﻿/* $Id$ */

/* vfprintf( FILE *, const char *, va_list )

   This file is part of the Public Dotest_vfprintf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>
#include <stdarg.h>
#include <stdint.h>
#include <limits.h>


#define NTD_FILEID "ntd_stdio_vfprintf.c"
#define NTD_FILEIO
#include <stddef.h>
#include "ntd_stdio_tests.h"

#include <unistd.h>
#if __NX__
static const char *tempfilename = "host:/ntd-test-vfprintf.txt";
#else
static const char *tempfilename = "ntd-test-vfprintf.txt";
#endif

static int testprintf( FILE * stream, const char * format, ... )
{
    int i;
    va_list arg;
    va_start( arg, format );
    i = vfprintf( stream, format, arg );
    va_end( arg );
    return i;
}

int ntd_stdio_vfprintf( void )
{
    FILE * target;
    if (!access(tempfilename, F_OK)) {
    	TESTCASE( remove( tempfilename ) == 0 );
    }

    TESTCASE( ( target = fopen( tempfilename, "wb+" ) ) != NULL );
    // TESTCASE( ( target = tmpfile() ) != NULL );
#include "ntd_printf_testcases.h"
    TESTCASE( fclose( target ) == 0 );
    return TEST_RESULTS;
}

