﻿/* $Id$ */

/* ungetc( int, FILE * )

   This file is part of the Public Dotest_ungetc C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>


#include "ntd_stdio_tests.h"
#include <stdlib.h>

static const char* hellostr = "Hello, world!";

#include <unistd.h>
#if __NX__
static const char *tempfilename = "host:/ntd-test-ungetc.txt";
#else
static const char *tempfilename = "ntd-test-ungetc.txt";
#endif

int ntd_stdio_ungetc( void )
{
    // Also see ftell() for some testing

    // PDCLIB-18: fread ignores ungetc
    size_t bufsz = strlen( hellostr ) + 1;
    char * buf = malloc( bufsz );
    FILE * fh;

    // Also fgets
    if (!access(tempfilename, F_OK)) {
    	TESTCASE( remove( tempfilename ) == 0 );
    }

    TESTCASE( ( fh = fopen( tempfilename, "wb+" ) ) != NULL );
    // TESTCASE( ( fh = tmpfile() ) != NULL );
    TESTCASE( fputs(hellostr, fh) == 0 );
    rewind(fh);
    TESTCASE( fgetc( fh ) == 'H' );
    TESTCASE( ungetc( 'H', fh ) == 'H' );
    TESTCASE( fgets( buf, bufsz, fh ) != NULL );
    TESTCASE( strcmp( buf, hellostr ) == 0 );

    // fread
    rewind(fh);
    TESTCASE( fgetc( fh ) == 'H' );
    TESTCASE( ungetc( 'H', fh ) == 'H' );
    TESTCASE( fread( buf, bufsz - 1, 1, fh ) == 1 );
    TESTCASE( strncmp( buf, hellostr, bufsz - 1 ) == 0 );

    free(buf);

    return TEST_RESULTS;
}

