﻿/* $Id$ */

/* snprintf( char *, size_t, const char *, ... )

   This file is part of the Public Dotest_snprintf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>
#include <stdarg.h>


#define NTD_FILEID "ntd_stdio_snprintf.c"
#define NTD_STRINGIO
#include <stdint.h>
#include <stddef.h>

#include "ntd_stdio_tests.h"

#define testprintf( s, ... ) snprintf( s, 100, __VA_ARGS__ )

int ntd_stdio_snprintf( void )
{
    char target[100];
#include "ntd_printf_testcases.h"
    TESTCASE( snprintf( NULL, 0, "foo" ) == 3 );
    TESTCASE( snprintf( NULL, 0, "%d", 100 ) == 3 );

    /*
      The test below is a regression in tests failed in the musl-libc-test
      testsuite on linux

      The failure is described in a Defect Report (located here:
      http://www.open-std.org/jtc1/sc22/wg14/www/docs/dr_151.html) suggesting
      that printf("%#.0o", 0) should print "0", but the "snprintf.c" test in
      musl-libc-test believes it should print ""
    */
    int count = snprintf(target, sizeof(target), "%#.0o", 0);
    TESTCASE_MESSAGE(count == 1 && strcmp(target, "0") == 0, "count = %d target = '%s'",
        count,
        target);
    count = snprintf(target, sizeof(target), "%.0o", 0);
    TESTCASE_MESSAGE(count == 0 && strcmp(target, "") == 0, "count = %d target = '%s'",
        count,
        target);

    return TEST_RESULTS;
}

