﻿/* $Id$ */

/* fscanf( FILE *, const char *, ... )

   This file is part of the Public Dotest_fscanf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>


#define NTD_FILEID "ntd_stdio_fscanf.c"
#define NTD_FILEIO

#include "ntd_stdio_tests.h"

#if __NX__
static const char *tempfilename = "host:/ntd-test-fscanf.txt";
#else
static const char *tempfilename = "ntd-test-fscanf.txt";
#endif

#define testscanf( stream, format, ... ) fscanf( stream, format, __VA_ARGS__ )

int ntd_stdio_fscanf( void )
{
    FILE * source;
    if (!access(tempfilename, F_OK)) {
    	TESTCASE( remove( tempfilename ) == 0 );
    }

    TESTCASE( ( source = fopen( tempfilename, "wb+" ) ) != NULL );
    // TESTCASE( ( source = tmpfile() ) != NULL );
#include "ntd_scanf_testcases.h"
    TESTCASE( fclose( source ) == 0 );
    return TEST_RESULTS;
}

