﻿/* $Id$ */

/* fgetpos( FILE * , fpos_t * )

   This file is part of the Public Dotest_fgetpos C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>

#if __NX__
static const char *tempfilename = "host:/ntd-test-fgetpos.txt";
#else
static const char *tempfilename = "ntd-test-fgetpos.txt";
#endif

#include "ntd_stdio_tests.h"
#include <string.h>

int ntd_stdio_fgetpos( void )
{
    FILE * fh;
    fpos_t pos1, pos2;
    TESTCASE( ( fh = fopen(tempfilename, "w+") ) != NULL );
    TESTCASE( fgetpos( fh, &pos1 ) == 0 );
    TESTCASE( fwrite( teststring, 1, strlen( teststring ), fh ) == strlen( teststring ) );
    TESTCASE( (size_t)ftell( fh ) == strlen( teststring ) );
    TESTCASE( fgetpos( fh, &pos2 ) == 0 );
    TESTCASE( fsetpos( fh, &pos1 ) == 0 );
    TESTCASE( ftell( fh ) == 0 );
    TESTCASE( fsetpos( fh, &pos2 ) == 0 );
    TESTCASE( (size_t)ftell( fh ) == strlen( teststring ) );
    TESTCASE( fclose( fh ) == 0 );
    return TEST_RESULTS;
}

