﻿/*******************************************************************************

  This file contains a series of tests for time()

*******************************************************************************/

#include "ntd_extended_test.h"
#include <time.h>
#include <stdio.h>
#include <unistd.h>


#define BAD_TIME_VALUE(val) TESTCASE_MESSAGE(val != -1, "current time is %d", val)

static void waste_time_using_sleep(unsigned int seconds)
{
  clock_t when_to_stop;
  clock_t current_time;

  when_to_stop = -1;
  do
  {
    current_time = clock();
    BAD_TIME_VALUE(current_time);
    if (current_time == -1) return;

    if (when_to_stop == -1)
      when_to_stop = current_time + (seconds * CLOCKS_PER_SEC);

  } while(current_time < when_to_stop);
}

static void test_time_passing()
{
  time_t time_val1;
  time_t time_val2;
  time_t time_diff;
  int seconds_to_sleep = 3;

  time(&time_val1);

  waste_time_using_sleep(seconds_to_sleep);

  time(&time_val2);

  BAD_TIME_VALUE(time_val1);
  BAD_TIME_VALUE(time_val2);
  if (time_val1 == -1 || time_val2 == -1) return;

  /* Since the accuracy of the exact amount of seconds the program slept can
     vary, simply check that the end time is greater than the beginning time */
  TESTCASE_MESSAGE(time_val2 > time_val1,
    "time_val2 %ld is <= time_val1 %ld",
    time_val2, time_val1);
}

void test_diff_return_methods()
{
  time_t val1;
  time_t val2;

  /* Time returns a value and also stores the value in the pointer that gets
     passed into it */
  val1 = time(&val2);

  BAD_TIME_VALUE(val1);
  BAD_TIME_VALUE(val2);
  if (val1 == -1 || val2 == -1) return;

  TESTCASE_MESSAGE(val1 == val2, "time(&val2) returned %ld but val2 = %ld",
    val1, val2);
}

void test_null_parameter()
{
  time_t val;

  val = time(NULL);

  BAD_TIME_VALUE(val);
}
/*------------------------------------------------------------------------}}}}*/




int ntd_extended_time(void)
{
  NTD_TEST_GROUP_START("time", 2);
  test_time_passing();
  test_diff_return_methods();
  test_null_parameter();
  return NTD_TEST_GROUP_END("time", 2);
}
