﻿/*******************************************************************************

  This file contains a series of tests for leak()

*******************************************************************************/

#include "ntd_extended_test.h"
#include "ntd_malloc_node.h"
#include <stdlib.h>

malloc_node * malloc_head = NULL;

#undef malloc
#undef calloc
#undef free
#undef realloc

static void new_malloc_node(void *p, const char *file, int line, const char *func)
{
    if (p == NULL) return;
    malloc_node * node = malloc(sizeof(malloc_node));
    if (node == NULL) return;
    node->mem = p;
    node->file = file;
    node->line = line;
    node->func = func;
    node->next = malloc_head;
    malloc_head = node;
}

static void release_or_replace_malloc_node(void *p, void *new, const char *file, int line, const char *func)
{
    malloc_node *node = malloc_head;
    malloc_node **prev = &malloc_head;
    if (p != NULL) {
        while (node) {
            if (node->mem == p) {
                if (new == NULL) {
                    *prev = node->next;
                    free(node);
                    return;
                }
                else
                {
                    node->mem = new;
                    return;
                }
            }
            prev = &node->next;
            node = node->next;
        }
#if PRINT_NOT_ALLOCATED_WARNING
        printf("%s, %i, %s No recorded allocation!!! %p\n", file, line, func, p);
#endif
    }
    new_malloc_node(new, file, line, func);
}

void* my_malloc(size_t size, const char *file, int line, const char *func)
{

    void *p = malloc(size);

#if PRINT_MALLOC_FREE_STAMP
    printf ("Allocated = %s, %i, %s, %p[%li]\n", file, line, func, p, (long) size);
#endif

    new_malloc_node(p, file, line, func);

    return p;
}

void ntd_test_register_allocation(void *p, const char *file, int line, const char *func)
{
    new_malloc_node(p, file, line, func);
}

void* my_calloc(size_t count, size_t size, const char *file, int line, const char *func)
{

    void *p = calloc(count, size);

#if PRINT_MALLOC_FREE_STAMP
    printf ("Callocated = %s, %i, %s, %p[%li*%li]\n", file, line, func, p, (long) count, (long) size);
#endif

    new_malloc_node(p, file, line, func);

    return p;
}

void* my_realloc(void *p, size_t size, const char *file, int line, const char *func)
{

    void *ret = realloc(p, size);

#if PRINT_MALLOC_FREE_STAMP
    printf ("Realloc = %s, %i, %s, %p->%p[%li]\n", file, line, func, p, ret, (long) size);
#endif

    release_or_replace_malloc_node(p, ret, file, line, func);
    return ret;
}

void* my_strdup(const char *str, const char *file, int line, const char *func)
{

    void *ret = (strdup)(str);

#if PRINT_MALLOC_FREE_STAMP
    printf ("strdup = %s, %i, %s, %p->%p\n", file, line, func, str, ret);
#endif

    new_malloc_node(ret, file, line, func);
    return ret;
}

void* my_strndup(const char *str, size_t n, const char *file, int line, const char *func)
{

    void *ret = (strndup)(str, n);

#if PRINT_MALLOC_FREE_STAMP
    printf ("strndup = %s, %i, %s, %p->%p\n", file, line, func, str, ret);
#endif

    new_malloc_node(ret, file, line, func);
    return ret;
}

void my_free(void * p, const char *file, int line, const char *func)
{

    free(p);

#if PRINT_MALLOC_FREE_STAMP
    if (p != NULL)
    {
        printf ("Free = %s, %i, %s, %p\n", file, line, func, p);
    }
#endif

    release_or_replace_malloc_node(p, NULL, file, line, func);
}

void ntd_test_ignore_allocation(void * p)
{
    release_or_replace_malloc_node(p, NULL, "", 0, "");
}

void leak_test()
{

    int result = 0;
    /* The main function for NTD-created tests */
    NTD_TEST_GROUP_START("memory_leak_test", 0);

    result = (malloc_head != NULL);

    NTD_TESTCASE_MESSAGE(malloc_head == NULL, __FILE__, __LINE__, "malloc_head != NULL",
        "memory leak test failed");

    for (malloc_node* malloc_remain = malloc_head; malloc_remain != NULL; malloc_remain = malloc_remain->next)
    {
        printf("Memory is not freed at %p\n  %s\n  line %d\n  %s()\n",
            malloc_remain->mem,
            malloc_remain->file,
            malloc_remain->line,
            malloc_remain->func);
    }

    NTD_TEST_GROUP_END("memory_leak_test", 0);
}
