﻿/*******************************************************************************

  This file contains a series of tests for chdir()

*******************************************************************************/
#include "ntd_extended_test.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>


static void test_chdir_append()
{
    FILE *file;
    char *fread_buffer;
    const char *filename;
    size_t count;
    int result;
    fread_buffer = NULL;
    char* cwd;
    char buff[PATH_MAX + 1];
    bool passed = false;

    /* 1) test directory 2 levels up */
    chdir(HOST_FILENAME("test1/test2/../../"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME(""))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME(""), cwd);

    filename = "chdir_append.txt";

    /* Write some data to the file */
    if (passed)
    {
        file = FOPEN_TEST(filename, "w");
        count = fwrite("abc", sizeof(char), 3, file);
        TESTCASE_MESSAGE(count == 3, "fwrite(\"abc\", 1, 3, file) failed count = %d", count);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        file = NULL;

        /* Try to append data to the file */
        file = FOPEN_TEST(filename, "a");
        count = fwrite("def", sizeof(char), 3, file);
        TESTCASE_MESSAGE(count == 3, "fwrite(\"def\", 1, 3, file) failed count = %d", count);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        file = NULL;

        file = FOPEN_TEST(filename, "r");
        if (file) {
            FREAD_FILE_TEST(&fread_buffer, file);

            TESTCASE_STRINGS_MATCH(fread_buffer, "abcdef");

            free(fread_buffer);
            result = FCLOSE_DELETE_TEST(file, filename);
        }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../\"failed, cwd is %s. Tests not run\n", cwd);

    /* 2) test directory level up*/
    chdir(HOST_FILENAME("test1/test2/../"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1/"), cwd);

    /* Write some data to the file */
    if (passed)
    {
         file = FOPEN_TEST(filename, "w");
         count = fwrite("abc", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"abc\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         /* Try to append data to the file */
         file = FOPEN_TEST(filename, "a");
         count = fwrite("def", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"def\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         file = FOPEN_TEST(filename, "r");
         if (file) {
             FREAD_FILE_TEST(&fread_buffer, file);

             TESTCASE_STRINGS_MATCH(fread_buffer, "abcdef");

             free(fread_buffer);
             result = FCLOSE_DELETE_TEST(file, filename);
         }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../\"failed, cwd is %s. Tests not run\n", cwd);

    /* 3) test ../ in the middle */
    chdir(HOST_FILENAME("test1/../test2/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test2/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test2/"), cwd);

    /* Write some data to the file */
    if (passed)
    {
         file = FOPEN_TEST(filename, "w");
         count = fwrite("abc", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"abc\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         /* Try to append data to the file */
         file = FOPEN_TEST(filename, "a");
         count = fwrite("def", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"def\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         file = FOPEN_TEST(filename, "r");
         if (file) {
             FREAD_FILE_TEST(&fread_buffer, file);

             TESTCASE_STRINGS_MATCH(fread_buffer, "abcdef");

             free(fread_buffer);
             result = FCLOSE_DELETE_TEST(file, filename);
         }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/../test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 4) test ../ in the middle */
    chdir(HOST_FILENAME("test1/test2/../../test2/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test2/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test2"), cwd);

    /* Write some data to the file */
    if (passed)
    {
         file = FOPEN_TEST(filename, "w");
         count = fwrite("abc", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"abc\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         /* Try to append data to the file */
         file = FOPEN_TEST(filename, "a");
         count = fwrite("def", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"def\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         file = FOPEN_TEST(filename, "r");
         if (file) {
             FREAD_FILE_TEST(&fread_buffer, file);

             TESTCASE_STRINGS_MATCH(fread_buffer, "abcdef");

             free(fread_buffer);
             result = FCLOSE_DELETE_TEST(file, filename);
         }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 5) test ../ in the middle */
    chdir(HOST_FILENAME("test1/test2/../../test2/../test1/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1"), cwd);

    /* Write some data to the file */
    if (passed)
    {
         file = FOPEN_TEST(filename, "w");
         count = fwrite("abc", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"abc\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         /* Try to append data to the file */
         file = FOPEN_TEST(filename, "a");
         count = fwrite("def", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"def\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         file = FOPEN_TEST(filename, "r");
         if (file) {
             FREAD_FILE_TEST(&fread_buffer, file);

             TESTCASE_STRINGS_MATCH(fread_buffer, "abcdef");

             free(fread_buffer);
             result = FCLOSE_DELETE_TEST(file, filename);
         }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../test2/../test1/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 6) test 2 directory levels */
    chdir(HOST_FILENAME("test1/test2/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/test2/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1/test2/"), cwd);

    /* Write some data to the file */
    if (passed)
    {
         file = FOPEN_TEST(filename, "w");
         count = fwrite("abc", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"abc\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         /* Try to append data to the file */
         file = FOPEN_TEST(filename, "a");
         count = fwrite("def", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"def\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         file = FOPEN_TEST(filename, "r");
         if (file) {
             FREAD_FILE_TEST(&fread_buffer, file);

             TESTCASE_STRINGS_MATCH(fread_buffer, "abcdef");

             free(fread_buffer);
             result = FCLOSE_DELETE_TEST(file, filename);
         }
    }
    else
         TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 7) test 1 directory level*/
    chdir(HOST_FILENAME("test1/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1/"), cwd);

    /* Write some data to the file */
    if (passed)
    {
         file = FOPEN_TEST(filename, "w");
         count = fwrite("abc", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"abc\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         /* Try to append data to the file */
         file = FOPEN_TEST(filename, "a");
         count = fwrite("def", sizeof(char), 3, file);
         TESTCASE_MESSAGE(count == 3, "fwrite(\"def\", 1, 3, file) failed count = %d", count);
         result = fclose(file);
         TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
         file = NULL;

         file = FOPEN_TEST(filename, "r");
         if (file) {
             FREAD_FILE_TEST(&fread_buffer, file);

             TESTCASE_STRINGS_MATCH(fread_buffer, "abcdef");

             free(fread_buffer);
             result = FCLOSE_DELETE_TEST(file, filename);
         }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/\"failed, cwd is %s. Tests not run\n", cwd);

}

static void test_chdir_remove()
{
    FILE *file;
    char *fread_buffer;
    const char *filename;
    size_t count;
    int result;
    fread_buffer = NULL;
    char* cwd;
    char buff[PATH_MAX + 1];
    bool passed = false;

    /* 1) test directory 2 levels up*/
    chdir(HOST_FILENAME("test1/test2/../.."));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME(""))==0), "chdir failed. Expect %s Actual %s\n", "", cwd);

    filename = "chdir_remove.txt";

    if (passed)
    {
        file = FOPEN_TEST(filename, "w");
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        remove(filename);
        TESTCASE_MESSAGE(access(HOST_FILENAME("chdir_remove.txt"), F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_FILENAME("chdir_remove.txt"));
        TESTCASE_MESSAGE(access("chdir_remove.txt", F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_FILENAME("chdir_remove.txt"));
        file = NULL;
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../\"failed, cwd is %s. Tests not run\n", cwd);

    /* 2) test directory level up */
    chdir(HOST_FILENAME("test1/test2/.."));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1/"), cwd);

    if (passed)
    {
        file = FOPEN_TEST(filename, "w");
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        remove(filename);
        TESTCASE_MESSAGE(access(HOST_DIR_FILENAME("test1/test2/..", "chdir_remove.txt"), F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test1/","chdir_remove.txt"));
        TESTCASE_MESSAGE(access("chdir_remove.txt", F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test1/","chdir_remove.txt"));
        file = NULL;
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../\"failed, cwd is %s. Tests not run\n", cwd);

    /* 3) test ../ in the middle */
    chdir(HOST_FILENAME("test1/../test2"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test2/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test2/"), cwd);

    if (passed)
    {
        file = FOPEN_TEST(filename, "w");
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        remove(filename);
        TESTCASE_MESSAGE(access(HOST_DIR_FILENAME("test2/", "chdir_remove.txt"), F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_FILENAME("chdir_remove.txt"));
        TESTCASE_MESSAGE(access("chdir_remove.txt", F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_FILENAME("chdir_remove.txt"));
        file = NULL;
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/../test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 4) test ../ in the middle */
    chdir(HOST_FILENAME("test1/test2/../../test2"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test2/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test2"), cwd);

    if (passed)
    {
        file = FOPEN_TEST(filename, "w");
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        remove(filename);
        TESTCASE_MESSAGE(access(HOST_DIR_FILENAME("test2/", "chdir_remove.txt"), F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test2/","chdir_remove.txt"));
        TESTCASE_MESSAGE(access("chdir_remove.txt", F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test2/","chdir_remove.txt"));
        file = NULL;
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 5) test ../ in the middle */
    chdir(HOST_FILENAME("test1/test2/../../test2/../test1"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1"), cwd);

    if (passed)
    {
        file = FOPEN_TEST(filename, "w");
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        remove(filename);
        TESTCASE_MESSAGE(access(HOST_DIR_FILENAME("test1/", "chdir_remove.txt"), F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test1/","chdir_remove.txt"));
        TESTCASE_MESSAGE(access("chdir_remove.txt", F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test1/","chdir_remove.txt"));
        file = NULL;
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../test2/../test1/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 6) test 2 directory levels */
    chdir(HOST_FILENAME("test1/test2"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/test2/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1/test2/"), cwd);

    if (passed)
    {
        file = FOPEN_TEST(filename, "w");
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        remove(filename);
        TESTCASE_MESSAGE(access(HOST_DIR_FILENAME("test1/test2/", "chdir_remove.txt"), F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test1/test2/","chdir_remove.txt"));
        TESTCASE_MESSAGE(access("chdir_remove.txt", F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test1/test2/","chdir_remove.txt"));
        file = NULL;
    }
    else
         TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 7) test 1 directory level*/
    chdir(HOST_FILENAME("test1"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1/"), cwd);

    if (passed)
    {
        file = FOPEN_TEST(filename, "w");
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);
        remove(filename);
        TESTCASE_MESSAGE(access(HOST_DIR_FILENAME("test1/", "chdir_remove.txt"), F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test1/", "chdir_remove.txt"));
        TESTCASE_MESSAGE(access("chdir_remove.txt", F_OK) != 0,
            "chdir remove failed. %s is not removed\n",
            HOST_DIR_FILENAME("test1/", "chdir_remove.txt"));
        file = NULL;
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/\"failed, cwd is %s. Tests not run\n", cwd);
}

static void test_chdir_rename()
{
    FILE *file;
    int rename_ret_val; /* Return value from rename() */
    const char *filename;
    const char *new_filename;
    const char *fwrite_text = "text written to file";
    char *fread_buffer;
    filename = "chdir_rename_before.txt";
    new_filename = "chdir_rename_after.txt";
    char* cwd;
    char buff[PATH_MAX + 1];
    size_t count;
    int result = 0;
    bool passed = false;

    /* 1) test directory 2 levels up*/
    chdir(HOST_FILENAME("/test1/test2/../.."));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME(""))==0), "chdir failed. Expect %s Actual %s\n", "", cwd);

    if (passed)
    {
        file = fopen(filename, "w");
        TESTCASE_MESSAGE(file != NULL, "fopen(%p) failed result = %d", file, result);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);

        if (file)
        {
            rename_ret_val = rename(filename, new_filename);
            TESTCASE_MESSAGE(rename_ret_val == 0, "rename(\"%s\", \"%s\") returned %d expected 0",
                filename, new_filename, rename_ret_val);
        }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../\"failed, cwd is %s. Tests not run\n", cwd);

    /* 2) test directory level up */
    chdir(HOST_FILENAME("/test1/test2/.."));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1/"), cwd);

    if (passed)
    {
        file = fopen(filename, "w");
        TESTCASE_MESSAGE(file != NULL, "fopen(%p) failed result = %d", file, result);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);

        if (file)
        {
            rename_ret_val = rename(filename, new_filename);
            TESTCASE_MESSAGE(rename_ret_val == 0, "rename(\"%s\", \"%s\") returned %d expected 0",
                filename, new_filename, rename_ret_val);
        }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../\"failed, cwd is %s. Tests not run\n", cwd);

    /* 3) test ../ in the middle */
    chdir(HOST_FILENAME("/test1/../test2"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test2/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test2/"), cwd);

    if (passed)
    {
        file = fopen(filename, "w");
        TESTCASE_MESSAGE(file != NULL, "fopen(%p) failed result = %d", file, result);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);

        if (file)
        {
            rename_ret_val = rename(filename, new_filename);
            TESTCASE_MESSAGE(rename_ret_val == 0, "rename(\"%s\", \"%s\") returned %d expected 0",
                filename, new_filename, rename_ret_val);
        }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/../test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 4) test ../ in the middle */
    chdir(HOST_FILENAME("/test1/test2/../../test3/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test3/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test3"), cwd);

    if (passed)
    {
        file = fopen(filename, "w");
        TESTCASE_MESSAGE(file != NULL, "fopen(%p) failed result = %d", file, result);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);

        if (file)
        {
            rename_ret_val = rename(filename, new_filename);
            TESTCASE_MESSAGE(rename_ret_val == 0, "rename(\"%s\", \"%s\") returned %d expected 0",
                filename, new_filename, rename_ret_val);
        }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 5) test ../ in the middle */
    chdir(HOST_FILENAME("/test1/test2/../../test2/../test4/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test4/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test4"), cwd);

    if (passed)
    {
        file = fopen(filename, "w");
        TESTCASE_MESSAGE(file != NULL, "fopen(%p) failed result = %d", file, result);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);

        if (file)
        {
            rename_ret_val = rename(filename, new_filename);
            TESTCASE_MESSAGE(rename_ret_val == 0, "rename(\"%s\", \"%s\") returned %d expected 0",
                filename, new_filename, rename_ret_val);
        }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/../../test2/../test1/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 6) test 2 directory levels */
    chdir(HOST_FILENAME("/test1/test2/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test1/test2/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test1/test2/"), cwd);

    if (passed)
    {
        file = fopen(filename, "w");
        TESTCASE_MESSAGE(file != NULL, "fopen(%p) failed result = %d", file, result);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);

        if (file)
        {
            rename_ret_val = rename(filename, new_filename);
            TESTCASE_MESSAGE(rename_ret_val == 0, "rename(\"%s\", \"%s\") returned %d expected 0",
                filename, new_filename, rename_ret_val);
        }
    }
    else
         TESTCASE_MESSAGE(passed == true, "chdir to \"test1/test2/\"failed, cwd is %s. Tests not run\n", cwd);

    /* 7) test 1 directory level*/
    chdir(HOST_FILENAME("/test5/"));

    cwd = getcwd( buff, PATH_MAX + 1 );
    passed = TESTCASE_MESSAGE((strcmp(cwd,HOST_FILENAME("test5/"))==0), "chdir failed. Expect %s Actual %s\n", HOST_FILENAME("test5/"), cwd);

    if (passed)
    {
        file = fopen(filename, "w");
        TESTCASE_MESSAGE(file != NULL, "fopen(%p) failed result = %d", file, result);
        result = fclose(file);
        TESTCASE_MESSAGE(result == 0, "fclose(%p) failed result = %d", file, result);

        if (file)
        {
            rename_ret_val = rename(filename, new_filename);
            TESTCASE_MESSAGE(rename_ret_val == 0, "rename(\"%s\", \"%s\") returned %d expected 0",
                filename, new_filename, rename_ret_val);
        }
    }
    else
        TESTCASE_MESSAGE(passed == true, "chdir to \"test1/\"failed, cwd is %s. Tests not run\n", cwd);
}

int ntd_extended_chdir(void)
{
    FILE *file;
    #if __horizon__
    const char *filename = HOST_FILENAME("long_term_file.txt");
    #else
    const char *filename = "long_term_file.txt";
    #endif

    bool files_deleted = false;

    NTD_TEST_GROUP_START("chdir", 2);

    file = fopen(filename, "w");

    mkdir(HOST_FILENAME("test1"), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
    mkdir(HOST_FILENAME("test1/test2"), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
    mkdir(HOST_FILENAME("test2"), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
    mkdir(HOST_FILENAME("test3"), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
    mkdir(HOST_FILENAME("test4"), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
    mkdir(HOST_FILENAME("test5"), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);

    if (file != NULL) {

        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/test2/../../", "chdir_append.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/", "chdir_append.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/", "chdir_append.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/", "chdir_append.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/", "chdir_append.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/test2", "chdir_append.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/", "chdir_append.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/test2/../../", "chdir_remove.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/test2/..", "chdir_remove.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/../test2", "chdir_remove.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/test2/../../test2/", "chdir_remove.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/test2/../../test2/../test1/", "chdir_remove.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/test2/", "chdir_remove.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("test1/", "chdir_remove.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/../../","chdir_rename_before.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/../../","chdir_rename_after.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/../","chdir_rename_before.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/../","chdir_rename_after.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/../test2/","chdir_rename_before.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/../test2/","chdir_rename_after.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/../../test3/","chdir_rename_before.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/../../test3/","chdir_rename_after.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/../../test2/../test4/","chdir_rename_before.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/../../test2/../test4/","chdir_rename_after.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/","chdir_rename_before.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test1/test2/","chdir_rename_after.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test5/","chdir_rename_before.txt"));
        DELETE_IF_EXISTS(HOST_DIR_FILENAME("/test5/","chdir_rename_after.txt"));

        files_deleted = true;
    }

    if (files_deleted == true)
    {
        test_chdir_append();
        test_chdir_remove();
        test_chdir_rename();
    }

    FCLOSE_DELETE_TEST(file, filename);

    return NTD_TEST_GROUP_END("chdir", 2);
}
