﻿#include "ntd-test-libc.h"
#include <stdint.h>
#include <stdio.h>
#include "mtest.h"

static struct l_l t[] = {
#if LDBL_MANT_DIG == 53
#include "crlibm/tan.h"
#include "ucb/tan.h"
#include "sanity/tan.h"
#include "special/tan.h"

#elif LDBL_MANT_DIG == 64
#include "sanity/tanl.h"
#include "special/tanl.h"

#endif
};

int testtanl(void)
{
    #pragma STDC FENV_ACCESS ON
    long double y;
    float d;
    int e, i, err = 0;
    struct l_l *p;

    for (i = 0; i < sizeof t/sizeof *t; i++) {
        p = t + i;

        if (p->r < 0)
            continue;
        fesetround(p->r);
        feclearexcept(FE_ALL_EXCEPT);
        y = tanl(p->x);
        e = fetestexcept(INEXACT|INVALID|DIVBYZERO|UNDERFLOW|OVERFLOW);

        int passed = t_checkexcept(e, p->e, p->r);
        char *msg = NULL;
        asprintf(&msg, "bad fp exception: %s tanl(%La)=%La, %s",
                rstr(p->r), p->x, p->y, ESTRS(e, p));
        if (p->expect_failure) {
            NTD_TESTCASE_KNOWN_FAILURE(p->fail_msg, passed, p->file, p->line, msg);
        } else {
            if (!passed) err++;
            NTD_TESTCASE(passed, p->file, p->line, msg);
        }
        free(msg);
        d = ulperrl(y, p->y, p->dy);
        if (!checkulp(d, p->r)) {
            printf("%s:%d: %s tanl(%La) want %La got %La ulperr %.3f = %a + %a\n",
                short_path(p->file), p->line, rstr(p->r), p->x, p->y, y, d, d-p->dy, p->dy);
            err++;
        }
    }
    return !!err;
}
