﻿// log2.testdata
//  copyright (C) 2005 Ch. Q. Lauter, F.de Dinechin and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Very worst case
T(RN,    0x1.b4ebe40c95a01p+0,    0x1.8adeac981e00ep-1,          0x1p-1, INEXACT) // 1.706724408218747379706314859504e+00
// undocumented values, probably by Christoph
T(RN,  0x1.cea1f96f699f5p-809,   -0x1.9412b93076276p+9,   0x1.830ab4p-2, INEXACT)
T(RN,  0x1.597a1eba0d538p-145,   -0x1.212296708397fp+7,   0x1.a7cb92p-2, INEXACT)
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RZ,    0x1.245db892bd6e5p-1,   -0x1.9de261c7c8623p-1,  0x1.30b104p-51, INEXACT) // 5.710275344015057763513709687686e-01
T(RN,    0x1.255a2a884ee79p-1,   -0x1.9b65a7b6f1152p-1,         -0x1p-1, INEXACT) // 5.729535380737181826660275874019e-01
T(RZ,    0x1.78c5a435dadb6p+0,    0x1.1d76f15181bedp-1, -0x1.2a29cap-51, INEXACT) // 1.471765769146128999267375547788e+00
T(RN,    0x1.e976593d80c0bp+0,    0x1.debf63860d0f5p-1,         -0x1p-1, INEXACT) // 1.911962106242529157995591049257e+00
T(RZ,    0x1.78c5a435dadb6p+0,    0x1.1d76f15181bedp-1, -0x1.2a29cap-51, INEXACT) // 1.471765769146128999267375547788e+00
T(RN,    0x1.e976593d80c0bp+0,    0x1.debf63860d0f5p-1,         -0x1p-1, INEXACT) // 1.911962106242529157995591049257e+00
T(RN,    0x1.81343fe42de87p+1,    0x1.96e81cad230dap+0,          0x1p-1, INEXACT) // 3.009407030502021296314296705532e+00
T(RZ,    0x1.89d948a94fe17p+1,    0x1.9f1a7d355cb4fp+0, -0x1.8c0d88p-53, INEXACT) // 3.076943476364032203917986407760e+00
T(RZ,    0x1.e5053b714d76fp+1,    0x1.ec01c07d5c8b9p+0,         -0x1p+0, INEXACT) // 3.789222173999341247707661750610e+00
T(RN,    0x1.f234a059adbaep+1,    0x1.f5e9b529cd31fp+0,         -0x1p-1, INEXACT) // 3.892231029308695688939678802853e+00
T(RZ,    0x1.1ba39ff28e3eap+2,    0x1.12eecf76d63cdp+1,  -0x1.2ae91p-55, INEXACT) // 4.431861864920373150766863545869e+00
T(RN,    0x1.cc7c6af92f393p+2,    0x1.6c6af049a8626p+1,         -0x1p-1, INEXACT) // 7.195093863815503532066486513941e+00
T(RN,    0x1.c526ccd9628c9p+4,    0x1.34b9f4ba3a37bp+2,         -0x1p-1, INEXACT) // 2.832197270313261938667892536614e+01
// Bad cases generated by tests/crlibm_generate_test_vectors log2 20 0
T(RN,  0x1.10cb4b87cf7a6p-879,   -0x1.b7744432d6c08p+9,  -0x1.fffff4p-2, INEXACT) // 2.643801551037429843074164038041e-265
T(RD,  0x1.7a6f1bfecd5c9p+368,    0x1.70905b9e3c97bp+8,  -0x1.fffffep-1, INEXACT) // 8.887684129119792667225814638419e+110
T(RU,  0x1.7a6f1bfecd5c9p+368,    0x1.70905b9e3c97cp+8,  0x1.e94688p-25, INEXACT) // 8.887684129119792667225814638419e+110
T(RZ,  0x1.7a6f1bfecd5c9p+368,    0x1.70905b9e3c97bp+8,  -0x1.fffffep-1, INEXACT) // 8.887684129119792667225814638419e+110
T(RD,  0x1.15ee1d3361233p+281,    0x1.191e5b28413b6p+8,  -0x1.fffffap-1, INEXACT) // 4.218173622828684580644850825746e+84
T(RU,  0x1.15ee1d3361233p+281,    0x1.191e5b28413b7p+8,   0x1.8b347p-23, INEXACT) // 4.218173622828684580644850825746e+84
T(RZ,  0x1.15ee1d3361233p+281,    0x1.191e5b28413b6p+8,  -0x1.fffffap-1, INEXACT) // 4.218173622828684580644850825746e+84
T(RD,  0x1.26e0e3075ae29p-876,   -0x1.b5e5e417d3827p+9,  -0x1.fffffcp-1, INEXACT) // 2.286266690475151143991963502995e-264
T(RU,  0x1.26e0e3075ae29p-876,   -0x1.b5e5e417d3826p+9,  0x1.0b03b4p-23, INEXACT) // 2.286266690475151143991963502995e-264
T(RZ,  0x1.26e0e3075ae29p-876,   -0x1.b5e5e417d3826p+9,  0x1.0b03b4p-23, INEXACT) // 2.286266690475151143991963502995e-264
T(RN,  0x1.be0a20acb57bdp-675,   -0x1.511977eb4031cp+9,   0x1.fffff6p-2, INEXACT) // 1.111440815285384282718728797629e-203
T(RN,  0x1.1103297293081p-129,   -0x1.01d07994bd16dp+7,  -0x1.fffff2p-2, INEXACT) // 1.567014045546800414877544229906e-39
T(RD,   0x1.d4a08bf9624d3p+67,    0x1.0f7d3b57a4285p+6, -0x1.79311ep-23, INEXACT) // 2.701451512738905784320000000000e+20
T(RU,   0x1.d4a08bf9624d3p+67,    0x1.0f7d3b57a4286p+6,   0x1.fffffap-1, INEXACT) // 2.701451512738905784320000000000e+20
T(RZ,   0x1.d4a08bf9624d3p+67,    0x1.0f7d3b57a4285p+6, -0x1.79311ep-23, INEXACT) // 2.701451512738905784320000000000e+20
T(RN,  0x1.012a54c079407p+439,    0x1.b701ad6c90591p+8,  -0x1.fffff4p-2, INEXACT) // 1.426069176313182772187271319520e+132
T(RN,  0x1.4e55b2fdb5c73p+844,    0x1.a6314c94a6f59p+9,    0x1.fffffp-2, INEXACT) // 1.531996982085165638097754215497e+254
T(RD,  0x1.ed53b71e03807p-981,   -0x1.ea06dc5964ab1p+9,  -0x1.fffffap-1, INEXACT) // 9.429077056757101977465712614647e-296
T(RU,  0x1.ed53b71e03807p-981,    -0x1.ea06dc5964abp+9,  0x1.8350bcp-23, INEXACT) // 9.429077056757101977465712614647e-296
T(RZ,  0x1.ed53b71e03807p-981,    -0x1.ea06dc5964abp+9,  0x1.8350bcp-23, INEXACT) // 9.429077056757101977465712614647e-296
T(RN,  0x1.eff2c505499a5p-553,     -0x1.1405e1d2438p+9,  -0x1.fffffap-2, INEXACT) // 6.570657878503617244711645063844e-167
T(RD,  0x1.fca315258ba75p+269,    0x1.0dfd90ee4e056p+8, -0x1.de441ep-26, INEXACT) // 1.884676662073399280746701696404e+81
T(RU,  0x1.fca315258ba75p+269,    0x1.0dfd90ee4e057p+8,          0x1p+0, INEXACT) // 1.884676662073399280746701696404e+81
T(RZ,  0x1.fca315258ba75p+269,    0x1.0dfd90ee4e056p+8, -0x1.de441ep-26, INEXACT) // 1.884676662073399280746701696404e+81
T(RD,  0x1.65ac4f0eee743p-322,   -0x1.41847b074b379p+8,  -0x1.fffffcp-1, INEXACT) // 1.635263288664831019205260390331e-97
T(RU,  0x1.65ac4f0eee743p-322,   -0x1.41847b074b378p+8,  0x1.f199dcp-24, INEXACT) // 1.635263288664831019205260390331e-97
T(RZ,  0x1.65ac4f0eee743p-322,   -0x1.41847b074b378p+8,  0x1.f199dcp-24, INEXACT) // 1.635263288664831019205260390331e-97
T(RD,  0x1.94828164a9ff6p+865,    0x1.b0d47be3a1f5dp+9,  -0x1.fffffap-1, INEXACT) // 3.887185961531632529594287186679e+260
T(RU,  0x1.94828164a9ff6p+865,    0x1.b0d47be3a1f5ep+9,  0x1.5c6312p-23, INEXACT) // 3.887185961531632529594287186679e+260
T(RZ,  0x1.94828164a9ff6p+865,    0x1.b0d47be3a1f5dp+9,  -0x1.fffffap-1, INEXACT) // 3.887185961531632529594287186679e+260
T(RD,  0x1.66b1d2155edc9p-235,   -0x1.d506dac1e25d1p+7,  -0x1.a12a4p-23, INEXACT) // 2.537674447183112733959038891510e-71
T(RU,  0x1.66b1d2155edc9p-235,    -0x1.d506dac1e25dp+7,   0x1.fffffap-1, INEXACT) // 2.537674447183112733959038891510e-71
T(RZ,  0x1.66b1d2155edc9p-235,    -0x1.d506dac1e25dp+7,   0x1.fffffap-1, INEXACT) // 2.537674447183112733959038891510e-71
T(RD,  0x1.f323a8ebdceadp+433,    0x1.b1f69abe015c9p+8, -0x1.144ae8p-23, INEXACT) // 4.324838749857688034094225538390e+130
T(RU,  0x1.f323a8ebdceadp+433,    0x1.b1f69abe015cap+8,   0x1.fffffcp-1, INEXACT) // 4.324838749857688034094225538390e+130
T(RZ,  0x1.f323a8ebdceadp+433,    0x1.b1f69abe015c9p+8, -0x1.144ae8p-23, INEXACT) // 4.324838749857688034094225538390e+130
T(RD,  0x1.a077755c2dd7cp-760,   -0x1.7ba622fe21746p+9,  -0x1.fffffcp-1, INEXACT) // 2.682523550533640765089171433109e-229
T(RU,  0x1.a077755c2dd7cp-760,   -0x1.7ba622fe21745p+9,  0x1.e59ca8p-24, INEXACT) // 2.682523550533640765089171433109e-229
T(RZ,  0x1.a077755c2dd7cp-760,   -0x1.7ba622fe21745p+9,  0x1.e59ca8p-24, INEXACT) // 2.682523550533640765089171433109e-229
T(RD,  0x1.7ca1577de5e65p-424,   -0x1.a76d8142e5c7bp+8, -0x1.e52132p-23, INEXACT) // 3.431983280192438031316666451158e-128
T(RU,  0x1.7ca1577de5e65p-424,   -0x1.a76d8142e5c7ap+8,   0x1.fffff8p-1, INEXACT) // 3.431983280192438031316666451158e-128
T(RZ,  0x1.7ca1577de5e65p-424,   -0x1.a76d8142e5c7ap+8,   0x1.fffff8p-1, INEXACT) // 3.431983280192438031316666451158e-128
T(RN,  0x1.d3b9cc878d409p+312,    0x1.38de98ce427cfp+8,  -0x1.fffff6p-2, INEXACT) // 1.524438776092007499136584606109e+94
T(RN,  0x1.230280e99e90ap-775,   -0x1.8368546a82ddcp+9,  -0x1.fffffep-2, INEXACT) // 5.720328623925579169824604807282e-234
T(RD,  0x1.ed608ba861707p+656,    0x1.48792874083a8p+9, -0x1.06c33ap-23, INEXACT) // 5.762569887530403124504731745369e+197
T(RU,  0x1.ed608ba861707p+656,    0x1.48792874083a9p+9,   0x1.fffffcp-1, INEXACT) // 5.762569887530403124504731745369e+197
T(RZ,  0x1.ed608ba861707p+656,    0x1.48792874083a8p+9, -0x1.06c33ap-23, INEXACT) // 5.762569887530403124504731745369e+197
T(RN,  0x1.cdc95123ec32bp-767,   -0x1.7f130fbfec60fp+9,  -0x1.fffff2p-2, INEXACT) // 2.323777238909358066020054974403e-231
T(RD,  0x1.dec0e459a710bp-818,   -0x1.988c65ef7a1dfp+9, -0x1.3aaa7ap-23, INEXACT) // 1.069881133910348763662207785421e-246
T(RU,  0x1.dec0e459a710bp-818,   -0x1.988c65ef7a1dep+9,   0x1.fffffcp-1, INEXACT) // 1.069881133910348763662207785421e-246
T(RZ,  0x1.dec0e459a710bp-818,   -0x1.988c65ef7a1dep+9,   0x1.fffffcp-1, INEXACT) // 1.069881133910348763662207785421e-246
T(RD,  0x1.dffc5b12bd01bp-990,   -0x1.ee8bec6936d8ap+9,  -0x1.fffffap-1, INEXACT) // 1.791813006251496280519077165188e-298
T(RU,  0x1.dffc5b12bd01bp-990,   -0x1.ee8bec6936d89p+9,  0x1.4210fep-23, INEXACT) // 1.791813006251496280519077165188e-298
T(RZ,  0x1.dffc5b12bd01bp-990,   -0x1.ee8bec6936d89p+9,  0x1.4210fep-23, INEXACT) // 1.791813006251496280519077165188e-298
T(RN,  0x1.76cf5953c50f1p+715,    0x1.65c666e82845ep+9,  -0x1.fffffap-2, INEXACT) // 2.523585676661139113192316944600e+215
T(RD,  0x1.5c48ad1408a31p-966,    -0x1.e2c72713f405p+9,  -0x1.fffffap-1, INEXACT) // 2.181311108037780118613049746973e-291
T(RU,  0x1.5c48ad1408a31p-966,   -0x1.e2c72713f404fp+9,   0x1.b9f8fp-23, INEXACT) // 2.181311108037780118613049746973e-291
T(RZ,  0x1.5c48ad1408a31p-966,   -0x1.e2c72713f404fp+9,   0x1.b9f8fp-23, INEXACT) // 2.181311108037780118613049746973e-291
T(RN,  0x1.b7a4486dd9bfbp+401,    0x1.91c7ba2c3b3efp+8,  -0x1.fffff4p-2, INEXACT) // 8.869256282502346185155268894965e+120
T(RD,  0x1.6e6ec6815fc1bp+127,    0x1.fe11d27cc3671p+6,  -0x1.fffffap-1, INEXACT) // 2.435363126394438788227448098994e+38
T(RU,  0x1.6e6ec6815fc1bp+127,    0x1.fe11d27cc3672p+6,  0x1.a3f8fep-23, INEXACT) // 2.435363126394438788227448098994e+38
T(RZ,  0x1.6e6ec6815fc1bp+127,    0x1.fe11d27cc3671p+6,  -0x1.fffffap-1, INEXACT) // 2.435363126394438788227448098994e+38
T(RN,  0x1.3299c05da4f9ep+239,    0x1.de853b1e9040ep+7,  -0x1.fffff4p-2, INEXACT) // 1.058039756220537108798054989787e+72
T(RD,  0x1.4503499b5b6b4p-527,   -0x1.0753ec3e66a88p+9,  -0x1.fffffep-1, INEXACT) // 2.889700552127225422286329206577e-159
T(RU,  0x1.4503499b5b6b4p-527,   -0x1.0753ec3e66a87p+9,  0x1.6a8f2cp-25, INEXACT) // 2.889700552127225422286329206577e-159
T(RZ,  0x1.4503499b5b6b4p-527,   -0x1.0753ec3e66a87p+9,  0x1.6a8f2cp-25, INEXACT) // 2.889700552127225422286329206577e-159
T(RN,  0x1.a2fb2846a526cp+476,    0x1.dcb5f32449306p+8,  -0x1.fffffcp-2, INEXACT) // 3.193246067969045780324366598145e+143
T(RN,  0x1.7fad0fdb60d7bp+705,    0x1.60cab8264d13bp+9,   0x1.fffffep-2, INEXACT) // 2.522735030298326577516068306398e+212
T(RD,  0x1.235930a2bdb1bp+771,    0x1.8197e28f6b534p+9,  -0x1.fffffap-1, INEXACT) // 1.413511436360484928395765008690e+232
T(RU,  0x1.235930a2bdb1bp+771,    0x1.8197e28f6b535p+9,   0x1.bac91p-23, INEXACT) // 1.413511436360484928395765008690e+232
T(RZ,  0x1.235930a2bdb1bp+771,    0x1.8197e28f6b534p+9,  -0x1.fffffap-1, INEXACT) // 1.413511436360484928395765008690e+232
T(RN,   0x1.9e77cb6a2a1fp+990,    0x1.ef58f995bc088p+9,   0x1.fffffcp-2, INEXACT) // 1.694129841877631008808501506737e+298
T(RN,  0x1.086e20b31cc58p+329,    0x1.490bf75a9198bp+8,   0x1.fffffep-2, INEXACT) // 1.129638900357372248055885416725e+99
T(RN,   0x1.421ed0fb18676p+63,    0x1.faa6d27680211p+5,   0x1.fffff2p-2, INEXACT) // 1.160560965318945587200000000000e+19
T(RD,  0x1.0a8396bca7c94p-807,   -0x1.9378913d91e66p+9,  -0x1.fffffcp-1, INEXACT) // 1.219757766334606437384523244891e-243
T(RU,  0x1.0a8396bca7c94p-807,   -0x1.9378913d91e65p+9,  0x1.332fe2p-23, INEXACT) // 1.219757766334606437384523244891e-243
T(RZ,  0x1.0a8396bca7c94p-807,   -0x1.9378913d91e65p+9,  0x1.332fe2p-23, INEXACT) // 1.219757766334606437384523244891e-243
T(RD,  0x1.0cb29a0742453p+176,    0x1.6023c210430afp+7,  -0x1.fffffap-1, INEXACT) // 1.005317309719003655503172775067e+53
T(RU,  0x1.0cb29a0742453p+176,     0x1.6023c210430bp+7,  0x1.79e032p-23, INEXACT) // 1.005317309719003655503172775067e+53
T(RZ,  0x1.0cb29a0742453p+176,    0x1.6023c210430afp+7,  -0x1.fffffap-1, INEXACT) // 1.005317309719003655503172775067e+53
T(RD,    0x1.ba6b2e02cbd8p+56,    0x1.c6506bfb97d65p+5, -0x1.d88ee6p-24, INEXACT) // 1.245297850656911360000000000000e+17
T(RU,    0x1.ba6b2e02cbd8p+56,    0x1.c6506bfb97d66p+5,   0x1.fffffcp-1, INEXACT) // 1.245297850656911360000000000000e+17
T(RZ,    0x1.ba6b2e02cbd8p+56,    0x1.c6506bfb97d65p+5, -0x1.d88ee6p-24, INEXACT) // 1.245297850656911360000000000000e+17
T(RD,  0x1.628126e9c3449p+803,    0x1.91bc1dd2babbcp+9,  -0x1.fffffap-1, INEXACT) // 7.387003508238810188400636181818e+241
T(RU,  0x1.628126e9c3449p+803,    0x1.91bc1dd2babbdp+9,   0x1.6f04dp-23, INEXACT) // 7.387003508238810188400636181818e+241
T(RZ,  0x1.628126e9c3449p+803,    0x1.91bc1dd2babbcp+9,  -0x1.fffffap-1, INEXACT) // 7.387003508238810188400636181818e+241
T(RD,  0x1.73ea25cb008b8p-701,   -0x1.5e3b07b16df62p+9,  -0x1.fffffcp-1, INEXACT) // 1.380944890463718112374326654167e-211
T(RU,  0x1.73ea25cb008b8p-701,   -0x1.5e3b07b16df61p+9,  0x1.975982p-24, INEXACT) // 1.380944890463718112374326654167e-211
T(RZ,  0x1.73ea25cb008b8p-701,   -0x1.5e3b07b16df61p+9,  0x1.975982p-24, INEXACT) // 1.380944890463718112374326654167e-211
T(RD,  0x1.548f1df9cbdb5p+114,    0x1.c9a5a4b80ce62p+6,  -0x1.0794cp-23, INEXACT) // 2.762943267812643058019921258820e+34
T(RU,  0x1.548f1df9cbdb5p+114,    0x1.c9a5a4b80ce63p+6,   0x1.fffffcp-1, INEXACT) // 2.762943267812643058019921258820e+34
T(RZ,  0x1.548f1df9cbdb5p+114,    0x1.c9a5a4b80ce62p+6,  -0x1.0794cp-23, INEXACT) // 2.762943267812643058019921258820e+34
T(RN,  0x1.657ed38a4f889p-859,   -0x1.ad425500a29ccp+9,  -0x1.fffff2p-2, INEXACT) // 3.632990280277094687002510796702e-259
T(RN,  0x1.90e6d81808e2ep-336,   -0x1.4f5a575626f34p+8,  -0x1.fffffcp-2, INEXACT) // 1.118714912243758729514343904179e-101
T(RN,  0x1.f51cbf466313cp-496,   -0x1.ef07f0436f8c1p+8,  -0x1.fffffep-2, INEXACT) // 9.567913549931045186278027521348e-150
T(RD,  0x1.24dec6e23ed4fp+600,    0x1.2c18d8d951fe2p+9,  -0x1.04337p-23, INEXACT) // 4.747146667134388598990949893054e+180
T(RU,  0x1.24dec6e23ed4fp+600,    0x1.2c18d8d951fe3p+9,   0x1.fffffcp-1, INEXACT) // 4.747146667134388598990949893054e+180
T(RZ,  0x1.24dec6e23ed4fp+600,    0x1.2c18d8d951fe2p+9,  -0x1.04337p-23, INEXACT) // 4.747146667134388598990949893054e+180
T(RN,  0x1.a9af673488d6cp-635,   -0x1.3d2217fc553e3p+9,  -0x1.fffff8p-2, INEXACT) // 1.166275915165854156206106997597e-191
T(RD,  0x1.2da5b5377d6fap+367,    0x1.6f3c999b231dep+8, -0x1.5b1344p-24, INEXACT) // 3.542157602849815808259731718966e+110
T(RU,  0x1.2da5b5377d6fap+367,    0x1.6f3c999b231dfp+8,   0x1.fffffep-1, INEXACT) // 3.542157602849815808259731718966e+110
T(RZ,  0x1.2da5b5377d6fap+367,    0x1.6f3c999b231dep+8, -0x1.5b1344p-24, INEXACT) // 3.542157602849815808259731718966e+110
T(RD,  0x1.4dafa65e1fe82p+185,    0x1.72c3c31b4c739p+7, -0x1.a69bbcp-23, INEXACT) // 6.392156372850441948634063767462e+55
T(RU,  0x1.4dafa65e1fe82p+185,    0x1.72c3c31b4c73ap+7,   0x1.fffffap-1, INEXACT) // 6.392156372850441948634063767462e+55
T(RZ,  0x1.4dafa65e1fe82p+185,    0x1.72c3c31b4c739p+7, -0x1.a69bbcp-23, INEXACT) // 6.392156372850441948634063767462e+55
T(RD,  0x1.3d2c38bd01d79p+262,    0x1.064f22d077cdep+8,  -0x1.fffffcp-1, INEXACT) // 9.181523575370561532709848749746e+78
T(RU,  0x1.3d2c38bd01d79p+262,    0x1.064f22d077cdfp+8,  0x1.1111bcp-23, INEXACT) // 9.181523575370561532709848749746e+78
T(RZ,  0x1.3d2c38bd01d79p+262,    0x1.064f22d077cdep+8,  -0x1.fffffcp-1, INEXACT) // 9.181523575370561532709848749746e+78
T(RN,   0x1.dc127ed4a534ap+61,    0x1.ef29090318fc4p+5,  -0x1.fffff6p-2, INEXACT) // 4.288077595425543168000000000000e+18
T(RD,   0x1.cc31866cbb785p-27,   -0x1.a27663588c92fp+4,  -0x1.fffffap-1, INEXACT) // 1.339339236172046409590309998120e-08
T(RU,   0x1.cc31866cbb785p-27,   -0x1.a27663588c92ep+4,  0x1.625306p-23, INEXACT) // 1.339339236172046409590309998120e-08
T(RZ,   0x1.cc31866cbb785p-27,   -0x1.a27663588c92ep+4,  0x1.625306p-23, INEXACT) // 1.339339236172046409590309998120e-08
T(RN,   0x1.4f5e7f97770dp+128,    0x1.00c77a739d98ep+7,   0x1.fffff4p-2, INEXACT) // 4.457820423589657268403111031324e+38
T(RD,  0x1.1ac1531320053p+877,    0x1.b6925b3f0654ep+9,  -0x1.fffffcp-1, INEXACT) // 1.112952917855509058723476146344e+264
T(RU,  0x1.1ac1531320053p+877,    0x1.b6925b3f0654fp+9,  0x1.eda9d2p-24, INEXACT) // 1.112952917855509058723476146344e+264
T(RZ,  0x1.1ac1531320053p+877,    0x1.b6925b3f0654ep+9,  -0x1.fffffcp-1, INEXACT) // 1.112952917855509058723476146344e+264
T(RD,  0x1.0ecb35c3ed7ccp+690,    0x1.590a5fdfb91a3p+9,  -0x1.fffffcp-1, INEXACT) // 5.433701065798880481889869474529e+207
T(RU,  0x1.0ecb35c3ed7ccp+690,    0x1.590a5fdfb91a4p+9,  0x1.286b74p-23, INEXACT) // 5.433701065798880481889869474529e+207
T(RZ,  0x1.0ecb35c3ed7ccp+690,    0x1.590a5fdfb91a3p+9,  -0x1.fffffcp-1, INEXACT) // 5.433701065798880481889869474529e+207
T(RD,  0x1.c30c484168543p-643,   -0x1.4117680d462d6p+9, -0x1.290284p-23, INEXACT) // 4.827202998069660132490998763970e-194
T(RU,  0x1.c30c484168543p-643,   -0x1.4117680d462d5p+9,   0x1.fffffcp-1, INEXACT) // 4.827202998069660132490998763970e-194
T(RZ,  0x1.c30c484168543p-643,   -0x1.4117680d462d5p+9,   0x1.fffffcp-1, INEXACT) // 4.827202998069660132490998763970e-194
T(RN,   0x1.1ee59e9b61e48p-21,   -0x1.4d5ea9d211d1dp+4,  -0x1.fffff6p-2, INEXACT) // 5.343872148547027393417942209286e-07
T(RD,  0x1.0bd355f121196p+978,    0x1.e90856d32081ap+9,  -0x1.fffffcp-1, INEXACT) // 2.672684944674978529295516522485e+294
T(RU,  0x1.0bd355f121196p+978,    0x1.e90856d32081bp+9,  0x1.fdefc6p-24, INEXACT) // 2.672684944674978529295516522485e+294
T(RZ,  0x1.0bd355f121196p+978,    0x1.e90856d32081ap+9,  -0x1.fffffcp-1, INEXACT) // 2.672684944674978529295516522485e+294
T(RD,  0x1.3cc6a24ba06f2p+674,    0x1.512756393ab7dp+9, -0x1.bf51f6p-25, INEXACT) // 9.699051487358757961263987837620e+202
T(RU,  0x1.3cc6a24ba06f2p+674,    0x1.512756393ab7ep+9,   0x1.fffffep-1, INEXACT) // 9.699051487358757961263987837620e+202
T(RZ,  0x1.3cc6a24ba06f2p+674,    0x1.512756393ab7dp+9, -0x1.bf51f6p-25, INEXACT) // 9.699051487358757961263987837620e+202
T(RD,  0x1.700d0c8267dbep+141,    0x1.1b0c2a80c0679p+7,  -0x1.940b7p-25, INEXACT) // 4.007720190187349059488703920797e+42
T(RU,  0x1.700d0c8267dbep+141,    0x1.1b0c2a80c067ap+7,   0x1.fffffep-1, INEXACT) // 4.007720190187349059488703920797e+42
T(RZ,  0x1.700d0c8267dbep+141,    0x1.1b0c2a80c0679p+7,  -0x1.940b7p-25, INEXACT) // 4.007720190187349059488703920797e+42
T(RD,   0x1.869da7c4123bep+45,    0x1.6ce0797339c4ep+5, -0x1.d12ae4p-23, INEXACT) // 5.368583241786348437500000000000e+13
T(RU,   0x1.869da7c4123bep+45,    0x1.6ce0797339c4fp+5,   0x1.fffff8p-1, INEXACT) // 5.368583241786348437500000000000e+13
T(RZ,   0x1.869da7c4123bep+45,    0x1.6ce0797339c4ep+5, -0x1.d12ae4p-23, INEXACT) // 5.368583241786348437500000000000e+13
T(RN,   0x1.0ab38bd115e4fp+36,    0x1.2078ffa1c56e2p+5,         -0x1p-1, INEXACT) // 7.159209908936839294433593750000e+10
T(RD,   0x1.93c91940221e9p+37,    0x1.2d4272c190113p+5, -0x1.3fa548p-23, INEXACT) // 2.167807119402649230957031250000e+11
T(RU,   0x1.93c91940221e9p+37,    0x1.2d4272c190114p+5,   0x1.fffffcp-1, INEXACT) // 2.167807119402649230957031250000e+11
T(RZ,   0x1.93c91940221e9p+37,    0x1.2d4272c190113p+5, -0x1.3fa548p-23, INEXACT) // 2.167807119402649230957031250000e+11
T(RD,  0x1.e991c281b3287p+195,    0x1.87dee8c04c718p+7,         -0x1p+0, INEXACT) // 9.603364900918120238068014906678e+58
T(RU,  0x1.e991c281b3287p+195,    0x1.87dee8c04c719p+7,   0x1.596acp-27, INEXACT) // 9.603364900918120238068014906678e+58
T(RZ,  0x1.e991c281b3287p+195,    0x1.87dee8c04c718p+7,         -0x1p+0, INEXACT) // 9.603364900918120238068014906678e+58
T(RD,  0x1.c1804a39ad6c9p+328,    0x1.48cfeb17125f7p+8, -0x1.1c4ac2p-23, INEXACT) // 9.601285918402335486502004258994e+98
T(RU,  0x1.c1804a39ad6c9p+328,    0x1.48cfeb17125f8p+8,   0x1.fffffcp-1, INEXACT) // 9.601285918402335486502004258994e+98
T(RZ,  0x1.c1804a39ad6c9p+328,    0x1.48cfeb17125f7p+8, -0x1.1c4ac2p-23, INEXACT) // 9.601285918402335486502004258994e+98
T(RD,  0x1.a3041f22b01e8p-670,   -0x1.4ea5027a71f62p+9, -0x1.7b5684p-25, INEXACT) // 3.341132125796710502268699707142e-202
T(RU,  0x1.a3041f22b01e8p-670,   -0x1.4ea5027a71f61p+9,   0x1.fffffep-1, INEXACT) // 3.341132125796710502268699707142e-202
T(RZ,  0x1.a3041f22b01e8p-670,   -0x1.4ea5027a71f61p+9,   0x1.fffffep-1, INEXACT) // 3.341132125796710502268699707142e-202
T(RD,  0x1.f8ac453760a8ap+569,    0x1.1cfd569609706p+9,  -0x1.fffff8p-1, INEXACT) // 3.809233358023687024142041697016e+171
T(RU,  0x1.f8ac453760a8ap+569,    0x1.1cfd569609707p+9,  0x1.c2ac12p-23, INEXACT) // 3.809233358023687024142041697016e+171
T(RZ,  0x1.f8ac453760a8ap+569,    0x1.1cfd569609706p+9,  -0x1.fffff8p-1, INEXACT) // 3.809233358023687024142041697016e+171
T(RD,  0x1.e6cbfb980a0f7p-657,   -0x1.4809524cd9f06p+9,  -0x1.5160dp-23, INEXACT) // 3.179805857938566810274467714063e-198
T(RU,  0x1.e6cbfb980a0f7p-657,   -0x1.4809524cd9f05p+9,   0x1.fffffap-1, INEXACT) // 3.179805857938566810274467714063e-198
T(RZ,  0x1.e6cbfb980a0f7p-657,   -0x1.4809524cd9f05p+9,   0x1.fffffap-1, INEXACT) // 3.179805857938566810274467714063e-198
T(RD,  0x1.adcafa87fe034p+696,    0x1.5c5fae01f2679p+9, -0x1.5cf836p-23, INEXACT) // 5.519455532745494734060976804423e+209
T(RU,  0x1.adcafa87fe034p+696,    0x1.5c5fae01f267ap+9,   0x1.fffffap-1, INEXACT) // 5.519455532745494734060976804423e+209
T(RZ,  0x1.adcafa87fe034p+696,    0x1.5c5fae01f2679p+9, -0x1.5cf836p-23, INEXACT) // 5.519455532745494734060976804423e+209
T(RN,  0x1.887a52d7c3ae9p-487,   -0x1.e6622f32494e9p+8,   0x1.fffff2p-2, INEXACT) // 3.836783309729249656417672085067e-147
T(RN,   0x1.c1afb4a76f5ep-323,   -0x1.422fedf583c4fp+8,   0x1.fffff6p-2, INEXACT) // 1.027971656876575363263011981060e-97
T(RN,  0x1.537becd8872d4p+618,    0x1.35341f2234f65p+9,   0x1.fffff4p-2, INEXACT) // 1.442503154356882875388832076314e+186
T(RD,  0x1.8828ebdf4ac63p+268,    0x1.0c9d842bda918p+8, -0x1.702294p-25, INEXACT) // 7.265441319221895223897943245587e+80
T(RU,  0x1.8828ebdf4ac63p+268,    0x1.0c9d842bda919p+8,   0x1.fffffep-1, INEXACT) // 7.265441319221895223897943245587e+80
T(RZ,  0x1.8828ebdf4ac63p+268,    0x1.0c9d842bda918p+8, -0x1.702294p-25, INEXACT) // 7.265441319221895223897943245587e+80
T(RN,   0x1.412818b1df05p+142,    0x1.1ca77e0292baap+7,  -0x1.fffff6p-2, INEXACT) // 6.994171975950923248294285123026e+42
T(RD,  0x1.8798a7b5581ccp-436,   -0x1.b36303cb49ba9p+8,  -0x1.fffffcp-1, INEXACT) // 8.620262975806254716504573719341e-132
T(RU,  0x1.8798a7b5581ccp-436,   -0x1.b36303cb49ba8p+8,  0x1.3066f2p-23, INEXACT) // 8.620262975806254716504573719341e-132
T(RZ,  0x1.8798a7b5581ccp-436,   -0x1.b36303cb49ba8p+8,  0x1.3066f2p-23, INEXACT) // 8.620262975806254716504573719341e-132
T(RN,   0x1.ab9801e2d1a6ep-52,   -0x1.9a1447ff171d4p+5,  -0x1.fffffep-2, INEXACT) // 3.708784831141337374595618943405e-16
T(RN,  0x1.042bffb746904p+432,    0x1.b005f86073362p+8,  -0x1.fffff6p-2, INEXACT) // 1.127141657900579031734479392334e+130
T(RD,  0x1.3b9eb815fd746p+212,    0x1.a89aa59dc03ecp+7, -0x1.585092p-24, INEXACT) // 8.114908476621989747509992822698e+63
T(RU,  0x1.3b9eb815fd746p+212,    0x1.a89aa59dc03edp+7,   0x1.fffffep-1, INEXACT) // 8.114908476621989747509992822698e+63
T(RZ,  0x1.3b9eb815fd746p+212,    0x1.a89aa59dc03ecp+7, -0x1.585092p-24, INEXACT) // 8.114908476621989747509992822698e+63
T(RD,  0x1.10b7a6043525bp+138,    0x1.142eba00085b5p+7,  -0x1.fffff8p-1, INEXACT) // 3.712036581293712527693438380255e+41
T(RU,  0x1.10b7a6043525bp+138,    0x1.142eba00085b6p+7,  0x1.f8cf62p-23, INEXACT) // 3.712036581293712527693438380255e+41
T(RZ,  0x1.10b7a6043525bp+138,    0x1.142eba00085b5p+7,  -0x1.fffff8p-1, INEXACT) // 3.712036581293712527693438380255e+41
T(RN,  0x1.11eea17b9f3e5p+393,    0x1.8919013724442p+8,   0x1.fffff8p-2, INEXACT) // 2.158695266422826150022857618571e+118
T(RD,  0x1.98456c6598259p+882,    0x1.b9563171e6329p+9,  -0x1.fffffep-1, INEXACT) // 5.142389163740648205758606985215e+265
T(RU,  0x1.98456c6598259p+882,    0x1.b9563171e632ap+9,  0x1.d85da8p-25, INEXACT) // 5.142389163740648205758606985215e+265
T(RZ,  0x1.98456c6598259p+882,    0x1.b9563171e6329p+9,  -0x1.fffffep-1, INEXACT) // 5.142389163740648205758606985215e+265
T(RN,  0x1.38f3de97d6ceep-716,   -0x1.65dae7d1dbf95p+9,   0x1.fffff4p-2, INEXACT) // 3.546187743572093367780266403250e-216
T(RN,  0x1.f921e9a66bb2dp-502,   -0x1.f504fcc6228a1p+8,   0x1.fffffep-2, INEXACT) // 1.506980034638550281586486892780e-151
T(RN,  0x1.482366767368dp-476,   -0x1.dba44f9e8d282p+8,  -0x1.fffff8p-2, INEXACT) // 6.569601076884624133015351057550e-144
T(RN,   0x1.dad3f6a975fd5p+87,    0x1.5f90a6c32ba27p+6,  -0x1.fffff8p-2, INEXACT) // 2.870159039676031706123468800000e+26
T(RD,  0x1.319799970afb8p-636,   -0x1.3ddf4cf5e6f85p+9,  -0x1.fffffep-1, INEXACT) // 4.186248832577275928730058819556e-192
T(RU,  0x1.319799970afb8p-636,   -0x1.3ddf4cf5e6f84p+9,  0x1.30da28p-25, INEXACT) // 4.186248832577275928730058819556e-192
T(RZ,  0x1.319799970afb8p-636,   -0x1.3ddf4cf5e6f84p+9,  0x1.30da28p-25, INEXACT) // 4.186248832577275928730058819556e-192
T(RD,  0x1.ecd2e407a2ff3p+587,    0x1.25f8f367631f6p+9,  -0x1.fffffep-1, INEXACT) // 9.751224505659146572685448028519e+176
T(RU,  0x1.ecd2e407a2ff3p+587,    0x1.25f8f367631f7p+9,  0x1.508e28p-24, INEXACT) // 9.751224505659146572685448028519e+176
T(RZ,  0x1.ecd2e407a2ff3p+587,    0x1.25f8f367631f6p+9,  -0x1.fffffep-1, INEXACT) // 9.751224505659146572685448028519e+176
T(RD,   0x1.d8c9546bc7332p+88,    0x1.638a49333c61cp+6, -0x1.94e1e2p-25, INEXACT) // 5.715637398138962557072834560000e+26
T(RU,   0x1.d8c9546bc7332p+88,    0x1.638a49333c61dp+6,   0x1.fffffep-1, INEXACT) // 5.715637398138962557072834560000e+26
T(RZ,   0x1.d8c9546bc7332p+88,    0x1.638a49333c61cp+6, -0x1.94e1e2p-25, INEXACT) // 5.715637398138962557072834560000e+26
T(RN,  0x1.fd55d4ba375c9p+611,    0x1.31ff095129458p+9,  -0x1.fffff8p-2, INEXACT) // 1.690795730059316458992977910840e+184
T(RN,  0x1.a3516db15a76fp+549,    0x1.12db1f9453f0fp+9,  -0x1.fffffep-2, INEXACT) // 3.018361431270806228185903263212e+165
T(RN,  0x1.a6d28bd2cec1bp-253,   -0x1.f88d5be903b46p+7,   0x1.fffff4p-2, INEXACT) // 1.141114347765962855695285478717e-76
T(RD,  0x1.a4e4706488f67p-661,   -0x1.4a242f450abc7p+9, -0x1.bf209cp-23, INEXACT) // 1.718319516046004213845707496483e-199
T(RU,  0x1.a4e4706488f67p-661,   -0x1.4a242f450abc6p+9,   0x1.fffffap-1, INEXACT) // 1.718319516046004213845707496483e-199
T(RZ,  0x1.a4e4706488f67p-661,   -0x1.4a242f450abc6p+9,   0x1.fffffap-1, INEXACT) // 1.718319516046004213845707496483e-199
T(RN,  0x1.85134472dfd09p+155,    0x1.373533184fdf1p+7,   0x1.fffffcp-2, INEXACT) // 6.941334646044936271636666756267e+46
T(RD,  0x1.649ef3d6fa2e9p-228,   -0x1.c70b2325812cap+7,  -0x1.30307p-28, INEXACT) // 3.229444497453362986163410398169e-69
T(RU,  0x1.649ef3d6fa2e9p-228,   -0x1.c70b2325812c9p+7,          0x1p+0, INEXACT) // 3.229444497453362986163410398169e-69
T(RZ,  0x1.649ef3d6fa2e9p-228,   -0x1.c70b2325812c9p+7,          0x1p+0, INEXACT) // 3.229444497453362986163410398169e-69
T(RN,  0x1.9eaf5003e414ap+813,    0x1.96d9125075dd7p+9,   0x1.fffffcp-2, INEXACT) // 8.848397854131119982807786247190e+244
T(RD,  0x1.d9ffb83689fd5p-730,   -0x1.6c8e3dc53d609p+9,  -0x1.fffffep-1, INEXACT) // 3.278238436914252826210461037848e-220
T(RU,  0x1.d9ffb83689fd5p-730,   -0x1.6c8e3dc53d608p+9,  0x1.1deeb4p-25, INEXACT) // 3.278238436914252826210461037848e-220
T(RZ,  0x1.d9ffb83689fd5p-730,   -0x1.6c8e3dc53d608p+9,  0x1.1deeb4p-25, INEXACT) // 3.278238436914252826210461037848e-220
T(RD,  0x1.9e4b762925e5ep-456,   -0x1.c74e3457e5b4ep+8, -0x1.fa1a46p-24, INEXACT) // 8.697440464250781246754497130404e-138
T(RU,  0x1.9e4b762925e5ep-456,   -0x1.c74e3457e5b4dp+8,   0x1.fffffcp-1, INEXACT) // 8.697440464250781246754497130404e-138
T(RZ,  0x1.9e4b762925e5ep-456,   -0x1.c74e3457e5b4dp+8,   0x1.fffffcp-1, INEXACT) // 8.697440464250781246754497130404e-138
T(RN,  0x1.91cb49e31a759p-665,   -0x1.4c2cc28ee4e0cp+9,  -0x1.fffff6p-2, INEXACT) // 1.025218582222422009527731288847e-200
T(RD,  0x1.31f398a788f72p+194,    0x1.8483aa6539826p+7,  -0x1.fffffap-1, INEXACT) // 3.000764052102742954667768170123e+58
T(RU,  0x1.31f398a788f72p+194,    0x1.8483aa6539827p+7,  0x1.8cbde6p-23, INEXACT) // 3.000764052102742954667768170123e+58
T(RZ,  0x1.31f398a788f72p+194,    0x1.8483aa6539826p+7,  -0x1.fffffap-1, INEXACT) // 3.000764052102742954667768170123e+58
T(RN,  0x1.bb61323766a8fp-654,   -0x1.469a92acee43cp+9,   0x1.fffffcp-2, INEXACT) // 2.316960600203029550400864388188e-197
T(RD,   0x1.33f59f531092p+967,    0x1.e3a21fd6c3a09p+9,  -0x1.fffffep-1, INEXACT) // 1.500580831684045833278771392510e+291
T(RU,   0x1.33f59f531092p+967,    0x1.e3a21fd6c3a0ap+9,  0x1.4fa11ap-25, INEXACT) // 1.500580831684045833278771392510e+291
T(RZ,   0x1.33f59f531092p+967,    0x1.e3a21fd6c3a09p+9,  -0x1.fffffep-1, INEXACT) // 1.500580831684045833278771392510e+291
T(RD,   0x1.899e5f3c0c9aap+53,    0x1.acf719d445d62p+5, -0x1.ee7394p-23, INEXACT) // 1.384922471422856400000000000000e+16
T(RU,   0x1.899e5f3c0c9aap+53,    0x1.acf719d445d63p+5,   0x1.fffff8p-1, INEXACT) // 1.384922471422856400000000000000e+16
T(RZ,   0x1.899e5f3c0c9aap+53,    0x1.acf719d445d62p+5, -0x1.ee7394p-23, INEXACT) // 1.384922471422856400000000000000e+16
T(RD,  0x1.3e90fcbfb93fcp+129,    0x1.02a182ad0d3b4p+7, -0x1.2fb18ap-23, INEXACT) // 8.468946395287264380906072440775e+38
T(RU,  0x1.3e90fcbfb93fcp+129,    0x1.02a182ad0d3b5p+7,   0x1.fffffcp-1, INEXACT) // 8.468946395287264380906072440775e+38
T(RZ,  0x1.3e90fcbfb93fcp+129,    0x1.02a182ad0d3b4p+7, -0x1.2fb18ap-23, INEXACT) // 8.468946395287264380906072440775e+38
T(RN,  0x1.8f9e8cffa0353p-767,   -0x1.7f2dc3216461ap+9,   0x1.fffffap-2, INEXACT) // 2.010943448042358101181983208667e-231
T(RN,  0x1.8b11bf546fd5fp+246,    0x1.ed407e18389bep+7,   0x1.fffffap-2, INEXACT) // 1.745067696293524278685751232675e+74
T(RD,  0x1.8a0a5de7cdfcdp+694,    0x1.5b4fa440abedbp+9, -0x1.d224a4p-25, INEXACT) // 1.265079685323100921362985524992e+209
T(RU,  0x1.8a0a5de7cdfcdp+694,    0x1.5b4fa440abedcp+9,   0x1.fffffep-1, INEXACT) // 1.265079685323100921362985524992e+209
T(RZ,  0x1.8a0a5de7cdfcdp+694,    0x1.5b4fa440abedbp+9, -0x1.d224a4p-25, INEXACT) // 1.265079685323100921362985524992e+209
T(RD,  0x1.aaea7392b3d49p+744,    0x1.745e707cb4b5cp+9,  -0x1.fffffcp-1, INEXACT) // 1.543188802344011440990583842760e+224
T(RU,  0x1.aaea7392b3d49p+744,    0x1.745e707cb4b5dp+9,  0x1.d6d18ap-24, INEXACT) // 1.543188802344011440990583842760e+224
T(RZ,  0x1.aaea7392b3d49p+744,    0x1.745e707cb4b5cp+9,  -0x1.fffffcp-1, INEXACT) // 1.543188802344011440990583842760e+224
T(RN,  0x1.5bd51b24e98e9p+189,    0x1.7ae26e6bfd5c9p+7,  -0x1.fffffap-2, INEXACT) // 1.066103343202742795216904249981e+57
T(RD,  0x1.67a58700df253p+214,    0x1.acfb1a716ff9ap+7, -0x1.5e6ca8p-25, INEXACT) // 3.698750655674708074429543546762e+64
T(RU,  0x1.67a58700df253p+214,    0x1.acfb1a716ff9bp+7,   0x1.fffffep-1, INEXACT) // 3.698750655674708074429543546762e+64
T(RZ,  0x1.67a58700df253p+214,    0x1.acfb1a716ff9ap+7, -0x1.5e6ca8p-25, INEXACT) // 3.698750655674708074429543546762e+64
T(RN,  0x1.6ec682bb31cb6p-429,   -0x1.ac7b32fd94957p+8,  -0x1.fffff4p-2, INEXACT) // 1.033456336656872260305636652831e-129
T(RD,  0x1.e354f5aef3bbdp-578,   -0x1.208aa3fe3bdedp+9,         -0x1p+0, INEXACT) // 1.908393712326075465697582432270e-174
T(RU,  0x1.e354f5aef3bbdp-578,   -0x1.208aa3fe3bdecp+9,  0x1.42b612p-27, INEXACT) // 1.908393712326075465697582432270e-174
T(RZ,  0x1.e354f5aef3bbdp-578,   -0x1.208aa3fe3bdecp+9,  0x1.42b612p-27, INEXACT) // 1.908393712326075465697582432270e-174
T(RN,  0x1.03cb866d95755p-643,   -0x1.417d485623f18p+9,  -0x1.fffffcp-2, INEXACT) // 2.780376726430289669254725934386e-194
T(RN,   0x1.56862cee99b89p-34,   -0x1.0ca3b6a55b6f5p+5,  -0x1.fffff8p-2, INEXACT) // 7.788096879913044941483957911500e-11
T(RD,  0x1.02f9c603e7521p-331,   -0x1.4afbbb54d4b1cp+8,  -0x1.fffffep-1, INEXACT) // 2.312546361609878483277658304853e-100
T(RU,  0x1.02f9c603e7521p-331,   -0x1.4afbbb54d4b1bp+8,  0x1.2a8cdcp-25, INEXACT) // 2.312546361609878483277658304853e-100
T(RZ,  0x1.02f9c603e7521p-331,   -0x1.4afbbb54d4b1bp+8,  0x1.2a8cdcp-25, INEXACT) // 2.312546361609878483277658304853e-100
T(RD,   0x1.e51b02c2a234p-600,   -0x1.2b89f6d536edbp+9, -0x1.e21948p-23, INEXACT) // 4.566661747317307855202191419260e-181
T(RU,   0x1.e51b02c2a234p-600,   -0x1.2b89f6d536edap+9,   0x1.fffff8p-1, INEXACT) // 4.566661747317307855202191419260e-181
T(RZ,   0x1.e51b02c2a234p-600,   -0x1.2b89f6d536edap+9,   0x1.fffff8p-1, INEXACT) // 4.566661747317307855202191419260e-181
T(RN, 0x1.32803469a8216p+1016,    0x1.fc213f63ff868p+9,  -0x1.fffffep-2, INEXACT) // 8.407507073192907833118137775931e+305
T(RN,    0x1.356d6d246a702p+3,    0x1.a300a69ba41edp+1,  -0x1.fffff2p-2, INEXACT) // 9.669607707142407804212780320086e+00
T(RN,  0x1.a4e8d7dc72549p+148,    0x1.296f4aa67b75bp+7,   0x1.fffff6p-2, INEXACT) // 5.866622804657321340158271392255e+44
T(RD,  0x1.02ef84e74414cp-680,   -0x1.53fde4fa6b8cap+9,  -0x1.a4ed8p-24, INEXACT) // 2.016298297823851360161174953245e-205
T(RU,  0x1.02ef84e74414cp-680,   -0x1.53fde4fa6b8c9p+9,   0x1.fffffcp-1, INEXACT) // 2.016298297823851360161174953245e-205
T(RZ,  0x1.02ef84e74414cp-680,   -0x1.53fde4fa6b8c9p+9,   0x1.fffffcp-1, INEXACT) // 2.016298297823851360161174953245e-205
T(RN,  0x1.b10644abf82e9p-936,   -0x1.d39eefde565bcp+9,          0x1p-1, INEXACT) // 2.912034711098945811318880469956e-282
T(RD,  0x1.33e3baffabfe5p+554,    0x1.1522151be7559p+9, -0x1.063c78p-23, INEXACT) // 7.092063453310183369379895274579e+166
T(RU,  0x1.33e3baffabfe5p+554,    0x1.1522151be755ap+9,   0x1.fffffcp-1, INEXACT) // 7.092063453310183369379895274579e+166
T(RZ,  0x1.33e3baffabfe5p+554,    0x1.1522151be7559p+9, -0x1.063c78p-23, INEXACT) // 7.092063453310183369379895274579e+166
T(RD,  0x1.e7c80f0214a87p+828,    0x1.9e770d3a3ac4fp+9, -0x1.71bb16p-24, INEXACT) // 3.410529030874095148071529171494e+249
T(RU,  0x1.e7c80f0214a87p+828,     0x1.9e770d3a3ac5p+9,   0x1.fffffep-1, INEXACT) // 3.410529030874095148071529171494e+249
T(RZ,  0x1.e7c80f0214a87p+828,    0x1.9e770d3a3ac4fp+9, -0x1.71bb16p-24, INEXACT) // 3.410529030874095148071529171494e+249
T(RD,  0x1.cb40baa690ae4p-922,   -0x1.cc9413d44c7b2p+9,  -0x1.fffffep-1, INEXACT) // 5.060062612444535647919016262987e-278
T(RU,  0x1.cb40baa690ae4p-922,   -0x1.cc9413d44c7b1p+9,  0x1.fea76ap-25, INEXACT) // 5.060062612444535647919016262987e-278
T(RZ,  0x1.cb40baa690ae4p-922,   -0x1.cc9413d44c7b1p+9,  0x1.fea76ap-25, INEXACT) // 5.060062612444535647919016262987e-278
T(RD,  0x1.219694db44cdbp-708,   -0x1.61e93bea23974p+9,  -0x1.fffff8p-1, INEXACT) // 8.400477624232370825649775884992e-214
T(RU,  0x1.219694db44cdbp-708,   -0x1.61e93bea23973p+9,  0x1.da9a1cp-23, INEXACT) // 8.400477624232370825649775884992e-214
T(RZ,  0x1.219694db44cdbp-708,   -0x1.61e93bea23973p+9,  0x1.da9a1cp-23, INEXACT) // 8.400477624232370825649775884992e-214
T(RN,  0x1.c7e035acd087fp+849,    0x1.a8ea8f43a2428p+9,   0x1.fffffap-2, INEXACT) // 6.684561295137765112193176015094e+255
T(RN,  0x1.02a5ee890a555p+955,    0x1.dd81e6832b537p+9,   0x1.fffffap-2, INEXACT) // 3.076913629110250440648792965919e+287
T(RD,  0x1.fd72db0e8462bp-341,   -0x1.5401d85262d47p+8, -0x1.2aacaap-23, INEXACT) // 4.442545999271695251764380505318e-103
T(RU,  0x1.fd72db0e8462bp-341,   -0x1.5401d85262d46p+8,   0x1.fffffcp-1, INEXACT) // 4.442545999271695251764380505318e-103
T(RZ,  0x1.fd72db0e8462bp-341,   -0x1.5401d85262d46p+8,   0x1.fffffcp-1, INEXACT) // 4.442545999271695251764380505318e-103
T(RD,  0x1.52a723e796664p+380,    0x1.7c67567dccdb6p+8, -0x1.5e900cp-23, INEXACT) // 3.257715657640540735129979012643e+114
T(RU,  0x1.52a723e796664p+380,    0x1.7c67567dccdb7p+8,   0x1.fffffap-1, INEXACT) // 3.257715657640540735129979012643e+114
T(RZ,  0x1.52a723e796664p+380,    0x1.7c67567dccdb6p+8, -0x1.5e900cp-23, INEXACT) // 3.257715657640540735129979012643e+114
T(RN,  0x1.0662115940ce5p-347,   -0x1.5af6e773051c5p+8,   -0x1.fffffp-2, INEXACT) // 3.575093137592339426387338488472e-105
T(RD,  0x1.419cc228bc2a6p+871,    0x1.b3aa22891aae9p+9,  -0x1.fffffcp-1, INEXACT) // 1.977966622418146834444332420623e+262
T(RU,  0x1.419cc228bc2a6p+871,    0x1.b3aa22891aaeap+9,   0x1.0508fp-23, INEXACT) // 1.977966622418146834444332420623e+262
T(RZ,  0x1.419cc228bc2a6p+871,    0x1.b3aa22891aae9p+9,  -0x1.fffffcp-1, INEXACT) // 1.977966622418146834444332420623e+262
T(RD,  0x1.f23af0108bf6fp-140,    -0x1.1614233a3578p+7,  -0x1.fffffap-1, INEXACT) // 1.396338500014747612218041728541e-42
T(RU,  0x1.f23af0108bf6fp-140,   -0x1.1614233a3577fp+7,  0x1.98160ap-23, INEXACT) // 1.396338500014747612218041728541e-42
T(RZ,  0x1.f23af0108bf6fp-140,   -0x1.1614233a3577fp+7,  0x1.98160ap-23, INEXACT) // 1.396338500014747612218041728541e-42
T(RD,  0x1.f23d7c351661ap+126,    0x1.fbd7c11941071p+6,         -0x1p+0, INEXACT) // 1.655686978085172217134470519745e+38
T(RU,  0x1.f23d7c351661ap+126,    0x1.fbd7c11941072p+6,  0x1.49b826p-26, INEXACT) // 1.655686978085172217134470519745e+38
T(RZ,  0x1.f23d7c351661ap+126,    0x1.fbd7c11941071p+6,         -0x1p+0, INEXACT) // 1.655686978085172217134470519745e+38
T(RN,  0x1.66ad2b0e9f2a2p-217,   -0x1.b106e456a08a6p+7,   0x1.fffff2p-2, INEXACT) // 6.652024254307642618771809433324e-66
T(RD,   0x1.80cbd9c7d2a61p-68,    -0x1.0da5f02686b8p+6, -0x1.90c3bap-23, INEXACT) // 5.092736517981006915611827041226e-21
T(RU,   0x1.80cbd9c7d2a61p-68,   -0x1.0da5f02686b7fp+6,   0x1.fffffap-1, INEXACT) // 5.092736517981006915611827041226e-21
T(RZ,   0x1.80cbd9c7d2a61p-68,   -0x1.0da5f02686b7fp+6,   0x1.fffffap-1, INEXACT) // 5.092736517981006915611827041226e-21
T(RN,  0x1.53fcb4584d9d5p-884,   -0x1.b9cb9ade24979p+9,  -0x1.fffffcp-2, INEXACT) // 1.029689635028238710816857080302e-266
T(RN,  0x1.0355bcbc85d69p+422,    0x1.a604c7ba9b9a6p+8,    0x1.fffffp-2, INEXACT) // 1.097183301915153495251402296154e+127
T(RN,  0x1.c11da4c46b062p+307,    0x1.33cf9a00d1c5fp+8,   0x1.fffff8p-2, INEXACT) // 4.574325163837526509868588617391e+92
T(RD,     0x1.07e4b613a6p+870,    0x1.b3059b9d4e13ep+9,  -0x1.fffffap-1, INEXACT) // 8.114930344205034590722284104921e+261
T(RU,     0x1.07e4b613a6p+870,    0x1.b3059b9d4e13fp+9,  0x1.ab1f62p-23, INEXACT) // 8.114930344205034590722284104921e+261
T(RZ,     0x1.07e4b613a6p+870,    0x1.b3059b9d4e13ep+9,  -0x1.fffffap-1, INEXACT) // 8.114930344205034590722284104921e+261
T(RD,  0x1.02ee9cf4a4eedp+925,     0x1.ce821a602925p+9,  -0x1.3d586p-23, INEXACT) // 2.868744617365426256589773764506e+278
T(RU,  0x1.02ee9cf4a4eedp+925,    0x1.ce821a6029251p+9,   0x1.fffffcp-1, INEXACT) // 2.868744617365426256589773764506e+278
T(RZ,  0x1.02ee9cf4a4eedp+925,     0x1.ce821a602925p+9,  -0x1.3d586p-23, INEXACT) // 2.868744617365426256589773764506e+278
T(RD,  0x1.0a0f87c1a52ebp-273,   -0x1.10f1c373187afp+8,         -0x1p+0, INEXACT) // 6.847812982784005688872864326530e-83
T(RU,  0x1.0a0f87c1a52ebp-273,   -0x1.10f1c373187aep+8,  0x1.f02112p-27, INEXACT) // 6.847812982784005688872864326530e-83
T(RZ,  0x1.0a0f87c1a52ebp-273,   -0x1.10f1c373187aep+8,  0x1.f02112p-27, INEXACT) // 6.847812982784005688872864326530e-83
T(RN,  0x1.5748139315977p-253,   -0x1.f9274bf8d5846p+7,  -0x1.fffffep-2, INEXACT) // 9.264491613400120103704518886543e-77
T(RD,  0x1.413cf993e02f1p-768,   -0x1.7fd6147e70da1p+9, -0x1.b2eafcp-23, INEXACT) // 8.082589565643831556817722414764e-232
T(RU,  0x1.413cf993e02f1p-768,    -0x1.7fd6147e70dap+9,   0x1.fffffap-1, INEXACT) // 8.082589565643831556817722414764e-232
T(RZ,  0x1.413cf993e02f1p-768,    -0x1.7fd6147e70dap+9,   0x1.fffffap-1, INEXACT) // 8.082589565643831556817722414764e-232
T(RN,  0x1.9e6e3a8095398p-816,   -0x1.97a70aad6b9c7p+9,   0x1.fffffap-2, INEXACT) // 3.704549197362196432818644875258e-246
T(RN,  0x1.7c165e3c2f4b2p+134,    0x1.0d23ef96dff65p+7,  -0x1.fffffap-2, INEXACT) // 3.233425793561503411442919857452e+40
T(RN,  0x1.a306ca9c6fb9fp+780,    0x1.865afeb2c427cp+9,  -0x1.fffff2p-2, INEXACT) // 1.040874028130076834959862217692e+235
T(RN,  0x1.e820ba0d8dc77p-730,   -0x1.6c88d137629c4p+9,   0x1.fffff4p-2, INEXACT) // 3.375955995171273984366663574015e-220
T(RD,  0x1.0820f9e1c9186p+691,    0x1.5985c5c46c8f8p+9, -0x1.e6380cp-26, INEXACT) // 1.059992562369846812967876956295e+208
T(RU,  0x1.0820f9e1c9186p+691,    0x1.5985c5c46c8f9p+9,          0x1p+0, INEXACT) // 1.059992562369846812967876956295e+208
T(RZ,  0x1.0820f9e1c9186p+691,    0x1.5985c5c46c8f8p+9, -0x1.e6380cp-26, INEXACT) // 1.059992562369846812967876956295e+208
T(RN,  0x1.805419d2bde2fp-942,   -0x1.d6b4f785a81ddp+9,   0x1.fffff8p-2, INEXACT) // 4.038375808386271298695185325943e-284
T(RN,  0x1.f79625e835cddp-545,   -0x1.10030f4a98fd9p+9,  -0x1.fffff4p-2, INEXACT) // 1.707994589805596119938206090467e-164
T(RN,  0x1.739dec3741ae4p-788,   -0x1.89bb2d8e4aa2cp+9,   0x1.fffff8p-2, INEXACT) // 8.917002549612509090692032801997e-238
T(RD,   0x1.8104104592754p+26,    0x1.a96b9e6839d5ap+4, -0x1.9e6748p-23, INEXACT) // 1.009296010870640873908996582031e+08
T(RU,   0x1.8104104592754p+26,    0x1.a96b9e6839d5bp+4,   0x1.fffffap-1, INEXACT) // 1.009296010870640873908996582031e+08
T(RZ,   0x1.8104104592754p+26,    0x1.a96b9e6839d5ap+4, -0x1.9e6748p-23, INEXACT) // 1.009296010870640873908996582031e+08
T(RN,  0x1.fab0ea36657dfp+171,    0x1.57f84d04b2c68p+7,  -0x1.fffff8p-2, INEXACT) // 5.924238671824621500463455556842e+51
T(RD,  0x1.ec99910de1dafp+235,    0x1.d7e377ad3bc6dp+7, -0x1.6ce8e2p-24, INEXACT) // 1.062437297016921417597480876901e+71
T(RU,  0x1.ec99910de1dafp+235,    0x1.d7e377ad3bc6ep+7,   0x1.fffffep-1, INEXACT) // 1.062437297016921417597480876901e+71
T(RZ,  0x1.ec99910de1dafp+235,    0x1.d7e377ad3bc6dp+7, -0x1.6ce8e2p-24, INEXACT) // 1.062437297016921417597480876901e+71
T(RN,  0x1.dbe95d4627726p+621,    0x1.36f2809b2a6eap+9,  -0x1.fffffcp-2, INEXACT) // 1.617758214997113453881435196052e+187
T(RN, 0x1.6ecfaeefb18c9p+1006,    0x1.f7426b1f6e921p+9,  -0x1.fffff2p-2, INEXACT) // 9.826035639706035757865863465695e+302
T(RD,  0x1.606a2bdd11c7ep+509,    0x1.fd760ca4b8234p+8,  -0x1.b0b0ap-24, INEXACT) // 2.307182146347459866376695905796e+153
T(RU,  0x1.606a2bdd11c7ep+509,    0x1.fd760ca4b8235p+8,   0x1.fffffcp-1, INEXACT) // 2.307182146347459866376695905796e+153
T(RZ,  0x1.606a2bdd11c7ep+509,    0x1.fd760ca4b8234p+8,  -0x1.b0b0ap-24, INEXACT) // 2.307182146347459866376695905796e+153
T(RD,  0x1.5fee7efe4218cp+263,    0x1.07758af16d62cp+8,  -0x1.fffffap-1, INEXACT) // 2.037544907890824955729286770445e+79
T(RU,  0x1.5fee7efe4218cp+263,    0x1.07758af16d62dp+8,   0x1.86b16p-23, INEXACT) // 2.037544907890824955729286770445e+79
T(RZ,  0x1.5fee7efe4218cp+263,    0x1.07758af16d62cp+8,  -0x1.fffffap-1, INEXACT) // 2.037544907890824955729286770445e+79
T(RD,  0x1.4dd02593fc7d5p-177,   -0x1.613bf4f87e7bdp+7, -0x1.f2a1aap-23, INEXACT) // 6.806974810332374422062056342201e-54
T(RU,  0x1.4dd02593fc7d5p-177,   -0x1.613bf4f87e7bcp+7,   0x1.fffff8p-1, INEXACT) // 6.806974810332374422062056342201e-54
T(RZ,  0x1.4dd02593fc7d5p-177,   -0x1.613bf4f87e7bcp+7,   0x1.fffff8p-1, INEXACT) // 6.806974810332374422062056342201e-54
T(RN,  0x1.8d14b214121c3p+845,    0x1.a6d10f9cbb04dp+9,          0x1p-1, INEXACT) // 3.639027228599389517001075544214e+254
T(RD,  0x1.984938780f1c8p-254,   -0x1.faa73359b9993p+7,  -0x1.fffffcp-1, INEXACT) // 5.509416983215169870747266026349e-77
T(RU,  0x1.984938780f1c8p-254,   -0x1.faa73359b9992p+7,  0x1.242a8ap-23, INEXACT) // 5.509416983215169870747266026349e-77
T(RZ,  0x1.984938780f1c8p-254,   -0x1.faa73359b9992p+7,  0x1.242a8ap-23, INEXACT) // 5.509416983215169870747266026349e-77
T(RD,  0x1.87eeafabf3b74p-868,   -0x1.b1b1595843742p+9,  -0x1.1652cp-23, INEXACT) // 7.779199869124979187539393131050e-262
T(RU,  0x1.87eeafabf3b74p-868,   -0x1.b1b1595843741p+9,   0x1.fffffcp-1, INEXACT) // 7.779199869124979187539393131050e-262
T(RZ,  0x1.87eeafabf3b74p-868,   -0x1.b1b1595843741p+9,   0x1.fffffcp-1, INEXACT) // 7.779199869124979187539393131050e-262
T(RN,  0x1.e462f4ee4ec85p-418,   -0x1.a11479e5b290bp+8,  -0x1.fffffep-2, INEXACT) // 2.795206660935492007528373870774e-126
T(RN,  0x1.080d7782b52f3p-729,   -0x1.6c7a47dfe1a3cp+9,         -0x1p-1, INEXACT) // 3.652444721325411045850214484808e-220
T(RD,  0x1.eaa4120af1829p-478,   -0x1.dd0fbce947528p+8, -0x1.fcbf04p-28, INEXACT) // 2.455759630792575175869513365836e-144
T(RU,  0x1.eaa4120af1829p-478,   -0x1.dd0fbce947527p+8,          0x1p+0, INEXACT) // 2.455759630792575175869513365836e-144
T(RZ,  0x1.eaa4120af1829p-478,   -0x1.dd0fbce947527p+8,          0x1p+0, INEXACT) // 2.455759630792575175869513365836e-144
T(RN,   0x1.19ce0c4903d57p+88,    0x1.608de0c640ebbp+6,   0x1.fffff2p-2, INEXACT) // 3.406811894293942962330009600000e+26
T(RD,   0x1.e45a2db600b9cp-92,   -0x1.6c52025cc7523p+6,  -0x1.fffffep-1, INEXACT) // 3.820865622644904777676045638295e-28
T(RU,   0x1.e45a2db600b9cp-92,   -0x1.6c52025cc7522p+6,  0x1.1b3672p-24, INEXACT) // 3.820865622644904777676045638295e-28
T(RZ,   0x1.e45a2db600b9cp-92,   -0x1.6c52025cc7522p+6,  0x1.1b3672p-24, INEXACT) // 3.820865622644904777676045638295e-28
T(RD,  0x1.e67e8cd4d454ap+677,    0x1.52f690511a8d1p+9,  -0x1.fffff8p-1, INEXACT) // 1.191639492699052181102720224280e+204
T(RU,  0x1.e67e8cd4d454ap+677,    0x1.52f690511a8d2p+9,  0x1.d2fae6p-23, INEXACT) // 1.191639492699052181102720224280e+204
T(RZ,  0x1.e67e8cd4d454ap+677,    0x1.52f690511a8d1p+9,  -0x1.fffff8p-1, INEXACT) // 1.191639492699052181102720224280e+204
T(RN,  0x1.0755006cbd3a6p+428,    0x1.ac0a6de319bdap+8,  -0x1.fffff8p-2, INEXACT) // 7.130202739343945603998395098647e+128
T(RD,  0x1.559ed04292e2fp-932,   -0x1.d1cab8507a71ap+9,  -0x1.fffffep-1, INEXACT) // 3.675765765390665629293207939525e-281
T(RU,  0x1.559ed04292e2fp-932,   -0x1.d1cab8507a719p+9,  0x1.1afbaep-24, INEXACT) // 3.675765765390665629293207939525e-281
T(RZ,  0x1.559ed04292e2fp-932,   -0x1.d1cab8507a719p+9,  0x1.1afbaep-24, INEXACT) // 3.675765765390665629293207939525e-281
T(RD,  0x1.97f701ab7811fp+880,    0x1.b8560df680031p+9, -0x1.23ac54p-27, INEXACT) // 1.284632738287634480023375759083e+265
T(RU,  0x1.97f701ab7811fp+880,    0x1.b8560df680032p+9,          0x1p+0, INEXACT) // 1.284632738287634480023375759083e+265
T(RZ,  0x1.97f701ab7811fp+880,    0x1.b8560df680031p+9, -0x1.23ac54p-27, INEXACT) // 1.284632738287634480023375759083e+265
T(RN,  0x1.ffd85f18a377bp+496,    0x1.f0ffe368e4706p+8,   0x1.fffff4p-2, INEXACT) // 4.090501156800161709353422135544e+149
T(RN,  0x1.f46b16ecf9d7dp-893,   -0x1.be0439a54dd24p+9,   0x1.fffffep-2, INEXACT) // 2.960104928900210259657932897797e-269
T(RD,  0x1.1ccba438634dfp-671,   -0x1.4f6c50dba1bf4p+9,  -0x1.da247p-25, INEXACT) // 1.135444806421596886906120322662e-202
T(RU,  0x1.1ccba438634dfp-671,   -0x1.4f6c50dba1bf3p+9,   0x1.fffffep-1, INEXACT) // 1.135444806421596886906120322662e-202
T(RZ,  0x1.1ccba438634dfp-671,   -0x1.4f6c50dba1bf3p+9,   0x1.fffffep-1, INEXACT) // 1.135444806421596886906120322662e-202
T(RN,   0x1.cc42bf810acep+801,    0x1.90ec53ce5d665p+9,   0x1.fffff6p-2, INEXACT) // 2.397675954168398349335619566677e+241
T(RN,  0x1.24ced46d2b495p+643,    0x1.4198cecae9e86p+9,   0x1.fffff8p-2, INEXACT) // 4.174746211998537111030450094483e+193
T(RN,  0x1.b2344f84fa602p-356,   -0x1.633cde791a48bp+8,  -0x1.fffff2p-2, INEXACT) // 1.155515396961663277024796999560e-107
T(RN,  0x1.950e7f250ae36p-770,   -0x1.80ab443eedcb1p+9,  -0x1.fffffcp-2, INEXACT) // 2.547880857730657961387441197211e-232
T(RN,  0x1.eab3bc50fda23p-196,   -0x1.861f623d77833p+7,  -0x1.fffff2p-2, INEXACT) // 1.908529135515174674018549019818e-59
T(RD,  0x1.c1f8ffa44037fp-270,   -0x1.0d2fb1c8455b2p+8, -0x1.3c09fep-23, INEXACT) // 9.265040534329820151804952032096e-82
T(RU,  0x1.c1f8ffa44037fp-270,   -0x1.0d2fb1c8455b1p+8,   0x1.fffffcp-1, INEXACT) // 9.265040534329820151804952032096e-82
T(RZ,  0x1.c1f8ffa44037fp-270,   -0x1.0d2fb1c8455b1p+8,   0x1.fffffcp-1, INEXACT) // 9.265040534329820151804952032096e-82
T(RD,  0x1.c51396315a32ep-504,   -0x1.f72d27d6403f8p+8, -0x1.3f4994p-25, INEXACT) // 3.379198992686702036452196456686e-152
T(RU,  0x1.c51396315a32ep-504,   -0x1.f72d27d6403f7p+8,   0x1.fffffep-1, INEXACT) // 3.379198992686702036452196456686e-152
T(RZ,  0x1.c51396315a32ep-504,   -0x1.f72d27d6403f7p+8,   0x1.fffffep-1, INEXACT) // 3.379198992686702036452196456686e-152
T(RN,  0x1.018160205dda7p-896,   -0x1.bffeead311f9ep+9,          0x1p-1, INEXACT) // 1.904014340653077881284816520015e-270
T(RN,  0x1.bbd21285ca015p-355,   -0x1.6234c75f8bf49p+8,  -0x1.fffff6p-2, INEXACT) // 2.362212837804196352855566190882e-107
T(RN,  0x1.157fcb9fe5f9ep-494,   -0x1.ede2378df0844p+8,  -0x1.fffff2p-2, INEXACT) // 2.119355998528515499148391419195e-149
T(RN,   0x1.2f663cbacecb1p-83,   -0x1.4b050b415c335p+6,  -0x1.fffff2p-2, INEXACT) // 1.225420272928151571855706869269e-25
T(RD,  0x1.abbdc10b2c00cp+226,    0x1.c57b2f3243debp+7,  -0x1.fffffep-1, INEXACT) // 1.801856353679078219055102078420e+68
T(RU,  0x1.abbdc10b2c00cp+226,    0x1.c57b2f3243decp+7,  0x1.5e7cf2p-24, INEXACT) // 1.801856353679078219055102078420e+68
T(RZ,  0x1.abbdc10b2c00cp+226,    0x1.c57b2f3243debp+7,  -0x1.fffffep-1, INEXACT) // 1.801856353679078219055102078420e+68
T(RN,   0x1.bc5b2135a732p+443,    0x1.bbcbaa9c9bdb6p+8,   0x1.fffffcp-2, INEXACT) // 3.942567509238740788370315138196e+133
T(RD,  0x1.7c616e3dd1bb4p+223,    0x1.bf248168c432dp+7, -0x1.638026p-24, INEXACT) // 2.002937573539872230739058659009e+67
T(RU,  0x1.7c616e3dd1bb4p+223,    0x1.bf248168c432ep+7,   0x1.fffffep-1, INEXACT) // 2.002937573539872230739058659009e+67
T(RZ,  0x1.7c616e3dd1bb4p+223,    0x1.bf248168c432dp+7, -0x1.638026p-24, INEXACT) // 2.002937573539872230739058659009e+67
T(RN,  0x1.62088ebb52b65p+706,    0x1.613bdef667a62p+9,  -0x1.fffff4p-2, INEXACT) // 4.655659861288433375101264620673e+212
T(RN,  0x1.a00b70092bb02p-618,   -0x1.34a652ea12d23p+9,  -0x1.fffffep-2, INEXACT) // 1.494041584372063163926931861135e-186
T(RD,  0x1.2af8d9f996cfbp-514,    -0x1.00e358540e46p+9, -0x1.fa0362p-23, INEXACT) // 2.177573840014742348788275570374e-155
T(RU,  0x1.2af8d9f996cfbp-514,   -0x1.00e358540e45fp+9,   0x1.fffff8p-1, INEXACT) // 2.177573840014742348788275570374e-155
T(RZ,  0x1.2af8d9f996cfbp-514,   -0x1.00e358540e45fp+9,   0x1.fffff8p-1, INEXACT) // 2.177573840014742348788275570374e-155
T(RD,  0x1.b49c189fb27dcp+394,    0x1.8ac52bdcd2522p+8, -0x1.468afcp-23, INEXACT) // 6.881320041462118970720268827783e+118
T(RU,  0x1.b49c189fb27dcp+394,    0x1.8ac52bdcd2523p+8,   0x1.fffffap-1, INEXACT) // 6.881320041462118970720268827783e+118
T(RZ,  0x1.b49c189fb27dcp+394,    0x1.8ac52bdcd2522p+8, -0x1.468afcp-23, INEXACT) // 6.881320041462118970720268827783e+118
T(RD,  0x1.809d6c9c72a01p-548,   -0x1.11b4d44de4136p+9,         -0x1p+0, INEXACT) // 1.630604209494401919379602324965e-165
T(RU,  0x1.809d6c9c72a01p-548,   -0x1.11b4d44de4135p+9,  0x1.119b34p-27, INEXACT) // 1.630604209494401919379602324965e-165
T(RZ,  0x1.809d6c9c72a01p-548,   -0x1.11b4d44de4135p+9,  0x1.119b34p-27, INEXACT) // 1.630604209494401919379602324965e-165
T(RD,  0x1.118bed0bd4417p-750,    -0x1.76f3c1fa8e1cp+9,  -0x1.fffffap-1, INEXACT) // 1.804241156583811696061571774469e-226
T(RU,  0x1.118bed0bd4417p-750,   -0x1.76f3c1fa8e1bfp+9,  0x1.7e0374p-23, INEXACT) // 1.804241156583811696061571774469e-226
T(RZ,  0x1.118bed0bd4417p-750,   -0x1.76f3c1fa8e1bfp+9,  0x1.7e0374p-23, INEXACT) // 1.804241156583811696061571774469e-226
T(RD,   0x1.f0aa2b0bd82fbp+98,    0x1.8bd31356a920fp+6,  -0x1.fffffep-1, INEXACT) // 6.148411421638898096115401359360e+29
T(RU,   0x1.f0aa2b0bd82fbp+98,     0x1.8bd31356a921p+6,  0x1.4fc37ap-25, INEXACT) // 6.148411421638898096115401359360e+29
T(RZ,   0x1.f0aa2b0bd82fbp+98,    0x1.8bd31356a920fp+6,  -0x1.fffffep-1, INEXACT) // 6.148411421638898096115401359360e+29
T(RD,  0x1.e22d5a886b258p-965,   -0x1.e20b1511c618ep+9, -0x1.4c0e98p-24, INEXACT) // 6.039776333415695845100040081775e-291
T(RU,  0x1.e22d5a886b258p-965,   -0x1.e20b1511c618dp+9,   0x1.fffffep-1, INEXACT) // 6.039776333415695845100040081775e-291
T(RZ,  0x1.e22d5a886b258p-965,   -0x1.e20b1511c618dp+9,   0x1.fffffep-1, INEXACT) // 6.039776333415695845100040081775e-291
T(RD,  0x1.3b32fbd6c78cbp-810,   -0x1.94d995ac28431p+9,  -0x1.fffffap-1, INEXACT) // 1.803219485789801878092470084906e-244
T(RU,  0x1.3b32fbd6c78cbp-810,    -0x1.94d995ac2843p+9,  0x1.7c952cp-23, INEXACT) // 1.803219485789801878092470084906e-244
T(RZ,  0x1.3b32fbd6c78cbp-810,    -0x1.94d995ac2843p+9,  0x1.7c952cp-23, INEXACT) // 1.803219485789801878092470084906e-244
T(RN,  0x1.77067da1ca7bap-812,   -0x1.95b97deee2484p+9,  -0x1.fffff6p-2, INEXACT) // 5.363696377391044463406990459092e-245
T(RN,  0x1.90b11ea0b43eap-297,   -0x1.285a88d7d2b57p+8,   0x1.fffff2p-2, INEXACT) // 6.146980807032071140160271507662e-90
T(RN,  0x1.06d2b4096dabcp+997,    0x1.f284db7b5214ep+9,   0x1.fffff2p-2, INEXACT) // 1.375083840701094041250996103383e+300
T(RD,    0x1.e4adc99221acp+37,    0x1.2f5df921fe52fp+5,  -0x1.fffffep-1, INEXACT) // 2.602099799722089843750000000000e+11
T(RU,    0x1.e4adc99221acp+37,     0x1.2f5df921fe53p+5,  0x1.7aee02p-25, INEXACT) // 2.602099799722089843750000000000e+11
T(RZ,    0x1.e4adc99221acp+37,    0x1.2f5df921fe52fp+5,  -0x1.fffffep-1, INEXACT) // 2.602099799722089843750000000000e+11
T(RN,  0x1.0b7a487ebd3ebp+184,    0x1.70206588887b1p+7,   0x1.fffff8p-2, INEXACT) // 2.561927090900766572655677921316e+55
