﻿// atan.testdata
// copyright (C) 2005 Ch. Q. Lauter and F. de Dinechin and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RN,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RU,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RU,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RD,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RD,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RZ,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RZ,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RN,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RN,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RU,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RU,              -0x1p-1074,                 -0x0p+0,          0x1p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RD,               0x1p-1074,                  0x0p+0,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RD,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RZ,               0x1p-1074,                  0x0p+0,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RZ,              -0x1p-1074,                 -0x0p+0,          0x1p+0, INEXACT|UNDERFLOW) // smallest denorm negative
// We assume that people asking for directed rounding mode know what they are doing
// and may return values larger than Pi/2 in this case.
T(RN,                     inf,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT) // +inf
T(RN,                    -inf,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT) // -inf
T(RU,                     inf,    0x1.921fb54442d19p+0,   0x1.72cecep-1, INEXACT) // +inf
T(RU,                    -inf,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT) // -inf
T(RD,                     inf,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT) // +inf
T(RD,                    -inf,   -0x1.921fb54442d19p+0,  -0x1.72cecep-1, INEXACT) // -inf
T(RZ,                     inf,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT) // +inf
T(RZ,                    -inf,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
// Various bad cases either provided by Evgeny Gvozdev, or found during debugging
T(RD,                 0x1p-27,   0x1.fffffffffffffp-28,  -0x1.aaaaaap-1, INEXACT)
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RN,   0x1.0e8bf2684d74ap-10,   0x1.0e8bec1cbf6b2p-10,         -0x1p-1, INEXACT) // 1.032053633094292491995114247061e-03
T(RN,   0x1.1bf1bcae5b31cp-10,   0x1.1bf1b56755aa9p-10,          0x1p-1, INEXACT) // 1.083161488703860385329758031503e-03
T(RN,   0x1.1d399727fb87ap-10,   0x1.1d398fc7a37f3p-10,          0x1p-1, INEXACT) // 1.088046885338948919358381672851e-03
T(RN,   0x1.42eaa6a3f3acdp-10,   0x1.42ea9befb4b99p-10,         -0x1p-1, INEXACT) // 1.231829091000658004187440219823e-03
T(RZ,   0x1.5366237899fbdp-10,   0x1.5366170af82d3p-10,  -0x1.403eep-53, INEXACT) // 1.294704356178385433809308047159e-03
T(RN,   0x1.5ade99be87449p-10,   0x1.5ade8c7a24eacp-10,         -0x1p-1, INEXACT) // 1.323202260784544235031057191065e-03
T(RZ,   0x1.8585851c0bd7ep-10,   0x1.85857252678b8p-10,         -0x1p+0, INEXACT) // 1.485906838762790071334363162237e-03
T(RZ,   0x1.c73ba3d8ec126p-10,   0x1.c73b85db6f34dp-10,         -0x1p+0, INEXACT) // 1.736575961540928660781224479592e-03
T(RN,   0x1.ed88a100f9257p-10,   0x1.ed887aca0e9dcp-10,         -0x1p-1, INEXACT) // 1.882681681530181663428158422846e-03
T(RZ,   0x1.1c37d13879ef5p-11,   0x1.1c37cf655f4c5p-11, -0x1.5ae134p-51, INEXACT) // 5.421028827727591157051301173908e-04
T(RZ,   0x1.30ca75a5e165fp-11,   0x1.30ca7365d31f6p-11,         -0x1p+0, INEXACT) // 5.813424256621671807818141353152e-04
T(RN,   0x1.3553529c54749p-11,   0x1.355350422da98p-11,          0x1p-1, INEXACT) // 5.899915300153570118027457347409e-04
T(RZ,   0x1.6cb1225fa1e86p-11,   0x1.6cb11e84d0741p-11, -0x1.a538c4p-52, INEXACT) // 6.955946555117920992311608685554e-04
T(RZ,   0x1.d346a1414896ep-11,   0x1.d346992584118p-11, -0x1.0e7ea4p-51, INEXACT) // 8.912580453038063035137161804755e-04
T(RZ,   0x1.6d0f686dbe5c5p-12,   0x1.6d0f67764a781p-12, -0x1.f16912p-51, INEXACT) // 3.481485244801431279577930144598e-04
T(RN,   0x1.b7fb97e173afep-12,   0x1.b7fb96303c0cbp-12,          0x1p-1, INEXACT) // 4.196002829219140943181609593182e-04
T(RN,   0x1.2037ace920bcdp-13,   0x1.2037accaaf1bbp-13,         -0x1p-1, INEXACT) // 1.374328051363102375179853220644e-04
T(RZ,   0x1.8d2b0797e98bbp-13,    0x1.8d2b07483f93p-13, -0x1.ba651cp-52, INEXACT) // 1.893845007973677556974839708559e-04
T(RZ,   0x1.a8a4c8b0e53ffp-13,   0x1.a8a4c84f873cfp-13, -0x1.148828p-51, INEXACT) // 2.024858891017944091238883741468e-04
T(RZ,   0x1.c418313579dc2p-13,   0x1.c41830bffaa5ep-13,         -0x1p+0, INEXACT) // 2.155754570331969003672833995466e-04
T(RN,   0x1.e72bcc8c49b09p-14,   0x1.e72bcc6788427p-14,         -0x1p-1, INEXACT) // 1.161506390344563098429922498589e-04
T(RZ,   0x1.08a99f9f02a69p-15,   0x1.08a99f9d897b3p-15,  -0x1.00dafp-53, INEXACT) // 3.155023954811294147797598452776e-05
T(RN,   0x1.0bf7380a73616p-15,   0x1.0bf73808ebe99p-15,          0x1p-1, INEXACT) // 3.194400058568692610510425522463e-05
T(RN,   0x1.32aa2632d4be2p-15,   0x1.32aa263089ff4p-15,          0x1p-1, INEXACT) // 3.655727450415487622074200979583e-05
T(RZ,   0x1.4cda0cdf619fcp-15,   0x1.4cda0cdc735d5p-15,         -0x1p+0, INEXACT) // 3.967902170658521641792570999741e-05
T(RZ,   0x1.807beb8f2affbp-15,   0x1.807beb8aa6a2fp-15,         -0x1p+0, INEXACT) // 4.583407200561825321208017647301e-05
T(RN,   0x1.8fbdec5c5b2a9p-15,   0x1.8fbdec57479a1p-15,         -0x1p-1, INEXACT) // 4.765294645179180720766590195758e-05
T(RZ,   0x1.a51daa1391937p-15,   0x1.a51daa0da234ap-15, -0x1.6d2b16p-51, INEXACT) // 5.020092444545309694854326454383e-05
T(RN,   0x1.d6c0d157c2de4p-15,   0x1.d6c0d14f7869ap-15,          0x1p-1, INEXACT) // 5.611815384839647269550610975131e-05
T(RZ,   0x1.ada7859cc5b51p-16,   0x1.ada7859b3249bp-16,         -0x1p+0, INEXACT) // 2.560939684589518366129336224279e-05
T(RZ,   0x1.bb65b457cb60ep-16,   0x1.bb65b4560fff2p-16,  -0x1.758c3p-53, INEXACT) // 2.642853755146193941950524819440e-05
T(RZ,   0x1.2c00000014997p-17,   0x1.2bfffffff2446p-17,  -0x1.aa3a6p-55, INEXACT) // 8.940696716451530559849163182218e-06
T(RZ,   0x1.6800000023988p-17,    0x1.67ffffffe845p-17, -0x1.7dd02cp-53, INEXACT) // 1.072883605981730730741935397887e-05
T(RN,   0x1.dde13267fb699p-17,   0x1.dde1326770a48p-17,         -0x1p-1, INEXACT) // 1.424192414841854682436023821213e-05
T(RZ,   0x1.a400000038865p-17,   0x1.a3ffffffda512p-17, -0x1.18d054p-51, INEXACT) // 1.251697540322424985622610377201e-05
T(RN,   0x1.204b6133bd682p-18,   0x1.204b6133b5ca3p-18,          0x1p-1, INEXACT) // 4.295922099597389084567507222534e-06
T(RZ,   0x1.2eb99c26be168p-18,   0x1.2eb99c26b544cp-18,         -0x1p+0, INEXACT) // 4.510954602514632603375149821900e-06
T(RZ,   0x1.5f999ff1d9087p-18,   0x1.5f999ff1cb372p-18,         -0x1p+0, INEXACT) // 5.239249718378666816705115788499e-06
T(RZ,   0x1.702e98819f15bp-18,   0x1.702e98818f37fp-18,         -0x1p+0, INEXACT) // 5.486339547663576499114939516444e-06
T(RZ,   0x1.f89cee4538a2bp-18,   0x1.f89cee450fc9fp-18,         -0x1p+0, INEXACT) // 7.519319813217279970137246064565e-06
T(RN,   0x1.455e27677a95fp-19,   0x1.455e276777d92p-19,         -0x1p-1, INEXACT) // 2.424178933803689146435659737544e-06
T(RZ,   0x1.e5a7356e0b457p-19,   0x1.e5a7356e022afp-19,         -0x1p+0, INEXACT) // 3.618398003466095983322826576400e-06
T(RZ,   0x1.e7d191094421bp-19,   0x1.e7d191093ae7fp-19, -0x1.42b8fcp-51, INEXACT) // 3.634531939973823635650759453219e-06
T(RZ,   0x1.0135349c42918p-19,   0x1.0135349c41375p-19,  -0x1.bddccp-55, INEXACT) // 1.916347697532586670824891750264e-06
T(RZ,   0x1.308426053551fp-20,   0x1.3084260534c25p-20,  -0x1.e9818p-56, INEXACT) // 1.134411264748953821930046136079e-06
T(RN,   0x1.f33ea93114a7cp-20,   0x1.f33ea931122edp-20,         -0x1p-1, INEXACT) // 1.859831695112542573747934498973e-06
T(RN,   0x1.31d5eaecdbf4ep-22,   0x1.31d5eaecdbebcp-22,         -0x1p-1, INEXACT) // 2.848316132319620023178696581467e-07
T(RN,    0x1.3ca8979eaea8p-22,   0x1.3ca8979eae9dep-22,         -0x1p-1, INEXACT) // 2.949112686657790458923111831524e-07
T(RN,   0x1.5723c546739b5p-22,   0x1.5723c546738e8p-22,          0x1p-1, INEXACT) // 3.195737758005850265672503646847e-07
T(RN,   0x1.58cd2bb9c2941p-22,    0x1.58cd2bb9c287p-22,         -0x1p-1, INEXACT) // 3.211213727016866001071385920002e-07
T(RN,   0x1.a2c23fb2c706cp-22,   0x1.a2c23fb2c6ef7p-22,          0x1p-1, INEXACT) // 3.899995092858347526713165207002e-07
T(RZ,   0x1.c3226d53cde31p-22,   0x1.c3226d53cdc5dp-22,         -0x1p+0, INEXACT) // 4.201517260662560564905278984865e-07
T(RN,   0x1.e3ab6e4646d99p-22,   0x1.e3ab6e4646b59p-22,         -0x1p-1, INEXACT) // 4.504524650104511773904497704685e-07
T(RZ,   0x1.cff7e1d2ea8d1p-23,   0x1.cff7e1d2ea851p-23,         -0x1p+0, INEXACT) // 2.160520709814155155529294101771e-07
T(RN,   0x1.11733d66373c1p-24,   0x1.11733d66373bbp-24,          0x1p-1, INEXACT) // 6.366757574227333336983151177227e-08
T(RN,   0x1.540cfd6fd11c9p-24,   0x1.540cfd6fd11bdp-24,          0x1p-1, INEXACT) // 7.917423316706809320823231635247e-08
T(RZ,     0x1.7137449123fp-24,   0x1.7137449123eefp-24,         -0x1p+0, INEXACT) // 8.596477331563297046533589362838e-08
T(RZ,   0x1.9a907c24108f4p-24,   0x1.9a907c24108dep-24, -0x1.3c1eb8p-51, INEXACT) // 9.559197217213607796666989709078e-08
T(RZ,   0x1.f0e454245e4d7p-24,    0x1.f0e454245e4bp-24, -0x1.fae0fcp-52, INEXACT) // 1.156916629769850921382882600295e-07
T(RN,   0x1.daadd3a1416c6p-25,   0x1.daadd3a1416bdp-25,         -0x1p-1, INEXACT) // 5.525990976789879550501899700340e-08
T(RZ,   0x1.e3cf476542bd6p-25,   0x1.e3cf476542bccp-25,         -0x1p+0, INEXACT) // 5.632285996801587960854600751689e-08
T(RN,   0x1.3bacd6561ff5fp-25,   0x1.3bacd6561ff5dp-25,          0x1p-1, INEXACT) // 3.674942365781174210017558513612e-08
T(RN,    0x1.2771cfc99bdfdp-4,    0x1.26ef0d4a9dbfep-4,         -0x1p-1, INEXACT) // 7.213002364164107504951317650921e-02
T(RN,    0x1.19a80b6fcae78p-4,    0x1.1936b81457b4cp-4,          0x1p-1, INEXACT) // 6.876377551514589736569860178861e-02
T(RN,    0x1.7a57e6d2b8d0ap-4,    0x1.7945d817cb533p-4,          0x1p-1, INEXACT) // 9.236898579870370107336441378720e-02
T(RZ,     0x1.1126c4506168p-5,    0x1.110cde8691ec5p-5,  -0x1.4ab01p-51, INEXACT) // 3.334368078780602928645748761483e-02
T(RZ,    0x1.21645443c8ad5p-5,    0x1.214588e04d21dp-5, -0x1.a6a024p-51, INEXACT) // 3.532616098370559148955649675372e-02
T(RZ,    0x1.8ddd25ab90ca1p-5,    0x1.8d8d2d4bd6fa2p-5,         -0x1p+0, INEXACT) // 4.856736524063732379774549485774e-02
T(RN,     0x1.93acbf326ccdp-6,     0x1.9397d7f17622p-6,         -0x1p-1, INEXACT) // 2.463835403041231275622635621403e-02
T(RZ,    0x1.4978d5aa88bbfp-7,    0x1.4975fe12ed9f5p-7,         -0x1p+0, INEXACT) // 1.005468781392504333538351346533e-02
T(RN,    0x1.59de94221ecbdp-7,    0x1.59db4a6a6dfa5p-7,         -0x1p-1, INEXACT) // 1.055509789534025445745246685192e-02
T(RZ,    0x1.f44aa37b8e66bp-7,    0x1.f440b04187c86p-7,         -0x1p+0, INEXACT) // 1.526768667746410644558974212259e-02
T(RN,    0x1.9fa8cb4780236p-8,    0x1.9fa75e052e2f4p-8,          0x1p-1, INEXACT) // 6.342458370909789464042738416083e-03
T(RZ,    0x1.f19a9657fae27p-8,    0x1.f19823ade6822p-8,         -0x1p+0, INEXACT) // 7.592832283971818162215949854499e-03
T(RZ,    0x1.fd2ac95e57ef9p-8,    0x1.fd2829febc039p-8,         -0x1p+0, INEXACT) // 7.769273912657353488298017651914e-03
T(RZ,    0x1.cd30a9499618bp-8,    0x1.cd2eb65f92a45p-8,         -0x1p+0, INEXACT) // 7.037202196066859143097627082852e-03
T(RZ,    0x1.0393435ab5021p-9,    0x1.03932d1d5c628p-9, -0x1.7ce75cp-51, INEXACT) // 1.980401966060100094751961208317e-03
T(RN,    0x1.129deef7602dfp-9,    0x1.129dd4a1d42ffp-9,          0x1p-1, INEXACT) // 2.095160885517407655526112009170e-03
T(RN,    0x1.1e6676c7797a9p-9,    0x1.1e6658e85b954p-9,         -0x1p-1, INEXACT) // 2.185060500539532952340993077200e-03
T(RN,    0x1.2770c46b918efp-9,    0x1.2770a3a135a49p-9,          0x1p-1, INEXACT) // 2.254032113145780068935719597789e-03
T(RN,   0x1.7c1cb888d1887p+48,    0x1.921fb54442d0ep+0,          0x1p-1, INEXACT) // 4.179377736134484375000000000000e+14
T(RN,   0x1.a2fecc1637629p+48,    0x1.921fb54442d0fp+0,          0x1p-1, INEXACT) // 4.606902061115865625000000000000e+14
T(RZ,   0x1.197b7e0796822p+49,    0x1.921fb54442d11p+0, -0x1.65acfap-52, INEXACT) // 6.189863256179242500000000000000e+14
T(RN,   0x1.0f340846f421fp+50,    0x1.921fb54442d14p+0,         -0x1p-1, INEXACT) // 1.192764513177735750000000000000e+15
T(RN,   0x1.70e83d4441252p+50,    0x1.921fb54442d16p+0,          0x1p-1, INEXACT) // 1.622470957270164500000000000000e+15
T(RZ,   0x1.d02967c31cdb5p+53,    0x1.921fb54442d18p+0,   -0x1.300dp-58, INEXACT) // 1.633123935319537000000000000000e+16
T(RZ,    0x1.68c2df4e923d2p-1,    0x1.3a45e1a0e87a1p-1, -0x1.12774cp-51, INEXACT) // 7.046117576038517515968351290212e-01
T(RZ,    0x1.fbf265d896256p-1,    0x1.9016d91c29a5dp-1,         -0x1p+0, INEXACT) // 9.920837237251116658143246240797e-01
T(RN,    0x1.8681ca04027e2p-2,    0x1.7512efd047259p-2,         -0x1p-1, INEXACT) // 3.813544812152241947345032713201e-01
T(RZ,    0x1.ab6053b7254e6p-2,    0x1.94dedf69ac729p-2, -0x1.50f55ap-51, INEXACT) // 4.173596458943634734950478559767e-01
T(RN,    0x1.cdc639501624bp-2,     0x1.b1cff78328acp-2,          0x1p-1, INEXACT) // 4.509514765864294782993226817780e-01
T(RN,    0x1.ed48930f781e8p-2,    0x1.cbb158baef5d4p-2,         -0x1p-1, INEXACT) // 4.817221620742473398024685593555e-01
T(RN,    0x1.48da7b1b53485p-3,    0x1.4611ed2d35d96p-3,          0x1p-1, INEXACT) // 1.605729692186380896945507856799e-01
T(RZ,    0x1.cfdaa0fe98c4dp-3,    0x1.c8286c9c7b27ap-3,         -0x1p+0, INEXACT) // 2.264912202545893704641599697425e-01
T(RN,    0x1.1fa60deea7c08p-3,    0x1.1dc77b9b2f59dp-3,         -0x1p-1, INEXACT) // 1.404534424263774727847930989810e-01
T(RN,    0x1.19a80b6fcae78p-4,    0x1.1936b81457b4cp-4,          0x1p-1, INEXACT) // 6.876377551514589736569860178861e-02
T(RN,    0x1.7a57e6d2b8d0ap-4,    0x1.7945d817cb533p-4,          0x1p-1, INEXACT) // 9.236898579870370107336441378720e-02
T(RN,    0x1.2771cfc99bdfdp-4,    0x1.26ef0d4a9dbfep-4,         -0x1p-1, INEXACT) // 7.213002364164107504951317650921e-02
T(RZ,    0x1.3d54e1e32c6dcp+0,    0x1.c8afe27275483p-1,         -0x1p+0, INEXACT) // 1.239576452219288249523287959164e+00
T(RN,    0x1.528a66c8019afp+0,    0x1.d8c0fb21fa037p-1,          0x1p-1, INEXACT) // 1.322424339131980763895057862101e+00
T(RZ,     0x1.ff648ab43e89p+0,    0x1.1b4efa2a1ebcap+0, -0x1.468be2p-51, INEXACT) // 1.997627896313620254886700422503e+00
T(RN,    0x1.6298b5896ed3cp+1,    0x1.3970e827504c7p+0,          0x1p-1, INEXACT) // 2.770285312753598461199544544797e+00
T(RN,    0x1.80589910b944dp+1,    0x1.3fd32b40fc999p+0,          0x1p-1, INEXACT) // 3.002703793683883848331106491969e+00
T(RN,    0x1.80e8d3a5df50cp+1,    0x1.3fefee16c346ep+0,          0x1p-1, INEXACT) // 3.007105308525416020870579814073e+00
T(RZ,    0x1.bf58c60072375p+1,    0x1.4ac7c92a74e9ep+0,         -0x1p+0, INEXACT) // 3.494896650522088865642444943660e+00
T(RN,     0x1.d955ccc243ccp+1,    0x1.4e83588b6747dp+0,          0x1p-1, INEXACT) // 3.697930903297304894294939003885e+00
T(RN,   0x1.203430f6d2e6ep+10,     0x1.91e6dc044f21p+0,         -0x1p-1, INEXACT) // 1.152815488534888118010712787509e+03
T(RN,   0x1.0e15cc38a7496p+11,    0x1.9201607c7ca5ep+0,          0x1p-1, INEXACT) // 2.160681179358226472686510533094e+03
T(RZ,   0x1.13e7000c9aad2p+11,    0x1.920204336eec9p+0,         -0x1p+0, INEXACT) // 2.207218756010152901581022888422e+03
T(RZ,   0x1.3729dbd0a371cp+11,    0x1.9205618e729d9p+0, -0x1.8fe388p-53, INEXACT) // 2.489308082885005205753259360790e+03
T(RZ,   0x1.706a0a1d4ead8p+11,    0x1.920978e43b5a3p+0, -0x1.e8f686p-52, INEXACT) // 2.947313734677951288176700472832e+03
T(RZ,   0x1.d9cbc1a79c8e8p+11,    0x1.920e6afd60094p+0,         -0x1p+0, INEXACT) // 3.790367389493727387161925435066e+03
T(RZ,   0x1.b847ea2083824p+11,    0x1.920d1a0da3df4p+0,         -0x1p+0, INEXACT) // 3.522247329956868270528502762318e+03
T(RN,   0x1.71a8c77cfe778p+12,    0x1.9214a0aa5bc7dp+0,         -0x1p-1, INEXACT) // 5.914548703187952924054116010666e+03
T(RZ,   0x1.901567508259cp+13,    0x1.921a96d20ff05p+0, -0x1.52901cp-51, INEXACT) // 1.280267544652782817138358950615e+04
T(RN,   0x1.cbbc07de2b592p+13,    0x1.921b40da15c51p+0,          0x1p-1, INEXACT) // 1.471150384172311532893218100071e+04
T(RZ,   0x1.18b96a925a6d8p+14,    0x1.921c0f741e745p+0, -0x1.4ca5e8p-54, INEXACT) // 1.796635407391827902756631374359e+04
T(RZ,   0x1.95b8fa630bd98p+14,    0x1.921d2f2677889p+0,         -0x1p+0, INEXACT) // 2.596624451845660223625600337982e+04
T(RN,   0x1.8fbbb2f3364e5p+14,     0x1.921d25781f41p+0,          0x1p-1, INEXACT) // 2.558292475590565663878805935383e+04
T(RZ,   0x1.a106949c9f896p+14,    0x1.921d40a9a73c2p+0, -0x1.6a504cp-53, INEXACT) // 2.668964512872005434473976492882e+04
T(RZ,   0x1.f38e708939066p+14,    0x1.921da88359c0dp+0,         -0x1p+0, INEXACT) // 3.197160989846326265251263976097e+04
T(RN,   0x1.170ffa1513b35p+15,    0x1.921ddf9460501p+0,         -0x1p-1, INEXACT) // 3.571998844205440400401130318642e+04
T(RZ,   0x1.4128ab1df1b41p+15,    0x1.921e1d2506c14p+0,         -0x1p+0, INEXACT) // 4.110833421283076313557103276253e+04
T(RN,   0x1.a2572652907d4p+15,    0x1.921e7bf3d2e3ep+0,         -0x1p-1, INEXACT) // 5.354757484866646700538694858551e+04
T(RN,   0x1.ce32c57f6c973p+15,    0x1.921e99aec8e67p+0,         -0x1p-1, INEXACT) // 5.916138573779435682808980345726e+04
T(RZ,   0x1.e2087d054e979p+15,    0x1.921ea55a0ba49p+0,         -0x1p+0, INEXACT) // 6.170024418111419799970462918282e+04
T(RZ,   0x1.258a867272716p+16,    0x1.921ed601b1073p+0,         -0x1p+0, INEXACT) // 7.514652518382327980361878871918e+04
T(RN,   0x1.26ede99f07165p+16,    0x1.921ed70eb7cebp+0,          0x1p-1, INEXACT) // 7.550191258281988848466426134109e+04
T(RZ,   0x1.2b3d56967323fp+17,    0x1.921f47c32e184p+0,         -0x1p+0, INEXACT) // 1.532106764663625217508524656296e+05
T(RZ,   0x1.9a96819c25effp+17,    0x1.921f657589b4fp+0,         -0x1p+0, INEXACT) // 2.102210125777646608185023069382e+05
T(RZ,   0x1.bf22ad6ca18bep+17,    0x1.921f6bfb7c446p+0,         -0x1p+0, INEXACT) // 2.289333548776562674902379512787e+05
T(RN,   0x1.0457f5b9aab52p+18,    0x1.921f76559ceb8p+0,         -0x1p-1, INEXACT) // 2.665918394572037504985928535461e+05
T(RZ,   0x1.0316c31646daep+18,    0x1.921f76079838ap+0,         -0x1p+0, INEXACT) // 2.653070482346665812656283378601e+05
T(RN,   0x1.8a6ff209ab215p+18,    0x1.921f8bba9f0d2p+0,          0x1p-1, INEXACT) // 4.039037818401170079596340656281e+05
T(RN,   0x1.53913a1d23e18p+19,    0x1.921f9d244e949p+0,         -0x1p-1, INEXACT) // 6.954338160571483895182609558105e+05
T(RN,   0x1.e2c8a43e5ead4p+19,    0x1.921fa44c62f8cp+0,          0x1p-1, INEXACT) // 9.887411326135047711431980133057e+05
T(RZ,    0x1.7c1feea123664p+2,    0x1.676c35d7ce031p+0,  -0x1.a8b65p-51, INEXACT) // 5.939448983537293003109880373813e+00
T(RN,    0x1.a364b47b3943fp+2,    0x1.6b5b639f90f3bp+0,          0x1p-1, INEXACT) // 6.553021545730245200900299096247e+00
T(RZ,    0x1.d5081f1c67944p+2,    0x1.6f681f3fa8459p+0,         -0x1p+0, INEXACT) // 7.328620698679802814012873568572e+00
T(RZ,   0x1.0d560dd815869p+20,    0x1.921fa60f12f09p+0, -0x1.6a04ccp-51, INEXACT) // 1.103200865254903445020318031311e+06
T(RN,   0x1.6072bb7991581p+20,    0x1.921fa9a523d08p+0,          0x1p-1, INEXACT) // 1.443627717179626459255814552307e+06
T(RZ,   0x1.7580866571185p+20,    0x1.921faa4cd8122p+0,         -0x1p+0, INEXACT) // 1.529864399766058893874287605286e+06
T(RN,   0x1.4c607a014111fp+20,    0x1.921fa8f17b0afp+0,          0x1p-1, INEXACT) // 1.361415625306196277961134910583e+06
T(RZ,   0x1.9086ccb05d85dp+20,    0x1.921fab0a44707p+0,         -0x1p+0, INEXACT) // 1.640556793057940201833844184875e+06
T(RN,   0x1.fe6ea806a00b3p+20,    0x1.921fad3df8836p+0,          0x1p-1, INEXACT) // 2.090730501617473317310214042664e+06
T(RN,   0x1.b860c0b74f607p+20,    0x1.921fabf72dd1cp+0,          0x1p-1, INEXACT) // 1.803788044753433903679251670837e+06
T(RN,   0x1.6b26dcb445f11p+21,    0x1.921fafa08b92ap+0,         -0x1p-1, INEXACT) // 2.974939588024028111249208450317e+06
T(RN,   0x1.e2f147b138f55p+21,    0x1.921fb106a63d1p+0,          0x1p-1, INEXACT) // 3.956264961534420493990182876587e+06
T(RZ,   0x1.a4fc8d4fabe62p+23,    0x1.921fb40cea87ap+0, -0x1.8f0494p-53, INEXACT) // 1.379488665560835972428321838379e+07
T(RZ,   0x1.ae7b19e121e4bp+23,     0x1.921fb413c86cp+0,         -0x1p+0, INEXACT) // 1.410599693971171043813228607178e+07
T(RN,   0x1.da40ad480d9a5p+23,    0x1.921fb42fe296cp+0,          0x1p-1, INEXACT) // 1.554031064072878099977970123291e+07
T(RN,   0x1.fa560e17afa06p+23,    0x1.921fb44165bc8p+0,         -0x1p-1, INEXACT) // 1.659162304626179859042167663574e+07
T(RN,   0x1.7e4c88f66a1b6p+24,    0x1.921fb498d5c02p+0,         -0x1p-1, INEXACT) // 2.505434496255656331777572631836e+07
T(RZ,   0x1.b99e9866202e8p+24,    0x1.921fb4afdc9cfp+0, -0x1.a1fb76p-52, INEXACT) // 2.894197639892855286598205566406e+07
T(RZ,   0x1.8e99a3b25dc1ap+25,     0x1.921fb4f20da6p+0, -0x1.4e2698p-51, INEXACT) // 5.224531939348621666431427001953e+07
T(RZ,   0x1.f0f30948c2833p+25,    0x1.921fb502529c8p+0,         -0x1p+0, INEXACT) // 6.513614656843604892492294311523e+07
T(RZ,   0x1.647c748304b78p+26,    0x1.921fb5164d21fp+0,         -0x1p+0, INEXACT) // 9.345070604716289043426513671875e+07
T(RN,   0x1.afed4b292250dp+27,    0x1.921fb5314b7a9p+0,          0x1p-1, INEXACT) // 2.264541052854389250278472900391e+08
T(RZ,   0x1.5af194f910d9ep+27,    0x1.921fb52ca62bep+0,         -0x1p+0, INEXACT) // 1.818984077833070158958435058594e+08
T(RZ,   0x1.c83ee64d0c6e4p+27,     0x1.921fb5324e47p+0,         -0x1p+0, INEXACT) // 2.392041464077674150466918945312e+08
T(RZ,   0x1.662d5e80107bbp+28,    0x1.921fb538d348dp+0, -0x1.ecceb6p-52, INEXACT) // 3.755760400040242075920104980469e+08
T(RN,   0x1.5f327148e1dcep+28,    0x1.921fb53899194p+0,          0x1p-1, INEXACT) // 3.682567885551422834396362304688e+08
T(RZ,   0x1.909a58812a46cp+28,    0x1.921fb53a0952ep+0, -0x1.e3b70cp-51, INEXACT) // 4.200626000728213787078857421875e+08
T(RN,   0x1.f7126514d2503p+28,    0x1.921fb53c1e78dp+0,         -0x1p-1, INEXACT) // 5.275090733013460040092468261719e+08
T(RZ,   0x1.38725fed885e1p+29,    0x1.921fb53db4cfap+0,  -0x1.4fed2p-51, INEXACT) // 6.552483816915856599807739257812e+08
T(RZ,   0x1.56f0ac66eeefbp+29,    0x1.921fb53e4a03dp+0,         -0x1p+0, INEXACT) // 7.191975808666681051254272460938e+08
T(RN,   0x1.7c9223f5c7c98p+29,    0x1.921fb53ee12edp+0,          0x1p-1, INEXACT) // 7.981149427225522994995117187500e+08
T(RN,    0x1.257598c10d197p+3,    0x1.76518559e4c65p+0,          0x1p-1, INEXACT) // 9.170605065396371102792727469932e+00
T(RN,    0x1.2c81b90b43dfap+3,    0x1.76f7307b27bc2p+0,          0x1p-1, INEXACT) // 9.390835306169709184587190975435e+00
T(RN,    0x1.4446ee1903875p+3,    0x1.78f16aea1098ap+0,          0x1p-1, INEXACT) // 1.013365845571045475992377760122e+01
T(RN,    0x1.8b1c41029a7c7p+3,    0x1.7d6f815b90cb5p+0,         -0x1p-1, INEXACT) // 1.234719896801460770063840755029e+01
T(RN,    0x1.a3f9a3843f2d4p+3,     0x1.7ea7d2da46cfp+0,          0x1p-1, INEXACT) // 1.312422347859811821990660973825e+01
T(RZ,    0x1.ab579e245e68ep+3,    0x1.7efd6b91aba4fp+0,         -0x1p+0, INEXACT) // 1.335444552520064220857420878019e+01
T(RN,    0x1.acc9f1aa021f2p+3,    0x1.7f0de25941eb6p+0,          0x1p-1, INEXACT) // 1.339965136723273886332208348904e+01
T(RZ,   0x1.153ba1e4c2dabp+30,    0x1.921fb540913edp+0, -0x1.9711d2p-51, INEXACT) // 1.162799225190287351608276367188e+09
T(RN,   0x1.e3e277333bcadp+30,    0x1.921fb5422511cp+0,         -0x1p-1, INEXACT) // 2.029559244808390855789184570312e+09
T(RN,    0x1.b80a0ae7fb3dp+30,     0x1.921fb541ef17p+0,          0x1p-1, INEXACT) // 1.845658297995349884033203125000e+09
T(RN,   0x1.59f08c2476e5ep+31,    0x1.921fb542c7ee7p+0,         -0x1p-1, INEXACT) // 2.901952018232222557067871093750e+09
T(RZ,   0x1.704de1d109112p+31,    0x1.921fb542def05p+0,  -0x1.0cbe5p-53, INEXACT) // 3.089559784517708778381347656250e+09
T(RZ,   0x1.757bcc69420e6p+32,    0x1.921fb5439358ap+0,  -0x1.d3cefp-55, INEXACT) // 6.266014825258031845092773437500e+09
T(RZ,   0x1.7b7861bc1d314p+32,    0x1.921fb543961d4p+0,         -0x1p+0, INEXACT) // 6.366454204114032745361328125000e+09
T(RZ,   0x1.b5bf3b4f3f0fbp+33,    0x1.921fb543f7f65p+0,         -0x1p+0, INEXACT) // 1.468835190249266624450683593750e+10
T(RZ,   0x1.06ced4085d0dfp+34,    0x1.921fb5440479fp+0,  -0x1.33f92p-53, INEXACT) // 1.763674115345397567749023437500e+10
T(RN,   0x1.0c7b15d00aae5p+34,    0x1.921fb54405cb3p+0,          0x1p-1, INEXACT) // 1.801744160016688919067382812500e+10
T(RZ,   0x1.4095761acd227p+34,    0x1.921fb5440fb63p+0,   -0x1.0c9ap-51, INEXACT) // 2.151401687520522689819335937500e+10
T(RZ,   0x1.53ffe2325fdb5p+34,    0x1.921fb54412a14p+0,         -0x1p+0, INEXACT) // 2.281698324149776077270507812500e+10
T(RZ,   0x1.75ca3d402ebfcp+34,    0x1.921fb54416fc7p+0,         -0x1p+0, INEXACT) // 2.508462208073045349121093750000e+10
T(RZ,   0x1.c9c484d522dd1p+34,    0x1.921fb5441f06fp+0,         -0x1p+0, INEXACT) // 3.072026709254474258422851562500e+10
T(RZ,    0x1.089b022446c4p+35,    0x1.921fb54423dbep+0,         -0x1p+0, INEXACT) // 3.551474921821142578125000000000e+10
T(RN,   0x1.596e6c4427792p+35,    0x1.921fb5442b1a7p+0,          0x1p-1, INEXACT) // 4.636300956923353576660156250000e+10
T(RN,   0x1.9e1c38f4ce613p+35,    0x1.921fb5442f095p+0,          0x1p-1, INEXACT) // 5.558093610244936370849609375000e+10
T(RN,    0x1.76ab3efdffb6p+36,    0x1.921fb54437e2dp+0,         -0x1p-1, INEXACT) // 1.005744250559819335937500000000e+11
T(RN,   0x1.d7e566639b6e1p+36,    0x1.921fb5443a238p+0,          0x1p-1, INEXACT) // 1.266736430657143707275390625000e+11
T(RZ,   0x1.01a6267d1f5ccp+37,    0x1.921fb5443ade9p+0,         -0x1p+0, INEXACT) // 1.383242669159202880859375000000e+11
T(RZ,   0x1.0959cdff5a188p+37,    0x1.921fb5443b19bp+0, -0x1.3d3ac2p-52, INEXACT) // 1.424591257392619628906250000000e+11
T(RN,   0x1.46f7b61809a1cp+37,    0x1.921fb5443c8e1p+0,          0x1p-1, INEXACT) // 1.755394055692039794921875000000e+11
T(RN,   0x1.f10ce6735ecd8p+37,    0x1.921fb5443eb2cp+0,          0x1p-1, INEXACT) // 2.668518969398503417968750000000e+11
T(RN,   0x1.fe5b26460dbb7p+37,    0x1.921fb5443ece4p+0,          0x1p-1, INEXACT) // 2.739953194897165222167968750000e+11
T(RZ,    0x1.0303e1e046a9p+38,    0x1.921fb5443edd6p+0,         -0x1p+0, INEXACT) // 2.781154160816650390625000000000e+11
T(RN,    0x1.095d8286d87ap+38,    0x1.921fb5443ef5ap+0,         -0x1p-1, INEXACT) // 2.849337921821191406250000000000e+11
T(RN,   0x1.4430c4a2d8a22p+38,    0x1.921fb5443fa8ep+0,         -0x1p-1, INEXACT) // 3.480968992541583251953125000000e+11
T(RN,   0x1.97f9b6546683ap+38,    0x1.921fb544404efp+0,         -0x1p-1, INEXACT) // 4.380602913536285400390625000000e+11
T(RN,    0x1.f33764075e1ep+38,    0x1.921fb54440c47p+0,          0x1p-1, INEXACT) // 5.360294957675292968750000000000e+11
T(RN,   0x1.6f7c0c5690c4fp+39,    0x1.921fb544416cep+0,          0x1p-1, INEXACT) // 7.891670905043846435546875000000e+11
T(RN,    0x1.42feddb3e669dp+4,     0x1.8573f320b5edp+0,          0x1p-1, INEXACT) // 2.018722315095384445271520235110e+01
T(RZ,    0x1.6876fc222add7p+4,    0x1.86c4a929c2845p+0, -0x1.086428p-51, INEXACT) // 2.252904904696137222686047607567e+01
T(RN,    0x1.aa3911ff9d2d7p+4,    0x1.8884b4412c284p+0,          0x1p-1, INEXACT) // 2.663893318032463852773616963532e+01
T(RZ,    0x1.ba4b8e383bbfep+4,    0x1.88ddfb05c4073p+0, -0x1.f47c5ep-51, INEXACT) // 2.764344617811365623083474929444e+01
T(RZ,    0x1.e5dfb44d08a74p+4,    0x1.89b25d19b3586p+0,         -0x1p+0, INEXACT) // 3.036711530772522849019878776744e+01
T(RN,   0x1.013509c6cf5dbp+40,    0x1.921fb54441d2cp+0,          0x1p-1, INEXACT) // 1.104696428239365966796875000000e+12
T(RZ,   0x1.ae66b4b034f85p+40,    0x1.921fb54442394p+0, -0x1.c46ab4p-52, INEXACT) // 1.848559054900969970703125000000e+12
T(RN,   0x1.79c2767d98151p+40,     0x1.921fb5444224p+0,         -0x1p-1, INEXACT) // 1.622465215896082275390625000000e+12
T(RZ,   0x1.12be8e3d2df0ap+41,    0x1.921fb544425a3p+0,         -0x1p+0, INEXACT) // 2.360036063835879882812500000000e+12
T(RZ,   0x1.a3ac6e00a01d7p+41,    0x1.921fb54442836p+0,         -0x1p+0, INEXACT) // 3.604968374592229980468750000000e+12
T(RN,   0x1.b84a871453212p+41,    0x1.921fb54442871p+0,         -0x1p-1, INEXACT) // 3.782071953574258789062500000000e+12
T(RZ,   0x1.3b59f7327350fp+42,    0x1.921fb544429d9p+0, -0x1.161808p-51, INEXACT) // 5.417696283085264648437500000000e+12
T(RZ,   0x1.d30cdeb9957f4p+42,    0x1.921fb54442ae7p+0, -0x1.81f75cp-53, INEXACT) // 8.023862601301988281250000000000e+12
T(RN,   0x1.808075148de2ap+42,    0x1.921fb54442a6ep+0,         -0x1p-1, INEXACT) // 6.605690393143541015625000000000e+12
T(RN,   0x1.0860a9733324ep+43,    0x1.921fb54442b28p+0,         -0x1p-1, INEXACT) // 9.083944671641152343750000000000e+12
T(RZ,   0x1.1057c325c6b23p+43,    0x1.921fb54442b36p+0,         -0x1p+0, INEXACT) // 9.357628091957568359375000000000e+12
T(RZ,   0x1.82542c540f642p+43,    0x1.921fb54442bc4p+0,         -0x1p+0, INEXACT) // 1.327415654002712890625000000000e+13
T(RZ,   0x1.282c65254ec5bp+44,    0x1.921fb54442c3bp+0,  -0x1.d118ap-51, INEXACT) // 2.035288233290835546875000000000e+13
T(RN,   0x1.4b5d7bae33cafp+44,    0x1.921fb54442c53p+0,          0x1p-1, INEXACT) // 2.277124098540468359375000000000e+13
T(RN,   0x1.929d7ebab9a8ap+44,    0x1.921fb54442c75p+0,         -0x1p-1, INEXACT) // 2.766750689986653906250000000000e+13
T(RZ,   0x1.b9fcbd4949f1fp+44,    0x1.921fb54442c83p+0,         -0x1p+0, INEXACT) // 3.037313345654312109375000000000e+13
T(RZ,   0x1.c31d4dd5bcbbep+44,    0x1.921fb54442c87p+0, -0x1.24a724p-53, INEXACT) // 3.100035025197974218750000000000e+13
T(RZ,   0x1.c9695fd56b9adp+44,    0x1.921fb54442c89p+0, -0x1.4e5d38p-52, INEXACT) // 3.143308708012167578125000000000e+13
T(RZ,   0x1.57ed8ee958604p+45,    0x1.921fb54442cb8p+0,         -0x1p+0, INEXACT) // 4.726909915418803125000000000000e+13
T(RN,   0x1.30ac2c8e4db6bp+46,    0x1.921fb54442ce2p+0,         -0x1p-1, INEXACT) // 8.374775418558167187500000000000e+13
T(RZ,   0x1.a1272504460ffp+46,     0x1.921fb54442cfp+0,         -0x1p+0, INEXACT) // 1.146661183860519843750000000000e+14
T(RZ,   0x1.838cf6838a195p+46,    0x1.921fb54442cedp+0,         -0x1p+0, INEXACT) // 1.065291077966143281250000000000e+14
T(RZ,   0x1.05ed93e058b67p+47,    0x1.921fb54442cf9p+0, -0x1.416b78p-53, INEXACT) // 1.439964615261072187500000000000e+14
T(RN,    0x1.9279b0d88bccap+5,    0x1.8d09388fe401bp+0,          0x1p-1, INEXACT) // 5.030941933800347953820164548233e+01
T(RZ,    0x1.d39625758196dp+5,    0x1.8dbe8da44673bp+0,         -0x1p+0, INEXACT) // 5.844831363488888342772042960860e+01
T(RZ,    0x1.7537689be17dap+6,    0x1.8f6157f6ff53bp+0,         -0x1p+0, INEXACT) // 9.330410998882089756989444140345e+01
T(RZ,    0x1.7cc3be002d9bcp+6,    0x1.8f6f441cf6672p+0,         -0x1p+0, INEXACT) // 9.519115448263522694105631671846e+01
T(RN,    0x1.aeb3a96a241a6p+6,    0x1.8fbf14ec45282p+0,         -0x1p-1, INEXACT) // 1.076754509529624499464262044057e+02
T(RZ,    0x1.2337a9249980dp+8,    0x1.913eaadfd9e01p+0,         -0x1p+0, INEXACT) // 2.912174246668590171793766785413e+02
T(RZ,    0x1.3f9d988745a6cp+8,     0x1.9152a995609bp+0, -0x1.12989cp-51, INEXACT) // 3.196156086487815173313720151782e+02
T(RN,    0x1.46382091d2939p+8,    0x1.9156d029bd2b7p+0,         -0x1p-1, INEXACT) // 3.262192469729521349108836147934e+02
T(RZ,    0x1.f1b8434891c62p+8,    0x1.919c0927df64ap+0, -0x1.cd7062p-52, INEXACT) // 4.977197766643422482957248575985e+02
T(RZ,    0x1.48cc2e72cc7d8p+9,    0x1.91bc0c4cff433p+0, -0x1.2f6fc4p-51, INEXACT) // 6.575951674936759445699863135815e+02
T(RZ,    0x1.6d52464f87b6bp+9,    0x1.91c6030303485p+0,  -0x1.607bbp-51, INEXACT) // 7.306427707111992049249238334596e+02
T(RN,    0x1.f09755d3f5835p+9,    0x1.91ddb8e3a7004p+0,         -0x1p-1, INEXACT) // 9.931823067616265916512929834425e+02
// The following are Sun's value distributed with libmcr 0.9
T(RN,    0x1.c9489adac26bap-2,    0x1.ae130e3029e0bp-2,  -0x1.ff5672p-2, INEXACT)
T(RN,   0x1.60ff1f2637968p+32,    0x1.921fb54389298p+0,  -0x1.ff6218p-2, INEXACT)
T(RN,  -0x1.705bb52f4cb9dp+25,   -0x1.921fb4eb4ddb5p+0,  -0x1.ffd742p-2, INEXACT)
T(RZ,    -0x1.7b876e00c113p+3,   -0x1.7c9713af298a3p+0,   0x1.ffa22ep-1, INEXACT)
T(RU,    -0x1.7b876e00c113p+3,   -0x1.7c9713af298a3p+0,   0x1.ffa22ep-1, INEXACT)
T(RD,    -0x1.7b876e00c113p+3,   -0x1.7c9713af298a4p+0, -0x1.7747fcp-11, INEXACT)
T(RZ,  -0x1.1452676e709c4p+22,   -0x1.921fb18f9201ap+0,   0x1.ffa11ap-1, INEXACT)
T(RU,  -0x1.1452676e709c4p+22,   -0x1.921fb18f9201ap+0,   0x1.ffa11ap-1, INEXACT)
T(RD,  -0x1.1452676e709c4p+22,   -0x1.921fb18f9201bp+0, -0x1.7b95a4p-11, INEXACT)
T(RN,  -0x1.4a092e11bf5a1p+52,   -0x1.921fb54442d18p+0,  -0x1.ffe7b6p-2, INEXACT)
T(RN,   -0x1.4d8f288486b4ep+8,   -0x1.915b3bda4f504p+0,  -0x1.ff58fcp-2, INEXACT)
T(RZ,  -0x1.30d1452484bfdp+23,   -0x1.921fb3964267cp+0,   0x1.ffb364p-1, INEXACT)
T(RU,  -0x1.30d1452484bfdp+23,   -0x1.921fb3964267cp+0,   0x1.ffb364p-1, INEXACT)
T(RD,  -0x1.30d1452484bfdp+23,   -0x1.921fb3964267dp+0, -0x1.326de8p-11, INEXACT)
T(RZ,   0x1.a5f200cc9117ap+42,    0x1.921fb54442aabp+0, -0x1.f6f724p-11, INEXACT)
T(RD,   0x1.a5f200cc9117ap+42,    0x1.921fb54442aabp+0, -0x1.f6f724p-11, INEXACT)
T(RU,   0x1.a5f200cc9117ap+42,    0x1.921fb54442aacp+0,   0x1.ff8242p-1, INEXACT)
T(RZ,    0x1.daa534ce33aa4p-4,    0x1.d889a9983ae22p-4, -0x1.a2050cp-12, INEXACT)
T(RD,    0x1.daa534ce33aa4p-4,    0x1.d889a9983ae22p-4, -0x1.a2050cp-12, INEXACT)
T(RU,    0x1.daa534ce33aa4p-4,    0x1.d889a9983ae23p-4,    0x1.ffcbcp-1, INEXACT)
T(RZ,   0x1.7c1a48ed7585fp+32,    0x1.921fb5439666dp+0,  -0x1.fff06ep-1, INEXACT)
T(RD,   0x1.7c1a48ed7585fp+32,    0x1.921fb5439666dp+0,  -0x1.fff06ep-1, INEXACT)
T(RU,   0x1.7c1a48ed7585fp+32,    0x1.921fb5439666ep+0,   0x1.f25a2p-14, INEXACT)
T(RZ,   0x1.1c02a46f0ee95p+21,    0x1.921fae0e3e5c2p+0, -0x1.623a34p-11, INEXACT)
T(RD,   0x1.1c02a46f0ee95p+21,    0x1.921fae0e3e5c2p+0, -0x1.623a34p-11, INEXACT)
T(RU,   0x1.1c02a46f0ee95p+21,    0x1.921fae0e3e5c3p+0,   0x1.ffa772p-1, INEXACT)
T(RZ,   0x1.c65e40acae367p+36,    0x1.921fb54439cdbp+0,  -0x1.ffbd68p-1, INEXACT)
T(RD,   0x1.c65e40acae367p+36,    0x1.921fb54439cdbp+0,  -0x1.ffbd68p-1, INEXACT)
T(RU,   0x1.c65e40acae367p+36,    0x1.921fb54439cdcp+0,  0x1.0a5e6ap-11, INEXACT)
T(RZ,  -0x1.bd37f46444f22p+22,   -0x1.921fb2f7766b1p+0,   0x1.ffa534p-1, INEXACT)
T(RU,  -0x1.bd37f46444f22p+22,   -0x1.921fb2f7766b1p+0,   0x1.ffa534p-1, INEXACT)
T(RD,  -0x1.bd37f46444f22p+22,   -0x1.921fb2f7766b2p+0, -0x1.6b31e8p-11, INEXACT)
T(RN,   0x1.820391a7f89cbp+44,    0x1.921fb54442c6ep+0,  -0x1.ff80b4p-2, INEXACT)
T(RN,   0x1.b6c6967ad8767p+40,    0x1.921fb544423c2p+0,  -0x1.ff19f2p-2, INEXACT)
T(RN,  -0x1.aceade334a2e9p+49,   -0x1.921fb54442d14p+0,  -0x1.ff05cep-2, INEXACT)
T(RN,  -0x1.519a6017a9f96p+38,   -0x1.921fb5443fc91p+0,  -0x1.ff01fap-2, INEXACT)
T(RZ,  -0x1.424e65cdf30acp+18,    -0x1.921f826ed945p+0,  0x1.beaa54p-13, INEXACT)
T(RU,  -0x1.424e65cdf30acp+18,    -0x1.921f826ed945p+0,  0x1.beaa54p-13, INEXACT)
T(RD,  -0x1.424e65cdf30acp+18,   -0x1.921f826ed9451p+0,  -0x1.ffe416p-1, INEXACT)
T(RZ,    0x1.1700ca32c12f8p+8,    0x1.9134d0cc6601bp+0, -0x1.d87a38p-11, INEXACT)
T(RD,    0x1.1700ca32c12f8p+8,    0x1.9134d0cc6601bp+0, -0x1.d87a38p-11, INEXACT)
T(RU,    0x1.1700ca32c12f8p+8,    0x1.9134d0cc6601cp+0,   0x1.ff89e2p-1, INEXACT)
T(RN,  -0x1.76ae5c2266311p+20,   -0x1.921faa55adaa4p+0,  -0x1.ffb5c8p-2, INEXACT)
T(RN,   0x1.2d5a7a8b601b6p+35,    0x1.921fb54427a26p+0,  -0x1.ff0208p-2, INEXACT)
T(RN,    0x1.ee7e21a690298p+3,    0x1.819498a35311ap+0,  -0x1.ff1b94p-2, INEXACT)
T(RN,   0x1.eb5e5eb50e163p+11,    0x1.920f0949246fdp+0,  -0x1.ff9f1ap-2, INEXACT)
T(RZ,   0x1.781b0cf7aa7e7p+27,    0x1.921fb52e7ada7p+0,  -0x1.ff880ep-1, INEXACT)
T(RD,   0x1.781b0cf7aa7e7p+27,    0x1.921fb52e7ada7p+0,  -0x1.ff880ep-1, INEXACT)
T(RU,   0x1.781b0cf7aa7e7p+27,    0x1.921fb52e7ada8p+0,  0x1.dfc832p-11, INEXACT)
T(RN,   0x1.24f440e87a9f4p+27,    0x1.921fb5284c2e9p+0,  -0x1.ffdb8ep-2, INEXACT)
T(RZ,  -0x1.88186681b3565p+18,   -0x1.921f8b7b1b5dfp+0,  0x1.348d22p-11, INEXACT)
T(RU,  -0x1.88186681b3565p+18,   -0x1.921f8b7b1b5dfp+0,  0x1.348d22p-11, INEXACT)
T(RD,  -0x1.88186681b3565p+18,    -0x1.921f8b7b1b5ep+0,  -0x1.ffb2dcp-1, INEXACT)
T(RZ,   0x1.0e0285f3e0897p+34,    0x1.921fb5440623ap+0, -0x1.89650ep-11, INEXACT)
T(RD,   0x1.0e0285f3e0897p+34,    0x1.921fb5440623ap+0, -0x1.89650ep-11, INEXACT)
T(RU,   0x1.0e0285f3e0897p+34,    0x1.921fb5440623bp+0,   0x1.ff9da6p-1, INEXACT)
T(RZ,    0x1.6530c0fddf078p+1,    0x1.3a09066fbb5ecp+0,  -0x1.fa39ap-13, INEXACT)
T(RD,    0x1.6530c0fddf078p+1,    0x1.3a09066fbb5ecp+0,  -0x1.fa39ap-13, INEXACT)
T(RU,    0x1.6530c0fddf078p+1,    0x1.3a09066fbb5edp+0,   0x1.ffe05cp-1, INEXACT)
T(RZ,    0x1.edbb376173ef4p+8,    0x1.919af8daff3c2p+0, -0x1.39f112p-12, INEXACT)
T(RD,    0x1.edbb376173ef4p+8,    0x1.919af8daff3c2p+0, -0x1.39f112p-12, INEXACT)
T(RU,    0x1.edbb376173ef4p+8,    0x1.919af8daff3c3p+0,   0x1.ffd8c2p-1, INEXACT)
T(RZ,   0x1.c9d9da0ad2ec1p+43,    0x1.921fb54442bf9p+0,  -0x1.ff9936p-1, INEXACT)
T(RD,   0x1.c9d9da0ad2ec1p+43,    0x1.921fb54442bf9p+0,  -0x1.ff9936p-1, INEXACT)
T(RU,   0x1.c9d9da0ad2ec1p+43,    0x1.921fb54442bfap+0,  0x1.9b2acap-11, INEXACT)
T(RN,    0x1.621293c9c8aeep+6,    0x1.8f3b5f1ec48d5p+0,  -0x1.fff75cp-2, INEXACT)
T(RN,   0x1.e5136f1523651p+46,    0x1.921fb54442cf6p+0,  -0x1.ff999ap-2, INEXACT)
T(RZ,   -0x1.31a43f7354055p+7,   -0x1.9072df3dcdcbap+0,   0x1.ffb7f6p-1, INEXACT)
T(RU,   -0x1.31a43f7354055p+7,   -0x1.9072df3dcdcbap+0,   0x1.ffb7f6p-1, INEXACT)
T(RD,   -0x1.31a43f7354055p+7,   -0x1.9072df3dcdcbbp+0, -0x1.2025f2p-11, INEXACT)
T(RZ,  -0x1.56b20b27b05ebp+20,   -0x1.921fa95078bc6p+0,   0x1.ffe52ep-1, INEXACT)
T(RU,  -0x1.56b20b27b05ebp+20,   -0x1.921fa95078bc6p+0,   0x1.ffe52ep-1, INEXACT)
T(RD,  -0x1.56b20b27b05ebp+20,   -0x1.921fa95078bc7p+0, -0x1.ad1674p-13, INEXACT)
T(RZ,    0x1.59d27180a3306p+6,    0x1.8f29b5dbb8b53p+0, -0x1.1dfdbap-11, INEXACT)
T(RD,    0x1.59d27180a3306p+6,    0x1.8f29b5dbb8b53p+0, -0x1.1dfdbap-11, INEXACT)
T(RU,    0x1.59d27180a3306p+6,    0x1.8f29b5dbb8b54p+0,    0x1.ffb88p-1, INEXACT)
T(RN,   0x1.12e9cc461329ap+43,    0x1.921fb54442b3bp+0,  -0x1.fff30ap-2, INEXACT)
T(RN,   -0x1.6cdb2b0cf82cp+38,   -0x1.921fb54440031p+0,  -0x1.ff6b0cp-2, INEXACT)
T(RN,   -0x1.74e98e8891345p+0,   -0x1.f03a7c421c337p-1,  -0x1.ff9e4ap-2, INEXACT)
T(RN,   -0x1.9ddc590ff16b3p+2,   -0x1.6ad8c6ac26eafp+0,  -0x1.ffa74cp-2, INEXACT)
T(RN,  -0x1.beeac40a5743ep+35,   -0x1.921fb544307d1p+0,  -0x1.ff919ap-2, INEXACT)
T(RN,  -0x1.5921486a117bep+43,   -0x1.921fb54442b9dp+0,  -0x1.fff518p-2, INEXACT)
T(RZ,    0x1.c04a07355ae6dp+4,    0x1.88fda38f5e8afp+0,  -0x1.ffe2cap-1, INEXACT)
T(RD,    0x1.c04a07355ae6dp+4,    0x1.88fda38f5e8afp+0,  -0x1.ffe2cap-1, INEXACT)
T(RU,    0x1.c04a07355ae6dp+4,     0x1.88fda38f5e8bp+0,  0x1.d35508p-13, INEXACT)
T(RZ,  -0x1.6c45a0aac7154p+41,   -0x1.921fb54442778p+0,   0x1.ffc564p-1, INEXACT)
T(RU,  -0x1.6c45a0aac7154p+41,   -0x1.921fb54442778p+0,   0x1.ffc564p-1, INEXACT)
T(RD,  -0x1.6c45a0aac7154p+41,   -0x1.921fb54442779p+0, -0x1.d4e54ap-12, INEXACT)
T(RZ,    0x1.fe29be026ecf3p+1,    0x1.533146475a2d9p+0,  -0x1.ffd058p-1, INEXACT)
T(RD,    0x1.fe29be026ecf3p+1,    0x1.533146475a2d9p+0,  -0x1.ffd058p-1, INEXACT)
T(RU,    0x1.fe29be026ecf3p+1,    0x1.533146475a2dap+0,  0x1.7d45b6p-12, INEXACT)
T(RZ,   0x1.64685f2c5114ap+38,     0x1.921fb5443ff2p+0, -0x1.6f7c2ep-12, INEXACT)
T(RD,   0x1.64685f2c5114ap+38,     0x1.921fb5443ff2p+0, -0x1.6f7c2ep-12, INEXACT)
T(RU,   0x1.64685f2c5114ap+38,    0x1.921fb5443ff21p+0,    0x1.ffd21p-1, INEXACT)
T(RZ,   0x1.fce1a27ed2127p+41,    0x1.921fb54442912p+0, -0x1.48937ep-12, INEXACT)
T(RD,   0x1.fce1a27ed2127p+41,    0x1.921fb54442912p+0, -0x1.48937ep-12, INEXACT)
T(RU,   0x1.fce1a27ed2127p+41,    0x1.921fb54442913p+0,   0x1.ffd6eep-1, INEXACT)
T(RN,   0x1.38a518579b406p+39,    0x1.921fb544412e4p+0,  -0x1.ffad76p-2, INEXACT)
T(RN,  -0x1.309bd489c8ca9p+14,   -0x1.921c58ac8ef16p+0,   -0x1.ffb4fp-2, INEXACT)
T(RN,  -0x1.dfb0b5a8a0422p+38,   -0x1.921fb54440af1p+0,   -0x1.ffa0ap-2, INEXACT)
T(RZ,    0x1.3fde4de78ded2p+2,    0x1.5f9201b475302p+0, -0x1.df41a4p-13, INEXACT)
T(RD,    0x1.3fde4de78ded2p+2,    0x1.5f9201b475302p+0, -0x1.df41a4p-13, INEXACT)
T(RU,    0x1.3fde4de78ded2p+2,    0x1.5f9201b475303p+0,   0x1.ffe20cp-1, INEXACT)
T(RZ,  -0x1.99e0464aaae6bp+40,   -0x1.921fb5444231ap+0,  0x1.e0a67ap-15, INEXACT)
T(RU,  -0x1.99e0464aaae6bp+40,   -0x1.921fb5444231ap+0,  0x1.e0a67ap-15, INEXACT)
T(RD,  -0x1.99e0464aaae6bp+40,   -0x1.921fb5444231bp+0,  -0x1.fff87ep-1, INEXACT)
T(RN,   0x1.251a07c8ae1b6p+24,    0x1.921fb464aa8f5p+0,   -0x1.ff979p-2, INEXACT)
T(RN,   0x1.2b8ecb0b083acp+44,    0x1.921fb54442c3dp+0,  -0x1.fff202p-2, INEXACT)
T(RN,  -0x1.be27abe9d4aa6p+22,   -0x1.921fb2f8b2c6fp+0,   -0x1.ff916p-2, INEXACT)
T(RZ,   0x1.4165c0339936bp+41,    0x1.921fb544426b8p+0,  -0x1.ffd4e2p-1, INEXACT)
T(RD,   0x1.4165c0339936bp+41,    0x1.921fb544426b8p+0,  -0x1.ffd4e2p-1, INEXACT)
T(RU,   0x1.4165c0339936bp+41,    0x1.921fb544426b9p+0,  0x1.58eaaep-12, INEXACT)
T(RN,  -0x1.28636d449a5cap+28,   -0x1.921fb53670f96p+0,  -0x1.ffee6cp-2, INEXACT)
T(RZ,   0x1.f2ba929c764b7p+12,    0x1.92177ec4ee85bp+0,  -0x1.ffd5eap-1, INEXACT)
T(RD,   0x1.f2ba929c764b7p+12,    0x1.92177ec4ee85bp+0,  -0x1.ffd5eap-1, INEXACT)
T(RU,   0x1.f2ba929c764b7p+12,    0x1.92177ec4ee85cp+0,  0x1.50aadep-12, INEXACT)
T(RZ,   0x1.0309cdcdcc0e4p+34,    0x1.921fb5440391ap+0,  -0x1.ffc71cp-1, INEXACT)
T(RD,   0x1.0309cdcdcc0e4p+34,    0x1.921fb5440391ap+0,  -0x1.ffc71cp-1, INEXACT)
T(RU,   0x1.0309cdcdcc0e4p+34,    0x1.921fb5440391bp+0,  0x1.c71a04p-12, INEXACT)
T(RN,   0x1.79bc9a8961a13p+38,    0x1.921fb544401b8p+0,   -0x1.fff3bp-2, INEXACT)
T(RZ,   0x1.cc2d39a60e097p+39,    0x1.921fb54441b4ap+0,  -0x1.fff044p-1, INEXACT)
T(RD,   0x1.cc2d39a60e097p+39,    0x1.921fb54441b4ap+0,  -0x1.fff044p-1, INEXACT)
T(RU,   0x1.cc2d39a60e097p+39,    0x1.921fb54441b4bp+0,  0x1.f76ed6p-14, INEXACT)
T(RN,  -0x1.c64811d25b537p+28,   -0x1.921fb53b3e9c7p+0,  -0x1.ff8732p-2, INEXACT)
T(RN,   0x1.d12e838b8b8efp+10,    0x1.91fc7cc832b9ep+0,  -0x1.ff9d5ep-2, INEXACT)
T(RZ,   0x1.89385fb412f34p+39,    0x1.921fb54441842p+0,  -0x1.ffc376p-1, INEXACT)
T(RD,   0x1.89385fb412f34p+39,    0x1.921fb54441842p+0,  -0x1.ffc376p-1, INEXACT)
T(RU,   0x1.89385fb412f34p+39,    0x1.921fb54441843p+0,  0x1.e457eap-12, INEXACT)
T(RZ,  -0x1.ddf0cd4ab82d7p+35,   -0x1.921fb54431ad9p+0,   0x1.ffd59cp-1, INEXACT)
T(RU,  -0x1.ddf0cd4ab82d7p+35,   -0x1.921fb54431ad9p+0,   0x1.ffd59cp-1, INEXACT)
T(RD,  -0x1.ddf0cd4ab82d7p+35,   -0x1.921fb54431adap+0, -0x1.53228cp-12, INEXACT)
T(RZ,  -0x1.41b7673874582p+26,   -0x1.921fb511558c3p+0,   0x1.ffd104p-1, INEXACT)
T(RU,  -0x1.41b7673874582p+26,   -0x1.921fb511558c3p+0,   0x1.ffd104p-1, INEXACT)
T(RD,  -0x1.41b7673874582p+26,   -0x1.921fb511558c4p+0, -0x1.77debep-12, INEXACT)
T(RZ,  -0x1.3ade5548f3e7ap+43,   -0x1.921fb54442b78p+0,  0x1.942c06p-12, INEXACT)
T(RU,  -0x1.3ade5548f3e7ap+43,   -0x1.921fb54442b78p+0,  0x1.942c06p-12, INEXACT)
T(RD,  -0x1.3ade5548f3e7ap+43,   -0x1.921fb54442b79p+0,  -0x1.ffcd7ap-1, INEXACT)
T(RN,  -0x1.03dbf751b364ep+17,   -0x1.921f372ae863fp+0,   -0x1.ffdedp-2, INEXACT)
T(RZ,   -0x1.32df7180a378p+28,   -0x1.921fb536e9d88p+0,   0x1.ffc96cp-1, INEXACT)
T(RU,   -0x1.32df7180a378p+28,   -0x1.921fb536e9d88p+0,   0x1.ffc96cp-1, INEXACT)
T(RD,   -0x1.32df7180a378p+28,   -0x1.921fb536e9d89p+0, -0x1.b49df4p-12, INEXACT)
T(RZ,    0x1.9a0337d64fc81p-1,    0x1.59b805506b809p-1,  -0x1.ffdc12p-1, INEXACT)
T(RD,    0x1.9a0337d64fc81p-1,    0x1.59b805506b809p-1,  -0x1.ffdc12p-1, INEXACT)
T(RU,    0x1.9a0337d64fc81p-1,    0x1.59b805506b80ap-1,  0x1.1f6ebep-12, INEXACT)
T(RZ,  -0x1.15e883914cfa1p+42,   -0x1.921fb54442969p+0,  0x1.d5cd94p-12, INEXACT)
T(RU,  -0x1.15e883914cfa1p+42,   -0x1.921fb54442969p+0,  0x1.d5cd94p-12, INEXACT)
T(RD,  -0x1.15e883914cfa1p+42,   -0x1.921fb5444296ap+0,  -0x1.ffc546p-1, INEXACT)
T(RZ,  -0x1.32df7180f1cc4p+28,   -0x1.921fb536e9d89p+0,  0x1.b3902ap-12, INEXACT)
T(RU,  -0x1.32df7180f1cc4p+28,   -0x1.921fb536e9d89p+0,  0x1.b3902ap-12, INEXACT)
T(RD,  -0x1.32df7180f1cc4p+28,   -0x1.921fb536e9d8ap+0,  -0x1.ffc98ep-1, INEXACT)
T(RZ,  -0x1.d9a8aa6d12135p+24,   -0x1.921fb4b9e65adp+0,   0x1.ffc8f2p-1, INEXACT)
T(RU,  -0x1.d9a8aa6d12135p+24,   -0x1.921fb4b9e65adp+0,   0x1.ffc8f2p-1, INEXACT)
T(RD,  -0x1.d9a8aa6d12135p+24,   -0x1.921fb4b9e65aep+0, -0x1.b8698cp-12, INEXACT)
T(RN,  -0x1.abda64418799fp+16,   -0x1.921f1c17b2e45p+0,  -0x1.ffb0fep-2, INEXACT)
T(RN,   0x1.629040d281c6dp+49,    0x1.921fb54442d12p+0,  -0x1.ffa41ep-2, INEXACT)
T(RN,   0x1.1544c57fe7a59p+20,     0x1.921fa67e74abp+0,  -0x1.ffb428p-2, INEXACT)
T(RN,    0x1.c84b01d2f3161p+7,    0x1.910074b5037e8p+0,  -0x1.fffd74p-2, INEXACT)
T(RN,  -0x1.44048517b8932p+20,   -0x1.921fa8a017786p+0,  -0x1.fffc08p-2, INEXACT)
T(RN,  -0x1.ebe65b7073dd1p+22,   -0x1.921fb32f56e9bp+0,  -0x1.ffb3b6p-2, INEXACT)
T(RN,  -0x1.36512354cfadbp+36,   -0x1.921fb544359e8p+0,  -0x1.ffc70ep-2, INEXACT)
T(RN,   0x1.9d275401c5c4dp+34,    0x1.921fb5441b299p+0,  -0x1.ffca88p-2, INEXACT)
T(RZ,  -0x1.0c1a92caa8549p+29,    -0x1.921fb53c9f47p+0,  0x1.e7b2bep-13, INEXACT)
T(RU,  -0x1.0c1a92caa8549p+29,    -0x1.921fb53c9f47p+0,  0x1.e7b2bep-13, INEXACT)
T(RD,  -0x1.0c1a92caa8549p+29,   -0x1.921fb53c9f471p+0,  -0x1.ffe184p-1, INEXACT)
T(RZ,  -0x1.54190535dd9ddp+29,   -0x1.921fb53e3d3cep+0,   0x1.ffe63cp-1, INEXACT)
T(RU,  -0x1.54190535dd9ddp+29,   -0x1.921fb53e3d3cep+0,   0x1.ffe63cp-1, INEXACT)
T(RD,  -0x1.54190535dd9ddp+29,   -0x1.921fb53e3d3cfp+0, -0x1.9c395ep-13, INEXACT)
T(RN,   -0x1.283ffcc3a4955p+8,   -0x1.91427d85017a3p+0,  -0x1.ffcfa2p-2, INEXACT)
T(RZ,   0x1.6cc77d599a592p+21,    0x1.921fafa6fc7e2p+0, -0x1.fd8d32p-16, INEXACT)
T(RD,   0x1.6cc77d599a592p+21,    0x1.921fafa6fc7e2p+0, -0x1.fd8d32p-16, INEXACT)
T(RU,   0x1.6cc77d599a592p+21,    0x1.921fafa6fc7e3p+0,   0x1.fffc04p-1, INEXACT)
T(RN,   0x1.49f38563a098fp+52,    0x1.921fb54442d17p+0,  -0x1.ffe426p-2, INEXACT)
T(RZ,   0x1.c025af4d6a0eep+16,    0x1.921f23076b5a1p+0,  -0x1.fffc5ep-1, INEXACT)
T(RD,   0x1.c025af4d6a0eep+16,    0x1.921f23076b5a1p+0,  -0x1.fffc5ep-1, INEXACT)
T(RU,   0x1.c025af4d6a0eep+16,    0x1.921f23076b5a2p+0,  0x1.d14392p-16, INEXACT)
T(RN,   -0x1.507690ec4cf32p-1,   -0x1.29abbcbd6d13cp-1,   -0x1.fff7bp-2, INEXACT)
T(RZ,    0x1.d7df6a60850a9p+1,    0x1.4e502c90466e1p+0, -0x1.4bb38ep-13, INEXACT)
T(RD,    0x1.d7df6a60850a9p+1,    0x1.4e502c90466e1p+0, -0x1.4bb38ep-13, INEXACT)
T(RU,    0x1.d7df6a60850a9p+1,    0x1.4e502c90466e2p+0,   0x1.ffeb44p-1, INEXACT)
T(RZ,    0x1.ec3e36ceb68b7p+2,    0x1.710670d421dd9p+0,  -0x1.fff232p-1, INEXACT)
T(RD,    0x1.ec3e36ceb68b7p+2,    0x1.710670d421dd9p+0,  -0x1.fff232p-1, INEXACT)
T(RU,    0x1.ec3e36ceb68b7p+2,    0x1.710670d421ddap+0,  0x1.b9de1cp-14, INEXACT)
T(RZ,    0x1.741c30172ae6ep+0,    0x1.efb6ba59fa434p-1,  -0x1.ffe742p-1, INEXACT)
T(RD,    0x1.741c30172ae6ep+0,    0x1.efb6ba59fa434p-1,  -0x1.ffe742p-1, INEXACT)
T(RU,    0x1.741c30172ae6ep+0,    0x1.efb6ba59fa435p-1,  0x1.8bd6a2p-13, INEXACT)
T(RZ,  -0x1.413a4e110d336p+40,   -0x1.921fb54442057p+0,   0x1.fff47ap-1, INEXACT)
T(RU,  -0x1.413a4e110d336p+40,   -0x1.921fb54442057p+0,   0x1.fff47ap-1, INEXACT)
T(RD,  -0x1.413a4e110d336p+40,   -0x1.921fb54442058p+0, -0x1.70c3bcp-14, INEXACT)
T(RZ,   0x1.25852a894789cp+44,    0x1.921fb54442c38p+0,  -0x1.ffe694p-1, INEXACT)
T(RD,   0x1.25852a894789cp+44,    0x1.921fb54442c38p+0,  -0x1.ffe694p-1, INEXACT)
T(RU,   0x1.25852a894789cp+44,    0x1.921fb54442c39p+0,  0x1.96b516p-13, INEXACT)
T(RZ,   -0x1.045d322441742p+5,   -0x1.8a42ab2a07ca1p+0,  0x1.ff95a6p-18, INEXACT)
T(RU,   -0x1.045d322441742p+5,   -0x1.8a42ab2a07ca1p+0,  0x1.ff95a6p-18, INEXACT)
T(RD,   -0x1.045d322441742p+5,   -0x1.8a42ab2a07ca2p+0,    -0x1.ffffp-1, INEXACT)
T(RZ,    0x1.d0fb1c3d5eb1p+13,    0x1.921b4db82126ap+0,  -0x1.ffed5ep-1, INEXACT)
T(RD,    0x1.d0fb1c3d5eb1p+13,    0x1.921b4db82126ap+0,  -0x1.ffed5ep-1, INEXACT)
T(RU,    0x1.d0fb1c3d5eb1p+13,    0x1.921b4db82126bp+0,  0x1.2a1c8cp-13, INEXACT)
T(RN,   0x1.49fcb5ad63094p+52,    0x1.921fb54442d17p+0,  -0x1.fffa46p-2, INEXACT)
T(RZ,  -0x1.c1ea9fae32467p+50,   -0x1.921fb54442d15p+0,   0x1.ffe438p-1, INEXACT)
T(RU,  -0x1.c1ea9fae32467p+50,   -0x1.921fb54442d15p+0,   0x1.ffe438p-1, INEXACT)
T(RD,  -0x1.c1ea9fae32467p+50,   -0x1.921fb54442d16p+0, -0x1.bc7704p-13, INEXACT)
T(RZ,  -0x1.b434501ef600cp+17,   -0x1.921f6a255901dp+0,    0x1.57cap-13, INEXACT)
T(RU,  -0x1.b434501ef600cp+17,   -0x1.921f6a255901dp+0,    0x1.57cap-13, INEXACT)
T(RD,  -0x1.b434501ef600cp+17,   -0x1.921f6a255901ep+0,  -0x1.ffea84p-1, INEXACT)
T(RZ,   0x1.d8a784aa026c8p+27,    0x1.921fb532edd9ep+0, -0x1.357888p-13, INEXACT)
T(RD,   0x1.d8a784aa026c8p+27,    0x1.921fb532edd9ep+0, -0x1.357888p-13, INEXACT)
T(RU,   0x1.d8a784aa026c8p+27,    0x1.921fb532edd9fp+0,   0x1.ffeca8p-1, INEXACT)
T(RZ,   0x1.4680d310c7eeap+33,    0x1.921fb543de753p+0,  -0x1.ffeca4p-1, INEXACT)
T(RD,   0x1.4680d310c7eeap+33,    0x1.921fb543de753p+0,  -0x1.ffeca4p-1, INEXACT)
T(RU,   0x1.4680d310c7eeap+33,    0x1.921fb543de754p+0,  0x1.35c384p-13, INEXACT)
T(RZ,  -0x1.42f5301ef7ed3p+35,   -0x1.921fb5442973fp+0,  0x1.416cccp-14, INEXACT)
T(RU,  -0x1.42f5301ef7ed3p+35,   -0x1.921fb5442973fp+0,  0x1.416cccp-14, INEXACT)
T(RD,  -0x1.42f5301ef7ed3p+35,    -0x1.921fb5442974p+0,  -0x1.fff5f4p-1, INEXACT)
T(RZ,    0x1.c54387f25c3f9p+5,    0x1.8d9b2211698c7p+0, -0x1.8cef9ap-13, INEXACT)
T(RD,    0x1.c54387f25c3f9p+5,    0x1.8d9b2211698c7p+0, -0x1.8cef9ap-13, INEXACT)
T(RU,    0x1.c54387f25c3f9p+5,    0x1.8d9b2211698c8p+0,   0x1.ffe732p-1, INEXACT)
T(RZ,    0x1.694fb8412f491p+9,    0x1.91c5042aee742p+0,  -0x1.ffee4ap-1, INEXACT)
T(RD,    0x1.694fb8412f491p+9,    0x1.91c5042aee742p+0,  -0x1.ffee4ap-1, INEXACT)
T(RU,    0x1.694fb8412f491p+9,    0x1.91c5042aee743p+0,  0x1.1b6a7ap-13, INEXACT)
T(RZ,  -0x1.8b41dc3923a1bp+34,   -0x1.921fb544195dfp+0,  0x1.0e3cfep-16, INEXACT)
T(RU,  -0x1.8b41dc3923a1bp+34,   -0x1.921fb544195dfp+0,  0x1.0e3cfep-16, INEXACT)
T(RD,  -0x1.8b41dc3923a1bp+34,    -0x1.921fb544195ep+0,  -0x1.fffde4p-1, INEXACT)
T(RN,   0x1.b44df002e210dp+47,    0x1.921fb54442d05p+0,  -0x1.ffe206p-2, INEXACT)
T(RZ,   0x1.6e4b37fb03ecdp+19,    0x1.921f9ee6ef0bep+0,  -0x1.ffe012p-1, INEXACT)
T(RD,   0x1.6e4b37fb03ecdp+19,    0x1.921f9ee6ef0bep+0,  -0x1.ffe012p-1, INEXACT)
T(RU,   0x1.6e4b37fb03ecdp+19,    0x1.921f9ee6ef0bfp+0,  0x1.fed162p-13, INEXACT)
T(RN,    0x1.8585021e10a86p+8,    0x1.917775cca25f3p+0,  -0x1.ffd048p-2, INEXACT)
T(RN,  -0x1.f522168d9d2b9p+44,   -0x1.921fb54442c96p+0,   -0x1.ffda2p-2, INEXACT)
T(RN,  -0x1.bac9668b61af3p+19,   -0x1.921fa2c400db6p+0,  -0x1.ffed38p-2, INEXACT)
T(RN,   0x1.acd0455dab4c3p+49,    0x1.921fb54442d13p+0,  -0x1.ffcaeep-2, INEXACT)
T(RN,   0x1.8aafa553496ddp+31,     0x1.921fb542f6bap+0,  -0x1.fff1b6p-2, INEXACT)
T(RN,   0x1.81418053f5a0fp+19,    0x1.921fa000bb0adp+0,  -0x1.ffc83ap-2, INEXACT)
T(RN,   -0x1.0b16ab3e47263p+9,   -0x1.91a505b6502fep+0,   -0x1.ffd62p-2, INEXACT)
T(RN,   -0x1.e94785c71262p+42,   -0x1.921fb54442b01p+0,  -0x1.ffec08p-2, INEXACT)
T(RN,   0x1.0162fa60e491ep+26,    0x1.921fb5049b15bp+0,  -0x1.ffd588p-2, INEXACT)
T(RN,   0x1.d9c89f46abe0dp+29,    0x1.921fb53ff0387p+0,  -0x1.ffe5acp-2, INEXACT)
T(RN,   0x1.6ea63a3a23edap+39,     0x1.921fb544416cp+0,  -0x1.ffcd76p-2, INEXACT)
T(RN,   -0x1.64c242e8b734fp+8,   -0x1.9168029e63377p+0,  -0x1.ffcc38p-2, INEXACT)
T(RN,   -0x1.bf6014ca24df6p+0,   -0x1.0d118ad357c48p+0,  -0x1.fffa82p-2, INEXACT)
T(RN,   0x1.2954dc3c39dddp+48,    0x1.921fb54442d0ap+0,   -0x1.ffe4ap-2, INEXACT)
T(RZ,   0x1.3ad61eb5e3c23p+14,    0x1.921c74a18c292p+0, -0x1.41b20cp-15, INEXACT)
T(RD,   0x1.3ad61eb5e3c23p+14,    0x1.921c74a18c292p+0, -0x1.41b20cp-15, INEXACT)
T(RU,   0x1.3ad61eb5e3c23p+14,    0x1.921c74a18c293p+0,   0x1.fffafap-1, INEXACT)
T(RZ,  -0x1.cb083faf103e1p+38,   -0x1.921fb54440966p+0,   0x1.fffeb6p-1, INEXACT)
T(RU,  -0x1.cb083faf103e1p+38,   -0x1.921fb54440966p+0,   0x1.fffeb6p-1, INEXACT)
T(RD,  -0x1.cb083faf103e1p+38,   -0x1.921fb54440967p+0, -0x1.4aa756p-17, INEXACT)
T(RZ,   0x1.2ad0e38bbcfcdp+42,    0x1.921fb544429abp+0, -0x1.2e8df6p-15, INEXACT)
T(RD,   0x1.2ad0e38bbcfcdp+42,    0x1.921fb544429abp+0, -0x1.2e8df6p-15, INEXACT)
T(RU,   0x1.2ad0e38bbcfcdp+42,    0x1.921fb544429acp+0,   0x1.fffb46p-1, INEXACT)
T(RZ,    0x1.3cd09c9a3c682p+1,    0x1.2fd3f62a0c5acp+0,  -0x1.fff59ep-1, INEXACT)
T(RD,    0x1.3cd09c9a3c682p+1,    0x1.2fd3f62a0c5acp+0,  -0x1.fff59ep-1, INEXACT)
T(RU,    0x1.3cd09c9a3c682p+1,    0x1.2fd3f62a0c5adp+0,  0x1.4c34f8p-14, INEXACT)
T(RZ,   -0x1.abd1f3866e139p+5,   -0x1.8d565d2705abdp+0,  0x1.f7fce4p-14, INEXACT)
T(RU,   -0x1.abd1f3866e139p+5,   -0x1.8d565d2705abdp+0,  0x1.f7fce4p-14, INEXACT)
T(RD,   -0x1.abd1f3866e139p+5,   -0x1.8d565d2705abep+0,   -0x1.fff04p-1, INEXACT)
T(RN,   0x1.b44e100401abfp+47,    0x1.921fb54442d05p+0,  -0x1.ffe788p-2, INEXACT)
T(RN,  -0x1.574f14b33cbe6p+26,   -0x1.921fb5148987bp+0,  -0x1.fffc86p-2, INEXACT)
T(RZ,  -0x1.b94e86094576fp+13,   -0x1.921b113b360dep+0,   0x1.fff1ccp-1, INEXACT)
T(RU,  -0x1.b94e86094576fp+13,   -0x1.921b113b360dep+0,   0x1.fff1ccp-1, INEXACT)
T(RD,  -0x1.b94e86094576fp+13,   -0x1.921b113b360dfp+0, -0x1.c674aap-14, INEXACT)
T(RZ,  -0x1.11d86e4eb1234p+36,   -0x1.921fb54433dc6p+0,   0x1.fff63ep-1, INEXACT)
T(RU,  -0x1.11d86e4eb1234p+36,   -0x1.921fb54433dc6p+0,   0x1.fff63ep-1, INEXACT)
T(RD,  -0x1.11d86e4eb1234p+36,   -0x1.921fb54433dc7p+0, -0x1.3824aap-14, INEXACT)
T(RZ,  -0x1.0ad1b8019abc2p+18,   -0x1.921f77dc9d0c7p+0,  0x1.318f52p-14, INEXACT)
T(RU,  -0x1.0ad1b8019abc2p+18,   -0x1.921f77dc9d0c7p+0,  0x1.318f52p-14, INEXACT)
T(RD,  -0x1.0ad1b8019abc2p+18,   -0x1.921f77dc9d0c8p+0,  -0x1.fff674p-1, INEXACT)
T(RZ,  -0x1.c3a68a890184ap+46,   -0x1.921fb54442cf3p+0,   0x1.fff734p-1, INEXACT)
T(RU,  -0x1.c3a68a890184ap+46,   -0x1.921fb54442cf3p+0,   0x1.fff734p-1, INEXACT)
T(RD,  -0x1.c3a68a890184ap+46,   -0x1.921fb54442cf4p+0, -0x1.197a14p-14, INEXACT)
T(RN,    0x1.7d44bdd246987p-5,    0x1.7cfe5bc6597cap-5,  -0x1.ffe54ep-2, INEXACT)
T(RZ,  -0x1.197a6da29c4a9p+49,    -0x1.921fb54442d1p+0,   0x1.fff1ecp-1, INEXACT)
T(RU,  -0x1.197a6da29c4a9p+49,    -0x1.921fb54442d1p+0,   0x1.fff1ecp-1, INEXACT)
T(RD,  -0x1.197a6da29c4a9p+49,   -0x1.921fb54442d11p+0, -0x1.c29f28p-14, INEXACT)
T(RZ,   -0x1.d97e10ede987cp+3,   -0x1.80d951a6b1817p+0,  0x1.303c72p-16, INEXACT)
T(RU,   -0x1.d97e10ede987cp+3,   -0x1.80d951a6b1817p+0,  0x1.303c72p-16, INEXACT)
T(RD,   -0x1.d97e10ede987cp+3,   -0x1.80d951a6b1818p+0,   -0x1.fffdap-1, INEXACT)
T(RN,   -0x1.48319740fa39bp+0,   -0x1.d113aa95cbf7bp-1,  -0x1.ffe47ap-2, INEXACT)
T(RZ,   -0x1.be2cba11b8781p+9,   -0x1.91d64419fb5f6p+0,  0x1.9f2a56p-14, INEXACT)
T(RU,   -0x1.be2cba11b8781p+9,   -0x1.91d64419fb5f6p+0,  0x1.9f2a56p-14, INEXACT)
T(RD,   -0x1.be2cba11b8781p+9,   -0x1.91d64419fb5f7p+0,  -0x1.fff306p-1, INEXACT)
T(RN,  -0x1.205476395e6d6p+51,   -0x1.921fb54442d17p+0,  -0x1.fffa1ep-2, INEXACT)
T(RZ,  -0x1.33f965bbef0f1p+22,   -0x1.921fb1f112a64p+0,  0x1.d8189ap-15, INEXACT)
T(RU,  -0x1.33f965bbef0f1p+22,   -0x1.921fb1f112a64p+0,  0x1.d8189ap-15, INEXACT)
T(RD,  -0x1.33f965bbef0f1p+22,   -0x1.921fb1f112a65p+0,   -0x1.fff8ap-1, INEXACT)
T(RN,   0x1.52e983af67da4p+29,    0x1.921fb53e37d86p+0,  -0x1.ffee12p-2, INEXACT)
T(RZ,  -0x1.4e1d8324754e1p+16,   -0x1.921ef11e68331p+0,  0x1.7a497ep-14, INEXACT)
T(RU,  -0x1.4e1d8324754e1p+16,   -0x1.921ef11e68331p+0,  0x1.7a497ep-14, INEXACT)
T(RD,  -0x1.4e1d8324754e1p+16,   -0x1.921ef11e68332p+0,  -0x1.fff42ep-1, INEXACT)
T(RN,   0x1.5aa9926ae55adp+40,    0x1.921fb54442147p+0,  -0x1.fffe14p-2, INEXACT)
T(RZ,   -0x1.d0304ef2b803ep+4,   -0x1.894da89eac712p+0,  0x1.8e4be8p-15, INEXACT)
T(RU,   -0x1.d0304ef2b803ep+4,   -0x1.894da89eac712p+0,  0x1.8e4be8p-15, INEXACT)
T(RD,   -0x1.d0304ef2b803ep+4,   -0x1.894da89eac713p+0,  -0x1.fff9c6p-1, INEXACT)
T(RN,  -0x1.e2601cc4cd77bp+40,   -0x1.921fb5444249bp+0,   -0x1.ffeaap-2, INEXACT)
T(RN,  -0x1.402cb39a9467ap+27,   -0x1.921fb52aaccafp+0,  -0x1.ffe5eap-2, INEXACT)
T(RN,   0x1.339c58aa8eadcp+40,    0x1.921fb54441fc7p+0,  -0x1.fffb86p-2, INEXACT)
T(RZ,   -0x1.bc8ba00e759fp+13,   -0x1.921b19e2f660cp+0,   0x1.fffdbep-1, INEXACT)
T(RU,   -0x1.bc8ba00e759fp+13,   -0x1.921b19e2f660cp+0,   0x1.fffdbep-1, INEXACT)
T(RD,   -0x1.bc8ba00e759fp+13,   -0x1.921b19e2f660dp+0, -0x1.20e434p-16, INEXACT)
T(RN,  -0x1.adf831925bfafp+32,    -0x1.921fb543aa66p+0,  -0x1.ffe8d2p-2, INEXACT)
T(RZ,  -0x1.9fb9e54b1643ep+40,   -0x1.921fb5444233ep+0,  0x1.e3ecdep-17, INEXACT)
T(RU,  -0x1.9fb9e54b1643ep+40,   -0x1.921fb5444233ep+0,  0x1.e3ecdep-17, INEXACT)
T(RD,  -0x1.9fb9e54b1643ep+40,   -0x1.921fb5444233fp+0,  -0x1.fffe1cp-1, INEXACT)
T(RN,  -0x1.4bbdce6252b54p+45,   -0x1.921fb54442cb6p+0,  -0x1.fff508p-2, INEXACT)
T(RZ,   0x1.197ab5a556938p+49,     0x1.921fb54442d1p+0,  -0x1.fff5a4p-1, INEXACT)
T(RD,   0x1.197ab5a556938p+49,     0x1.921fb54442d1p+0,  -0x1.fff5a4p-1, INEXACT)
T(RU,   0x1.197ab5a556938p+49,    0x1.921fb54442d11p+0,  0x1.4b7e4ap-14, INEXACT)
T(RZ,  -0x1.efe2e8db0d9ecp+29,   -0x1.921fb540218b4p+0,  0x1.b4bcb2p-14, INEXACT)
T(RU,  -0x1.efe2e8db0d9ecp+29,   -0x1.921fb540218b4p+0,  0x1.b4bcb2p-14, INEXACT)
T(RD,  -0x1.efe2e8db0d9ecp+29,   -0x1.921fb540218b5p+0,  -0x1.fff25ap-1, INEXACT)
T(RZ,    0x1.73198da9b2f1bp-3,    0x1.6f1dd039b9449p-3,  -0x1.fffca4p-1, INEXACT)
T(RD,    0x1.73198da9b2f1bp-3,    0x1.6f1dd039b9449p-3,  -0x1.fffca4p-1, INEXACT)
T(RU,    0x1.73198da9b2f1bp-3,    0x1.6f1dd039b944ap-3,  0x1.adc75cp-16, INEXACT)
T(RN,   0x1.07d5c143c3817p+30,    0x1.921fb540613a4p+0,   -0x1.ffee1p-2, INEXACT)
T(RN,   0x1.f8834078af013p+32,    0x1.921fb543c0eb3p+0,   -0x1.fff5fp-2, INEXACT)
T(RN,   0x1.344be8a0e7ba8p+12,    0x1.92126c12d4f8bp+0,   -0x1.ffec4p-2, INEXACT)
T(RN,   0x1.1e1f67688bbc8p+34,    0x1.921fb544098e6p+0,  -0x1.fff0a8p-2, INEXACT)
T(RN,   0x1.7504ccef3f876p+28,    0x1.921fb53947c39p+0,  -0x1.fff16cp-2, INEXACT)
T(RN,   0x1.bd31df46d2fd5p+26,    0x1.921fb51f758a6p+0,  -0x1.ffe62ap-2, INEXACT)
T(RN,  -0x1.d69fad6c58b72p+18,    -0x1.921f92740994p+0,  -0x1.fff972p-2, INEXACT)
T(RN,   0x1.ff80bf65588b5p+20,    0x1.921fad4245507p+0,  -0x1.fff164p-2, INEXACT)
T(RZ,   0x1.f37d9309faa22p+15,    0x1.921eaedaf2594p+0,  -0x1.fffac4p-1, INEXACT)
T(RD,   0x1.f37d9309faa22p+15,    0x1.921eaedaf2594p+0,  -0x1.fffac4p-1, INEXACT)
T(RU,   0x1.f37d9309faa22p+15,    0x1.921eaedaf2595p+0,  0x1.4ec1fep-15, INEXACT)
T(RZ,   -0x1.ef59539bbf941p+7,   -0x1.91171aa74cf01p+0,  0x1.3f98e6p-16, INEXACT)
T(RU,   -0x1.ef59539bbf941p+7,   -0x1.91171aa74cf01p+0,  0x1.3f98e6p-16, INEXACT)
T(RD,   -0x1.ef59539bbf941p+7,   -0x1.91171aa74cf02p+0,   -0x1.fffd8p-1, INEXACT)
T(RZ,  -0x1.23da4de8ba1dcp+45,   -0x1.921fb54442ca7p+0,   0x1.fffc0cp-1, INEXACT)
T(RU,  -0x1.23da4de8ba1dcp+45,   -0x1.921fb54442ca7p+0,   0x1.fffc0cp-1, INEXACT)
T(RD,  -0x1.23da4de8ba1dcp+45,   -0x1.921fb54442ca8p+0, -0x1.fa2c6ap-16, INEXACT)
T(RZ,  -0x1.4d196e0e6582fp+20,   -0x1.921fa8f852bbcp+0,   0x1.fff9f8p-1, INEXACT)
T(RU,  -0x1.4d196e0e6582fp+20,   -0x1.921fa8f852bbcp+0,   0x1.fff9f8p-1, INEXACT)
T(RD,  -0x1.4d196e0e6582fp+20,   -0x1.921fa8f852bbdp+0, -0x1.823352p-15, INEXACT)
T(RZ,   0x1.263135c5b7068p+10,    0x1.91e804406b9e5p+0, -0x1.abcb9ep-15, INEXACT)
T(RD,   0x1.263135c5b7068p+10,    0x1.91e804406b9e5p+0, -0x1.abcb9ep-15, INEXACT)
T(RU,   0x1.263135c5b7068p+10,    0x1.91e804406b9e6p+0,    0x1.fff95p-1, INEXACT)
T(RZ,  -0x1.e1f9b67a90b06p+36,   -0x1.921fb5443a51fp+0,  0x1.c78d86p-15, INEXACT)
T(RU,  -0x1.e1f9b67a90b06p+36,   -0x1.921fb5443a51fp+0,  0x1.c78d86p-15, INEXACT)
T(RD,  -0x1.e1f9b67a90b06p+36,    -0x1.921fb5443a52p+0,  -0x1.fff8e2p-1, INEXACT)
T(RZ,   0x1.eaada9a013593p+22,    0x1.921fb32e034c4p+0,  -0x1.50d51p-15, INEXACT)
T(RD,   0x1.eaada9a013593p+22,    0x1.921fb32e034c4p+0,  -0x1.50d51p-15, INEXACT)
T(RU,   0x1.eaada9a013593p+22,    0x1.921fb32e034c5p+0,   0x1.fffabcp-1, INEXACT)
T(RN,  -0x1.08e396599151cp+36,    -0x1.921fb544335bp+0,  -0x1.fff2c8p-2, INEXACT)
T(RZ,   0x1.a6ef084653c18p+31,    0x1.921fb5430ce83p+0, -0x1.0126bcp-15, INEXACT)
T(RD,   0x1.a6ef084653c18p+31,    0x1.921fb5430ce83p+0, -0x1.0126bcp-15, INEXACT)
T(RU,   0x1.a6ef084653c18p+31,    0x1.921fb5430ce84p+0,   0x1.fffbfcp-1, INEXACT)
T(RZ,   0x1.e6adf01ef1aafp+41,    0x1.921fb544428e2p+0,  -0x1.fff87cp-1, INEXACT)
T(RD,   0x1.e6adf01ef1aafp+41,    0x1.921fb544428e2p+0,  -0x1.fff87cp-1, INEXACT)
T(RU,   0x1.e6adf01ef1aafp+41,    0x1.921fb544428e3p+0,  0x1.e0e1bcp-15, INEXACT)
T(RN,  -0x1.70ea44e54c7d1p+50,   -0x1.921fb54442d16p+0,  -0x1.fff05cp-2, INEXACT)
T(RZ,   0x1.0f8850a6125c8p+32,    0x1.921fb54351766p+0, -0x1.cb9282p-16, INEXACT)
T(RD,   0x1.0f8850a6125c8p+32,    0x1.921fb54351766p+0, -0x1.cb9282p-16, INEXACT)
T(RU,   0x1.0f8850a6125c8p+32,    0x1.921fb54351767p+0,   0x1.fffc68p-1, INEXACT)
T(RZ,   0x1.3487f6372f092p+48,    0x1.921fb54442d0ap+0,  -0x1.fffa58p-1, INEXACT)
T(RD,   0x1.3487f6372f092p+48,    0x1.921fb54442d0ap+0,  -0x1.fffa58p-1, INEXACT)
T(RU,   0x1.3487f6372f092p+48,    0x1.921fb54442d0bp+0,  0x1.6a2d92p-15, INEXACT)
T(RZ,  -0x1.604bad5d7d5b2p+37,   -0x1.921fb5443d015p+0,  0x1.b3b94cp-15, INEXACT)
T(RU,  -0x1.604bad5d7d5b2p+37,   -0x1.921fb5443d015p+0,  0x1.b3b94cp-15, INEXACT)
T(RD,  -0x1.604bad5d7d5b2p+37,   -0x1.921fb5443d016p+0,  -0x1.fff932p-1, INEXACT)
T(RN,   0x1.dffbbc77e05f7p+23,    0x1.921fb4332f537p+0,   -0x1.fff2bp-2, INEXACT)
T(RZ,  -0x1.915792311d032p+51,   -0x1.921fb54442d17p+0,  0x1.83b9e6p-15, INEXACT)
T(RU,  -0x1.915792311d032p+51,   -0x1.921fb54442d17p+0,  0x1.83b9e6p-15, INEXACT)
T(RD,  -0x1.915792311d032p+51,   -0x1.921fb54442d18p+0,  -0x1.fff9f2p-1, INEXACT)
T(RZ,   -0x1.1d3e23ddc6d8dp-3,   -0x1.1b6b62dff2e68p-3,    0x1.ffff1p-1, INEXACT)
T(RU,   -0x1.1d3e23ddc6d8dp-3,   -0x1.1b6b62dff2e68p-3,    0x1.ffff1p-1, INEXACT)
T(RD,   -0x1.1d3e23ddc6d8dp-3,   -0x1.1b6b62dff2e69p-3, -0x1.de2da6p-18, INEXACT)
T(RZ,    -0x1.d1c28457872ep+5,   -0x1.8dba283523a03p+0,    0x1.ffffbp-1, INEXACT)
T(RU,    -0x1.d1c28457872ep+5,   -0x1.8dba283523a03p+0,    0x1.ffffbp-1, INEXACT)
T(RD,    -0x1.d1c28457872ep+5,   -0x1.8dba283523a04p+0, -0x1.3ea828p-19, INEXACT)
T(RZ,   0x1.db1bb86101f78p+27,    0x1.921fb53304c48p+0,   -0x1.fff85p-1, INEXACT)
T(RD,   0x1.db1bb86101f78p+27,    0x1.921fb53304c48p+0,   -0x1.fff85p-1, INEXACT)
T(RU,   0x1.db1bb86101f78p+27,    0x1.921fb53304c49p+0,  0x1.ec15ecp-15, INEXACT)
T(RZ,   0x1.96fb0ab71a0dep+24,    0x1.921fb4a33b321p+0,  -0x1.fffdcep-1, INEXACT)
T(RD,   0x1.96fb0ab71a0dep+24,    0x1.921fb4a33b321p+0,  -0x1.fffdcep-1, INEXACT)
T(RU,   0x1.96fb0ab71a0dep+24,    0x1.921fb4a33b322p+0,  0x1.189cd2p-16, INEXACT)
T(RZ,  -0x1.671611749a8e9p+13,   -0x1.921a013479e7bp+0,  0x1.28c868p-15, INEXACT)
T(RU,  -0x1.671611749a8e9p+13,   -0x1.921a013479e7bp+0,  0x1.28c868p-15, INEXACT)
T(RD,  -0x1.671611749a8e9p+13,   -0x1.921a013479e7cp+0,  -0x1.fffb5cp-1, INEXACT)
T(RZ,    0x1.b840b2066ea58p-2,    0x1.9fc9a1deece89p-2,  -0x1.fffe4ap-1, INEXACT)
T(RD,    0x1.b840b2066ea58p-2,    0x1.9fc9a1deece89p-2,  -0x1.fffe4ap-1, INEXACT)
T(RU,    0x1.b840b2066ea58p-2,    0x1.9fc9a1deece8ap-2,   0x1.b672ep-17, INEXACT)
T(RZ,   0x1.aa8ca43fc82a7p+40,    0x1.921fb5444237ep+0,  -0x1.0eeccp-16, INEXACT)
T(RD,   0x1.aa8ca43fc82a7p+40,    0x1.921fb5444237ep+0,  -0x1.0eeccp-16, INEXACT)
T(RU,   0x1.aa8ca43fc82a7p+40,    0x1.921fb5444237fp+0,   0x1.fffde2p-1, INEXACT)
T(RN,  -0x1.496b0518eda3ep+26,   -0x1.921fb512865a5p+0,   -0x1.fffd9p-2, INEXACT)
T(RN,   0x1.b4a1c02c39dc5p+23,    0x1.921fb418127a7p+0,  -0x1.ffffd8p-2, INEXACT)
T(RN,    0x1.cede016a794bp+21,    0x1.921fb0d7908d4p+0,  -0x1.fff92ap-2, INEXACT)
T(RN,   0x1.7b9312ae4ae23p+19,    0x1.921f9faf40e29p+0,  -0x1.fff14cp-2, INEXACT)
T(RN,   0x1.6532efd6968bcp+41,    0x1.921fb5444275cp+0,  -0x1.fffc48p-2, INEXACT)
T(RN,   0x1.017790b762b3ep+23,    0x1.921fb3472dab4p+0,  -0x1.fffcbep-2, INEXACT)
T(RN,   0x1.e828f451ee353p+31,    0x1.921fb5433650fp+0,  -0x1.fff1b6p-2, INEXACT)
T(RN,  -0x1.6b9919b61dc4dp+39,   -0x1.921fb54441691p+0,  -0x1.fff68cp-2, INEXACT)
T(RN,   0x1.77f04351e3564p+37,    0x1.921fb5443d5eep+0,  -0x1.fffeb8p-2, INEXACT)
T(RN,  -0x1.25670f961f272p+31,   -0x1.921fb54284167p+0,   -0x1.fff76p-2, INEXACT)
T(RN,   -0x1.2a19314f0ee6cp+5,   -0x1.8b415aef833e4p+0,   -0x1.fffe6p-2, INEXACT)
T(RN,  -0x1.08e39659ef0a9p+36,    -0x1.921fb544335bp+0,  -0x1.fff16ap-2, INEXACT)
T(RN,  -0x1.917746e01555ep+35,   -0x1.921fb5442e69dp+0,  -0x1.fffafap-2, INEXACT)
T(RN,   0x1.49fa959c57b09p+52,    0x1.921fb54442d17p+0,  -0x1.fff528p-2, INEXACT)
T(RN,   0x1.13678e378885fp+30,    0x1.921fb5408af7bp+0,  -0x1.fffa6ep-2, INEXACT)
T(RN,   -0x1.5ee0cc6e4a276p+9,   -0x1.91c251d02a6a9p+0,  -0x1.fff80ep-2, INEXACT)
T(RN,   0x1.9be8933cd1bc2p+46,     0x1.921fb54442cfp+0,  -0x1.fff0b2p-2, INEXACT)
T(RZ,   0x1.79b68cf58e1b3p+31,    0x1.921fb542e7cdbp+0,  -0x1.ffff6ep-1, INEXACT)
T(RD,   0x1.79b68cf58e1b3p+31,    0x1.921fb542e7cdbp+0,  -0x1.ffff6ep-1, INEXACT)
T(RU,   0x1.79b68cf58e1b3p+31,    0x1.921fb542e7cdcp+0,  0x1.252dccp-18, INEXACT)
T(RZ,    0x1.4b6105c467872p-4,     0x1.4aa8a8f1e7c2p-4,  -0x1.fffc54p-1, INEXACT)
T(RD,    0x1.4b6105c467872p-4,     0x1.4aa8a8f1e7c2p-4,  -0x1.fffc54p-1, INEXACT)
T(RU,    0x1.4b6105c467872p-4,    0x1.4aa8a8f1e7c21p-4,  0x1.d611ccp-16, INEXACT)
T(RZ,  -0x1.caf7d7f087437p+39,   -0x1.921fb54441b3ep+0,   0x1.fffe2ep-1, INEXACT)
T(RU,  -0x1.caf7d7f087437p+39,   -0x1.921fb54441b3ep+0,   0x1.fffe2ep-1, INEXACT)
T(RD,  -0x1.caf7d7f087437p+39,   -0x1.921fb54441b3fp+0, -0x1.d24854p-17, INEXACT)
T(RZ,   0x1.ffc0b8a283ab3p+19,     0x1.921fa5424858p+0, -0x1.ace356p-16, INEXACT)
T(RD,   0x1.ffc0b8a283ab3p+19,     0x1.921fa5424858p+0, -0x1.ace356p-16, INEXACT)
T(RU,   0x1.ffc0b8a283ab3p+19,    0x1.921fa54248581p+0,   0x1.fffca6p-1, INEXACT)
T(RN,   -0x1.0f778843aacffp+1,   -0x1.21549efa25887p+0,  -0x1.fffc2cp-2, INEXACT)
T(RZ,    0x1.eef06fddba9cp+48,     0x1.921fb54442d1p+0, -0x1.1817f4p-19, INEXACT)
T(RD,    0x1.eef06fddba9cp+48,     0x1.921fb54442d1p+0, -0x1.1817f4p-19, INEXACT)
T(RU,    0x1.eef06fddba9cp+48,    0x1.921fb54442d11p+0,   0x1.ffffbap-1, INEXACT)
T(RZ,    0x1.d4b62835a8179p+0,    0x1.1225fc292fdcap+0, -0x1.7f041cp-20, INEXACT)
T(RD,    0x1.d4b62835a8179p+0,    0x1.1225fc292fdcap+0, -0x1.7f041cp-20, INEXACT)
T(RU,    0x1.d4b62835a8179p+0,    0x1.1225fc292fdcbp+0,    0x1.ffffdp-1, INEXACT)
T(RN,    0x1.035210381cc75p+3,    0x1.72b1486d097c4p+0,  -0x1.fffef6p-2, INEXACT)
T(RN,  -0x1.a2061ad4741bcp+44,   -0x1.921fb54442c7cp+0,  -0x1.fffa7ep-2, INEXACT)
T(RZ,  -0x1.f73ce575311f8p+31,   -0x1.921fb5433e5c7p+0,  0x1.d3f278p-17, INEXACT)
T(RU,  -0x1.f73ce575311f8p+31,   -0x1.921fb5433e5c7p+0,  0x1.d3f278p-17, INEXACT)
T(RD,  -0x1.f73ce575311f8p+31,   -0x1.921fb5433e5c8p+0,  -0x1.fffe2cp-1, INEXACT)
T(RN,   0x1.d3f677bd5d8d8p+28,    0x1.921fb53b8217dp+0,  -0x1.ffffc8p-2, INEXACT)
T(RZ,  -0x1.2bbf2bcb17693p+43,   -0x1.921fb54442b62p+0,   0x1.fffdcap-1, INEXACT)
T(RU,  -0x1.2bbf2bcb17693p+43,   -0x1.921fb54442b62p+0,   0x1.fffdcap-1, INEXACT)
T(RD,  -0x1.2bbf2bcb17693p+43,   -0x1.921fb54442b63p+0, -0x1.1b7b5ap-16, INEXACT)
T(RN,   -0x1.c56dda0b1127ap+6,   -0x1.8fdd961d82d04p+0,  -0x1.fffe78p-2, INEXACT)
T(RN,   0x1.d4c6526ae0ba8p+23,    0x1.921fb42ca7cd1p+0,  -0x1.fffa82p-2, INEXACT)
T(RN,      0x1.0a76b0d6602p+2,    0x1.55c7b37609046p+0,   -0x1.fff93p-2, INEXACT)
T(RZ,    0x1.8fd3190fce121p+3,    0x1.7dadaf4ccec5bp+0,  -0x1.fffe86p-1, INEXACT)
T(RD,    0x1.8fd3190fce121p+3,    0x1.7dadaf4ccec5bp+0,  -0x1.fffe86p-1, INEXACT)
T(RU,    0x1.8fd3190fce121p+3,    0x1.7dadaf4ccec5cp+0,  0x1.79e464p-17, INEXACT)
T(RN,  -0x1.bc413d1c6edf6p+33,   -0x1.921fb543f90f2p+0,  -0x1.fffcc6p-2, INEXACT)
T(RZ,   0x1.ab52f8ef20054p+38,     0x1.921fb544406cp+0,  -0x1.fffd02p-1, INEXACT)
T(RD,   0x1.ab52f8ef20054p+38,     0x1.921fb544406cp+0,  -0x1.fffd02p-1, INEXACT)
T(RU,   0x1.ab52f8ef20054p+38,    0x1.921fb544406c1p+0,  0x1.7f2a5ap-16, INEXACT)
T(RZ,    0x1.ebab63bcd4879p+4,    0x1.89cbc696232a9p+0,  -0x1.fffeaap-1, INEXACT)
T(RD,    0x1.ebab63bcd4879p+4,    0x1.89cbc696232a9p+0,  -0x1.fffeaap-1, INEXACT)
T(RU,    0x1.ebab63bcd4879p+4,    0x1.89cbc696232aap+0,  0x1.563918p-17, INEXACT)
T(RZ,  -0x1.2b003241d8f0ap+28,   -0x1.921fb5368fe26p+0,   0x1.6dc0ap-19, INEXACT)
T(RU,  -0x1.2b003241d8f0ap+28,   -0x1.921fb5368fe26p+0,   0x1.6dc0ap-19, INEXACT)
T(RD,  -0x1.2b003241d8f0ap+28,   -0x1.921fb5368fe27p+0,  -0x1.ffffa4p-1, INEXACT)
T(RN,  -0x1.0f3473dde7dfdp+50,   -0x1.921fb54442d15p+0,  -0x1.fffa02p-2, INEXACT)
T(RZ,    0x1.65103d5b23e9dp+8,    0x1.91682abc61a14p+0, -0x1.485a78p-18, INEXACT)
T(RD,    0x1.65103d5b23e9dp+8,    0x1.91682abc61a14p+0, -0x1.485a78p-18, INEXACT)
T(RU,    0x1.65103d5b23e9dp+8,    0x1.91682abc61a15p+0,   0x1.ffff5cp-1, INEXACT)
T(RZ,   0x1.e71425f0d9702p+34,    0x1.921fb544212e5p+0,  -0x1.fffd4ap-1, INEXACT)
T(RD,   0x1.e71425f0d9702p+34,    0x1.921fb544212e5p+0,  -0x1.fffd4ap-1, INEXACT)
T(RU,   0x1.e71425f0d9702p+34,    0x1.921fb544212e6p+0,  0x1.5b60f6p-16, INEXACT)
T(RZ,  -0x1.c1f580066804bp+50,   -0x1.921fb54442d16p+0,  0x1.8dc04ep-19, INEXACT)
T(RU,  -0x1.c1f580066804bp+50,   -0x1.921fb54442d16p+0,  0x1.8dc04ep-19, INEXACT)
T(RD,  -0x1.c1f580066804bp+50,   -0x1.921fb54442d17p+0,  -0x1.ffff9cp-1, INEXACT)
T(RN,  -0x1.86ddf2cb97167p+26,   -0x1.921fb51a580c4p+0,  -0x1.fff95ep-2, INEXACT)
T(RN,  -0x1.46a254e36454bp+34,   -0x1.921fb54410a89p+0,  -0x1.fff994p-2, INEXACT)
T(RZ,   0x1.9e7d03f51937fp+20,    0x1.921fab6273ec2p+0,   -0x1.fffcap-1, INEXACT)
T(RD,   0x1.9e7d03f51937fp+20,    0x1.921fab6273ec2p+0,   -0x1.fffcap-1, INEXACT)
T(RU,   0x1.9e7d03f51937fp+20,    0x1.921fab6273ec3p+0,  0x1.b054bap-16, INEXACT)
T(RZ,   -0x1.e3a074f6fc45ep-4,   -0x1.e165e0072e1c7p-4,   0x1.fffd28p-1, INEXACT)
T(RU,   -0x1.e3a074f6fc45ep-4,   -0x1.e165e0072e1c7p-4,   0x1.fffd28p-1, INEXACT)
T(RD,   -0x1.e3a074f6fc45ep-4,   -0x1.e165e0072e1c8p-4, -0x1.6bda12p-16, INEXACT)
T(RZ,   0x1.2c85c053ef88ap+20,    0x1.921fa7a315923p+0,  -0x1.fffed4p-1, INEXACT)
T(RD,   0x1.2c85c053ef88ap+20,    0x1.921fa7a315923p+0,  -0x1.fffed4p-1, INEXACT)
T(RU,   0x1.2c85c053ef88ap+20,    0x1.921fa7a315924p+0,  0x1.2c62b2p-17, INEXACT)
T(RN,   -0x1.ba5dbb010870bp-2,   -0x1.a191eb8d02fe8p-2,  -0x1.fff924p-2, INEXACT)
T(RZ,  -0x1.0a4c4e9788383p+32,   -0x1.921fb5434cb7dp+0,   0x1.fffe9cp-1, INEXACT)
T(RU,  -0x1.0a4c4e9788383p+32,   -0x1.921fb5434cb7dp+0,   0x1.fffe9cp-1, INEXACT)
T(RD,  -0x1.0a4c4e9788383p+32,   -0x1.921fb5434cb7ep+0, -0x1.641136p-17, INEXACT)
T(RZ,   -0x1.a31837baef5a8p+8,   -0x1.9183554ae8879p+0,   0x1.fffc12p-1, INEXACT)
T(RU,   -0x1.a31837baef5a8p+8,   -0x1.9183554ae8879p+0,   0x1.fffc12p-1, INEXACT)
T(RD,   -0x1.a31837baef5a8p+8,   -0x1.9183554ae887ap+0, -0x1.f77e96p-16, INEXACT)
T(RN,  -0x1.e514f72198ca5p+46,   -0x1.921fb54442cf7p+0,  -0x1.fff934p-2, INEXACT)
T(RN,   -0x1.e5d8a2a511d57p+1,   -0x1.502d5bb4129cfp+0,  -0x1.fffdb6p-2, INEXACT)
T(RN,   0x1.d2b77608d09e6p+18,    0x1.921f92296dde9p+0,   -0x1.fffe4p-2, INEXACT)
T(RN,   -0x1.dfd4cf3d4d986p-3,   -0x1.d7546cbb93c79p-3,  -0x1.ffff5ep-2, INEXACT)
T(RN,   -0x1.82395fa38df77p+8,    -0x1.9176064b7364p+0,  -0x1.fff8cep-2, INEXACT)
T(RN,   0x1.30199a74d0a9ep+27,    0x1.921fb529528f9p+0,  -0x1.fffa48p-2, INEXACT)
T(RN,  -0x1.fc24348cd36b7p+41,   -0x1.921fb54442911p+0,  -0x1.fffae4p-2, INEXACT)
T(RN,  -0x1.bea7fd53c27bcp+29,   -0x1.921fb53fad031p+0,  -0x1.fffaaep-2, INEXACT)
T(RZ,   -0x1.e05dc40115acep+8,   -0x1.9197476f3e346p+0,  0x1.550b1cp-22, INEXACT)
T(RU,   -0x1.e05dc40115acep+8,   -0x1.9197476f3e346p+0,  0x1.550b1cp-22, INEXACT)
T(RD,   -0x1.e05dc40115acep+8,   -0x1.9197476f3e347p+0,  -0x1.fffff6p-1, INEXACT)
T(RN,  -0x1.e514e720ff999p+46,   -0x1.921fb54442cf7p+0,  -0x1.fffda8p-2, INEXACT)
T(RZ,   0x1.f7238a0c8dafcp+38,    0x1.921fb54440c87p+0,  -0x1.fffed4p-1, INEXACT)
T(RD,   0x1.f7238a0c8dafcp+38,    0x1.921fb54440c87p+0,  -0x1.fffed4p-1, INEXACT)
T(RU,   0x1.f7238a0c8dafcp+38,    0x1.921fb54440c88p+0,   0x1.2b402p-17, INEXACT)
T(RZ,   -0x1.d28d0377bcac4p+6,   -0x1.8fedd86119d14p+0,   0x1.ffffd4p-1, INEXACT)
T(RU,   -0x1.d28d0377bcac4p+6,   -0x1.8fedd86119d14p+0,   0x1.ffffd4p-1, INEXACT)
T(RD,   -0x1.d28d0377bcac4p+6,   -0x1.8fedd86119d15p+0, -0x1.5c088ep-20, INEXACT)
T(RN,   -0x1.f234eeb8223adp+2,   -0x1.716ac33a6d7a6p+0,  -0x1.fffe22p-2, INEXACT)
T(RZ,    0x1.92f4ed9c01419p-3,    0x1.8ddfd8b3e5d95p-3, -0x1.4cff08p-17, INEXACT)
T(RD,    0x1.92f4ed9c01419p-3,    0x1.8ddfd8b3e5d95p-3, -0x1.4cff08p-17, INEXACT)
T(RU,    0x1.92f4ed9c01419p-3,    0x1.8ddfd8b3e5d96p-3,   0x1.fffeb4p-1, INEXACT)
T(RN,   0x1.ce7f7e72c2a64p+21,    0x1.921fb0d6a915cp+0,  -0x1.fffd7ep-2, INEXACT)
T(RN,   0x1.08ae26844bd42p+28,    0x1.921fb534c925ep+0,   -0x1.fffc5p-2, INEXACT)
T(RZ,   0x1.3fb8da94b284dp+20,    0x1.921fa8749cd93p+0, -0x1.314884p-17, INEXACT)
T(RD,   0x1.3fb8da94b284dp+20,    0x1.921fa8749cd93p+0, -0x1.314884p-17, INEXACT)
T(RU,   0x1.3fb8da94b284dp+20,    0x1.921fa8749cd94p+0,   0x1.fffecep-1, INEXACT)
T(RN,   0x1.762fd22afc7cbp+33,    0x1.921fb543eb3f4p+0,  -0x1.fffd4ep-2, INEXACT)
T(RZ,  -0x1.03fb31ff80f54p+40,   -0x1.921fb54441d57p+0,  0x1.43aa8ep-18, INEXACT)
T(RU,  -0x1.03fb31ff80f54p+40,   -0x1.921fb54441d57p+0,  0x1.43aa8ep-18, INEXACT)
T(RD,  -0x1.03fb31ff80f54p+40,   -0x1.921fb54441d58p+0,  -0x1.ffff5ep-1, INEXACT)
T(RN,  -0x1.20541636668e1p+51,   -0x1.921fb54442d17p+0,  -0x1.fffc7cp-2, INEXACT)
T(RN,    -0x1.5f2766f3e1e9p-1,   -0x1.33cbd057c1d58p-1,  -0x1.fffec6p-2, INEXACT)
T(RN,   0x1.e7e6c978e601dp+30,    0x1.921fb54229879p+0,  -0x1.fffe5cp-2, INEXACT)
T(RZ,   0x1.f92fb4f434741p+10,    0x1.91ff46c754295p+0, -0x1.332cf6p-18, INEXACT)
T(RD,   0x1.f92fb4f434741p+10,    0x1.91ff46c754295p+0, -0x1.332cf6p-18, INEXACT)
T(RU,   0x1.f92fb4f434741p+10,    0x1.91ff46c754296p+0,   0x1.ffff66p-1, INEXACT)
T(RZ,  -0x1.ceae2772a5953p+10,   -0x1.91fc4c092fb8dp+0,   0x1.fffe0ep-1, INEXACT)
T(RU,  -0x1.ceae2772a5953p+10,   -0x1.91fc4c092fb8dp+0,   0x1.fffe0ep-1, INEXACT)
T(RD,  -0x1.ceae2772a5953p+10,   -0x1.91fc4c092fb8ep+0, -0x1.f1920ep-17, INEXACT)
T(RZ,   0x1.037891485a716p+34,    0x1.921fb54403acbp+0, -0x1.8e2482p-17, INEXACT)
T(RD,   0x1.037891485a716p+34,    0x1.921fb54403acbp+0, -0x1.8e2482p-17, INEXACT)
T(RU,   0x1.037891485a716p+34,    0x1.921fb54403accp+0,   0x1.fffe72p-1, INEXACT)
T(RN,  -0x1.e234f4544ddecp+10,   -0x1.91fdbb1ff0982p+0,  -0x1.fffda8p-2, INEXACT)
T(RN,    0x1.0d9f71734d364p+1,    0x1.20a7edbbe56e2p+0,  -0x1.fffc5cp-2, INEXACT)
T(RZ,    0x1.3d2facf8cbfbfp+8,    0x1.9151178b724a3p+0,  -0x1.ffff5cp-1, INEXACT)
T(RD,    0x1.3d2facf8cbfbfp+8,    0x1.9151178b724a3p+0,  -0x1.ffff5cp-1, INEXACT)
T(RU,    0x1.3d2facf8cbfbfp+8,    0x1.9151178b724a4p+0,   0x1.46801p-18, INEXACT)
T(RN,   0x1.7dc3c4be09cf4p+30,    0x1.921fb54194279p+0,   -0x1.ffff4p-2, INEXACT)
T(RZ,   -0x1.6f91f30147d2p+20,   -0x1.921faa1f8988ep+0,  0x1.148176p-19, INEXACT)
T(RU,   -0x1.6f91f30147d2p+20,   -0x1.921faa1f8988ep+0,  0x1.148176p-19, INEXACT)
T(RD,   -0x1.6f91f30147d2p+20,   -0x1.921faa1f8988fp+0,  -0x1.ffffbap-1, INEXACT)
T(RN,  -0x1.5b01f1f3a2fa8p+15,   -0x1.921e3b8bba20ap+0,  -0x1.ffff34p-2, INEXACT)
T(RZ,  -0x1.0c2329aee7507p+48,   -0x1.921fb54442d09p+0,  0x1.b287f6p-17, INEXACT)
T(RU,  -0x1.0c2329aee7507p+48,   -0x1.921fb54442d09p+0,  0x1.b287f6p-17, INEXACT)
T(RD,  -0x1.0c2329aee7507p+48,   -0x1.921fb54442d0ap+0,  -0x1.fffe4ep-1, INEXACT)
T(RN,   -0x1.c41c039804dcbp+1,   -0x1.4b7e8542b31b5p+0,  -0x1.fffdb8p-2, INEXACT)
T(RN,  -0x1.7e04f255120d3p+45,   -0x1.921fb54442cc3p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,  -0x1.f9ca3fa721dfbp+28,   -0x1.921fb53c29ac6p+0,   0x1.fffe4ep-1, INEXACT)
T(RU,  -0x1.f9ca3fa721dfbp+28,   -0x1.921fb53c29ac6p+0,   0x1.fffe4ep-1, INEXACT)
T(RD,  -0x1.f9ca3fa721dfbp+28,   -0x1.921fb53c29ac7p+0, -0x1.b2fa46p-17, INEXACT)
T(RZ,    0x1.2c0cc238ae2cp+17,    0x1.921f480ee0fd3p+0,  -0x1.fffe86p-1, INEXACT)
T(RD,    0x1.2c0cc238ae2cp+17,    0x1.921f480ee0fd3p+0,  -0x1.fffe86p-1, INEXACT)
T(RU,    0x1.2c0cc238ae2cp+17,    0x1.921f480ee0fd4p+0,  0x1.79f1d2p-17, INEXACT)
T(RZ,   0x1.bd21f16428af6p+19,    0x1.921fa2dcf6b0dp+0,  -0x1.ffff86p-1, INEXACT)
T(RD,   0x1.bd21f16428af6p+19,    0x1.921fa2dcf6b0dp+0,  -0x1.ffff86p-1, INEXACT)
T(RU,   0x1.bd21f16428af6p+19,    0x1.921fa2dcf6b0ep+0,  0x1.eb3ce6p-19, INEXACT)
T(RN,   -0x1.cf7efaec92179p+6,   -0x1.8fea246c68c98p+0,  -0x1.fffe5ep-2, INEXACT)
T(RZ,   0x1.e477fbe357c2fp+17,    0x1.921f71a1318cbp+0,  -0x1.ffff2ap-1, INEXACT)
T(RD,   0x1.e477fbe357c2fp+17,    0x1.921f71a1318cbp+0,  -0x1.ffff2ap-1, INEXACT)
T(RU,   0x1.e477fbe357c2fp+17,    0x1.921f71a1318ccp+0,  0x1.ac34e6p-18, INEXACT)
T(RN,  -0x1.6216de63f0cd3p+30,   -0x1.921fb5415e7c5p+0,  -0x1.fffceep-2, INEXACT)
T(RN,   -0x1.32c780e595c07p-3,   -0x1.3083e20e69c52p-3,   -0x1.fffd9p-2, INEXACT)
T(RZ,   0x1.657ada667518ep+31,    0x1.921fb542d429bp+0, -0x1.7be064p-17, INEXACT)
T(RD,   0x1.657ada667518ep+31,    0x1.921fb542d429bp+0, -0x1.7be064p-17, INEXACT)
T(RU,   0x1.657ada667518ep+31,    0x1.921fb542d429cp+0,   0x1.fffe84p-1, INEXACT)
T(RZ,  -0x1.7a645091ec6c4p+39,   -0x1.921fb54441772p+0,  0x1.9eaafep-17, INEXACT)
T(RU,  -0x1.7a645091ec6c4p+39,   -0x1.921fb54441772p+0,  0x1.9eaafep-17, INEXACT)
T(RD,  -0x1.7a645091ec6c4p+39,   -0x1.921fb54441773p+0,  -0x1.fffe62p-1, INEXACT)
T(RZ,   0x1.9c04f5cfe08c9p+17,    0x1.921f65bc84fc1p+0, -0x1.57c764p-17, INEXACT)
T(RD,   0x1.9c04f5cfe08c9p+17,    0x1.921f65bc84fc1p+0, -0x1.57c764p-17, INEXACT)
T(RU,   0x1.9c04f5cfe08c9p+17,    0x1.921f65bc84fc2p+0,   0x1.fffea8p-1, INEXACT)
T(RZ,  -0x1.19c444b72aeb5p+24,    -0x1.921fb45babe1p+0,    0x1.4f8bp-21, INEXACT)
T(RU,  -0x1.19c444b72aeb5p+24,    -0x1.921fb45babe1p+0,    0x1.4f8bp-21, INEXACT)
T(RD,  -0x1.19c444b72aeb5p+24,   -0x1.921fb45babe11p+0,  -0x1.ffffecp-1, INEXACT)
T(RN,  -0x1.4a009dcc827ddp+52,   -0x1.921fb54442d18p+0,  -0x1.fffc52p-2, INEXACT)
T(RN,   0x1.91cea214bd072p+46,    0x1.921fb54442cefp+0,  -0x1.fffc92p-2, INEXACT)
T(RN,   0x1.12215f5cdd1b9p+24,    0x1.921fb45531389p+0,  -0x1.ffff78p-2, INEXACT)
T(RZ,    0x1.d1cb4989e673ap+1,    0x1.4d78464e8fe13p+0, -0x1.f40172p-19, INEXACT)
T(RD,    0x1.d1cb4989e673ap+1,    0x1.4d78464e8fe13p+0, -0x1.f40172p-19, INEXACT)
T(RU,    0x1.d1cb4989e673ap+1,    0x1.4d78464e8fe14p+0,   0x1.ffff82p-1, INEXACT)
T(RZ,   0x1.4770ffd407c5bp+19,    0x1.921f9c3f98f79p+0,  -0x1.ffff16p-1, INEXACT)
T(RD,   0x1.4770ffd407c5bp+19,    0x1.921f9c3f98f79p+0,  -0x1.ffff16p-1, INEXACT)
T(RU,   0x1.4770ffd407c5bp+19,    0x1.921f9c3f98f7ap+0,  0x1.d3be22p-18, INEXACT)
T(RZ,   0x1.b0a77036d1fbfp+23,     0x1.921fb4154ff1p+0,  -0x1.ffff4ep-1, INEXACT)
T(RD,   0x1.b0a77036d1fbfp+23,     0x1.921fb4154ff1p+0,  -0x1.ffff4ep-1, INEXACT)
T(RU,   0x1.b0a77036d1fbfp+23,    0x1.921fb4154ff11p+0,  0x1.63fe52p-18, INEXACT)
T(RZ,    0x1.a586c2cdba779p-3,    0x1.9fb88a551a8fap-3,   -0x1.ffff6p-1, INEXACT)
T(RD,    0x1.a586c2cdba779p-3,    0x1.9fb88a551a8fap-3,   -0x1.ffff6p-1, INEXACT)
T(RU,    0x1.a586c2cdba779p-3,    0x1.9fb88a551a8fbp-3,  0x1.41207ap-18, INEXACT)
T(RZ,  -0x1.e59ab8dc1d619p+22,   -0x1.921fb3286e3d8p+0,   0x1.ffffa6p-1, INEXACT)
T(RU,  -0x1.e59ab8dc1d619p+22,   -0x1.921fb3286e3d8p+0,   0x1.ffffa6p-1, INEXACT)
T(RD,  -0x1.e59ab8dc1d619p+22,   -0x1.921fb3286e3d9p+0, -0x1.699ea6p-19, INEXACT)
T(RZ,   0x1.da30b06546685p+47,    0x1.921fb54442d06p+0,  -0x1.ffffa8p-1, INEXACT)
T(RD,   0x1.da30b06546685p+47,    0x1.921fb54442d06p+0,  -0x1.ffffa8p-1, INEXACT)
T(RU,   0x1.da30b06546685p+47,    0x1.921fb54442d07p+0,  0x1.5e4828p-19, INEXACT)
T(RZ,   0x1.d1868428eb40ep+28,    0x1.921fb53b765c8p+0,  -0x1.ffff78p-1, INEXACT)
T(RD,   0x1.d1868428eb40ep+28,    0x1.921fb53b765c8p+0,  -0x1.ffff78p-1, INEXACT)
T(RU,   0x1.d1868428eb40ep+28,    0x1.921fb53b765c9p+0,  0x1.0ee7b2p-18, INEXACT)
T(RZ,    0x1.c34a9eb88252p+24,    0x1.921fb4b30acf5p+0,  -0x1.ffff36p-1, INEXACT)
T(RD,    0x1.c34a9eb88252p+24,    0x1.921fb4b30acf5p+0,  -0x1.ffff36p-1, INEXACT)
T(RU,    0x1.c34a9eb88252p+24,    0x1.921fb4b30acf6p+0,  0x1.92ad4ap-18, INEXACT)
T(RN,   0x1.1a91c7c82393dp+30,    0x1.921fb540a31a6p+0,  -0x1.fffe46p-2, INEXACT)
T(RZ,   0x1.15c9450a1bf95p+14,    0x1.921c0593af24ap+0, -0x1.d5eb0ep-18, INEXACT)
T(RD,   0x1.15c9450a1bf95p+14,    0x1.921c0593af24ap+0, -0x1.d5eb0ep-18, INEXACT)
T(RU,   0x1.15c9450a1bf95p+14,    0x1.921c0593af24bp+0,   0x1.ffff16p-1, INEXACT)
T(RZ,  -0x1.6872a5a1137eap+25,   -0x1.921fb4e95a14bp+0,   0x1.fcffcp-23, INEXACT)
T(RU,  -0x1.6872a5a1137eap+25,   -0x1.921fb4e95a14bp+0,   0x1.fcffcp-23, INEXACT)
T(RD,  -0x1.6872a5a1137eap+25,   -0x1.921fb4e95a14cp+0,  -0x1.fffff8p-1, INEXACT)
T(RN,   -0x1.8695fafd1050cp-2,   -0x1.752490629185ep-2,  -0x1.fffed6p-2, INEXACT)
T(RZ,    0x1.8b5761f7575b3p-1,    0x1.50a778fa9a6f9p-1,  -0x1.ffff96p-1, INEXACT)
T(RD,    0x1.8b5761f7575b3p-1,    0x1.50a778fa9a6f9p-1,  -0x1.ffff96p-1, INEXACT)
T(RU,    0x1.8b5761f7575b3p-1,    0x1.50a778fa9a6fap-1,  0x1.a534c6p-19, INEXACT)
T(RZ,  -0x1.03d542f4d1643p+22,   -0x1.921fb1535df65p+0,   0x1.ffff96p-1, INEXACT)
T(RU,  -0x1.03d542f4d1643p+22,   -0x1.921fb1535df65p+0,   0x1.ffff96p-1, INEXACT)
T(RD,  -0x1.03d542f4d1643p+22,   -0x1.921fb1535df66p+0, -0x1.aac9aap-19, INEXACT)
T(RZ,  -0x1.338b21cf3821cp+11,   -0x1.920512398dd47p+0,   0x1.ffff88p-1, INEXACT)
T(RU,  -0x1.338b21cf3821cp+11,   -0x1.920512398dd47p+0,   0x1.ffff88p-1, INEXACT)
T(RD,  -0x1.338b21cf3821cp+11,   -0x1.920512398dd48p+0, -0x1.e2a56ep-19, INEXACT)
T(RZ,   0x1.9153fa14389e1p+51,    0x1.921fb54442d17p+0, -0x1.ab3cd6p-20, INEXACT)
T(RD,   0x1.9153fa14389e1p+51,    0x1.921fb54442d17p+0, -0x1.ab3cd6p-20, INEXACT)
T(RU,   0x1.9153fa14389e1p+51,    0x1.921fb54442d18p+0,   0x1.ffffcap-1, INEXACT)
T(RN,    0x1.affe9e9a16d68p+7,    0x1.90f04c8e44c27p+0,  -0x1.ffffb6p-2, INEXACT)
T(RZ,  -0x1.e192d02c203b7p+32,   -0x1.921fb543babb3p+0,   0x1.38a73p-18, INEXACT)
T(RU,  -0x1.e192d02c203b7p+32,   -0x1.921fb543babb3p+0,   0x1.38a73p-18, INEXACT)
T(RD,  -0x1.e192d02c203b7p+32,   -0x1.921fb543babb4p+0,  -0x1.ffff64p-1, INEXACT)
T(RN,   -0x1.c665d5fa6d217p+1,   -0x1.4bd50f3a1b934p+0,  -0x1.fffe92p-2, INEXACT)
T(RZ,   0x1.335aed60baf16p+28,    0x1.921fb536ef356p+0, -0x1.0d5d46p-21, INEXACT)
T(RD,   0x1.335aed60baf16p+28,    0x1.921fb536ef356p+0, -0x1.0d5d46p-21, INEXACT)
T(RU,   0x1.335aed60baf16p+28,    0x1.921fb536ef357p+0,    0x1.fffffp-1, INEXACT)
T(RZ,  -0x1.fdcda4faebd45p+45,   -0x1.921fb54442cd7p+0,   0x1.ffff5cp-1, INEXACT)
T(RU,  -0x1.fdcda4faebd45p+45,   -0x1.921fb54442cd7p+0,   0x1.ffff5cp-1, INEXACT)
T(RD,  -0x1.fdcda4faebd45p+45,   -0x1.921fb54442cd8p+0, -0x1.48f44ap-18, INEXACT)
T(RN,   0x1.ce404629e1127p+44,    0x1.921fb54442c8ap+0,  -0x1.ffffc6p-2, INEXACT)
T(RZ,  -0x1.0a01b505586c9p+33,   -0x1.921fb543c7a23p+0,   0x1.8fc4ep-18, INEXACT)
T(RU,  -0x1.0a01b505586c9p+33,   -0x1.921fb543c7a23p+0,   0x1.8fc4ep-18, INEXACT)
T(RD,  -0x1.0a01b505586c9p+33,   -0x1.921fb543c7a24p+0,  -0x1.ffff38p-1, INEXACT)
T(RZ,   -0x1.43920108b29eap+9,   -0x1.91ba70242b43fp+0,   0x1.ffff3ep-1, INEXACT)
T(RU,   -0x1.43920108b29eap+9,   -0x1.91ba70242b43fp+0,   0x1.ffff3ep-1, INEXACT)
T(RD,   -0x1.43920108b29eap+9,    -0x1.91ba70242b44p+0, -0x1.82b552p-18, INEXACT)
T(RN,    0x1.0f871c99d42c7p+6,    0x1.8e5a564bb10fbp+0,  -0x1.fffeeap-2, INEXACT)
T(RZ,   -0x1.6e9c7323c5c25p-1,   -0x1.3e293e0494533p-1,    0x1.ffff7p-1, INEXACT)
T(RU,   -0x1.6e9c7323c5c25p-1,   -0x1.3e293e0494533p-1,    0x1.ffff7p-1, INEXACT)
T(RD,   -0x1.6e9c7323c5c25p-1,   -0x1.3e293e0494534p-1, -0x1.21b672p-18, INEXACT)
T(RN,   0x1.4cfc0e5e9cbafp+32,    0x1.921fb5437e012p+0,  -0x1.fffe86p-2, INEXACT)
T(RN,   0x1.0cf1cd648bb02p+34,    0x1.921fb54405e61p+0,  -0x1.ffff9cp-2, INEXACT)
T(RN,    0x1.b082fb61c3c7p+39,    0x1.921fb54441a27p+0,  -0x1.ffff34p-2, INEXACT)
T(RN,   0x1.31451fb400257p+32,    0x1.921fb5436c22ep+0,  -0x1.ffff68p-2, INEXACT)
T(RN,  -0x1.228f1383e1725p+45,   -0x1.921fb54442ca8p+0,  -0x1.fffe9cp-2, INEXACT)
T(RN,   0x1.72e6b6b22dbc7p+42,    0x1.921fb54442a55p+0,  -0x1.fffe44p-2, INEXACT)
T(RN,  -0x1.9123935167a9ap+13,   -0x1.921a9a44a9d21p+0,  -0x1.ffffdep-2, INEXACT)
T(RN,  -0x1.8b838fd2cee49p+36,   -0x1.921fb54438766p+0,  -0x1.fffefep-2, INEXACT)
T(RN,    0x1.6957cf45eb4e8p-3,    0x1.65a9779f92d89p-3,  -0x1.fffe52p-2, INEXACT)
T(RN,   -0x1.20014efeba3fp+45,   -0x1.921fb54442ca7p+0,  -0x1.fffe06p-2, INEXACT)
T(RN,   -0x1.87ef2b8373bacp-5,   -0x1.87a2b81542426p-5,  -0x1.fffe1cp-2, INEXACT)
T(RN,  -0x1.acd4fd83858f7p+49,   -0x1.921fb54442d14p+0,   -0x1.ffff4p-2, INEXACT)
T(RN,   0x1.8e786d92b8f1ep+23,    0x1.921fb3fb52bb3p+0,  -0x1.fffe3cp-2, INEXACT)
T(RN,  -0x1.2053a632810adp+51,   -0x1.921fb54442d17p+0,  -0x1.ffff3ep-2, INEXACT)
T(RZ,  -0x1.d4cb51cd9eabbp+22,   -0x1.921fb31512bedp+0,  0x1.b5ada8p-19, INEXACT)
T(RU,  -0x1.d4cb51cd9eabbp+22,   -0x1.921fb31512bedp+0,  0x1.b5ada8p-19, INEXACT)
T(RD,  -0x1.d4cb51cd9eabbp+22,   -0x1.921fb31512beep+0,  -0x1.ffff92p-1, INEXACT)
T(RZ,   0x1.0d8d11cd9b261p+23,    0x1.921fb35e0028ap+0, -0x1.1537fcp-20, INEXACT)
T(RD,   0x1.0d8d11cd9b261p+23,    0x1.921fb35e0028ap+0, -0x1.1537fcp-20, INEXACT)
T(RU,   0x1.0d8d11cd9b261p+23,    0x1.921fb35e0028bp+0,   0x1.ffffdep-1, INEXACT)
T(RZ,  -0x1.eb87a0c5d3bcep+12,   -0x1.92175ff9d0dedp+0,  0x1.91e814p-21, INEXACT)
T(RU,  -0x1.eb87a0c5d3bcep+12,   -0x1.92175ff9d0dedp+0,  0x1.91e814p-21, INEXACT)
T(RD,  -0x1.eb87a0c5d3bcep+12,   -0x1.92175ff9d0deep+0,  -0x1.ffffe6p-1, INEXACT)
T(RZ,  -0x1.855ea5b0d783cp+35,   -0x1.921fb5442dc77p+0,   0x1.ffff86p-1, INEXACT)
T(RU,  -0x1.855ea5b0d783cp+35,   -0x1.921fb5442dc77p+0,   0x1.ffff86p-1, INEXACT)
T(RD,  -0x1.855ea5b0d783cp+35,   -0x1.921fb5442dc78p+0, -0x1.e79cc6p-19, INEXACT)
T(RZ,  -0x1.f0d359a2d9b0cp+41,   -0x1.921fb544428f9p+0,  0x1.6539e6p-19, INEXACT)
T(RU,  -0x1.f0d359a2d9b0cp+41,   -0x1.921fb544428f9p+0,  0x1.6539e6p-19, INEXACT)
T(RD,  -0x1.f0d359a2d9b0cp+41,   -0x1.921fb544428fap+0,  -0x1.ffffa6p-1, INEXACT)
T(RZ,  -0x1.ec5ed1b067613p+46,   -0x1.921fb54442cf7p+0,  0x1.df668ep-19, INEXACT)
T(RU,  -0x1.ec5ed1b067613p+46,   -0x1.921fb54442cf7p+0,  0x1.df668ep-19, INEXACT)
T(RD,  -0x1.ec5ed1b067613p+46,   -0x1.921fb54442cf8p+0,  -0x1.ffff88p-1, INEXACT)
T(RZ,  -0x1.91540214bbe83p+51,   -0x1.921fb54442d17p+0,  0x1.09b6d8p-19, INEXACT)
T(RU,  -0x1.91540214bbe83p+51,   -0x1.921fb54442d17p+0,  0x1.09b6d8p-19, INEXACT)
T(RD,  -0x1.91540214bbe83p+51,   -0x1.921fb54442d18p+0,  -0x1.ffffbep-1, INEXACT)
T(RZ,   0x1.de1e8ae0e8159p+30,    0x1.921fb5421e896p+0,  -0x1.ffffe4p-1, INEXACT)
T(RD,   0x1.de1e8ae0e8159p+30,    0x1.921fb5421e896p+0,  -0x1.ffffe4p-1, INEXACT)
T(RU,   0x1.de1e8ae0e8159p+30,    0x1.921fb5421e897p+0,  0x1.c90652p-21, INEXACT)
T(RN,  -0x1.fae21e97c8342p+36,   -0x1.921fb5443abcep+0,  -0x1.ffff46p-2, INEXACT)
T(RZ,   0x1.93b6ed658e7a2p+20,    0x1.921fab1ef0d5ep+0, -0x1.c4e674p-19, INEXACT)
T(RD,   0x1.93b6ed658e7a2p+20,    0x1.921fab1ef0d5ep+0, -0x1.c4e674p-19, INEXACT)
T(RU,   0x1.93b6ed658e7a2p+20,    0x1.921fab1ef0d5fp+0,   0x1.ffff8ep-1, INEXACT)
T(RZ,    0x1.789ca755ebc9ap+4,    0x1.8741258a5f51fp+0,   -0x1.ffff8p-1, INEXACT)
T(RD,    0x1.789ca755ebc9ap+4,    0x1.8741258a5f51fp+0,   -0x1.ffff8p-1, INEXACT)
T(RU,    0x1.789ca755ebc9ap+4,     0x1.8741258a5f52p+0,  0x1.fd0ef8p-19, INEXACT)
T(RN,  -0x1.30d007b769c83p+16,   -0x1.921ede432e11bp+0,  -0x1.fffff4p-2, INEXACT)
T(RZ,   0x1.197b75ab74ea1p+49,     0x1.921fb54442d1p+0,  -0x1.ffff92p-1, INEXACT)
T(RD,   0x1.197b75ab74ea1p+49,     0x1.921fb54442d1p+0,  -0x1.ffff92p-1, INEXACT)
T(RU,   0x1.197b75ab74ea1p+49,    0x1.921fb54442d11p+0,   0x1.ba8bbp-19, INEXACT)
T(RZ,   0x1.107d56cc69d46p+30,     0x1.921fb54080c9p+0,  -0x1.ffffacp-1, INEXACT)
T(RD,   0x1.107d56cc69d46p+30,     0x1.921fb54080c9p+0,  -0x1.ffffacp-1, INEXACT)
T(RU,   0x1.107d56cc69d46p+30,    0x1.921fb54080c91p+0,  0x1.4dbf22p-19, INEXACT)
T(RZ,   0x1.1e5a05b42bd3fp+19,    0x1.921f98a89106ep+0,  -0x1.ffff8ep-1, INEXACT)
T(RD,   0x1.1e5a05b42bd3fp+19,    0x1.921f98a89106ep+0,  -0x1.ffff8ep-1, INEXACT)
T(RU,   0x1.1e5a05b42bd3fp+19,    0x1.921f98a89106fp+0,  0x1.c7983ap-19, INEXACT)
T(RZ,   0x1.e81916e6234c5p+35,    0x1.921fb5443208ep+0,  -0x1.fffffcp-1, INEXACT)
T(RD,   0x1.e81916e6234c5p+35,    0x1.921fb5443208ep+0,  -0x1.fffffcp-1, INEXACT)
T(RU,   0x1.e81916e6234c5p+35,    0x1.921fb5443208fp+0,  0x1.c86d64p-24, INEXACT)
T(RZ,  -0x1.a127255f5fb53p+46,   -0x1.921fb54442cf1p+0,  0x1.1278ecp-21, INEXACT)
T(RU,  -0x1.a127255f5fb53p+46,   -0x1.921fb54442cf1p+0,  0x1.1278ecp-21, INEXACT)
T(RD,  -0x1.a127255f5fb53p+46,   -0x1.921fb54442cf2p+0,  -0x1.ffffeep-1, INEXACT)
T(RN,    0x1.64cf439f26dbcp-2,    0x1.5756676013a8bp-2,  -0x1.ffff9ap-2, INEXACT)
T(RZ,  -0x1.797330d7c7238p+18,   -0x1.921f89dc0c8f4p+0,   0x1.ffffc4p-1, INEXACT)
T(RU,  -0x1.797330d7c7238p+18,   -0x1.921f89dc0c8f4p+0,   0x1.ffffc4p-1, INEXACT)
T(RD,  -0x1.797330d7c7238p+18,   -0x1.921f89dc0c8f5p+0, -0x1.dd3142p-20, INEXACT)
T(RN,   0x1.58ad0d5fdab94p+23,    0x1.921fb3c7fc2a8p+0,  -0x1.fffff4p-2, INEXACT)
T(RZ,   0x1.4ef01d98ef26bp+21,    0x1.921faf26eea99p+0, -0x1.c5ac1ap-19, INEXACT)
T(RD,   0x1.4ef01d98ef26bp+21,    0x1.921faf26eea99p+0, -0x1.c5ac1ap-19, INEXACT)
T(RU,   0x1.4ef01d98ef26bp+21,    0x1.921faf26eea9ap+0,   0x1.ffff8ep-1, INEXACT)
T(RZ,   0x1.e313097479edfp+18,    0x1.921f9359bd127p+0,  -0x1.ffffeep-1, INEXACT)
T(RD,   0x1.e313097479edfp+18,    0x1.921f9359bd127p+0,  -0x1.ffffeep-1, INEXACT)
T(RU,   0x1.e313097479edfp+18,    0x1.921f9359bd128p+0,   0x1.185afp-21, INEXACT)
T(RN,  -0x1.2bbe5a5f4094bp+10,    -0x1.91e90c4bb096p+0,  -0x1.ffffd4p-2, INEXACT)
T(RN,   -0x1.d808410b8c063p+8,   -0x1.9194decc70411p+0,  -0x1.ffff38p-2, INEXACT)
T(RN,   0x1.0f42fd6599f78p+41,    0x1.921fb5444258bp+0,  -0x1.ffff7ap-2, INEXACT)
T(RZ,    0x1.b994b32c6918p+48,    0x1.921fb54442d0fp+0, -0x1.a53644p-20, INEXACT)
T(RD,    0x1.b994b32c6918p+48,    0x1.921fb54442d0fp+0, -0x1.a53644p-20, INEXACT)
T(RU,    0x1.b994b32c6918p+48,     0x1.921fb54442d1p+0,   0x1.ffffccp-1, INEXACT)
T(RN,   0x1.79b9c24981dd8p+17,    0x1.921f5e840e5a5p+0,  -0x1.ffff4ap-2, INEXACT)
T(RZ,  -0x1.2e66213f4209ap+12,   -0x1.921229bdca38bp+0,  0x1.b9da86p-20, INEXACT)
T(RU,  -0x1.2e66213f4209ap+12,   -0x1.921229bdca38bp+0,  0x1.b9da86p-20, INEXACT)
T(RD,  -0x1.2e66213f4209ap+12,   -0x1.921229bdca38cp+0,  -0x1.ffffc8p-1, INEXACT)
T(RN,   0x1.14c40b4d4f08fp+12,    0x1.9210e897292dap+0,  -0x1.ffff06p-2, INEXACT)
T(RN,  -0x1.571f3ae4c322cp+36,   -0x1.921fb54436e19p+0,  -0x1.ffff9cp-2, INEXACT)
T(RN,   0x1.8975334c56347p+10,    0x1.91f611283183dp+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.29556c40c3426p+48,    0x1.921fb54442d0ap+0,  -0x1.ffff52p-2, INEXACT)
T(RN,   0x1.ab789e44aa438p+33,    0x1.921fb543f629bp+0,  -0x1.ffff0cp-2, INEXACT)
T(RN,   -0x1.4a2e85af8e4cep-2,   -0x1.3f674f06fb3c1p-2,  -0x1.ffff1cp-2, INEXACT)
T(RN,   0x1.3bc32a283af69p+40,    0x1.921fb5444201fp+0,  -0x1.ffffa8p-2, INEXACT)
T(RN,  -0x1.16c11d7111b97p+46,   -0x1.921fb54442cdep+0,  -0x1.ffff4ap-2, INEXACT)
T(RN,    0x1.d52aed69c941ap+2,    0x1.6f6aaa8934b63p+0,  -0x1.ffffb8p-2, INEXACT)
T(RN,   -0x1.4886b74fe626ap+7,   -0x1.9090be4ba7438p+0,  -0x1.ffff5ap-2, INEXACT)
T(RN,   0x1.20318b1fb0316p+38,    0x1.921fb5443f43ep+0,  -0x1.ffffe2p-2, INEXACT)
T(RN,  -0x1.08e973ec22b5ep+43,   -0x1.921fb54442b2ap+0,  -0x1.ffff5ep-2, INEXACT)
T(RN,   0x1.67ae3864c2ef7p+47,    0x1.921fb54442d01p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.acd4e582fb034p+49,    0x1.921fb54442d13p+0,  -0x1.ffffaep-2, INEXACT)
T(RZ,  -0x1.197b7dab30124p+49,    -0x1.921fb54442d1p+0,   0x1.fffffcp-1, INEXACT)
T(RU,  -0x1.197b7dab30124p+49,    -0x1.921fb54442d1p+0,   0x1.fffffcp-1, INEXACT)
T(RD,  -0x1.197b7dab30124p+49,   -0x1.921fb54442d11p+0, -0x1.31b5d8p-23, INEXACT)
T(RZ,   -0x1.21352e079e0a4p+0,   -0x1.b1453e8021322p-1,  0x1.9360fep-23, INEXACT)
T(RU,   -0x1.21352e079e0a4p+0,   -0x1.b1453e8021322p-1,  0x1.9360fep-23, INEXACT)
T(RD,   -0x1.21352e079e0a4p+0,   -0x1.b1453e8021323p-1,  -0x1.fffffap-1, INEXACT)
T(RN,   0x1.e3ba1978d3ce8p+32,    0x1.921fb543bb564p+0,  -0x1.ffffbap-2, INEXACT)
T(RZ,   -0x1.5c82422a6b58p+10,   -0x1.91f0b2448cd11p+0,  0x1.d55066p-21, INEXACT)
T(RU,   -0x1.5c82422a6b58p+10,   -0x1.91f0b2448cd11p+0,  0x1.d55066p-21, INEXACT)
T(RD,   -0x1.5c82422a6b58p+10,   -0x1.91f0b2448cd12p+0,  -0x1.ffffe2p-1, INEXACT)
T(RZ,   0x1.7002521304b1bp+35,    0x1.921fb5442c8edp+0,   -0x1.ffffep-1, INEXACT)
T(RD,   0x1.7002521304b1bp+35,    0x1.921fb5442c8edp+0,   -0x1.ffffep-1, INEXACT)
T(RU,   0x1.7002521304b1bp+35,    0x1.921fb5442c8eep+0,   0x1.fd4d2p-21, INEXACT)
T(RZ,   0x1.f1783c805c866p+38,    0x1.921fb54440c28p+0,   -0x1.fffffp-1, INEXACT)
T(RD,   0x1.f1783c805c866p+38,    0x1.921fb54440c28p+0,   -0x1.fffffp-1, INEXACT)
T(RU,   0x1.f1783c805c866p+38,    0x1.921fb54440c29p+0,  0x1.033102p-21, INEXACT)
T(RZ,  -0x1.70ab6eea75754p+24,   -0x1.921fb4927f5e7p+0,  0x1.735302p-20, INEXACT)
T(RU,  -0x1.70ab6eea75754p+24,   -0x1.921fb4927f5e7p+0,  0x1.735302p-20, INEXACT)
T(RD,  -0x1.70ab6eea75754p+24,   -0x1.921fb4927f5e8p+0,  -0x1.ffffd2p-1, INEXACT)
T(RN,    0x1.e29e7da30237cp-3,    0x1.d9f8c37a6f4bbp-3,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.5c47c62e57d48p+28,    0x1.921fb53880183p+0,  -0x1.ffffecp-2, INEXACT)
T(RZ,   -0x1.430871f15af57p-5,    -0x1.42dd9f51c4e9p-5,   0x1.fffff6p-1, INEXACT)
T(RU,   -0x1.430871f15af57p-5,    -0x1.42dd9f51c4e9p-5,   0x1.fffff6p-1, INEXACT)
T(RD,   -0x1.430871f15af57p-5,   -0x1.42dd9f51c4e91p-5, -0x1.4ef636p-22, INEXACT)
T(RN,   0x1.f4dc220c92448p+41,    0x1.921fb54442901p+0,  -0x1.ffffdep-2, INEXACT)
T(RN,  -0x1.cf7117440eacfp+33,   -0x1.921fb543fc1cep+0,  -0x1.ffffbep-2, INEXACT)
T(RZ,   0x1.82190c2bfddacp+36,    0x1.921fb5443835bp+0, -0x1.e4b85ap-23, INEXACT)
T(RD,   0x1.82190c2bfddacp+36,    0x1.921fb5443835bp+0, -0x1.e4b85ap-23, INEXACT)
T(RU,   0x1.82190c2bfddacp+36,    0x1.921fb5443835cp+0,   0x1.fffff8p-1, INEXACT)
T(RZ,  -0x1.75cf6611409dap+42,   -0x1.921fb54442a5bp+0,   0x1.da29ep-23, INEXACT)
T(RU,  -0x1.75cf6611409dap+42,   -0x1.921fb54442a5bp+0,   0x1.da29ep-23, INEXACT)
T(RD,  -0x1.75cf6611409dap+42,   -0x1.921fb54442a5cp+0,  -0x1.fffff8p-1, INEXACT)
T(RN,  -0x1.9324b8814889cp+30,   -0x1.921fb541b8919p+0,  -0x1.ffffa2p-2, INEXACT)
T(RZ,   -0x1.78436e12ddf2fp+6,   -0x1.8f6707e83f973p+0,  0x1.84219ep-20, INEXACT)
T(RU,   -0x1.78436e12ddf2fp+6,   -0x1.8f6707e83f973p+0,  0x1.84219ep-20, INEXACT)
T(RD,   -0x1.78436e12ddf2fp+6,   -0x1.8f6707e83f974p+0,   -0x1.ffffdp-1, INEXACT)
T(RN,  -0x1.fd76899f2cc1bp+13,   -0x1.921bb02ade47bp+0,  -0x1.ffffa4p-2, INEXACT)
T(RZ,  -0x1.52485d647930fp+17,   -0x1.921f5466a2005p+0,  0x1.8c0862p-22, INEXACT)
T(RU,  -0x1.52485d647930fp+17,   -0x1.921f5466a2005p+0,  0x1.8c0862p-22, INEXACT)
T(RD,  -0x1.52485d647930fp+17,   -0x1.921f5466a2006p+0,  -0x1.fffff4p-1, INEXACT)
T(RZ,   0x1.c3d35a3e42862p+23,    0x1.921fb4222ab1dp+0, -0x1.155bb8p-22, INEXACT)
T(RD,   0x1.c3d35a3e42862p+23,    0x1.921fb4222ab1dp+0, -0x1.155bb8p-22, INEXACT)
T(RU,   0x1.c3d35a3e42862p+23,    0x1.921fb4222ab1ep+0,   0x1.fffff8p-1, INEXACT)
T(RZ,   0x1.e45c6e911d284p+32,    0x1.921fb543bb83bp+0, -0x1.d8d9aep-21, INEXACT)
T(RD,   0x1.e45c6e911d284p+32,    0x1.921fb543bb83bp+0, -0x1.d8d9aep-21, INEXACT)
T(RU,   0x1.e45c6e911d284p+32,    0x1.921fb543bb83cp+0,   0x1.ffffe2p-1, INEXACT)
T(RZ,  -0x1.f99c0a0cfb75ap+33,   -0x1.921fb54402027p+0,  0x1.a612bap-22, INEXACT)
T(RU,  -0x1.f99c0a0cfb75ap+33,   -0x1.921fb54402027p+0,  0x1.a612bap-22, INEXACT)
T(RD,  -0x1.f99c0a0cfb75ap+33,   -0x1.921fb54402028p+0,  -0x1.fffff2p-1, INEXACT)
T(RN,   -0x1.ff61c3f4d5611p-4,    -0x1.fcbfdc156679p-4,  -0x1.ffffc8p-2, INEXACT)
T(RZ,   -0x1.ef5a7f7def5dp+12,   -0x1.921770716b8cdp+0,    0x1.ffffdp-1, INEXACT)
T(RU,   -0x1.ef5a7f7def5dp+12,   -0x1.921770716b8cdp+0,    0x1.ffffdp-1, INEXACT)
T(RD,   -0x1.ef5a7f7def5dp+12,   -0x1.921770716b8cep+0, -0x1.7a77c2p-20, INEXACT)
T(RZ,   0x1.6d87524c4c9e9p+30,    0x1.921fb54175a78p+0, -0x1.d27b7cp-21, INEXACT)
T(RD,   0x1.6d87524c4c9e9p+30,    0x1.921fb54175a78p+0, -0x1.d27b7cp-21, INEXACT)
T(RU,   0x1.6d87524c4c9e9p+30,    0x1.921fb54175a79p+0,   0x1.ffffe2p-1, INEXACT)
T(RZ,  -0x1.5353d52dbddd7p+37,   -0x1.921fb5443cc87p+0,   0x1.121b8p-20, INEXACT)
T(RU,  -0x1.5353d52dbddd7p+37,   -0x1.921fb5443cc87p+0,   0x1.121b8p-20, INEXACT)
T(RD,  -0x1.5353d52dbddd7p+37,   -0x1.921fb5443cc88p+0,  -0x1.ffffdep-1, INEXACT)
T(RN,   0x1.26eef0335065fp+47,    0x1.921fb54442cfcp+0,  -0x1.ffffccp-2, INEXACT)
T(RZ,   -0x1.dfae7431314f9p+5,   -0x1.8ddad140876bfp+0,   0x1.ffffd4p-1, INEXACT)
T(RU,   -0x1.dfae7431314f9p+5,   -0x1.8ddad140876bfp+0,   0x1.ffffd4p-1, INEXACT)
T(RD,   -0x1.dfae7431314f9p+5,    -0x1.8ddad140876cp+0, -0x1.5bab06p-20, INEXACT)
T(RN,   0x1.ba610c577d75ap+10,    0x1.91faac062258fp+0,  -0x1.ffffc8p-2, INEXACT)
T(RZ,  -0x1.2fd0b56511bbap+13,   -0x1.9218f7961ff33p+0,   0x1.ffffe6p-1, INEXACT)
T(RU,  -0x1.2fd0b56511bbap+13,   -0x1.9218f7961ff33p+0,   0x1.ffffe6p-1, INEXACT)
T(RD,  -0x1.2fd0b56511bbap+13,   -0x1.9218f7961ff34p+0, -0x1.95a204p-21, INEXACT)
T(RZ,   -0x1.b7dfc6d6b419p+29,   -0x1.921fb53f9ae9fp+0,  0x1.f951b2p-21, INEXACT)
T(RU,   -0x1.b7dfc6d6b419p+29,   -0x1.921fb53f9ae9fp+0,  0x1.f951b2p-21, INEXACT)
T(RD,   -0x1.b7dfc6d6b419p+29,    -0x1.921fb53f9aeap+0,   -0x1.ffffep-1, INEXACT)
T(RN,    0x1.b3db95f1e95c3p-3,    0x1.ad735954ba8d6p-3,  -0x1.ffffa6p-2, INEXACT)
T(RN,   0x1.435747a78ceffp+20,    0x1.921fa89951976p+0,   -0x1.ffffbp-2, INEXACT)
T(RN,    0x1.45e7259e568dcp+1,    0x1.32512df5875fdp+0,   -0x1.fffffp-2, INEXACT)
T(RN,    0x1.d53abc5ec3f4fp+0,    0x1.12446be69aa3bp+0,  -0x1.ffffc6p-2, INEXACT)
T(RN,  -0x1.4f95b407d1d74p+33,   -0x1.921fb543e12c9p+0,  -0x1.ffffbap-2, INEXACT)
T(RN,   0x1.2e40ec8d159e6p+49,    0x1.921fb54442d11p+0,   -0x1.ffffcp-2, INEXACT)
T(RN,   0x1.d0a55d17938ccp+28,    0x1.921fb53b72191p+0,  -0x1.ffffb8p-2, INEXACT)
T(RN,    0x1.d59af5670838p+39,    0x1.921fb54441ba6p+0,  -0x1.ffffdep-2, INEXACT)
T(RZ,  -0x1.07337852c5051p+25,   -0x1.921fb4c7c355dp+0,  0x1.074a86p-23, INEXACT)
T(RU,  -0x1.07337852c5051p+25,   -0x1.921fb4c7c355dp+0,  0x1.074a86p-23, INEXACT)
T(RD,  -0x1.07337852c5051p+25,   -0x1.921fb4c7c355ep+0,  -0x1.fffffcp-1, INEXACT)
T(RN,  -0x1.0a4b62409fc2ap+16,   -0x1.921ebf29c3fd9p+0,  -0x1.ffffeep-2, INEXACT)
T(RZ,    0x1.45eb95c224cfbp+1,    0x1.32525d9da63bdp+0, -0x1.bca832p-25, INEXACT)
T(RD,    0x1.45eb95c224cfbp+1,    0x1.32525d9da63bdp+0, -0x1.bca832p-25, INEXACT)
T(RU,    0x1.45eb95c224cfbp+1,    0x1.32525d9da63bep+0,   0x1.fffffep-1, INEXACT)
T(RZ,   0x1.f1783c807f4fcp+38,    0x1.921fb54440c28p+0,  -0x1.fffff4p-1, INEXACT)
T(RD,   0x1.f1783c807f4fcp+38,    0x1.921fb54440c28p+0,  -0x1.fffff4p-1, INEXACT)
T(RU,   0x1.f1783c807f4fcp+38,    0x1.921fb54440c29p+0,  0x1.72fd3ap-22, INEXACT)
T(RN,   -0x1.9e3994c23c8cep+3,   -0x1.7e62e8ee9c3a5p+0,  -0x1.ffffeep-2, INEXACT)
T(RN,    0x1.6a02638ded2dcp+6,     0x1.8f4b99fca285p+0,  -0x1.fffffep-2, INEXACT)
T(RN,    0x1.20318b1fd164p+38,    0x1.921fb5443f43ep+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.2e40ec8ca1bfdp+49,    0x1.921fb54442d11p+0,   -0x1.ffffcp-2, INEXACT)
T(RN,    -0x1.1e14724968d2p+7,   -0x1.90558cbe4d496p+0,  -0x1.fffff6p-2, INEXACT)
T(RN,   -0x1.b881cc8849556p+9,   -0x1.91d552335c977p+0,  -0x1.fffff8p-2, INEXACT)
T(RZ,  -0x1.c1b7db276fbaep+15,   -0x1.921e91d0217a3p+0,   0x1.ffffeep-1, INEXACT)
T(RU,  -0x1.c1b7db276fbaep+15,   -0x1.921e91d0217a3p+0,   0x1.ffffeep-1, INEXACT)
T(RD,  -0x1.c1b7db276fbaep+15,   -0x1.921e91d0217a4p+0, -0x1.1e06bcp-21, INEXACT)
T(RN,   0x1.67ae38652bd47p+47,    0x1.921fb54442d01p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.05375e3a85206p+43,    0x1.921fb54442b22p+0,  -0x1.ffffc2p-2, INEXACT)
T(RZ,  -0x1.db6feff1bef1bp+23,   -0x1.921fb43092e07p+0,  0x1.be7be2p-21, INEXACT)
T(RU,  -0x1.db6feff1bef1bp+23,   -0x1.921fb43092e07p+0,  0x1.be7be2p-21, INEXACT)
T(RD,  -0x1.db6feff1bef1bp+23,   -0x1.921fb43092e08p+0,  -0x1.ffffe4p-1, INEXACT)
T(RZ,   -0x1.3702ca1f93ac3p-4,   -0x1.366a4dfc6e009p-4,   0x1.fffffcp-1, INEXACT)
T(RU,   -0x1.3702ca1f93ac3p-4,   -0x1.366a4dfc6e009p-4,   0x1.fffffcp-1, INEXACT)
T(RD,   -0x1.3702ca1f93ac3p-4,   -0x1.366a4dfc6e00ap-4,  -0x1.12267p-23, INEXACT)
T(RN,    0x1.a41eb7f7cd672p+8,     0x1.9183b6ffbd63p+0,   -0x1.fffffp-2, INEXACT)
T(RZ,  -0x1.f0d21ed2bf153p+27,   -0x1.921fb533c5acbp+0,  0x1.e2702ap-22, INEXACT)
T(RU,  -0x1.f0d21ed2bf153p+27,   -0x1.921fb533c5acbp+0,  0x1.e2702ap-22, INEXACT)
T(RD,  -0x1.f0d21ed2bf153p+27,   -0x1.921fb533c5accp+0,   -0x1.fffffp-1, INEXACT)
T(RZ,   -0x1.9e9abbf5a7b55p-2,   -0x1.89f2067379584p-2,   0x1.ffffeap-1, INEXACT)
T(RU,   -0x1.9e9abbf5a7b55p-2,   -0x1.89f2067379584p-2,   0x1.ffffeap-1, INEXACT)
T(RD,   -0x1.9e9abbf5a7b55p-2,   -0x1.89f2067379585p-2, -0x1.577b68p-21, INEXACT)
T(RZ,  -0x1.50bea49428a25p+32,   -0x1.921fb5438033bp+0,   0x1.ffffe2p-1, INEXACT)
T(RU,  -0x1.50bea49428a25p+32,   -0x1.921fb5438033bp+0,   0x1.ffffe2p-1, INEXACT)
T(RD,  -0x1.50bea49428a25p+32,   -0x1.921fb5438033cp+0, -0x1.d7415cp-21, INEXACT)
T(RN,   0x1.318db6223b70bp+27,    0x1.921fb529735dfp+0,  -0x1.fffff4p-2, INEXACT)
T(RZ,   0x1.2e317370b6062p+17,    0x1.921f48d52b383p+0,  -0x1.fffff4p-1, INEXACT)
T(RD,   0x1.2e317370b6062p+17,    0x1.921f48d52b383p+0,  -0x1.fffff4p-1, INEXACT)
T(RU,   0x1.2e317370b6062p+17,    0x1.921f48d52b384p+0,   0x1.8dd07p-22, INEXACT)
T(RZ,  -0x1.6e022561c7be2p+29,   -0x1.921fb53eaa5edp+0,  0x1.e3e298p-22, INEXACT)
T(RU,  -0x1.6e022561c7be2p+29,   -0x1.921fb53eaa5edp+0,  0x1.e3e298p-22, INEXACT)
T(RD,  -0x1.6e022561c7be2p+29,   -0x1.921fb53eaa5eep+0,   -0x1.fffffp-1, INEXACT)
T(RZ,  -0x1.f34557bc576bfp+13,   -0x1.921b9b28c8f5bp+0,   0x1.ffffecp-1, INEXACT)
T(RU,  -0x1.f34557bc576bfp+13,   -0x1.921b9b28c8f5bp+0,   0x1.ffffecp-1, INEXACT)
T(RD,  -0x1.f34557bc576bfp+13,   -0x1.921b9b28c8f5cp+0, -0x1.3e1118p-21, INEXACT)
T(RN,    0x1.60e50bdcc243ep+8,    0x1.9165ffb0944cfp+0,  -0x1.ffffe2p-2, INEXACT)
T(RN,  -0x1.03a385673053dp+48,   -0x1.921fb54442d09p+0,  -0x1.ffffc8p-2, INEXACT)
T(RZ,   0x1.35d545703dfffp+23,    0x1.921fb39d3867dp+0, -0x1.91782ap-21, INEXACT)
T(RD,   0x1.35d545703dfffp+23,    0x1.921fb39d3867dp+0, -0x1.91782ap-21, INEXACT)
T(RU,   0x1.35d545703dfffp+23,    0x1.921fb39d3867ep+0,   0x1.ffffe6p-1, INEXACT)
T(RZ,   0x1.e9bc817338c94p+42,      0x1.921fb54442bp+0,         -0x1p+0, INEXACT)
T(RD,   0x1.e9bc817338c94p+42,      0x1.921fb54442bp+0,         -0x1p+0, INEXACT)
T(RU,   0x1.e9bc817338c94p+42,    0x1.921fb54442b01p+0,  0x1.33b6a2p-26, INEXACT)
T(RZ,   0x1.fad99452b00b3p+23,    0x1.921fb441a8e8ep+0,  -0x1.fffff6p-1, INEXACT)
T(RD,   0x1.fad99452b00b3p+23,    0x1.921fb441a8e8ep+0,  -0x1.fffff6p-1, INEXACT)
T(RU,   0x1.fad99452b00b3p+23,    0x1.921fb441a8e8fp+0,  0x1.27e5a4p-22, INEXACT)
T(RN,  -0x1.d6c0073563d1ep+19,    -0x1.921fa3dd586ep+0,  -0x1.fffff8p-2, INEXACT)
T(RN,   0x1.9e3e8ec609d27p+47,    0x1.921fb54442d04p+0,  -0x1.ffffc4p-2, INEXACT)
T(RN,    0x1.21bf7d72aa3cfp+4,    0x1.840074b012c26p+0,  -0x1.ffffc8p-2, INEXACT)
T(RZ,   -0x1.b1416a939b67bp-1,   -0x1.6791ea2e9dffap-1,   0x1.fffffcp-1, INEXACT)
T(RU,   -0x1.b1416a939b67bp-1,   -0x1.6791ea2e9dffap-1,   0x1.fffffcp-1, INEXACT)
T(RD,   -0x1.b1416a939b67bp-1,   -0x1.6791ea2e9dffbp-1, -0x1.e46ab2p-24, INEXACT)
T(RZ,  -0x1.fba01c407ac4dp+46,   -0x1.921fb54442cf7p+0,   0x1.ffffe6p-1, INEXACT)
T(RU,  -0x1.fba01c407ac4dp+46,   -0x1.921fb54442cf7p+0,   0x1.ffffe6p-1, INEXACT)
T(RD,  -0x1.fba01c407ac4dp+46,   -0x1.921fb54442cf8p+0, -0x1.a63c28p-21, INEXACT)
T(RZ,    0x1.dd3098a3500ap+16,    0x1.921f2bede467ap+0, -0x1.b85536p-23, INEXACT)
T(RD,    0x1.dd3098a3500ap+16,    0x1.921f2bede467ap+0, -0x1.b85536p-23, INEXACT)
T(RU,    0x1.dd3098a3500ap+16,    0x1.921f2bede467bp+0,   0x1.fffffap-1, INEXACT)
T(RZ,   -0x1.ca176c4760c8p+33,   -0x1.921fb543fb496p+0,          0x1p+0, INEXACT)
T(RU,   -0x1.ca176c4760c8p+33,   -0x1.921fb543fb496p+0,          0x1p+0, INEXACT)
T(RD,   -0x1.ca176c4760c8p+33,   -0x1.921fb543fb497p+0, -0x1.5ad3dcp-26, INEXACT)
T(RN,   0x1.3683f73bf6a0ep+39,    0x1.921fb544412b6p+0,  -0x1.ffffc4p-2, INEXACT)
T(RN,   -0x1.e7c8e972ba1d7p+0,   -0x1.1665b129ca7a9p+0,  -0x1.ffffc6p-2, INEXACT)
T(RN,   0x1.07a1523be4a44p+23,    0x1.921fb35314646p+0,  -0x1.fffff2p-2, INEXACT)
T(RZ,   0x1.708395338a3a9p+13,    0x1.921a268ee1a5bp+0,   -0x1.ffffep-1, INEXACT)
T(RD,   0x1.708395338a3a9p+13,    0x1.921a268ee1a5bp+0,   -0x1.ffffep-1, INEXACT)
T(RU,   0x1.708395338a3a9p+13,    0x1.921a268ee1a5cp+0,  0x1.fe7894p-21, INEXACT)
T(RN,   -0x1.9ab51d1d67b76p+9,   -0x1.91cfec804e4aap+0,  -0x1.ffffdep-2, INEXACT)
T(RZ,   0x1.f627395c27faap+37,    0x1.921fb5443ebd7p+0, -0x1.a73188p-24, INEXACT)
T(RD,   0x1.f627395c27faap+37,    0x1.921fb5443ebd7p+0, -0x1.a73188p-24, INEXACT)
T(RU,   0x1.f627395c27faap+37,    0x1.921fb5443ebd8p+0,   0x1.fffffcp-1, INEXACT)
T(RN,   -0x1.132f415f4cbdp+26,   -0x1.921fb508b908fp+0,  -0x1.fffff6p-2, INEXACT)
T(RN,   0x1.8d5dd32aa82fep+21,    0x1.921fb01cdab87p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,  -0x1.58fa810a65d7dp+35,   -0x1.921fb5442b127p+0,  0x1.1b6806p-24, INEXACT)
T(RU,  -0x1.58fa810a65d7dp+35,   -0x1.921fb5442b127p+0,  0x1.1b6806p-24, INEXACT)
T(RD,  -0x1.58fa810a65d7dp+35,   -0x1.921fb5442b128p+0,  -0x1.fffffep-1, INEXACT)
T(RN,  -0x1.00ffa2f3210b8p+10,   -0x1.91dff4eebef16p+0,  -0x1.fffffap-2, INEXACT)
T(RZ,  -0x1.4bece82b26ef7p+35,   -0x1.921fb5442a236p+0,  0x1.c27fe2p-24, INEXACT)
T(RU,  -0x1.4bece82b26ef7p+35,   -0x1.921fb5442a236p+0,  0x1.c27fe2p-24, INEXACT)
T(RD,  -0x1.4bece82b26ef7p+35,   -0x1.921fb5442a237p+0,  -0x1.fffffcp-1, INEXACT)
T(RN,   0x1.aaad9a825f434p+26,    0x1.921fb51ddcaecp+0,   -0x1.ffffep-2, INEXACT)
T(RN,  -0x1.89d48471f2603p+18,   -0x1.921f8baa3a675p+0,  -0x1.ffffe2p-2, INEXACT)
T(RN,   0x1.49b81ce73843bp+33,    0x1.921fb543df6fdp+0,  -0x1.ffffe6p-2, INEXACT)
T(RZ,   0x1.9f70ec134e46dp+31,    0x1.921fb54307514p+0,  -0x1.fffff6p-1, INEXACT)
T(RD,   0x1.9f70ec134e46dp+31,    0x1.921fb54307514p+0,  -0x1.fffff6p-1, INEXACT)
T(RU,   0x1.9f70ec134e46dp+31,    0x1.921fb54307515p+0,  0x1.56df88p-22, INEXACT)
T(RN,   -0x1.d29b5fc39197p+11,   -0x1.920e26cb563bdp+0,  -0x1.ffffe4p-2, INEXACT)
T(RN,   0x1.8c1f41542c66fp+42,    0x1.921fb54442a82p+0,   -0x1.fffffp-2, INEXACT)
T(RZ,   0x1.23d8b78b1e703p+16,    0x1.921ed4b5d501ap+0,  -0x1.fffff2p-1, INEXACT)
T(RD,   0x1.23d8b78b1e703p+16,    0x1.921ed4b5d501ap+0,  -0x1.fffff2p-1, INEXACT)
T(RU,   0x1.23d8b78b1e703p+16,    0x1.921ed4b5d501bp+0,  0x1.b5e0dcp-22, INEXACT)
T(RZ,  -0x1.39c722d2df872p+20,   -0x1.921fa8367ba68p+0,  0x1.e7c95ap-23, INEXACT)
T(RU,  -0x1.39c722d2df872p+20,   -0x1.921fa8367ba68p+0,  0x1.e7c95ap-23, INEXACT)
T(RD,  -0x1.39c722d2df872p+20,   -0x1.921fa8367ba69p+0,  -0x1.fffff8p-1, INEXACT)
T(RN,  -0x1.acd4ed82cb816p+49,   -0x1.921fb54442d14p+0,  -0x1.fffff6p-2, INEXACT)
T(RN,  -0x1.acd4ed82bca67p+49,   -0x1.921fb54442d14p+0,  -0x1.fffff6p-2, INEXACT)
T(RZ,  -0x1.30aa24611160cp+34,   -0x1.921fb5440d0a8p+0,   0x1.fffffcp-1, INEXACT)
T(RU,  -0x1.30aa24611160cp+34,   -0x1.921fb5440d0a8p+0,   0x1.fffffcp-1, INEXACT)
T(RD,  -0x1.30aa24611160cp+34,   -0x1.921fb5440d0a9p+0, -0x1.247714p-23, INEXACT)
T(RZ,   0x1.8b2c78c733b79p+20,    0x1.921faae6ce212p+0,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.8b2c78c733b79p+20,    0x1.921faae6ce212p+0,  -0x1.fffffep-1, INEXACT)
T(RU,   0x1.8b2c78c733b79p+20,    0x1.921faae6ce213p+0,  0x1.41c5f2p-24, INEXACT)
T(RZ,  -0x1.8430a6fc5a8ebp+49,   -0x1.921fb54442d12p+0,   0x1.fffff2p-1, INEXACT)
T(RU,  -0x1.8430a6fc5a8ebp+49,   -0x1.921fb54442d12p+0,   0x1.fffff2p-1, INEXACT)
T(RD,  -0x1.8430a6fc5a8ebp+49,   -0x1.921fb54442d13p+0, -0x1.c8e8e2p-22, INEXACT)
T(RZ,   0x1.629331fd6f376p+40,    0x1.921fb5444218bp+0, -0x1.46857ap-22, INEXACT)
T(RD,   0x1.629331fd6f376p+40,    0x1.921fb5444218bp+0, -0x1.46857ap-22, INEXACT)
T(RU,   0x1.629331fd6f376p+40,    0x1.921fb5444218cp+0,   0x1.fffff6p-1, INEXACT)
T(RN,  -0x1.36fb8635998d2p+12,   -0x1.921289733b985p+0,  -0x1.fffffap-2, INEXACT)
T(RN,   0x1.b31d304a897ddp+39,    0x1.921fb54441a44p+0,  -0x1.fffff6p-2, INEXACT)
T(RN,  -0x1.8dba77c5761c3p+44,   -0x1.921fb54442c74p+0,  -0x1.ffffeep-2, INEXACT)
T(RZ,  -0x1.fafb1274c862ep+40,   -0x1.921fb54442503p+0,   0x1.fffff2p-1, INEXACT)
T(RU,  -0x1.fafb1274c862ep+40,   -0x1.921fb54442503p+0,   0x1.fffff2p-1, INEXACT)
T(RD,  -0x1.fafb1274c862ep+40,   -0x1.921fb54442504p+0, -0x1.c0fbe2p-22, INEXACT)
T(RZ,    0x1.01f9f80852fdap-4,    0x1.01a2d9deef07ep-4,  -0x1.fffff8p-1, INEXACT)
T(RD,    0x1.01f9f80852fdap-4,    0x1.01a2d9deef07ep-4,  -0x1.fffff8p-1, INEXACT)
T(RU,    0x1.01f9f80852fdap-4,    0x1.01a2d9deef07fp-4,  0x1.f7148ep-23, INEXACT)
T(RN,   0x1.50d0825e08f62p+18,    0x1.921f849f666a6p+0,  -0x1.fffff2p-2, INEXACT)
T(RN,  -0x1.3fd243d7d601bp+31,   -0x1.921fb542a8fd6p+0,  -0x1.ffffecp-2, INEXACT)
T(RZ,   0x1.3508159e92163p+42,    0x1.921fb544429c8p+0, -0x1.bed36ap-22, INEXACT)
T(RD,   0x1.3508159e92163p+42,    0x1.921fb544429c8p+0, -0x1.bed36ap-22, INEXACT)
T(RU,   0x1.3508159e92163p+42,    0x1.921fb544429c9p+0,   0x1.fffff2p-1, INEXACT)
T(RN,   0x1.238158f429262p+11,    0x1.92039b0cee03dp+0,  -0x1.ffffeap-2, INEXACT)
T(RZ,  -0x1.cc6fbd949c80ep+31,   -0x1.921fb54326263p+0,   0x1.fffff6p-1, INEXACT)
T(RU,  -0x1.cc6fbd949c80ep+31,   -0x1.921fb54326263p+0,   0x1.fffff6p-1, INEXACT)
T(RD,  -0x1.cc6fbd949c80ep+31,   -0x1.921fb54326264p+0, -0x1.2cd7f6p-22, INEXACT)
T(RZ,  -0x1.0a01b5054be15p+33,   -0x1.921fb543c7a23p+0,  0x1.bfebb6p-22, INEXACT)
T(RU,  -0x1.0a01b5054be15p+33,   -0x1.921fb543c7a23p+0,  0x1.bfebb6p-22, INEXACT)
T(RD,  -0x1.0a01b5054be15p+33,   -0x1.921fb543c7a24p+0,  -0x1.fffff2p-1, INEXACT)
T(RN,   0x1.70e83cd4b3716p+50,    0x1.921fb54442d15p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,    0x1.2ea8608d7315bp-2,    0x1.26478ab80a9bbp-2,  -0x1.fffffcp-1, INEXACT)
T(RD,    0x1.2ea8608d7315bp-2,    0x1.26478ab80a9bbp-2,  -0x1.fffffcp-1, INEXACT)
T(RU,    0x1.2ea8608d7315bp-2,    0x1.26478ab80a9bcp-2,  0x1.1da26ep-23, INEXACT)
T(RN,    0x1.975409801eae3p-2,    0x1.83adbbb2a2861p-2,  -0x1.ffffe6p-2, INEXACT)
T(RZ,  -0x1.86b5010b5c67dp+15,   -0x1.921e65caf4245p+0,  0x1.0ad942p-22, INEXACT)
T(RU,  -0x1.86b5010b5c67dp+15,   -0x1.921e65caf4245p+0,  0x1.0ad942p-22, INEXACT)
T(RD,  -0x1.86b5010b5c67dp+15,   -0x1.921e65caf4246p+0,  -0x1.fffff8p-1, INEXACT)
T(RZ,   -0x1.0b804d0504348p+7,   -0x1.9035bb06a5ce4p+0,   0x1.fffff8p-1, INEXACT)
T(RU,   -0x1.0b804d0504348p+7,   -0x1.9035bb06a5ce4p+0,   0x1.fffff8p-1, INEXACT)
T(RD,   -0x1.0b804d0504348p+7,   -0x1.9035bb06a5ce5p+0, -0x1.178a5ep-22, INEXACT)
T(RZ,   0x1.cac4f8cbee754p+11,    0x1.920dda0304242p+0, -0x1.8a3f28p-24, INEXACT)
T(RD,   0x1.cac4f8cbee754p+11,    0x1.920dda0304242p+0, -0x1.8a3f28p-24, INEXACT)
T(RU,   0x1.cac4f8cbee754p+11,    0x1.920dda0304243p+0,   0x1.fffffcp-1, INEXACT)
T(RN,    0x1.a612aa4588196p+1,    0x1.46bea81d04ab1p+0,  -0x1.ffffe4p-2, INEXACT)
T(RZ,   0x1.c570684797c06p+14,    0x1.921d7324876d2p+0, -0x1.27c738p-22, INEXACT)
T(RD,   0x1.c570684797c06p+14,    0x1.921d7324876d2p+0, -0x1.27c738p-22, INEXACT)
T(RU,   0x1.c570684797c06p+14,    0x1.921d7324876d3p+0,   0x1.fffff6p-1, INEXACT)
T(RN,  -0x1.571f3ae49ddc6p+36,   -0x1.921fb54436e19p+0,  -0x1.ffffeep-2, INEXACT)
T(RN,  -0x1.a8e448c657293p+32,   -0x1.921fb543a893bp+0,  -0x1.fffffap-2, INEXACT)
T(RN,   -0x1.ce6bf9fd1298p+16,   -0x1.921f278b1048fp+0,  -0x1.fffff8p-2, INEXACT)
T(RZ,    0x1.10ae487a90b3bp-1,    0x1.f51d828ebffd9p-2,         -0x1p+0, INEXACT)
T(RD,    0x1.10ae487a90b3bp-1,    0x1.f51d828ebffd9p-2,         -0x1p+0, INEXACT)
T(RU,    0x1.10ae487a90b3bp-1,    0x1.f51d828ebffdap-2,  0x1.170792p-26, INEXACT)
T(RZ,    0x1.417086602e127p+7,    0x1.9087f29cef487p+0, -0x1.0fd8dap-24, INEXACT)
T(RD,    0x1.417086602e127p+7,    0x1.9087f29cef487p+0, -0x1.0fd8dap-24, INEXACT)
T(RU,    0x1.417086602e127p+7,    0x1.9087f29cef488p+0,   0x1.fffffep-1, INEXACT)
T(RZ,   -0x1.924b5671ed92ep+5,   -0x1.8d08a286ca1d4p+0,  0x1.334cb4p-24, INEXACT)
T(RU,   -0x1.924b5671ed92ep+5,   -0x1.8d08a286ca1d4p+0,  0x1.334cb4p-24, INEXACT)
T(RD,   -0x1.924b5671ed92ep+5,   -0x1.8d08a286ca1d5p+0,  -0x1.fffffep-1, INEXACT)
T(RZ,   -0x1.b26752436b14cp-3,   -0x1.ac0f29d85d44bp-3,   0x1.fffffcp-1, INEXACT)
T(RU,   -0x1.b26752436b14cp-3,   -0x1.ac0f29d85d44bp-3,   0x1.fffffcp-1, INEXACT)
T(RD,   -0x1.b26752436b14cp-3,   -0x1.ac0f29d85d44cp-3, -0x1.d6e524p-24, INEXACT)
T(RN,   0x1.49ff15c0df12ep+52,    0x1.921fb54442d17p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,  -0x1.6afa095694d37p+45,   -0x1.921fb54442cbep+0,  0x1.722a4cp-23, INEXACT)
T(RU,  -0x1.6afa095694d37p+45,   -0x1.921fb54442cbep+0,  0x1.722a4cp-23, INEXACT)
T(RD,  -0x1.6afa095694d37p+45,   -0x1.921fb54442cbfp+0,  -0x1.fffffap-1, INEXACT)
T(RZ,   0x1.468863e9ddb5ap+13,    0x1.92196fa531342p+0, -0x1.bdedc6p-24, INEXACT)
T(RD,   0x1.468863e9ddb5ap+13,    0x1.92196fa531342p+0, -0x1.bdedc6p-24, INEXACT)
T(RU,   0x1.468863e9ddb5ap+13,    0x1.92196fa531343p+0,   0x1.fffffcp-1, INEXACT)
T(RN,  -0x1.acd4ed82c63d5p+49,   -0x1.921fb54442d14p+0,  -0x1.fffff6p-2, INEXACT)
T(RZ,   -0x1.a7eaee03d6b69p-3,   -0x1.a203b1ac12dc9p-3,   0x1.fffff8p-1, INEXACT)
T(RU,   -0x1.a7eaee03d6b69p-3,   -0x1.a203b1ac12dc9p-3,   0x1.fffff8p-1, INEXACT)
T(RD,   -0x1.a7eaee03d6b69p-3,   -0x1.a203b1ac12dcap-3, -0x1.cd1c34p-23, INEXACT)
T(RZ,    0x1.9f3dd676f972cp+5,     0x1.8d31412c9ce5p+0, -0x1.430c24p-25, INEXACT)
T(RD,    0x1.9f3dd676f972cp+5,     0x1.8d31412c9ce5p+0, -0x1.430c24p-25, INEXACT)
T(RU,    0x1.9f3dd676f972cp+5,    0x1.8d31412c9ce51p+0,   0x1.fffffep-1, INEXACT)
T(RN,   0x1.49ff15c0db8e4p+52,    0x1.921fb54442d17p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,   0x1.e9bc8172ce29cp+42,      0x1.921fb54442bp+0,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.e9bc8172ce29cp+42,      0x1.921fb54442bp+0,  -0x1.fffffep-1, INEXACT)
T(RU,   0x1.e9bc8172ce29cp+42,    0x1.921fb54442b01p+0,  0x1.82ee9ap-25, INEXACT)
T(RZ,  -0x1.6b41c5e5d48c7p+48,   -0x1.921fb54442d0dp+0,  0x1.b6271ep-23, INEXACT)
T(RU,  -0x1.6b41c5e5d48c7p+48,   -0x1.921fb54442d0dp+0,  0x1.b6271ep-23, INEXACT)
T(RD,  -0x1.6b41c5e5d48c7p+48,   -0x1.921fb54442d0ep+0,  -0x1.fffffap-1, INEXACT)
T(RZ,  -0x1.197b7dab4a6abp+49,    -0x1.921fb54442d1p+0,   0x1.fffffcp-1, INEXACT)
T(RU,  -0x1.197b7dab4a6abp+49,    -0x1.921fb54442d1p+0,   0x1.fffffcp-1, INEXACT)
T(RD,  -0x1.197b7dab4a6abp+49,   -0x1.921fb54442d11p+0, -0x1.315eaep-23, INEXACT)
T(RZ,   0x1.1eeb7895abe75p+48,    0x1.921fb54442d0ap+0, -0x1.fb710ap-24, INEXACT)
T(RD,   0x1.1eeb7895abe75p+48,    0x1.921fb54442d0ap+0, -0x1.fb710ap-24, INEXACT)
T(RU,   0x1.1eeb7895abe75p+48,    0x1.921fb54442d0bp+0,   0x1.fffffcp-1, INEXACT)
T(RN,  -0x1.8f9d0d37bd1d8p+21,   -0x1.921fb02445f37p+0,  -0x1.fffff8p-2, INEXACT)
T(RN,   -0x1.eb29f50fcd26p+11,   -0x1.920f0781b379fp+0,  -0x1.fffff2p-2, INEXACT)
T(RN,   -0x1.f18b23b3a7687p+5,   -0x1.8e020bba2058fp+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.d72cc62a08f26p+34,    0x1.921fb544200bbp+0,         -0x1p-1, INEXACT)
T(RZ,  -0x1.197b7dab55b74p+49,    -0x1.921fb54442d1p+0,   0x1.fffffcp-1, INEXACT)
T(RU,  -0x1.197b7dab55b74p+49,    -0x1.921fb54442d1p+0,   0x1.fffffcp-1, INEXACT)
T(RD,  -0x1.197b7dab55b74p+49,   -0x1.921fb54442d11p+0, -0x1.31394cp-23, INEXACT)
T(RN,   0x1.67ae386508e34p+47,    0x1.921fb54442d01p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,  -0x1.7e04f254cde0ep+45,   -0x1.921fb54442cc3p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,   0x1.629331fd1a37ep+40,    0x1.921fb5444218bp+0, -0x1.2a9626p-23, INEXACT)
T(RD,   0x1.629331fd1a37ep+40,    0x1.921fb5444218bp+0, -0x1.2a9626p-23, INEXACT)
T(RU,   0x1.629331fd1a37ep+40,    0x1.921fb5444218cp+0,   0x1.fffffcp-1, INEXACT)
T(RZ,  -0x1.f1f02bf3faa5ep+22,   -0x1.921fb335cd54ap+0,  0x1.99e866p-23, INEXACT)
T(RU,  -0x1.f1f02bf3faa5ep+22,   -0x1.921fb335cd54ap+0,  0x1.99e866p-23, INEXACT)
T(RD,  -0x1.f1f02bf3faa5ep+22,   -0x1.921fb335cd54bp+0,  -0x1.fffffap-1, INEXACT)
T(RZ,   0x1.b4b3f35b4d1bap+16,    0x1.921f1f3258a6ep+0, -0x1.55e84cp-23, INEXACT)
T(RD,   0x1.b4b3f35b4d1bap+16,    0x1.921f1f3258a6ep+0, -0x1.55e84cp-23, INEXACT)
T(RU,   0x1.b4b3f35b4d1bap+16,    0x1.921f1f3258a6fp+0,   0x1.fffffap-1, INEXACT)
T(RZ,   -0x1.1fe0e1cfd735ep-2,   -0x1.18a283b882832p-2,  0x1.55357ep-23, INEXACT)
T(RU,   -0x1.1fe0e1cfd735ep-2,   -0x1.18a283b882832p-2,  0x1.55357ep-23, INEXACT)
T(RD,   -0x1.1fe0e1cfd735ep-2,   -0x1.18a283b882833p-2,  -0x1.fffffap-1, INEXACT)
T(RZ,   -0x1.007c5fe6d91ffp+1,   -0x1.1b9fc5d57599cp+0,  0x1.4ab5dcp-23, INEXACT)
T(RU,   -0x1.007c5fe6d91ffp+1,   -0x1.1b9fc5d57599cp+0,  0x1.4ab5dcp-23, INEXACT)
T(RD,   -0x1.007c5fe6d91ffp+1,   -0x1.1b9fc5d57599dp+0,  -0x1.fffffap-1, INEXACT)
T(RZ,   0x1.c335496f0a39dp+18,    0x1.921f90f48adcap+0, -0x1.679f46p-23, INEXACT)
T(RD,   0x1.c335496f0a39dp+18,    0x1.921f90f48adcap+0, -0x1.679f46p-23, INEXACT)
T(RU,   0x1.c335496f0a39dp+18,    0x1.921f90f48adcbp+0,   0x1.fffffap-1, INEXACT)
T(RN,   0x1.b31d304aab0cap+39,    0x1.921fb54441a44p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,    0x1.e9bc8172cbbdp+42,      0x1.921fb54442bp+0,  -0x1.fffffep-1, INEXACT)
T(RD,    0x1.e9bc8172cbbdp+42,      0x1.921fb54442bp+0,  -0x1.fffffep-1, INEXACT)
T(RU,    0x1.e9bc8172cbbdp+42,    0x1.921fb54442b01p+0,  0x1.883b8cp-25, INEXACT)
T(RN,    0x1.993055d601ddcp+5,    0x1.8d1e95c446f82p+0,  -0x1.fffffep-2, INEXACT)
T(RN,     0x1.866f223c18e7p+9,    0x1.91cbc7f15d27fp+0,  -0x1.fffff4p-2, INEXACT)
T(RN,   0x1.16203effb50f5p+13,    0x1.9218583155ff4p+0,  -0x1.fffff8p-2, INEXACT)
T(RN,   0x1.49ff15c0c65a3p+52,    0x1.921fb54442d17p+0,  -0x1.fffffep-2, INEXACT)
T(RN,    0x1.a65e7b1cb174ep-1,    0x1.6128c2637b187p-1,  -0x1.fffff8p-2, INEXACT)
T(RN,  -0x1.8658d44ece551p+23,   -0x1.921fb3f47a4b4p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.301a522cd1004p+37,    0x1.921fb5443c157p+0,  -0x1.fffff8p-2, INEXACT)
T(RN,  -0x1.1ea44e7ec044bp+17,   -0x1.921f42f323824p+0,  -0x1.fffff8p-2, INEXACT)
T(RZ,  -0x1.defa8067a73d6p+49,   -0x1.921fb54442d14p+0,  0x1.cab08ap-24, INEXACT)
T(RU,  -0x1.defa8067a73d6p+49,   -0x1.921fb54442d14p+0,  0x1.cab08ap-24, INEXACT)
T(RD,  -0x1.defa8067a73d6p+49,   -0x1.921fb54442d15p+0,  -0x1.fffffcp-1, INEXACT)
T(RN,    0x1.0ffa2b9894c7cp+0,    0x1.a19ce512c93bbp-1,  -0x1.fffff8p-2, INEXACT)
T(RN,   0x1.acb028a7ab581p+13,    0x1.921aee42cfa73p+0,  -0x1.fffffep-2, INEXACT)
T(RN,   -0x1.de803bc80c2a8p-4,   -0x1.dc57819838b7fp-4,  -0x1.fffffap-2, INEXACT)
T(RZ,   0x1.4141e5608f23dp+18,    0x1.921f82445cdf7p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.4141e5608f23dp+18,    0x1.921f82445cdf7p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.4141e5608f23dp+18,    0x1.921f82445cdf8p+0,  0x1.1476dap-26, INEXACT)
T(RN,    0x1.0e66b078e27a5p+2,    0x1.56a094b9a8752p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,  -0x1.6b077a5e6d273p+25,   -0x1.921fb4e9ff90ap+0,  0x1.d1b462p-25, INEXACT)
T(RU,  -0x1.6b077a5e6d273p+25,   -0x1.921fb4e9ff90ap+0,  0x1.d1b462p-25, INEXACT)
T(RD,  -0x1.6b077a5e6d273p+25,   -0x1.921fb4e9ff90bp+0,  -0x1.fffffep-1, INEXACT)
T(RZ,    0x1.bb0ef4e14fdcp+14,    0x1.921d6598f597fp+0, -0x1.840c28p-24, INEXACT)
T(RD,    0x1.bb0ef4e14fdcp+14,    0x1.921d6598f597fp+0, -0x1.840c28p-24, INEXACT)
T(RU,    0x1.bb0ef4e14fdcp+14,     0x1.921d6598f598p+0,   0x1.fffffcp-1, INEXACT)
T(RZ,   0x1.c8787bdff9a97p+39,    0x1.921fb54441b26p+0, -0x1.c6c712p-24, INEXACT)
T(RD,   0x1.c8787bdff9a97p+39,    0x1.921fb54441b26p+0, -0x1.c6c712p-24, INEXACT)
T(RU,   0x1.c8787bdff9a97p+39,    0x1.921fb54441b27p+0,   0x1.fffffcp-1, INEXACT)
T(RZ,   0x1.2de8d2b37d392p+19,    0x1.921f9a21f7796p+0,  -0x1.fffffcp-1, INEXACT)
T(RD,   0x1.2de8d2b37d392p+19,    0x1.921f9a21f7796p+0,  -0x1.fffffcp-1, INEXACT)
T(RU,   0x1.2de8d2b37d392p+19,    0x1.921f9a21f7797p+0,  0x1.b76174p-24, INEXACT)
T(RZ,   0x1.6c913ba5a0985p+21,    0x1.921fafa626972p+0,  -0x1.fffffcp-1, INEXACT)
T(RD,   0x1.6c913ba5a0985p+21,    0x1.921fafa626972p+0,  -0x1.fffffcp-1, INEXACT)
T(RU,   0x1.6c913ba5a0985p+21,    0x1.921fafa626973p+0,  0x1.da806ap-24, INEXACT)
T(RN,   -0x1.58690fb2a3222p+8,   -0x1.91616c8ab1556p+0,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.70e83cd4db5abp+50,    0x1.921fb54442d15p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,  -0x1.222054cd1c327p+20,   -0x1.921fa7260e409p+0,  0x1.f313a8p-24, INEXACT)
T(RU,  -0x1.222054cd1c327p+20,   -0x1.921fa7260e409p+0,  0x1.f313a8p-24, INEXACT)
T(RD,  -0x1.222054cd1c327p+20,   -0x1.921fa7260e40ap+0,  -0x1.fffffcp-1, INEXACT)
T(RZ,  -0x1.ba8f8e925bd98p+11,   -0x1.920d32974ae7bp+0,   0x1.fffffep-1, INEXACT)
T(RU,  -0x1.ba8f8e925bd98p+11,   -0x1.920d32974ae7bp+0,   0x1.fffffep-1, INEXACT)
T(RD,  -0x1.ba8f8e925bd98p+11,   -0x1.920d32974ae7cp+0, -0x1.42becap-24, INEXACT)
T(RN,  -0x1.05076fa47177bp+26,    -0x1.921fb5057e7ap+0,  -0x1.fffffap-2, INEXACT)
T(RZ,  -0x1.047e7f7f31098p+21,   -0x1.921fad6798033p+0,  0x1.67a50ap-24, INEXACT)
T(RU,  -0x1.047e7f7f31098p+21,   -0x1.921fad6798033p+0,  0x1.67a50ap-24, INEXACT)
T(RD,  -0x1.047e7f7f31098p+21,   -0x1.921fad6798034p+0,  -0x1.fffffep-1, INEXACT)
T(RZ,   0x1.e9bc81733e9bap+42,      0x1.921fb54442bp+0,         -0x1p+0, INEXACT)
T(RD,   0x1.e9bc81733e9bap+42,      0x1.921fb54442bp+0,         -0x1p+0, INEXACT)
T(RU,   0x1.e9bc81733e9bap+42,    0x1.921fb54442b01p+0,  0x1.1a42c8p-26, INEXACT)
T(RN,   0x1.b128b33255865p+32,    0x1.921fb543ab854p+0,  -0x1.fffffap-2, INEXACT)
T(RN,   0x1.67ae3864cacffp+47,    0x1.921fb54442d01p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   -0x1.427a9f7ebd0f8p+8,   -0x1.91547bab7cda9p+0,  -0x1.fffffap-2, INEXACT)
T(RZ,   0x1.7400ff17223fdp+31,    0x1.921fb542e27a6p+0, -0x1.4332ecp-24, INEXACT)
T(RD,   0x1.7400ff17223fdp+31,    0x1.921fb542e27a6p+0, -0x1.4332ecp-24, INEXACT)
T(RU,   0x1.7400ff17223fdp+31,    0x1.921fb542e27a7p+0,   0x1.fffffep-1, INEXACT)
T(RZ,   0x1.6cab83b472566p+20,    0x1.921faa08d9a65p+0, -0x1.6ccfa2p-24, INEXACT)
T(RD,   0x1.6cab83b472566p+20,    0x1.921faa08d9a65p+0, -0x1.6ccfa2p-24, INEXACT)
T(RU,   0x1.6cab83b472566p+20,    0x1.921faa08d9a66p+0,   0x1.fffffep-1, INEXACT)
T(RZ,  -0x1.b49ad2bac9965p+37,   -0x1.921fb5443e20bp+0,  0x1.9351f2p-24, INEXACT)
T(RU,  -0x1.b49ad2bac9965p+37,   -0x1.921fb5443e20bp+0,  0x1.9351f2p-24, INEXACT)
T(RD,  -0x1.b49ad2bac9965p+37,   -0x1.921fb5443e20cp+0,  -0x1.fffffcp-1, INEXACT)
T(RZ,    0x1.21f6d0b9b63e6p+6,    0x1.8e97b56fe994cp+0, -0x1.b55886p-24, INEXACT)
T(RD,    0x1.21f6d0b9b63e6p+6,    0x1.8e97b56fe994cp+0, -0x1.b55886p-24, INEXACT)
T(RU,    0x1.21f6d0b9b63e6p+6,    0x1.8e97b56fe994dp+0,   0x1.fffffcp-1, INEXACT)
T(RZ,    -0x1.bc1e998e9f4ep+9,   -0x1.91d5ed192aa65p+0,  0x1.7edbaep-24, INEXACT)
T(RU,    -0x1.bc1e998e9f4ep+9,   -0x1.91d5ed192aa65p+0,  0x1.7edbaep-24, INEXACT)
T(RD,    -0x1.bc1e998e9f4ep+9,   -0x1.91d5ed192aa66p+0,  -0x1.fffffep-1, INEXACT)
T(RZ,   -0x1.cbf0f8ac65668p+9,   -0x1.91d876d785613p+0,          0x1p+0, INEXACT)
T(RU,   -0x1.cbf0f8ac65668p+9,   -0x1.91d876d785613p+0,          0x1p+0, INEXACT)
T(RD,   -0x1.cbf0f8ac65668p+9,   -0x1.91d876d785614p+0,  -0x1.918acp-27, INEXACT)
T(RZ,  -0x1.e54a47e03701cp+24,   -0x1.921fb4bd374dap+0,   0x1.fffffep-1, INEXACT)
T(RU,  -0x1.e54a47e03701cp+24,   -0x1.921fb4bd374dap+0,   0x1.fffffep-1, INEXACT)
T(RD,  -0x1.e54a47e03701cp+24,   -0x1.921fb4bd374dbp+0,  -0x1.40e21p-24, INEXACT)
T(RZ,  -0x1.b49ad2bac8438p+37,   -0x1.921fb5443e20bp+0,   0x1.59142p-24, INEXACT)
T(RU,  -0x1.b49ad2bac8438p+37,   -0x1.921fb5443e20bp+0,   0x1.59142p-24, INEXACT)
T(RD,  -0x1.b49ad2bac8438p+37,   -0x1.921fb5443e20cp+0,  -0x1.fffffep-1, INEXACT)
T(RZ,   -0x1.aedd1a700bf42p+3,   -0x1.7f254e79ae558p+0,   0x1.fffffcp-1, INEXACT)
T(RU,   -0x1.aedd1a700bf42p+3,   -0x1.7f254e79ae558p+0,   0x1.fffffcp-1, INEXACT)
T(RD,   -0x1.aedd1a700bf42p+3,   -0x1.7f254e79ae559p+0, -0x1.b55cd4p-24, INEXACT)
T(RN,   0x1.df5841a5d91f9p+26,    0x1.921fb52214bd8p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.5a171dd19edb2p+40,    0x1.921fb54442142p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,  -0x1.7e04f254d6d1dp+45,   -0x1.921fb54442cc3p+0,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.6db6e3ca27b18p+30,    0x1.921fb5417604cp+0,  -0x1.fffffcp-2, INEXACT)
T(RN,    0x1.4d204557d9948p-2,    0x1.42117f165525ap-2,  -0x1.fffffcp-2, INEXACT)
T(RN,  -0x1.24fe20e999e3dp+37,   -0x1.921fb5443bd42p+0,         -0x1p-1, INEXACT)
T(RN,   0x1.b31d304aaebb9p+39,    0x1.921fb54441a44p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,  -0x1.4591662a2f6b8p+26,   -0x1.921fb511efc83p+0,  -0x1.fffffap-2, INEXACT)
T(RN,   -0x1.7227bcffa390ap+6,   -0x1.8f5b89138dad7p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,  -0x1.fb8bccb00b513p+37,   -0x1.921fb5443ec89p+0,  -0x1.fffffap-2, INEXACT)
T(RZ,  -0x1.e66dd8b894ca9p+34,   -0x1.921fb5442122dp+0,   0x1.fffffep-1, INEXACT)
T(RU,  -0x1.e66dd8b894ca9p+34,   -0x1.921fb5442122dp+0,   0x1.fffffep-1, INEXACT)
T(RD,  -0x1.e66dd8b894ca9p+34,   -0x1.921fb5442122ep+0, -0x1.dd8cacp-25, INEXACT)
T(RZ,   0x1.e9bc8172dfacbp+42,      0x1.921fb54442bp+0,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.e9bc8172dfacbp+42,      0x1.921fb54442bp+0,  -0x1.fffffep-1, INEXACT)
T(RU,   0x1.e9bc8172dfacbp+42,    0x1.921fb54442b01p+0,  0x1.5ca702p-25, INEXACT)
T(RZ,   -0x1.fedf8168959bcp-2,    -0x1.d9df8aa86e3dp-2,  0x1.65bd68p-26, INEXACT)
T(RU,   -0x1.fedf8168959bcp-2,    -0x1.d9df8aa86e3dp-2,  0x1.65bd68p-26, INEXACT)
T(RD,   -0x1.fedf8168959bcp-2,   -0x1.d9df8aa86e3d1p-2,         -0x1p+0, INEXACT)
T(RN,   0x1.70e83cd5110a7p+50,    0x1.921fb54442d15p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,  -0x1.cc5ce237aa974p+17,   -0x1.921f6e168774bp+0,  0x1.9ddf46p-25, INEXACT)
T(RU,  -0x1.cc5ce237aa974p+17,   -0x1.921f6e168774bp+0,  0x1.9ddf46p-25, INEXACT)
T(RD,  -0x1.cc5ce237aa974p+17,   -0x1.921f6e168774cp+0,  -0x1.fffffep-1, INEXACT)
T(RN,   0x1.d5a2c2919baadp+35,      0x1.921fb544316p+0,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.a4a82dfb2bb6cp+31,   -0x1.921fb5430b3adp+0,  -0x1.fffffep-2, INEXACT)
T(RZ,    0x1.b089247d781a8p+9,    0x1.91d3f340540a1p+0,         -0x1p+0, INEXACT)
T(RD,    0x1.b089247d781a8p+9,    0x1.91d3f340540a1p+0,         -0x1p+0, INEXACT)
T(RU,    0x1.b089247d781a8p+9,    0x1.91d3f340540a2p+0,  0x1.0bc07ap-28, INEXACT)
T(RZ,  -0x1.98b4c6bca62f1p+32,   -0x1.921fb543a277fp+0,  0x1.d1fe0ap-25, INEXACT)
T(RU,  -0x1.98b4c6bca62f1p+32,   -0x1.921fb543a277fp+0,  0x1.d1fe0ap-25, INEXACT)
T(RD,  -0x1.98b4c6bca62f1p+32,    -0x1.921fb543a278p+0,  -0x1.fffffep-1, INEXACT)
T(RN,   -0x1.feab7700f038ap-3,   -0x1.f476d21ac4ef9p-3,         -0x1p-1, INEXACT)
T(RZ,  -0x1.62fe5180d66c6p+35,   -0x1.921fb5442bbdep+0,          0x1p+0, INEXACT)
T(RU,  -0x1.62fe5180d66c6p+35,   -0x1.921fb5442bbdep+0,          0x1p+0, INEXACT)
T(RD,  -0x1.62fe5180d66c6p+35,   -0x1.921fb5442bbdfp+0, -0x1.a19322p-29, INEXACT)
T(RN,   0x1.49ff15c0c65d3p+52,    0x1.921fb54442d17p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,  -0x1.0c0d125e73185p+29,   -0x1.921fb53c9ee48p+0,  0x1.dd8376p-25, INEXACT)
T(RU,  -0x1.0c0d125e73185p+29,   -0x1.921fb53c9ee48p+0,  0x1.dd8376p-25, INEXACT)
T(RD,  -0x1.0c0d125e73185p+29,   -0x1.921fb53c9ee49p+0,  -0x1.fffffep-1, INEXACT)
T(RN,    0x1.70e83cd4cd77p+50,    0x1.921fb54442d15p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.49ff15c072637p+52,    0x1.921fb54442d17p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,   -0x1.ce5c177c6520dp+3,   -0x1.806f2bd35a165p+0,   0x1.fffffep-1, INEXACT)
T(RU,   -0x1.ce5c177c6520dp+3,   -0x1.806f2bd35a165p+0,   0x1.fffffep-1, INEXACT)
T(RD,   -0x1.ce5c177c6520dp+3,   -0x1.806f2bd35a166p+0, -0x1.f31b2cp-25, INEXACT)
T(RZ,  -0x1.e51c5f341ea9ap+25,   -0x1.921fb500b6abbp+0,   0x1.fffffep-1, INEXACT)
T(RU,  -0x1.e51c5f341ea9ap+25,   -0x1.921fb500b6abbp+0,   0x1.fffffep-1, INEXACT)
T(RD,  -0x1.e51c5f341ea9ap+25,   -0x1.921fb500b6abcp+0, -0x1.eae3b8p-25, INEXACT)
T(RZ,   0x1.b07e95b247e1fp+11,    0x1.920cc44c669a1p+0, -0x1.b00052p-26, INEXACT)
T(RD,   0x1.b07e95b247e1fp+11,    0x1.920cc44c669a1p+0, -0x1.b00052p-26, INEXACT)
T(RU,   0x1.b07e95b247e1fp+11,    0x1.920cc44c669a2p+0,          0x1p+0, INEXACT)
T(RN,   0x1.70e83cd4ca646p+50,    0x1.921fb54442d15p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.70e83cd4d57fbp+50,    0x1.921fb54442d15p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,  -0x1.caf0c319d0847p+33,   -0x1.921fb543fb6b5p+0,   0x1.8dcc6p-25, INEXACT)
T(RU,  -0x1.caf0c319d0847p+33,   -0x1.921fb543fb6b5p+0,   0x1.8dcc6p-25, INEXACT)
T(RD,  -0x1.caf0c319d0847p+33,   -0x1.921fb543fb6b6p+0,  -0x1.fffffep-1, INEXACT)
T(RN,    0x1.2a1f0c1ac40c7p-2,    0x1.221a3b383ea95p-2,         -0x1p-1, INEXACT)
T(RN,   0x1.49ff15c0ba6c3p+52,    0x1.921fb54442d17p+0,  -0x1.fffffep-2, INEXACT)
T(RN,    0x1.7bbc4bd031bf1p-2,    0x1.6ba3290fdc02ap-2,  -0x1.fffffep-2, INEXACT)
T(RZ,   0x1.8512ff77f91fdp+30,     0x1.921fb541a10ep+0,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.8512ff77f91fdp+30,     0x1.921fb541a10ep+0,  -0x1.fffffep-1, INEXACT)
T(RU,   0x1.8512ff77f91fdp+30,    0x1.921fb541a10e1p+0,  0x1.d68c16p-25, INEXACT)
T(RZ,   0x1.b2994273a4c42p+16,    0x1.921f1e78551e1p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.b2994273a4c42p+16,    0x1.921f1e78551e1p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.b2994273a4c42p+16,    0x1.921f1e78551e2p+0,   0x1.3d53bp-33, INEXACT)
T(RN,    0x1.286312c9d7988p+4,    0x1.84514722290e1p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,   -0x1.26c5581ca467bp+7,   -0x1.90630ec36ff61p+0,   0x1.d5651p-26, INEXACT)
T(RU,   -0x1.26c5581ca467bp+7,   -0x1.90630ec36ff61p+0,   0x1.d5651p-26, INEXACT)
T(RD,   -0x1.26c5581ca467bp+7,   -0x1.90630ec36ff62p+0,         -0x1p+0, INEXACT)
T(RN,    0x1.83394983e416cp+0,    0x1.f929abb29b38fp-1,  -0x1.fffffcp-2, INEXACT)
T(RZ,   0x1.76f2cbf954eb3p+17,    0x1.921f5ddf900bap+0,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.76f2cbf954eb3p+17,    0x1.921f5ddf900bap+0,  -0x1.fffffep-1, INEXACT)
T(RU,   0x1.76f2cbf954eb3p+17,    0x1.921f5ddf900bbp+0,  0x1.efaa62p-25, INEXACT)
T(RN,  -0x1.e96df8aaf4176p+13,   -0x1.921b860b499d6p+0,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.381eba6cde9a4p+16,    0x1.921ee34bcff6dp+0,  -0x1.fffffep-2, INEXACT)
T(RN,    0x1.781198a97bbb3p+1,    0x1.3e23b26a2dbcbp+0,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.47fe87d0af1fep+34,    0x1.921fb54410ddcp+0,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.e1f2955370f0fp+14,   -0x1.921d95571cc0bp+0,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.b016935ce3e88p+33,    0x1.921fb543f6fb6p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,  -0x1.b49ad2bac45b1p+37,   -0x1.921fb5443e20bp+0,  0x1.5a358ap-25, INEXACT)
T(RU,  -0x1.b49ad2bac45b1p+37,   -0x1.921fb5443e20bp+0,  0x1.5a358ap-25, INEXACT)
T(RD,  -0x1.b49ad2bac45b1p+37,   -0x1.921fb5443e20cp+0,  -0x1.fffffep-1, INEXACT)
T(RZ,  -0x1.5353d52d82eccp+37,   -0x1.921fb5443cc87p+0,  0x1.6ed294p-26, INEXACT)
T(RU,  -0x1.5353d52d82eccp+37,   -0x1.921fb5443cc87p+0,  0x1.6ed294p-26, INEXACT)
T(RD,  -0x1.5353d52d82eccp+37,   -0x1.921fb5443cc88p+0,         -0x1p+0, INEXACT)
T(RZ,  -0x1.be5aed85c501cp+22,   -0x1.921fb2f8f63f9p+0,          0x1p+0, INEXACT)
T(RU,  -0x1.be5aed85c501cp+22,   -0x1.921fb2f8f63f9p+0,          0x1p+0, INEXACT)
T(RD,  -0x1.be5aed85c501cp+22,   -0x1.921fb2f8f63fap+0, -0x1.cb9fdcp-26, INEXACT)
T(RZ,   0x1.c8787bdfb6557p+39,    0x1.921fb54441b25p+0,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.c8787bdfb6557p+39,    0x1.921fb54441b25p+0,  -0x1.fffffep-1, INEXACT)
T(RU,   0x1.c8787bdfb6557p+39,    0x1.921fb54441b26p+0,  0x1.bdbae4p-25, INEXACT)
T(RZ,  -0x1.7889e7fb82f24p+16,   -0x1.921f0737d77e4p+0,          0x1p+0, INEXACT)
T(RU,  -0x1.7889e7fb82f24p+16,   -0x1.921f0737d77e4p+0,          0x1p+0, INEXACT)
T(RD,  -0x1.7889e7fb82f24p+16,   -0x1.921f0737d77e5p+0, -0x1.8b2ac4p-26, INEXACT)
T(RN,    0x1.ea5f294f81bcdp+4,    0x1.89c623381854ep+0,  -0x1.fffffep-2, INEXACT)
T(RZ,   0x1.6341ab9d7b44ap+35,    0x1.921fb5442bc24p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.6341ab9d7b44ap+35,    0x1.921fb5442bc24p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.6341ab9d7b44ap+35,    0x1.921fb5442bc25p+0,  0x1.08c562p-26, INEXACT)
T(RZ,  -0x1.a97b1e1dd1c76p+12,   -0x1.921614d159bf5p+0,  0x1.123ceep-26, INEXACT)
T(RU,  -0x1.a97b1e1dd1c76p+12,   -0x1.921614d159bf5p+0,  0x1.123ceep-26, INEXACT)
T(RD,  -0x1.a97b1e1dd1c76p+12,   -0x1.921614d159bf6p+0,         -0x1p+0, INEXACT)
T(RZ,   0x1.1ae2fc7aa3558p+12,    0x1.92113a9113dc2p+0, -0x1.f8d5dap-28, INEXACT)
T(RD,   0x1.1ae2fc7aa3558p+12,    0x1.92113a9113dc2p+0, -0x1.f8d5dap-28, INEXACT)
T(RU,   0x1.1ae2fc7aa3558p+12,    0x1.92113a9113dc3p+0,          0x1p+0, INEXACT)
T(RZ,   0x1.b86c5a03e05a7p+17,    0x1.921f6add907bbp+0, -0x1.425cf6p-26, INEXACT)
T(RD,   0x1.b86c5a03e05a7p+17,    0x1.921f6add907bbp+0, -0x1.425cf6p-26, INEXACT)
T(RU,   0x1.b86c5a03e05a7p+17,    0x1.921f6add907bcp+0,          0x1p+0, INEXACT)
T(RZ,   -0x1.532484e960676p-3,   -0x1.5017b7e2fe2cdp-3,          0x1p+0, INEXACT)
T(RU,   -0x1.532484e960676p-3,   -0x1.5017b7e2fe2cdp-3,          0x1p+0, INEXACT)
T(RD,   -0x1.532484e960676p-3,   -0x1.5017b7e2fe2cep-3, -0x1.cb3e98p-26, INEXACT)
T(RN,  -0x1.28da0838bcbdap+27,   -0x1.921fb528aa2c4p+0,         -0x1p-1, INEXACT)
T(RN,    0x1.ec9b9595ca106p+7,    0x1.9115a1b79ac54p+0,         -0x1p-1, INEXACT)
T(RZ,   0x1.3396c919b60b7p+20,    0x1.921fa7f33e977p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.3396c919b60b7p+20,    0x1.921fa7f33e977p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.3396c919b60b7p+20,    0x1.921fa7f33e978p+0,  0x1.b03d44p-27, INEXACT)
T(RZ,   0x1.82190c2bf5403p+36,    0x1.921fb5443835bp+0, -0x1.21ea24p-32, INEXACT)
T(RD,   0x1.82190c2bf5403p+36,    0x1.921fb5443835bp+0, -0x1.21ea24p-32, INEXACT)
T(RU,   0x1.82190c2bf5403p+36,    0x1.921fb5443835cp+0,          0x1p+0, INEXACT)
T(RZ,   0x1.6b277a9a3ddc5p+24,    0x1.921fb48fcc381p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.6b277a9a3ddc5p+24,    0x1.921fb48fcc381p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.6b277a9a3ddc5p+24,    0x1.921fb48fcc382p+0,  0x1.ed4ddap-27, INEXACT)
T(RZ,    0x1.9074cc9918c88p+1,    0x1.42ecb12819971p+0,         -0x1p+0, INEXACT)
T(RD,    0x1.9074cc9918c88p+1,    0x1.42ecb12819971p+0,         -0x1p+0, INEXACT)
T(RU,    0x1.9074cc9918c88p+1,    0x1.42ecb12819972p+0,  0x1.883e3cp-26, INEXACT)
T(RN,  -0x1.fb8bccafff1cap+37,   -0x1.921fb5443ec89p+0,         -0x1p-1, INEXACT)
T(RZ,  -0x1.1356ab60c4a97p+27,   -0x1.921fb52682301p+0,          0x1p+0, INEXACT)
T(RU,  -0x1.1356ab60c4a97p+27,   -0x1.921fb52682301p+0,          0x1p+0, INEXACT)
T(RD,  -0x1.1356ab60c4a97p+27,   -0x1.921fb52682302p+0, -0x1.0d9f0cp-26, INEXACT)
T(RZ,   0x1.0dd183f340d9dp+23,    0x1.921fb35e7b82ap+0, -0x1.d4bbb2p-28, INEXACT)
T(RD,   0x1.0dd183f340d9dp+23,    0x1.921fb35e7b82ap+0, -0x1.d4bbb2p-28, INEXACT)
T(RU,   0x1.0dd183f340d9dp+23,    0x1.921fb35e7b82bp+0,          0x1p+0, INEXACT)
T(RN,   -0x1.a081ee53b84dap+2,   -0x1.6b17af2265403p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,   -0x1.b239bfc1d2378p+6,   -0x1.8fc4053fd8437p+0,          0x1p+0, INEXACT)
T(RU,   -0x1.b239bfc1d2378p+6,   -0x1.8fc4053fd8437p+0,          0x1p+0, INEXACT)
T(RD,   -0x1.b239bfc1d2378p+6,   -0x1.8fc4053fd8438p+0, -0x1.3b75b8p-26, INEXACT)
T(RN,   -0x1.7e04f25507edp+45,   -0x1.921fb54442cc3p+0,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.4abc9e27293d1p+24,    -0x1.921fb47e1c07p+0,         -0x1p-1, INEXACT)
T(RZ,  -0x1.740eab34d6da1p+15,   -0x1.921e54fa110a1p+0,          0x1p+0, INEXACT)
T(RU,  -0x1.740eab34d6da1p+15,   -0x1.921e54fa110a1p+0,          0x1p+0, INEXACT)
T(RD,  -0x1.740eab34d6da1p+15,   -0x1.921e54fa110a2p+0,  -0x1.8f49ap-26, INEXACT)
T(RZ,    0x1.4e65b2a21ab4fp+2,    0x1.61b6b2918cf46p+0, -0x1.79f2f2p-32, INEXACT)
T(RD,    0x1.4e65b2a21ab4fp+2,    0x1.61b6b2918cf46p+0, -0x1.79f2f2p-32, INEXACT)
T(RU,    0x1.4e65b2a21ab4fp+2,    0x1.61b6b2918cf47p+0,          0x1p+0, INEXACT)
T(RN,  -0x1.7e04f255101a4p+45,   -0x1.921fb54442cc3p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,   -0x1.a6fb63bd99a1p+35,   -0x1.921fb5442f737p+0,          0x1p+0, INEXACT)
T(RU,   -0x1.a6fb63bd99a1p+35,   -0x1.921fb5442f737p+0,          0x1p+0, INEXACT)
T(RD,   -0x1.a6fb63bd99a1p+35,   -0x1.921fb5442f738p+0, -0x1.9c57dcp-26, INEXACT)
T(RN,  -0x1.1cba2f945fcc8p+28,   -0x1.921fb535e014ap+0,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.758ac437cb836p+32,    0x1.921fb543935fap+0,         -0x1p-1, INEXACT)
T(RN,  -0x1.8854f3ca462c5p+12,   -0x1.921544972643bp+0,  -0x1.fffffep-2, INEXACT)
T(RZ,  -0x1.b49ad2babd8b5p+37,   -0x1.921fb5443e20ap+0,          0x1p+0, INEXACT)
T(RU,  -0x1.b49ad2babd8b5p+37,   -0x1.921fb5443e20ap+0,          0x1p+0, INEXACT)
T(RD,  -0x1.b49ad2babd8b5p+37,   -0x1.921fb5443e20bp+0,  -0x1.fa938p-26, INEXACT)
T(RN,   0x1.ae4664cb57a1dp+33,    0x1.921fb543f6a99p+0,         -0x1p-1, INEXACT)
T(RN,   0x1.5a171dd1af5a3p+40,    0x1.921fb54442142p+0,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.50c5c27eb1d46p+29,    0x1.921fb53e2e044p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,   0x1.c8787bdfc50f9p+39,    0x1.921fb54441b25p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.c8787bdfc50f9p+39,    0x1.921fb54441b25p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.c8787bdfc50f9p+39,    0x1.921fb54441b26p+0,  0x1.2a8fe6p-26, INEXACT)
T(RN,  -0x1.192179733a0aep+16,   -0x1.921ecc26a2da8p+0,         -0x1p-1, INEXACT)
T(RZ,   -0x1.16d8982b058bcp+7,   -0x1.9049aa28c2f5ap+0,  0x1.aef722p-27, INEXACT)
T(RU,   -0x1.16d8982b058bcp+7,   -0x1.9049aa28c2f5ap+0,  0x1.aef722p-27, INEXACT)
T(RD,   -0x1.16d8982b058bcp+7,   -0x1.9049aa28c2f5bp+0,         -0x1p+0, INEXACT)
T(RZ,  -0x1.b9eafd6a4004cp+37,   -0x1.921fb5443e2f2p+0,   0x1.ff37dp-26, INEXACT)
T(RU,  -0x1.b9eafd6a4004cp+37,   -0x1.921fb5443e2f2p+0,   0x1.ff37dp-26, INEXACT)
T(RD,  -0x1.b9eafd6a4004cp+37,   -0x1.921fb5443e2f3p+0,         -0x1p+0, INEXACT)
T(RN,  -0x1.aa1851faa1a9cp+21,   -0x1.921fb075cff9bp+0,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.90f6b99b2bd49p+23,   -0x1.921fb3fd5e5ebp+0,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.4ae51b4550faep+29,   -0x1.921fb53e125d3p+0,  -0x1.fffffep-2, INEXACT)
T(RN,    -0x1.6dca45501f91p+0,    -0x1.eb9b1c04cbe5p-1,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.5a171dd1af9b8p+40,    0x1.921fb54442142p+0,  -0x1.fffffep-2, INEXACT)
T(RN,   -0x1.c66f6333ad342p-3,   -0x1.bf30946696bc3p-3,         -0x1p-1, INEXACT)
T(RN,  -0x1.67a80d444ca1bp+12,   -0x1.921451c5f7b5fp+0,         -0x1p-1, INEXACT)
T(RZ,   -0x1.d72c30e798a44p-4,   -0x1.d51c57946d43cp-4,          0x1p+0, INEXACT)
T(RU,   -0x1.d72c30e798a44p-4,   -0x1.d51c57946d43cp-4,          0x1p+0, INEXACT)
T(RD,   -0x1.d72c30e798a44p-4,   -0x1.d51c57946d43dp-4, -0x1.b101e8p-27, INEXACT)
T(RZ,  -0x1.b26ff6136b452p+12,   -0x1.921647a00ca03p+0,          0x1p+0, INEXACT)
T(RU,  -0x1.b26ff6136b452p+12,   -0x1.921647a00ca03p+0,          0x1p+0, INEXACT)
T(RD,  -0x1.b26ff6136b452p+12,   -0x1.921647a00ca04p+0, -0x1.2b32f8p-27, INEXACT)
T(RZ,   -0x1.84514a4d60872p+0,   -0x1.f9d3a86c8178dp-1,          0x1p+0, INEXACT)
T(RU,   -0x1.84514a4d60872p+0,   -0x1.f9d3a86c8178dp-1,          0x1p+0, INEXACT)
T(RD,   -0x1.84514a4d60872p+0,   -0x1.f9d3a86c8178ep-1, -0x1.c7c4ccp-29, INEXACT)
T(RZ,  -0x1.c338230ffebdfp+20,   -0x1.921fac3063822p+0,  0x1.99371cp-27, INEXACT)
T(RU,  -0x1.c338230ffebdfp+20,   -0x1.921fac3063822p+0,  0x1.99371cp-27, INEXACT)
T(RD,  -0x1.c338230ffebdfp+20,   -0x1.921fac3063823p+0,         -0x1p+0, INEXACT)
T(RZ,    0x1.6b93544a544bbp+1,    0x1.3b7741a2be418p+0,         -0x1p+0, INEXACT)
T(RD,    0x1.6b93544a544bbp+1,    0x1.3b7741a2be418p+0,         -0x1p+0, INEXACT)
T(RU,    0x1.6b93544a544bbp+1,    0x1.3b7741a2be419p+0,  0x1.ab6ba6p-28, INEXACT)
T(RZ,   0x1.267e3b445777cp+14,    0x1.921c3b1d03a79p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.267e3b445777cp+14,    0x1.921c3b1d03a79p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.267e3b445777cp+14,    0x1.921c3b1d03a7ap+0,   0x1.e0fa7p-28, INEXACT)
T(RZ,   0x1.b5b1079c8768dp+32,    0x1.921fb543ad166p+0, -0x1.b783a4p-29, INEXACT)
T(RD,   0x1.b5b1079c8768dp+32,    0x1.921fb543ad166p+0, -0x1.b783a4p-29, INEXACT)
T(RU,   0x1.b5b1079c8768dp+32,    0x1.921fb543ad167p+0,          0x1p+0, INEXACT)
T(RN,   -0x1.cda7dd366e381p-3,   -0x1.c610fefda5acbp-3,         -0x1p-1, INEXACT)
T(RZ,    0x1.18baca8a1f79p+32,    0x1.921fb543595e9p+0,         -0x1p+0, INEXACT)
T(RD,    0x1.18baca8a1f79p+32,    0x1.921fb543595e9p+0,         -0x1p+0, INEXACT)
T(RU,    0x1.18baca8a1f79p+32,    0x1.921fb543595eap+0,  0x1.1c6864p-27, INEXACT)
T(RZ,  -0x1.6eedb69e5bc0ep+21,    -0x1.921fafaf67bep+0,  0x1.546eb8p-27, INEXACT)
T(RU,  -0x1.6eedb69e5bc0ep+21,    -0x1.921fafaf67bep+0,  0x1.546eb8p-27, INEXACT)
T(RD,  -0x1.6eedb69e5bc0ep+21,   -0x1.921fafaf67be1p+0,         -0x1p+0, INEXACT)
T(RZ,   0x1.27025608cb4d7p+33,    0x1.921fb543d3be6p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.27025608cb4d7p+33,    0x1.921fb543d3be6p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.27025608cb4d7p+33,    0x1.921fb543d3be7p+0,  0x1.a3ca7ap-28, INEXACT)
T(RN,   0x1.83c747abfe443p+23,    0x1.921fb3f240e96p+0,         -0x1p-1, INEXACT)
T(RZ,   0x1.92691bb0c865ap+21,    0x1.921fb02d64866p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.92691bb0c865ap+21,    0x1.921fb02d64866p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.92691bb0c865ap+21,    0x1.921fb02d64867p+0,  0x1.21c41cp-28, INEXACT)
T(RZ,   0x1.f954de4734448p+31,    0x1.921fb5433f70ap+0,         -0x1p+0, INEXACT)
T(RD,   0x1.f954de4734448p+31,    0x1.921fb5433f70ap+0,         -0x1p+0, INEXACT)
T(RU,   0x1.f954de4734448p+31,    0x1.921fb5433f70bp+0,  0x1.2eec36p-27, INEXACT)
T(RN,   0x1.d767604f4c522p+24,    0x1.921fb4b93cea5p+0,         -0x1p-1, INEXACT)
T(RN,  -0x1.56c250bfb2999p+37,   -0x1.921fb5443cd7fp+0,         -0x1p-1, INEXACT)
T(RN,   0x1.4a6c4f03d4b0cp+18,    0x1.921f83ae85e6fp+0,         -0x1p-1, INEXACT)
T(RZ,  -0x1.2ee2e28c6a6d3p+19,   -0x1.921f9a385e4fep+0,  0x1.306dd4p-27, INEXACT)
T(RU,  -0x1.2ee2e28c6a6d3p+19,   -0x1.921f9a385e4fep+0,  0x1.306dd4p-27, INEXACT)
T(RD,  -0x1.2ee2e28c6a6d3p+19,   -0x1.921f9a385e4ffp+0,         -0x1p+0, INEXACT)
T(RZ,  -0x1.7cb5a8e1b3f3cp+36,   -0x1.921fb544380f3p+0,          0x1p+0, INEXACT)
T(RU,  -0x1.7cb5a8e1b3f3cp+36,   -0x1.921fb544380f3p+0,          0x1p+0, INEXACT)
T(RD,  -0x1.7cb5a8e1b3f3cp+36,   -0x1.921fb544380f4p+0, -0x1.c8b186p-29, INEXACT)
T(RN,  -0x1.5dc27dc0f1905p+12,   -0x1.9213ff46f56ecp+0,         -0x1p-1, INEXACT)
T(RN,   -0x1.fab72a2ad927p+32,   -0x1.921fb543c17bdp+0,         -0x1p-1, INEXACT)
T(RN,   0x1.fea0b8d4d724cp+31,    0x1.921fb54342216p+0,         -0x1p-1, INEXACT)
T(RZ,   0x1.c8787bdfc890dp+39,    0x1.921fb54441b25p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.c8787bdfc890dp+39,    0x1.921fb54441b25p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.c8787bdfc890dp+39,    0x1.921fb54441b26p+0,   0x1.3aeadp-27, INEXACT)
T(RN,  -0x1.a6647126e8a16p+17,   -0x1.921f67b081e97p+0,         -0x1p-1, INEXACT)
T(RZ,   -0x1.c4b4cd01383e5p+7,   -0x1.90fe2e17a10f9p+0,          0x1p+0, INEXACT)
T(RU,   -0x1.c4b4cd01383e5p+7,   -0x1.90fe2e17a10f9p+0,          0x1p+0, INEXACT)
T(RD,   -0x1.c4b4cd01383e5p+7,   -0x1.90fe2e17a10fap+0, -0x1.f6cc52p-27, INEXACT)
T(RZ,  -0x1.f5be47723b052p+18,    -0x1.921f949ccc7ap+0,          0x1p+0, INEXACT)
T(RU,  -0x1.f5be47723b052p+18,    -0x1.921f949ccc7ap+0,          0x1p+0, INEXACT)
T(RD,  -0x1.f5be47723b052p+18,   -0x1.921f949ccc7a1p+0, -0x1.fca678p-27, INEXACT)
T(RZ,   -0x1.0fc79c50f3a16p+3,    -0x1.741eb4b5b401p+0,          0x1p+0, INEXACT)
T(RU,   -0x1.0fc79c50f3a16p+3,    -0x1.741eb4b5b401p+0,          0x1p+0, INEXACT)
T(RD,   -0x1.0fc79c50f3a16p+3,   -0x1.741eb4b5b4011p+0, -0x1.6bbe0ep-30, INEXACT)
T(RZ,   0x1.a789be33bc389p+22,    0x1.921fb2d952919p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.a789be33bc389p+22,    0x1.921fb2d952919p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.a789be33bc389p+22,    0x1.921fb2d95291ap+0,  0x1.442138p-28, INEXACT)
T(RZ,   0x1.653673a37d39fp+25,     0x1.921fb4e8874fp+0, -0x1.6e39bcp-29, INEXACT)
T(RD,   0x1.653673a37d39fp+25,     0x1.921fb4e8874fp+0, -0x1.6e39bcp-29, INEXACT)
T(RU,   0x1.653673a37d39fp+25,    0x1.921fb4e8874f1p+0,          0x1p+0, INEXACT)
T(RN,  -0x1.7dda5e865ae95p+21,   -0x1.921fafe740413p+0,         -0x1p-1, INEXACT)
T(RN,     0x1.3a443696c8dfp-1,    0x1.19dbed2a0c0fcp-1,         -0x1p-1, INEXACT)
T(RN,    0x1.7a40b170c62c1p+0,    0x1.f39ddaae0d518p-1,         -0x1p-1, INEXACT)
T(RN,   -0x1.abf845cd249c2p-4,   -0x1.aa6c2bddaa7cep-4,         -0x1p-1, INEXACT)
T(RN,    0x1.c19fd1efe08edp+4,    0x1.89049364efe51p+0,         -0x1p-1, INEXACT)
T(RN,   0x1.212092a06e39fp+38,    0x1.921fb5443f46dp+0,         -0x1p-1, INEXACT)
T(RN,  -0x1.c6f1ff7534f89p+18,   -0x1.921f9140e6f66p+0,         -0x1p-1, INEXACT)
T(RN,    0x1.d4747939b0427p+4,    0x1.896234f8c84cap+0,         -0x1p-1, INEXACT)
T(RN,   0x1.0f5f673432b59p+11,     0x1.920185537a55p+0,         -0x1p-1, INEXACT)
T(RZ,  -0x1.46c9552ec0bd6p+12,   -0x1.92132c844d908p+0,  0x1.278c66p-28, INEXACT)
T(RU,  -0x1.46c9552ec0bd6p+12,   -0x1.92132c844d908p+0,  0x1.278c66p-28, INEXACT)
T(RD,  -0x1.46c9552ec0bd6p+12,   -0x1.92132c844d909p+0,         -0x1p+0, INEXACT)
T(RN,   -0x1.efb1866075201p+7,   -0x1.911749bbd7e66p+0,         -0x1p-1, INEXACT)
T(RZ,    0x1.130f8ead9d07bp+3,    0x1.74798194349ebp+0, -0x1.3be544p-29, INEXACT)
T(RD,    0x1.130f8ead9d07bp+3,    0x1.74798194349ebp+0, -0x1.3be544p-29, INEXACT)
T(RU,    0x1.130f8ead9d07bp+3,    0x1.74798194349ecp+0,          0x1p+0, INEXACT)
T(RN,   0x1.3c5a2f814855dp+20,    0x1.921fa851ad802p+0,         -0x1p-1, INEXACT)
T(RN,    0x1.89ccffe534b0ap+2,    0x1.68e1318b25f9bp+0,         -0x1p-1, INEXACT)
T(RZ,   -0x1.aee70c49d6ca3p+5,   -0x1.8d5f2090a79aep+0,  0x1.c1e8bap-29, INEXACT)
T(RU,   -0x1.aee70c49d6ca3p+5,   -0x1.8d5f2090a79aep+0,  0x1.c1e8bap-29, INEXACT)
T(RD,   -0x1.aee70c49d6ca3p+5,   -0x1.8d5f2090a79afp+0,         -0x1p+0, INEXACT)
T(RZ,   0x1.a048bf4e5ad75p+16,    0x1.921f17d5f2007p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.a048bf4e5ad75p+16,    0x1.921f17d5f2007p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.a048bf4e5ad75p+16,    0x1.921f17d5f2008p+0,  0x1.a4701cp-28, INEXACT)
T(RZ,   0x1.82f78cffd02cfp+28,    0x1.921fb539ad16bp+0, -0x1.f0d0c6p-30, INEXACT)
T(RD,   0x1.82f78cffd02cfp+28,    0x1.921fb539ad16bp+0, -0x1.f0d0c6p-30, INEXACT)
T(RU,   0x1.82f78cffd02cfp+28,    0x1.921fb539ad16cp+0,          0x1p+0, INEXACT)
T(RZ,  -0x1.e3f8bbbe03b38p+22,   -0x1.921fb3269c023p+0,  0x1.56f0c8p-28, INEXACT)
T(RU,  -0x1.e3f8bbbe03b38p+22,   -0x1.921fb3269c023p+0,  0x1.56f0c8p-28, INEXACT)
T(RD,  -0x1.e3f8bbbe03b38p+22,   -0x1.921fb3269c024p+0,         -0x1p+0, INEXACT)
T(RZ,   0x1.fff3cfedcacebp+16,    0x1.921f354136ba6p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.fff3cfedcacebp+16,    0x1.921f354136ba6p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.fff3cfedcacebp+16,    0x1.921f354136ba7p+0,  0x1.86cc0ap-28, INEXACT)
T(RN,  -0x1.c696097efb7b5p+14,   -0x1.921d7499f48e4p+0,         -0x1p-1, INEXACT)
T(RZ,    0x1.396efe5ba669fp-3,    0x1.370530a519eb9p-3,         -0x1p+0, INEXACT)
T(RD,    0x1.396efe5ba669fp-3,    0x1.370530a519eb9p-3,         -0x1p+0, INEXACT)
T(RU,    0x1.396efe5ba669fp-3,    0x1.370530a519ebap-3,  0x1.7de004p-28, INEXACT)
T(RN,    0x1.a11b9cb0d0dd8p+4,    0x1.884f04fecb39ap+0,         -0x1p-1, INEXACT)
T(RZ,   -0x1.70140200e6397p+3,   -0x1.7bec6cdeec8c3p+0,          0x1p+0, INEXACT)
T(RU,   -0x1.70140200e6397p+3,   -0x1.7bec6cdeec8c3p+0,          0x1p+0, INEXACT)
T(RD,   -0x1.70140200e6397p+3,   -0x1.7bec6cdeec8c4p+0, -0x1.bc2be4p-28, INEXACT)
T(RN,   0x1.786c4b5d28a29p+32,    0x1.921fb54394b76p+0,         -0x1p-1, INEXACT)
T(RN,   0x1.32ea56c46a1fbp+24,    0x1.921fb46ebad71p+0,         -0x1p-1, INEXACT)
T(RZ,   -0x1.51fb04cf582ecp+9,   -0x1.91bec17d33b94p+0,  0x1.812b24p-29, INEXACT)
T(RU,   -0x1.51fb04cf582ecp+9,   -0x1.91bec17d33b94p+0,  0x1.812b24p-29, INEXACT)
T(RD,   -0x1.51fb04cf582ecp+9,   -0x1.91bec17d33b95p+0,         -0x1p+0, INEXACT)
T(RZ,   0x1.d86bf3de72181p+18,    0x1.921f9295f4a86p+0,         -0x1p+0, INEXACT)
T(RD,   0x1.d86bf3de72181p+18,    0x1.921f9295f4a86p+0,         -0x1p+0, INEXACT)
T(RU,   0x1.d86bf3de72181p+18,    0x1.921f9295f4a87p+0,   0x1.e0b66p-28, INEXACT)
T(RN,   -0x1.5290a0bc2ae44p+8,   -0x1.915e2381178cfp+0,         -0x1p-1, INEXACT)
T(RZ,   0x1.b69e2fa9e6555p+12,    0x1.92165ea151b6ep+0, -0x1.76bda6p-28, INEXACT)
T(RD,   0x1.b69e2fa9e6555p+12,    0x1.92165ea151b6ep+0, -0x1.76bda6p-28, INEXACT)
T(RU,   0x1.b69e2fa9e6555p+12,    0x1.92165ea151b6fp+0,          0x1p+0, INEXACT)
T(RZ,  -0x1.1fa8c397af519p+13,   -0x1.921896aa6a14dp+0,          0x1p+0, INEXACT)
T(RU,  -0x1.1fa8c397af519p+13,   -0x1.921896aa6a14dp+0,          0x1p+0, INEXACT)
T(RD,  -0x1.1fa8c397af519p+13,   -0x1.921896aa6a14ep+0, -0x1.8f0ff4p-28, INEXACT)
T(RZ,   0x1.9f439ccd5b925p+13,    0x1.921ac6b9beb31p+0, -0x1.6f1ed2p-31, INEXACT)
T(RD,   0x1.9f439ccd5b925p+13,    0x1.921ac6b9beb31p+0, -0x1.6f1ed2p-31, INEXACT)
T(RU,   0x1.9f439ccd5b925p+13,    0x1.921ac6b9beb32p+0,          0x1p+0, INEXACT)
T(RN,   -0x1.dad226fc2fba5p-3,   -0x1.d293da8ea5895p-3,         -0x1p-1, INEXACT)
T(RZ,    0x1.a969493eaceb7p-4,    0x1.a7e43764146b7p-4,         -0x1p+0, INEXACT)
T(RD,    0x1.a969493eaceb7p-4,    0x1.a7e43764146b7p-4,         -0x1p+0, INEXACT)
T(RU,    0x1.a969493eaceb7p-4,    0x1.a7e43764146b8p-4,  0x1.c8b98ap-28, INEXACT)
T(RZ,   0x1.963f134730e97p+22,    0x1.921fb2befa4cbp+0,         -0x1p+0, INEXACT)
T(RD,   0x1.963f134730e97p+22,    0x1.921fb2befa4cbp+0,         -0x1p+0, INEXACT)
T(RU,   0x1.963f134730e97p+22,    0x1.921fb2befa4ccp+0,  0x1.b80832p-30, INEXACT)
T(RZ,  -0x1.ad84174e9a7b3p+13,   -0x1.921af09e44958p+0,  0x1.1905bcp-29, INEXACT)
T(RU,  -0x1.ad84174e9a7b3p+13,   -0x1.921af09e44958p+0,  0x1.1905bcp-29, INEXACT)
T(RD,  -0x1.ad84174e9a7b3p+13,   -0x1.921af09e44959p+0,         -0x1p+0, INEXACT)
T(RZ,  -0x1.4a4ea5030da33p+27,   -0x1.921fb52b75b91p+0,  0x1.cfca38p-28, INEXACT)
T(RU,  -0x1.4a4ea5030da33p+27,   -0x1.921fb52b75b91p+0,  0x1.cfca38p-28, INEXACT)
T(RD,  -0x1.4a4ea5030da33p+27,   -0x1.921fb52b75b92p+0,         -0x1p+0, INEXACT)
T(RZ,  -0x1.4a57f9eb9d4afp+33,   -0x1.921fb543df9fep+0,          0x1p+0, INEXACT)
T(RU,  -0x1.4a57f9eb9d4afp+33,   -0x1.921fb543df9fep+0,          0x1p+0, INEXACT)
T(RD,  -0x1.4a57f9eb9d4afp+33,   -0x1.921fb543df9ffp+0, -0x1.e8491cp-28, INEXACT)
T(RN,   0x1.7883feb8c47d6p+25,    0x1.921fb4ed3b3e1p+0,         -0x1p-1, INEXACT)
T(RZ,   -0x1.33d637da29563p-5,   -0x1.33b127e5b5cf4p-5,          0x1p+0, INEXACT)
T(RU,   -0x1.33d637da29563p-5,   -0x1.33b127e5b5cf4p-5,          0x1p+0, INEXACT)
T(RD,   -0x1.33d637da29563p-5,   -0x1.33b127e5b5cf5p-5, -0x1.4d3514p-29, INEXACT)
T(RN,   0x1.38b35d8cf2b41p+14,    0x1.921c6ef1b0e1dp+0,         -0x1p-1, INEXACT)
T(RN,   -0x1.5033dbc0335b7p-5,   -0x1.500395e3da4cfp-5,         -0x1p-1, INEXACT)
T(RN,    0x1.09d1d782b35dfp+7,    0x1.9032a19a832a5p+0,         -0x1p-1, INEXACT)
T(RN,   -0x1.d93ca307792a4p-2,   -0x1.bb4c3b96fd72ep-2,         -0x1p-1, INEXACT)
T(RN,   0x1.44efd8a13efa9p+15,    0x1.921e21e3ce31ep+0,         -0x1p-1, INEXACT)
T(RN,  -0x1.fe3425ba44f72p+21,   -0x1.921fb140a7e01p+0,         -0x1p-1, INEXACT)
T(RN,   0x1.c78965a5156e8p-28,   0x1.c78965a5156e8p-28,   0x1.e0ce12p-4, INEXACT)
T(RN,   0x1.378e0b41dd84fp-29,   0x1.378e0b41dd84fp-29,   0x1.33a1f4p-7, INEXACT)
T(RN,   0x1.119914f4d122fp-28,   0x1.119914f4d122fp-28,   0x1.a0acccp-6, INEXACT)
T(RN,   0x1.d9da31e371592p-28,   0x1.d9da31e371592p-28,   0x1.0e94d4p-3, INEXACT)
T(RN,   0x1.a4073958cf009p-27,   0x1.a4073958cf009p-27,   0x1.78e832p-2, INEXACT)
T(RN,   0x1.307778e7efa4ap-29,   0x1.307778e7efa4ap-29,   0x1.1f1c22p-7, INEXACT)
T(RN,    0x1.3741dc1318e8p-27,    0x1.3741dc1318e8p-27,   0x1.32c07ep-3, INEXACT)
T(RN,   0x1.916db46dceaeap-29,   0x1.916db46dceaeap-29,   0x1.49055cp-6, INEXACT)
T(RN,  -0x1.b699d13f8ee72p-28,  -0x1.b699d13f8ee72p-28,  -0x1.ad25ecp-4, INEXACT)
T(RN,  -0x1.ba2c0770c642bp-30,  -0x1.ba2c0770c642bp-30,  -0x1.b7b75ap-8, INEXACT)
T(RN,  -0x1.297c9a9f0371cp-30,  -0x1.297c9a9f0371cp-30,   -0x1.0bd02p-9, INEXACT)
T(RN,  -0x1.59664708aa283p-28,  -0x1.59664708aa283p-28,  -0x1.a32c76p-5, INEXACT)
T(RN,  -0x1.eb84c5bbc3333p-29,  -0x1.eb84c5bbc3333p-29,  -0x1.2dfcc6p-5, INEXACT)
T(RN,  -0x1.4645b44ac1a8cp-28,  -0x1.4645b44ac1a8cp-28,  -0x1.615228p-5, INEXACT)
T(RN,  -0x1.b3e8b218852cdp-27,  -0x1.b3e8b218852cdp-27,   -0x1.a54b8p-2, INEXACT)
T(RN,  -0x1.da9c1e5a7d174p-28,  -0x1.da9c1e5a7d174p-28,   -0x1.0fe19p-3, INEXACT)
T(RN,    0x1.8f869f0d3e1a8p-1,    0x1.5343ef4bbeb28p-1,  -0x1.2617b8p-2, INEXACT)
T(RN,    0x1.564eac9d593abp-1,    0x1.2dbb25790bef9p-1,    0x1.c014fp-4, INEXACT)
T(RN,    0x1.903aa07540ea8p-1,    0x1.53b3bdafedb7dp-1,    0x1.bed68p-4, INEXACT)
T(RN,    0x1.96836d06da0dbp-1,    0x1.57946993a7ac1p-1,   0x1.b80f74p-2, INEXACT)
T(RN,    0x1.ab05960b2c166p-1,    0x1.63ea5fd9695c4p-1,  -0x1.f284d2p-4, INEXACT)
T(RN,    0x1.a3b047608ec12p-3,    0x1.9df51977a7eebp-3,  -0x1.f7c048p-3, INEXACT)
T(RN,    0x1.4c3a987530ea6p-1,    0x1.26b3d211bc3fbp-1,   0x1.41c3f2p-2, INEXACT)
T(RN,    0x1.6e16dc2db85b7p-2,    0x1.5f96cd03253ddp-2,   0x1.f740cep-2, INEXACT)
T(RN,   -0x1.8d071a0e341c7p-2,   -0x1.7ac134683b0b9p-2,   0x1.4884bap-3, INEXACT)
T(RN,   -0x1.d841f083e107cp-1,   -0x1.7d762593ac827p-1,  -0x1.b1fdb2p-2, INEXACT)
T(RN,   -0x1.197c32f865f0dp-1,   -0x1.015e172d8e3dfp-1,   0x1.cc362cp-2, INEXACT)
T(RN,   -0x1.c11e823d047a1p-2,   -0x1.a73f4e443ab01p-2,  -0x1.2424a8p-6, INEXACT)
T(RN,   -0x1.433fc67f8cff2p-1,   -0x1.205527a5e681cp-1,   0x1.1097a4p-2, INEXACT)
T(RN,   -0x1.9900f201e403cp-1,   -0x1.591a82807fd13p-1,   0x1.1c00b8p-2, INEXACT)
T(RN,    -0x1.df247e48fc92p-1,   -0x1.81281ec3d7101p-1,   0x1.94c392p-5, INEXACT)
T(RN,   -0x1.c191032206441p-1,   -0x1.70ed437c7733ep-1,   -0x1.a028fp-2, INEXACT)
T(RN,    -0x1.bff0bfe17fc3p-1,   -0x1.7001d908266cep-1,   0x1.2e31e4p-3, INEXACT)
T(RN,    0x1.d91d7f07cadc7p-2,    0x1.bb32924a5ec19p-2,   0x1.98914ap-4, INEXACT)
T(RN,    0x1.6fa97e0b4e023p-2,    0x1.60fba131671eep-2,  -0x1.9c8edap-2, INEXACT)
T(RN,    0x1.26c50d8a1b144p-1,    0x1.0b74f984dac1fp-1,  -0x1.4000ccp-2, INEXACT)
T(RN,    0x1.9fdad43089a8cp-1,    0x1.5d4233c5626edp-1,  -0x1.128a82p-2, INEXACT)
T(RN,    0x1.b4f8e762729bfp-1,     0x1.69ba651ae867p-1,   0x1.2e3fc2p-2, INEXACT)
T(RN,    0x1.0b51b184aab77p+0,    0x1.9d3248b0e547ap-1,  -0x1.65d9fep-3, INEXACT)
T(RN,    0x1.198aeb67c254bp-2,    0x1.12c0f189426cep-2,   0x1.e2c73cp-3, INEXACT)
T(RN,    0x1.8f175b9f5b15cp-1,    0x1.52fec066419a2p-1,   0x1.126bacp-2, INEXACT)
T(RN,   -0x1.712b862e1699ap-1,    -0x1.3fd944042b7bp-1,   0x1.966f0ep-2, INEXACT)
T(RN,   -0x1.68a5c70e1d789p-4,   -0x1.67b84b2dc3279p-4,   0x1.1e48a8p-3, INEXACT)
T(RN,   -0x1.228210893fcadp+0,   -0x1.b268fdec8d34ep-1,  -0x1.2073c8p-3, INEXACT)
T(RN,   -0x1.076ceed9ddb3cp+0,   -0x1.997156a1b6c8cp-1,   0x1.043fb6p-6, INEXACT)
T(RN,   -0x1.d0d5b6264d947p-4,   -0x1.cedac58083f59p-4,   -0x1.39db9p-2, INEXACT)
T(RN,   -0x1.89fa37cb79d47p-2,   -0x1.7819b0463de1cp-2,  -0x1.6dcd16p-3, INEXACT)
T(RN,   -0x1.93682440ec58fp-1,   -0x1.55ab2e7a27c39p-1,  -0x1.3312aep-3, INEXACT)
T(RN,   -0x1.546342601e59ep-2,   -0x1.489f0ce46cbf4p-2,  -0x1.439fbep-2, INEXACT)
T(RN,   -0x1.70506ffd08efep-2,   -0x1.618f7b1e6a2c8p-2,   0x1.041452p-9, INEXACT)
T(RN,    0x1.eb495692ad256p+3,    0x1.817908e74187ep+0,   0x1.40e41ap-2, INEXACT)
T(RN,    0x1.6bd0d7a1af436p+0,    0x1.ea4d9098044c2p-1,  -0x1.2e8686p-2, INEXACT)
T(RN,    0x1.71fc63f8c7f19p+2,    0x1.6646669146b75p+0,   0x1.0ceb18p-4, INEXACT)
T(RN,    0x1.8b5616ac2d586p+3,    0x1.7d7284c8e843ap+0,   0x1.e64fb4p-2, INEXACT)
T(RN,    0x1.2944d289a5135p+2,    0x1.5bd65f3b88d24p+0,   0x1.1e497ap-3, INEXACT)
T(RN,    0x1.3afcb5f96bf2dp+3,    0x1.78349346d8b5ap+0,    0x1.4a0d2p-2, INEXACT)
T(RN,    0x1.a6a54d4a9a953p+0,    0x1.06b465a769246p+0,  -0x1.d3b7f8p-2, INEXACT)
T(RN,    0x1.eae7d5cfab9f5p+3,    0x1.8175bca556ff4p+0,   0x1.42db1ep-4, INEXACT)
T(RN,   -0x1.725de4bbc9779p+2,   -0x1.6651b85f83989p+0,   0x1.58bb42p-2, INEXACT)
T(RN,   -0x1.e3efc7df8fbf2p+0,   -0x1.158f9fd131d15p+0,  -0x1.fbd072p-4, INEXACT)
T(RN,   -0x1.e833d067a0cf4p+2,   -0x1.70c11994ae55dp+0,  -0x1.639138p-3, INEXACT)
T(RN,   -0x1.d737ae6f5cdecp+3,   -0x1.80c408a6ca73dp+0,  -0x1.1d9094p-2, INEXACT)
T(RN,   -0x1.32ae655ccab99p+3,   -0x1.778226580c7acp+0,   0x1.398c96p-2, INEXACT)
T(RN,   -0x1.642bc85790af2p+1,   -0x1.39cd79eecad02p+0,   0x1.8ed8b4p-3, INEXACT)
T(RN,   -0x1.317ea2fd45fa9p+3,   -0x1.7767e07cb7194p+0,  -0x1.21529ap-9, INEXACT)
T(RN,   -0x1.31f863f0c7e19p+2,   -0x1.5d565549e13d3p+0,   0x1.0a8576p-4, INEXACT)
T(RN,   -0x1.0e03dc07b80f7p+3,   -0x1.73ecf870fb94fp+0,  -0x1.3ee542p-4, INEXACT)
T(RN,    0x1.35072a0e541cbp+4,    0x1.84e197b7d956fp+0,   0x1.7a8cccp-3, INEXACT)
T(RN,    0x1.6ad795af2b5e5p+4,     0x1.86d7aedc35d4p+0,  -0x1.408bb4p-4, INEXACT)
T(RN,    0x1.5af635ec6bd8dp+4,    0x1.8653ae84c299fp+0,  -0x1.8bec0cp-2, INEXACT)
T(RN,    0x1.c38e071c0e382p+4,    0x1.890e88952b856p+0,   0x1.c54662p-5, INEXACT)
T(RN,    -0x1.5fa33f467e8dp+4,   -0x1.867bc8f5b4954p+0,  -0x1.ca0c72p-5, INEXACT)
T(RN,   -0x1.503e207c40f88p+4,   -0x1.85f38c9412145p+0,   -0x1.45de2p-2, INEXACT)
T(RN,   -0x1.558fab1f563ebp+4,   -0x1.86240006518b2p+0,   0x1.b10874p-9, INEXACT)
T(RN,   -0x1.09aa935526aa5p+4,   -0x1.82b980dfe2eb1p+0,  -0x1.8ce8acp-4, INEXACT)
T(RN,   0x1.07e322c8073a5p+50,    0x1.921fb54442d14p+0,  -0x1.94cef8p-2, INEXACT)
T(RN,     0x1.5a24b6641e3p+50,    0x1.921fb54442d15p+0,  -0x1.4512ccp-2, INEXACT)
T(RN,    0x1.81c23e3f7d41p+50,    0x1.921fb54442d16p+0,   0x1.83d526p-2, INEXACT)
T(RN,   0x1.f2e4d953c4659p+49,    0x1.921fb54442d14p+0,  -0x1.5d901cp-3, INEXACT)
T(RN,  -0x1.3e830b2d43f4cp+50,   -0x1.921fb54442d15p+0,   0x1.f232f4p-5, INEXACT)
T(RN,  -0x1.933b3f05db053p+50,   -0x1.921fb54442d16p+0,  -0x1.0e0c42p-2, INEXACT)
T(RN,  -0x1.1b0a07c60f406p+50,   -0x1.921fb54442d15p+0,  -0x1.5e517cp-2, INEXACT)
T(RN,  -0x1.315216148ec12p+50,   -0x1.921fb54442d15p+0,  -0x1.3fd63cp-4, INEXACT)
T(RN,  -0x1.17aab1d0faeabp+50,   -0x1.921fb54442d15p+0,  -0x1.8afdf6p-2, INEXACT)
T(RN,  0x1.c77250c52a4c4p+994,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT)
T(RN,  0x1.d1aa8519bf27bp+994,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT)
T(RN,  0x1.53258d061f91bp+996,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT)
T(RN,  0x1.c05a809d29d95p+991,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT)
T(RN,  0x1.f1d168dc8b4b9p+995,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT)
T(RN,  0x1.30be428e34f88p+995,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT)
T(RN,  0x1.02859c02ccfe3p+996,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT)
T(RN,  0x1.180bc4172290dp+996,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT)
T(RN, -0x1.667d39b69351dp+996,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT)
T(RN, -0x1.64b4491f0919fp+994,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT)
T(RN,  -0x1.40870a9d1e64p+996,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT)
T(RN, -0x1.71bc3eb2a1814p+996,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT)
T(RN, -0x1.29a6726634859p+996,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT)
T(RN, -0x1.49e53a9551829p+995,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT)
T(RN, -0x1.01ae9433f55c6p+996,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT)
T(RN,                  0x0p+0,                  0x0p+0,          0x0p+0, 0)
T(RN,    0x1.03d70a3d70a3cp+1,    0x1.1cf2a5ad5a7c4p+0,  -0x1.e09e0ap-2, INEXACT)
T(RN,    0x1.77e33174f034ap+0,     0x1.f21fc6be04bap-1,   -0x1.e02e8p-2, INEXACT)
T(RN,    0x1.0fe1abd7c0c31p+0,     0x1.a185df7479f8p-1,  -0x1.c4d78ap-2, INEXACT)
T(RN,    0x1.894e8ff49463fp-1,      0x1.4f608f8d0eep-1,  -0x1.e5224cp-2, INEXACT)
T(RN,    0x1.1c7b2878d0b55p-1,    0x1.03a9953ab4dc5p-1,   0x1.b09172p-2, INEXACT)
T(RN,    0x1.9b88968355891p-2,    0x1.874de6410afb2p-2,  -0x1.c5ba0cp-2, INEXACT)
T(RN,    0x1.29aa1ee7bb44bp-2,    0x1.21ae6d9650a87p-2,  -0x1.d856cep-2, INEXACT)
T(RN,    0x1.ae9ad8d075d09p-3,    0x1.a86c356162bb3p-3,   -0x1.9a40ap-2, INEXACT)
T(RN,    0x1.37757c75ba9bbp-3,    0x1.35172e4485d02p-3,  -0x1.ef9044p-2, INEXACT)
T(RN,   -0x1.0ccccccccccbep+1,   -0x1.205a403005894p+0,  -0x1.f5e8c2p-2, INEXACT)
T(RN,   -0x1.a176095a6ceffp+0,   -0x1.054cecf6d0cc3p+0,   0x1.f9554cp-2, INEXACT)
T(RN,   -0x1.442b806d262eap+0,   -0x1.ce025d4cc5fd7p-1,   0x1.fa7618p-2, INEXACT)
T(RN,   -0x1.f7741f52e167ep-1,   -0x1.8dd0969da6674p-1,  -0x1.f8ff22p-2, INEXACT)
T(RN,   -0x1.86f20a5a8d1cap-1,   -0x1.4de38894826b6p-1,  -0x1.f76728p-2, INEXACT)
T(RN,   -0x1.2f946ff58ef22p-1,   -0x1.12064ba34959dp-1,   0x1.fa224ep-2, INEXACT)
T(RN,   -0x1.d779df206d4b6p-2,   -0x1.b9d88e093b33bp-2,   0x1.fd5ed4p-2, INEXACT)
T(RN,   -0x1.6e1d31743baa4p-2,   -0x1.5f9c6a8a74d99p-2,   0x1.fee798p-2, INEXACT)
T(RN,   -0x1.1c4c2bfe9b699p-2,   -0x1.15502d8145d8fp-2,   0x1.f5de42p-2, INEXACT)
T(RN,   -0x1.b98794ea32e01p-3,   -0x1.b2dfa4b974fcap-3,   0x1.fa5c48p-2, INEXACT)
T(RN,   -0x1.56dc1c17bd6ccp-3,   -0x1.53b5a37e63e06p-3,   0x1.f9ea5ap-2, INEXACT)
T(RN,    0x1.0147ae147a988p+1,    0x1.1bf0a5e329627p+0,  -0x1.ff4e32p-2, INEXACT)
T(RN,    0x1.0147ae147a988p+1,    0x1.1bf0a5e329627p+0,  -0x1.ff4e32p-2, INEXACT)
T(RN,    0x1.749804a2107eap+0,    0x1.f006381c46c92p-1,  -0x1.ffa42ap-2, INEXACT)
T(RN,    0x1.0dcbbd29904cdp+0,    0x1.9f8dfe00af198p-1,  -0x1.ff6d0cp-2, INEXACT)
T(RN,    0x1.86b825d1f6c0ep-1,    0x1.4dbef4779463ap-1,  -0x1.ff086ap-2, INEXACT)
T(RN,    0x1.1aebaa4595706p-1,    0x1.0277eeffb5da1p-1,  -0x1.fefa56p-2, INEXACT)
T(RN,    0x1.99ba01442f607p-2,    0x1.85bf65d82c18bp-2,    0x1.ff36cp-2, INEXACT)
T(RN,     0x1.28af0a83ec23p-2,    0x1.20c6da21d88c4p-2,   -0x1.ff66dp-2, INEXACT)
T(RN,     0x1.ada89216f1a1p-3,    0x1.a7842aef1e0dbp-3,   0x1.fff5bep-2, INEXACT)
T(RN,    0x1.371dd16db0a85p-3,    0x1.34c17e06363bcp-3,   -0x1.ffba7p-2, INEXACT)
T(RN,   -0x1.0147ae147a988p+1,   -0x1.1bf0a5e329627p+0,   0x1.ff4e32p-2, INEXACT)
T(RN,   -0x1.8b1e29f16fcb1p+0,   -0x1.fde5b57c4c214p-1,  -0x1.ff6c82p-2, INEXACT)
T(RN,   -0x1.2f66b201035e4p+0,   -0x1.bd67b21497d2cp-1,  -0x1.ff2334p-2, INEXACT)
T(RN,   -0x1.d1f2ca6d258edp-1,   -0x1.7a08152543fbdp-1,   -0x1.ff58fp-2, INEXACT)
T(RN,   -0x1.65ca49e03f80cp-1,   -0x1.38483e00f7299p-1,  -0x1.ff8f0ap-2, INEXACT)
T(RN,    -0x1.12bcf9f28ea5p-1,    -0x1.f850c3e91c77p-2,  -0x1.ff9deep-2, INEXACT)
T(RN,   -0x1.a5ede30b77684p-2,   -0x1.90390dd74336fp-2,  -0x1.ffc9c8p-2, INEXACT)
T(RN,   -0x1.43fd2d7518e8dp-2,   -0x1.39c8bdecc0bcap-2,   0x1.ff6702p-2, INEXACT)
T(RN,   -0x1.f190ef69fb38fp-3,   -0x1.e81bf09cb915fp-3,   0x1.ff95cep-2, INEXACT)
T(RN,   -0x1.7e1194b194556p-3,   -0x1.79b9ff396601fp-3,   0x1.ff4668p-2, INEXACT)
T(RN,   -0x1.25618b72654d7p-3,   -0x1.236606895f067p-3,  -0x1.ffc67cp-2, INEXACT)
T(RN,    0x1.8cccccccccc9ep+1,    0x1.423db7312ceb3p+0,  -0x1.fd6a2ep-2, INEXACT)
T(RN,    0x1.8c191ab452b13p+1,    0x1.421bc9d1090c3p+0,   -0x1.fac2dp-2, INEXACT)
T(RN,    0x1.8b65b9fc73c45p+1,    0x1.41f9cff64fad8p+0,   0x1.fc164ep-2, INEXACT)
T(RN,     0x1.8ab2aa8055b1p+1,     0x1.41d7c99ecf81p+0,  -0x1.f7576cp-2, INEXACT)
T(RN,    0x1.89ffec1b2ef43p+1,    0x1.41b5b6c859f77p+0,   0x1.feae92p-2, INEXACT)
T(RN,    0x1.894d7ea846835p+1,    0x1.41939770c334dp+0,  -0x1.f83124p-2, INEXACT)
T(RN,    0x1.889b6202f4101p+1,     0x1.41716b95e224p+0,  -0x1.f98e94p-2, INEXACT)
T(RN,     0x1.87e996069fe8p+1,    0x1.414f33359075cp+0,  -0x1.feaf98p-2, INEXACT)
T(RN,    0x1.87381a8ec2e86p+1,    0x1.412cee4daaa49p+0,    0x1.fec4cp-2, INEXACT)
T(RN,    0x1.8686ef76e66a9p+1,    0x1.410a9cdc0ff66p+0,  -0x1.fc7d22p-2, INEXACT)
T(RN,    0x1.85d6149aa463cp+1,    0x1.40e83edea2893p+0,  -0x1.fe719ap-2, INEXACT)
T(RN,    0x1.852589d5a72f5p+1,    0x1.40c5d453474dfp+0,  -0x1.ffff86p-2, INEXACT)
T(RN,    0x1.84754f03a9a9dp+1,    0x1.40a35d37e613fp+0,  -0x1.ff8038p-2, INEXACT)
T(RN,    0x1.83c56400771a5p+1,    0x1.4080d98a698a5p+0,   -0x1.fe92bp-2, INEXACT)
T(RN,    0x1.8315c8a7eb294p+1,    0x1.405e4948bf442p+0,  -0x1.fd4606p-2, INEXACT)
T(RN,    0x1.82667cd5f1ddap+1,    0x1.403bac70d7bdcp+0,  -0x1.f83378p-2, INEXACT)
T(RN,    0x1.81b780668799cp+1,    0x1.40190300a6623p+0,  -0x1.faf5e8p-2, INEXACT)
T(RN,    0x1.8108d335b90ddp+1,    0x1.3ff64cf6218e6p+0,  -0x1.f5fd4ap-2, INEXACT)
T(RN,    0x1.805a751fa333ap+1,    0x1.3fd38a4f42966p+0,   0x1.f6ef1ap-2, INEXACT)
T(RN,    0x1.7fac66007333cp+1,    0x1.3fb0bb0a05c5cp+0,   0x1.f64092p-2, INEXACT)
T(RN,    0x1.7efea5b466947p+1,    0x1.3f8ddf246a6f5p+0,   0x1.f7eec2p-2, INEXACT)
T(RN,    0x1.7e513417cae04p+1,     0x1.3f6af69c72e1p+0,   0x1.fa1a8ap-2, INEXACT)
T(RN,    0x1.7da41106fdfabp+1,    0x1.3f480170247afp+0,   0x1.f9186ap-2, INEXACT)
T(RN,    0x1.7cf73c5e6dc1ep+1,    0x1.3f24ff9d87a27p+0,  -0x1.fef7a6p-2, INEXACT)
T(RN,    0x1.7c4ab5fa984b2p+1,    0x1.3f01f122a7d49p+0,   0x1.f83f1ap-2, INEXACT)
T(RN,    0x1.7b9e7db80baf5p+1,    0x1.3eded5fd93a11p+0,   -0x1.f8ccep-2, INEXACT)
T(RN,    0x1.7af29373661e5p+1,    0x1.3ebbae2c5cb54p+0,  -0x1.fc1acap-2, INEXACT)
T(RN,     0x1.7a46f70955cdp+1,    0x1.3e9879ad17ddcp+0,   -0x1.f8bf7p-2, INEXACT)
T(RN,    0x1.799ba85698e77p+1,    0x1.3e75387ddd0a2p+0,   0x1.f6bdb8p-2, INEXACT)
T(RN,     0x1.78f0a737fda1p+1,    0x1.3e51ea9cc755fp+0,  -0x1.f616c2p-2, INEXACT)
T(RN,    0x1.7845f38a6205cp+1,    0x1.3e2e9007f505ep+0,  -0x1.fa7322p-2, INEXACT)
T(RN,    0x1.779b8d2ab426dp+1,    0x1.3e0b28bd87968p+0,   0x1.fbbb3cp-2, INEXACT)
T(RN,    0x1.76f173f5f1d97p+1,     0x1.3de7b4bba3b5p+0,   0x1.fec544p-2, INEXACT)
T(RN,    0x1.7647a7c928e8dp+1,    0x1.3dc43400714ffp+0,  -0x1.f91ddep-2, INEXACT)
T(RN,    0x1.759e288176deap+1,    0x1.3da0a68a1b91ep+0,  -0x1.fa1202p-2, INEXACT)
T(RN,    0x1.74f4f5fc09195p+1,    0x1.3d7d0c56d0ebfp+0,   0x1.f8a1a8p-2, INEXACT)
T(RN,    0x1.744c10161cc93p+1,    0x1.3d596564c31b7p+0,   0x1.f7eb12p-2, INEXACT)
T(RN,    0x1.73a376acfec3ap+1,    0x1.3d35b1b22726fp+0,   0x1.fb5014p-2, INEXACT)
T(RN,    0x1.72fb299e0b9fcp+1,    0x1.3d11f13d356a3p+0,  -0x1.f95f24p-2, INEXACT)
T(RN,    0x1.725328c6afa7bp+1,    0x1.3cee240429999p+0,  -0x1.f6e234p-2, INEXACT)
T(RN,    0x1.71ab740466c17p+1,     0x1.3cca4a0542c3p+0,  -0x1.f7fae8p-2, INEXACT)
T(RN,    0x1.71040b34bca8fp+1,     0x1.3ca6633ec361p+0,   0x1.f6119ap-2, INEXACT)
T(RN,    0x1.705cee354c60bp+1,    0x1.3c826faef141ep+0,    0x1.fff1ap-2, INEXACT)
T(RN,    0x1.6fb61ce3c0b2cp+1,    0x1.3c5e6f5415a9fp+0,  -0x1.fb762ap-2, INEXACT)
T(RN,    0x1.6f0f971dd3ef2p+1,    0x1.3c3a622c7d4bdp+0,   0x1.ff67c6p-2, INEXACT)
T(RN,    0x1.6e695cc14fde6p+1,    0x1.3c164836784b4p+0,   0x1.f74c5ep-2, INEXACT)
T(RN,    0x1.6dc36dac0de1ep+1,     0x1.3bf221705a4bp+0,  -0x1.f900e2p-2, INEXACT)
T(RN,    0x1.6d1dc9bbf6b4dp+1,    0x1.3bcdedd87a656p+0,  -0x1.f66d1cp-2, INEXACT)
T(RN,    0x1.6c7870cf028cfp+1,    0x1.3ba9ad6d33396p+0,  -0x1.f6aaf4p-2, INEXACT)
T(RN,    0x1.6bd362c339105p+1,    0x1.3b85602ce2ef2p+0,   0x1.fc52f8p-2, INEXACT)
T(RN,    0x1.6b2e9f76b13afp+1,    0x1.3b610615eb381p+0,  -0x1.fb60f8p-2, INEXACT)
T(RN,    0x1.6a8a26c791739p+1,    0x1.3b3c9f26b15a8p+0,  -0x1.fa1e62p-2, INEXACT)
T(RN,    0x1.69e5f8940f696p+1,    0x1.3b182b5d9e2fep+0,   0x1.f5e558p-2, INEXACT)
T(RN,    0x1.694214ba70134p+1,     0x1.3af3aab91e2bp+0,   0x1.f87a06p-2, INEXACT)
T(RN,    0x1.689e7b1907c7cp+1,    0x1.3acf1d37a1642p+0,    0x1.ffdf4p-2, INEXACT)
T(RN,    0x1.67fb2b8e3a02ap+1,    0x1.3aaa82d79b921p+0,   0x1.facaacp-2, INEXACT)
T(RN,    0x1.675825f879822p+1,    0x1.3a85db9784172p+0,  -0x1.f7ab02p-2, INEXACT)
T(RN,    0x1.66b56a364832bp+1,    0x1.3a612775d6035p+0,   0x1.f82c22p-2, INEXACT)
T(RN,      0x1.6612f826374p+1,    0x1.3a3c6671101dfp+0,  -0x1.f622fep-2, INEXACT)
T(RN,    0x1.6570cfa6e6d22p+1,    0x1.3a179887b4ddep+0,   0x1.f636b4p-2, INEXACT)
T(RN,    0x1.64cef097065d2p+1,    0x1.39f2bdb84a812p+0,   0x1.fd2408p-2, INEXACT)
T(RN,    0x1.642d5ad5543f8p+1,    0x1.39cdd6015afddp+0,   0x1.f6b5aap-2, INEXACT)
T(RN,    0x1.638c0e409e081p+1,    0x1.39a8e16174184p+0,   0x1.fcdeecp-2, INEXACT)
T(RN,    0x1.62eb0ab7c0386p+1,    0x1.3983dfd7275b6p+0,  -0x1.ffa50cp-2, INEXACT)
T(RN,    0x1.624a5019a64fep+1,    0x1.395ed1610a221p+0,    0x1.f61b5p-2, INEXACT)
T(RN,    0x1.61a9de454b096p+1,    0x1.3939b5fdb5ab4p+0,   0x1.f65b56p-2, INEXACT)
T(RN,    0x1.6109b519b7ab2p+1,    0x1.39148dabc6f86p+0,  -0x1.f8742ep-2, INEXACT)
T(RN,    0x1.6069d47604b29p+1,    0x1.38ef5869defb8p+0,  -0x1.fc9886p-2, INEXACT)
T(RN,    0x1.5fca3c3959734p+1,    0x1.38ca1636a2872p+0,   -0x1.f9231p-2, INEXACT)
T(RN,      0x1.5f2aec42ec1p+1,    0x1.38a4c710ba536p+0,   0x1.feaa14p-2, INEXACT)
T(RN,    0x1.5e8be471ffce6p+1,    0x1.387f6af6d29f5p+0,   -0x1.f5d34p-2, INEXACT)
T(RN,    0x1.5ded24a5edf7bp+1,    0x1.385a01e79d4f1p+0,    0x1.fc559p-2, INEXACT)
T(RN,    0x1.5d4eacbe13bc8p+1,    0x1.38348be1cdae8p+0,  -0x1.f734dep-2, INEXACT)
T(RN,    0x1.5cb07c99e466dp+1,    0x1.380f08e41cc0ep+0,   0x1.ff5798p-2, INEXACT)
T(RN,    0x1.5c129418e0112p+1,    0x1.37e978ed47172p+0,   0x1.f81306p-2, INEXACT)
T(RN,    0x1.5b74f31a95ad7p+1,    0x1.37c3dbfc0d515p+0,  -0x1.f8d5b4p-2, INEXACT)
T(RN,    0x1.5ad7997ea2c53p+1,    0x1.379e320f3415fp+0,  -0x1.f8feccp-2, INEXACT)
T(RN,    0x1.5a3a8724b3991p+1,    0x1.37787b25841fep+0,   0x1.f70d0ep-2, INEXACT)
T(RN,    0x1.599dbbec83097p+1,    0x1.3752b73dca3f5p+0,   -0x1.f8675p-2, INEXACT)
T(RN,    0x1.590137b5da9d6p+1,    0x1.372ce656d762bp+0,   0x1.f5f0c2p-2, INEXACT)
T(RN,    0x1.5864fa6092626p+1,    0x1.3707086f8094ap+0,  -0x1.fb2e04p-2, INEXACT)
T(RN,    0x1.57c903cc91009p+1,    0x1.36e11d869f087p+0,    0x1.febb3p-2, INEXACT)
T(RN,    0x1.572d53d9cba55p+1,    0x1.36bb259b101abp+0,   0x1.f77f84p-2, INEXACT)
T(RN,    0x1.5691ea6846067p+1,    0x1.369520abb5595p+0,   0x1.fcd64ap-2, INEXACT)
T(RN,    0x1.55f6c758124c8p+1,    0x1.366f0eb77484ap+0,  -0x1.fc2beep-2, INEXACT)
T(RN,    0x1.555bea89511c9p+1,    0x1.3648efbd3798bp+0,  -0x1.f67a5ep-2, INEXACT)
T(RN,    0x1.54c153dc318f3p+1,    0x1.3622c3bbecd17p+0,   -0x1.fc05ap-2, INEXACT)
T(RN,    0x1.54270330f1145p+1,    0x1.35fc8ab286aabp+0,  -0x1.fc516ep-2, INEXACT)
T(RN,    0x1.538cf867db93dp+1,    0x1.35d6449ffbeedp+0,  -0x1.fa1116p-2, INEXACT)
T(RN,    0x1.52f333614b3abp+1,    0x1.35aff18347b0ep+0,  -0x1.f62674p-2, INEXACT)
T(RN,    0x1.5259b3fda89dfp+1,    0x1.3589915b695c1p+0,   0x1.f6e8d8p-2, INEXACT)
T(RN,    0x1.51c07a1d6aa9ap+1,     0x1.3563242764b6p+0,   0x1.f6d954p-2, INEXACT)
T(RN,    0x1.512785a1165e5p+1,    0x1.353ca9e641d52p+0,   0x1.f60aacp-2, INEXACT)
T(RN,    0x1.508ed6693f3fep+1,    0x1.351622970d42fp+0,  -0x1.ff4fa6p-2, INEXACT)
T(RN,    0x1.4ff66c5686deep+1,    0x1.34ef8e38d7e55p+0,   0x1.f5e696p-2, INEXACT)
T(RN,    0x1.4f5e47499d133p+1,    0x1.34c8eccab7135p+0,  -0x1.f99f12p-2, INEXACT)
T(RN,    0x1.4ec667233fe56p+1,    0x1.34a23e4bc4973p+0,   0x1.f96bc8p-2, INEXACT)
T(RN,    0x1.4e2ecbc43b7dep+1,    0x1.347b82bb1eafep+0,  -0x1.f766aap-2, INEXACT)
T(RN,    0x1.4d97750d6a268p+1,    0x1.3454ba17e8192p+0,   0x1.fbad98p-2, INEXACT)
T(RN,    0x1.4d0062dfb44b7p+1,    0x1.342de46148119p+0,  -0x1.f78d2cp-2, INEXACT)
T(RN,    0x1.4c69951c10682p+1,    0x1.340701966a5d9p+0,   0x1.ffc628p-2, INEXACT)
T(RN,    0x1.4bd30ba38305ep+1,    0x1.33e011b67f4cbp+0,  -0x1.fbca36p-2, INEXACT)
T(RN,    0x1.4b3cc6571eb53p+1,    0x1.33b914c0bbbfbp+0,   -0x1.fa839p-2, INEXACT)
T(RN,    0x1.4aa6c518040a6p+1,    0x1.33920ab4592dcp+0,  -0x1.f8f80cp-2, INEXACT)
T(RN,    0x1.4a1107c761a19p+1,    0x1.336af39095acbp+0,  -0x1.f747a6p-2, INEXACT)
T(RN,    0x1.497b8e4673ea4p+1,    0x1.3343cf54b3ea1p+0,   0x1.ff1396p-2, INEXACT)
T(RN,    0x1.48e6587685502p+1,    0x1.331c9dfffb3c5p+0,  -0x1.f68766p-2, INEXACT)
T(RN,    0x1.48516638ee62dp+1,    0x1.32f55f91b7b4dp+0,   0x1.fdee6cp-2, INEXACT)
T(RN,    0x1.47bcb76f151ffp+1,    0x1.32ce140939f5ep+0,  -0x1.f60626p-2, INEXACT)
T(RN,    0x1.47284bfa6dca5p+1,    0x1.32a6bb65d7734p+0,   0x1.f63f74p-2, INEXACT)
T(RN,    0x1.469423bc7a351p+1,    0x1.327f55a6ea484p+0,  -0x1.f7ee2cp-2, INEXACT)
T(RN,    0x1.46003e96ca1fdp+1,    0x1.3257e2cbd157fp+0,   0x1.f853c8p-2, INEXACT)
T(RN,    0x1.456c9c6afb239p+1,     0x1.323062d3f04ep+0,  -0x1.f763e4p-2, INEXACT)
T(RN,    0x1.44d93d1ab8747p+1,    0x1.3208d5beaf95fp+0,   0x1.fd5abcp-2, INEXACT)
T(RN,    0x1.44462087bb1c7p+1,    0x1.31e13b8b7c70bp+0,   0x1.f8597ap-2, INEXACT)
T(RN,    0x1.43b34693c9d99p+1,    0x1.31b99439c8f32p+0,   0x1.fbd2fcp-2, INEXACT)
T(RN,    0x1.4320af20b910bp+1,    0x1.3191dfc90c091p+0,   0x1.ff9ec4p-2, INEXACT)
T(RN,    0x1.428e5a106ad96p+1,    0x1.316a1e38c17f5p+0,  -0x1.f6bfd4p-2, INEXACT)
T(RN,    0x1.41fc4744ced91p+1,    0x1.31424f886a00ep+0,   0x1.f78deep-2, INEXACT)
T(RN,     0x1.416a769fe298p+1,    0x1.311a73b78b346p+0,   0x1.fedf22p-2, INEXACT)
T(RN,    0x1.40d8e803b0d1dp+1,    0x1.30f28ac5af93ap+0,  -0x1.fa7e1ep-2, INEXACT)
T(RN,    0x1.40479b525210cp+1,    0x1.30ca94b2669cdp+0,  -0x1.fe2c16p-2, INEXACT)
T(RN,    0x1.3fb6906dec5f1p+1,    0x1.30a2917d44c3bp+0,   0x1.f6f71cp-2, INEXACT)
T(RN,    0x1.3f25c738b3478p+1,    0x1.307a8125e3788p+0,  -0x1.f66a1ap-2, INEXACT)
T(RN,    0x1.3e953f94e7d1bp+1,    0x1.305263abe12e8p+0,   0x1.f7ddacp-2, INEXACT)
T(RN,    0x1.3e04f964d8917p+1,    0x1.302a390ee1664p+0,   0x1.f79a58p-2, INEXACT)
T(RN,    0x1.3d74f48ae16ddp+1,    0x1.3002014e8ca56p+0,   0x1.f91816p-2, INEXACT)
T(RN,    0x1.3ce530e96bcb5p+1,    0x1.2fd9bc6a9088ep+0,   0x1.fdde56p-2, INEXACT)
T(RN,    0x1.3c55ae62ee794p+1,    0x1.2fb16a629fc6fp+0,   0x1.fa7d74p-2, INEXACT)
T(RN,    0x1.3bc66cd9ed9cbp+1,    0x1.2f890b36722fep+0,  -0x1.f91fe2p-2, INEXACT)
T(RN,    0x1.3b376c30fab71p+1,    0x1.2f609ee5c4b72p+0,  -0x1.f8e68ep-2, INEXACT)
T(RN,    0x1.3aa8ac4ab4a35p+1,     0x1.2f3825705979p+0,   -0x1.fe3c8p-2, INEXACT)
T(RN,    0x1.3a1a2d09c7864p+1,    0x1.2f0f9ed5f7bd7p+0,  -0x1.f6558cp-2, INEXACT)
T(RN,    0x1.398bee50ec77dp+1,    0x1.2ee70b166be61p+0,   -0x1.f5d76p-2, INEXACT)
T(RN,    0x1.38fdf002eb22cp+1,    0x1.2ebe6a3187ebfp+0,   0x1.fb24d4p-2, INEXACT)
T(RN,    0x1.38703202967d7p+1,    0x1.2e95bc2722768p+0,   0x1.fa05fap-2, INEXACT)
T(RN,    0x1.37e2b432cff92p+1,    0x1.2e6d00f717cbbp+0,  -0x1.fa2878p-2, INEXACT)
T(RN,    0x1.3755767685dfdp+1,    0x1.2e4438a1495f6p+0,  -0x1.fd109ep-2, INEXACT)
T(RN,    0x1.36c878b0b3b76p+1,    0x1.2e1b63259df66p+0,   -0x1.f9ea5p-2, INEXACT)
T(RN,    0x1.363bbac4621d7p+1,    0x1.2df2808401a34p+0,   0x1.f7800ep-2, INEXACT)
T(RN,    0x1.35af3c94a6c94p+1,    0x1.2dc990bc65cd7p+0,   0x1.f81a6ap-2, INEXACT)
T(RN,    0x1.3522fe04a4997p+1,    0x1.2da093cec13c9p+0,   0x1.fecc9ap-2, INEXACT)
T(RN,    0x1.3496fef78b733p+1,    0x1.2d7789bb10159p+0,   0x1.fb071ep-2, INEXACT)
T(RN,    0x1.340b3f5098419p+1,    0x1.2d4e728153e17p+0,   0x1.fae1eap-2, INEXACT)
T(RN,    0x1.337fbef315137p+1,     0x1.2d254e21939dp+0,   0x1.f78ca8p-2, INEXACT)
T(RN,    0x1.32f47dc258c93p+1,    0x1.2cfc1c9bdba78p+0,  -0x1.f5f9bap-2, INEXACT)
T(RN,    0x1.32697ba1c77fap+1,    0x1.2cd2ddf03de96p+0,  -0x1.f85d24p-2, INEXACT)
T(RN,    0x1.31deb874d2017p+1,    0x1.2ca9921ed1b0ap+0,  -0x1.faa62cp-2, INEXACT)
T(RN,    0x1.3154341ef6349p+1,    0x1.2c803927b3d87p+0,    0x1.ff872p-2, INEXACT)
T(RN,    0x1.30c9ee83bed13p+1,    0x1.2c56d30b06ba1p+0,  -0x1.f678f6p-2, INEXACT)
T(RN,     0x1.303fe786c38fp+1,    0x1.2c2d5fc8f241fp+0,   0x1.f7c9fep-2, INEXACT)
T(RN,    0x1.2fb61f0ba8ea5p+1,    0x1.2c03df61a3e41p+0,  -0x1.ff5ecep-2, INEXACT)
T(RN,    0x1.2f2c94f620385p+1,    0x1.2bda51d54ea9ep+0,  -0x1.ff4ef6p-2, INEXACT)
T(RN,    0x1.2ea34929e7ab9p+1,    0x1.2bb0b7242b39ep+0,  -0x1.f938b4p-2, INEXACT)
T(RN,    0x1.2e1a3b8aca1d4p+1,    0x1.2b870f4e77ce5p+0,   0x1.f65ab6p-2, INEXACT)
T(RN,    0x1.2d916bfc9fa92p+1,    0x1.2b5d5a54786b3p+0,  -0x1.ff2f46p-2, INEXACT)
T(RN,    0x1.2d08da634c706p+1,    0x1.2b33983676854p+0,  -0x1.fcf2bep-2, INEXACT)
T(RN,    0x1.2c8086a2c1cadp+1,    0x1.2b09c8f4c1653p+0,  -0x1.fad22ep-2, INEXACT)
T(RN,    0x1.2bf8709efda67p+1,    0x1.2adfec8fadfe1p+0,   0x1.f8ac5ap-2, INEXACT)
T(RN,    0x1.2b70983c0aaccp+1,    0x1.2ab6030796ff5p+0,   0x1.fa92a6p-2, INEXACT)
T(RN,    0x1.2ae8fd5e0015ep+1,    0x1.2a8c0c5cdcce2p+0,  -0x1.fc7768p-2, INEXACT)
T(RN,    0x1.2a619fe901d07p+1,    0x1.2a62088fe598ap+0,  -0x1.fcb4b8p-2, INEXACT)
T(RN,    0x1.29da7fc140688p+1,    0x1.2a37f7a11d54cp+0,   -0x1.f9f48p-2, INEXACT)
T(RN,    0x1.29539ccaf8f3bp+1,    0x1.2a0dd990f5c14p+0,    0x1.f79f2p-2, INEXACT)
T(RN,    0x1.28ccf6ea75425p+1,    0x1.29e3ae5fe67bap+0,   0x1.fd7232p-2, INEXACT)
T(RN,    0x1.28468e040b727p+1,    0x1.29b9760e6ce54p+0,  -0x1.ffbc16p-2, INEXACT)
T(RN,    0x1.27c061fc1e5bbp+1,     0x1.298f309d0c4cp+0,  -0x1.f75ba8p-2, INEXACT)
T(RN,    0x1.273a72b71d3f1p+1,    0x1.2964de0c4dd7cp+0,    0x1.fd262p-2, INEXACT)
T(RN,    0x1.26b4c01983e5cp+1,    0x1.293a7e5cc09aep+0,  -0x1.faa696p-2, INEXACT)
T(RN,    0x1.262f4a07da896p+1,    0x1.2910118ef9923p+0,  -0x1.f63812p-2, INEXACT)
T(RN,    0x1.25aa1066b5d15p+1,    0x1.28e597a393aa6p+0,   0x1.facf3cp-2, INEXACT)
T(RN,    0x1.2525131ab6d06p+1,    0x1.28bb109b2fc63p+0,   0x1.fbc54cp-2, INEXACT)
T(RN,    0x1.24a052088b0cdp+1,    0x1.28907c7674c82p+0,  -0x1.ff0686p-2, INEXACT)
T(RN,    0x1.241bcd14ec538p+1,    0x1.2865db360f8afp+0,  -0x1.fb3076p-2, INEXACT)
T(RN,    0x1.23978424a0dfdp+1,     0x1.283b2cdab2f5p+0,   0x1.fa2e04p-2, INEXACT)
T(RN,    0x1.2313771c7b375p+1,    0x1.2810716517f38p+0,   0x1.f5ef5ap-2, INEXACT)
T(RN,    0x1.228fa5e15a2f9p+1,    0x1.27e5a8d5fd836p+0,  -0x1.f6d42ep-2, INEXACT)
T(RN,    0x1.220c105828ecep+1,    0x1.27bad32e28b7dp+0,   0x1.fc20e8p-2, INEXACT)
T(RN,    0x1.2188b665deceap+1,    0x1.278ff06e64ba2p+0,   0x1.ff2954p-2, INEXACT)
T(RN,    0x1.210597ef7f788p+1,    0x1.2765009782d43p+0,   0x1.fcd584p-2, INEXACT)
T(RN,     0x1.2082b4da1ac6p+1,    0x1.273a03aa5a72dp+0,  -0x1.f75edep-2, INEXACT)
T(RN,    0x1.20000d0accc34p+1,    0x1.270ef9a7c92a9p+0,   0x1.ffc1b4p-2, INEXACT)
T(RN,    0x1.1f7da066bdaacp+1,    0x1.26e3e290b2bd2p+0,  -0x1.fc53c4p-2, INEXACT)
T(RN,    0x1.1efb6ed321ddep+1,    0x1.26b8be66011e8p+0,  -0x1.f8584ap-2, INEXACT)
T(RN,    0x1.1e79783539eb5p+1,    0x1.268d8d28a47d4p+0,   -0x1.f63bcp-2, INEXACT)
T(RN,    0x1.1df7bc7252546p+1,    0x1.26624ed993362p+0,     0x1.f625p-2, INEXACT)
T(RN,    0x1.1d763b6fc41e6p+1,     0x1.26370379ca0bp+0,   0x1.f6d12ep-2, INEXACT)
T(RN,    0x1.1cf4f512f3c7cp+1,    0x1.260bab0a4bd0fp+0,   0x1.f9da14p-2, INEXACT)
T(RN,    0x1.1c73e94152479p+1,     0x1.25e0458c21ccp+0,   0x1.fa8726p-2, INEXACT)
T(RN,    0x1.1bf317e05c775p+1,    0x1.25b4d3005b83ep+0,    0x1.fe686p-2, INEXACT)
T(RN,    0x1.1b7280d59b405p+1,    0x1.258953680ed9dp+0,   0x1.fcc252p-2, INEXACT)
T(RN,    0x1.1af22406a374bp+1,    0x1.255dc6c458022p+0,  -0x1.f6ac58p-2, INEXACT)
T(RN,    0x1.1a72015915f32p+1,    0x1.25322d1659974p+0,  -0x1.f67c52p-2, INEXACT)
T(RN,    0x1.19f218b29f7a3p+1,     0x1.2506865f3c91p+0,   0x1.f871eep-2, INEXACT)
T(RN,    0x1.197269f8f8be3p+1,    0x1.24dad2a03052bp+0,   0x1.fe57f2p-2, INEXACT)
T(RN,    0x1.18f2f511e649cp+1,    0x1.24af11da6aa76p+0,   0x1.f621e8p-2, INEXACT)
T(RN,    0x1.1873b9e338b86p+1,    0x1.2483440f27dc7p+0,   0x1.ff245ap-2, INEXACT)
T(RN,    0x1.17f4b852cc3e2p+1,    0x1.2457693faa9efp+0,   0x1.fba1bep-2, INEXACT)
T(RN,    0x1.1775f046890eap+1,    0x1.242b816d3c25ap+0,   -0x1.feeffp-2, INEXACT)
T(RN,    0x1.16f761a4628a8p+1,    0x1.23ff8c992beeep+0,   0x1.f5e7a4p-2, INEXACT)
T(RN,     0x1.16790c525a48p+1,    0x1.23d38ac4d0d4dp+0,   0x1.f60832p-2, INEXACT)
T(RN,    0x1.15faf0367a242p+1,    0x1.23a77bf187045p+0,   0x1.fc4b6ap-2, INEXACT)
T(RN,    0x1.157d0d36d9da8p+1,    0x1.237b6020b1f52p+0,  -0x1.f831a2p-2, INEXACT)
T(RN,    0x1.14ff63399c8ddp+1,    0x1.234f3753bb955p+0,  -0x1.fd4eb4p-2, INEXACT)
T(RN,    0x1.1481f224f0fe6p+1,    0x1.2323018c14625p+0,  -0x1.f8afc8p-2, INEXACT)
T(RN,     0x1.1404b9df1198p+1,    0x1.22f6becb33749p+0,  -0x1.fe06e2p-2, INEXACT)
T(RN,    0x1.1387ba4e447f9p+1,    0x1.22ca6f12968aep+0,   0x1.fc3f5ep-2, INEXACT)
T(RN,    0x1.130af358db733p+1,    0x1.229e1263c2057p+0,  -0x1.fc3cbep-2, INEXACT)
T(RN,     0x1.128e64e533acp+1,    0x1.2271a8c040e22p+0,  -0x1.f6547ep-2, INEXACT)
T(RN,    0x1.12120ed9b6c3bp+1,    0x1.22453229a5147p+0,   -0x1.fe502p-2, INEXACT)
T(RN,     0x1.1195f11cd8bbp+1,    0x1.2218aea186d7ep+0,   0x1.f65b96p-2, INEXACT)
T(RN,    0x1.111a0b9519e52p+1,    0x1.21ec1e2985659p+0,   0x1.f887e4p-2, INEXACT)
T(RN,    0x1.109e5e2906053p+1,    0x1.21bf80c346aa5p+0,   0x1.fb19e8p-2, INEXACT)
T(RN,    0x1.1022e8bf34559p+1,    0x1.2192d670774f5p+0,   -0x1.f8977p-2, INEXACT)
T(RN,    0x1.0fa7ab3e4791ap+1,    0x1.21661f32cac47p+0,   0x1.fcb3a4p-2, INEXACT)
T(RN,    0x1.0f2ca58cedf16p+1,    0x1.21395b0bfb448p+0,   0x1.f60968p-2, INEXACT)
T(RN,    0x1.0eb1d791e12f9p+1,    0x1.210c89fdc9de8p+0,  -0x1.fce804p-2, INEXACT)
T(RN,    0x1.0e374133e66f7p+1,    0x1.20dfac09fe728p+0,   0x1.fef832p-2, INEXACT)
T(RN,    0x1.0dbce259ce3e7p+1,    0x1.20b2c13267b81p+0,   0x1.fdee0ep-2, INEXACT)
T(RN,    0x1.0d42baea749cap+1,    0x1.2085c978db486p+0,   0x1.fd83dep-2, INEXACT)
T(RN,    0x1.0cc8caccc0df1p+1,    0x1.2058c4df35997p+0,    0x1.f8ee7p-2, INEXACT)
T(RN,    0x1.0c4f11e7a5c6cp+1,    0x1.202bb3675a0cfp+0,   0x1.ff541cp-2, INEXACT)
T(RN,    0x1.0bd590222162ep+1,    0x1.1ffe951332eb9p+0,  -0x1.f8bb46p-2, INEXACT)
T(RN,    0x1.0b5c45633d171p+1,    0x1.1fd169e4b16dfp+0,   0x1.fd089ap-2, INEXACT)
T(RN,    0x1.0ae331920d9a2p+1,    0x1.1fa431ddcdc1dp+0,  -0x1.f65ea2p-2, INEXACT)
T(RN,    0x1.0a6a5495b2ba3p+1,    0x1.1f76ed0086faep+0,   0x1.f5c53ap-2, INEXACT)
T(RN,    0x1.09f1ae55583c6p+1,     0x1.1f499b4ee36cp+0,   0x1.fb71e4p-2, INEXACT)
T(RN,    0x1.09793eb8341e3p+1,    0x1.1f1c3ccaf006ap+0,  -0x1.fbfd36p-2, INEXACT)
T(RN,    0x1.090105a58842cp+1,     0x1.1eeed176c102p+0,   0x1.f6b282p-2, INEXACT)
T(RN,    0x1.08890304a1932p+1,    0x1.1ec15954718cep+0,  -0x1.ff7018p-2, INEXACT)
T(RN,    0x1.081136bcd82a4p+1,    0x1.1e93d46623e51p+0,  -0x1.fd1e18p-2, INEXACT)
T(RN,    0x1.0799a0b58f5d8p+1,    0x1.1e6642ae01605p+0,   0x1.fdfa46p-2, INEXACT)
T(RN,    0x1.072240d6358bfp+1,      0x1.1e38a42e3a6p+0,    0x1.fd724p-2, INEXACT)
T(RN,    0x1.06ab17064441cp+1,     0x1.1e0af8e90665p+0,   -0x1.fdf8ap-2, INEXACT)
T(RN,    0x1.0634232d40303p+1,    0x1.1ddd40e0a412ep+0,    0x1.f86d6p-2, INEXACT)
T(RN,    0x1.05bd6532b910ep+1,    0x1.1daf7c17592a6p+0,  -0x1.fff61ap-2, INEXACT)
T(RN,    0x1.0546dcfe49b18p+1,    0x1.1d81aa8f7294fp+0,   0x1.fe455cp-2, INEXACT)
T(RN,    0x1.04d08a7797ed6p+1,    0x1.1d53cc4b44675p+0,   -0x1.f9b09p-2, INEXACT)
T(RN,    0x1.045a6d8654a9bp+1,    0x1.1d25e14d29e73p+0,   0x1.fbc57ep-2, INEXACT)
T(RN,      0x1.03e486123bdp+1,    0x1.1cf7e997858e2p+0,  -0x1.fe7764p-2, INEXACT)
T(RN,    0x1.036ed403143c4p+1,    0x1.1cc9e52cc1099p+0,   0x1.f9e7aap-2, INEXACT)
T(RN,    0x1.02f95740afc82p+1,    0x1.1c9bd40f4d444p+0,   -0x1.f5c35p-2, INEXACT)
T(RN,     0x1.02840fb2eb41p+1,    0x1.1c6db641a2694p+0,  -0x1.f64e88p-2, INEXACT)
T(RN,    0x1.020efd41ae6ddp+1,    0x1.1c3f8bc63febap+0,   0x1.fdd8e8p-2, INEXACT)
T(RN,    0x1.019a1fd4ebe8dp+1,    0x1.1c11549fac7d6p+0,   0x1.f8140cp-2, INEXACT)
T(RN,    0x1.01257754a13f8p+1,    0x1.1be310d076223p+0,  -0x1.f7cc38p-2, INEXACT)
T(RN,    0x1.00b103a8d6dc3p+1,    0x1.1bb4c05b322c9p+0,   0x1.f9f152p-2, INEXACT)
T(RN,    0x1.003cc4b99ffbap+1,    0x1.1b8663427d3efp+0,  -0x1.f892a4p-2, INEXACT)
T(RN,    0x1.ff9174de3579dp+0,    0x1.1b57f988fb58dp+0,   0x1.f6cf0cp-2, INEXACT)
T(RN,    0x1.fea9c962e0318p+0,    0x1.1b29833157d84p+0,   0x1.f6d852p-2, INEXACT)
T(RN,    0x1.fdc286d1a76bdp+0,    0x1.1afb003e456eep+0,   0x1.fad6d6p-2, INEXACT)
T(RN,    0x1.fcdbacfb08217p+0,    0x1.1acc70b27e373p+0,   0x1.f72e64p-2, INEXACT)
T(RN,    0x1.fbf53baf94d54p+0,    0x1.1a9dd490c3b3dp+0,   0x1.facd5ap-2, INEXACT)
T(RN,    0x1.fb0f32bff5874p+0,    0x1.1a6f2bdbded29p+0,  -0x1.fe8c78p-2, INEXACT)
T(RN,    0x1.fa2991fce799ep+0,    0x1.1a4076969fed1p+0,   0x1.f6c642p-2, INEXACT)
T(RN,    0x1.f94459373de24p+0,    0x1.1a11b4c3ded12p+0,   0x1.fe4a38p-2, INEXACT)
T(RN,    0x1.f85f883fe08f5p+0,    0x1.19e2e6667ac1fp+0,  -0x1.f6de54p-2, INEXACT)
T(RN,    0x1.f77b1ee7cd1e6p+0,    0x1.19b40b815a7b5p+0,  -0x1.ff64f4p-2, INEXACT)
T(RN,    0x1.f6971d0016621p+0,    0x1.198524176c388p+0,   0x1.fc840cp-2, INEXACT)
T(RN,    0x1.f5b38259e45c6p+0,    0x1.1956302ba5b1fp+0,  -0x1.fcacb8p-2, INEXACT)
T(RN,    0x1.f4d04ec6745cfp+0,    0x1.19272fc10429bp+0,   0x1.f91596p-2, INEXACT)
T(RN,    0x1.f3ed821718cc9p+0,    0x1.18f822da8c654p+0,  -0x1.fefd04p-2, INEXACT)
T(RN,    0x1.f30b1c1d387b7p+0,    0x1.18c9097b4a8efp+0,  -0x1.f5c388p-2, INEXACT)
T(RN,    0x1.f2291caa525f3p+0,    0x1.1899e3a653025p+0,  -0x1.ffdfe8p-2, INEXACT)
T(RN,    0x1.f147838ff5edbp+0,    0x1.186ab15ec0ba5p+0,   0x1.f95e3ep-2, INEXACT)
T(RN,    0x1.f066509fcaad9p+0,    0x1.183b72a7b6e9cp+0,  -0x1.fe3b8cp-2, INEXACT)
T(RN,    0x1.ef8583ab8c5c8p+0,    0x1.180c278460341p+0,    0x1.f7c1ap-2, INEXACT)
T(RN,    0x1.eea51c850bc76p+0,    0x1.17dccff7eedefp+0,   0x1.f92272p-2, INEXACT)
T(RN,    0x1.edc51afe2e73bp+0,    0x1.17ad6c059cc62p+0,   0x1.f994bap-2, INEXACT)
T(RN,    0x1.ece57ee8eee86p+0,    0x1.177dfbb0ab6fdp+0,   0x1.f815fep-2, INEXACT)
T(RN,    0x1.ec0648175c814p+0,    0x1.174e7efc6408ap+0,   0x1.f98d4cp-2, INEXACT)
T(RN,    0x1.eb27765b9b631p+0,    0x1.171ef5ec17665p+0,  -0x1.f6291ep-2, INEXACT)
T(RN,    0x1.ea490987e4621p+0,    0x1.16ef60831e07dp+0,  -0x1.f5cc86p-2, INEXACT)
T(RN,     0x1.e96b016e856bp+0,    0x1.16bfbec4d830bp+0,   0x1.f5c3cap-2, INEXACT)
T(RN,    0x1.e88d5de1e08fbp+0,    0x1.169010b4adba2p+0,  -0x1.fb624ep-2, INEXACT)
T(RN,    0x1.e7b01eb46ce3bp+0,     0x1.166056560e48p+0,   0x1.fd62dap-2, INEXACT)
T(RN,     0x1.e6d343b8b608p+0,    0x1.16308fac71344p+0,   0x1.fac154p-2, INEXACT)
T(RN,    0x1.e5f6ccc15c351p+0,    0x1.1600bcbb5596dp+0,   0x1.f70de8p-2, INEXACT)
T(RN,    0x1.e51ab9a11422bp+0,    0x1.15d0dd8642453p+0,   0x1.fb6a74p-2, INEXACT)
T(RN,    0x1.e43f0a2aa7208p+0,    0x1.15a0f210c5dcep+0,   0x1.f6229cp-2, INEXACT)
T(RN,    0x1.e363be30f2e33p+0,    0x1.1570fa5e76bd5p+0,  -0x1.fe5096p-2, INEXACT)
T(RN,    0x1.e288d586e9998p+0,    0x1.1540f672f311cp+0,   0x1.fb0e72p-2, INEXACT)
T(RN,    0x1.e1ae4fff91e08p+0,    0x1.1510e651e0d31p+0,   0x1.fed648p-2, INEXACT)
T(RN,    0x1.e0d42d6e06a64p+0,    0x1.14e0c9feedc6dp+0,  -0x1.f8b038p-2, INEXACT)
T(RN,    0x1.dffa6da57733ap+0,    0x1.14b0a17dcf864p+0,  -0x1.fef1eep-2, INEXACT)
T(RN,    0x1.df211079270aap+0,    0x1.14806cd2437b7p+0,  -0x1.f6eb0ep-2, INEXACT)
T(RN,    0x1.de4815bc6e298p+0,    0x1.14502c000ef55p+0,   0x1.f73928p-2, INEXACT)
T(RN,    0x1.dd6f7d42b8913p+0,    0x1.141fdf0aff114p+0,   0x1.f7dbbep-2, INEXACT)
T(RN,    0x1.dc9746df866cfp+0,    0x1.13ef85f6e8c8ep+0,  -0x1.f681f6p-2, INEXACT)
T(RN,    0x1.dbbf72666c2f4p+0,    0x1.13bf20c7a8fd6p+0,   0x1.fe3d4ap-2, INEXACT)
T(RN,    0x1.dae7ffab125bep+0,    0x1.138eaf81246f9p+0,  -0x1.fcc1ecp-2, INEXACT)
T(RN,    0x1.da10ee81358e5p+0,    0x1.135e322747c6ep+0,  -0x1.f9af48p-2, INEXACT)
T(RN,    0x1.d93a3ebca6694p+0,    0x1.132da8be0791ap+0,  -0x1.fb2526p-2, INEXACT)
T(RN,    0x1.d863f031498f2p+0,    0x1.12fd134960484p+0,  -0x1.f8ce0ep-2, INEXACT)
T(RN,    0x1.d78e02b317ab5p+0,    0x1.12cc71cd5653fp+0,  -0x1.fe1ef8p-2, INEXACT)
T(RN,    0x1.d6b876161d41fp+0,    0x1.129bc44df6084p+0,  -0x1.fb77bap-2, INEXACT)
T(RN,    0x1.d5e34a2e7ad3dp+0,    0x1.126b0acf53afep+0,   0x1.fe7278p-2, INEXACT)
T(RN,    0x1.d50e7ed064afdp+0,    0x1.123a45558b864p+0,    0x1.fe2a1p-2, INEXACT)
T(RN,    0x1.d43a13d02308bp+0,    0x1.120973e4c1c15p+0,  -0x1.f7e9bep-2, INEXACT)
T(RN,    0x1.d366090211d2cp+0,    0x1.11d89681228e2p+0,   0x1.fb706cp-2, INEXACT)
T(RN,    0x1.d2925e3aa0c4bp+0,    0x1.11a7ad2ee214ep+0,   0x1.fbd518p-2, INEXACT)
T(RN,    0x1.d1bf134e5362bp+0,    0x1.1176b7f23c807p+0,    0x1.f6fdcp-2, INEXACT)
T(RN,    0x1.d0ec2811c0c45p+0,    0x1.1145b6cf75f4ep+0,  -0x1.f704bap-2, INEXACT)
T(RN,    0x1.d0199c5993c3ap+0,    0x1.1114a9cada9efp+0,  -0x1.fae824p-2, INEXACT)
T(RN,    0x1.cf476ffa8ac93p+0,    0x1.10e390e8beabep+0,  -0x1.f9b298p-2, INEXACT)
T(RN,    0x1.ce75a2c977e2dp+0,    0x1.10b26c2d7e533p+0,  -0x1.f8b6ccp-2, INEXACT)
T(RN,    0x1.cda4349b4089bp+0,    0x1.10813b9d7dcd3p+0,  -0x1.f6be78p-2, INEXACT)
T(RN,    0x1.ccd32544de16dp+0,    0x1.104fff3d29729p+0,   0x1.fcf28ap-2, INEXACT)
T(RN,    0x1.cc02749b5ce45p+0,    0x1.101eb710f58bep+0,   0x1.ff5d66p-2, INEXACT)
T(RN,    0x1.cb322273dd0c5p+0,    0x1.0fed631d5e82ep+0,   0x1.f9a8c4p-2, INEXACT)
T(RN,    0x1.ca622ea39203dp+0,    0x1.0fbc0366e8ce7p+0,  -0x1.f7b936p-2, INEXACT)
T(RN,    0x1.c99298ffc2a78p+0,    0x1.0f8a97f220f9fp+0,   0x1.f7d894p-2, INEXACT)
T(RN,    0x1.c8c3615dc9194p+0,    0x1.0f5920c39ba05p+0,  -0x1.fe29d6p-2, INEXACT)
T(RN,    0x1.c7f4879312df4p+0,    0x1.0f279ddff5784p+0,  -0x1.f8fb18p-2, INEXACT)
T(RN,    0x1.c7260b7520bfcp+0,    0x1.0ef60f4bd34ecp+0,   -0x1.fe82dp-2, INEXACT)
T(RN,    0x1.c657ecd986bbdp+0,     0x1.0ec4750be20ap+0,  -0x1.ffa77ap-2, INEXACT)
T(RN,    0x1.c58a2b95ec0f6p+0,    0x1.0e92cf24d6ad3p+0,   0x1.f60eb6p-2, INEXACT)
T(RN,    0x1.c4bcc7800b28dp+0,     0x1.0e611d9b6e5ap+0,   0x1.fc1d1ep-2, INEXACT)
T(RN,    0x1.c3efc06db1904p+0,    0x1.0e2f60746e4ebp+0,  -0x1.fb41c4p-2, INEXACT)
T(RN,     0x1.c3231634bfebp+0,    0x1.0dfd97b4a3eaap+0,    0x1.feb54p-2, INEXACT)
T(RN,    0x1.c256c8ab29ff8p+0,    0x1.0dcbc360e4b25p+0,  -0x1.f90c4ap-2, INEXACT)
T(RN,    0x1.c18ad7a6f68d6p+0,    0x1.0d99e37e0e4a3p+0,   0x1.f873aep-2, INEXACT)
T(RN,    0x1.c0bf42fe3f61fp+0,    0x1.0d67f811067e3p+0,  -0x1.f6dbbap-2, INEXACT)
T(RN,    0x1.bff40a87313b8p+0,    0x1.0d36011ebb3f3p+0,   -0x1.f820cp-2, INEXACT)
T(RN,    0x1.bf292e180bd15p+0,    0x1.0d03feac22a7dp+0,   0x1.ff382ap-2, INEXACT)
T(RN,    0x1.be5ead8721be7p+0,    0x1.0cd1f0be3afabp+0,  -0x1.fe5d56p-2, INEXACT)
T(RN,    0x1.bd9488aad8857p+0,    0x1.0c9fd75a0aa75p+0,  -0x1.fae1aap-2, INEXACT)
T(RN,    0x1.bccabf59a870ep+0,     0x1.0c6db284a045p+0,  -0x1.ff1ce2p-2, INEXACT)
T(RN,    0x1.bc01516a1c973p+0,    0x1.0c3b824312977p+0,  -0x1.f7b8f4p-2, INEXACT)
T(RN,    0x1.bb383eb2d2fe1p+0,    0x1.0c09469a809adp+0,   0x1.f6583ap-2, INEXACT)
T(RN,    0x1.ba6f870a7c383p+0,    0x1.0bd6ff90116e5p+0,   0x1.f6d212p-2, INEXACT)
T(RN,     0x1.b9a72a47dba1p+0,    0x1.0ba4ad28f4669p+0,   0x1.fa314ep-2, INEXACT)
T(RN,    0x1.b8df2841c7477p+0,    0x1.0b724f6a610b4p+0,    0x1.f9ce7p-2, INEXACT)
T(RN,    0x1.b81780cf27d0fp+0,     0x1.0b3fe6599713p+0,   0x1.f9ba96p-2, INEXACT)
T(RN,    0x1.b75033c6f8823p+0,    0x1.0b0d71fbde68ap+0,   0x1.f996bep-2, INEXACT)
T(RN,     0x1.b6894100473bp+0,    0x1.0adaf256872d1p+0,  -0x1.f9343ap-2, INEXACT)
T(RN,    0x1.b5c2a85234632p+0,    0x1.0aa8676ee9b5dp+0,   0x1.fb2bbep-2, INEXACT)
T(RN,    0x1.b4fc6993f2dd4p+0,    0x1.0a75d14a668bfp+0,   0x1.f7be3ap-2, INEXACT)
T(RN,    0x1.b436849cc80edp+0,    0x1.0a432fee66719p+0,   0x1.fcc908p-2, INEXACT)
T(RN,    0x1.b370f9440bcb4p+0,    0x1.0a1083605a5f1p+0,  -0x1.faed62p-2, INEXACT)
T(RN,     0x1.b2abc7612855p+0,    0x1.09ddcba5bb867p+0,  -0x1.f81ddap-2, INEXACT)
T(RN,    0x1.b1e6eecb9a437p+0,    0x1.09ab08c40b4f1p+0,   0x1.f832c2p-2, INEXACT)
T(RN,     0x1.b1226f5af094p+0,    0x1.09783ac0d35ccp+0,   -0x1.fc45ap-2, INEXACT)
T(RN,    0x1.b05e48e6cc933p+0,    0x1.094561a1a58d2p+0,   0x1.fd3bcep-2, INEXACT)
T(RN,    0x1.af9a7b46e1c85p+0,    0x1.09127d6c1bf41p+0,  -0x1.f695dep-2, INEXACT)
T(RN,    0x1.aed70652f5f09p+0,    0x1.08df8e25d8ddfp+0,   0x1.f6eb56p-2, INEXACT)
T(RN,    0x1.ae13e9e2e156dp+0,    0x1.08ac93d486e82p+0,  -0x1.f97b72p-2, INEXACT)
T(RN,    0x1.ad5125ce8df16p+0,    0x1.08798e7dd8c96p+0,  -0x1.fe472ep-2, INEXACT)
T(RN,    0x1.ac8eb9edf82f8p+0,    0x1.08467e2789893p+0,  -0x1.f7bd14p-2, INEXACT)
T(RN,    0x1.abcca6192ea1bp+0,    0x1.081362d75c6bbp+0,  -0x1.f76a0ep-2, INEXACT)
T(RN,    0x1.ab0aea2851c66p+0,    0x1.07e03c931ce66p+0,  -0x1.feb5b4p-2, INEXACT)
T(RN,    0x1.aa4985f39447cp+0,    0x1.07ad0b609eb2bp+0,  -0x1.fc0c02p-2, INEXACT)
T(RN,    0x1.a98879533acd7p+0,    0x1.0779cf45bdc42p+0,    0x1.fc875p-2, INEXACT)
T(RN,    0x1.a8c7c41f9bfe9p+0,    0x1.074688485e4abp+0,  -0x1.f5d642p-2, INEXACT)
T(RN,    0x1.a8076631208abp+0,    0x1.0713366e6cb82p+0,    0x1.f6f9ap-2, INEXACT)
T(RN,    0x1.a7475f6042e99p+0,    0x1.06dfd9bdddb01p+0,   0x1.fc38a8p-2, INEXACT)
T(RN,    0x1.a687af858f8cbp+0,    0x1.06ac723cae17ep+0,  -0x1.ff1a2ap-2, INEXACT)
T(RN,     0x1.a5c85679a4cap+0,     0x1.0678fff0e313p+0,  -0x1.fba6f6p-2, INEXACT)
T(RN,    0x1.a509541532c17p+0,    0x1.064582e089fd9p+0,   0x1.fed82ap-2, INEXACT)
T(RN,     0x1.a44aa830fb6ap+0,    0x1.0611fb11b871cp+0,  -0x1.fef068p-2, INEXACT)
T(RN,    0x1.a38c52a5d27bbp+0,    0x1.05de688a8c446p+0,   0x1.ffddd2p-2, INEXACT)
T(RN,    0x1.a2ce534c9d634p+0,    0x1.05aacb512b827p+0,  -0x1.fc8504p-2, INEXACT)
T(RN,    0x1.a210a9fe529e8p+0,    0x1.0577236bc4473p+0,  -0x1.f5e684p-2, INEXACT)
T(RN,    0x1.a1535693fd256p+0,    0x1.054370e08dab6p+0,   0x1.f65bd8p-2, INEXACT)
T(RN,    0x1.a09658e6b5523p+0,    0x1.050fb3b5c5d7dp+0,   0x1.fe0074p-2, INEXACT)
T(RN,    0x1.9fd9b0cfa7f17p+0,    0x1.04dbebf1b3f44p+0,  -0x1.fa8eccp-2, INEXACT)
T(RN,    0x1.9f1d5e2812bcbp+0,    0x1.04a8199aa7334p+0,  -0x1.ff3f64p-2, INEXACT)
T(RN,    0x1.9e6160c944e82p+0,     0x1.04743cb6f6fap+0,    0x1.f674dp-2, INEXACT)
T(RN,    0x1.9da5b88c9f3ccp+0,     0x1.0440554d02e9p+0,   0x1.fe7fe2p-2, INEXACT)
T(RN,    0x1.9cea654b93f66p+0,    0x1.040c636332d46p+0,   -0x1.f6506p-2, INEXACT)
T(RN,    0x1.9c2f66dfa6cd5p+0,    0x1.03d866fff6c7fp+0,  -0x1.fe170ep-2, INEXACT)
T(RN,    0x1.9b74bd226ce59p+0,    0x1.03a46029c703ap+0,   0x1.fe29dap-2, INEXACT)
T(RN,    0x1.9aba67ed8cc6ap+0,    0x1.03704ee723fa7p+0,  -0x1.f8f752p-2, INEXACT)
T(RN,    0x1.9a00671abe5d5p+0,    0x1.033c333e9654cp+0,  -0x1.fec1c2p-2, INEXACT)
T(RN,    0x1.9946ba83cae7dp+0,    0x1.03080d36aeeb6p+0,   0x1.fd4b4cp-2, INEXACT)
T(RN,    0x1.988d62028ceb4p+0,    0x1.02d3dcd606c5cp+0,  -0x1.f78a22p-2, INEXACT)
T(RN,    0x1.97d45d70f03c1p+0,    0x1.029fa2233f1dfp+0,  -0x1.fc4822p-2, INEXACT)
T(RN,    0x1.971baca8f1f12p+0,    0x1.026b5d25015d7p+0,  -0x1.f920a2p-2, INEXACT)
T(RN,    0x1.96634f84a04b5p+0,    0x1.02370de1ff179p+0,  -0x1.fbae92p-2, INEXACT)
T(RN,    0x1.95ab45de1ac0dp+0,    0x1.0202b460f20d8p+0,  -0x1.f9d244p-2, INEXACT)
T(RN,    0x1.94f38f8f91dfep+0,    0x1.01ce50a89c26ep+0,  -0x1.f60808p-2, INEXACT)
T(RN,    0x1.943c2c73479f4p+0,    0x1.0199e2bfc789ap+0,   0x1.f7193ap-2, INEXACT)
T(RN,    0x1.93851c638ea89p+0,    0x1.01656aad4666bp+0,   0x1.fb40a4p-2, INEXACT)
T(RN,    0x1.92ce5f3acadb2p+0,    0x1.0130e877f3206p+0,   0x1.f9acb8p-2, INEXACT)
T(RN,    0x1.9217f4d3712eap+0,    0x1.00fc5c26b0428p+0,   0x1.fc8a74p-2, INEXACT)
T(RN,    0x1.9161dd080790cp+0,    0x1.00c7c5c068792p+0,  -0x1.f7d606p-2, INEXACT)
T(RN,    0x1.90ac17b324e81p+0,    0x1.0093254c0e924p+0,   0x1.feb838p-2, INEXACT)
T(RN,    0x1.8ff6a4af710b1p+0,    0x1.005e7ad09d7b2p+0,   0x1.fe738ep-2, INEXACT)
T(RN,    0x1.8f4183d7a4bfep+0,    0x1.0029c65518413p+0,  -0x1.fda44cp-2, INEXACT)
T(RN,    0x1.8e8cb50689a32p+0,    0x1.ffea0fc114164p-1,  -0x1.fc9428p-2, INEXACT)
T(RN,    0x1.8dd83816fa316p+0,    0x1.ff807ef40c373p-1,  -0x1.f63816p-2, INEXACT)
T(RN,    0x1.8d240ce3e1c02p+0,    0x1.ff16da514f9fcp-1,   0x1.fc57fap-2, INEXACT)
T(RN,    0x1.8c7033483c654p+0,    0x1.fead21e725316p-1,   0x1.f97e7cp-2, INEXACT)
T(RN,     0x1.8bbcab1f16fep+0,    0x1.fe4355c3e3f94p-1,   0x1.fe8f16p-2, INEXACT)
T(RN,    0x1.8b0974438f272p+0,    0x1.fdd975f5f32bcp-1,   0x1.fb9d28p-2, INEXACT)
T(RN,    0x1.8a568e90d3278p+0,    0x1.fd6f828bca181p-1,   0x1.f8c8f8p-2, INEXACT)
T(RN,    0x1.89a3f9e222021p+0,    0x1.fd057b93f032ep-1,   0x1.fcde06p-2, INEXACT)
T(RN,     0x1.88f1b612cb4cp+0,    0x1.fc9b611cfcfd9p-1,   0x1.f6e238p-2, INEXACT)
T(RN,    0x1.883fc2fe2f49ap+0,    0x1.fc31333598172p-1,  -0x1.fe4feep-2, INEXACT)
T(RN,    0x1.878e207fbec19p+0,    0x1.fbc6f1ec79218p-1,   -0x1.f9e18p-2, INEXACT)
T(RN,    0x1.86dcce72fb1b5p+0,    0x1.fb5c9d5067d32p-1,   0x1.f6424ap-2, INEXACT)
T(RN,    0x1.862bccb376595p+0,    0x1.faf235703bf31p-1,   0x1.f91748p-2, INEXACT)
T(RN,    0x1.857b1b1cd2baap+0,    0x1.fa87ba5add1ffp-1,  -0x1.f99c12p-2, INEXACT)
T(RN,    0x1.84cab98ac32d1p+0,    0x1.fa1d2c1f4313dp-1,  -0x1.ff5f0ap-2, INEXACT)
T(RN,    0x1.841aa7d90aff7p+0,    0x1.f9b28acc75747p-1,   0x1.f9dbb2p-2, INEXACT)
T(RN,    0x1.836ae5e37de91p+0,    0x1.f947d6718bd6cp-1,   -0x1.feadfp-2, INEXACT)
T(RN,    0x1.82bb738600092p+0,    0x1.f8dd0f1dadbe2p-1,   0x1.f71b52p-2, INEXACT)
T(RN,    0x1.820c509c85c6fp+0,     0x1.f87234e01287p-1,  -0x1.f8aefap-2, INEXACT)
T(RN,    0x1.815d7d031402bp+0,    0x1.f80747c801845p-1,   -0x1.f85b7p-2, INEXACT)
T(RN,    0x1.80aef895bfba4p+0,    0x1.f79c47e4d1c5ep-1,     0x1.fd8bp-2, INEXACT)
T(RN,    0x1.8000c330ae4a2p+0,    0x1.f7313545ea3eap-1,   0x1.fef112p-2, INEXACT)
T(RN,    0x1.7f52dcb015437p+0,    0x1.f6c60ffac1a9ap-1,  -0x1.fe46fcp-2, INEXACT)
T(RN,    0x1.7ea544f03a727p+0,    0x1.f65ad812de8c6p-1,  -0x1.fe8cb6p-2, INEXACT)
T(RN,    0x1.7df7fbcd73cb3p+0,    0x1.f5ef8d9dd728dp-1,  -0x1.fd4322p-2, INEXACT)
T(RN,    0x1.7d4b0124276f1p+0,    0x1.f58430ab517f1p-1,  -0x1.f7c384p-2, INEXACT)
T(RN,    0x1.7c9e54d0cb949p+0,    0x1.f518c14b033c7p-1,    0x1.fd454p-2, INEXACT)
T(RN,    0x1.7bf1f6afe6933p+0,    0x1.f4ad3f8cb1c06p-1,  -0x1.f93a2ap-2, INEXACT)
T(RN,      0x1.7b45e69e0edp+0,    0x1.f441ab80320edp-1,   0x1.f72edcp-2, INEXACT)
T(RN,    0x1.7a9a2477eabe4p+0,    0x1.f3d6053568cd6p-1,   0x1.f9d8aap-2, INEXACT)
T(RN,    0x1.79eeb01a30cacp+0,    0x1.f36a4cbc4a34bp-1,   0x1.f8ab36p-2, INEXACT)
T(RN,    0x1.79438961a75e5p+0,     0x1.f2fe8224da0fp-1,    0x1.fd00ap-2, INEXACT)
T(RN,    0x1.7898b02b24db5p+0,    0x1.f292a57f2bb41p-1,   0x1.fa3b98p-2, INEXACT)
T(RN,    0x1.77ee24538f954p+0,    0x1.f226b6db62011p-1,   0x1.f69c08p-2, INEXACT)
T(RN,    0x1.7743e5b7ddb4cp+0,    0x1.f1bab649af43fp-1,  -0x1.fbca0ap-2, INEXACT)
T(RN,    0x1.7699f435153f8p+0,    0x1.f14ea3da553dap-1,   0x1.f7590cp-2, INEXACT)
T(RN,    0x1.75f04fa84c3ddp+0,    0x1.f0e27f9da5364p-1,  -0x1.fd8c0cp-2, INEXACT)
T(RN,    0x1.7546f7eea842ep+0,    0x1.f07649a3ffae8p-1,  -0x1.f94eaep-2, INEXACT)
T(RN,    0x1.749dece55ee35p+0,    0x1.f00a01fdd4a72p-1,  -0x1.fff74ep-2, INEXACT)
T(RN,    0x1.73f52e69b5533p+0,    0x1.ef9da8bba35f4p-1,  -0x1.fd1eb2p-2, INEXACT)
T(RN,    0x1.734cbc59008e1p+0,    0x1.ef313dedfa6a6p-1,   0x1.fc2486p-2, INEXACT)
T(RN,    0x1.72a49690a5483p+0,     0x1.eec4c1a577a3p-1,   0x1.f89c1ap-2, INEXACT)
T(RN,    0x1.71fcbcee17d64p+0,    0x1.ee5833f2c8179p-1,   0x1.fe3064p-2, INEXACT)
T(RN,    0x1.71552f4edc35ap+0,    0x1.edeb94e6a80b9p-1,   0x1.fdafbep-2, INEXACT)
T(RN,    0x1.70aded90860a5p+0,    0x1.ed7ee491e2f25p-1,   0x1.f80474p-2, INEXACT)
T(RN,    0x1.7006f790b8807p+0,    0x1.ed1223055356fp-1,  -0x1.fe7aa2p-2, INEXACT)
T(RN,    0x1.6f604d2d265cfp+0,    0x1.eca55051e2e34p-1,   0x1.f66578p-2, INEXACT)
T(RN,    0x1.6eb9ee4391e68p+0,    0x1.ec386c888a4bcp-1,   0x1.f76262p-2, INEXACT)
T(RN,    0x1.6e13dab1ccf73p+0,    0x1.ebcb77ba51574p-1,  -0x1.fdd35ep-2, INEXACT)
T(RN,    0x1.6d6e1255b8d03p+0,    0x1.eb5e71f84ebd5p-1,   0x1.f9bd98p-2, INEXACT)
T(RN,    0x1.6cc8950d462a5p+0,    0x1.eaf15b53a82bbp-1,  -0x1.ffc748p-2, INEXACT)
T(RN,    0x1.6c2362b675324p+0,    0x1.ea8433dd923ffp-1,  -0x1.ffd482p-2, INEXACT)
T(RN,    0x1.6b7e7b2f556e2p+0,    0x1.ea16fba750706p-1,  -0x1.fb4d12p-2, INEXACT)
T(RN,    0x1.6ad9de5605d5cp+0,    0x1.e9a9b2c235176p-1,   -0x1.fa8b7p-2, INEXACT)
T(RN,    0x1.6a358c08b49c6p+0,    0x1.e93c593fa14a3p-1,  -0x1.f5d28ep-2, INEXACT)
T(RN,    0x1.699184259f71ep+0,    0x1.e8ceef3104ff1p-1,   0x1.f6df62p-2, INEXACT)
T(RN,    0x1.68edc68b1329bp+0,    0x1.e86174a7decc6p-1,   0x1.fa36c4p-2, INEXACT)
T(RN,    0x1.684a53176bda7p+0,    0x1.e7f3e9b5bbf87p-1,    0x1.fbd9ep-2, INEXACT)
T(RN,    0x1.67a729a914e77p+0,    0x1.e7864e6c387a1p-1,   0x1.ffb004p-2, INEXACT)
T(RN,    0x1.67044a1e88e85p+0,    0x1.e718a2dcfee29p-1,  -0x1.f81baap-2, INEXACT)
T(RN,    0x1.6661b45651999p+0,    0x1.e6aae719c84ddp-1,   0x1.fa3594p-2, INEXACT)
T(RN,    0x1.65bf682f07e39p+0,    0x1.e63d1b345c605p-1,   -0x1.f5c97p-2, INEXACT)
T(RN,    0x1.651d658753d4bp+0,    0x1.e5cf3f3e913e1p-1,  -0x1.f8885cp-2, INEXACT)
T(RN,    0x1.647bac3dec889p+0,    0x1.e561534a4b72fp-1,  -0x1.ffe5f6p-2, INEXACT)
T(RN,    0x1.63da3c319837ap+0,    0x1.e4f357697df75p-1,   0x1.f9a1bap-2, INEXACT)
T(RN,    0x1.633915412c23ap+0,    0x1.e4854bae2a1c1p-1,  -0x1.f5d55cp-2, INEXACT)
T(RN,     0x1.6298374b8c95p+0,    0x1.e417302a5f82ep-1,  -0x1.fe64f4p-2, INEXACT)
T(RN,    0x1.61f7a22facc91p+0,    0x1.e3a904f03c0adp-1,  -0x1.f8173ep-2, INEXACT)
T(RN,    0x1.615755cc8f038p+0,    0x1.e33aca11ebd5fp-1,   0x1.f7e3d6p-2, INEXACT)
T(RN,    0x1.60b75201446ebp+0,    0x1.e2cc7fa1a92c7p-1,   0x1.fea1bep-2, INEXACT)
T(RN,    0x1.601796aced1f4p+0,    0x1.e25e25b1bc786p-1,  -0x1.f9bb4cp-2, INEXACT)
T(RN,    0x1.5f7823aeb8135p+0,    0x1.e1efbc547c3e3p-1,   0x1.fe9be8p-2, INEXACT)
T(RN,    0x1.5ed8f8e5e320fp+0,    0x1.e181439c4d08dp-1,   0x1.faec3ap-2, INEXACT)
T(RN,    0x1.5e3a1631baf2ap+0,    0x1.e112bb9ba1608p-1,  -0x1.fe7146p-2, INEXACT)
T(RN,    0x1.5d9b7b719b02bp+0,    0x1.e0a42464f9c03p-1,   0x1.f9c096p-2, INEXACT)
T(RN,    0x1.5cfd2884ed915p+0,    0x1.e0357e0ae4867p-1,  -0x1.f6d078p-2, INEXACT)
T(RN,    0x1.5c5f1d4b2bb79p+0,    0x1.dfc6c89ffdfc1p-1,    0x1.f5d02p-2, INEXACT)
T(RN,    0x1.5bc159a3dd24ap+0,    0x1.df580436f01cbp-1,  -0x1.fbbf02p-2, INEXACT)
T(RN,    0x1.5b23dd6e984c8p+0,    0x1.dee930e272b08p-1,   0x1.fbd7f2p-2, INEXACT)
T(RN,    0x1.5a86a88b0259dp+0,    0x1.de7a4eb54b397p-1,  -0x1.f76802p-2, INEXACT)
T(RN,    0x1.59e9bad8cf113p+0,    0x1.de0b5dc24cd7ep-1,  -0x1.fa3b04p-2, INEXACT)
T(RN,    0x1.594d1437c0da4p+0,    0x1.dd9c5e1c58481p-1,  -0x1.fb75e8p-2, INEXACT)
T(RN,    0x1.58b0b487a8c04p+0,    0x1.dd2d4fd65bdabp-1,   0x1.f6eb64p-2, INEXACT)
T(RN,    0x1.58149ba866553p+0,    0x1.dcbe33035357ap-1,  -0x1.fa65e2p-2, INEXACT)
T(RN,    0x1.5778c979e7396p+0,    0x1.dc4f07b6479ffp-1,  -0x1.f5dfccp-2, INEXACT)
T(RN,     0x1.56dd3ddc299ep+0,    0x1.dbdfce02506fbp-1,   0x1.fce34ap-2, INEXACT)
T(RN,    0x1.5641f8af37278p+0,    0x1.db7085fa90adep-1,   0x1.ff195cp-2, INEXACT)
T(RN,    0x1.55a6f9d329f56p+0,    0x1.db012fb239fbap-1,  -0x1.f89058p-2, INEXACT)
T(RN,    0x1.550c41282a1ddp+0,     0x1.da91cb3c8adfp-1,  -0x1.fe8be6p-2, INEXACT)
T(RN,    0x1.5471ce8e6e1ccp+0,    0x1.da2258accf08ep-1,  -0x1.fd4744p-2, INEXACT)
T(RN,    0x1.53d7a1e63ad65p+0,    0x1.d9b2d8165f4dcp-1,  -0x1.f84aacp-2, INEXACT)
T(RN,    0x1.533dbb0fe393bp+0,    0x1.d943498ca19a3p-1,  -0x1.f65288p-2, INEXACT)
T(RN,    0x1.52a419ebc9acfp+0,    0x1.d8d3ad2308aaep-1,   0x1.f5d96ap-2, INEXACT)
T(RN,    0x1.520abe5a5dcb9p+0,    0x1.d86402ed14ed7p-1,   0x1.f8dc3ep-2, INEXACT)
T(RN,    0x1.5171a83c1d686p+0,    0x1.d7f44afe52a42p-1,  -0x1.f64f48p-2, INEXACT)
T(RN,    0x1.50d8d7719548cp+0,    0x1.d784856a5babbp-1,   0x1.fd1064p-2, INEXACT)
T(RN,    0x1.50404bdb601edp+0,     0x1.d714b244d671p-1,   0x1.fd8f56p-2, INEXACT)
T(RN,    0x1.4fa8055a26de7p+0,    0x1.d6a4d1a17625ap-1,   0x1.ffcf48p-2, INEXACT)
T(RN,    0x1.4f1003cea0abfp+0,    0x1.d634e393faa8cp-1,  -0x1.fae352p-2, INEXACT)
T(RN,    0x1.4e78471992d65p+0,    0x1.d5c4e83030792p-1,  -0x1.ff9f7ap-2, INEXACT)
T(RN,    0x1.4de0cf1bd0d38p+0,    0x1.d554df89f0a7cp-1,   0x1.ff0aeep-2, INEXACT)
T(RN,    0x1.4d499bb63c30ap+0,    0x1.d4e4c9b520c1dp-1,  -0x1.f657f4p-2, INEXACT)
T(RN,    0x1.4cb2acc9c497ep+0,    0x1.d474a6c5b2cb3p-1,   0x1.fd4cb4p-2, INEXACT)
T(RN,    0x1.4c1c023767cc2p+0,    0x1.d40476cfa52fcp-1,  -0x1.f90522p-2, INEXACT)
T(RN,    0x1.4b859be031887p+0,    0x1.d39439e702a18p-1,   0x1.ff0758p-2, INEXACT)
T(RN,    0x1.4aef79a53b94ep+0,    0x1.d323f01fe21c4p-1,  -0x1.f8f582p-2, INEXACT)
T(RN,    0x1.4a599b67adbedp+0,    0x1.d2b3998e66d61p-1,   0x1.f6de0ap-2, INEXACT)
T(RN,    0x1.49c40108bdd8ap+0,    0x1.d2433646c0333p-1,   0x1.fabe02p-2, INEXACT)
T(RN,    0x1.492eaa69af751p+0,    0x1.d1d2c65d29881p-1,   0x1.f7169ep-2, INEXACT)
T(RN,    0x1.4899976bd43eep+0,    0x1.d16249e5ea4f9p-1,   -0x1.fbbf8p-2, INEXACT)
T(RN,    0x1.4804c7f08bbc8p+0,    0x1.d0f1c0f555f2cp-1,  -0x1.f60636p-2, INEXACT)
T(RN,    0x1.47703bd9433efp+0,    0x1.d0812b9fcbb02p-1,   0x1.f77456p-2, INEXACT)
T(RN,     0x1.46dbf3077619p+0,     0x1.d01089f9b6bap-1,   0x1.fb2d68p-2, INEXACT)
T(RN,    0x1.4647ed5cad3e7p+0,    0x1.cf9fdc178de1cp-1,   0x1.fb39e6p-2, INEXACT)
T(RN,    0x1.45b42aba7f905p+0,    0x1.cf2f220dd3c5dp-1,   0x1.f6996ep-2, INEXACT)
T(RN,    0x1.4520ab0291a62p+0,    0x1.cebe5bf1169c4p-1,     0x1.fc15p-2, INEXACT)
T(RN,    0x1.448d6e1695e34p+0,    0x1.ce4d89d5f0372p-1,  -0x1.fe76f6p-2, INEXACT)
T(RN,    0x1.43fa73d84c564p+0,    0x1.cddcabd105dfcp-1,  -0x1.fbefd8p-2, INEXACT)
T(RN,    0x1.4367bc2982cadp+0,    0x1.cd6bc1f70857fp-1,  -0x1.fb75cap-2, INEXACT)
T(RN,    0x1.42d546ec14b5ep+0,    0x1.ccfacc5cb3bedp-1,  -0x1.fb6dc6p-2, INEXACT)
T(RN,    0x1.42431401eb321p+0,    0x1.cc89cb16cf81cp-1,   0x1.f9e2e2p-2, INEXACT)
T(RN,    0x1.41b1234cfcf7ep+0,    0x1.cc18be3a2e49bp-1,    0x1.f7335p-2, INEXACT)
T(RN,    0x1.411f74af4e598p+0,    0x1.cba7a5dbadebbp-1,  -0x1.f81d78p-2, INEXACT)
T(RN,    0x1.408e080af150ep+0,    0x1.cb36821037676p-1,   0x1.ff5f92p-2, INEXACT)
T(RN,    0x1.3ffcdd42054acp+0,    0x1.cac552ecbeb09p-1,   0x1.fa0b22p-2, INEXACT)
T(RN,    0x1.3f6bf436b7472p+0,    0x1.ca54188642bc4p-1,    0x1.fe71dp-2, INEXACT)
T(RN,     0x1.3edb4ccb41bep+0,    0x1.c9e2d2f1cd5e3p-1,   0x1.f9a7bap-2, INEXACT)
T(RN,    0x1.3e4ae6e1ecb48p+0,    0x1.c9718244734c7p-1,  -0x1.f68b34p-2, INEXACT)
T(RN,    0x1.3dbac25d0db43p+0,    0x1.c9002693540bfp-1,   0x1.ffa31ep-2, INEXACT)
T(RN,    0x1.3d2adf1f07778p+0,    0x1.c88ebff399a0ep-1,  -0x1.fc6276p-2, INEXACT)
T(RN,    0x1.3c9b3d0a4a59ep+0,    0x1.c81d4e7a78da7p-1,   -0x1.fbcb4p-2, INEXACT)
T(RN,    0x1.3c0bdc0154069p+0,    0x1.c7abd23d3104fp-1,   -0x1.fadcdp-2, INEXACT)
T(RN,    0x1.3b7cbbe6af8a6p+0,    0x1.c73a4b510beabp-1,   0x1.f8ea9ap-2, INEXACT)
T(RN,    0x1.3aeddc9cf546fp+0,     0x1.c6c8b9cb5dbcp-1,  -0x1.fbddc6p-2, INEXACT)
T(RN,    0x1.3a5f3e06cae7dp+0,    0x1.c6571dc184f99p-1,   0x1.fe5066p-2, INEXACT)
T(RN,    0x1.39d0e006e377fp+0,    0x1.c5e57748ea76ep-1,  -0x1.fa2632p-2, INEXACT)
T(RN,    0x1.3942c27fff2e7p+0,    0x1.c573c6770124ap-1,   0x1.f6c784p-2, INEXACT)
T(RN,    0x1.38b4e554eb8cep+0,    0x1.c5020b614619fp-1,   0x1.fdcaf2p-2, INEXACT)
T(RN,    0x1.382748688356ep+0,    0x1.c490461d40806p-1,  -0x1.fa82d8p-2, INEXACT)
T(RN,    0x1.3799eb9dae6e2p+0,    0x1.c41e76c08168fp-1,    0x1.fe631p-2, INEXACT)
T(RN,    0x1.370cced761f5bp+0,    0x1.c3ac9d60a3d9ap-1,  -0x1.f688aep-2, INEXACT)
T(RN,     0x1.367ff1f8a025p+0,    0x1.c33aba134c9bdp-1,  -0x1.f74758p-2, INEXACT)
T(RN,    0x1.35f354e47871ap+0,    0x1.c2c8ccee2a4efp-1,   -0x1.fa564p-2, INEXACT)
T(RN,    0x1.3566f77e073d3p+0,     0x1.c256d606f518p-1,   0x1.f9c3b6p-2, INEXACT)
T(RN,    0x1.34dad9a876369p+0,    0x1.c1e4d5736ee17p-1,  -0x1.f99e96p-2, INEXACT)
T(RN,    0x1.344efb46fbeb6p+0,    0x1.c172cb4962f38p-1,   0x1.faa6d2p-2, INEXACT)
T(RN,     0x1.33c35c3cdc06p+0,    0x1.c100b79ea616fp-1,  -0x1.f863d2p-2, INEXACT)
T(RN,    0x1.3337fc6d6744ap+0,      0x1.c08e9a89168p-1,  -0x1.ffe75ap-2, INEXACT)
T(RN,    0x1.32acdbbbfb3fdp+0,    0x1.c01c741e9b8fep-1,  -0x1.f5d918p-2, INEXACT)
T(RN,    0x1.3221fa0c02aebp+0,    0x1.bfaa447525fdep-1,  -0x1.fce332p-2, INEXACT)
T(RN,    0x1.31975740f51cdp+0,    0x1.bf380ba2af8b9p-1,  -0x1.fe8326p-2, INEXACT)
T(RN,    0x1.310cf33e57066p+0,    0x1.bec5c9bd3b0ccp-1,   0x1.febb5ap-2, INEXACT)
T(RN,    0x1.3082cde7b9d93p+0,    0x1.be537edad458ep-1,  -0x1.f5e268p-2, INEXACT)
T(RN,    0x1.2ff8e720bbd82p+0,    0x1.bde12b119024cp-1,  -0x1.fb5ed8p-2, INEXACT)
T(RN,    0x1.2f6f3ecd0827cp+0,     0x1.bd6ece778bfdp-1,  -0x1.fd0fe2p-2, INEXACT)
T(RN,    0x1.2ee5d4d055b1bp+0,    0x1.bcfc6922ed49ep-1,   0x1.f5d18cp-2, INEXACT)
T(RN,    0x1.2e5ca90e6c5fbp+0,    0x1.bc89fb29e59b5p-1,   0x1.fa118cp-2, INEXACT)
T(RN,    0x1.2dd3bb6b1a9e2p+0,    0x1.bc1784a2a9dbbp-1,  -0x1.f69256p-2, INEXACT)
T(RN,    0x1.2d4b0bca3fc59p+0,    0x1.bba505a37aed7p-1,  -0x1.f5d67ap-2, INEXACT)
T(RN,    0x1.2cc29a0fc6e7dp+0,    0x1.bb327e42a145ep-1,  -0x1.f60942p-2, INEXACT)
T(RN,    0x1.2c3a661fa7c65p+0,    0x1.babfee966daadp-1,  -0x1.f72684p-2, INEXACT)
T(RN,    0x1.2bb26fdde6d6cp+0,    0x1.ba4d56b539267p-1,  -0x1.f6e558p-2, INEXACT)
T(RN,    0x1.2b2ab72e954f8p+0,    0x1.b9dab6b56501ep-1,  -0x1.fa555ep-2, INEXACT)
T(RN,    0x1.2aa33bf5d0e36p+0,    0x1.b9680ead5a7b9p-1,   0x1.fc8f6ap-2, INEXACT)
T(RN,    0x1.2a1bfe17c40afp+0,    0x1.b8f55eb38af4cp-1,   0x1.ff874cp-2, INEXACT)
T(RN,    0x1.2994fd78a5c7dp+0,    0x1.b882a6de6fae5p-1,  -0x1.fdee24p-2, INEXACT)
T(RN,    0x1.290e39fcb9b8bp+0,    0x1.b80fe74489c97p-1,   0x1.f9e468p-2, INEXACT)
T(RN,    0x1.2887b3885003cp+0,    0x1.b79d1ffc62245p-1,  -0x1.f7e844p-2, INEXACT)
T(RN,    0x1.280169ffc55e2p+0,    0x1.b72a511c8950ep-1,  -0x1.f8970cp-2, INEXACT)
T(RN,    0x1.277b5d4783032p+0,    0x1.b6b77abb977c4p-1,   0x1.f81ea4p-2, INEXACT)
T(RN,    0x1.26f58d43fea47p+0,    0x1.b6449cf02c50bp-1,   0x1.fed814p-2, INEXACT)
T(RN,    0x1.266ff9d9ba795p+0,    0x1.b5d1b7d0eef24p-1,   0x1.fb9288p-2, INEXACT)
T(RN,    0x1.25eaa2ed451f8p+0,    0x1.b55ecb748dd32p-1,  -0x1.f97a28p-2, INEXACT)
T(RN,    0x1.2565886339a6cp+0,    0x1.b4ebd7f1bead1p-1,   0x1.ff590cp-2, INEXACT)
T(RN,    0x1.24e0aa203f86cp+0,    0x1.b478dd5f3e673p-1,  -0x1.f92a2ep-2, INEXACT)
T(RN,    0x1.245c08090aa51p+0,    0x1.b405dbd3d10b2p-1,  -0x1.f7c3dap-2, INEXACT)
T(RN,    0x1.23d7a2025b2a9p+0,    0x1.b392d366418e8p-1,   0x1.f82ad2p-2, INEXACT)
T(RN,    0x1.235377f0fdb0bp+0,    0x1.b31fc42d61e92p-1,  -0x1.f7ce56p-2, INEXACT)
T(RN,    0x1.22cf89b9cb0eap+0,    0x1.b2acae400ad85p-1,  -0x1.ff2408p-2, INEXACT)
T(RN,    0x1.224bd741a821dp+0,    0x1.b23991b51b9c6p-1,  -0x1.f5f148p-2, INEXACT)
T(RN,    0x1.21c8606d87517p+0,    0x1.b1c66ea37b3aep-1,   0x1.ffa242p-2, INEXACT)
T(RN,    0x1.21452522655cfp+0,    0x1.b153452215a1bp-1,  -0x1.f9470ep-2, INEXACT)
T(RN,    0x1.20c225454c7cbp+0,    0x1.b0e01547de52dp-1,   0x1.f823e4p-2, INEXACT)
T(RN,    0x1.203f60bb52e71p+0,    0x1.b06cdf2bcf06ap-1,  -0x1.f82b3cp-2, INEXACT)
T(RN,    0x1.1fbcd7699ad7cp+0,    0x1.aff9a2e4e7a15p-1,  -0x1.f841ccp-2, INEXACT)
T(RN,    0x1.1f3a893552e17p+0,    0x1.af86608a2e68bp-1,    0x1.faaf1p-2, INEXACT)
T(RN,    0x1.1eb87603b59cep+0,    0x1.af131832afab4p-1,   0x1.ffc92cp-2, INEXACT)
T(RN,    0x1.1e369dba09cf5p+0,    0x1.ae9fc9f57dd0cp-1,   0x1.f6bc36p-2, INEXACT)
T(RN,    0x1.1db5003da252fp+0,    0x1.ae2c75e9b1335p-1,  -0x1.fda182p-2, INEXACT)
T(RN,    0x1.1d339d73de232p+0,    0x1.adb91c266818ep-1,   -0x1.fde47p-2, INEXACT)
T(RN,    0x1.1cb2754228386p+0,    0x1.ad45bcc2c680fp-1,   0x1.ff9e66p-2, INEXACT)
T(RN,    0x1.1c31878df7a28p+0,    0x1.acd257d5f629fp-1,  -0x1.fd439ep-2, INEXACT)
T(RN,    0x1.1bb0d43ccf6e8p+0,    0x1.ac5eed7726689p-1,  -0x1.fcbdaep-2, INEXACT)
T(RN,    0x1.1b305b343ea8cp+0,    0x1.abeb7dbd8c171p-1,  -0x1.f673c6p-2, INEXACT)
T(RN,    0x1.1ab01c59e063cp+0,    0x1.ab7808c06189bp-1,   0x1.fd1718p-2, INEXACT)
T(RN,    0x1.1a3017935b8aep+0,    0x1.ab048e96e6538p-1,  -0x1.f82508p-2, INEXACT)
T(RN,    0x1.19b04cc663144p+0,    0x1.aa910f585f61cp-1,  -0x1.f6d92ap-2, INEXACT)
T(RN,    0x1.1930bbd8b5c98p+0,    0x1.aa1d8b1c16b75p-1,   0x1.fa8e9ep-2, INEXACT)
T(RN,    0x1.18b164b01e6acp+0,    0x1.a9aa01f95b7a1p-1,  -0x1.f87b38p-2, INEXACT)
T(RN,    0x1.183247327387ep+0,    0x1.a936740781be2p-1,    0x1.fa9bap-2, INEXACT)
T(RN,    0x1.17b3634597973p+0,    0x1.a8c2e15de2873p-1,  -0x1.f76624p-2, INEXACT)
T(RN,    0x1.1734b8cf78cf1p+0,    0x1.a84f4a13db943p-1,   0x1.ffd376p-2, INEXACT)
T(RN,    0x1.16b647b611441p+0,    0x1.a7dbae40cf675p-1,  -0x1.fd35f6p-2, INEXACT)
T(RN,    0x1.16380fdf66c87p+0,    0x1.a7680dfc2516ep-1,    0x1.f61c5p-2, INEXACT)
T(RN,    0x1.15ba11318b155p+0,    0x1.a6f4695d485fap-1,   0x1.fdec2ep-2, INEXACT)
T(RN,    0x1.153c4b929b657p+0,     0x1.a680c07ba936p-1,   0x1.fef684p-2, INEXACT)
T(RN,    0x1.14bebee8c0dc4p+0,    0x1.a60d136ebc11bp-1,  -0x1.f6027ep-2, INEXACT)
T(RN,    0x1.14416b1a303c6p+0,    0x1.a599624df997ep-1,   0x1.fa4e78p-2, INEXACT)
T(RN,    0x1.13c4500d29fd3p+0,    0x1.a525ad30de9bbp-1,  -0x1.f77102p-2, INEXACT)
T(RN,    0x1.13476da7fa41bp+0,     0x1.a4b1f42eec04p-1,   0x1.fe1e12p-2, INEXACT)
T(RN,    0x1.12cac3d0f8c4cp+0,    0x1.a43e375fa6a57p-1,   0x1.fd27e2p-2, INEXACT)
T(RN,    0x1.124e526e88f15p+0,    0x1.a3ca76da9746ap-1,  -0x1.ff6b8cp-2, INEXACT)
T(RN,    0x1.11d2196719bacp+0,    0x1.a356b2b74a689p-1,   0x1.f8aa32p-2, INEXACT)
T(RN,    0x1.115618a125b0fp+0,    0x1.a2e2eb0d5045cp-1,  -0x1.fb6768p-2, INEXACT)
T(RN,    0x1.10da500332f45p+0,    0x1.a26f1ff43cb52p-1,   0x1.ff961cp-2, INEXACT)
T(RN,    0x1.105ebf73d3275p+0,    0x1.a1fb5183a7089p-1,   0x1.fb24fcp-2, INEXACT)
T(RN,    0x1.0fe366d9a37c7p+0,    0x1.a1877fd32a07cp-1,   0x1.f5ce26p-2, INEXACT)
T(RN,    0x1.0f68461b4c93dp+0,    0x1.a113aafa63bc9p-1,   0x1.fc6976p-2, INEXACT)
T(RN,    0x1.0eed5d1f829d9p+0,    0x1.a09fd310f5805p-1,  -0x1.f6698ap-2, INEXACT)
T(RN,    0x1.0e72abcd0525bp+0,    0x1.a02bf82e83b7ep-1,  -0x1.fddef8p-2, INEXACT)
T(RN,    0x1.0df8320a9f411p+0,    0x1.9fb81a6ab5eabp-1,   0x1.f6e8fep-2, INEXACT)
T(RN,    0x1.0d7defbf2758cp+0,    0x1.9f4439dd367ddp-1,  -0x1.fe93cep-2, INEXACT)
T(RN,    0x1.0d03e4d17f467p+0,    0x1.9ed0569db2bc4p-1,   0x1.fea87cp-2, INEXACT)
T(RN,    0x1.0c8a1128943f9p+0,    0x1.9e5c70c3daaf1p-1,  -0x1.f7995ap-2, INEXACT)
T(RN,    0x1.0c1074ab5ee73p+0,    0x1.9de88867611c3p-1,   0x1.fd5a04p-2, INEXACT)
T(RN,    0x1.0b970f40e3103p+0,    0x1.9d749d9ffb376p-1,   0x1.f5c4fep-2, INEXACT)
T(RN,     0x1.0b1de0d02ffcp+0,    0x1.9d00b08560cb5p-1,  -0x1.fe8cb4p-2, INEXACT)
T(RN,     0x1.0aa4e9406031p+0,    0x1.9c8cc12f4bfebp-1,   0x1.f5dd88p-2, INEXACT)
T(RN,    0x1.0a2c28789971cp+0,    0x1.9c18cfb57937ep-1,   0x1.ff0494p-2, INEXACT)
T(RN,    0x1.09b39e600cd6ep+0,     0x1.9ba4dc2fa723p-1,  -0x1.f723dap-2, INEXACT)
T(RN,    0x1.093b4addf69b4p+0,    0x1.9b30e6b5966cdp-1,   0x1.fd2d38p-2, INEXACT)
T(RN,    0x1.08c32dd99e463p+0,    0x1.9abcef5f09d75p-1,   0x1.fd322ep-2, INEXACT)
T(RN,    0x1.084b473a56861p+0,    0x1.9a48f643c602fp-1,  -0x1.fd147ap-2, INEXACT)
T(RN,    0x1.07d396e77d34ep+0,    0x1.99d4fb7b915f8p-1,    0x1.fef68p-2, INEXACT)
T(RN,    0x1.075c1cc87b5d5p+0,    0x1.9960ff1e341d1p-1,  -0x1.fad868p-2, INEXACT)
T(RN,    0x1.06e4d8c4c521bp+0,    0x1.98ed014378011p-1,  -0x1.fe0786p-2, INEXACT)
T(RN,    0x1.066dcac3d9d12p+0,    0x1.987902032866cp-1,   -0x1.fe532p-2, INEXACT)
T(RN,    0x1.05f6f2ad43c3ap+0,    0x1.9805017512092p-1,   0x1.f7f836p-2, INEXACT)
T(RN,    0x1.0580506898699p+0,    0x1.9790ffb102fe3p-1,   0x1.f7438cp-2, INEXACT)
T(RN,    0x1.0509e3dd78481p+0,    0x1.971cfccecaa04p-1,  -0x1.ffd314p-2, INEXACT)
T(RN,    0x1.0493acf38eeaap+0,    0x1.96a8f8e6396c6p-1,  -0x1.fbec48p-2, INEXACT)
T(RN,    0x1.041dab9292dd1p+0,    0x1.9634f40f20e89p-1,  -0x1.f7b4f8p-2, INEXACT)
T(RN,    0x1.03a7dfa245abdp+0,    0x1.95c0ee615390cp-1,  -0x1.fd10eap-2, INEXACT)
T(RN,    0x1.0332490a73e7bp+0,    0x1.954ce7f4a4c6fp-1,  -0x1.ffd4ecp-2, INEXACT)
T(RN,    0x1.02bce7b2f50d2p+0,    0x1.94d8e0e0e8a74p-1,  -0x1.f64992p-2, INEXACT)
T(RN,    0x1.0247bb83ab833p+0,    0x1.9464d93df3f35p-1,  -0x1.fbaa68p-2, INEXACT)
T(RN,     0x1.01d2c46484b1p+0,    0x1.93f0d1239c13fp-1,  -0x1.f8fef6p-2, INEXACT)
T(RN,    0x1.015e023d78d99p+0,    0x1.937cc8a9b6e1cp-1,  -0x1.f92e1ap-2, INEXACT)
T(RN,    0x1.00e974f68b13dp+0,    0x1.9308bfe81a89ap-1,  -0x1.f621bcp-2, INEXACT)
T(RN,    0x1.00751c77c96d2p+0,    0x1.9294b6f69d9b7p-1,  -0x1.f5de62p-2, INEXACT)
T(RN,    0x1.0000f8a945e4fp+0,    0x1.9220aded0ff26p-1,  -0x1.f5c33ap-2, INEXACT)
T(RN,    0x1.ff1a12e671797p-1,    0x1.91aca4e35cf13p-1,   0x1.f5d2b6p-2, INEXACT)
T(RN,    0x1.fe329d7b779cdp-1,     0x1.91389bf146c5p-1,   0x1.f67ea6p-2, INEXACT)
T(RN,    0x1.fd4b90e21e8bcp-1,    0x1.90c4932eab0b6p-1,   0x1.f6e3bap-2, INEXACT)
T(RN,    0x1.fc64eceaee3e9p-1,    0x1.90508ab3603cdp-1,   0x1.fc84bcp-2, INEXACT)
T(RN,    0x1.fb7eb166845a2p-1,    0x1.8fdc82973c9f6p-1,    0x1.fe0eep-2, INEXACT)
T(RN,    0x1.fa98de2593dacp-1,    0x1.8f687af216085p-1,   0x1.fafb9cp-2, INEXACT)
T(RN,    0x1.f9b372f8e5386p-1,    0x1.8ef473dbc1dabp-1,   0x1.f78cf6p-2, INEXACT)
T(RN,    0x1.f8ce6fb156411p-1,    0x1.8e806d6c14e0ep-1,   0x1.fd59cep-2, INEXACT)
T(RN,    0x1.f7e9d41fda223p-1,    0x1.8e0c67bae33dap-1,   0x1.f9444ap-2, INEXACT)
T(RN,    0x1.f705a0157957cp-1,    0x1.8d9862e000501p-1,   0x1.f89232p-2, INEXACT)
T(RN,    0x1.f621d363519d2p-1,    0x1.8d245ef33e986p-1,   0x1.f80be6p-2, INEXACT)
T(RN,    0x1.f53e6dda95f1dp-1,    0x1.8cb05c0c6fa6ap-1,  -0x1.f6d366p-2, INEXACT)
T(RN,    0x1.f45b6f4c8e7fap-1,    0x1.8c3c5a4363fa5p-1,  -0x1.f80ff4p-2, INEXACT)
T(RN,     0x1.f378d78a9896p-1,    0x1.8bc859afeaec2p-1,   0x1.f9b304p-2, INEXACT)
T(RN,    0x1.f296a66626b42p-1,    0x1.8b545a69d29f9p-1,  -0x1.fc2eeep-2, INEXACT)
T(RN,    0x1.f1b4dbb0c054ap-1,    0x1.8ae05c88e7d53p-1,  -0x1.f92c86p-2, INEXACT)
T(RN,    0x1.f0d3773c02185p-1,    0x1.8a6c6024f5ec8p-1,   0x1.fa2f94p-2, INEXACT)
T(RN,    0x1.eff278d99d891p-1,    0x1.89f86555c6b11p-1,  -0x1.f83d36p-2, INEXACT)
T(RN,    0x1.ef11e05b593f1p-1,    0x1.89846c33225adp-1,    0x1.f6eaap-2, INEXACT)
T(RN,    0x1.ee31ad9310ac3p-1,    0x1.891074d4cf5e9p-1,  -0x1.fd0492p-2, INEXACT)
T(RN,    0x1.ed51e052b43b6p-1,    0x1.889c7f52926bcp-1,   0x1.f68ceap-2, INEXACT)
T(RN,     0x1.ec72786c4926p-1,    0x1.88288bc42e421p-1,   0x1.fcb6b6p-2, INEXACT)
T(RN,    0x1.eb9375b1e980ap-1,    0x1.87b49a4163a55p-1,   0x1.f9630cp-2, INEXACT)
T(RN,    0x1.eab4d7f5c421fp-1,    0x1.8740aae1f13cbp-1,  -0x1.fa931ep-2, INEXACT)
T(RN,    0x1.e9d69f0a1ca43p-1,    0x1.86ccbdbd93808p-1,   0x1.f86856p-2, INEXACT)
T(RN,     0x1.e8f8cac14b58p-1,    0x1.8658d2ec049f6p-1,   0x1.f98fbep-2, INEXACT)
T(RN,    0x1.e81b5aedbd359p-1,    0x1.85e4ea84fc63dp-1,   0x1.f6c358p-2, INEXACT)
T(RN,    0x1.e73e4f61f3ed6p-1,    0x1.857104a030295p-1,  -0x1.febf2cp-2, INEXACT)
T(RN,    0x1.e661a7f085a91p-1,    0x1.84fd215552a85p-1,  -0x1.fcd738p-2, INEXACT)
T(RN,    0x1.e585646c1d2f9p-1,    0x1.848940bc13f59p-1,   0x1.f60896p-2, INEXACT)
T(RN,    0x1.e4a984a779eb7p-1,    0x1.841562ec21725p-1,   0x1.f74168p-2, INEXACT)
T(RN,    0x1.e3ce08756f98cp-1,    0x1.83a187fd258e2p-1,  -0x1.f7a2ccp-2, INEXACT)
T(RN,    0x1.e2f2efa8e6821p-1,    0x1.832db006c7d3dp-1,  -0x1.f61ed6p-2, INEXACT)
T(RN,    0x1.e2183a14db635p-1,    0x1.82b9db20acc6cp-1,   0x1.fa695ep-2, INEXACT)
T(RN,    0x1.e13de78c5f477p-1,    0x1.8246096275bd9p-1,   0x1.ffa0b2p-2, INEXACT)
T(RN,    0x1.e063f7e2979bdp-1,    0x1.81d23ae3c0d9ap-1,   0x1.f639dcp-2, INEXACT)
T(RN,    0x1.df8a6aeabe204p-1,    0x1.815e6fbc28eb4p-1,  -0x1.fcfb44p-2, INEXACT)
T(RN,    0x1.deb1407820dabp-1,    0x1.80eaa80345587p-1,  -0x1.ff454cp-2, INEXACT)
T(RN,    0x1.ddd8785e220b1p-1,    0x1.8076e3d0aa031p-1,  -0x1.ff9824p-2, INEXACT)
T(RN,    0x1.dd00127038249p-1,    0x1.8003233be7329p-1,  -0x1.fffa9ap-2, INEXACT)
T(RN,    0x1.dc280e81edd45p-1,    0x1.7f8f665c8984ap-1,   0x1.f9ac54p-2, INEXACT)
T(RN,    0x1.db506c66e1d36p-1,    0x1.7f1bad4a19c17p-1,   0x1.f9bc3ep-2, INEXACT)
T(RN,    0x1.da792bf2c705ap-1,    0x1.7ea7f81c1cd9cp-1,   0x1.fbe71ap-2, INEXACT)
T(RN,    0x1.d9a24cf9644adp-1,    0x1.7e3446ea13baap-1,   0x1.f6cfeap-2, INEXACT)
T(RN,    0x1.d8cbcf4e94b17p-1,    0x1.7dc099cb7b562p-1,   0x1.f8e50cp-2, INEXACT)
T(RN,    0x1.d7f5b2c6470fdp-1,    0x1.7d4cf0d7cc592p-1,   0x1.f7e7a6p-2, INEXACT)
T(RN,    0x1.d71ff7347e62ep-1,    0x1.7cd94c267b4bbp-1,  -0x1.fa19cep-2, INEXACT)
T(RN,    0x1.d64a9c6d516a2p-1,    0x1.7c65abcef848bp-1,   0x1.fcd734p-2, INEXACT)
T(RN,     0x1.d575a244eae6p-1,    0x1.7bf20fe8af0c4p-1,  -0x1.ffb8fap-2, INEXACT)
T(RN,    0x1.d4a1088f895f9p-1,    0x1.7b7e788b06c39p-1,  -0x1.fd7f34p-2, INEXACT)
T(RN,    0x1.d3cccf217f35fp-1,    0x1.7b0ae5cd6200fp-1,  -0x1.f601bep-2, INEXACT)
T(RN,    0x1.d2f8f5cf3294dp-1,    0x1.7a9757c71ea49p-1,   0x1.fa55c6p-2, INEXACT)
T(RN,     0x1.d2257c6d1d68p-1,     0x1.7a23ce8f95c3p-1,   0x1.fbaaa6p-2, INEXACT)
T(RN,    0x1.d15262cfcd3d3p-1,    0x1.79b04a3e1b82ap-1,   0x1.f90cfcp-2, INEXACT)
T(RN,    0x1.d07fa8cbe35e5p-1,    0x1.793ccae9ff177p-1,   0x1.f696e4p-2, INEXACT)
T(RN,    0x1.cfad4e3614c74p-1,    0x1.78c950aa8aab3p-1,  -0x1.ff482cp-2, INEXACT)
T(RN,    0x1.cedb52e329f1ep-1,    0x1.7855db97032efp-1,   0x1.f771c4p-2, INEXACT)
T(RN,    0x1.ce09b6a7fef8ap-1,    0x1.77e26bc6a85b3p-1,   0x1.fe72cep-2, INEXACT)
T(RN,    0x1.cd38795983855p-1,    0x1.776f0150b494fp-1,   0x1.f7f3bap-2, INEXACT)
T(RN,    0x1.cc679accbab5ap-1,    0x1.76fb9c4c5ccc2p-1,    0x1.fd875p-2, INEXACT)
T(RN,    0x1.cb971ad6bb2bep-1,    0x1.76883cd0d072dp-1,  -0x1.fd0e5cp-2, INEXACT)
T(RN,    0x1.cac6f94caee97p-1,    0x1.7614e2f53956bp-1,  -0x1.f6a976p-2, INEXACT)
T(RN,    0x1.c9f73603d358cp-1,    0x1.75a18ed0bb944p-1,  -0x1.f5d2a8p-2, INEXACT)
T(RN,    0x1.c927d0d17977ap-1,    0x1.752e407a759cdp-1,    0x1.f82aep-2, INEXACT)
T(RN,    0x1.c858c98b052d4p-1,    0x1.74baf8097fc5ep-1,   0x1.f92ca4p-2, INEXACT)
T(RN,    0x1.c78a2005ee012p-1,    0x1.7447b594ec9d5p-1,  -0x1.f760bep-2, INEXACT)
T(RN,     0x1.c6bbd417be9fp-1,    0x1.73d47933c892bp-1,  -0x1.fd164ep-2, INEXACT)
T(RN,    0x1.c5ede59614f7ap-1,    0x1.736142fd19f78p-1,  -0x1.f68b58p-2, INEXACT)
T(RN,    0x1.c5205456a223cp-1,    0x1.72ee1307e0ddbp-1,   0x1.fa23e8p-2, INEXACT)
T(RN,    0x1.c453202f2a68bp-1,    0x1.727ae96b17084p-1,  -0x1.f8747ep-2, INEXACT)
T(RN,    0x1.c38648f584c8dp-1,    0x1.7207c63daf9bcp-1,   0x1.f5edb2p-2, INEXACT)
T(RN,    0x1.c2b9ce7f9cf44p-1,    0x1.7194a99698236p-1,  -0x1.fe027ep-2, INEXACT)
T(RN,    0x1.c1edb0a36f484p-1,    0x1.7121938cb6402p-1,   -0x1.fb7b3p-2, INEXACT)
T(RN,    0x1.c121ef370cb88p-1,    0x1.70ae8436e9ca2p-1,   0x1.fbfa0cp-2, INEXACT)
T(RN,    0x1.c0568a1098d3dp-1,    0x1.703b7bac0ba21p-1,   0x1.f7dcdcp-2, INEXACT)
T(RN,    0x1.bf8b81064a273p-1,     0x1.6fc87a02edd8p-1,   -0x1.f7dc5p-2, INEXACT)
T(RN,     0x1.bec0d3ee6a1ep-1,    0x1.6f557f525b885p-1,   0x1.fcb9e4p-2, INEXACT)
T(RN,    0x1.bdf6829f5512cp-1,    0x1.6ee28bb118d38p-1,   -0x1.fda21p-2, INEXACT)
T(RN,    0x1.bd2c8cef7a32ap-1,    0x1.6e6f9f35e2bdfp-1,  -0x1.f91de8p-2, INEXACT)
T(RN,    0x1.bc62f2b55b866p-1,    0x1.6dfcb9f76f235p-1,  -0x1.fc94cap-2, INEXACT)
T(RN,    0x1.bb99b3c78db83p-1,    0x1.6d89dc0c6c84fp-1,   -0x1.f7159p-2, INEXACT)
T(RN,    0x1.bad0cffcb8b1bp-1,    0x1.6d17058b82533p-1,   0x1.f70c4cp-2, INEXACT)
T(RN,    0x1.ba08472b9679dp-1,    0x1.6ca4368b5036ep-1,   0x1.fbc0ecp-2, INEXACT)
T(RN,    0x1.b940192af4089p-1,    0x1.6c316f226e79cp-1,  -0x1.ffe3d6p-2, INEXACT)
T(RN,    0x1.b87845d1b1109p-1,    0x1.6bbeaf676dd6fp-1,  -0x1.f66a9ep-2, INEXACT)
T(RN,    0x1.b7b0ccf6bfd2fp-1,    0x1.6b4bf770d750dp-1,  -0x1.fb19a4p-2, INEXACT)
T(RN,    0x1.b6e9ae712528ap-1,    0x1.6ad947552c262p-1,  -0x1.f94bcap-2, INEXACT)
T(RN,     0x1.b622ea17f87ap-1,    0x1.6a669f2ae5bcdp-1,   0x1.ff9a0ep-2, INEXACT)
T(RN,    0x1.b55c7fc263b4cp-1,    0x1.69f3ff08758b9p-1,  -0x1.fea044p-2, INEXACT)
T(RN,    0x1.b4966f47a34f6p-1,    0x1.69816704450c5p-1,   0x1.fbd924p-2, INEXACT)
T(RN,    0x1.b3d0b87f06244p-1,    0x1.690ed734b595ep-1,   0x1.f6272cp-2, INEXACT)
T(RN,    0x1.b30b5b3fed89cp-1,    0x1.689c4fb0205a8p-1,    0x1.f7091p-2, INEXACT)
T(RN,    0x1.b2465761cd361p-1,    0x1.6829d08cd6474p-1,   0x1.f8ff6cp-2, INEXACT)
T(RN,    0x1.b181acbc2b3a2p-1,    0x1.67b759e11ff12p-1,  -0x1.fa4c22p-2, INEXACT)
T(RN,    0x1.b0bd5b269fbe1p-1,    0x1.6744ebc33d5e1p-1,  -0x1.f5ff12p-2, INEXACT)
T(RN,    0x1.aff96278d63b7p-1,    0x1.66d2864966ac3p-1,   0x1.f7d8dap-2, INEXACT)
T(RN,    0x1.af35c28a8ae67p-1,    0x1.66602989ca7f8p-1,   0x1.f7eb96p-2, INEXACT)
T(RN,    0x1.ae727b338d2fdp-1,    0x1.65edd59a8f68fp-1,  -0x1.f94968p-2, INEXACT)
T(RN,    0x1.adaf8c4bbe817p-1,    0x1.657b8a91d31a3p-1,  -0x1.ff3f8ep-2, INEXACT)
T(RN,    0x1.acecf5ab12725p-1,    0x1.65094885aa744p-1,  -0x1.f97142p-2, INEXACT)
T(RN,    0x1.ac2ab7298eaf6p-1,    0x1.64970f8c216abp-1,  -0x1.fe60a4p-2, INEXACT)
T(RN,    0x1.ab68d09f4b0abp-1,    0x1.6424dfbb3afd4p-1,   0x1.fadb2ap-2, INEXACT)
T(RN,    0x1.aaa741e4716c2p-1,    0x1.63b2b928f11f7p-1,   0x1.fe1ffep-2, INEXACT)
T(RN,    0x1.a9e60ad13db86p-1,     0x1.63409beb349bp-1,     0x1.f6cfp-2, INEXACT)
T(RN,    0x1.a9252b3dfde74p-1,    0x1.62ce8817ed0ddp-1,   0x1.f9d87ap-2, INEXACT)
T(RN,    0x1.a864a30311d4ep-1,    0x1.625c7dc4f8bf5p-1,   0x1.f5cfbap-2, INEXACT)
T(RN,    0x1.a7a471f8eb6eep-1,    0x1.61ea7d082cac5p-1,  -0x1.f8d4ccp-2, INEXACT)
T(RN,    0x1.a6e497f80e6c8p-1,    0x1.617885f7544dfp-1,   0x1.fb0778p-2, INEXACT)
T(RN,    0x1.a62514d91075bp-1,    0x1.610698a831a16p-1,  -0x1.f80ad2p-2, INEXACT)
T(RN,    0x1.a565e874990b4p-1,    0x1.6094b5307d0c1p-1,   0x1.f6245ap-2, INEXACT)
T(RN,     0x1.a4a712a3617cp-1,    0x1.6022dba5e545bp-1,  -0x1.fbb69cp-2, INEXACT)
T(RN,    0x1.a3e8933e34e5fp-1,    0x1.5fb10c1e0f4b6p-1,  -0x1.f703ecp-2, INEXACT)
T(RN,    0x1.a32a6a1df0248p-1,    0x1.5f3f46ae96461p-1,  -0x1.f7a46ap-2, INEXACT)
T(RN,    0x1.a26c971b81cfep-1,    0x1.5ecd8b6d0b7c2p-1,   -0x1.f7c7cp-2, INEXACT)
T(RN,    0x1.a1af1a0fea291p-1,    0x1.5e5bda6ef6374p-1,   0x1.f7733ap-2, INEXACT)
T(RN,    0x1.a0f1f2d43b217p-1,    0x1.5dea33c9d3baap-1,   0x1.f89e3ap-2, INEXACT)
T(RN,      0x1.a0352141985p-1,    0x1.5d789793172eep-1,   0x1.f6b7f2p-2, INEXACT)
T(RN,    0x1.9f78a53136dbdp-1,    0x1.5d0705e02986ep-1,  -0x1.f77c54p-2, INEXACT)
T(RN,    0x1.9ebc7e7c5d766p-1,    0x1.5c957ec6696eep-1,   0x1.fc361ap-2, INEXACT)
T(RN,    0x1.9e00acfc645b3p-1,    0x1.5c24025b2b3dep-1,   0x1.f5f0c2p-2, INEXACT)
T(RN,    0x1.9d45308ab58dbp-1,    0x1.5bb290b3b90e2p-1,   0x1.feebfap-2, INEXACT)
T(RN,     0x1.9c8a0900cc0cp-1,    0x1.5b4129e552332p-1,   0x1.f62f06p-2, INEXACT)
T(RN,    0x1.9bcf3638349ccp-1,    0x1.5acfce052ba8ap-1,  -0x1.fa16d4p-2, INEXACT)
T(RN,    0x1.9b14b80a8d58fp-1,    0x1.5a5e7d286fbe1p-1,  -0x1.fdd792p-2, INEXACT)
T(RN,    0x1.9a5a8e5185c45p-1,    0x1.59ed37643e17cp-1,   0x1.f7b22ap-2, INEXACT)
T(RN,    0x1.99a0b8e6deb0ep-1,    0x1.597bfccdab906p-1,   0x1.f71bfcp-2, INEXACT)
T(RN,    0x1.98e737a46a486p-1,    0x1.590acd79c231fp-1,  -0x1.fd292cp-2, INEXACT)
T(RN,    0x1.982e0a640bf5fp-1,    0x1.5899a97d811b3p-1,   0x1.f7abc2p-2, INEXACT)
T(RN,    0x1.977530ffb883dp-1,    0x1.582890eddc846p-1,   0x1.fc29fcp-2, INEXACT)
T(RN,    0x1.96bcab5175cc2p-1,    0x1.57b783dfbd82ap-1,   0x1.fa1242p-2, INEXACT)
T(RN,    0x1.960479335afd4p-1,    0x1.574682680224cp-1,   0x1.f9f24cp-2, INEXACT)
T(RN,    0x1.954c9a7f905abp-1,      0x1.56d58c9b7d4p-1,  -0x1.fce7d4p-2, INEXACT)
T(RN,    0x1.94950f104f561p-1,    0x1.5664a28ef6733p-1,   0x1.f8acc4p-2, INEXACT)
T(RN,    0x1.93ddd6bfe29a5p-1,    0x1.55f3c4572a20ap-1,   0x1.fc9e0ap-2, INEXACT)
T(RN,    0x1.9326f168a5a1cp-1,    0x1.5582f208c9213p-1,   0x1.fd17b6p-2, INEXACT)
T(RN,    0x1.92705ee50522dp-1,    0x1.55122bb878facp-1,   0x1.f7ff2ep-2, INEXACT)
T(RN,    0x1.91ba1f0f7ed01p-1,    0x1.54a1717ad3acbp-1,  -0x1.fb14dcp-2, INEXACT)
T(RN,    0x1.910431c2a1572p-1,    0x1.5430c36467a38p-1,   0x1.f913c8p-2, INEXACT)
T(RN,    0x1.904e96d90c56fp-1,    0x1.53c02189b7a64p-1,   0x1.fa7f94p-2, INEXACT)
T(RN,    0x1.8f994e2d705dfp-1,    0x1.534f8bff3aca3p-1,  -0x1.fda53ep-2, INEXACT)
T(RN,    0x1.8ee4579a8ee2dp-1,    0x1.52df02d95c629p-1,   0x1.ffd896p-2, INEXACT)
T(RN,    0x1.8e2fb2fb3a36ep-1,    0x1.526e862c7bebfp-1,  -0x1.fe8aaap-2, INEXACT)
T(RN,    0x1.8d7b602a557dcp-1,    0x1.51fe160cecfc6p-1,  -0x1.f8056ep-2, INEXACT)
T(RN,    0x1.8cc75f02d4ac5p-1,    0x1.518db28ef736bp-1,   -0x1.f69fdp-2, INEXACT)
T(RN,    0x1.8c13af5fbc9a8p-1,    0x1.511d5bc6d64abp-1,   0x1.f7d6bep-2, INEXACT)
T(RN,    0x1.8b60511c22a3ap-1,    0x1.50ad11c8b9adep-1,   0x1.f9977ep-2, INEXACT)
T(RN,    0x1.8aad44132d0afp-1,    0x1.503cd4a8c4cf9p-1,   0x1.fa56dap-2, INEXACT)
T(RN,    0x1.89fa882012b02p-1,    0x1.4fcca47b0ede7p-1,   0x1.fc465ep-2, INEXACT)
T(RN,    0x1.89481d1e1b2a9p-1,    0x1.4f5c8153a2cedp-1,   0x1.f86ea6p-2, INEXACT)
T(RN,    0x1.889602e89ea0fp-1,    0x1.4eec6b467f368p-1,   0x1.f8fa68p-2, INEXACT)
T(RN,    0x1.87e4395b05dccp-1,    0x1.4e7c6267964e6p-1,   0x1.f72372p-2, INEXACT)
T(RN,     0x1.8732c050ca3ap-1,    0x1.4e0c66cacddd8p-1,   -0x1.ff5fbp-2, INEXACT)
T(RN,    0x1.868197a5759bfp-1,    0x1.4d9c7883ff27ep-1,   0x1.fa0548p-2, INEXACT)
T(RN,    0x1.85d0bf34a26bfp-1,    0x1.4d2c97a6f6e2cp-1,   0x1.fe5616p-2, INEXACT)
T(RN,    0x1.852036d9fb8aep-1,    0x1.4cbcc4477521bp-1,  -0x1.fbed78p-2, INEXACT)
T(RN,    0x1.846ffe713c55bp-1,    0x1.4c4cfe792d4f5p-1,   0x1.f852c8p-2, INEXACT)
T(RN,    0x1.83c015d6308c6p-1,    0x1.4bdd464fc612dp-1,  -0x1.f9da7cp-2, INEXACT)
T(RN,    0x1.83107ce4b45ccp-1,    0x1.4b6d9bded94dbp-1,  -0x1.f5f11ap-2, INEXACT)
T(RN,    0x1.82613378b447bp-1,    0x1.4afdff39f4005p-1,   0x1.fe5134p-2, INEXACT)
T(RN,    0x1.81b2396e2d34dp-1,    0x1.4a8e7074964cdp-1,   0x1.f871b6p-2, INEXACT)
T(RN,    0x1.81038ea12c449p-1,    0x1.4a1eefa233507p-1,  -0x1.f6bab2p-2, INEXACT)
T(RN,    0x1.805532edcef5fp-1,    0x1.49af7cd631323p-1,   0x1.ffd722p-2, INEXACT)
T(RN,    0x1.7fa7263042f6ap-1,    0x1.49401823e8fa5p-1,    0x1.f845fp-2, INEXACT)
T(RN,    0x1.7ef96844c6388p-1,    0x1.48d0c19ea6976p-1,   0x1.ff420ap-2, INEXACT)
T(RN,    0x1.7e4bf907a6d88p-1,    0x1.48617959a8c4bp-1,   0x1.f99a4cp-2, INEXACT)
T(RN,    0x1.7d9ed85542fb1p-1,    0x1.47f23f6820ea7p-1,   0x1.f5c32cp-2, INEXACT)
T(RN,    0x1.7cf2060a097bap-1,    0x1.478313dd33859p-1,   0x1.fac1fep-2, INEXACT)
T(RN,    0x1.7c4582027870fp-1,    0x1.4713f6cbf72acp-1,  -0x1.fdfff6p-2, INEXACT)
T(RN,    0x1.7b994c1b1ea1ep-1,    0x1.46a4e847756dap-1,  -0x1.fe1078p-2, INEXACT)
T(RN,    0x1.7aed64309aaf7p-1,    0x1.4635e862aa4e2p-1,  -0x1.fb72dep-2, INEXACT)
T(RN,    0x1.7a41ca1f9b508p-1,    0x1.45c6f7308456bp-1,  -0x1.fab9f2p-2, INEXACT)
T(RN,    0x1.79967dc4df2b7p-1,    0x1.455814c3e47b1p-1,   0x1.fe043ep-2, INEXACT)
T(RN,    0x1.78eb7efd34e7dp-1,    0x1.44e9412f9e1b2p-1,   -0x1.fcea3p-2, INEXACT)
T(RN,    0x1.7840cda57b17ep-1,    0x1.447a7c8676eccp-1,  -0x1.f66e4cp-2, INEXACT)
T(RN,    0x1.7796699aa0321p-1,    0x1.440bc6db26eefp-1,   0x1.f5fa44p-2, INEXACT)
T(RN,    0x1.76ec52b9a2b43p-1,    0x1.439d20405878dp-1,   0x1.fee90ap-2, INEXACT)
T(RN,    0x1.764288df90b2bp-1,    0x1.432e88c8a7e8bp-1,  -0x1.f9e732p-2, INEXACT)
T(RN,    0x1.75990be9884a5p-1,    0x1.42c00086a3e65p-1,    0x1.f790fp-2, INEXACT)
T(RN,    0x1.74efdbb4b74fap-1,    0x1.4251878ccd264p-1,  -0x1.f6c888p-2, INEXACT)
T(RN,    0x1.7446f81e5b5fbp-1,    0x1.41e31ded966e2p-1,    0x1.f6956p-2, INEXACT)
T(RN,     0x1.739e6103c1ddp-1,    0x1.4174c3bb648a5p-1,    0x1.fca56p-2, INEXACT)
T(RN,    0x1.72f6164247cf2p-1,    0x1.410679088e321p-1,  -0x1.fdd70ap-2, INEXACT)
T(RN,    0x1.724e17b759fe9p-1,    0x1.40983de75c128p-1,  -0x1.fa7b6ep-2, INEXACT)
T(RN,    0x1.71a6654074cf3p-1,    0x1.402a126a08aeap-1,  -0x1.fc9676p-2, INEXACT)
T(RN,    0x1.70fefebb244c2p-1,    0x1.3fbbf6a2c0607p-1,   0x1.ff5fc6p-2, INEXACT)
T(RN,    0x1.7057e405041f2p-1,    0x1.3f4deaa3a14c2p-1,   0x1.f6d6a8p-2, INEXACT)
T(RN,    0x1.6fb114fbbf7e8p-1,    0x1.3edfee7ebb4ddp-1,   0x1.f80af6p-2, INEXACT)
T(RN,    0x1.6f0a917d112dap-1,    0x1.3e7202460ff2fp-1,  -0x1.f8a286p-2, INEXACT)
T(RN,     0x1.6e645966c375p-1,    0x1.3e04260b926eep-1,   0x1.fe35bcp-2, INEXACT)
T(RN,    0x1.6dbe6c96b01c2p-1,    0x1.3d9659e1278fdp-1,  -0x1.f6a808p-2, INEXACT)
T(RN,    0x1.6d18caeac0661p-1,    0x1.3d289dd8a5b71p-1,  -0x1.fe5b12p-2, INEXACT)
T(RN,    0x1.6c737440ecf82p-1,    0x1.3cbaf203d4c17p-1,  -0x1.fb1f98p-2, INEXACT)
T(RN,    0x1.6bce68773df28p-1,    0x1.3c4d56746e11dp-1,   -0x1.fc01ep-2, INEXACT)
T(RN,    0x1.6b29a76bcaca9p-1,    0x1.3bdfcb3c1c722p-1,  -0x1.f8ffdcp-2, INEXACT)
T(RN,    0x1.6a8530fcba43cp-1,    0x1.3b72506c7c08cp-1,  -0x1.f706b2p-2, INEXACT)
T(RN,    0x1.69e1050842ba6p-1,    0x1.3b04e6171a84bp-1,   0x1.f640eep-2, INEXACT)
T(RN,    0x1.693d236ca971ep-1,    0x1.3a978c4d76a15p-1,   0x1.f7c06ap-2, INEXACT)
T(RN,    0x1.68998c084345cp-1,    0x1.3a2a432100972p-1,    0x1.f918cp-2, INEXACT)
T(RN,    0x1.67f63eb974191p-1,    0x1.39bd0aa319b5cp-1,   0x1.fde7f2p-2, INEXACT)
T(RN,    0x1.67533b5eaf227p-1,    0x1.394fe2e514917p-1,   0x1.f8dc54p-2, INEXACT)
T(RN,    0x1.66b081d676d74p-1,    0x1.38e2cbf834f01p-1,   0x1.f74c48p-2, INEXACT)
T(RN,    0x1.660e11ff5cbe3p-1,    0x1.3875c5edafa5ap-1,   0x1.ff94fap-2, INEXACT)
T(RN,    0x1.656bebb801892p-1,    0x1.3808d0d6aaa09p-1,  -0x1.fa6048p-2, INEXACT)
T(RN,    0x1.64ca0edf150cap-1,    0x1.379becc43cdf8p-1,  -0x1.f82ba2p-2, INEXACT)
T(RN,    0x1.64287b53562fbp-1,    0x1.372f19c76e614p-1,  -0x1.f7b462p-2, INEXACT)
T(RN,    0x1.638730f392e86p-1,    0x1.36c257f1381e3p-1,   -0x1.fee54p-2, INEXACT)
T(RN,    0x1.62e62f9ea8312p-1,    0x1.3655a75283fc8p-1,  -0x1.f7e064p-2, INEXACT)
T(RN,    0x1.62457733820f8p-1,    0x1.35e907fc2cd06p-1,  -0x1.f8ee58p-2, INEXACT)
T(RN,    0x1.61a507911b7d8p-1,    0x1.357c79fefe487p-1,   -0x1.fe431p-2, INEXACT)
T(RN,    0x1.6104e0967e6aap-1,    0x1.350ffd6bb4ea6p-1,   0x1.f7bd78p-2, INEXACT)
T(RN,    0x1.60650222c3b25p-1,    0x1.34a39252fe083p-1,   0x1.f7a18ap-2, INEXACT)
T(RN,    0x1.5fc56c1513185p-1,    0x1.343738c577ba3p-1,   0x1.fd8004p-2, INEXACT)
T(RN,    0x1.5f261e4ca3328p-1,    0x1.33caf0d3b0cbep-1,   0x1.f5f006p-2, INEXACT)
T(RN,    0x1.5e8718a8b99dap-1,    0x1.335eba8e28dc3p-1,   0x1.fcb46ep-2, INEXACT)
T(RN,    0x1.5de85b08aa89dp-1,    0x1.32f29605500b5p-1,  -0x1.f8895ap-2, INEXACT)
T(RN,     0x1.5d49e54bd919p-1,    0x1.328683498737cp-1,   0x1.ff7842p-2, INEXACT)
T(RN,    0x1.5cabb751b728ep-1,    0x1.321a826b1fd58p-1,  -0x1.fd453ap-2, INEXACT)
T(RN,    0x1.5c0dd0f9c55b5p-1,    0x1.31ae937a5bf18p-1,   0x1.fc61d8p-2, INEXACT)
T(RN,    0x1.5b7032239300bp-1,    0x1.3142b6876e1ebp-1,  -0x1.f81d6ep-2, INEXACT)
T(RN,    0x1.5ad2daaebe1a5p-1,    0x1.30d6eba279759p-1,  -0x1.fc282ap-2, INEXACT)
T(RN,    0x1.5a35ca7af3649p-1,    0x1.306b32db9197ap-1,   0x1.fcc132p-2, INEXACT)
T(RN,    0x1.59990167ee211p-1,    0x1.2fff8c42ba87bp-1,  -0x1.fda56cp-2, INEXACT)
T(RN,    0x1.58fc7f55784adp-1,    0x1.2f93f7e7e8cb9p-1,    0x1.f8decp-2, INEXACT)
T(RN,    0x1.586044236a704p-1,    0x1.2f2875db014eap-1,   0x1.ff17d4p-2, INEXACT)
T(RN,    0x1.57c44fb1ab97dp-1,    0x1.2ebd062bd94d2p-1,   0x1.f65356p-2, INEXACT)
T(RN,    0x1.5728a1e03160ep-1,    0x1.2e51a8ea36683p-1,   0x1.ff3d34p-2, INEXACT)
T(RN,    0x1.568d3a8efff98p-1,    0x1.2de65e25ce9cap-1,   0x1.f87724p-2, INEXACT)
T(RN,    0x1.55f2199e29f45p-1,    0x1.2d7b25ee4823bp-1,   -0x1.fdf44p-2, INEXACT)
T(RN,    0x1.55573eedcefe2p-1,    0x1.2d100053388c8p-1,  -0x1.f5df26p-2, INEXACT)
T(RN,    0x1.54bcaa5e22d5dp-1,    0x1.2ca4ed64298cep-1,   0x1.fd6674p-2, INEXACT)
T(RN,    0x1.54225bcf5f2d8p-1,     0x1.2c39ed308f39p-1,   0x1.ffcd6ep-2, INEXACT)
T(RN,    0x1.53885321d1b3ep-1,    0x1.2bceffc7d1b9ap-1,  -0x1.feea48p-2, INEXACT)
T(RN,    0x1.52ee9035d5114p-1,    0x1.2b642539486fep-1,  -0x1.f66652p-2, INEXACT)
T(RN,    0x1.525512ebd246bp-1,    0x1.2af95d943ae6ap-1,   0x1.fd446ep-2, INEXACT)
T(RN,     0x1.51bbdb24409ap-1,    0x1.2a8ea8e7e0c34p-1,   0x1.fd8de8p-2, INEXACT)
T(RN,    0x1.5122e8bfa59e6p-1,    0x1.2a24074361caap-1,  -0x1.fa5e44p-2, INEXACT)
T(RN,    0x1.508a3b9e952a2p-1,    0x1.29b978b5d5d8ep-1,  -0x1.fe95b8p-2, INEXACT)
T(RN,    0x1.4ff1d3a1b1486p-1,    0x1.294efd4e44d61p-1,  -0x1.fb926cp-2, INEXACT)
T(RN,    0x1.4f59b0a9aa2a2p-1,    0x1.28e4951ba6ab1p-1,  -0x1.f67ed2p-2, INEXACT)
T(RN,    0x1.4ec1d2973e7c9p-1,    0x1.287a402ce37d3p-1,   0x1.f76082p-2, INEXACT)
T(RN,    0x1.4e2a394b3a9acp-1,    0x1.280ffe90d31cdp-1,  -0x1.ff9ccap-2, INEXACT)
T(RN,    0x1.4d92e4a679535p-1,    0x1.27a5d0563d8fdp-1,   0x1.f7d59ap-2, INEXACT)
T(RN,    0x1.4cfbd489e37b4p-1,    0x1.273bb58bdac3cp-1,  -0x1.fda136p-2, INEXACT)
T(RN,    0x1.4c6508d66ffb7p-1,    0x1.26d1ae405297ep-1,  -0x1.f6a49cp-2, INEXACT)
T(RN,    0x1.4bce816d23cb6p-1,    0x1.2667ba823cd89p-1,   0x1.f9080ap-2, INEXACT)
T(RN,    0x1.4b383e2f11e66p-1,    0x1.25fdda6021379p-1,  -0x1.f90eeap-2, INEXACT)
T(RN,    0x1.4aa23efd5b501p-1,    0x1.25940de8774fbp-1,  -0x1.f85feep-2, INEXACT)
T(RN,    0x1.4a0c83b92f046p-1,    0x1.252a5529a6991p-1,    0x1.f621ep-2, INEXACT)
T(RN,     0x1.49770c43c9efp-1,    0x1.24c0b03206634p-1,  -0x1.fb35a4p-2, INEXACT)
T(RN,    0x1.48e1d87e76f28p-1,    0x1.24571f0fdddb2p-1,  -0x1.ff8392p-2, INEXACT)
T(RN,    0x1.484ce84a8ed6cp-1,    0x1.23eda1d163fe4p-1,  -0x1.f9943cp-2, INEXACT)
T(RN,    0x1.47b83b89783a8p-1,    0x1.23843884bf918p-1,   0x1.fc4772p-2, INEXACT)
T(RN,    0x1.4723d21ca7a52p-1,    0x1.231ae338072dfp-1,   0x1.fc53cep-2, INEXACT)
T(RN,    0x1.468fabe59f711p-1,    0x1.22b1a1f94132ap-1,    0x1.f747ap-2, INEXACT)
T(RN,    0x1.45fbc8c5efc33p-1,    0x1.224874d663bf1p-1,   0x1.f73192p-2, INEXACT)
T(RN,     0x1.4568289f3689p-1,    0x1.21df5bdd54b2dp-1,  -0x1.fbfa62p-2, INEXACT)
T(RN,    0x1.44d4cb531f7a1p-1,    0x1.2176571be9afdp-1,  -0x1.f7ccc8p-2, INEXACT)
T(RN,    0x1.4441b0c364029p-1,    0x1.210d669fe80bep-1,  -0x1.f5c672p-2, INEXACT)
T(RN,    0x1.43aed8d1cb2a4p-1,    0x1.20a48a7704c05p-1,   0x1.f69506p-2, INEXACT)
T(RN,     0x1.431c43602a1bp-1,    0x1.203bc2aee4cb2p-1,   0x1.fad0e6p-2, INEXACT)
T(RN,     0x1.4289f05062f8p-1,    0x1.1fd30f551c5cbp-1,   -0x1.ff565p-2, INEXACT)
T(RN,    0x1.41f7df8466074p-1,    0x1.1f6a70772fadfp-1,    0x1.f95e1p-2, INEXACT)
T(RN,    0x1.416610de30febp-1,    0x1.1f01e6229281ap-1,   0x1.f6669cp-2, INEXACT)
T(RN,    0x1.40d4843fcf395p-1,    0x1.1e997064a84cbp-1,   0x1.fcd2e8p-2, INEXACT)
T(RN,    0x1.4043398b5998bp-1,    0x1.1e310f4ac421ep-1,  -0x1.f7e034p-2, INEXACT)
T(RN,    0x1.3fb230a2f68dap-1,    0x1.1dc8c2e228ba5p-1,   0x1.fdc7b6p-2, INEXACT)
T(RN,    0x1.3f216968da13ap-1,    0x1.1d608b380873ap-1,  -0x1.fec6c6p-2, INEXACT)
T(RN,    0x1.3e90e3bf45964p-1,    0x1.1cf86859853fdp-1,  -0x1.f8bfa2p-2, INEXACT)
T(RN,    0x1.3e009f8888071p-1,    0x1.1c905a53b0b6bp-1,    0x1.fb1bfp-2, INEXACT)
T(RN,    0x1.3d709ca6fdbbap-1,    0x1.1c2861338bffdp-1,   0x1.f5ec08p-2, INEXACT)
T(RN,    0x1.3ce0dafd108d1p-1,    0x1.1bc07d0607ec1p-1,   0x1.fd4554p-2, INEXACT)
T(RN,    0x1.3c515a6d37a38p-1,    0x1.1b58add804d1fp-1,  -0x1.fe081ap-2, INEXACT)
T(RN,    0x1.3bc21ad9f78b5p-1,    0x1.1af0f3b6529fep-1,  -0x1.fb8584p-2, INEXACT)
T(RN,    0x1.3b331c25e233fp-1,    0x1.1a894eadb0ddep-1,   0x1.fec298p-2, INEXACT)
T(RN,    0x1.3aa45e3396da6p-1,    0x1.1a21becacea0cp-1,  -0x1.fd1aaep-2, INEXACT)
T(RN,    0x1.3a15e0e5c206cp-1,    0x1.19ba441a4a8bep-1,  -0x1.f9f006p-2, INEXACT)
T(RN,    0x1.3987a41f1ce0fp-1,    0x1.1952dea8b2571p-1,   0x1.f5cccep-2, INEXACT)
T(RN,    0x1.38f9a7c2709bap-1,    0x1.18eb8e82854e4p-1,   0x1.fd7eacp-2, INEXACT)
T(RN,    0x1.386bebb28f65fp-1,    0x1.188453b42f335p-1,   0x1.fc3e7cp-2, INEXACT)
T(RN,    0x1.37de6fd25b7abp-1,    0x1.181d2e4a0d639p-1,    0x1.ffd35p-2, INEXACT)
T(RN,    0x1.37513404c3971p-1,    0x1.17b61e506c48ep-1,   0x1.f9a5b2p-2, INEXACT)
T(RN,    0x1.36c4382cc3986p-1,    0x1.174f23d387cffp-1,   0x1.f75956p-2, INEXACT)
T(RN,    0x1.36377c2d64835p-1,    0x1.16e83edf8b712p-1,  -0x1.fd797ep-2, INEXACT)
T(RN,    0x1.35aaffe9bc7afp-1,    0x1.16816f80922dfp-1,  -0x1.febf7ep-2, INEXACT)
T(RN,    0x1.351ec344eebdap-1,    0x1.161ab5c2a6924p-1,  -0x1.f9787cp-2, INEXACT)
T(RN,    0x1.3492c6222b885p-1,    0x1.15b411b1c2a38p-1,   0x1.f7196ep-2, INEXACT)
T(RN,    0x1.34070864b05c9p-1,    0x1.154d8359d017cp-1,   -0x1.f8572p-2, INEXACT)
T(RN,    0x1.337b89efc771cp-1,    0x1.14e70ac6a7f1bp-1,  -0x1.fca1aap-2, INEXACT)
T(RN,     0x1.32f04aa6c837p-1,    0x1.1480a80412e3ap-1,   0x1.fef064p-2, INEXACT)
T(RN,    0x1.32654a6d1703ep-1,    0x1.141a5b1dc919ap-1,  -0x1.ffbad8p-2, INEXACT)
T(RN,    0x1.31da892625266p-1,    0x1.13b4241f7248dp-1,   0x1.f69fe2p-2, INEXACT)
T(RN,    0x1.315006b570eafp-1,    0x1.134e0314a5b8fp-1,   0x1.fda8cep-2, INEXACT)
T(RN,    0x1.30c5c2fe8564fp-1,    0x1.12e7f808ea20bp-1,  -0x1.fa4cf4p-2, INEXACT)
T(RN,    0x1.303bbde4fa9b6p-1,    0x1.12820307b5cb4p-1,  -0x1.f5c3c2p-2, INEXACT)
T(RN,    0x1.2fb1f74c75951p-1,    0x1.121c241c6ea5ep-1,  -0x1.fe47f6p-2, INEXACT)
T(RN,    0x1.2f286f18a7f1ep-1,    0x1.11b65b5269f92p-1,   0x1.feadb8p-2, INEXACT)
T(RN,    0x1.2e9f252d504a3p-1,    0x1.1150a8b4ecb41p-1,   0x1.fab0a4p-2, INEXACT)
T(RN,    0x1.2e16196e39f71p-1,    0x1.10eb0c4f2b487p-1,   0x1.fd9bccp-2, INEXACT)
T(RN,    0x1.2d8d4bbf3d1d3p-1,    0x1.1085862c49b7ap-1,  -0x1.fcd7cap-2, INEXACT)
T(RN,    0x1.2d04bc043ea11p-1,    0x1.102016575b8f8p-1,   0x1.fe75fcp-2, INEXACT)
T(RN,    0x1.2c7c6a21301b7p-1,    0x1.0fbabcdb63e68p-1,  -0x1.f64f56p-2, INEXACT)
T(RN,    0x1.2bf455fa0fda3p-1,    0x1.0f5579c355629p-1,  -0x1.fe6dccp-2, INEXACT)
T(RN,    0x1.2b6c7f72e8e4ap-1,    0x1.0ef04d1a12413p-1,  -0x1.f8d224p-2, INEXACT)
T(RN,    0x1.2ae4e66fd2da6p-1,    0x1.0e8b36ea6c44cp-1,   0x1.fd9062p-2, INEXACT)
T(RN,    0x1.2a5d8ad4f20dap-1,    0x1.0e26373f24cd6p-1,  -0x1.fbc3ecp-2, INEXACT)
T(RN,     0x1.29d66c86776ap-1,    0x1.0dc14e22ecccap-1,  -0x1.fb3304p-2, INEXACT)
T(RN,    0x1.294f8b68a06aap-1,    0x1.0d5c7ba064c35p-1,  -0x1.fba012p-2, INEXACT)
T(RN,    0x1.28c8e75fb7231p-1,    0x1.0cf7bfc21cce7p-1,  -0x1.f71026p-2, INEXACT)
T(RN,    0x1.284280501236ep-1,    0x1.0c931a9294a6ep-1,  -0x1.f7c0e4p-2, INEXACT)
T(RN,    0x1.27bc561e14b9cp-1,    0x1.0c2e8c1c3b8fap-1,  -0x1.f5f6eep-2, INEXACT)
T(RN,    0x1.273668ae2ea61p-1,     0x1.0bca146970b5p-1,   0x1.f7af68p-2, INEXACT)
T(RN,    0x1.26b0b7e4dbc73p-1,    0x1.0b65b38482627p-1,    0x1.f6c09p-2, INEXACT)
T(RN,    0x1.262b43a6a4c7cp-1,    0x1.0b016977aed3ep-1,    0x1.f9e4bp-2, INEXACT)
T(RN,    0x1.25a60bd81ec62p-1,    0x1.0a9d364d23eb7p-1,   0x1.fe052ep-2, INEXACT)
T(RN,     0x1.2521105deb2fp-1,    0x1.0a391a0eff1bep-1,    0x1.fb546p-2, INEXACT)
T(RN,    0x1.249c511cb7dd1p-1,     0x1.09d514c74d87p-1,   0x1.fd9cacp-2, INEXACT)
T(RN,    0x1.2417cdf93f06bp-1,    0x1.097126800bf6ap-1,     0x1.fca2p-2, INEXACT)
T(RN,    0x1.239386d84740bp-1,    0x1.090d4f4326e57p-1,   0x1.fe5774p-2, INEXACT)
T(RN,    0x1.230f7b9ea3712p-1,    0x1.08a98f1a7a7bfp-1,   0x1.feb35ep-2, INEXACT)
T(RN,    0x1.228bac3132d51p-1,    0x1.0845e60fd29bbp-1,  -0x1.ffbd3ap-2, INEXACT)
T(RN,    0x1.22081874e0e5ep-1,    0x1.07e2542cead28p-1,   0x1.ff987cp-2, INEXACT)
T(RN,    0x1.2184c04ea5679p-1,    0x1.077ed97b6e6bbp-1,   -0x1.fbc1bp-2, INEXACT)
T(RN,    0x1.2101a3a38457ep-1,    0x1.071b7604f86b6p-1,  -0x1.f6bb08p-2, INEXACT)
T(RN,    0x1.207ec2588df57p-1,    0x1.06b829d3139a8p-1,  -0x1.fbc266p-2, INEXACT)
T(RN,    0x1.1ffc1c52dea4dp-1,    0x1.0654f4ef3a7a1p-1,  -0x1.fe911cp-2, INEXACT)
T(RN,    0x1.1f79b1779f02ap-1,    0x1.05f1d762d7584p-1,  -0x1.f6a606p-2, INEXACT)
T(RN,    0x1.1ef781ac03cfbp-1,    0x1.058ed1374448ep-1,  -0x1.fa196cp-2, INEXACT)
T(RN,    0x1.1e758cd54de88p-1,    0x1.052be275cb268p-1,  -0x1.f81bf2p-2, INEXACT)
T(RN,    0x1.1df3d2d8ca5eap-1,    0x1.04c90b27a5ad7p-1,  -0x1.f6e2fep-2, INEXACT)
T(RN,    0x1.1d72539bd2366p-1,    0x1.04664b55fd511p-1,   0x1.f9cedcp-2, INEXACT)
T(RN,    0x1.1cf10f03caa05p-1,    0x1.0403a309eb6f3p-1,   0x1.fd218ep-2, INEXACT)
T(RN,    0x1.1c7004f624d35p-1,    0x1.03a1124c793b6p-1,  -0x1.fa6d56p-2, INEXACT)
T(RN,    0x1.1bef35585e0a5p-1,    0x1.033e99269fc53p-1,   -0x1.f7898p-2, INEXACT)
T(RN,    0x1.1b6ea00fff7dep-1,    0x1.02dc37a147fb1p-1,   0x1.f9c786p-2, INEXACT)
T(RN,    0x1.1aee45029e72ap-1,    0x1.0279edc54abd7p-1,  -0x1.fb4ea4p-2, INEXACT)
T(RN,    0x1.1a6e2415dc0a6p-1,    0x1.0217bb9b70c3bp-1,   0x1.f63784p-2, INEXACT)
T(RN,    0x1.19ee3d2f6578ap-1,    0x1.01b5a12c72cbbp-1,   -0x1.fb505p-2, INEXACT)
T(RN,    0x1.196e9034f3bd6p-1,    0x1.01539e80f96e1p-1,   -0x1.ffe55p-2, INEXACT)
T(RN,    0x1.18ef1d0c4bca4p-1,    0x1.00f1b3a19d426p-1,  -0x1.f6c7e6p-2, INEXACT)
T(RN,    0x1.186fe39b3d435p-1,    0x1.008fe096e5f27p-1,    -0x1.f5cfp-2, INEXACT)
T(RN,    0x1.17f0e3c7a88a3p-1,     0x1.002e25694ee9p-1,   0x1.fad298p-2, INEXACT)
T(RN,    0x1.17721d77726cfp-1,    0x1.ff9904427bc14p-2,   0x1.fff4ecp-2, INEXACT)
T(RN,    0x1.16f39090907c6p-1,    0x1.fed5ed8e18d49p-2,   0x1.fe2278p-2, INEXACT)
T(RN,    0x1.16753cf902e4ap-1,    0x1.fe1306c60673dp-2,  -0x1.fc481ap-2, INEXACT)
T(RN,    0x1.15f72296d5868p-1,    0x1.fd504ffab60fcp-2,  -0x1.faeb1ap-2, INEXACT)
T(RN,    0x1.15794150200efp-1,    0x1.fc8dc93c7957ap-2,   0x1.fa41dep-2, INEXACT)
T(RN,    0x1.14fb990b05e6bp-1,     0x1.fbcb729b8232p-2,   0x1.fadd8cp-2, INEXACT)
T(RN,    0x1.147e29adb626fp-1,    0x1.fb094c27e2bd8p-2,  -0x1.f89daep-2, INEXACT)
T(RN,    0x1.1400f31e6b9b5p-1,    0x1.fa4755f18d663p-2,   0x1.f8b2f8p-2, INEXACT)
T(RN,    0x1.1383f5436cbd1p-1,    0x1.f985900854efep-2,  -0x1.fe6af6p-2, INEXACT)
T(RN,    0x1.130730030baa5p-1,    0x1.f8c3fa7bec7bfp-2,    -0x1.fc2fp-2, INEXACT)
T(RN,    0x1.128aa343a6235p-1,     0x1.f802955be797p-2,  -0x1.fb6a24p-2, INEXACT)
T(RN,    0x1.120e4eeba5826p-1,    0x1.f74160b7ba3f8p-2,  -0x1.f764c6p-2, INEXACT)
T(RN,     0x1.119232e17eb7p-1,     0x1.f6805c9eb8f1p-2,   0x1.f7c032p-2, INEXACT)
T(RN,    0x1.11164f0bb252fp-1,    0x1.f5bf892018cb5p-2,   0x1.ff1beep-2, INEXACT)
T(RN,    0x1.109aa350cc582p-1,    0x1.f4fee64aef582p-2,   0x1.f81f08p-2, INEXACT)
T(RN,    0x1.101f2f97645dep-1,    0x1.f43e742e32d7ep-2,   0x1.f621eap-2, INEXACT)
T(RN,    0x1.0fa3f3c61d7d4p-1,    0x1.f37e32d8ba36ap-2,  -0x1.feea3cp-2, INEXACT)
T(RN,    0x1.0f28efc3a645cp-1,    0x1.f2be22593d0e3p-2,  -0x1.f7f3acp-2, INEXACT)
T(RN,    0x1.0eae2376b8cf8p-1,    0x1.f1fe42be53d5ep-2,   0x1.f893fap-2, INEXACT)
T(RN,    0x1.0e338ec61a8f2p-1,    0x1.f13e941677b15p-2,  -0x1.f6042ap-2, INEXACT)
T(RN,    0x1.0db931989c69fp-1,    0x1.f07f167002a47p-2,   0x1.f84f5ep-2, INEXACT)
T(RN,    0x1.0d3f0bd51abfap-1,    0x1.efbfc9d92fb5ep-2,   0x1.fba918p-2, INEXACT)
T(RN,    0x1.0cc51d627d35cp-1,    0x1.ef00ae601ab18p-2,   -0x1.fdd67p-2, INEXACT)
T(RN,    0x1.0c4b6627b6e9cp-1,    0x1.ee41c412c08afp-2,    -0x1.fcbap-2, INEXACT)
T(RN,    0x1.0bd1e60bc63cbp-1,    0x1.ed830afeff1fcp-2,  -0x1.fd4baep-2, INEXACT)
T(RN,    0x1.0b589cf5b4dfdp-1,    0x1.ecc48332955fep-2,   0x1.f639eap-2, INEXACT)
T(RN,    0x1.0adf8acc98116p-1,    0x1.ec062cbb23c19p-2,   0x1.f6b3cep-2, INEXACT)
T(RN,     0x1.0a66af778ff2p-1,    0x1.eb4807a62b4a4p-2,  -0x1.fdeed4p-2, INEXACT)
T(RN,     0x1.09ee0addc825p-1,    0x1.ea8a14010e9f5p-2,  -0x1.fd22c8p-2, INEXACT)
T(RN,    0x1.09759ce677808p-1,    0x1.e9cc51d9119d3p-2,  -0x1.fab114p-2, INEXACT)
T(RN,    0x1.08fd6578e018bp-1,    0x1.e90ec13b597e6p-2,  -0x1.fd9ac4p-2, INEXACT)
T(RN,    0x1.0885647c4f2a6p-1,    0x1.e8516234eccecp-2,  -0x1.f89208p-2, INEXACT)
T(RN,    0x1.080d99d81d346p-1,    0x1.e79434d2b3a8ep-2,  -0x1.fd9286p-2, INEXACT)
T(RN,    0x1.07960573adca8p-1,    0x1.e6d7392177847p-2,    0x1.f603bp-2, INEXACT)
T(RN,    0x1.071ea7366fafap-1,    0x1.e61a6f2de3749p-2,  -0x1.f923c2p-2, INEXACT)
T(RN,    0x1.06a77f07dcc98p-1,    0x1.e55dd704842adp-2,  -0x1.f87606p-2, INEXACT)
T(RN,    0x1.06308ccf7a125p-1,    0x1.e4a170b1c7f57p-2,  -0x1.fdf476p-2, INEXACT)
T(RN,    0x1.05b9d074d7a27p-1,    0x1.e3e53c41fee4fp-2,  -0x1.f715c2p-2, INEXACT)
T(RN,     0x1.054349df909ap-1,    0x1.e32939c15abe7p-2,   0x1.fe198ap-2, INEXACT)
T(RN,    0x1.04ccf8f74b2a9p-1,    0x1.e26d693bef20cp-2,  -0x1.f70c62p-2, INEXACT)
T(RN,    0x1.0456dda3b8928p-1,    0x1.e1b1cabdb193ep-2,   0x1.fe3e26p-2, INEXACT)
T(RN,    0x1.03e0f7cc9506dp-1,    0x1.e0f65e52797b1p-2,  -0x1.f9432ep-2, INEXACT)
T(RN,    0x1.036b4759a7c0ap-1,    0x1.e03b240600418p-2,  -0x1.faf568p-2, INEXACT)
T(RN,    0x1.02f5cc32c0956p-1,    0x1.df801be3dd9b6p-2,  -0x1.f5cac6p-2, INEXACT)
T(RN,    0x1.0280863fc3ac7p-1,    0x1.dec545f79a42bp-2,  -0x1.f848bcp-2, INEXACT)
T(RN,    0x1.020b756892133p-1,    0x1.de0aa24c8ac0cp-2,  -0x1.f9c6dcp-2, INEXACT)
T(RN,    0x1.0196999521191p-1,    0x1.dd5030edf4b8cp-2,    0x1.fec7ap-2, INEXACT)
T(RN,    0x1.0121f2ad6ea07p-1,    0x1.dc95f1e6fc62bp-2,   0x1.fdfcecp-2, INEXACT)
T(RN,     0x1.00ad8099835fp-1,    0x1.dbdbe542a8387p-2,  -0x1.fd23c4p-2, INEXACT)
T(RN,    0x1.0039434172e9fp-1,    0x1.db220b0be1203p-2,  -0x1.f790e8p-2, INEXACT)
T(RN,    0x1.ff8a751ab77ebp-2,    0x1.da68634d72926p-2,   0x1.f69d9ap-2, INEXACT)
T(RN,    0x1.fea2cccace44ep-2,    0x1.d9aeee120a77ap-2,  -0x1.f7582cp-2, INEXACT)
T(RN,    0x1.fdbb8d6391fd5p-2,    0x1.d8f5ab6439124p-2,   0x1.f9b85cp-2, INEXACT)
T(RN,    0x1.fcd4b6b5806c8p-2,    0x1.d83c9b4e7192ap-2,   0x1.f83ae6p-2, INEXACT)
T(RN,    0x1.fbee48912cb23p-2,    0x1.d783bddb09ba2p-2,   0x1.fdbddep-2, INEXACT)
T(RN,    0x1.fb0842c73f69cp-2,    0x1.d6cb13143a0c4p-2,   0x1.f7d32ep-2, INEXACT)
T(RN,    0x1.fa22a52876ac3p-2,    0x1.d6129b041de7ep-2,  -0x1.fdad86p-2, INEXACT)
T(RN,    0x1.f93d6f85a5e98p-2,    0x1.d55a55b4b3804p-2,   0x1.fed2e8p-2, INEXACT)
T(RN,    0x1.f858a1afb5f4fp-2,     0x1.d4a2432fdbfep-2,   0x1.fcc8bcp-2, INEXACT)
T(RN,    0x1.f7743b77a4f47p-2,    0x1.d3ea637f5b8a5p-2,    0x1.fda63p-2, INEXACT)
T(RN,    0x1.f6903cae86596p-2,    0x1.d332b6acd960cp-2,   0x1.fa26bap-2, INEXACT)
T(RN,    0x1.f5aca52582d7dp-2,    0x1.d27b3cc1dfe05p-2,   0x1.f5e254p-2, INEXACT)
T(RN,    0x1.f4c974add84f4p-2,    0x1.d1c3f5c7dc90dp-2,    0x1.fc78ap-2, INEXACT)
T(RN,    0x1.f3e6ab18d9d79p-2,    0x1.d10ce1c820457p-2,  -0x1.fdfb78p-2, INEXACT)
T(RN,    0x1.f3044837efa5bp-2,    0x1.d05600cbdf1f5p-2,   0x1.f88bacp-2, INEXACT)
T(RN,    0x1.f2224bdc970b8p-2,    0x1.cf9f52dc30a52p-2,   0x1.ffd586p-2, INEXACT)
T(RN,    0x1.f140b5d86266dp-2,    0x1.cee8d8020fce7p-2,   0x1.f77594p-2, INEXACT)
T(RN,    0x1.f05f85fcf91d8p-2,    0x1.ce3290465b18cp-2,   0x1.f76c1cp-2, INEXACT)
T(RN,     0x1.ef7ebc1c179cp-2,    0x1.cd7c7bb1d49eep-2,   -0x1.fec9ep-2, INEXACT)
T(RN,    0x1.ee9e58078f237p-2,    0x1.ccc69a4d22098p-2,   0x1.f5c674p-2, INEXACT)
T(RN,    0x1.edbe5991461fap-2,    0x1.cc10ec20ccecfp-2,   -0x1.fad81p-2, INEXACT)
T(RN,    0x1.ecdec08b3789cp-2,    0x1.cb5b713542634p-2,  -0x1.fe5194p-2, INEXACT)
T(RN,    0x1.ebff8cc7736cep-2,    0x1.caa62992d38ffp-2,    0x1.f94dcp-2, INEXACT)
T(RN,    0x1.eb20be181e894p-2,    0x1.c9f11541b56dcp-2,   0x1.f78492p-2, INEXACT)
T(RN,    0x1.ea42544f7270ep-2,    0x1.c93c344a00ff2p-2,  -0x1.fb23fap-2, INEXACT)
T(RN,    0x1.e9644f3fbd638p-2,    0x1.c88786b3b34a1p-2,   0x1.fc2502p-2, INEXACT)
T(RN,    0x1.e886aebb625c7p-2,    0x1.c7d30c86ad7bfp-2,   0x1.f8f1f2p-2, INEXACT)
T(RN,    0x1.e7a97294d8f8dp-2,    0x1.c71ec5cab4ee5p-2,  -0x1.fb851cp-2, INEXACT)
T(RN,     0x1.e6cc9a9ead79p-2,    0x1.c66ab28773415p-2,  -0x1.f70a08p-2, INEXACT)
T(RN,    0x1.e5f026ab80ae3p-2,    0x1.c5b6d2c47665bp-2,   0x1.fbb426p-2, INEXACT)
T(RN,    0x1.e514168e07f77p-2,    0x1.c503268930b3dp-2,    0x1.fa63ap-2, INEXACT)
T(RN,    0x1.e4386a190d3c1p-2,    0x1.c44faddcf900dp-2,  -0x1.fc9c34p-2, INEXACT)
T(RN,    0x1.e35d211f6ed5fp-2,    0x1.c39c68c70aa66p-2,   -0x1.fbce9p-2, INEXACT)
T(RN,    0x1.e2823b741f7c4p-2,    0x1.c2e9574e858abp-2,    0x1.f7265p-2, INEXACT)
T(RN,    0x1.e1a7b8ea26979p-2,    0x1.c236797a6e7eep-2,    0x1.f84ddp-2, INEXACT)
T(RN,    0x1.e0cd99549f872p-2,    0x1.c183cf51aec04p-2,   0x1.ff4962p-2, INEXACT)
T(RN,    0x1.dff3dc86ba413p-2,     0x1.c0d158db1495p-2,   0x1.fa5238p-2, INEXACT)
T(RN,    0x1.df1a8253baf35p-2,    0x1.c01f161d5317bp-2,  -0x1.f84978p-2, INEXACT)
T(RN,    0x1.de418a8efa0fbp-2,    0x1.bf6d071f025c4p-2,  -0x1.fc9fe4p-2, INEXACT)
T(RN,    0x1.dd68f50be4463p-2,    0x1.bebb2be69f83fp-2,   0x1.f611ccp-2, INEXACT)
T(RN,    0x1.dc90c19dfa722p-2,    0x1.be09847a8cc84p-2,   -0x1.f69f3p-2, INEXACT)
T(RN,    0x1.dbb8f018d190ep-2,    0x1.bd5810e1118ddp-2,  -0x1.f663a2p-2, INEXACT)
T(RN,    0x1.dae1805012c2cp-2,    0x1.bca6d1205a7e9p-2,  -0x1.f90e0ep-2, INEXACT)
T(RN,    0x1.da0a72177b436p-2,     0x1.bbf5c53e799ep-2,   0x1.ff7beep-2, INEXACT)
T(RN,    0x1.d933c542dc46bp-2,    0x1.bb44ed4166463p-2,  -0x1.f79f5ap-2, INEXACT)
T(RN,    0x1.d85d79a61b124p-2,    0x1.ba94492efd578p-2,   0x1.f94ef6p-2, INEXACT)
T(RN,    0x1.d7878f1530e2ap-2,    0x1.b9e3d90d013c2p-2,    0x1.fdb7cp-2, INEXACT)
T(RN,    0x1.d6b205642ae11p-2,    0x1.b9339ce119fa9p-2,   0x1.f77158p-2, INEXACT)
T(RN,    0x1.d5dcdc6729e1dp-2,    0x1.b88394b0d5196p-2,  -0x1.f5fa2ep-2, INEXACT)
T(RN,    0x1.d50813f263866p-2,    0x1.b7d3c081a6a9cp-2,     0x1.fda8p-2, INEXACT)
T(RN,    0x1.d433abda1fea6p-2,    0x1.b7242058e775cp-2,   0x1.f61546p-2, INEXACT)
T(RN,    0x1.d35fa3f2bbcd9p-2,     0x1.b674b43bd6e5p-2,  -0x1.fbf572p-2, INEXACT)
T(RN,    0x1.d28bfc10a78a5p-2,    0x1.b5c57c2f9a3bfp-2,   0x1.fa0726p-2, INEXACT)
T(RN,    0x1.d1b8b408672eep-2,    0x1.b51678393ccaap-2,  -0x1.ff6e68p-2, INEXACT)
T(RN,    0x1.d0e5cbae9278ap-2,    0x1.b467a85db0045p-2,  -0x1.f64d08p-2, INEXACT)
T(RN,    0x1.d01342d7d4d18p-2,    0x1.b3b90ca1cb976p-2,   0x1.fe478ap-2, INEXACT)
T(RN,    0x1.cf411958ed3e5p-2,    0x1.b30aa50a4d797p-2,   0x1.fa45dep-2, INEXACT)
T(RN,    0x1.ce6f4f06ae5c3p-2,    0x1.b25c719bda005p-2,   0x1.fc4d92p-2, INEXACT)
T(RN,    0x1.cd9de3b5fe581p-2,    0x1.b1ae725afbf57p-2,  -0x1.f7d50ap-2, INEXACT)
T(RN,    0x1.ccccd73bd6e54p-2,    0x1.b100a74c24a93p-2,  -0x1.fd80dap-2, INEXACT)
T(RN,    0x1.cbfc296d45285p-2,    0x1.b0531073abfbdp-2,  -0x1.fb6578p-2, INEXACT)
T(RN,    0x1.cb2bda1f69c55p-2,    0x1.afa5add5d0847p-2,  -0x1.f624d2p-2, INEXACT)
T(RN,    0x1.ca5be92778c8ep-2,    0x1.aef87f76b798ep-2,  -0x1.f9b9cap-2, INEXACT)
T(RN,    0x1.c98c565ab9973p-2,    0x1.ae4b855a6d5a7p-2,  -0x1.fb7ceap-2, INEXACT)
T(RN,    0x1.c8bd218e86f74p-2,    0x1.ad9ebf84e4da6p-2,   0x1.f9b64cp-2, INEXACT)
T(RN,    0x1.c7ee4a984efcbp-2,    0x1.acf22df9f8223p-2,   0x1.fadb06p-2, INEXACT)
T(RN,    0x1.c71fd14d92fd3p-2,    0x1.ac45d0bd68464p-2,   0x1.f63deep-2, INEXACT)
T(RN,    0x1.c651b583e79e7p-2,    0x1.ab99a7d2dd8c5p-2,   0x1.f5cefcp-2, INEXACT)
T(RN,    0x1.c583f710f4a92p-2,    0x1.aaedb33de7612p-2,   0x1.f60a2cp-2, INEXACT)
T(RN,    0x1.c4b695ca75184p-2,    0x1.aa41f301fc805p-2,  -0x1.f8995ep-2, INEXACT)
T(RN,    0x1.c3e9918637107p-2,    0x1.a99667227b089p-2,  -0x1.f8ef62p-2, INEXACT)
T(RN,     0x1.c31cea1a1bcap-2,    0x1.a8eb0fa2a8842p-2,  -0x1.f7398ap-2, INEXACT)
T(RN,    0x1.c2509f5c17957p-2,    0x1.a83fec85b2082p-2,   0x1.f6b344p-2, INEXACT)
T(RN,    0x1.c184b12231d1bp-2,    0x1.a794fdceac475p-2,  -0x1.fb65a2p-2, INEXACT)
T(RN,     0x1.c0b91f4284dbp-2,    0x1.a6ea4380939fbp-2,   0x1.f943bep-2, INEXACT)
T(RN,    0x1.bfede9933dfd7p-2,    0x1.a63fbd9e4c299p-2,  -0x1.fe52b4p-2, INEXACT)
T(RN,     0x1.bf230fea9d8ap-2,    0x1.a5956c2aa1e59p-2,  -0x1.f86df6p-2, INEXACT)
T(RN,    0x1.be58921ef6a6dp-2,    0x1.a4eb4f2848af4p-2,   0x1.fa6b5ap-2, INEXACT)
T(RN,    0x1.bd8e7006af669p-2,    0x1.a4416699dc6c3p-2,  -0x1.fc8962p-2, INEXACT)
T(RN,    0x1.bcc4a97840a9dp-2,    0x1.a397b281e10e2p-2,   -0x1.fcdbbp-2, INEXACT)
T(RN,    0x1.bbfb3e4a36293p-2,    0x1.a2ee32e2c2b67p-2,   0x1.ff386cp-2, INEXACT)
T(RN,    0x1.bb322e532e4a1p-2,    0x1.a244e7bed5ad3p-2,     0x1.f7fap-2, INEXACT)
T(RN,    0x1.ba697969da6e5p-2,    0x1.a19bd11856c01p-2,   0x1.f81fdap-2, INEXACT)
T(RN,    0x1.b9a11f64fe55dp-2,    0x1.a0f2eef16ad82p-2,   0x1.f89c26p-2, INEXACT)
T(RN,    0x1.b8d9201b70a3fp-2,    0x1.a04a414c1f85cp-2,   -0x1.f8023p-2, INEXACT)
T(RN,    0x1.b8117b641aa2dp-2,    0x1.9fa1c82a6ae94p-2,  -0x1.ffba28p-2, INEXACT)
T(RN,    0x1.b74a3115f81cbp-2,    0x1.9ef9838e2bad8p-2,   0x1.f861aep-2, INEXACT)
T(RN,    0x1.b6834108177c9p-2,    0x1.9e517379293efp-2,  -0x1.f99ffcp-2, INEXACT)
T(RN,    0x1.b5bcab1199b49p-2,    0x1.9da997ed13d21p-2,  -0x1.fbffa4p-2, INEXACT)
T(RN,    0x1.b4f66f09b245dp-2,    0x1.9d01f0eb84851p-2,  -0x1.f74dccp-2, INEXACT)
T(RN,    0x1.b4308cc7a71f1p-2,    0x1.9c5a7e75fd5f9p-2,    0x1.f91ccp-2, INEXACT)
T(RN,    0x1.b36b0422d09a7p-2,     0x1.9bb3408de96cp-2,   0x1.ff5608p-2, INEXACT)
T(RN,    0x1.b2a5d4f299902p-2,    0x1.9b0c37349ce37p-2,   0x1.fffa3ap-2, INEXACT)
T(RN,    0x1.b1e0ff0e7f25fp-2,    0x1.9a65626b551ffp-2,   0x1.fcaa0ep-2, INEXACT)
T(RN,    0x1.b11c824e10e1bp-2,    0x1.99bec23338c7dp-2,    0x1.fd4f1p-2, INEXACT)
T(RN,    0x1.b0585e88f0989p-2,    0x1.9918568d57db2p-2,  -0x1.f72fcap-2, INEXACT)
T(RN,    0x1.af949396d26bap-2,    0x1.98721f7aabccbp-2,   0x1.f7e874p-2, INEXACT)
T(RN,    0x1.aed1214f7cb52p-2,    0x1.97cc1cfc178d3p-2,  -0x1.fef376p-2, INEXACT)
T(RN,    0x1.ae0e078ac80b3p-2,    0x1.97264f1267aa1p-2,   0x1.f6a4eep-2, INEXACT)
T(RN,    0x1.ad4b46209f315p-2,    0x1.9680b5be525bep-2,   -0x1.fe709p-2, INEXACT)
T(RN,    0x1.ac88dce8ff127p-2,    0x1.95db5100779dfp-2,   0x1.f9a87ap-2, INEXACT)
T(RN,    0x1.abc6cbbbf6b98p-2,    0x1.953620d96142cp-2,   0x1.fcc23ep-2, INEXACT)
T(RN,    0x1.ab051271a7368p-2,    0x1.9491254982f97p-2,   0x1.f5d9e2p-2, INEXACT)
T(RN,    0x1.aa43b0e243e36p-2,    0x1.93ec5e513aa3dp-2,    0x1.fccd7p-2, INEXACT)
T(RN,    0x1.a982a6e611c6bp-2,    0x1.9347cbf0cfec1p-2,  -0x1.fc4102p-2, INEXACT)
T(RN,    0x1.a8c1f4556825cp-2,    0x1.92a36e2874dd4p-2,   0x1.fbea98p-2, INEXACT)
T(RN,    0x1.a8019908b02c2p-2,    0x1.91ff44f845b2fp-2,   -0x1.f963fp-2, INEXACT)
T(RN,    0x1.a74194d864e3dp-2,    0x1.915b506048ef1p-2,   -0x1.f9628p-2, INEXACT)
T(RN,    0x1.a681e79d13573p-2,    0x1.90b790606f91fp-2,  -0x1.f729f2p-2, INEXACT)
T(RN,    0x1.a5c2912f5a53fp-2,    0x1.901404f895023p-2,   0x1.f959eap-2, INEXACT)
T(RN,    0x1.a5039167ea8a7p-2,    0x1.8f70ae287f42ep-2,  -0x1.fc0fa2p-2, INEXACT)
T(RN,    0x1.a444e81f86794p-2,    0x1.8ecd8befdefe5p-2,  -0x1.feea3ep-2, INEXACT)
T(RN,    0x1.a386952f025fep-2,    0x1.8e2a9e4e4f95dp-2,  -0x1.f82f88p-2, INEXACT)
T(RN,    0x1.a2c8986f44337p-2,     0x1.8d87e5435734p-2,   -0x1.f7606p-2, INEXACT)
T(RN,    0x1.a20af1b93f43fp-2,     0x1.8ce560ce632dp-2,   0x1.f5c616p-2, INEXACT)
T(RN,    0x1.a14da0e60a51ap-2,    0x1.8c4310eedb07bp-2,   0x1.f5cca4p-2, INEXACT)
T(RN,    0x1.a090a5ceb2ec8p-2,    0x1.8ba0f5a3fa594p-2,   0x1.fa4f7cp-2, INEXACT)
T(RN,      0x1.9fd4004c6a4p-2,    0x1.8aff0eecf7462p-2,   0x1.f65852p-2, INEXACT)
T(RN,    0x1.9f17b0386e78ap-2,    0x1.8a5d5cc8ef3dep-2,  -0x1.fecb36p-2, INEXACT)
T(RN,    0x1.9e5bb56c0f622p-2,    0x1.89bbdf36eb0c8p-2,   0x1.fdf656p-2, INEXACT)
T(RN,    0x1.9da00fc0ae448p-2,    0x1.891a9635ded76p-2,  -0x1.fe339ep-2, INEXACT)
T(RN,    0x1.9ce4bf0fbde89p-2,    0x1.887981c4aa3dcp-2,   0x1.fa34f6p-2, INEXACT)
T(RN,     0x1.9c29c332c289p-2,    0x1.87d8a1e218669p-2,  -0x1.fa5e48p-2, INEXACT)
T(RN,    0x1.9b6f1c0351ce6p-2,    0x1.8737f68ce0199p-2,  -0x1.f994e2p-2, INEXACT)
T(RN,    0x1.9ab4c95b12cf4p-2,    0x1.86977fc3a3da7p-2,    0x1.f984bp-2, INEXACT)
T(RN,    0x1.99facb13bdf53p-2,    0x1.85f73d84f1ed3p-2,  -0x1.f8ee6cp-2, INEXACT)
T(RN,    0x1.994121071d02dp-2,    0x1.85572fcf44778p-2,  -0x1.feb1a8p-2, INEXACT)
T(RN,    0x1.9887cb0f0b0c8p-2,    0x1.84b756a101957p-2,  -0x1.fa3e3ap-2, INEXACT)
T(RN,    0x1.97cec90574674p-2,    0x1.8417b1f87b669p-2,  -0x1.f7aaf2p-2, INEXACT)
T(RN,    0x1.97161ac456ae4p-2,    0x1.837841d3f02e4p-2,  -0x1.fa1212p-2, INEXACT)
T(RN,    0x1.965dc025c0a5ap-2,    0x1.82d906318a561p-2,   0x1.f7d39ap-2, INEXACT)
T(RN,    0x1.95a5b903d2531p-2,    0x1.8239ff0f609e5p-2,   0x1.f8497cp-2, INEXACT)
T(RN,    0x1.94ee0538bccfbp-2,    0x1.819b2c6b76121p-2,  -0x1.f914e4p-2, INEXACT)
T(RN,    0x1.9436a49ec267fp-2,    0x1.80fc8e43ba3e3p-2,    -0x1.f6c8p-2, INEXACT)
T(RN,    0x1.937f97103669cp-2,    0x1.805e249609218p-2,   -0x1.fa1c9p-2, INEXACT)
T(RN,    0x1.92c8dc677d3fbp-2,    0x1.7fbfef602b5ffp-2,  -0x1.fd0e92p-2, INEXACT)
T(RN,    0x1.9212747f0c62fp-2,    0x1.7f21ee9fd651ep-2,  -0x1.f696e4p-2, INEXACT)
T(RN,    0x1.915c5f316a3a4p-2,     0x1.7e842252ac03p-2,   0x1.f801bap-2, INEXACT)
T(RN,     0x1.90a69c592e36p-2,    0x1.7de68a763b65dp-2,   0x1.fc8f4ap-2, INEXACT)
T(RN,    0x1.8ff12bd100abfp-2,    0x1.7d492708004ffp-2,  -0x1.fc1a88p-2, INEXACT)
T(RN,    0x1.8f3c0d739ae23p-2,    0x1.7cabf805639f1p-2,  -0x1.fad6fep-2, INEXACT)
T(RN,    0x1.8e87411bc6fcfp-2,    0x1.7c0efd6bbb442p-2,  -0x1.fb4182p-2, INEXACT)
T(RN,    0x1.8dd2c6a45ffd6p-2,    0x1.7b7237384a5e1p-2,   0x1.f7be3ep-2, INEXACT)
T(RN,    0x1.8d1e9de851b15p-2,    0x1.7ad5a5684146ap-2,   0x1.fb85f6p-2, INEXACT)
T(RN,    0x1.8c6ac6c298b61p-2,    0x1.7a3947f8bdb09p-2,   0x1.fab0bcp-2, INEXACT)
T(RN,    0x1.8bb7410e42692p-2,    0x1.799d1ee6cab56p-2,   0x1.fe1982p-2, INEXACT)
T(RN,    0x1.8b040ca66ce96p-2,    0x1.79012a2f60f1ap-2,  -0x1.f780d8p-2, INEXACT)
T(RN,    0x1.8a51296646ff1p-2,    0x1.786569cf668b9p-2,  -0x1.f80298p-2, INEXACT)
T(RN,      0x1.899e9729103p-2,    0x1.77c9ddc3af5fap-2,   0x1.fd2484p-2, INEXACT)
T(RN,    0x1.88ec55ca188d7p-2,    0x1.772e8608fceffp-2,  -0x1.fa0f9ep-2, INEXACT)
T(RN,    0x1.883a6524c0de3p-2,    0x1.7693629bfea4dp-2,   0x1.f794d8p-2, INEXACT)
T(RN,     0x1.8788c5147a6cp-2,    0x1.75f8737951baep-2,  -0x1.ff8328p-2, INEXACT)
T(RN,    0x1.86d77574c7206p-2,    0x1.755db89d81784p-2,  -0x1.f5fcc6p-2, INEXACT)
T(RN,    0x1.86267621395b7p-2,    0x1.74c3320507233p-2,   0x1.fdc7f4p-2, INEXACT)
T(RN,    0x1.8575c6f57404dp-2,    0x1.7428dfac4a2bep-2,  -0x1.fbb5e4p-2, INEXACT)
T(RN,    0x1.84c567cd2a7e6p-2,    0x1.738ec18fa03c8p-2,  -0x1.f63b5ep-2, INEXACT)
T(RN,    0x1.841558842097cp-2,    0x1.72f4d7ab4d48cp-2,  -0x1.f90b9cp-2, INEXACT)
T(RN,    0x1.836598f62a638p-2,    0x1.725b21fb8383bp-2,  -0x1.f5d4f4p-2, INEXACT)
T(RN,    0x1.82b628ff2cb42p-2,    0x1.71c1a07c63e81p-2,   0x1.f6c616p-2, INEXACT)
T(RN,    0x1.8207087b1c88ap-2,    0x1.71285329fdd22p-2,   0x1.f68b96p-2, INEXACT)
T(RN,    0x1.81583745fee67p-2,    0x1.708f3a004ef97p-2,   -0x1.fab02p-2, INEXACT)
T(RN,    0x1.80a9b53be973bp-2,    0x1.6ff654fb4412ep-2,   0x1.fd5daep-2, INEXACT)
T(RN,    0x1.7ffb823902089p-2,    0x1.6f5da416b88a1p-2,  -0x1.ff0354p-2, INEXACT)
T(RN,    0x1.7f4d9e197ebc8p-2,    0x1.6ec5274e76a8ap-2,   -0x1.fd384p-2, INEXACT)
T(RN,    0x1.7ea008b9a5ccdp-2,    0x1.6e2cde9e379a2p-2,   0x1.ff8f9ap-2, INEXACT)
T(RN,    0x1.7df2c1f5cdaebp-2,    0x1.6d94ca01a396ap-2,  -0x1.fd90fep-2, INEXACT)
T(RN,    0x1.7d45c9aa5cfd7p-2,    0x1.6cfce97451ee7p-2,  -0x1.fb821ep-2, INEXACT)
T(RN,    0x1.7c991fb3ca73ap-2,    0x1.6c653cf1c91e4p-2,   0x1.f6dd16p-2, INEXACT)
T(RN,    0x1.7becc3ee9ce1ep-2,    0x1.6bcdc4757ee1cp-2,  -0x1.fb898ap-2, INEXACT)
T(RN,    0x1.7b40b6376b26dp-2,    0x1.6b367ffad847dp-2,   0x1.ffdfbcp-2, INEXACT)
T(RN,    0x1.7a94f66adc2e2p-2,    0x1.6a9f6f7d29cb6p-2,  -0x1.ffd4c8p-2, INEXACT)
T(RN,    0x1.79e98465a6e5fp-2,    0x1.6a0892f7b765ap-2,  -0x1.fa92a6p-2, INEXACT)
T(RN,    0x1.793e60049233ep-2,    0x1.6971ea65b49e5p-2,   0x1.ffe6b8p-2, INEXACT)
T(RN,    0x1.7893892474f2bp-2,    0x1.68db75c244a44p-2,   0x1.f71458p-2, INEXACT)
T(RN,     0x1.77e8ffa235edp-2,    0x1.684535087a638p-2,   0x1.fb508ep-2, INEXACT)
T(RN,    0x1.773ec35acbc7fp-2,    0x1.67af2833588ccp-2,   0x1.ffb8fap-2, INEXACT)
T(RN,    0x1.7694d42b3d11cp-2,    0x1.67194f3dd1bcap-2,  -0x1.fbc72ep-2, INEXACT)
T(RN,     0x1.75eb31f0a037p-2,    0x1.6683aa22c88cdp-2,   -0x1.f8d5fp-2, INEXACT)
T(RN,    0x1.7541dc881b543p-2,    0x1.65ee38dd0f853p-2,   0x1.fb7ad8p-2, INEXACT)
T(RN,    0x1.7498d3cee46b6p-2,    0x1.6558fb6769657p-2,    0x1.fe3fbp-2, INEXACT)
T(RN,    0x1.73f017a241331p-2,    0x1.64c3f1bc89144p-2,  -0x1.f97a64p-2, INEXACT)
T(RN,     0x1.7347a7df8724p-2,    0x1.642f1bd711c5dp-2,   0x1.fd1278p-2, INEXACT)
T(RN,     0x1.729f84641b64p-2,    0x1.639a79b19702cp-2,    0x1.f8a5ap-2, INEXACT)
T(RN,    0x1.71f7ad0d72c1fp-2,    0x1.63060b469cbf6p-2,   0x1.ff3a52p-2, INEXACT)
T(RN,    0x1.715021b911b66p-2,    0x1.6271d09097761p-2,   0x1.fae7dcp-2, INEXACT)
T(RN,    0x1.70a8e2448c5b5p-2,    0x1.61ddc989ec3a1p-2,  -0x1.f8a9f2p-2, INEXACT)
T(RN,    0x1.7001ee8d86577p-2,    0x1.6149f62cf0bf7p-2,  -0x1.fb79ccp-2, INEXACT)
T(RN,    0x1.6f5b4671b2e79p-2,    0x1.60b65673eb7d2p-2,   0x1.f9a6cap-2, INEXACT)
T(RN,     0x1.6eb4e9ced4cdp-2,    0x1.6022ea5913b75p-2,   0x1.fa6d58p-2, INEXACT)
T(RN,    0x1.6e0ed882be50ep-2,    0x1.5f8fb1d6919c9p-2,  -0x1.fcbbc8p-2, INEXACT)
T(RN,    0x1.6d69126b512efp-2,     0x1.5efcace67e4dp-2,   0x1.ffc642p-2, INEXACT)
T(RN,    0x1.6cc397667e9c1p-2,    0x1.5e69db82e3f96p-2,   0x1.febc02p-2, INEXACT)
T(RN,    0x1.6c1e6752473b5p-2,    0x1.5dd73da5bdf3cp-2,  -0x1.f99178p-2, INEXACT)
T(RN,    0x1.6b79820cbb091p-2,    0x1.5d44d348f8b6bp-2,  -0x1.f63c64p-2, INEXACT)
T(RN,    0x1.6ad4e773f964ep-2,    0x1.5cb29c6672077p-2,  -0x1.f74a24p-2, INEXACT)
T(RN,    0x1.6a30976630f12p-2,    0x1.5c2098f7f8f32p-2,  -0x1.f6104ep-2, INEXACT)
T(RN,    0x1.698c91c1a02fcp-2,    0x1.5b8ec8f74e73cp-2,   0x1.f70b6ap-2, INEXACT)
T(RN,    0x1.68e8d66494008p-2,    0x1.5afd2c5e2432bp-2,   0x1.f877c4p-2, INEXACT)
T(RN,    0x1.6845652d690fdp-2,    0x1.5a6bc3261de8bp-2,   0x1.f7dbe4p-2, INEXACT)
T(RN,    0x1.67a23dfa8b397p-2,    0x1.59da8d48d0eb5p-2,   0x1.fa9d74p-2, INEXACT)
T(RN,    0x1.66ff60aa75895p-2,    0x1.59498abfc4473p-2,  -0x1.f5e4b4p-2, INEXACT)
T(RN,    0x1.665ccd1bb2339p-2,    0x1.58b8bb8470d2ap-2,   0x1.ffcf56p-2, INEXACT)
T(RN,    0x1.65ba832cda93ap-2,    0x1.58281f904145ap-2,   0x1.fb76e6p-2, INEXACT)
T(RN,    0x1.651882bc972d4p-2,    0x1.5797b6dc9254bp-2,  -0x1.fe8964p-2, INEXACT)
T(RN,     0x1.6476cba99f8ap-2,    0x1.57078162b2ab6p-2,   0x1.f6259ap-2, INEXACT)
T(RN,    0x1.63d55dd2ba6b2p-2,    0x1.56777f1be3317p-2,  -0x1.fe5f3cp-2, INEXACT)
T(RN,    0x1.63343916bd74fp-2,    0x1.55e7b00156d97p-2,  -0x1.fde48cp-2, INEXACT)
T(RN,    0x1.62935d548d63fp-2,    0x1.5558140c32e8ap-2,  -0x1.f8586ap-2, INEXACT)
T(RN,    0x1.61f2ca6b1dee3p-2,    0x1.54c8ab358ef52p-2,   0x1.f9d67cp-2, INEXACT)
T(RN,    0x1.6152803971c98p-2,    0x1.5439757675043p-2,  -0x1.f792ecp-2, INEXACT)
T(RN,    0x1.60b27e9e9a959p-2,    0x1.53aa72c7e1905p-2,  -0x1.fac0a4p-2, INEXACT)
T(RN,    0x1.6012c579b8d61p-2,    0x1.531ba322c39c6p-2,  -0x1.fa831ep-2, INEXACT)
T(RN,    0x1.5f7354a9fbf3fp-2,     0x1.528d067ffccep-2,  -0x1.f6db1ep-2, INEXACT)
T(RN,     0x1.5ed42c0ea252p-2,    0x1.51fe9cd86198fp-2,   0x1.f88756p-2, INEXACT)
T(RN,    0x1.5e354b86f8ff3p-2,    0x1.51706624b9122p-2,   0x1.f80232p-2, INEXACT)
T(RN,    0x1.5d96b2f25be2dp-2,    0x1.50e2625dbd307p-2,   0x1.f8c544p-2, INEXACT)
T(RN,    0x1.5cf8623035b96p-2,    0x1.5054917c1ae25p-2,   -0x1.fa03bp-2, INEXACT)
T(RN,    0x1.5c5a591ffff96p-2,    0x1.4fc6f378720e8p-2,   0x1.fa7a1ep-2, INEXACT)
T(RN,    0x1.5bbc97a142cb5p-2,    0x1.4f39884b55a4fp-2,   0x1.f6034cp-2, INEXACT)
T(RN,    0x1.5b1f1d939535dp-2,    0x1.4eac4fed4bdf8p-2,  -0x1.fd554ap-2, INEXACT)
T(RN,    0x1.5a81ead69cab8p-2,    0x1.4e1f4a56cdf44p-2,   0x1.fe02b8p-2, INEXACT)
T(RN,    0x1.59e4ff4a0d70ep-2,    0x1.4d9277804888bp-2,  -0x1.fef344p-2, INEXACT)
T(RN,    0x1.59485acdaa60dp-2,    0x1.4d05d7621b95cp-2,  -0x1.f83774p-2, INEXACT)
T(RN,    0x1.58abfd4144f5ap-2,    0x1.4c7969f49a87bp-2,  -0x1.fcdff6p-2, INEXACT)
T(RN,    0x1.580fe684bd2f7p-2,    0x1.4bed2f300c3fcp-2,  -0x1.fa4a56p-2, INEXACT)
T(RN,    0x1.5774167801a62p-2,    0x1.4b61270cab3cap-2,   0x1.ff5b74p-2, INEXACT)
T(RN,    0x1.56d88cfb0f6a5p-2,    0x1.4ad55182a5969p-2,  -0x1.fb5b5ep-2, INEXACT)
T(RN,    0x1.563d49edf2256p-2,     0x1.4a49ae8a1d35p-2,  -0x1.f7e058p-2, INEXACT)
T(RN,    0x1.55a24d30c3d9ap-2,    0x1.49be3e1b27acdp-2,    0x1.f8e16p-2, INEXACT)
T(RN,    0x1.550796a3ad0abp-2,    0x1.4933002dce7cdp-2,   0x1.f74bc2p-2, INEXACT)
T(RN,    0x1.546d2626e4a94p-2,    0x1.48a7f4ba0f13fp-2,   0x1.fa0b54p-2, INEXACT)
T(RN,    0x1.53d2fb9ab0189p-2,     0x1.481d1bb7daeep-2,   0x1.f8aa74p-2, INEXACT)
T(RN,    0x1.533916df62f5bp-2,    0x1.4792751f17789p-2,  -0x1.fc0882p-2, INEXACT)
T(RN,    0x1.529f77d55f4ebp-2,    0x1.470800e79e5cdp-2,  -0x1.fbaddap-2, INEXACT)
T(RN,    0x1.52061e5d15855p-2,    0x1.467dbf093d7ccp-2,   0x1.fd1efap-2, INEXACT)
T(RN,    0x1.516d0a57043b8p-2,    0x1.45f3af7bb6f97p-2,   0x1.fc9336p-2, INEXACT)
T(RN,    0x1.50d43ba3b85e7p-2,    0x1.4569d236c1551p-2,   0x1.fce2e2p-2, INEXACT)
T(RN,    0x1.503bb223cd12ap-2,    0x1.44e0273207787p-2,   0x1.fe7c16p-2, INEXACT)
T(RN,    0x1.4fa36db7ebbf5p-2,    0x1.4456ae6528d51p-2,   0x1.f9c666p-2, INEXACT)
T(RN,    0x1.4f0b6e40cbf1bp-2,    0x1.43cd67c7b962bp-2,  -0x1.fbc0fap-2, INEXACT)
T(RN,    0x1.4e73b39f33654p-2,    0x1.4344535141becp-2,    0x1.fce4dp-2, INEXACT)
T(RN,    0x1.4ddc3db3f5fe6p-2,    0x1.42bb70f93f3e6p-2,   0x1.fb1d18p-2, INEXACT)
T(RN,    0x1.4d450c5ff5b7dp-2,    0x1.4232c0b723f5bp-2,  -0x1.f9213ap-2, INEXACT)
T(RN,    0x1.4cae1f8422acep-2,    0x1.41aa428256d86p-2,  -0x1.fe11f6p-2, INEXACT)
T(RN,    0x1.4c1777017afa1p-2,    0x1.4121f65233b47p-2,   0x1.f61de8p-2, INEXACT)
T(RN,    0x1.4b8112b90ae1cp-2,    0x1.4099dc1e0b6aap-2,  -0x1.f6c642p-2, INEXACT)
T(RN,    0x1.4aeaf28bec89fp-2,    0x1.4011f3dd23ca6p-2,   0x1.f69142p-2, INEXACT)
T(RN,    0x1.4a55165b48313p-2,     0x1.3f8a3d86b7d8p-2,  -0x1.fb8782p-2, INEXACT)
T(RN,    0x1.49bf7e0853febp-2,    0x1.3f02b911f7b96p-2,  -0x1.f7335ep-2, INEXACT)
T(RN,    0x1.492a297454114p-2,    0x1.3e7b667608d9fp-2,  -0x1.f9781cp-2, INEXACT)
T(RN,    0x1.489518809a71ep-2,    0x1.3df445aa05f5fp-2,   0x1.f6ba28p-2, INEXACT)
T(RN,     0x1.48004b0e8707p-2,    0x1.3d6d56a4ff258p-2,  -0x1.f6952ep-2, INEXACT)
T(RN,    0x1.476bc0ff87aeap-2,    0x1.3ce6995dfa0bfp-2,   0x1.f8a474p-2, INEXACT)
T(RN,    0x1.46d77a3517fc2p-2,    0x1.3c600dcbf1b1cp-2,   0x1.f9950ap-2, INEXACT)
T(RN,    0x1.46437690c16abp-2,    0x1.3bd9b3e5d6c9ep-2,   0x1.fc97c6p-2, INEXACT)
T(RN,    0x1.45afb5f41b35fp-2,    0x1.3b538ba28fa47p-2,   0x1.ff83fap-2, INEXACT)
T(RN,    0x1.451c3840ca6d5p-2,    0x1.3acd94f8f8571p-2,   -0x1.f6a74p-2, INEXACT)
T(RN,    0x1.4488fd5881d55p-2,    0x1.3a47cfdfe2b7ep-2,   -0x1.f8a57p-2, INEXACT)
T(RN,    0x1.43f6051d01ee3p-2,    0x1.39c23c4e1679dp-2,  -0x1.f6fb52p-2, INEXACT)
T(RN,    0x1.43634f7018cf7p-2,    0x1.393cda3a51225p-2,   0x1.f82bc4p-2, INEXACT)
T(RN,    0x1.42d0dc33a28dep-2,    0x1.38b7a99b467c5p-2,   0x1.fb40d8p-2, INEXACT)
T(RN,    0x1.423eab498886ap-2,    0x1.3832aa67a00a8p-2,   0x1.f7184ap-2, INEXACT)
T(RN,    0x1.41acbc93c1e7cp-2,    0x1.37addc95fd99ap-2,   -0x1.f6464p-2, INEXACT)
T(RN,    0x1.411b0ff4536adp-2,     0x1.3729401cf518p-2,   -0x1.f9ab9p-2, INEXACT)
T(RN,     0x1.4089a54d4f66p-2,     0x1.36a4d4f312bbp-2,  -0x1.faf70ep-2, INEXACT)
T(RN,    0x1.3ff87c80d5bbep-2,    0x1.36209b0ed906cp-2,  -0x1.fcda74p-2, INEXACT)
T(RN,    0x1.3f67957113d22p-2,    0x1.359c9266c0dbdp-2,  -0x1.fd8392p-2, INEXACT)
T(RN,    0x1.3ed6f00044945p-2,    0x1.3518baf1398fdp-2,  -0x1.f687d8p-2, INEXACT)
T(RN,    0x1.3e468c10b065dp-2,    0x1.349514a4a8f6bp-2,  -0x1.f63a36p-2, INEXACT)
T(RN,    0x1.3db66984ad1e6p-2,    0x1.34119f776b759p-2,  -0x1.f7dd4ep-2, INEXACT)
T(RN,    0x1.3d26883e9e06cp-2,    0x1.338e5b5fd415ap-2,  -0x1.ffcdc4p-2, INEXACT)
T(RN,    0x1.3c96e820f3d4cp-2,    0x1.330b48542c967p-2,   -0x1.f8b1bp-2, INEXACT)
T(RN,    0x1.3c07890e2c75cp-2,    0x1.3288664ab552fp-2,  -0x1.f5c6f8p-2, INEXACT)
T(RN,    0x1.3b786ae8d3d1ep-2,    0x1.3205b539a6097p-2,  -0x1.fd0542p-2, INEXACT)
T(RN,    0x1.3ae98d938235bp-2,    0x1.318335172c7e6p-2,  -0x1.fea892p-2, INEXACT)
T(RN,    0x1.3a5af0f0dde82p-2,    0x1.3100e5d96e04ap-2,  -0x1.f5c672p-2, INEXACT)
T(RN,    0x1.39cc94e39a45bp-2,    0x1.307ec77686c23p-2,  -0x1.f9dbe6p-2, INEXACT)
T(RN,    0x1.393e794e78016p-2,    0x1.2ffcd9e48a012p-2,   0x1.f740ecp-2, INEXACT)
T(RN,    0x1.38b09e1445007p-2,    0x1.2f7b1d198223bp-2,   0x1.f74262p-2, INEXACT)
T(RN,    0x1.38230317dc5d4p-2,    0x1.2ef9910b70bcbp-2,  -0x1.f99c5ep-2, INEXACT)
T(RN,    0x1.3795a83c266e2p-2,    0x1.2e7835b04eab3p-2,    0x1.fbae1p-2, INEXACT)
T(RN,    0x1.37088d6418b36p-2,    0x1.2df70afe0c1edp-2,   -0x1.f68ddp-2, INEXACT)
T(RN,    0x1.367bb272b5d31p-2,     0x1.2d7610ea90aap-2,  -0x1.ff45c6p-2, INEXACT)
T(RN,    0x1.35ef174b0d922p-2,    0x1.2cf5476bbb504p-2,  -0x1.f786cap-2, INEXACT)
T(RN,    0x1.3562bbd03cd7cp-2,    0x1.2c74ae77629ebp-2,  -0x1.f6c97ep-2, INEXACT)
T(RN,    0x1.34d69fe56d79bp-2,    0x1.2bf446035491cp-2,  -0x1.f5f866p-2, INEXACT)
T(RN,    0x1.344ac36dd6debp-2,    0x1.2b740e05573f3p-2,   0x1.f5eb38p-2, INEXACT)
T(RN,    0x1.33bf264cbcbdcp-2,    0x1.2af4067327c4dp-2,   0x1.f9ba76p-2, INEXACT)
T(RN,    0x1.3333c8657040cp-2,    0x1.2a742f427b682p-2,  -0x1.fecd76p-2, INEXACT)
T(RN,    0x1.32a8a99b4f73ep-2,    0x1.29f48868ff26bp-2,  -0x1.f6e4d8p-2, INEXACT)
T(RN,      0x1.321dc9d1c56p-2,    0x1.297511dc57e2ep-2,    0x1.f6f55p-2, INEXACT)
T(RN,    0x1.319328ec4a05cp-2,    0x1.28f5cb9222741p-2,  -0x1.fcf602p-2, INEXACT)
T(RN,     0x1.3108c6ce6246p-2,    0x1.2876b57ff3a66p-2,   0x1.f98e02p-2, INEXACT)
T(RN,    0x1.307ea35b9fe86p-2,    0x1.27f7cf9b58546p-2,   -0x1.fb468p-2, INEXACT)
T(RN,    0x1.2ff4be77a19f7p-2,    0x1.277919d9d5808p-2,   0x1.fb2c18p-2, INEXACT)
T(RN,    0x1.2f6b180612e9cp-2,    0x1.26fa9430e84c4p-2,   0x1.fdf5c8p-2, INEXACT)
T(RN,    0x1.2ee1afeaac1e9p-2,    0x1.267c3e960618fp-2,  -0x1.febc62p-2, INEXACT)
T(RN,    0x1.2e58860932702p-2,    0x1.25fe18fe9c9e4p-2,   0x1.fc0cecp-2, INEXACT)
T(RN,    0x1.2dcf9a4577c65p-2,    0x1.2580236011dbap-2,  -0x1.f6a7c4p-2, INEXACT)
T(RN,    0x1.2d46ec835ad43p-2,    0x1.25025dafc4415p-2,   0x1.f8b7a8p-2, INEXACT)
T(RN,    0x1.2cbe7ca6c7114p-2,    0x1.2484c7e30abd7p-2,  -0x1.fb9b0cp-2, INEXACT)
T(RN,    0x1.2c364a93b49dep-2,    0x1.240761ef34b7dp-2,   0x1.f9f296p-2, INEXACT)
T(RN,    0x1.2bae562e285b3p-2,    0x1.238a2bc98a3b1p-2,  -0x1.f7e3fep-2, INEXACT)
T(RN,    0x1.2b269f5a33c87p-2,    0x1.230d25674be9dp-2,   0x1.fb1c8cp-2, INEXACT)
T(RN,    0x1.2a9f25fbf5166p-2,    0x1.22904ebdb323ap-2,    0x1.f951dp-2, INEXACT)
T(RN,    0x1.2a17e9f797115p-2,    0x1.2213a7c1f2057p-2,   0x1.fe93e8p-2, INEXACT)
T(RN,    0x1.2990eb31511e5p-2,    0x1.21973069337a8p-2,   -0x1.fa866p-2, INEXACT)
T(RN,    0x1.290a298d67394p-2,    0x1.211ae8a89b4ecp-2,  -0x1.f988ecp-2, INEXACT)
T(RN,     0x1.2883a4f029f3p-2,    0x1.209ed0754640ap-2,   0x1.fde97ep-2, INEXACT)
T(RN,    0x1.27fd5d3df659ep-2,     0x1.2022e7c449ffp-2,  -0x1.fd0fb4p-2, INEXACT)
T(RN,    0x1.2777525b35f1fp-2,    0x1.1fa72e8ab5366p-2,   0x1.f6727ap-2, INEXACT)
T(RN,     0x1.26f1842c5f1ap-2,    0x1.1f2ba4bd9000dp-2,   -0x1.f83e8p-2, INEXACT)
T(RN,     0x1.266bf295f415p-2,    0x1.1eb04a51db16dp-2,   0x1.f8f592p-2, INEXACT)
T(RN,    0x1.25e69d7c840eap-2,    0x1.1e351f3c90d27p-2,  -0x1.f6cc7cp-2, INEXACT)
T(RN,    0x1.256184c4aa672p-2,    0x1.1dba2372a49d5p-2,  -0x1.fe1526p-2, INEXACT)
T(RN,    0x1.24dca8530efb8p-2,    0x1.1d3f56e903461p-2,   0x1.ff5cb4p-2, INEXACT)
T(RN,    0x1.2458080c6604ep-2,    0x1.1cc4b99492f58p-2,  -0x1.f6b724p-2, INEXACT)
T(RN,    0x1.23d3a3d5701e9p-2,    0x1.1c4a4b6a33481p-2,  -0x1.ff172ap-2, INEXACT)
T(RN,    0x1.234f7b92fa2e7p-2,    0x1.1bd00c5ebd4aap-2,   0x1.f89132p-2, INEXACT)
T(RN,    0x1.22cb8f29dd7cap-2,    0x1.1b55fc6703a3ap-2,   0x1.fbe6fep-2, INEXACT)
T(RN,    0x1.2247de7eff8e8p-2,    0x1.1adc1b77d2844p-2,    0x1.f6272p-2, INEXACT)
T(RN,    0x1.21c469775234ap-2,    0x1.1a626985efc81p-2,  -0x1.fe4b66p-2, INEXACT)
T(RN,    0x1.21412ff7d3807p-2,    0x1.19e8e6861afedp-2,   0x1.f8ba16p-2, INEXACT)
T(RN,    0x1.20be31e58dbf3p-2,    0x1.196f926d0d7a1p-2,   0x1.fbafe2p-2, INEXACT)
T(RN,    0x1.203b6f2597767p-2,    0x1.18f66d2f7a5d6p-2,   -0x1.f81b2p-2, INEXACT)
T(RN,    0x1.1fb8e79d13516p-2,    0x1.187d76c20e9fcp-2,  -0x1.fde1d4p-2, INEXACT)
T(RN,    0x1.1f369b313032dp-2,    0x1.1804af19712edp-2,   0x1.fa05cep-2, INEXACT)
T(RN,    0x1.1eb489c729193p-2,    0x1.178c162a42e78p-2,  -0x1.fc6dc4p-2, INEXACT)
T(RN,    0x1.1e32b3444522fp-2,    0x1.1713abe91ead5p-2,  -0x1.fb5faep-2, INEXACT)
T(RN,    0x1.1db1178dd7918p-2,    0x1.169b704a997f1p-2,   -0x1.feb6dp-2, INEXACT)
T(RN,    0x1.1d2fb6893fae1p-2,    0x1.1623634342707p-2,  -0x1.f69dc8p-2, INEXACT)
T(RN,    0x1.1cae901be8d1ap-2,    0x1.15ab84c7a2c3ep-2,  -0x1.f9a66ep-2, INEXACT)
T(RN,     0x1.1c2da42b4a6ap-2,    0x1.1533d4cc3e01ap-2,  -0x1.f611dap-2, INEXACT)
T(RN,    0x1.1bacf29ce8019p-2,    0x1.14bc534592116p-2,   0x1.f6c5d4p-2, INEXACT)
T(RN,     0x1.1b2c7b5650d6p-2,    0x1.1445002816ea9p-2,   0x1.f78af6p-2, INEXACT)
T(RN,    0x1.1aac3e3d205b4p-2,    0x1.13cddb683f209p-2,   0x1.faa43ep-2, INEXACT)
T(RN,    0x1.1a2c3b36fdeb1p-2,    0x1.1356e4fa77a9fp-2,   0x1.f6650ap-2, INEXACT)
T(RN,    0x1.19ac72299cc78p-2,    0x1.12e01cd327f4ep-2,  -0x1.fc52acp-2, INEXACT)
T(RN,    0x1.192ce2fabc24bp-2,    0x1.126982e6b2029p-2,  -0x1.f9170ep-2, INEXACT)
T(RN,    0x1.18ad8d902712ep-2,    0x1.11f3172972647p-2,  -0x1.fb264cp-2, INEXACT)
T(RN,    0x1.182e71cfb483fp-2,    0x1.117cd98fc0539p-2,   0x1.f84f94p-2, INEXACT)
T(RN,    0x1.17af8f9f47402p-2,    0x1.1106ca0dedb7bp-2,  -0x1.ff9ce6p-2, INEXACT)
T(RN,    0x1.1730e6e4cde83p-2,    0x1.1090e898473bbp-2,  -0x1.f877c2p-2, INEXACT)
T(RN,     0x1.16b2778642e3p-2,    0x1.101b3523144dbp-2,   0x1.ffda3ep-2, INEXACT)
T(RN,    0x1.16344169ac681p-2,    0x1.0fa5afa2973a9p-2,  -0x1.fdde84p-2, INEXACT)
T(RN,     0x1.15b644751c6ep-2,    0x1.0f30580b0d2ffp-2,   0x1.fc1a08p-2, INEXACT)
T(RN,    0x1.1538808eb0ac4p-2,    0x1.0ebb2e50ae4e8p-2,   0x1.ff3f6ap-2, INEXACT)
T(RN,    0x1.14baf59c928b6p-2,    0x1.0e463267adadap-2,   0x1.fa07f6p-2, INEXACT)
T(RN,    0x1.143da384f7386p-2,    0x1.0dd16444397e9p-2,    0x1.ff49cp-2, INEXACT)
T(RN,    0x1.13c08a2e1f75ep-2,    0x1.0d5cc3da7af25p-2,   0x1.feddacp-2, INEXACT)
T(RN,    0x1.1343a97e57c79p-2,    0x1.0ce8511e96737p-2,  -0x1.fef31ep-2, INEXACT)
T(RN,    0x1.12c7015bf8463p-2,    0x1.0c740c04ab8eap-2,  -0x1.f8ae8ap-2, INEXACT)
T(RN,    0x1.124a91ad64b17p-2,    0x1.0bfff480d5144p-2,  -0x1.f6c0f4p-2, INEXACT)
T(RN,    0x1.11ce5a590c368p-2,    0x1.0b8c0a8728f44p-2,  -0x1.f6567cp-2, INEXACT)
T(RN,    0x1.11525b456a236p-2,    0x1.0b184e0bb8f6ap-2,   0x1.f7b946p-2, INEXACT)
T(RN,    0x1.10d6945904895p-2,    0x1.0aa4bf0291861p-2,   0x1.fed2d6p-2, INEXACT)
T(RN,     0x1.105b057a6d88p-2,    0x1.0a315d5fbaf67p-2,     0x1.f7a1p-2, INEXACT)
T(RN,    0x1.0fdfae9042abap-2,    0x1.09be291738fe7p-2,   0x1.ff8588p-2, INEXACT)
T(RN,    0x1.0f648f812cf03p-2,    0x1.094b221d0acb9p-2,  -0x1.f9799ep-2, INEXACT)
T(RN,    0x1.0ee9a833e0d0bp-2,    0x1.08d848652b217p-2,  -0x1.fbd392p-2, INEXACT)
T(RN,    0x1.0e6ef88f1e458p-2,    0x1.08659be39068dp-2,    0x1.f9789p-2, INEXACT)
T(RN,    0x1.0df48079b0aaep-2,    0x1.07f31c8c2ca87p-2,  -0x1.fc2dccp-2, INEXACT)
T(RN,    0x1.0d7a3fda6ecbbp-2,    0x1.0780ca52eda06p-2,  -0x1.f83bdcp-2, INEXACT)
T(RN,    0x1.0d0036983ad96p-2,    0x1.070ea52bbcd29p-2,    0x1.f62a1p-2, INEXACT)
T(RN,    0x1.0c86649a0261fp-2,    0x1.069cad0a7f8a2p-2,   0x1.f81132p-2, INEXACT)
T(RN,    0x1.0c0cc9c6be508p-2,    0x1.062ae1e316eccp-2,    0x1.fc585p-2, INEXACT)
T(RN,    0x1.0b93660572e38p-2,    0x1.05b943a96001cp-2,   0x1.fe30c2p-2, INEXACT)
T(RN,    0x1.0b1a393d2fabap-2,    0x1.0547d25133c19p-2,   0x1.f9d0eap-2, INEXACT)
T(RN,    0x1.0aa143550f841p-2,    0x1.04d68dce671eep-2,   0x1.fe557cp-2, INEXACT)
T(RN,    0x1.0a288434388ebp-2,    0x1.04657614cb135p-2,  -0x1.f9c3f6p-2, INEXACT)
T(RN,    0x1.09affbc1dc2f7p-2,    0x1.03f48b182cabap-2,  -0x1.f6823ep-2, INEXACT)
T(RN,    0x1.0937a9e53701dp-2,    0x1.0383cccc550dcp-2,   0x1.fdb0f2p-2, INEXACT)
T(RN,    0x1.08bf8e8590de6p-2,    0x1.03133b25098e1p-2,  -0x1.f871e2p-2, INEXACT)
T(RN,    0x1.0847a98a3cca6p-2,    0x1.02a2d6160bb0cp-2,   0x1.fe49aep-2, INEXACT)
T(RN,    0x1.07cffada98f39p-2,    0x1.02329d9319351p-2,   0x1.f921eep-2, INEXACT)
T(RN,    0x1.0758825e0ec92p-2,    0x1.01c2918fec3d5p-2,  -0x1.fdf11ep-2, INEXACT)
T(RN,    0x1.06e13ffc12b15p-2,     0x1.0152b2003b19p-2,  -0x1.ffe454p-2, INEXACT)
T(RN,    0x1.066a339c245a1p-2,    0x1.00e2fed7b8a01p-2,   0x1.feee8ap-2, INEXACT)
T(RN,    0x1.05f35d25ce6eap-2,    0x1.0073780a13fcfp-2,   0x1.fd9978p-2, INEXACT)
T(RN,    0x1.057cbc80a6b83p-2,    0x1.00041d8af8db4p-2,   0x1.f6c81ep-2, INEXACT)
T(RN,    0x1.050651944e075p-2,    0x1.ff29de9c1ec42p-3,  -0x1.f89fe8p-2, INEXACT)
T(RN,    0x1.04901c48704d1p-2,    0x1.fe4bda8df8b6cp-3,   -0x1.f9d2dp-2, INEXACT)
T(RN,    0x1.041a1c84c45cep-2,    0x1.fd6e2ed2c2124p-3,  -0x1.f6e70ap-2, INEXACT)
T(RN,    0x1.03a452310c1f9p-2,    0x1.fc90db51b6c9ap-3,  -0x1.f5cda4p-2, INEXACT)
T(RN,    0x1.032ebd3514703p-2,    0x1.fbb3dff20c1bfp-3,   -0x1.fa0dbp-2, INEXACT)
T(RN,    0x1.02b95d78b52ddp-2,    0x1.fad73c9af0d4ap-3,   0x1.f94506p-2, INEXACT)
T(RN,    0x1.024432e3d1103p-2,    0x1.f9faf1338d18ap-3,   0x1.f9aa16p-2, INEXACT)
T(RN,    0x1.01cf3d5e55ce1p-2,    0x1.f91efda302cd7p-3,   0x1.fea6d6p-2, INEXACT)
T(RN,    0x1.015a7cd03bfa6p-2,     0x1.f84361d06d76p-3,    0x1.ff1afp-2, INEXACT)
T(RN,    0x1.00e5f121870eep-2,    0x1.f7681da2e2652p-3,  -0x1.ffe7cap-2, INEXACT)
T(RN,     0x1.00719a3a4562p-2,    0x1.f68d310170c91p-3,  -0x1.f9ddbep-2, INEXACT)
T(RN,    0x1.fffaf005204a9p-3,    0x1.f5b29bd321c66p-3,   -0x1.f8832p-2, INEXACT)
T(RN,    0x1.ff1314c516919p-3,    0x1.f4d85dfef860ap-3,   0x1.f8da54p-2, INEXACT)
T(RN,    0x1.fe2ba284cb646p-3,    0x1.f3fe776bf1ffcp-3,  -0x1.fd6a92p-2, INEXACT)
T(RN,    0x1.fd449914b1cbcp-3,     0x1.f324e80105ebp-3,    0x1.fa835p-2, INEXACT)
T(RN,    0x1.fc5df845528acp-3,    0x1.f24bafa525db7p-3,  -0x1.faa6dap-2, INEXACT)
T(RN,    0x1.fb77bfe74bd79p-3,    0x1.f172ce3f3dd79p-3,  -0x1.fff952p-2, INEXACT)
T(RN,    0x1.fa91efcb5160ap-3,    0x1.f09a43b634552p-3,   0x1.f9bfe8p-2, INEXACT)
T(RN,    0x1.f9ac87c22c381p-3,    0x1.efc20ff0ea434p-3,  -0x1.fec27ep-2, INEXACT)
T(RN,    0x1.f8c7879cbad51p-3,    0x1.eeea32d63b29bp-3,  -0x1.f72684p-2, INEXACT)
T(RN,    0x1.f7e2ef2bf1129p-3,    0x1.ee12ac4cfd444p-3,   -0x1.f915fp-2, INEXACT)
T(RN,    0x1.f6febe40d805cp-3,    0x1.ed3b7c3c01793p-3,  -0x1.fc83d4p-2, INEXACT)
T(RN,    0x1.f61af4ac8e142p-3,    0x1.ec64a28a138b1p-3,   0x1.f89072p-2, INEXACT)
T(RN,    0x1.f537924046db1p-3,    0x1.eb8e1f1dfa1e6p-3,  -0x1.f68d96p-2, INEXACT)
T(RN,    0x1.f45496cd4b2b3p-3,    0x1.eab7f1de76d2bp-3,  -0x1.f66046p-2, INEXACT)
T(RN,    0x1.f3720224f9012p-3,    0x1.e9e21ab24657fp-3,  -0x1.f9ac18p-2, INEXACT)
T(RN,    0x1.f28fd418c3693p-3,    0x1.e90c99802070bp-3,  -0x1.fb685ep-2, INEXACT)
T(RN,    0x1.f1ae0c7a32911p-3,    0x1.e8376e2eb81f5p-3,  -0x1.f96508p-2, INEXACT)
T(RN,    0x1.f0ccab1ae34b9p-3,    0x1.e76298a4bb4d2p-3,  -0x1.f5dd7cp-2, INEXACT)
T(RN,    0x1.efebafcc891b4p-3,    0x1.e68e18c8d4d45p-3,  -0x1.f841aep-2, INEXACT)
T(RN,    0x1.ef0b1a60e9d45p-3,    0x1.e5b9ee81a87c3p-3,  -0x1.f715f4p-2, INEXACT)
T(RN,    0x1.ee2aeaa9e2085p-3,    0x1.e4e619b5d7424p-3,   0x1.fbe824p-2, INEXACT)
T(RN,    0x1.ed4b207962c2cp-3,    0x1.e4129a4bfd52cp-3,   0x1.fbac4ap-2, INEXACT)
T(RN,    0x1.ec6bbba171e07p-3,    0x1.e33f702ab2778p-3,   0x1.f8233ap-2, INEXACT)
T(RN,    0x1.eb8cbbf42a123p-3,     0x1.e26c9b388a36p-3,   0x1.f8ea64p-2, INEXACT)
T(RN,    0x1.eaae2143bacecp-3,    0x1.e19a1b5c13ddfp-3,   0x1.fd433ap-2, INEXACT)
T(RN,    0x1.e9cfeb626852fp-3,    0x1.e0c7f07bdaa4fp-3,   0x1.f60a46p-2, INEXACT)
T(RN,    0x1.e8f21a228b8a1p-3,    0x1.dff61a7e65abdp-3,   0x1.f8663cp-2, INEXACT)
T(RN,    0x1.e814ad56921f1p-3,    0x1.df24994a382a3p-3,   0x1.fed344p-2, INEXACT)
T(RN,    0x1.e737a4d0fe3f5p-3,    0x1.de536cc5d14ffp-3,   0x1.f8f25cp-2, INEXACT)
T(RN,    0x1.e65b006466d0cp-3,    0x1.dd8294d7ac939p-3,  -0x1.fda132p-2, INEXACT)
T(RN,    0x1.e57ebfe377341p-3,    0x1.dcb2116641931p-3,   -0x1.fcd9cp-2, INEXACT)
T(RN,    0x1.e4a2e320ef626p-3,    0x1.dbe1e258044abp-3,  -0x1.fb9554p-2, INEXACT)
T(RN,    0x1.e3c769efa3c3ep-3,    0x1.db1207936508fp-3,  -0x1.f7f13cp-2, INEXACT)
T(RN,    0x1.e2ec54227d206p-3,    0x1.da4280fed07abp-3,  -0x1.f63054p-2, INEXACT)
T(RN,     0x1.e211a18c793ep-3,    0x1.d9734e80b05c5p-3,   0x1.f633c8p-2, INEXACT)
T(RN,    0x1.e1375200a9467p-3,    0x1.d8a46fff6a0efp-3,    0x1.f8d15p-2, INEXACT)
T(RN,    0x1.e05d6552337d4p-3,    0x1.d7d5e56160528p-3,  -0x1.fb1e3ap-2, INEXACT)
T(RN,    0x1.df83db54522f9p-3,    0x1.d707ae8cf25e3p-3,  -0x1.fe9eb8p-2, INEXACT)
T(RN,    0x1.deaab3da540c8p-3,    0x1.d639cb687c4e4p-3,  -0x1.fba236p-2, INEXACT)
T(RN,    0x1.ddd1eeb79be76p-3,    0x1.d56c3bda5703ep-3,   -0x1.f61b3p-2, INEXACT)
T(RN,    0x1.dcf98bbfa0d82p-3,    0x1.d49effc8d85e1p-3,   0x1.f5cee4p-2, INEXACT)
T(RN,    0x1.dc218ac5ee18fp-3,    0x1.d3d2171a5332dp-3,   0x1.f6a04ap-2, INEXACT)
T(RN,    0x1.db49eb9e230bfp-3,    0x1.d30581b5176ecp-3,   -0x1.fb77fp-2, INEXACT)
T(RN,    0x1.da72ae1bf3295p-3,    0x1.d2393f7f721e1p-3,   0x1.f86f1cp-2, INEXACT)
T(RN,    0x1.d99bd21325f68p-3,    0x1.d16d505fad7d4p-3,   -0x1.f9442p-2, INEXACT)
T(RN,    0x1.d8c557579703bp-3,    0x1.d0a1b43c11115p-3,   0x1.ffe604p-2, INEXACT)
T(RN,    0x1.d7ef3dbd35e08p-3,    0x1.cfd66afae1b59p-3,  -0x1.f70f4ap-2, INEXACT)
T(RN,    0x1.d71985180606dp-3,    0x1.cf0b748261a1ep-3,   -0x1.f662ep-2, INEXACT)
T(RN,    0x1.d6442d3c1eef5p-3,    0x1.ce40d0b8d096ep-3,  -0x1.f91bfep-2, INEXACT)
T(RN,    0x1.d56f35fdabc7ep-3,    0x1.cd767f846bb1ap-3,   0x1.f67b32p-2, INEXACT)
T(RN,    0x1.d49a9f30ebf39p-3,    0x1.ccac80cb6dfe1p-3,   0x1.fcace8p-2, INEXACT)
T(RN,    0x1.d3c668aa3236ep-3,    0x1.cbe2d4740fc74p-3,   0x1.fc9b2cp-2, INEXACT)
T(RN,    0x1.d2f2923de5613p-3,    0x1.cb197a6487511p-3,    0x1.f90c3p-2, INEXACT)
T(RN,     0x1.d21f1bc07ff1p-3,    0x1.ca5072830899fp-3,   0x1.fe16e4p-2, INEXACT)
T(RN,    0x1.d14c0506901e3p-3,    0x1.c987bcb5c57d6p-3,   0x1.f9c77cp-2, INEXACT)
T(RN,    0x1.d0794de4b7c42p-3,    0x1.c8bf58e2edb7dp-3,   0x1.fa2b22p-2, INEXACT)
T(RN,    0x1.cfa6f62fac683p-3,    0x1.c7f746f0af056p-3,   0x1.f5d394p-2, INEXACT)
T(RN,    0x1.ced4fdbc37309p-3,    0x1.c72f86c53531ap-3,   0x1.fc6d2ep-2, INEXACT)
T(RN,     0x1.ce03645f34c3p-3,    0x1.c6681846aa105p-3,   0x1.ff733cp-2, INEXACT)
T(RN,    0x1.cd3229ed95634p-3,    0x1.c5a0fb5b35b2ap-3,    0x1.fe5f1p-2, INEXACT)
T(RN,    0x1.cc614e3c5cc63p-3,    0x1.c4da2fe8fe54ap-3,   -0x1.fe849p-2, INEXACT)
T(RN,    0x1.cb90d120a21b9p-3,    0x1.c413b5d6287eep-3,  -0x1.f78bd4p-2, INEXACT)
T(RN,     0x1.cac0b26f900dp-3,    0x1.c34d8d08d71d2p-3,  -0x1.f89d54p-2, INEXACT)
T(RN,    0x1.c9f0f1fe648bfp-3,    0x1.c287b5672b66ep-3,   0x1.f5c514p-2, INEXACT)
T(RN,    0x1.c9218fa27129bp-3,    0x1.c1c22ed7454acp-3,   0x1.fdea36p-2, INEXACT)
T(RN,    0x1.c8528b311a6d9p-3,    0x1.c0fcf93f42e4dp-3,   0x1.f656c8p-2, INEXACT)
T(RN,    0x1.c783e47fd86afp-3,    0x1.c03814854124ep-3,   0x1.f9c734p-2, INEXACT)
T(RN,    0x1.c6b59b64366e1p-3,    0x1.bf73808f5b96ep-3,   0x1.f5f26ap-2, INEXACT)
T(RN,    0x1.c5e7afb3d2edbp-3,    0x1.beaf3d43ac6cap-3,   0x1.fa3556p-2, INEXACT)
T(RN,    0x1.c51a21445fa14p-3,    0x1.bdeb4a884caa4p-3,  -0x1.f84e12p-2, INEXACT)
T(RN,    0x1.c44cefeba15eap-3,    0x1.bd27a843541d2p-3,   0x1.fc3faep-2, INEXACT)
T(RN,    0x1.c3801b7f701f5p-3,    0x1.bc64565ad9776p-3,   0x1.f709e8p-2, INEXACT)
T(RN,    0x1.c2b3a3d5b6fa3p-3,    0x1.bba154b4f2619p-3,   -0x1.fc0fap-2, INEXACT)
T(RN,    0x1.c1e788c474086p-3,    0x1.badea337b377cp-3,  -0x1.f6049ep-2, INEXACT)
T(RN,    0x1.c11bca21b8737p-3,    0x1.ba1c41c9306dap-3,  -0x1.f65f78p-2, INEXACT)
T(RN,     0x1.c05067c3a85dp-3,    0x1.b95a304f7c0e5p-3,  -0x1.fbd5e4p-2, INEXACT)
T(RN,    0x1.bf8561807ad07p-3,    0x1.b8986eb0a8456p-3,  -0x1.f68f66p-2, INEXACT)
T(RN,    0x1.bebab72e79ed8p-3,    0x1.b7d6fcd2c65e3p-3,   0x1.f5ed26p-2, INEXACT)
T(RN,    0x1.bdf068a40298cp-3,    0x1.b715da9be6ce4p-3,  -0x1.fb117cp-2, INEXACT)
T(RN,    0x1.bd2675b7847c9p-3,    0x1.b65507f2194d4p-3,   0x1.fce218p-2, INEXACT)
T(RN,    0x1.bc5cde3f823afp-3,    0x1.b59484bb6d1a1p-3,  -0x1.f5d9cep-2, INEXACT)
T(RN,    0x1.bb93a21291312p-3,    0x1.b4d450ddf0d86p-3,      0x1.f9ap-2, INEXACT)
T(RN,    0x1.bacac1075989ep-3,    0x1.b4146c3fb2b76p-3,   0x1.f6b112p-2, INEXACT)
T(RN,    0x1.ba023af496143p-3,    0x1.b354d6c6c0612p-3,    0x1.fe6b4p-2, INEXACT)
T(RN,    0x1.b93a0fb11460ep-3,    0x1.b2959059272c8p-3,   0x1.f9eacap-2, INEXACT)
T(RN,    0x1.b8723f13b49f5p-3,    0x1.b1d698dcf4118p-3,   0x1.fe14fep-2, INEXACT)
T(RN,    0x1.b7aac8f369a09p-3,    0x1.b117f03833c21p-3,   0x1.fe2442p-2, INEXACT)
T(RN,    0x1.b6e3ad2738d61p-3,    0x1.b0599650f2be8p-3,  -0x1.f6000cp-2, INEXACT)
T(RN,    0x1.b61ceb863a304p-3,    0x1.af9b8b0d3d4b8p-3,   -0x1.fc5c5p-2, INEXACT)
T(RN,    0x1.b55683e7982d1p-3,    0x1.aeddce531f953p-3,  -0x1.f871b6p-2, INEXACT)
T(RN,    0x1.b49076228fd35p-3,    0x1.ae206008a5c08p-3,   0x1.f5f2bep-2, INEXACT)
T(RN,    0x1.b3cac20e70928p-3,    0x1.ad634013dbe18p-3,   0x1.fa9712p-2, INEXACT)
T(RN,    0x1.b30567829c3f9p-3,    0x1.aca66e5ace0dfp-3,   0x1.fa9d88p-2, INEXACT)
T(RN,    0x1.b24066568728cp-3,    0x1.abe9eac388854p-3,   0x1.fa48fap-2, INEXACT)
T(RN,    0x1.b17bbe61b7ed9p-3,    0x1.ab2db534179f6p-3,   -0x1.fd45ap-2, INEXACT)
T(RN,    0x1.b0b76f7bc77fep-3,    0x1.aa71cd9287e32p-3,  -0x1.fe5816p-2, INEXACT)
T(RN,    0x1.aff3797c6124dp-3,    0x1.a9b633c4e61bbp-3,   0x1.fbe746p-2, INEXACT)
T(RN,    0x1.af2fdc3b425f1p-3,    0x1.a8fae7b13f58cp-3,   0x1.f79f66p-2, INEXACT)
T(RN,     0x1.ae6c97903af3p-3,    0x1.a83fe93da1078p-3,  -0x1.f8f1c2p-2, INEXACT)
T(RN,    0x1.ada9ab532cd13p-3,    0x1.a785385018f2dp-3,   0x1.fc3cbep-2, INEXACT)
T(RN,    0x1.ace7175c0c183p-3,    0x1.a6cad4ceb5591p-3,   0x1.ff5936p-2, INEXACT)
T(RN,    0x1.ac24db82df083p-3,    0x1.a610be9f84f56p-3,  -0x1.fa24aep-2, INEXACT)
T(RN,    0x1.ab62f79fbe00cp-3,    0x1.a556f5a89711fp-3,   0x1.fe2b5ep-2, INEXACT)
T(RN,    0x1.aaa16b8ad36dap-3,    0x1.a49d79cffb897p-3,   0x1.fe0424p-2, INEXACT)
T(RN,    0x1.a9e0371c5bc64p-3,    0x1.a3e44afbc2db7p-3,   -0x1.fc6dep-2, INEXACT)
T(RN,    0x1.a91f5a2ca5857p-3,    0x1.a32b6911fe389p-3,  -0x1.f8f3acp-2, INEXACT)
T(RN,    0x1.a85ed494111d8p-3,    0x1.a272d3f8bf8afp-3,  -0x1.f5e478p-2, INEXACT)
T(RN,    0x1.a79ea62b10f66p-3,    0x1.a1ba8b961988cp-3,   0x1.f72696p-2, INEXACT)
T(RN,    0x1.a6dececa295ddp-3,    0x1.a1028fd01fb8bp-3,   -0x1.f88fap-2, INEXACT)
T(RN,    0x1.a61f4e49f0844p-3,    0x1.a04ae08ce6838p-3,   0x1.fb8f56p-2, INEXACT)
T(RN,    0x1.a56024830e724p-3,    0x1.9f937db2833ccp-3,  -0x1.f788f2p-2, INEXACT)
T(RN,    0x1.a4a1514e3d047p-3,    0x1.9edc67270c339p-3,  -0x1.f9e94ap-2, INEXACT)
T(RN,    0x1.a3e2d48447d9ap-3,    0x1.9e259cd098b47p-3,  -0x1.fbe734p-2, INEXACT)
T(RN,    0x1.a324adfe0c622p-3,    0x1.9d6f1e95412bdp-3,  -0x1.f88d36p-2, INEXACT)
T(RN,    0x1.a266dd9479b25p-3,    0x1.9cb8ec5b1f0dep-3,  -0x1.fb6d4cp-2, INEXACT)
T(RN,    0x1.a1a96320909a7p-3,    0x1.9c0306084d00ep-3,   0x1.ff6fdap-2, INEXACT)
T(RN,    0x1.a0ec3e7b63929p-3,    0x1.9b4d6b82e6dcfp-3,   0x1.f7e132p-2, INEXACT)
T(RN,    0x1.a02f6f7e16b8cp-3,    0x1.9a981cb109bdfp-3,   0x1.f9b52ap-2, INEXACT)
T(RN,    0x1.9f72f601dfbbep-3,     0x1.99e31978d402p-3,  -0x1.fbb17cp-2, INEXACT)
T(RN,    0x1.9eb6d1e005df2p-3,    0x1.992e61c065604p-3,  -0x1.faba16p-2, INEXACT)
T(RN,    0x1.9dfb02f1e1ed7p-3,    0x1.9879f56ddeef6p-3,  -0x1.fbfa4cp-2, INEXACT)
T(RN,    0x1.9d3f8910de344p-3,    0x1.97c5d4676333dp-3,   0x1.f8cdf4p-2, INEXACT)
T(RN,     0x1.9c846416767ep-3,     0x1.9711fe93162dp-3,   0x1.fbf5ccp-2, INEXACT)
T(RN,    0x1.9bc993dc37ff3p-3,    0x1.965e73d71d564p-3,  -0x1.fe1728p-2, INEXACT)
T(RN,    0x1.9b0f183bc157fp-3,    0x1.95ab34199fbafp-3,  -0x1.f7bbcep-2, INEXACT)
T(RN,     0x1.9a54f10ec292p-3,    0x1.94f83f40c606ep-3,  -0x1.f63478p-2, INEXACT)
T(RN,    0x1.999b1e2efb064p-3,    0x1.94459532b8935p-3,  -0x1.f5c2e6p-2, INEXACT)
T(RN,    0x1.98e19f764362cp-3,    0x1.939335d5a91cbp-3,  -0x1.f69124p-2, INEXACT)
T(RN,    0x1.982874be799a4p-3,    0x1.92e1210fbf8a2p-3,    0x1.f717ep-2, INEXACT)
T(RN,    0x1.976f9de194f49p-3,    0x1.922f56c72d4a4p-3,  -0x1.f741dep-2, INEXACT)
T(RN,    0x1.96b71ab99bd9ep-3,    0x1.917dd6e22395ep-3,   0x1.fc2fdep-2, INEXACT)
T(RN,    0x1.95feeb20a5f92p-3,    0x1.90cca146d5928p-3,   0x1.f94176p-2, INEXACT)
T(RN,    0x1.95470ef0dc1eep-3,    0x1.901bb5db783d7p-3,  -0x1.fa7d84p-2, INEXACT)
T(RN,    0x1.948f860478474p-3,     0x1.8f6b1486428fp-3,  -0x1.fe1772p-2, INEXACT)
T(RN,    0x1.93d85035c5791p-3,    0x1.8ebabd2d6d68ap-3,  -0x1.ff6186p-2, INEXACT)
T(RN,    0x1.93216d5f1fe11p-3,    0x1.8e0aafb733c13p-3,   -0x1.fcf3ep-2, INEXACT)
T(RN,    0x1.926add5af4b12p-3,    0x1.8d5aec09d2973p-3,   0x1.fc6816p-2, INEXACT)
T(RN,    0x1.91b4a003c2113p-3,    0x1.8cab720b88f3ap-3,  -0x1.ff32b2p-2, INEXACT)
T(RN,    0x1.90feb53417367p-3,    0x1.8bfc41a298129p-3,   -0x1.f6944p-2, INEXACT)
T(RN,    0x1.90491cc694464p-3,    0x1.8b4d5ab543581p-3,  -0x1.fdb70cp-2, INEXACT)
T(RN,    0x1.8f93d695ea504p-3,    0x1.8a9ebd29d05c5p-3,   0x1.f6da48p-2, INEXACT)
T(RN,    0x1.8edee27cdb4edp-3,    0x1.89f068e686fd2p-3,  -0x1.fc9da2p-2, INEXACT)
T(RN,    0x1.8e2a40563a0f4p-3,     0x1.89425dd1b159p-3,    0x1.fe2f5p-2, INEXACT)
T(RN,    0x1.8d75effcea415p-3,    0x1.88949bd19bee7p-3,    0x1.fd192p-2, INEXACT)
T(RN,     0x1.8cc1f14be05dp-3,    0x1.87e722cc95949p-3,    0x1.fd969p-2, INEXACT)
T(RN,    0x1.8c0e441e21a02p-3,    0x1.8739f2a8ef899p-3,    0x1.f65fep-2, INEXACT)
T(RN,    0x1.8b5ae84ec4068p-3,    0x1.868d0b4cfd7c3p-3,  -0x1.fa7c6cp-2, INEXACT)
T(RN,    0x1.8aa7ddb8ee3fdp-3,    0x1.85e06c9f15933p-3,   -0x1.f844bp-2, INEXACT)
T(RN,    0x1.89f52437d7b38p-3,    0x1.853416859081ap-3,   0x1.f6210ep-2, INEXACT)
T(RN,    0x1.8942bba6c8a25p-3,    0x1.848808e6c9b81p-3,   0x1.f6ba9ep-2, INEXACT)
T(RN,    0x1.8890a3e119766p-3,    0x1.83dc43a91ecbfp-3,   0x1.fd12cap-2, INEXACT)
T(RN,    0x1.87dedcc2338fcp-3,    0x1.8330c6b2f04d4p-3,   0x1.fa04aap-2, INEXACT)
T(RN,    0x1.872d662590ce6p-3,    0x1.828591eaa1655p-3,  -0x1.f88e54p-2, INEXACT)
T(RN,    0x1.867c3fe6bb909p-3,    0x1.81daa53697e61p-3,  -0x1.fff202p-2, INEXACT)
T(RN,    0x1.85cb69e14ec01p-3,    0x1.8130007d3c66dp-3,    0x1.fa6b7p-2, INEXACT)
T(RN,    0x1.851ae3f0f5c07p-3,    0x1.8085a3a4fa43ap-3,    0x1.f7ba1p-2, INEXACT)
T(RN,    0x1.846aadf16c663p-3,    0x1.7fdb8e943fa55p-3,  -0x1.f5e632p-2, INEXACT)
T(RN,    0x1.83bac7be7ef4ap-3,    0x1.7f31c1317d8fap-3,   -0x1.f788dp-2, INEXACT)
T(RN,    0x1.830b313407c07p-3,    0x1.7e883b6325a89p-3,  -0x1.f5c2c2p-2, INEXACT)
T(RN,    0x1.825bea2dfadd8p-3,    0x1.7ddefd0fb58f7p-3,  -0x1.fdf05ep-2, INEXACT)
T(RN,    0x1.81acf2884e902p-3,    0x1.7d36061da02e1p-3,  -0x1.fa528cp-2, INEXACT)
T(RN,    0x1.80fe4a1f12dd8p-3,    0x1.7c8d567364893p-3,   0x1.f89dbap-2, INEXACT)
T(RN,    0x1.804ff0ce65c12p-3,    0x1.7be4edf7826dbp-3,   0x1.fcadeap-2, INEXACT)
T(RN,    0x1.7fa1e6727565dp-3,    0x1.7b3ccc907ca61p-3,  -0x1.ffbdc6p-2, INEXACT)
T(RN,    0x1.7ef42ae780386p-3,    0x1.7a94f224d91c4p-3,  -0x1.f9d8c8p-2, INEXACT)
T(RN,    0x1.7e46be09d4d91p-3,    0x1.79ed5e9b20dafp-3,  -0x1.f6c6eep-2, INEXACT)
T(RN,    0x1.7d999fb5d2019p-3,    0x1.794611d9e0045p-3,  -0x1.f6ced6p-2, INEXACT)
T(RN,    0x1.7ceccfc7e6abdp-3,    0x1.789f0bc7a6071p-3,   -0x1.ff985p-2, INEXACT)
T(RN,    0x1.7c404e1c91d0ap-3,    0x1.77f84c4b056ecp-3,   0x1.fb328ep-2, INEXACT)
T(RN,    0x1.7b941a9062811p-3,    0x1.7751d34a940b8p-3,   0x1.f9622cp-2, INEXACT)
T(RN,    0x1.7ae834fff7facp-3,    0x1.76aba0aceb156p-3,   0x1.fdb9dep-2, INEXACT)
T(RN,    0x1.7a3c9d4801527p-3,    0x1.7605b458a6e8cp-3,  -0x1.fec8aap-2, INEXACT)
T(RN,    0x1.799153453db6ep-3,    0x1.75600e3467568p-3,   -0x1.f8696p-2, INEXACT)
T(RN,    0x1.78e656d47c465p-3,    0x1.74baae26cf89cp-3,   0x1.f772aap-2, INEXACT)
T(RN,    0x1.783ba7d29c134p-3,    0x1.74159416861b9p-3,   0x1.f8ee06p-2, INEXACT)
T(RN,    0x1.7791461c8c15bp-3,     0x1.7370bfea3514p-3,   0x1.f835f2p-2, INEXACT)
T(RN,    0x1.76e7318f4b206p-3,    0x1.72cc318889ee6p-3,  -0x1.f99baap-2, INEXACT)
T(RN,    0x1.763d6a07e7f0ap-3,    0x1.7227e8d835b7cp-3,   -0x1.f5f9ap-2, INEXACT)
T(RN,    0x1.7593ef63810a6p-3,    0x1.7183e5bfecfaap-3,  -0x1.fb9538p-2, INEXACT)
T(RN,    0x1.74eac17f44b67p-3,    0x1.70e0282667cc5p-3,   0x1.fa789cp-2, INEXACT)
T(RN,    0x1.7441e038711c3p-3,    0x1.703caff261f43p-3,   0x1.fa1dccp-2, INEXACT)
T(RN,    0x1.73994b6c54058p-3,    0x1.6f997d0a9ac09p-3,   0x1.fdc384p-2, INEXACT)
T(RN,    0x1.72f102f84afc2p-3,    0x1.6ef68f55d5316p-3,  -0x1.fe5fcap-2, INEXACT)
T(RN,    0x1.724906b9c3423p-3,    0x1.6e53e6bad7ffdp-3,   0x1.ff0e46p-2, INEXACT)
T(RN,    0x1.71a1568e39aefp-3,    0x1.6db183206d89fp-3,  -0x1.faa6aep-2, INEXACT)
T(RN,    0x1.70f9f2533ace5p-3,    0x1.6d0f646d64008p-3,  -0x1.f7b782p-2, INEXACT)
T(RN,    0x1.7052d9e662b5ap-3,    0x1.6c6d8a888d4aap-3,   -0x1.f7c74p-2, INEXACT)
T(RN,    0x1.6fac0d255d2d7p-3,    0x1.6bcbf558bf3cfp-3,   -0x1.f6b69p-2, INEXACT)
T(RN,    0x1.6f058bede553dp-3,    0x1.6b2aa4c4d34cfp-3,   0x1.fe900ap-2, INEXACT)
T(RN,    0x1.6e5f561dc5f65p-3,    0x1.6a8998b3a6f61p-3,   0x1.febe26p-2, INEXACT)
T(RN,    0x1.6db96b92d9561p-3,    0x1.69e8d10c1b8e1p-3,   0x1.f8fdc2p-2, INEXACT)
T(RN,    0x1.6d13cc2b0923dp-3,    0x1.69484db5164efp-3,   0x1.fa11fap-2, INEXACT)
T(RN,    0x1.6c6e77c44e881p-3,    0x1.68a80e95806ccp-3,  -0x1.fcd8dep-2, INEXACT)
T(RN,    0x1.6bc96e3cb2131p-3,    0x1.6808139447144p-3,  -0x1.f9a32cp-2, INEXACT)
T(RN,    0x1.6b24af724bb0dp-3,    0x1.67685c985b6cbp-3,  -0x1.f86658p-2, INEXACT)
T(RN,    0x1.6a803b4342b38p-3,    0x1.66c8e988b2affp-3,  -0x1.fa66e8p-2, INEXACT)
T(RN,    0x1.69dc118dcda6ap-3,    0x1.6629ba4c460cbp-3,   0x1.f64bfap-2, INEXACT)
T(RN,    0x1.6938323032979p-3,    0x1.658aceca12fa3p-3,   0x1.f71fb2p-2, INEXACT)
T(RN,    0x1.68949d08c6a05p-3,    0x1.64ec26e91ad48p-3,   0x1.fc4848p-2, INEXACT)
T(RN,    0x1.67f151f5ee3aap-3,    0x1.644dc290633a5p-3,  -0x1.f63bd2p-2, INEXACT)
T(RN,    0x1.674e50d61d068p-3,     0x1.63afa1a6f5e3p-3,   0x1.fcea24p-2, INEXACT)
T(RN,    0x1.66ab9987d5ea6p-3,    0x1.6311c413e0ca9p-3,  -0x1.faee1ep-2, INEXACT)
T(RN,    0x1.66092be9aae17p-3,    0x1.627429be360fap-3,  -0x1.f8c248p-2, INEXACT)
T(RN,    0x1.656707da3d1e4p-3,    0x1.61d6d28d0c21ap-3,  -0x1.ff0712p-2, INEXACT)
T(RN,     0x1.64c52d383cd5p-3,    0x1.6139be677d9a3p-3,  -0x1.f72834p-2, INEXACT)
T(RN,    0x1.64239be2697bfp-3,    0x1.609ced34a988dp-3,   0x1.f77024p-2, INEXACT)
T(RN,    0x1.638253b7916b8p-3,    0x1.60005edbb322bp-3,   0x1.f98aeep-2, INEXACT)
T(RN,    0x1.62e15496921f1p-3,    0x1.5f641343c20eep-3,  -0x1.f68168p-2, INEXACT)
T(RN,    0x1.62409e5e57ff2p-3,    0x1.5ec80a54023f2p-3,   0x1.f91aaep-2, INEXACT)
T(RN,    0x1.61a030edde837p-3,    0x1.5e2c43f3a41d6p-3,   0x1.fbbebap-2, INEXACT)
T(RN,    0x1.61000c24300bdp-3,    0x1.5d90c009dc733p-3,   0x1.fcbde8p-2, INEXACT)
T(RN,    0x1.60602fe065e6ap-3,    0x1.5cf57e7de47c9p-3,   0x1.ff7c0ep-2, INEXACT)
T(RN,    0x1.5fc09c01a84c9p-3,    0x1.5c5a7f36f9f0ap-3,   0x1.fd041ep-2, INEXACT)
T(RN,    0x1.5f2150672e3e1p-3,    0x1.5bbfc21c5eeccp-3,   0x1.f5ea08p-2, INEXACT)
T(RN,    0x1.5e824cf03de88p-3,    0x1.5b2547155a638p-3,   0x1.fd04fap-2, INEXACT)
T(RN,    0x1.5de3917c2bcbep-3,    0x1.5a8b0e0937552p-3,     0x1.f6c6p-2, INEXACT)
T(RN,    0x1.5d451dea5b89bp-3,     0x1.59f116df45a5p-3,  -0x1.fa3bb8p-2, INEXACT)
T(RN,    0x1.5ca6f21a3f73fp-3,    0x1.5957617ed9b8ap-3,   0x1.ffec8ep-2, INEXACT)
T(RN,    0x1.5c090deb58977p-3,    0x1.58bdedcf4c8d6p-3,  -0x1.fd46c2p-2, INEXACT)
T(RN,    0x1.5b6b713d36bafp-3,    0x1.5824bbb7fbc4fp-3,   0x1.fa236cp-2, INEXACT)
T(RN,    0x1.5ace1bef7853ep-3,    0x1.578bcb2049a5bp-3,  -0x1.f8dba6p-2, INEXACT)
T(RN,     0x1.5a310de1ca86p-3,    0x1.56f31bef9d279p-3,   0x1.fcf462p-2, INEXACT)
T(RN,    0x1.599446f3e911fp-3,    0x1.565aae0d61ee6p-3,   0x1.f9d886p-2, INEXACT)
T(RN,    0x1.58f7c7059e5c2p-3,    0x1.55c28161085d6p-3,   0x1.fdef58p-2, INEXACT)
T(RN,     0x1.585b8df6c357p-3,    0x1.552a95d2058ddp-3,   0x1.f6b564p-2, INEXACT)
T(RN,    0x1.57bf9ba73f88ap-3,    0x1.5492eb47d3608p-3,   0x1.fd1322p-2, INEXACT)
T(RN,    0x1.5723eff709076p-3,    0x1.53fb81a9f0868p-3,  -0x1.f92736p-2, INEXACT)
T(RN,    0x1.56888ac624629p-3,    0x1.536458dfe0769p-3,  -0x1.f63484p-2, INEXACT)
T(RN,     0x1.55ed6bf4a4a2p-3,    0x1.52cd70d12b783p-3,  -0x1.fa0e2ap-2, INEXACT)
T(RN,    0x1.55529362ab4cep-3,    0x1.5236c9655eb67p-3,   0x1.f6100cp-2, INEXACT)
T(RN,    0x1.54b800f068533p-3,    0x1.51a062840c357p-3,   0x1.fd5102p-2, INEXACT)
T(RN,    0x1.541db47e1a107p-3,    0x1.510a3c14cae11p-3,   0x1.f96308p-2, INEXACT)
T(RN,    0x1.5383adec0d3cbp-3,    0x1.507455ff3689cp-3,   -0x1.fc8d2p-2, INEXACT)
T(RN,      0x1.52e9ed1a9cfp-3,    0x1.4fdeb02aeff3cp-3,  -0x1.fe574ep-2, INEXACT)
T(RN,    0x1.525071ea32967p-3,    0x1.4f494a7f9cd6ap-3,   -0x1.f83c8p-2, INEXACT)
T(RN,    0x1.51b73c3b45e64p-3,    0x1.4eb424e4e7df7p-3,  -0x1.fd46c4p-2, INEXACT)
T(RN,    0x1.511e4bee5ce03p-3,    0x1.4e1f3f4280bc8p-3,   0x1.fb667ep-2, INEXACT)
T(RN,     0x1.5085a0e40bc9p-3,    0x1.4d8a99801c222p-3,   -0x1.fc7dbp-2, INEXACT)
T(RN,    0x1.4fed3afcf519bp-3,    0x1.4cf6338573c75p-3,   0x1.fa9f06p-2, INEXACT)
T(RN,    0x1.4f551a19c9838p-3,    0x1.4c620d3a46741p-3,   0x1.fd3a98p-2, INEXACT)
T(RN,    0x1.4ebd3e1b47e81p-3,    0x1.4bce268658059p-3,  -0x1.fc0038p-2, INEXACT)
T(RN,    0x1.4e25a6e23d462p-3,    0x1.4b3a7f517166ap-3,    0x1.ff72ep-2, INEXACT)
T(RN,    0x1.4d8e544f84cfap-3,    0x1.4aa7178360afbp-3,  -0x1.fc39fap-2, INEXACT)
T(RN,    0x1.4cf7464407bc9p-3,    0x1.4a13ef03f906dp-3,  -0x1.f7a178p-2, INEXACT)
T(RN,    0x1.4c607ca0bd61fp-3,    0x1.498105bb12c06p-3,  -0x1.f5d7acp-2, INEXACT)
T(RN,    0x1.4bc9f746ab33ap-3,    0x1.48ee5b908b6c4p-3,   0x1.f686bep-2, INEXACT)
T(RN,    0x1.4b33b616e4876p-3,     0x1.485bf06c45a5p-3,   0x1.ffa16ep-2, INEXACT)
T(RN,    0x1.4a9db8f28ad41p-3,    0x1.47c9c4362958cp-3,    0x1.fe2fcp-2, INEXACT)
T(RN,    0x1.4a07ffbacd7f9p-3,    0x1.4737d6d623a2ep-3,  -0x1.f6900ap-2, INEXACT)
T(RN,    0x1.49728a50e9e21p-3,    0x1.46a6283426da5p-3,  -0x1.fdbd4ap-2, INEXACT)
T(RN,    0x1.48dd58962b4d2p-3,    0x1.4614b8382aa2dp-3,  -0x1.faadf2p-2, INEXACT)
T(RN,    0x1.48486a6beae89p-3,    0x1.458386ca2bd5bp-3,   0x1.f6aca4p-2, INEXACT)
T(RN,    0x1.47b3bfb38fc1ep-3,    0x1.44f293d22c9b3p-3,   0x1.f6dafep-2, INEXACT)
T(RN,    0x1.471f584e8ee63p-3,    0x1.4461df38348ecp-3,   0x1.feb1acp-2, INEXACT)
T(RN,    0x1.468b341e6af82p-3,    0x1.43d168e45061cp-3,  -0x1.fb491ep-2, INEXACT)
T(RN,    0x1.45f75304b4938p-3,    0x1.434130be92479p-3,   0x1.fe5a22p-2, INEXACT)
T(RN,    0x1.4563b4e30a13fp-3,    0x1.42b136af11c76p-3,   -0x1.fbf97p-2, INEXACT)
T(RN,    0x1.44d0599b17955p-3,    0x1.42217a9debc7ep-3,  -0x1.f8cb02p-2, INEXACT)
T(RN,    0x1.443d410e96ed9p-3,    0x1.4191fc734292ep-3,  -0x1.f61712p-2, INEXACT)
T(RN,    0x1.43aa6b1f4fb12p-3,    0x1.4102bc173de45p-3,   0x1.fc2bb2p-2, INEXACT)
T(RN,     0x1.4317d7af1717p-3,    0x1.4073b9720ad8ep-3,  -0x1.fe54fap-2, INEXACT)
T(RN,    0x1.4285869fd0087p-3,    0x1.3fe4f46bdc082p-3,  -0x1.f5eb02p-2, INEXACT)
T(RN,    0x1.41f377d36b106p-3,    0x1.3f566cece97dfp-3,   0x1.f8f974p-2, INEXACT)
T(RN,    0x1.4161ab2be6587p-3,    0x1.3ec822dd70c1bp-3,  -0x1.f8b522p-2, INEXACT)
T(RN,    0x1.40d0208b4d98ep-3,    0x1.3e3a1625b4d13p-3,  -0x1.f6635ep-2, INEXACT)
T(RN,     0x1.403ed7d3ba24p-3,    0x1.3dac46adfe354p-3,  -0x1.f5cb7cp-2, INEXACT)
T(RN,    0x1.3fadd0e752d29p-3,    0x1.3d1eb45e9af8dp-3,  -0x1.f6cfdep-2, INEXACT)
T(RN,    0x1.3f1d0ba84c008p-3,    0x1.3c915f1fdeafbp-3,   0x1.fc84d4p-2, INEXACT)
T(RN,    0x1.3e8c87f8e78a9p-3,    0x1.3c0446da227ddp-3,  -0x1.fce568p-2, INEXACT)
T(RN,    0x1.3dfc45bb74c46p-3,     0x1.3b776b75c518p-3,  -0x1.f620e4p-2, INEXACT)
T(RN,    0x1.3d6c44d250778p-3,    0x1.3aeaccdb2acc3p-3,  -0x1.fb956ap-2, INEXACT)
T(RN,    0x1.3cdc851fe4d08p-3,    0x1.3a5e6af2bd791p-3,   0x1.fc9a84p-2, INEXACT)
T(RN,    0x1.3c4d0686a969ep-3,    0x1.39d245a4eca22p-3,   0x1.ff291ep-2, INEXACT)
T(RN,    0x1.3bbdc8e9233d2p-3,    0x1.39465cda2d6b2p-3,   0x1.f713dep-2, INEXACT)
T(RN,    0x1.3b2ecc29e4976p-3,    0x1.38bab07afa965p-3,   0x1.fb2daep-2, INEXACT)
T(RN,    0x1.3aa0102b8d213p-3,    0x1.382f406fd495bp-3,   0x1.f7e8a2p-2, INEXACT)
T(RN,    0x1.3a1194d0c9ccbp-3,     0x1.37a40ca14183p-3,  -0x1.fad12ap-2, INEXACT)
T(RN,    0x1.398359fc54d16p-3,    0x1.371914f7cd256p-3,  -0x1.fbd788p-2, INEXACT)
T(RN,    0x1.38f55f90f5b18p-3,    0x1.368e595c08ffbp-3,   0x1.fe8bfcp-2, INEXACT)
T(RN,    0x1.3867a571811f2p-3,    0x1.3603d9b68c3fap-3,   0x1.fcf24ap-2, INEXACT)
T(RN,     0x1.37da2b80d90bp-3,    0x1.357995eff3d5ep-3,    0x1.f6a15p-2, INEXACT)
T(RN,    0x1.374cf1a1ec90ep-3,    0x1.34ef8df0e26bfp-3,   0x1.fbdfeep-2, INEXACT)
T(RN,    0x1.36bff7b7b7fa5p-3,    0x1.3465c1a200703p-3,   0x1.ff309ap-2, INEXACT)
T(RN,    0x1.36333da544ac8p-3,    0x1.33dc30ebfc0d4p-3,  -0x1.ff47eap-2, INEXACT)
T(RN,    0x1.35a6c34da9354p-3,    0x1.3352dbb789403p-3,   0x1.fa2cdap-2, INEXACT)
T(RN,    0x1.351a889409322p-3,    0x1.32c9c1ed61c8ap-3,  -0x1.fe98e6p-2, INEXACT)
T(RN,    0x1.348e8d5b954e4p-3,    0x1.3240e3764530ap-3,   0x1.f64742p-2, INEXACT)
T(RN,    0x1.3402d1878b584p-3,    0x1.31b8403af8ea4p-3,   0x1.f8adfep-2, INEXACT)
T(RN,    0x1.337754fb3606dp-3,    0x1.312fd824481f2p-3,   0x1.fc3c0ep-2, INEXACT)
T(RN,    0x1.32ec1799ed26cp-3,    0x1.30a7ab1b03e62p-3,    0x1.f7404p-2, INEXACT)
T(RN,    0x1.32611947156cdp-3,    0x1.301fb908031f2p-3,  -0x1.fc0a44p-2, INEXACT)
T(RN,    0x1.31d659e620949p-3,    0x1.2f9801d4229a6p-3,   0x1.f7febcp-2, INEXACT)
T(RN,    0x1.314bd95a8d3cbp-3,    0x1.2f10856844fddp-3,   0x1.fe0a42p-2, INEXACT)
T(RN,    0x1.30c19787e6f0fp-3,    0x1.2e8943ad52d83p-3,   0x1.fba668p-2, INEXACT)
T(RN,    0x1.30379451c6193p-3,    0x1.2e023c8c3a98ep-3,   -0x1.f64bep-2, INEXACT)
T(RN,    0x1.2fadcf9bd005ap-3,    0x1.2d7b6fedf0a4ep-3,   0x1.ff877ap-2, INEXACT)
T(RN,    0x1.2f244949b6d72p-3,    0x1.2cf4ddbb6f47cp-3,   0x1.f9de4cp-2, INEXACT)
T(RN,     0x1.2e9b013f397fp-3,    0x1.2c6e85ddb6bcap-3,   0x1.fbdaf6p-2, INEXACT)
T(RN,    0x1.2e11f76023ba5p-3,    0x1.2be8683dcd31ep-3,   0x1.f95c32p-2, INEXACT)
T(RN,    0x1.2d892b904e0e5p-3,    0x1.2b6284c4bece4p-3,    0x1.fb9ebp-2, INEXACT)
T(RN,    0x1.2d009db39dbfep-3,    0x1.2adcdb5b9db0fp-3,  -0x1.f5e0a8p-2, INEXACT)
T(RN,    0x1.2c784dae04cedp-3,    0x1.2a576beb81f5cp-3,   0x1.f7169ep-2, INEXACT)
T(RN,    0x1.2bf03b6381e9fp-3,    0x1.29d2365d89b14p-3,    0x1.f8bafp-2, INEXACT)
T(RN,    0x1.2b6866b820781p-3,    0x1.294d3a9ad9028p-3,   -0x1.f6e3dp-2, INEXACT)
T(RN,     0x1.2ae0cf8ff87cp-3,    0x1.28c8788c99fffp-3,  -0x1.f796aap-2, INEXACT)
T(RN,    0x1.2a5975cf2eac7p-3,    0x1.2843f01bfcd6cp-3,  -0x1.f97952p-2, INEXACT)
T(RN,    0x1.29d25959f44dcp-3,     0x1.27bfa13237aep-3,  -0x1.ffa594p-2, INEXACT)
T(RN,    0x1.294b7a1487461p-3,    0x1.273b8bb886c28p-3,   0x1.f7a7a2p-2, INEXACT)
T(RN,    0x1.28c4d7e3320b7p-3,    0x1.26b7af982c5d5p-3,   0x1.fceb8ep-2, INEXACT)
T(RN,    0x1.283e72aa4b9bfp-3,    0x1.26340cba70d47p-3,  -0x1.fe12f2p-2, INEXACT)
T(RN,    0x1.27b84a4e37835p-3,    0x1.25b0a308a2988p-3,  -0x1.f836f4p-2, INEXACT)
T(RN,    0x1.27325eb365c95p-3,    0x1.252d726c162b3p-3,  -0x1.fb27e4p-2, INEXACT)
T(RN,    0x1.26acafbe52f08p-3,    0x1.24aa7ace26266p-3,  -0x1.ff616cp-2, INEXACT)
T(RN,    0x1.26273d5387f63p-3,    0x1.2427bc1833441p-3,   0x1.f99baep-2, INEXACT)
T(RN,    0x1.25a207579a446p-3,    0x1.23a53633a4584p-3,  -0x1.f5cb28p-2, INEXACT)
T(RN,    0x1.251d0daf2bb0cp-3,    0x1.2322e909e6589p-3,   0x1.feaae8p-2, INEXACT)
T(RN,    0x1.2498503eea716p-3,    0x1.22a0d4846c582p-3,  -0x1.fc1ae2p-2, INEXACT)
T(RN,    0x1.2413ceeb91244p-3,    0x1.221ef88caf97dp-3,   0x1.fb546ep-2, INEXACT)
T(RN,    0x1.238f8999e6b9ep-3,    0x1.219d550c2f782p-3,   0x1.fdbeaap-2, INEXACT)
T(RN,    0x1.230b802ebe763p-3,    0x1.211be9ec71828p-3,  -0x1.f8d7c2p-2, INEXACT)
T(RN,    0x1.2287b28ef7f01p-3,    0x1.209ab71701708p-3,  -0x1.f8898cp-2, INEXACT)
T(RN,    0x1.2204209f7f059p-3,    0x1.2019bc757127bp-3,  -0x1.f785eep-2, INEXACT)
T(RN,    0x1.2180ca454bdabp-3,    0x1.1f98f9f158c05p-3,   -0x1.fb9f4p-2, INEXACT)
T(RN,    0x1.20fdaf6562c9cp-3,    0x1.1f186f74567d9p-3,   -0x1.fce3ap-2, INEXACT)
T(RN,    0x1.207acfe4d46b3p-3,    0x1.1e981ce80edcdp-3,  -0x1.fef058p-2, INEXACT)
T(RN,    0x1.1ff82ba8bd8bdp-3,    0x1.1e1802362c93ap-3,   -0x1.f94b4p-2, INEXACT)
T(RN,    0x1.1f75c296471dbp-3,    0x1.1d981f4860887p-3,   -0x1.f6e81p-2, INEXACT)
T(RN,    0x1.1ef39492a6445p-3,     0x1.1d18740861e6p-3,   -0x1.ff114p-2, INEXACT)
T(RN,    0x1.1e71a1831c3b8p-3,    0x1.1c99005fee0a3p-3,  -0x1.f77d7cp-2, INEXACT)
T(RN,    0x1.1defe94cf6661p-3,    0x1.1c19c438c89bep-3,   0x1.fcd7c8p-2, INEXACT)
T(RN,    0x1.1d6e6bd58e347p-3,    0x1.1b9abf7cbb792p-3,  -0x1.f83e98p-2, INEXACT)
T(RN,    0x1.1ced2902492c4p-3,    0x1.1b1bf21596c6ap-3,    0x1.f7d5fp-2, INEXACT)
T(RN,    0x1.1c6c20b898e24p-3,    0x1.1a9d5bed30f02p-3,  -0x1.f9d6a2p-2, INEXACT)
T(RN,    0x1.1beb52ddfaf11p-3,    0x1.1a1efced66a79p-3,  -0x1.f87e6ap-2, INEXACT)
T(RN,    0x1.1b6abf57f8ef2p-3,    0x1.19a0d5001ae1dp-3,   0x1.f9a04ap-2, INEXACT)
T(RN,    0x1.1aea660c2872ep-3,    0x1.1922e40f36e21p-3,   0x1.fd3caep-2, INEXACT)
T(RN,    0x1.1a6a46e02b0e5p-3,    0x1.18a52a04aa3cfp-3,   0x1.fddfb2p-2, INEXACT)
T(RN,    0x1.19ea61b9ae387p-3,    0x1.1827a6ca6ac94p-3,   0x1.f780dep-2, INEXACT)
T(RN,    0x1.196ab67e6b602p-3,    0x1.17aa5a4a74b9ap-3,    -0x1.fdbap-2, INEXACT)
T(RN,    0x1.18eb451427d16p-3,    0x1.172d446eca899p-3,  -0x1.f773dap-2, INEXACT)
T(RN,    0x1.186c0d60b4be1p-3,    0x1.16b06521750cbp-3,  -0x1.fd286cp-2, INEXACT)
T(RN,    0x1.17ed0f49ef308p-3,    0x1.1633bc4c8368ep-3,   0x1.fc06dap-2, INEXACT)
T(RN,     0x1.176e4ab5c00dp-3,    0x1.15b749da0b1e7p-3,   0x1.fd884cp-2, INEXACT)
T(RN,     0x1.16efbf8a1c04p-3,    0x1.153b0db42801dp-3,   0x1.f924e8p-2, INEXACT)
T(RN,    0x1.16716dad03971p-3,    0x1.14bf07c4fc472p-3,   0x1.f980aep-2, INEXACT)
T(RN,    0x1.15f3550483074p-3,    0x1.144337f6b077cp-3,   -0x1.fb894p-2, INEXACT)
T(RN,    0x1.15757576b259bp-3,    0x1.13c79e33737dep-3,  -0x1.fe655cp-2, INEXACT)
T(RN,    0x1.14f7cee9b54cep-3,    0x1.134c3a657aa08p-3,   0x1.f9a044p-2, INEXACT)
T(RN,    0x1.147a6143bb59cp-3,    0x1.12d10c77018b3p-3,  -0x1.f824a2p-2, INEXACT)
T(RN,    0x1.13fd2c6affa84p-3,    0x1.125614524a4a3p-3,   0x1.f8c20ep-2, INEXACT)
T(RN,    0x1.13803045c9066p-3,    0x1.11db51e19d478p-3,   0x1.fca126p-2, INEXACT)
T(RN,    0x1.13036cba69f15p-3,    0x1.1160c50f495b3p-3,   0x1.fe620ap-2, INEXACT)
T(RN,    0x1.1286e1af4081ap-3,    0x1.10e66dc5a3be3p-3,  -0x1.fbe8b2p-2, INEXACT)
T(RN,    0x1.120a8f0ab66a2p-3,    0x1.106c4bef08102p-3,  -0x1.ff46b4p-2, INEXACT)
T(RN,    0x1.118e74b340f55p-3,    0x1.0ff25f75d85b1p-3,   0x1.fd0daep-2, INEXACT)
T(RN,    0x1.1112928f61046p-3,    0x1.0f78a8447d191p-3,   0x1.fa5f1cp-2, INEXACT)
T(RN,    0x1.1096e885a2fe4p-3,    0x1.0eff2645652a5p-3,  -0x1.fcf43ap-2, INEXACT)
T(RN,    0x1.101b767c9ece7p-3,    0x1.0e85d96305da7p-3,  -0x1.fc9772p-2, INEXACT)
T(RN,    0x1.0fa03c5af7e9ap-3,    0x1.0e0cc187daeb4p-3,    0x1.fc81ap-2, INEXACT)
T(RN,    0x1.0f253a075d3e6p-3,    0x1.0d93de9e668c1p-3,  -0x1.fcf028p-2, INEXACT)
T(RN,    0x1.0eaa6f68892aep-3,    0x1.0d1b309131569p-3,  -0x1.f69438p-2, INEXACT)
T(RN,     0x1.0e2fdc654187p-3,    0x1.0ca2b74aca5e7p-3,  -0x1.fec70cp-2, INEXACT)
T(RN,    0x1.0db580e4579a9p-3,    0x1.0c2a72b5c72e7p-3,   -0x1.ff7dap-2, INEXACT)
T(RN,    0x1.0d3b5ccca8064p-3,    0x1.0bb262bcc3b7fp-3,  -0x1.ff106ep-2, INEXACT)
T(RN,    0x1.0cc170051ade7p-3,    0x1.0b3a874a62739p-3,  -0x1.f8fca2p-2, INEXACT)
T(RN,    0x1.0c47ba74a385ap-3,    0x1.0ac2e0494c428p-3,  -0x1.fdfedap-2, INEXACT)
T(RN,    0x1.0bce3c0240c03p-3,    0x1.0a4b6da430882p-3,  -0x1.fc50f6p-2, INEXACT)
T(RN,    0x1.0b54f494fca4dp-3,    0x1.09d42f45c520fp-3,   0x1.fafaeap-2, INEXACT)
T(RN,    0x1.0adbe413ec92fp-3,     0x1.095d2518c65fp-3,  -0x1.feb93ap-2, INEXACT)
T(RN,    0x1.0a630a663135bp-3,    0x1.08e64f07f713ap-3,   0x1.fb571cp-2, INEXACT)
T(RN,    0x1.09ea6772f67e6p-3,    0x1.086facfe208f2p-3,  -0x1.fedb0ap-2, INEXACT)
T(RN,    0x1.0971fb2173912p-3,    0x1.07f93ee61294cp-3,  -0x1.fd20ecp-2, INEXACT)
T(RN,    0x1.08f9c558eadd8p-3,    0x1.078304aaa3784p-3,  -0x1.ffd9d4p-2, INEXACT)
T(RN,    0x1.0881c600a9f8cp-3,    0x1.070cfe36afff2p-3,   0x1.fa9e7ep-2, INEXACT)
T(RN,    0x1.0809fd0009ab3p-3,    0x1.06972b751b737p-3,   0x1.fff786p-2, INEXACT)
T(RN,    0x1.07926a3e6decap-3,    0x1.06218c50cfa69p-3,  -0x1.ff4a9ep-2, INEXACT)
T(RN,      0x1.071b0da345dp-3,    0x1.05ac20b4bce31p-3,  -0x1.fdd12ap-2, INEXACT)
T(RN,    0x1.06a3e7160b934p-3,    0x1.0536e88bda01ep-3,  -0x1.f6e032p-2, INEXACT)
T(RN,    0x1.062cf67e44871p-3,    0x1.04c1e3c12458ap-3,   0x1.ffb274p-2, INEXACT)
T(RN,    0x1.05b63bc38113fp-3,    0x1.044d123f9fc42p-3,    0x1.fff33p-2, INEXACT)
T(RN,    0x1.053fb6cd5cb54p-3,    0x1.03d873f256a9bp-3,   0x1.fa5a9ap-2, INEXACT)
T(RN,    0x1.04c967837df33p-3,    0x1.036408c459f6ap-3,  -0x1.f8f478p-2, INEXACT)
T(RN,    0x1.04534dcd965a3p-3,    0x1.02efd0a0c11dep-3,  -0x1.ff53aap-2, INEXACT)
T(RN,    0x1.03dd699362755p-3,    0x1.027bcb72aa17ep-3,   0x1.fa385ep-2, INEXACT)
T(RN,     0x1.0367babca9d6p-3,    0x1.0207f925396fdp-3,   -0x1.f8d25p-2, INEXACT)
T(RN,    0x1.02f241313efe8p-3,    0x1.019459a39a34ap-3,  -0x1.fd4eb4p-2, INEXACT)
T(RN,    0x1.027cfcd8ff66cp-3,    0x1.0120ecd8fe02ep-3,   0x1.ff24fcp-2, INEXACT)
T(RN,     0x1.0207ed9bd36fp-3,    0x1.00adb2b09cfd3p-3,  -0x1.faf8ecp-2, INEXACT)
T(RN,    0x1.01931361ae68cp-3,    0x1.003aab15b5db4p-3,   0x1.fdfb6cp-2, INEXACT)
T(RN,    0x1.011e6e128e877p-3,    0x1.ff8fabe71bbecp-4,  -0x1.fe1b94p-2, INEXACT)
T(RN,    0x1.00a9fd967cd9ap-3,    0x1.feaa666ae1ac7p-4,   0x1.fb7ddcp-2, INEXACT)
T(RN,    0x1.0035c1d58d4b2p-3,    0x1.fdc5858d623b5p-4,   0x1.feee08p-2, INEXACT)
T(RN,    0x1.ff83756fbd461p-4,    0x1.fce109254f518p-4,   0x1.fbfa88p-2, INEXACT)
T(RN,    0x1.fe9bd04b34d5ep-4,    0x1.fbfcf10967d93p-4,  -0x1.fd859ep-2, INEXACT)
T(RN,    0x1.fdb4940dea03ap-4,     0x1.fb193d1077f1p-4,   0x1.fcac1ep-2, INEXACT)
T(RN,    0x1.fccdc0885b1a1p-4,    0x1.fa35ed1158d8ap-4,  -0x1.fb359cp-2, INEXACT)
T(RN,    0x1.fbe7558b1be2cp-4,    0x1.f95300e2f0eebp-4,    0x1.fb703p-2, INEXACT)
T(RN,    0x1.fb0152e6d5a5fp-4,    0x1.f870785c33ba6p-4,   0x1.fb5b28p-2, INEXACT)
T(RN,    0x1.fa1bb86c47119p-4,    0x1.f78e535421de1p-4,  -0x1.f86ecep-2, INEXACT)
T(RN,    0x1.f93685ec44467p-4,    0x1.f6ac91a1c92edp-4,  -0x1.feaf8cp-2, INEXACT)
T(RN,     0x1.f851bb37b6b9p-4,    0x1.f5cb331c449fdp-4,  -0x1.fb3284p-2, INEXACT)
T(RN,    0x1.f76d581f9d375p-4,     0x1.f4ea379abc53p-4,  -0x1.ffedaep-2, INEXACT)
T(RN,    0x1.f6895c750bd36p-4,    0x1.f4099ef4658e2p-4,   0x1.ffd15ep-2, INEXACT)
T(RN,    0x1.f5a5c8092be6dp-4,    0x1.f329690082c87p-4,  -0x1.fd220ap-2, INEXACT)
T(RN,    0x1.f4c29aad3bf5ep-4,    0x1.f249959663991p-4,  -0x1.ff299cp-2, INEXACT)
T(RN,    0x1.f3dfd4328fb94p-4,    0x1.f16a248d64ca5p-4,  -0x1.f76b8cp-2, INEXACT)
T(RN,    0x1.f2fd746a900adp-4,    0x1.f08b15bcf0514p-4,  -0x1.f8ded8p-2, INEXACT)
T(RN,    0x1.f21b7b26bae06p-4,    0x1.efac68fc7d52ap-4,   -0x1.f7c74p-2, INEXACT)
T(RN,     0x1.f139e838a33ap-4,    0x1.eece1e23901b9p-4,  -0x1.f7ca6cp-2, INEXACT)
T(RN,    0x1.f058bb71f11e4p-4,    0x1.edf03509ba27fp-4,  -0x1.f64446p-2, INEXACT)
T(RN,    0x1.ef77f4a461974p-4,    0x1.ed12ad869a299p-4,   0x1.fd3cb4p-2, INEXACT)
T(RN,    0x1.ee9793a1c69fcp-4,    0x1.ec358771dbff4p-4,   0x1.fbbc48p-2, INEXACT)
T(RN,    0x1.edb7983c07192p-4,    0x1.eb58c2a338b53p-4,  -0x1.f7571cp-2, INEXACT)
T(RN,    0x1.ecd802451ec28p-4,    0x1.ea7c5ef276861p-4,  -0x1.ff4354p-2, INEXACT)
T(RN,    0x1.ebf8d18f1e3a3p-4,     0x1.e9a05c3768e6p-4,  -0x1.f774aep-2, INEXACT)
T(RN,    0x1.eb1a05ec2ae4dp-4,    0x1.e8c4ba49f0741p-4,  -0x1.fb6b28p-2, INEXACT)
T(RN,    0x1.ea3b9f2e7ef0bp-4,    0x1.e7e97901fb075p-4,   0x1.fdae9ep-2, INEXACT)
T(RN,    0x1.e95d9d286943bp-4,    0x1.e70e983783a66p-4,   0x1.feb87cp-2, INEXACT)
T(RN,    0x1.e87fffac4d72fp-4,    0x1.e63417c292894p-4,   0x1.fc73e6p-2, INEXACT)
T(RN,    0x1.e7a2c68ca3bbep-4,    0x1.e559f77b3d1bcp-4,  -0x1.ff83c2p-2, INEXACT)
T(RN,    0x1.e6c5f19bf9029p-4,    0x1.e4803739a605bp-4,  -0x1.ff9c2cp-2, INEXACT)
T(RN,    0x1.e5e980aceeb21p-4,    0x1.e3a6d6d5fd14ep-4,   0x1.ff871cp-2, INEXACT)
T(RN,    0x1.e50d73923aca7p-4,    0x1.e2cdd6287f546p-4,   0x1.ffe45ep-2, INEXACT)
T(RN,    0x1.e431ca1ea7d0bp-4,    0x1.e1f5350977066p-4,   0x1.ff1e44p-2, INEXACT)
T(RN,    0x1.e356842514bb4p-4,     0x1.e11cf3513b9ap-4,   -0x1.f603bp-2, INEXACT)
T(RN,    0x1.e27ba17874f5fp-4,    0x1.e04510d831b8ep-4,   0x1.ff6b3ap-2, INEXACT)
T(RN,    0x1.e1a121ebd04cap-4,    0x1.df6d8d76cb3acp-4,   0x1.ffec96p-2, INEXACT)
T(RN,    0x1.e0c7055242f18p-4,    0x1.de96690587358p-4,   0x1.ffccbep-2, INEXACT)
T(RN,    0x1.dfed4b7efd69fp-4,    0x1.ddbfa35cf1f31p-4,  -0x1.ffd544p-2, INEXACT)
T(RN,    0x1.df13f445447c2p-4,    0x1.dce93c55a4e8cp-4,  -0x1.f9bd82p-2, INEXACT)
T(RN,    0x1.de3aff7871399p-4,    0x1.dc1333c846ca6p-4,   0x1.fe0d88p-2, INEXACT)
T(RN,    0x1.dd626cebf0eb2p-4,    0x1.db3d898d8b7f9p-4,  -0x1.f6596ep-2, INEXACT)
T(RN,    0x1.dc8a3c734506ap-4,     0x1.da683d7e3423p-4,  -0x1.ff1872p-2, INEXACT)
T(RN,    0x1.dbb26de2032bap-4,    0x1.d9934f730f07bp-4,   0x1.fff616p-2, INEXACT)
T(RN,    0x1.dadb010bd5128p-4,    0x1.d8bebf44f7b12p-4,  -0x1.f83204p-2, INEXACT)
T(RN,    0x1.da03f5c4788b6p-4,    0x1.d7ea8cccd6dbbp-4,  -0x1.fab714p-2, INEXACT)
T(RN,    0x1.d92d4bdfbf6bep-4,    0x1.d716b7e3a272dp-4,  -0x1.f6e89cp-2, INEXACT)
T(RN,    0x1.d85703318f9a2p-4,    0x1.d64340625da4fp-4,  -0x1.f6cb26p-2, INEXACT)
T(RN,    0x1.d7811b8de2e0bp-4,    0x1.d570262218c0cp-4,    0x1.fd207p-2, INEXACT)
T(RN,    0x1.d6ab94c8c7067p-4,    0x1.d49d68fbf1552p-4,  -0x1.f65d36p-2, INEXACT)
T(RN,    0x1.d5d66eb65dbc8p-4,    0x1.d3cb08c912289p-4,  -0x1.fdd7f2p-2, INEXACT)
T(RN,    0x1.d501a92adc805p-4,    0x1.d2f90562b323bp-4,   0x1.fe5b8ap-2, INEXACT)
T(RN,    0x1.d42d43fa8cbcap-4,    0x1.d2275ea2197a7p-4,   0x1.fd11aep-2, INEXACT)
T(RN,    0x1.d3593ef9cb912p-4,    0x1.d1561460977d3p-4,  -0x1.fabd98p-2, INEXACT)
T(RN,    0x1.d28599fd09f22p-4,    0x1.d08526778cc09p-4,    0x1.fdb1ap-2, INEXACT)
T(RN,    0x1.d1b254d8cc81dp-4,    0x1.cfb494c065ff1p-4,    0x1.fdd07p-2, INEXACT)
T(RN,    0x1.d0df6f61ab95fp-4,    0x1.cee45f149d27bp-4,   0x1.fdb86cp-2, INEXACT)
T(RN,    0x1.d00ce96c53314p-4,    0x1.ce14854db95f7p-4,  -0x1.fbbfc4p-2, INEXACT)
T(RN,    0x1.cf3ac2cd82ef6p-4,    0x1.cd4507454ef62p-4,   0x1.ff5d04p-2, INEXACT)
T(RN,    0x1.ce68fb5a0e0b7p-4,    0x1.cc75e4d4ff748p-4,  -0x1.ffd984p-2, INEXACT)
T(RN,    0x1.cd9792e6db404p-4,     0x1.cba71dd67986p-4,   0x1.fe534cp-2, INEXACT)
T(RN,    0x1.ccc68948e4d74p-4,    0x1.cad8b223790ebp-4,  -0x1.fc4452p-2, INEXACT)
T(RN,    0x1.cbf5de5538912p-4,    0x1.ca0aa195c71d4p-4,  -0x1.f9caa6p-2, INEXACT)
T(RN,    0x1.cb2591e0f7a96p-4,     0x1.c93cec0739f6p-4,   0x1.ff9592p-2, INEXACT)
T(RN,    0x1.ca55a3c156b88p-4,    0x1.c86f9151b4fd9p-4,   0x1.fe4292p-2, INEXACT)
T(RN,    0x1.c98613cb9dc4fp-4,    0x1.c7a2914f28d1ep-4,  -0x1.fd5fa4p-2, INEXACT)
T(RN,    0x1.c8b6e1d52823bp-4,    0x1.c6d5ebd993333p-4,  -0x1.f7d42ap-2, INEXACT)
T(RN,     0x1.c7e80db3647ep-4,    0x1.c609a0caff115p-4,  -0x1.fc959ep-2, INEXACT)
T(RN,    0x1.c719973bd4c4fp-4,    0x1.c53daffd84878p-4,  -0x1.f75118p-2, INEXACT)
T(RN,    0x1.c64b7e440e263p-4,    0x1.c472194b48d93p-4,  -0x1.fc88bep-2, INEXACT)
T(RN,    0x1.c57dc2a1b908ap-4,    0x1.c3a6dc8e7e768p-4,   0x1.febbe8p-2, INEXACT)
T(RN,    0x1.c4b0642a90faep-4,    0x1.c2dbf9a164f28p-4,  -0x1.f6ad1ep-2, INEXACT)
T(RN,    0x1.c3e362b464adfp-4,    0x1.c211705e49064p-4,  -0x1.f9d4b8p-2, INEXACT)
T(RN,    0x1.c316be1515f29p-4,    0x1.c147409f84955p-4,  -0x1.f971aap-2, INEXACT)
T(RN,    0x1.c24a762299b2bp-4,    0x1.c07d6a3f7eaf4p-4,  -0x1.fdf3fcp-2, INEXACT)
T(RN,    0x1.c17e8ab2f7d89p-4,    0x1.bfb3ed18ab7eap-4,  -0x1.f64ba6p-2, INEXACT)
T(RN,    0x1.c0b2fb9c4b4c1p-4,    0x1.beeac9058c4dfp-4,  -0x1.f88806p-2, INEXACT)
T(RN,    0x1.bfe7c8b4c1fd7p-4,    0x1.be21fde0af99ep-4,   0x1.fe8f32p-2, INEXACT)
T(RN,    0x1.bf1cf1d29cc27p-4,    0x1.bd598b84b0f61p-4,  -0x1.f7fdc8p-2, INEXACT)
T(RN,    0x1.be5276cc2f59ep-4,    0x1.bc9171cc3918bp-4,    -0x1.fe2fp-2, INEXACT)
T(RN,    0x1.bd885777e067fp-4,    0x1.bbc9b091fdddbp-4,  -0x1.f8f648p-2, INEXACT)
T(RN,    0x1.bcbe93ac295e2p-4,    0x1.bb0247b0c236bp-4,  -0x1.f931f2p-2, INEXACT)
T(RN,    0x1.bbf52b3f967b7p-4,    0x1.ba3b370356328p-4,  -0x1.ff8f44p-2, INEXACT)
T(RN,    0x1.bb2c1e08c6d41p-4,    0x1.b9747e64970c1p-4,  -0x1.f732e8p-2, INEXACT)
T(RN,    0x1.ba636bde6c2a7p-4,    0x1.b8ae1daf6f0b4p-4,  -0x1.fd7324p-2, INEXACT)
T(RN,    0x1.b99b14974afbdp-4,    0x1.b7e814bed5989p-4,  -0x1.f8877ep-2, INEXACT)
T(RN,    0x1.b8d3180a3a684p-4,    0x1.b722636dcf2cap-4,   -0x1.f7035p-2, INEXACT)
T(RN,    0x1.b80b760e2443cp-4,    0x1.b65d09976d685p-4,  -0x1.f6efaap-2, INEXACT)
T(RN,    0x1.b7442e7a04f85p-4,    0x1.b5980716cefe6p-4,    0x1.ff73ap-2, INEXACT)
T(RN,    0x1.b67d4124eb755p-4,    0x1.b4d35bc71fa9dp-4,  -0x1.f7d496p-2, INEXACT)
T(RN,    0x1.b5b6ade5f9418p-4,    0x1.b40f078398476p-4,  -0x1.fe664cp-2, INEXACT)
T(RN,    0x1.b4f07494626a4p-4,    0x1.b34b0a277ecb7p-4,   -0x1.fa774p-2, INEXACT)
T(RN,    0x1.b42a95076d68bp-4,    0x1.b287638e262ecp-4,  -0x1.fbfe58p-2, INEXACT)
T(RN,    0x1.b3650f167330fp-4,    0x1.b1c41392ee847p-4,  -0x1.f8ed2ap-2, INEXACT)
T(RN,    0x1.b29fe298df1c7p-4,    0x1.b1011a1144eb8p-4,  -0x1.f716e4p-2, INEXACT)
T(RN,    0x1.b1db0f662ee21p-4,    0x1.b03e76e4a38dfp-4,  -0x1.f72922p-2, INEXACT)
T(RN,    0x1.b1169555f29bfp-4,    0x1.af7c29e891ad6p-4,  -0x1.f817c4p-2, INEXACT)
T(RN,    0x1.b052743fccae1p-4,    0x1.aeba32f8a390dp-4,  -0x1.f6ba36p-2, INEXACT)
T(RN,    0x1.af8eabfb71ba7p-4,    0x1.adf891f07a7fbp-4,   -0x1.fb737p-2, INEXACT)
T(RN,    0x1.aecb3c60a8aedp-4,    0x1.ad3746abc4d64p-4,  -0x1.f754cep-2, INEXACT)
T(RN,    0x1.ae0825474ab2ap-4,    0x1.ac7651063dfa7p-4,    -0x1.f7acp-2, INEXACT)
T(RN,    0x1.ad456687430c6p-4,    0x1.abb5b0dbae484p-4,  -0x1.fc061ep-2, INEXACT)
T(RN,    0x1.ac82fff88f3cfp-4,    0x1.aaf56607eb337p-4,  -0x1.fe5324p-2, INEXACT)
T(RN,     0x1.abc0f1733ed3p-4,    0x1.aa357066d7221p-4,  -0x1.f903c6p-2, INEXACT)
T(RN,    0x1.aaff3acf737a8p-4,    0x1.a975cfd461826p-4,  -0x1.f8ce32p-2, INEXACT)
T(RN,    0x1.aa3ddbe560f27p-4,    0x1.a8b6842c86c75p-4,  -0x1.f62af4p-2, INEXACT)
T(RN,    0x1.a97cd48d4cf36p-4,    0x1.a7f78d4b5055dp-4,  -0x1.fe2eacp-2, INEXACT)
T(RN,     0x1.a8bc249f8f42p-4,    0x1.a738eb0cd49dbp-4,   -0x1.fee98p-2, INEXACT)
T(RN,    0x1.a7fbcbf491898p-4,    0x1.a67a9d4d36faep-4,  -0x1.fad6bap-2, INEXACT)
T(RN,    0x1.a73bca64cf73bp-4,    0x1.a5bca3e8a7d3cp-4,  -0x1.f919e4p-2, INEXACT)
T(RN,    0x1.a67c1fc8d67d6p-4,    0x1.a4fefebb64746p-4,  -0x1.fb8cbep-2, INEXACT)
T(RN,    0x1.a5bccbf9460e6p-4,    0x1.a441ada1b72cap-4,  -0x1.fa73f4p-2, INEXACT)
T(RN,    0x1.a4fdcececf592p-4,    0x1.a384b077f7368p-4,  -0x1.fc0cb6p-2, INEXACT)
T(RN,     0x1.a43f2822356dp-4,    0x1.a2c8071a88ce9p-4,  -0x1.fc167cp-2, INEXACT)
T(RN,    0x1.a380d7cc4d09bp-4,    0x1.a20bb165dd0e1p-4,  -0x1.f76c44p-2, INEXACT)
T(RN,    0x1.a2c2dda5fcbd4p-4,    0x1.a14faf36720efp-4,   -0x1.fa424p-2, INEXACT)
T(RN,    0x1.a20539883cc3ap-4,    0x1.a0940068d2d1ep-4,  -0x1.f6b9d8p-2, INEXACT)
T(RN,    0x1.a147eb4c17006p-4,    0x1.9fd8a4d9973e5p-4,  -0x1.ff1198p-2, INEXACT)
T(RN,    0x1.a08af2caa7027p-4,    0x1.9f1d9c65642c5p-4,  -0x1.f85b3cp-2, INEXACT)
T(RN,    0x1.9fce4fdd19f7cp-4,    0x1.9e62e6e8eb5e7p-4,  -0x1.ff2544p-2, INEXACT)
T(RN,     0x1.9f12025cae9fp-4,    0x1.9da88440eb79cp-4,  -0x1.f8ddd2p-2, INEXACT)
T(RN,    0x1.9e560a22b5414p-4,    0x1.9cee744a30059p-4,   -0x1.fad4bp-2, INEXACT)
T(RN,    0x1.9d9a67088fb61p-4,    0x1.9c34b6e191759p-4,   -0x1.f76c6p-2, INEXACT)
T(RN,    0x1.9cdf18e7b144ep-4,    0x1.9b7b4be3f5118p-4,  -0x1.ff3682p-2, INEXACT)
T(RN,    0x1.9c241f999eb59p-4,    0x1.9ac2332e4d0b9p-4,  -0x1.fc1072p-2, INEXACT)
T(RN,    0x1.9b697af7ee3e5p-4,    0x1.9a096c9d98746p-4,  -0x1.fd90aep-2, INEXACT)
T(RN,    0x1.9aaf2adc4768dp-4,    0x1.9950f80ee3266p-4,  -0x1.fd3ac2p-2, INEXACT)
T(RN,    0x1.99f52f2063328p-4,    0x1.9898d55f45ebap-4,  -0x1.f941f8p-2, INEXACT)
T(RN,    0x1.993b879e0be53p-4,    0x1.97e1046be65cbp-4,  -0x1.fe4b8cp-2, INEXACT)
T(RN,    0x1.9882342f1d127p-4,    0x1.97298511f6e1ep-4,  -0x1.f7afd8p-2, INEXACT)
T(RN,    0x1.97c934ad8397fp-4,    0x1.9672572eb6bd6p-4,  -0x1.ffc6a6p-2, INEXACT)
T(RN,    0x1.971088f33d958p-4,    0x1.95bb7a9f72072p-4,  -0x1.f75cd6p-2, INEXACT)
T(RN,    0x1.965830da5a5eap-4,    0x1.9504ef4181a44p-4,   -0x1.fae6ap-2, INEXACT)
T(RN,    0x1.95a02c3cfa6a5p-4,    0x1.944eb4f24b3ccp-4,  -0x1.facedap-2, INEXACT)
T(RN,    0x1.94e87af54f656p-4,    0x1.9398cb8f41535p-4,  -0x1.fed96ep-2, INEXACT)
T(RN,    0x1.94311cdd9c159p-4,    0x1.92e332f5e32e7p-4,   0x1.f7da72p-2, INEXACT)
T(RN,    0x1.937a11d034534p-4,    0x1.922deb03bcd78p-4,  -0x1.f61f8cp-2, INEXACT)
T(RN,    0x1.92c359a77d12dp-4,    0x1.9178f396672a4p-4,  -0x1.ff35fap-2, INEXACT)
T(RN,    0x1.920cf43dec3f8p-4,     0x1.90c44c8b87b5p-4,  -0x1.f6cdc8p-2, INEXACT)
T(RN,    0x1.9156e16e08d22p-4,    0x1.900ff5c0d0d4fp-4,  -0x1.fc109ep-2, INEXACT)
T(RN,    0x1.90a121126ab93p-4,    0x1.8f5bef1401a3fp-4,  -0x1.fccdf6p-2, INEXACT)
T(RN,    0x1.8febb305bad05p-4,    0x1.8ea83862e5f59p-4,  -0x1.f7589ap-2, INEXACT)
T(RN,    0x1.8f369722b2dbcp-4,    0x1.8df4d18b56581p-4,  -0x1.feb2f2p-2, INEXACT)
T(RN,    0x1.8e81cd441d882p-4,    0x1.8d41ba6b38199p-4,  -0x1.f5ca7ap-2, INEXACT)
T(RN,    0x1.8dcd5544d64b8p-4,    0x1.8c8ef2e07d2edp-4,  -0x1.f8820ep-2, INEXACT)
T(RN,    0x1.8d192effc9877p-4,    0x1.8bdc7ac9245a5p-4,   -0x1.fb658p-2, INEXACT)
T(RN,    0x1.8c655a4ff4508p-4,    0x1.8b2a520338f9bp-4,  -0x1.f946f4p-2, INEXACT)
T(RN,    0x1.8bb1d71064832p-4,    0x1.8a78786cd31fbp-4,  -0x1.fcc7e6p-2, INEXACT)
T(RN,    0x1.8afea51c38c8fp-4,    0x1.89c6ede4179ecp-4,  -0x1.f70faap-2, INEXACT)
T(RN,    0x1.8a4bc44ea0644p-4,    0x1.8915b24737da4p-4,  -0x1.fed308p-2, INEXACT)
T(RN,    0x1.89993482db518p-4,    0x1.8864c57471ecep-4,  -0x1.f74596p-2, INEXACT)
T(RN,    0x1.88e6f5943a3c3p-4,    0x1.87b4274a10a2ep-4,  -0x1.fb546ep-2, INEXACT)
T(RN,    0x1.8835075e1e4fdp-4,    0x1.8703d7a66b50ap-4,  -0x1.f96854p-2, INEXACT)
T(RN,    0x1.878369bbf9726p-4,    0x1.8653d667e611cp-4,  -0x1.f7d78cp-2, INEXACT)
T(RN,    0x1.86d21c894df37p-4,    0x1.85a4236cf17e1p-4,  -0x1.fc4d24p-2, INEXACT)
T(RN,    0x1.86211fa1aec1bp-4,    0x1.84f4be940ae3cp-4,  -0x1.fdfbfcp-2, INEXACT)
T(RN,    0x1.857072e0bf43fp-4,    0x1.8445a7bbbc25dp-4,  -0x1.fdd48ep-2, INEXACT)
T(RN,    0x1.84c016223351dp-4,    0x1.8396dec29bb9ep-4,  -0x1.f99648p-2, INEXACT)
T(RN,    0x1.84100941cf377p-4,    0x1.82e863874cb0ep-4,   -0x1.f5eb2p-2, INEXACT)
T(RN,    0x1.83604c1b67b69p-4,    0x1.823a35e87ebd3p-4,  -0x1.fac20ep-2, INEXACT)
T(RN,    0x1.82b0de8ae1dabp-4,    0x1.818c55c4ee0c2p-4,  -0x1.f8939ep-2, INEXACT)
T(RN,    0x1.8201c06c331e3p-4,    0x1.80dec2fb636fbp-4,  -0x1.fbc2bcp-2, INEXACT)
T(RN,    0x1.8152f19b6138bp-4,    0x1.80317d6ab4325p-4,  -0x1.fd7a26p-2, INEXACT)
T(RN,     0x1.80a471f4823fp-4,    0x1.7f8484f1c23b7p-4,   -0x1.f6f87p-2, INEXACT)
T(RN,    0x1.7ff64153bc879p-4,    0x1.7ed7d96f7bf91p-4,  -0x1.fd6924p-2, INEXACT)
T(RN,    0x1.7f485f95469abp-4,     0x1.7e2b7ac2dc55p-4,  -0x1.f8a6fcp-2, INEXACT)
T(RN,    0x1.7e9acc95673b9p-4,    0x1.7d7f68caeac2ap-4,  -0x1.f751dcp-2, INEXACT)
T(RN,    0x1.7ded88307559fp-4,    0x1.7cd3a366bb358p-4,   -0x1.fc023p-2, INEXACT)
T(RN,    0x1.7d409242d807cp-4,    0x1.7c282a756e1bep-4,  -0x1.f95c28p-2, INEXACT)
T(RN,    0x1.7c93eaa90688cp-4,    0x1.7b7cfdd63072fp-4,  -0x1.f6df1ep-2, INEXACT)
T(RN,    0x1.7be7913f881e4p-4,    0x1.7ad21d683b97cp-4,  -0x1.f84316p-2, INEXACT)
T(RN,    0x1.7b3b85e2f42e8p-4,     0x1.7a27890ad573p-4,  -0x1.fcf146p-2, INEXACT)
T(RN,     0x1.7a8fc86ff219p-4,    0x1.797d409d50527p-4,   0x1.fb616ap-2, INEXACT)
T(RN,    0x1.79e458c33942ap-4,    0x1.78d343ff0af94p-4,  -0x1.fb0b22p-2, INEXACT)
T(RN,    0x1.793936b991174p-4,    0x1.7829930f70a6fp-4,  -0x1.fce44ap-2, INEXACT)
T(RN,    0x1.788e622fd0e4ap-4,    0x1.77802dadf8f68p-4,   -0x1.fa809p-2, INEXACT)
T(RN,     0x1.77e3db02dff4p-4,    0x1.76d713ba27fccp-4,  -0x1.f7447ap-2, INEXACT)
T(RN,    0x1.7739a10fb56dap-4,    0x1.762e45138e309p-4,  -0x1.fb2b22p-2, INEXACT)
T(RN,    0x1.768fb43358482p-4,    0x1.7585c199c85efp-4,  -0x1.fa826ap-2, INEXACT)
T(RN,    0x1.75e6144adf70fp-4,    0x1.74dd892c7fd7ap-4,  -0x1.f7da86p-2, INEXACT)
T(RN,     0x1.753cc1337189p-4,    0x1.74359bab6a2eep-4,  -0x1.fc8e78p-2, INEXACT)
T(RN,    0x1.7493baca45009p-4,    0x1.738df8f6495d8p-4,  -0x1.f732c8p-2, INEXACT)
T(RN,    0x1.73eb00eca011ap-4,    0x1.72e6a0ecebbfdp-4,  -0x1.fda966p-2, INEXACT)
T(RN,    0x1.73429377d8a1bp-4,    0x1.723f936f2bfc1p-4,   -0x1.fddf9p-2, INEXACT)
T(RN,    0x1.729a724954551p-4,     0x1.7198d05cf11ap-4,  -0x1.f7f24ep-2, INEXACT)
T(RN,    0x1.71f29d3e8879dp-4,    0x1.70f257962e726p-4,  -0x1.f95a24p-2, INEXACT)
T(RN,    0x1.714b1434f9ff5p-4,    0x1.704c28fae3aafp-4,  -0x1.fcee9ap-2, INEXACT)
T(RN,   -0x1.7333333333315p+1,   -0x1.3d1ddbdad64eap+0,  -0x1.f7cbd2p-2, INEXACT)
T(RN,   -0x1.73003971db714p+1,   -0x1.3d1304ee73998p+0,   0x1.fcb506p-2, INEXACT)
T(RN,   -0x1.72cd46b097886p+1,   -0x1.3d082cd5ec027p+0,   0x1.ff5ff4p-2, INEXACT)
T(RN,   -0x1.729a5aee7161ap+1,   -0x1.3cfd539133027p+0,   0x1.f93d9cp-2, INEXACT)
T(RN,   -0x1.7267762a73062p+1,   -0x1.3cf279203c191p+0,   0x1.fee568p-2, INEXACT)
T(RN,   -0x1.72349863a69cdp+1,   -0x1.3ce79d82facc5p+0,   0x1.f9df22p-2, INEXACT)
T(RN,   -0x1.7201c199166f6p+1,   -0x1.3cdcc0b962a9bp+0,    0x1.f8f62p-2, INEXACT)
T(RN,   -0x1.71cef1c9ccf2ap+1,    -0x1.3cd1e2c36748p+0,   0x1.f72a4ap-2, INEXACT)
T(RN,    -0x1.719c28f4d4adp+1,   -0x1.3cc703a0fc41fp+0,    0x1.f6882p-2, INEXACT)
T(RN,   -0x1.716967193841fp+1,   -0x1.3cbc235215389p+0,  -0x1.f61ce2p-2, INEXACT)
T(RN,   -0x1.7136ac3602c23p+1,   -0x1.3cb141d6a5e45p+0,  -0x1.f9ebf2p-2, INEXACT)
T(RN,   -0x1.7103f84a3edf7p+1,   -0x1.3ca65f2ea1e99p+0,  -0x1.fa610ap-2, INEXACT)
T(RN,   -0x1.70d14b54f7cb8p+1,   -0x1.3c9b7b59fd084p+0,  -0x1.ff98cep-2, INEXACT)
T(RN,   -0x1.709ea55538b28p+1,   -0x1.3c909658aaff4p+0,  -0x1.f7aae8p-2, INEXACT)
T(RN,   -0x1.706c064a0cf83p+1,   -0x1.3c85b02a9f998p+0,   0x1.fea142p-2, INEXACT)
T(RN,   -0x1.70396e32800eap+1,   -0x1.3c7ac8cfcea56p+0,   0x1.f77c9cp-2, INEXACT)
T(RN,   -0x1.7006dd0d9d98fp+1,   -0x1.3c6fe0482bfbdp+0,   0x1.f9614ep-2, INEXACT)
T(RN,   -0x1.6fd452da71512p+1,   -0x1.3c64f693ab7afp+0,   0x1.f986bap-2, INEXACT)
T(RN,   -0x1.6fa1cf98071b2p+1,   -0x1.3c5a0bb2410a2p+0,   0x1.fde316p-2, INEXACT)
T(RN,   -0x1.6f6f53456af28p+1,   -0x1.3c4f1fa3e0962p+0,   -0x1.f8dc9p-2, INEXACT)
T(RN,   -0x1.6f3cdde1a8fe5p+1,   -0x1.3c4432687e152p+0,  -0x1.fa9d3cp-2, INEXACT)
T(RN,   -0x1.6f0a6f6bcd80ep+1,   -0x1.3c3944000d83ap+0,   -0x1.fe898p-2, INEXACT)
T(RN,   -0x1.6ed807e2e4e0ap+1,   -0x1.3c2e546a82e62p+0,  -0x1.f98a2cp-2, INEXACT)
T(RN,   -0x1.6ea5a745fba29p+1,   -0x1.3c2363a7d247fp+0,   0x1.fdca94p-2, INEXACT)
T(RN,   -0x1.6e734d941e6edp+1,   -0x1.3c1871b7efbc8p+0,  -0x1.f836aep-2, INEXACT)
T(RN,   -0x1.6e40facc5a0e8p+1,   -0x1.3c0d7e9acf5e5p+0,  -0x1.f9ee48p-2, INEXACT)
T(RN,   -0x1.6e0eaeedbb745p+1,   -0x1.3c028a5065517p+0,  -0x1.fa2b12p-2, INEXACT)
T(RN,   -0x1.6ddc69f74fa37p+1,   -0x1.3bf794d8a5bdbp+0,   0x1.fc4b9ep-2, INEXACT)
T(RN,   -0x1.6daa2be823cc8p+1,   -0x1.3bec9e3384d55p+0,  -0x1.fe6ffcp-2, INEXACT)
T(RN,   -0x1.6d77f4bf45404p+1,   -0x1.3be1a660f6d17p+0,   0x1.f961fep-2, INEXACT)
T(RN,   -0x1.6d45c47bc173dp+1,   -0x1.3bd6ad60eff3fp+0,  -0x1.f967c6p-2, INEXACT)
T(RN,   -0x1.6d139b1ca5eb7p+1,   -0x1.3bcbb3336481ep+0,  -0x1.fa0df2p-2, INEXACT)
T(RN,   -0x1.6ce178a1006b5p+1,   -0x1.3bc0b7d848ceep+0,  -0x1.fe9afap-2, INEXACT)
T(RN,   -0x1.6caf5d07debe1p+1,   -0x1.3bb5bb4f91304p+0,  -0x1.f85848p-2, INEXACT)
T(RN,   -0x1.6c7d48504ed86p+1,   -0x1.3baabd993204ep+0,  -0x1.f72398p-2, INEXACT)
T(RN,   -0x1.6c4b3a795ed73p+1,   -0x1.3b9fbeb51fb4cp+0,    0x1.f92dbp-2, INEXACT)
T(RN,   -0x1.6c1933821ced2p+1,   -0x1.3b94bea34ead3p+0,   0x1.fa4d9ep-2, INEXACT)
T(RN,   -0x1.6be7336997785p+1,   -0x1.3b89bd63b3655p+0,  -0x1.fa042ep-2, INEXACT)
T(RN,   -0x1.6bb53a2edcee2p+1,   -0x1.3b7ebaf64259ap+0,  -0x1.fd5adcp-2, INEXACT)
T(RN,   -0x1.6b8347d0fbedep+1,   -0x1.3b73b75af0106p+0,   0x1.fff912p-2, INEXACT)
T(RN,   -0x1.6b515c4f0332dp+1,   -0x1.3b68b291b1168p+0,   0x1.fb4098p-2, INEXACT)
T(RN,    -0x1.6b1f77a8019cp+1,   -0x1.3b5dac9a7a011p+0,   0x1.f84a32p-2, INEXACT)
T(RN,   -0x1.6aed99db062adp+1,   -0x1.3b52a5753f6d3p+0,   0x1.fd3eaep-2, INEXACT)
T(RN,   -0x1.6abbc2e71ff79p+1,   -0x1.3b479d21f5fd8p+0,   0x1.f873e4p-2, INEXACT)
T(RN,   -0x1.6a89f2cb5e4edp+1,   -0x1.3b3c93a09260ap+0,   0x1.f9c478p-2, INEXACT)
T(RN,   -0x1.6a582986d0839p+1,   -0x1.3b3188f109471p+0,   0x1.f6112ep-2, INEXACT)
T(RN,   -0x1.6a2667188621bp+1,   -0x1.3b267d134f6e6p+0,   0x1.f6432ep-2, INEXACT)
T(RN,   -0x1.69f4ab7f8ee5ep+1,   -0x1.3b1b7007599f8p+0,  -0x1.f630b4p-2, INEXACT)
T(RN,   -0x1.69c2f6bafa71ap+1,   -0x1.3b1061cd1c9dap+0,  -0x1.f7386ep-2, INEXACT)
T(RN,   -0x1.699148c9d8c2cp+1,   -0x1.3b0552648d412p+0,  -0x1.f7e76cp-2, INEXACT)
T(RN,   -0x1.695fa1ab39c8cp+1,   -0x1.3afa41cda05fap+0,  -0x1.fb5266p-2, INEXACT)
T(RN,   -0x1.692e015e2dbeep+1,   -0x1.3aef30084ae02p+0,  -0x1.f88fa4p-2, INEXACT)
T(RN,   -0x1.68fc67e1c4e8bp+1,    -0x1.3ae41d1481acp+0,  -0x1.fb2b4cp-2, INEXACT)
T(RN,   -0x1.68cad5350fb3fp+1,   -0x1.3ad908f239b68p+0,   0x1.f97f96p-2, INEXACT)
T(RN,   -0x1.689949571ea4ap+1,   -0x1.3acdf3a167f8ap+0,  -0x1.f96a0ap-2, INEXACT)
T(RN,   -0x1.6867c44702695p+1,    -0x1.3ac2dd220175p+0,    0x1.fc9d3p-2, INEXACT)
T(RN,   -0x1.68364603cbd2bp+1,   -0x1.3ab7c573fb36ep+0,   0x1.fc37e4p-2, INEXACT)
T(RN,   -0x1.6804ce8c8bce7p+1,   -0x1.3aacac974a505p+0,   0x1.fb63a8p-2, INEXACT)
T(RN,   -0x1.67d35de053666p+1,   -0x1.3aa1928be3da5p+0,    0x1.faaffp-2, INEXACT)
T(RN,    -0x1.67a1f3fe33c9p+1,   -0x1.3a967751bcf6bp+0,   0x1.faa412p-2, INEXACT)
T(RN,   -0x1.677090e53e4ebp+1,   -0x1.3a8b5ae8cad15p+0,  -0x1.f8876ap-2, INEXACT)
T(RN,   -0x1.673f34948464cp+1,   -0x1.3a803d51029b2p+0,   0x1.ffa3aep-2, INEXACT)
T(RN,   -0x1.670ddf0b1798dp+1,   -0x1.3a751e8a598d5p+0,    0x1.fe257p-2, INEXACT)
T(RN,   -0x1.66dc904809a4ap+1,   -0x1.3a69fe94c4eb7p+0,  -0x1.f906cap-2, INEXACT)
T(RN,   -0x1.66ab484a6c4e2p+1,   -0x1.3a5edd7039fc5p+0,  -0x1.f69922p-2, INEXACT)
T(RN,   -0x1.667a0711519e3p+1,   -0x1.3a53bb1cae16ap+0,    0x1.f9f58p-2, INEXACT)
T(RN,   -0x1.6648cc9bcb96bp+1,   -0x1.3a48979a16905p+0,  -0x1.f75932p-2, INEXACT)
T(RN,   -0x1.661798e8ec75ep+1,   -0x1.3a3d72e868cd4p+0,  -0x1.ff1dbcp-2, INEXACT)
T(RN,   -0x1.65e66bf7c68d7p+1,   -0x1.3a324d079a36ap+0,  -0x1.f9c702p-2, INEXACT)
T(RN,   -0x1.65b545c76c4ffp+1,   -0x1.3a2725f7a03dap+0,   0x1.f67be4p-2, INEXACT)
T(RN,   -0x1.65842656f0484p+1,   -0x1.3a1bfdb87059dp+0,   0x1.f5f2dcp-2, INEXACT)
T(RN,   -0x1.65530da565792p+1,   -0x1.3a10d44a001e9p+0,  -0x1.fa52d4p-2, INEXACT)
T(RN,   -0x1.6521fbb1de621p+1,    -0x1.3a05a9ac4502p+0,  -0x1.fe1744p-2, INEXACT)
T(RN,   -0x1.64f0f07b6e1bap+1,   -0x1.39fa7ddf349dep+0,   0x1.f6e09ap-2, INEXACT)
T(RN,   -0x1.64bfec0127bfdp+1,   -0x1.39ef50e2c48d3p+0,  -0x1.f9e0dap-2, INEXACT)
T(RN,   -0x1.648eee421e8abp+1,   -0x1.39e422b6ea731p+0,  -0x1.f6b138p-2, INEXACT)
T(RN,   -0x1.645df73d65ce9p+1,   -0x1.39d8f35b9bf8ap+0,     0x1.f6cfp-2, INEXACT)
T(RN,   -0x1.642d06f211148p+1,   -0x1.39cdc2d0ced47p+0,   -0x1.f6215p-2, INEXACT)
T(RN,   -0x1.63fc1d5f33ee8p+1,   -0x1.39c2911678bf8p+0,  -0x1.f9eea4p-2, INEXACT)
T(RN,   -0x1.63cb3a83e2178p+1,   -0x1.39b75e2c8f7d3p+0,  -0x1.facb02p-2, INEXACT)
T(RN,   -0x1.639a5e5f2f6fbp+1,   -0x1.39ac2a1308da1p+0,   0x1.fa6da2p-2, INEXACT)
T(RN,   -0x1.636988f02ff2ap+1,   -0x1.39a0f4c9daa9fp+0,   0x1.f89056p-2, INEXACT)
T(RN,   -0x1.6338ba35f7bcap+1,   -0x1.3995be50fac8cp+0,   0x1.f92874p-2, INEXACT)
T(RN,   -0x1.6307f22f9b0b8p+1,    -0x1.398a86a85f1bp+0,   0x1.fde78ap-2, INEXACT)
T(RN,   -0x1.62d730dc2e3ecp+1,   -0x1.397f4dcffd8dcp+0,   0x1.f8614ep-2, INEXACT)
T(RN,   -0x1.62a6763ac5d85p+1,   -0x1.397413c7cc16ep+0,  -0x1.fd6ba2p-2, INEXACT)
T(RN,   -0x1.6275c24a76376p+1,   -0x1.3968d88fc0a4dp+0,   0x1.f5e7f6p-2, INEXACT)
T(RN,   -0x1.6245150a54c6bp+1,   -0x1.395d9c27d164fp+0,   0x1.f63658p-2, INEXACT)
T(RN,   -0x1.62146e7975bc4p+1,   -0x1.39525e8ff43e1p+0,  -0x1.fae50ep-2, INEXACT)
T(RN,   -0x1.61e3ce96ee4e1p+1,   -0x1.39471fc81f52dp+0,   -0x1.fd9f4p-2, INEXACT)
T(RN,   -0x1.61b33561d3a48p+1,   -0x1.393bdfd048c3cp+0,  -0x1.fa158cp-2, INEXACT)
T(RN,   -0x1.6182a2d93af52p+1,   -0x1.39309ea866b55p+0,  -0x1.fc1a5cp-2, INEXACT)
T(RN,   -0x1.615216fc39aa5p+1,    -0x1.39255c506f59p+0,    0x1.f8517p-2, INEXACT)
T(RN,   -0x1.612191c9e5396p+1,   -0x1.391a18c858e3fp+0,   0x1.f92796p-2, INEXACT)
T(RN,   -0x1.60f11341534efp+1,   -0x1.390ed4101998ep+0,  -0x1.fc16fep-2, INEXACT)
T(RN,   -0x1.60c09b6199a27p+1,   -0x1.39038e27a7bddp+0,   0x1.f80776p-2, INEXACT)
T(RN,   -0x1.60902a29ce173p+1,   -0x1.38f8470ef9a45p+0,  -0x1.fe996ep-2, INEXACT)
T(RN,   -0x1.605fbf9906b65p+1,   -0x1.38ecfec605a74p+0,  -0x1.f728bep-2, INEXACT)
T(RN,   -0x1.602f5bae5984ap+1,   -0x1.38e1b54cc221bp+0,  -0x1.f68282p-2, INEXACT)
T(RN,   -0x1.5ffefe68dd00cp+1,    -0x1.38d66aa3258cp+0,  -0x1.f995acp-2, INEXACT)
T(RN,   -0x1.5fcea7c7a7515p+1,   -0x1.38cb1ec9264afp+0,   0x1.f6d9dcp-2, INEXACT)
T(RN,   -0x1.5f9e57c9cf0dcp+1,   -0x1.38bfd1bebadedp+0,  -0x1.fbca3ep-2, INEXACT)
T(RN,   -0x1.5f6e0e6e6ad58p+1,   -0x1.38b48383d9ca7p+0,   -0x1.fcb6ap-2, INEXACT)
T(RN,    -0x1.5f3dcbb4916fp+1,    -0x1.38a93418799bp+0,  -0x1.fe9fd4p-2, INEXACT)
T(RN,   -0x1.5f0d8f9b59b53p+1,   -0x1.389de37c90e36p+0,   0x1.f60de6p-2, INEXACT)
T(RN,   -0x1.5edd5a21daac4p+1,   -0x1.389291b016415p+0,   0x1.fb2684p-2, INEXACT)
T(RN,   -0x1.5ead2b472b7c7p+1,   -0x1.38873eb3005bep+0,   0x1.f7792ap-2, INEXACT)
T(RN,   -0x1.5e7d030a63632p+1,   -0x1.387bea8545e03p+0,   0x1.fbb9bcp-2, INEXACT)
T(RN,   -0x1.5e4ce16a99bc1p+1,   -0x1.38709526dd83ap+0,  -0x1.f95b5ap-2, INEXACT)
T(RN,   -0x1.5e1cc666e6153p+1,   -0x1.38653e97be083p+0,   0x1.fb50aap-2, INEXACT)
T(RN,   -0x1.5decb1fe60042p+1,   -0x1.3859e6d7de333p+0,  -0x1.fc66acp-2, INEXACT)
T(RN,   -0x1.5dbca4301f526p+1,   -0x1.384e8de734d6dp+0,  -0x1.f95a3ep-2, INEXACT)
T(RN,   -0x1.5d8c9cfb3be0ap+1,    -0x1.384333c5b8ccp+0,   0x1.ff4874p-2, INEXACT)
T(RN,    -0x1.5d5c9c5ecdacp+1,   -0x1.3837d87360f3ap+0,   0x1.f8680cp-2, INEXACT)
T(RN,   -0x1.5d2ca259ecdc4p+1,   -0x1.382c7bf02439ap+0,  -0x1.fddeaap-2, INEXACT)
T(RN,   -0x1.5cfcaeebb1acbp+1,   -0x1.38211e3bf98f9p+0,  -0x1.fbcb1ep-2, INEXACT)
T(RN,   -0x1.5cccc213347ffp+1,   -0x1.3815bf56d7f19p+0,   0x1.fa54fcp-2, INEXACT)
T(RN,   -0x1.5c9cdbcf8dd6ap+1,   -0x1.380a5f40b6642p+0,   0x1.f6b532p-2, INEXACT)
T(RN,   -0x1.5c6cfc1fd64e4p+1,   -0x1.37fefdf98bf39p+0,   0x1.f5cee6p-2, INEXACT)
T(RN,   -0x1.5c3d230326a62p+1,   -0x1.37f39b814fb57p+0,   0x1.f63616p-2, INEXACT)
T(RN,   -0x1.5c0d507897da5p+1,   -0x1.37e837d7f8cefp+0,   0x1.fa3bb4p-2, INEXACT)
T(RN,   -0x1.5bdd847f42c4dp+1,   -0x1.37dcd2fd7e5e6p+0,  -0x1.fdd7f6p-2, INEXACT)
T(RN,   -0x1.5badbf164093ep+1,   -0x1.37d16cf1d7971p+0,    0x1.fc0d6p-2, INEXACT)
T(RN,   -0x1.5b7e003caa82dp+1,    -0x1.37c605b4fbb1p+0,    0x1.fe063p-2, INEXACT)
T(RN,   -0x1.5b4e47f199fb3p+1,   -0x1.37ba9d46e1f04p+0,  -0x1.fc2552p-2, INEXACT)
T(RN,   -0x1.5b1e963428702p+1,   -0x1.37af33a7819c3p+0,   0x1.f5ce7ap-2, INEXACT)
T(RN,   -0x1.5aeeeb036f843p+1,   -0x1.37a3c8d6d2092p+0,   0x1.fec054p-2, INEXACT)
T(RN,   -0x1.5abf465e88f07p+1,   -0x1.37985cd4ca91cp+0,   0x1.f85512p-2, INEXACT)
T(RN,   -0x1.5a8fa8448ea22p+1,   -0x1.378cefa1629e9p+0,   0x1.fd4cb6p-2, INEXACT)
T(RN,   -0x1.5a6010b49a857p+1,   -0x1.3781813c91992p+0,  -0x1.f8bf54p-2, INEXACT)
T(RN,   -0x1.5a307fadc6bb6p+1,   -0x1.377611a64ef8cp+0,  -0x1.ff6f08p-2, INEXACT)
T(RN,   -0x1.5a00f52f2d862p+1,   -0x1.376aa0de923e2p+0,   0x1.fff6aap-2, INEXACT)
T(RN,    -0x1.59d17137e93cp+1,   -0x1.375f2ee552f04p+0,  -0x1.fa3d7ap-2, INEXACT)
T(RN,   -0x1.59a1f3c714546p+1,   -0x1.3753bbba889efp+0,   0x1.f6eae2p-2, INEXACT)
T(RN,   -0x1.59727cdbc9741p+1,   -0x1.3748475e2ae6cp+0,  -0x1.f77fc6p-2, INEXACT)
T(RN,   -0x1.59430c752352cp+1,   -0x1.373cd1d03169bp+0,    -0x1.fd0dp-2, INEXACT)
T(RN,   -0x1.5913a2923cc94p+1,   -0x1.37315b1093d35p+0,  -0x1.f6a5e2p-2, INEXACT)
T(RN,   -0x1.58e43f3230cb3p+1,   -0x1.3725e31f49d6ep+0,    0x1.fce8dp-2, INEXACT)
T(RN,   -0x1.58b4e2541a6dbp+1,   -0x1.371a69fc4b314p+0,   0x1.f6c85ap-2, INEXACT)
T(RN,   -0x1.58858bf71505fp+1,   -0x1.370eefa78fb01p+0,  -0x1.fc908ep-2, INEXACT)
T(RN,   -0x1.58563c1a3bc8bp+1,   -0x1.370374210f1a5p+0,  -0x1.ff1208p-2, INEXACT)
T(RN,   -0x1.5826f2bcaa415p+1,   -0x1.36f7f768c14d9p+0,  -0x1.fd5076p-2, INEXACT)
T(RN,   -0x1.57f7afdd7bfcfp+1,   -0x1.36ec797e9e292p+0,  -0x1.fddf46p-2, INEXACT)
T(RN,   -0x1.57c8737bccb52p+1,   -0x1.36e0fa629d988p+0,   -0x1.f85bcp-2, INEXACT)
T(RN,   -0x1.57993d96b83f1p+1,   -0x1.36d57a14b78f4p+0,   0x1.f69698p-2, INEXACT)
T(RN,   -0x1.576a0e2d5a8c9p+1,   -0x1.36c9f894e4098p+0,   0x1.fbb856p-2, INEXACT)
T(RN,   -0x1.573ae53ecfb2ap+1,   -0x1.36be75e31b0d4p+0,  -0x1.ff1926p-2, INEXACT)
T(RN,   -0x1.570bc2ca33e9ap+1,   -0x1.36b2f1ff54aa6p+0,   0x1.fc7552p-2, INEXACT)
T(RN,   -0x1.56dca6cea37cep+1,   -0x1.36a76ce988f73p+0,   0x1.f6a038p-2, INEXACT)
T(RN,   -0x1.56ad914b3ae09p+1,   -0x1.369be6a1b0154p+0,  -0x1.f7b55cp-2, INEXACT)
T(RN,   -0x1.567e823f16a56p+1,   -0x1.36905f27c22e7p+0,    -0x1.f884p-2, INEXACT)
T(RN,    -0x1.564f79a9537ap+1,   -0x1.3684d67bb7759p+0,   0x1.f8f6b2p-2, INEXACT)
T(RN,   -0x1.562077890e327p+1,   -0x1.36794c9d88283p+0,   0x1.fe98ecp-2, INEXACT)
T(RN,   -0x1.55f17bdd63b8ap+1,   -0x1.366dc18d2c8aap+0,  -0x1.fc1e1ep-2, INEXACT)
T(RN,   -0x1.55c286a57118ep+1,   -0x1.3662354a9ceafp+0,   0x1.fef95cp-2, INEXACT)
T(RN,   -0x1.559397e053872p+1,   -0x1.3656a7d5d1a2ep+0,  -0x1.fb8a0ap-2, INEXACT)
T(RN,   -0x1.5564af8d2848cp+1,   -0x1.364b192ec3118p+0,   0x1.f8fec6p-2, INEXACT)
T(RN,   -0x1.5535cdab0ccaep+1,   -0x1.363f895569a1ap+0,   0x1.fa9476p-2, INEXACT)
T(RN,   -0x1.5506f2391e9dbp+1,   -0x1.3633f849bdc81p+0,  -0x1.f9d764p-2, INEXACT)
T(RN,   -0x1.54d81d367b602p+1,   -0x1.3628660bb7febp+0,  -0x1.ff40b4p-2, INEXACT)
T(RN,   -0x1.54a94ea240dbfp+1,   -0x1.361cd29b50cbap+0,    0x1.fab6bp-2, INEXACT)
T(RN,   -0x1.547a867b8d004p+1,   -0x1.36113df880bffp+0,    0x1.f8702p-2, INEXACT)
T(RN,   -0x1.544bc4c17dcf5p+1,   -0x1.3605a8234072dp+0,   0x1.f96c78p-2, INEXACT)
T(RN,   -0x1.541d09733170ep+1,   -0x1.35fa111b88866p+0,   0x1.fa350ap-2, INEXACT)
T(RN,   -0x1.53ee548fc6248p+1,   -0x1.35ee78e151a44p+0,   0x1.f8b0acp-2, INEXACT)
T(RN,   -0x1.53bfa6165a52ap+1,   -0x1.35e2df749481dp+0,   0x1.faca5ap-2, INEXACT)
T(RN,   -0x1.5390fe060c7e2p+1,   -0x1.35d744d549dcap+0,   0x1.fa02ecp-2, INEXACT)
T(RN,    -0x1.53625c5dfb3fp+1,   -0x1.35cba9036a792p+0,   0x1.f7abe4p-2, INEXACT)
T(RN,   -0x1.5333c11d45613p+1,   -0x1.35c00bfeef2a5p+0,   0x1.f670c6p-2, INEXACT)
T(RN,   -0x1.53052c4309b8dp+1,   -0x1.35b46dc7d0c6ep+0,    0x1.f7368p-2, INEXACT)
T(RN,   -0x1.52d69dce673d4p+1,   -0x1.35a8ce5e082ffp+0,   0x1.f61866p-2, INEXACT)
T(RN,    -0x1.52a815be365fp+1,   -0x1.359d2dc17ca69p+0,   0x1.f5c2fep-2, INEXACT)
T(RN,   -0x1.527994126acc3p+1,   -0x1.35918bf25c3cfp+0,  -0x1.f6732cp-2, INEXACT)
T(RN,   -0x1.524b18c94f6cbp+1,   -0x1.3585e8f06ad53p+0,   0x1.fcea46p-2, INEXACT)
T(RN,   -0x1.521ca3e24a43fp+1,   -0x1.357a44bbb31a6p+0,  -0x1.f72e5cp-2, INEXACT)
T(RN,   -0x1.51ee355c7b29bp+1,    -0x1.356e9f542e2ep+0,  -0x1.f5e28ep-2, INEXACT)
T(RN,   -0x1.51bfcd3701d29p+1,   -0x1.3562f8b9d52acp+0,  -0x1.f63c88p-2, INEXACT)
T(RN,   -0x1.51916b70fe038p+1,   -0x1.355750eca1311p+0,  -0x1.fb14ccp-2, INEXACT)
T(RN,   -0x1.516310098fb88p+1,   -0x1.354ba7ec8b70fp+0,  -0x1.fad774p-2, INEXACT)
T(RN,   -0x1.5134baffd70b6p+1,   -0x1.353ffdb98d23ap+0,   -0x1.faf02p-2, INEXACT)
T(RN,   -0x1.51066c52f4255p+1,    -0x1.353452539f88p+0,  -0x1.fcd19ep-2, INEXACT)
T(RN,   -0x1.50d824020759ep+1,   -0x1.3528a5babbe96p+0,  -0x1.fa89fep-2, INEXACT)
T(RN,   -0x1.50a9e20c3120bp+1,   -0x1.351cf7eedb9dfp+0,  -0x1.f6a136p-2, INEXACT)
T(RN,   -0x1.507ba67092021p+1,   -0x1.351148eff801ep+0,   -0x1.fbbbep-2, INEXACT)
T(RN,   -0x1.504d712e4aabcp+1,   -0x1.350598be0a7cap+0,  -0x1.fecaeap-2, INEXACT)
T(RN,   -0x1.501f42447be8bp+1,   -0x1.34f9e7590c7edp+0,   -0x1.ff854p-2, INEXACT)
T(RN,   -0x1.4ff119b246aa1p+1,   -0x1.34ee34c0f7849p+0,  -0x1.fc14f6p-2, INEXACT)
T(RN,   -0x1.4fc2f776cbef9p+1,   -0x1.34e280f5c50f7p+0,   0x1.ff5602p-2, INEXACT)
T(RN,   -0x1.4f94db912ceb9p+1,   -0x1.34d6cbf76eaffp+0,  -0x1.f85008p-2, INEXACT)
T(RN,   -0x1.4f66c6008ade9p+1,   -0x1.34cb15c5edfbap+0,  -0x1.ffb782p-2, INEXACT)
T(RN,   -0x1.4f38b6c4072e1p+1,   -0x1.34bf5e613c939p+0,  -0x1.f6b4bep-2, INEXACT)
T(RN,   -0x1.4f0aaddac35d9p+1,   -0x1.34b3a5c954223p+0,   0x1.f9b73ep-2, INEXACT)
T(RN,   -0x1.4edcab43e1137p+1,   -0x1.34a7ebfe2e5cep+0,   0x1.fcfce8p-2, INEXACT)
T(RN,   -0x1.4eaeaefe820cdp+1,   -0x1.349c30ffc5008p+0,   0x1.f8586ep-2, INEXACT)
T(RN,   -0x1.4e80b909c828dp+1,   -0x1.349074ce11d49p+0,   0x1.faaca8p-2, INEXACT)
T(RN,   -0x1.4e52c964d5641p+1,    -0x1.3484b7690eaap+0,   0x1.f925f2p-2, INEXACT)
T(RN,   -0x1.4e24e00ecbe3ap+1,    -0x1.3478f8d0b55ep+0,   0x1.fdc2dcp-2, INEXACT)
T(RN,   -0x1.4df6fd06cdd6ap+1,   -0x1.346d3904ffd25p+0,  -0x1.f67a82p-2, INEXACT)
T(RN,   -0x1.4dc9204bfd9e4p+1,   -0x1.34617805e7f74p+0,  -0x1.f928cap-2, INEXACT)
T(RN,   -0x1.4d9b49dd7dae3p+1,   -0x1.3455b5d367c3fp+0,   0x1.f9a4dcp-2, INEXACT)
T(RN,   -0x1.4d6d79ba70a09p+1,   -0x1.3449f26d793b7p+0,   0x1.fac422p-2, INEXACT)
T(RN,   -0x1.4d3fafe1f9249p+1,   -0x1.343e2dd416681p+0,  -0x1.faec64p-2, INEXACT)
T(RN,   -0x1.4d11ec533a0ebp+1,   -0x1.34326807395f9p+0,  -0x1.fc602cp-2, INEXACT)
T(RN,   -0x1.4ce42f0d5655cp+1,   -0x1.3426a106dc42bp+0,  -0x1.ff6ad6p-2, INEXACT)
T(RN,   -0x1.4cb6780f7103cp+1,    -0x1.341ad8d2f939p+0,   0x1.f6792ep-2, INEXACT)
T(RN,   -0x1.4c88c758ad4afp+1,   -0x1.340f0f6b8a76ap+0,   0x1.f8772ep-2, INEXACT)
T(RN,   -0x1.4c5b1ce82e6f3p+1,   -0x1.340344d08a362p+0,  -0x1.fdbd52p-2, INEXACT)
T(RN,   -0x1.4c2d78bd17e6ap+1,   -0x1.33f77901f2c0fp+0,  -0x1.ff4d1cp-2, INEXACT)
T(RN,   -0x1.4bffdad68d339p+1,   -0x1.33ebabffbe65dp+0,   0x1.ffe396p-2, INEXACT)
T(RN,   -0x1.4bd24333b1fe9p+1,   -0x1.33dfddc9e77f9p+0,   0x1.fd5922p-2, INEXACT)
T(RN,   -0x1.4ba4b1d3aa0cfp+1,   -0x1.33d40e6068725p+0,   0x1.fb9a62p-2, INEXACT)
T(RN,   -0x1.4b7726b59940bp+1,   -0x1.33c83dc33babcp+0,   0x1.f7aa3ap-2, INEXACT)
T(RN,   -0x1.4b49a1d8a39d8p+1,   -0x1.33bc6bf25ba47p+0,   -0x1.f7203p-2, INEXACT)
T(RN,   -0x1.4b1c233bed42ep+1,    -0x1.33b098edc2dep+0,   0x1.fdce98p-2, INEXACT)
T(RN,   -0x1.4aeeaade9a6ecp+1,   -0x1.33a4c4b56be48p+0,  -0x1.fc53eap-2, INEXACT)
T(RN,   -0x1.4ac138bfcf80cp+1,   -0x1.3398ef49514e6p+0,   0x1.f85c76p-2, INEXACT)
T(RN,   -0x1.4a93ccdeb0f4ap+1,   -0x1.338d18a96dbbfp+0,   0x1.f99ff8p-2, INEXACT)
T(RN,   -0x1.4a66673a63567p+1,   -0x1.338140d5bbd3bp+0,   -0x1.f6a62p-2, INEXACT)
T(RN,   -0x1.4a3907d20b732p+1,   -0x1.337567ce364f1p+0,  -0x1.f75188p-2, INEXACT)
T(RN,    -0x1.4a0baea4ce0dp+1,   -0x1.33698d92d7e71p+0,  -0x1.f5d696p-2, INEXACT)
T(RN,   -0x1.49de5bb1d020ap+1,   -0x1.335db2239b65fp+0,   0x1.f795acp-2, INEXACT)
T(RN,   -0x1.49b10ef836b9fp+1,   -0x1.3351d5807b9c6p+0,  -0x1.f99c82p-2, INEXACT)
T(RN,   -0x1.4983c877270a6p+1,   -0x1.3345f7a97366ap+0,    0x1.fcf98p-2, INEXACT)
T(RN,   -0x1.4956882dc6604p+1,   -0x1.333a189e7dab3p+0,  -0x1.fbd0c6p-2, INEXACT)
T(RN,   -0x1.49294e1b3a272p+1,   -0x1.332e385f9559fp+0,   0x1.fbfa12p-2, INEXACT)
T(RN,   -0x1.48fc1a3ea7e38p+1,   -0x1.332256ecb56bfp+0,   0x1.f69b2ap-2, INEXACT)
T(RN,   -0x1.48ceec97351c7p+1,   -0x1.33167445d8dcfp+0,   -0x1.f5e23p-2, INEXACT)
T(RN,   -0x1.48a1c524080e4p+1,   -0x1.330a906afada8p+0,  -0x1.f8c3fep-2, INEXACT)
T(RN,   -0x1.4874a3e4461dfp+1,   -0x1.32feab5c165bfp+0,  -0x1.fa8026p-2, INEXACT)
T(RN,   -0x1.484788d7157d6p+1,   -0x1.32f2c5192690ap+0,   0x1.fe5c0ep-2, INEXACT)
T(RN,   -0x1.481a73fb9c457p+1,   -0x1.32e6dda226a3ep+0,  -0x1.f85d32p-2, INEXACT)
T(RN,   -0x1.47ed655100b5cp+1,   -0x1.32daf4f711cd1p+0,   0x1.fd81a6p-2, INEXACT)
T(RN,   -0x1.47c05cd6691bdp+1,   -0x1.32cf0b17e349fp+0,   0x1.f689dep-2, INEXACT)
T(RN,   -0x1.47935a8afc16fp+1,   -0x1.32c32004966ffp+0,   0x1.fee4aap-2, INEXACT)
T(RN,   -0x1.47665e6de0152p+1,   -0x1.32b733bd2689ep+0,  -0x1.f92da8p-2, INEXACT)
T(RN,   -0x1.4739687e3be03p+1,   -0x1.32ab46418efcfp+0,   0x1.fa2f2cp-2, INEXACT)
T(RN,   -0x1.470c78bb36413p+1,   -0x1.329f5791cb30dp+0,   0x1.fcb0a8p-2, INEXACT)
T(RN,   -0x1.46df8f23f62f8p+1,   -0x1.329367add69bap+0,  -0x1.f75964p-2, INEXACT)
T(RN,   -0x1.46b2abb7a2af9p+1,   -0x1.32877695acb92p+0,   0x1.fa6c14p-2, INEXACT)
T(RN,   -0x1.4685ce7562fe5p+1,   -0x1.327b84494916dp+0,   0x1.f65f66p-2, INEXACT)
T(RN,   -0x1.4658f75c5e584p+1,   -0x1.326f90c8a7443p+0,   0x1.f7e382p-2, INEXACT)
T(RN,   -0x1.462c266bbc273p+1,   -0x1.32639c13c2df5p+0,  -0x1.f92bd8p-2, INEXACT)
T(RN,   -0x1.45ff5ba2a3ebep+1,   -0x1.3257a62a978e9p+0,  -0x1.fbe01ap-2, INEXACT)
T(RN,   -0x1.45d297003d561p+1,   -0x1.324baf0d21077p+0,  -0x1.f6dcdcp-2, INEXACT)
T(RN,   -0x1.45a5d883b01e8p+1,   -0x1.323fb6bb5b042p+0,   0x1.fc9dfcp-2, INEXACT)
T(RN,   -0x1.4579202c2423bp+1,   -0x1.3233bd35414b8p+0,   0x1.f93decp-2, INEXACT)
T(RN,   -0x1.454c6df8c1621p+1,   -0x1.3227c27acfaebp+0,    0x1.feb8cp-2, INEXACT)
T(RN,   -0x1.451fc1e8aff16p+1,   -0x1.321bc68c0208ap+0,   0x1.ff7afcp-2, INEXACT)
T(RN,   -0x1.44f31bfb180d4p+1,   -0x1.320fc968d4406p+0,  -0x1.f890e8p-2, INEXACT)
T(RN,   -0x1.44c67c2f22081p+1,   -0x1.3203cb1142455p+0,   0x1.fc4d66p-2, INEXACT)
T(RN,   -0x1.4499e283f6556p+1,   -0x1.31f7cb8548129p+0,   0x1.f9ed1ep-2, INEXACT)
T(RN,   -0x1.446d4ef8bd848p+1,   -0x1.31ebcac4e1acfp+0,   0x1.fb6bfcp-2, INEXACT)
T(RN,   -0x1.4440c18ca044ap+1,   -0x1.31dfc8d00b247p+0,  -0x1.fb7d84p-2, INEXACT)
T(RN,   -0x1.44143a3ec7609p+1,   -0x1.31d3c5a6c092dp+0,  -0x1.f8e7f8p-2, INEXACT)
T(RN,   -0x1.43e7b90e5bbfap+1,   -0x1.31c7c148fe1c2p+0,   0x1.fc01e4p-2, INEXACT)
T(RN,   -0x1.43bb3dfa866bdp+1,   -0x1.31bbbbb6bff08p+0,  -0x1.ff4504p-2, INEXACT)
T(RN,    -0x1.438ec9027082p+1,   -0x1.31afb4f002474p+0,   0x1.fc97dep-2, INEXACT)
T(RN,   -0x1.43625a25434ffp+1,   -0x1.31a3acf4c167fp+0,  -0x1.fb315ap-2, INEXACT)
T(RN,   -0x1.4335f162282a2p+1,   -0x1.3197a3c4f99e1p+0,  -0x1.f88b68p-2, INEXACT)
T(RN,   -0x1.43098eb848904p+1,   -0x1.318b9960a7439p+0,     0x1.fe98p-2, INEXACT)
T(RN,   -0x1.42dd3226ce1d3p+1,   -0x1.317f8dc7c6bc7p+0,   0x1.ff2f12p-2, INEXACT)
T(RN,    -0x1.42b0dbace289p+1,    -0x1.317380fa5477p+0,   0x1.f83d88p-2, INEXACT)
T(RN,    -0x1.42848b49afa2p+1,   -0x1.316772f84cea4p+0,   0x1.f789cap-2, INEXACT)
T(RN,   -0x1.425840fc5f5f1p+1,   -0x1.315b63c1ac9adp+0,   0x1.f8a7aep-2, INEXACT)
T(RN,   -0x1.422bfcc41bab4p+1,   -0x1.314f5356700cbp+0,   0x1.f67c64p-2, INEXACT)
T(RN,   -0x1.41ffbea00f291p+1,   -0x1.314341b693f89p+0,  -0x1.f5fdc2p-2, INEXACT)
T(RN,   -0x1.41d3868f63b56p+1,   -0x1.31372ee214e3bp+0,   -0x1.f956ep-2, INEXACT)
T(RN,   -0x1.41a7549143ceep+1,   -0x1.312b1ad8ef823p+0,   0x1.f9609ep-2, INEXACT)
T(RN,   -0x1.417b28a4d9fa5p+1,   -0x1.311f059b208cbp+0,  -0x1.f5ce28p-2, INEXACT)
T(RN,   -0x1.414f02c950e2bp+1,   -0x1.3112ef28a4c89p+0,  -0x1.fbe3a6p-2, INEXACT)
T(RN,    -0x1.4122e2fdd349p+1,   -0x1.3106d78179042p+0,  -0x1.f66498p-2, INEXACT)
T(RN,    -0x1.40f6c9418c01p+1,   -0x1.30fabea59a157p+0,  -0x1.f76b84p-2, INEXACT)
T(RN,   -0x1.40cab593a60e5p+1,   -0x1.30eea49504e26p+0,  -0x1.fb3f6ap-2, INEXACT)
T(RN,   -0x1.409ea7f34c818p+1,    -0x1.30e2894fb657p+0,   0x1.f6064cp-2, INEXACT)
T(RN,   -0x1.4072a05faa961p+1,   -0x1.30d66cd5ab6e1p+0,   0x1.f66f08p-2, INEXACT)
T(RN,   -0x1.40469ed7eb97cp+1,   -0x1.30ca4f26e1296p+0,  -0x1.f85b66p-2, INEXACT)
T(RN,   -0x1.401aa35b3af4bp+1,   -0x1.30be30435496cp+0,    0x1.f7235p-2, INEXACT)
T(RN,   -0x1.3feeade8c4454p+1,   -0x1.30b2102b02d2dp+0,  -0x1.ff39a4p-2, INEXACT)
T(RN,   -0x1.3fc2be7fb324cp+1,   -0x1.30a5eedde8fd5p+0,  -0x1.f60a6ep-2, INEXACT)
T(RN,   -0x1.3f96d51f33605p+1,   -0x1.3099cc5c0446cp+0,  -0x1.f69794p-2, INEXACT)
T(RN,   -0x1.3f6af1c670dc1p+1,   -0x1.308da8a551e8ap+0,   0x1.fa5516p-2, INEXACT)
T(RN,    -0x1.3f3f14749794p+1,    -0x1.308183b9cf26p+0,   0x1.ffb972p-2, INEXACT)
T(RN,   -0x1.3f133d28d3aeep+1,   -0x1.30755d9979506p+0,   0x1.ff9bb8p-2, INEXACT)
T(RN,   -0x1.3ee76be251602p+1,   -0x1.306936444dbfap+0,   0x1.fa78c6p-2, INEXACT)
T(RN,   -0x1.3ebba0a03d04bp+1,    -0x1.305d0dba49dap+0,   -0x1.fe496p-2, INEXACT)
T(RN,   -0x1.3e8fdb61c30d1p+1,   -0x1.3050e3fb6b0ddp+0,  -0x1.f61f88p-2, INEXACT)
T(RN,   -0x1.3e641c2610123p+1,   -0x1.3044b907aed7ap+0,  -0x1.f7d20cp-2, INEXACT)
T(RN,   -0x1.3e3862ec50bd5p+1,   -0x1.30388cdf12bb4p+0,   0x1.f87026p-2, INEXACT)
T(RN,   -0x1.3e0cafb3b1ddcp+1,   -0x1.302c5f81944a3p+0,   -0x1.fcd5cp-2, INEXACT)
T(RN,   -0x1.3de1027b605bcp+1,   -0x1.302030ef311f5p+0,    0x1.f8abap-2, INEXACT)
T(RN,   -0x1.3db55b42893e5p+1,   -0x1.30140127e6e17p+0,  -0x1.fd379ap-2, INEXACT)
T(RN,   -0x1.3d89ba0859aa3p+1,   -0x1.3007d02bb3422p+0,  -0x1.f8cdd6p-2, INEXACT)
T(RN,   -0x1.3d5e1ecbfedb2p+1,   -0x1.2ffb9dfa93fc7p+0,    0x1.f822bp-2, INEXACT)
T(RN,   -0x1.3d32898ca62e9p+1,   -0x1.2fef6a9486d7fp+0,  -0x1.f65f3ap-2, INEXACT)
T(RN,   -0x1.3d06fa497d2d5p+1,   -0x1.2fe335f989aaep+0,   -0x1.fa731p-2, INEXACT)
T(RN,   -0x1.3cdb7101b15c4p+1,   -0x1.2fd700299a4d8p+0,   0x1.ff0a6ap-2, INEXACT)
T(RN,   -0x1.3cafedb47076bp+1,   -0x1.2fcac924b6aa6p+0,    0x1.fc23cp-2, INEXACT)
T(RN,   -0x1.3c847060e84eap+1,   -0x1.2fbe90eadcb53p+0,   0x1.fed9dap-2, INEXACT)
T(RN,   -0x1.3c58f90646ccfp+1,   -0x1.2fb2577c0a6b2p+0,   -0x1.fc376p-2, INEXACT)
T(RN,   -0x1.3c2d87a3ba00ep+1,   -0x1.2fa61cd83dd6fp+0,  -0x1.fbc202p-2, INEXACT)
T(RN,    -0x1.3c021c38700ep+1,   -0x1.2f99e0ff750c4p+0,  -0x1.fa0576p-2, INEXACT)
T(RN,   -0x1.3bd6b6c3973d7p+1,   -0x1.2f8da3f1ae2c3p+0,   -0x1.faf41p-2, INEXACT)
T(RN,   -0x1.3bab57445debap+1,   -0x1.2f8165aee7604p+0,    0x1.f5cf4p-2, INEXACT)
T(RN,   -0x1.3b7ffdb9f29a7p+1,   -0x1.2f7526371edfcp+0,  -0x1.fea8c2p-2, INEXACT)
T(RN,   -0x1.3b54aa2383de8p+1,   -0x1.2f68e58a52e9ep+0,    0x1.fdf13p-2, INEXACT)
T(RN,   -0x1.3b295c8040766p+1,   -0x1.2f5ca3a881cd2p+0,    0x1.fb85bp-2, INEXACT)
T(RN,   -0x1.3afe14cf5730ap+1,   -0x1.2f506091a9df5p+0,   0x1.f83ac8p-2, INEXACT)
T(RN,   -0x1.3ad2d30ff701ap+1,   -0x1.2f441c45c9842p+0,  -0x1.fe9928p-2, INEXACT)
T(RN,   -0x1.3aa797414ef79p+1,   -0x1.2f37d6c4df297p+0,  -0x1.ff665cp-2, INEXACT)
T(RN,   -0x1.3a7c61628e352p+1,   -0x1.2f2b900ee9462p+0,   0x1.fbcffap-2, INEXACT)
T(RN,   -0x1.3a513172e4077p+1,   -0x1.2f1f4823e6605p+0,   0x1.f63444p-2, INEXACT)
T(RN,   -0x1.3a2607717fd2ap+1,   -0x1.2f12ff03d5079p+0,   0x1.fc069cp-2, INEXACT)
T(RN,   -0x1.39fae35d9117bp+1,   -0x1.2f06b4aeb3d6dp+0,   0x1.f5fbdep-2, INEXACT)
T(RN,   -0x1.39cfc5364769fp+1,   -0x1.2efa692481715p+0,   0x1.f64ea2p-2, INEXACT)
T(RN,   -0x1.39a4acfad29bap+1,   -0x1.2eee1c653c8f7p+0,  -0x1.ff344cp-2, INEXACT)
T(RN,   -0x1.39799aaa625a7p+1,   -0x1.2ee1ce70e3e21p+0,  -0x1.f6643cp-2, INEXACT)
T(RN,   -0x1.394e8e4426bf8p+1,   -0x1.2ed57f47763c1p+0,  -0x1.f6c8b4p-2, INEXACT)
T(RN,   -0x1.392387c74fc65p+1,   -0x1.2ec92ee8f26afp+0,  -0x1.f6f77cp-2, INEXACT)
T(RN,   -0x1.38f887330da19p+1,   -0x1.2ebcdd55574f2p+0,  -0x1.fad094p-2, INEXACT)
T(RN,   -0x1.38cd8c8690962p+1,   -0x1.2eb08a8ca3d17p+0,  -0x1.fc4136p-2, INEXACT)
T(RN,   -0x1.38a297c1090a8p+1,   -0x1.2ea4368ed6e78p+0,  -0x1.fadf34p-2, INEXACT)
T(RN,   -0x1.3877a8e1a77d6p+1,    -0x1.2e97e15bef91p+0,   0x1.ff33ccp-2, INEXACT)
T(RN,   -0x1.384cbfe79c89fp+1,   -0x1.2e8b8af3ecd94p+0,  -0x1.f9b712p-2, INEXACT)
T(RN,    -0x1.3821dcd218f2p+1,   -0x1.2e7f3356cdd98p+0,   -0x1.febafp-2, INEXACT)
T(RN,   -0x1.37f6ffa04d8c2p+1,   -0x1.2e72da8491b46p+0,   0x1.f98e6ap-2, INEXACT)
T(RN,   -0x1.37cc28516b436p+1,   -0x1.2e66807d3795cp+0,   0x1.f89fccp-2, INEXACT)
T(RN,   -0x1.37a156e4a32fcp+1,   -0x1.2e5a2540beb99p+0,  -0x1.f6ef3ep-2, INEXACT)
T(RN,   -0x1.37768b59267b7p+1,   -0x1.2e4dc8cf26642p+0,  -0x1.fb577ep-2, INEXACT)
T(RN,   -0x1.374bc5ae266b4p+1,   -0x1.2e416b286de4ep+0,  -0x1.f6cc98p-2, INEXACT)
T(RN,   -0x1.372105e2d466cp+1,   -0x1.2e350c4c94987p+0,   0x1.ff350ep-2, INEXACT)
T(RN,   -0x1.36f64bf661eccp+1,   -0x1.2e28ac3b99e5bp+0,  -0x1.ff71cap-2, INEXACT)
T(RN,   -0x1.36cb97e800a22p+1,   -0x1.2e1c4af57d417p+0,   -0x1.ffbe7p-2, INEXACT)
T(RN,   -0x1.36a0e9b6e23a4p+1,   -0x1.2e0fe87a3e283p+0,   0x1.f84a36p-2, INEXACT)
T(RN,    -0x1.367641623888p+1,   -0x1.2e0384c9dc231p+0,  -0x1.fd8fb4p-2, INEXACT)
T(RN,   -0x1.364b9ee935883p+1,   -0x1.2df71fe456ca5p+0,  -0x1.f8a568p-2, INEXACT)
T(RN,   -0x1.3621024b0b42cp+1,   -0x1.2deab9c9adbcfp+0,   0x1.fb162ap-2, INEXACT)
T(RN,   -0x1.35f66b86ebe6ep+1,   -0x1.2dde5279e0a8ep+0,  -0x1.ff74eap-2, INEXACT)
T(RN,   -0x1.35cbda9c09b6fp+1,   -0x1.2dd1e9f4ef44ap+0,  -0x1.fb931cp-2, INEXACT)
T(RN,   -0x1.35a14f899719ap+1,   -0x1.2dc5803ad954ep+0,   -0x1.f91bcp-2, INEXACT)
T(RN,    -0x1.3576ca4ec68dp+1,   -0x1.2db9154b9ea87p+0,  -0x1.fd5a92p-2, INEXACT)
T(RN,   -0x1.354c4aeacab0fp+1,   -0x1.2daca9273f1b5p+0,   0x1.feb0bap-2, INEXACT)
T(RN,   -0x1.3521d15cd63a7p+1,   -0x1.2da03bcdba934p+0,    0x1.fce94p-2, INEXACT)
T(RN,   -0x1.34f75da41c014p+1,   -0x1.2d93cd3f11036p+0,   0x1.fb2c4ep-2, INEXACT)
T(RN,   -0x1.34ccefbfceef6p+1,   -0x1.2d875d7b4267ap+0,   0x1.fa5934p-2, INEXACT)
T(RN,   -0x1.34a287af221adp+1,   -0x1.2d7aec824ecc4p+0,   0x1.fd3468p-2, INEXACT)
T(RN,   -0x1.3478257148a2cp+1,   -0x1.2d6e7a543643ap+0,   0x1.f9b524p-2, INEXACT)
T(RN,   -0x1.344dc90575c73p+1,   -0x1.2d6206f0f8ed3p+0,   0x1.f5d772p-2, INEXACT)
T(RN,   -0x1.3423726add14dp+1,   -0x1.2d55925897027p+0,  -0x1.f96246p-2, INEXACT)
T(RN,   -0x1.33f921a0b1d36p+1,   -0x1.2d491c8b10abep+0,  -0x1.f8a51ep-2, INEXACT)
T(RN,   -0x1.33ced6a627afep+1,   -0x1.2d3ca58866337p+0,  -0x1.fdc032p-2, INEXACT)
T(RN,   -0x1.33a4917a72641p+1,   -0x1.2d302d5097ea4p+0,  -0x1.feea44p-2, INEXACT)
T(RN,   -0x1.337a521cc5c0dp+1,   -0x1.2d23b3e3a62bcp+0,  -0x1.fd1d1ep-2, INEXACT)
T(RN,   -0x1.3350188c55adep+1,   -0x1.2d173941915d9p+0,   0x1.f610a8p-2, INEXACT)
T(RN,   -0x1.3325e4c856365p+1,   -0x1.2d0abd6a59f37p+0,   0x1.fa54dep-2, INEXACT)
T(RN,   -0x1.32fbb6cffb7f5p+1,   -0x1.2cfe405e006c3p+0,   0x1.f7d60ep-2, INEXACT)
T(RN,   -0x1.32d18ea279d72p+1,   -0x1.2cf1c21c85567p+0,  -0x1.f7da38p-2, INEXACT)
T(RN,   -0x1.32a76c3f058a6p+1,   -0x1.2ce542a5e943ap+0,   0x1.fde3b8p-2, INEXACT)
T(RN,   -0x1.327d4fa4d31c9p+1,   -0x1.2cd8c1fa2cd97p+0,  -0x1.fd9a04p-2, INEXACT)
T(RN,   -0x1.325338d316b66p+1,   -0x1.2ccc401950a5bp+0,  -0x1.f5ceeap-2, INEXACT)
T(RN,   -0x1.322927c906412p+1,   -0x1.2cbfbd0355bf5p+0,   0x1.f788d4p-2, INEXACT)
T(RN,   -0x1.31ff1c85d554dp+1,   -0x1.2cb338b83c909p+0,   0x1.fffafap-2, INEXACT)
T(RN,   -0x1.31d51708b9404p+1,   -0x1.2ca6b3380609ap+0,  -0x1.fd7428p-2, INEXACT)
T(RN,   -0x1.31ab1750e70dfp+1,   -0x1.2c9a2c82b309dp+0,   0x1.fc2c0ap-2, INEXACT)
T(RN,   -0x1.31811d5d93d7fp+1,   -0x1.2c8da49844791p+0,   0x1.fdb3dep-2, INEXACT)
T(RN,   -0x1.3157292df4dd3p+1,   -0x1.2c811b78bb4dbp+0,   0x1.f97812p-2, INEXACT)
T(RN,   -0x1.312d3ac13f7b9p+1,   -0x1.2c749124188afp+0,   0x1.fc1336p-2, INEXACT)
T(RN,   -0x1.31035216a9245p+1,   -0x1.2c68059a5d3d8p+0,   0x1.f6982ep-2, INEXACT)
T(RN,   -0x1.30d96f2d6766bp+1,   -0x1.2c5b78db8a7ebp+0,   0x1.f8486ap-2, INEXACT)
T(RN,   -0x1.30af9204af4b8p+1,   -0x1.2c4eeae7a1433p+0,  -0x1.f5e48ap-2, INEXACT)
T(RN,   -0x1.3085ba9bb8764p+1,   -0x1.2c425bbea34b3p+0,  -0x1.f678a6p-2, INEXACT)
T(RN,   -0x1.305be8f1b70edp+1,   -0x1.2c35cb60914f4p+0,   -0x1.f80aap-2, INEXACT)
T(RN,   -0x1.30321d05e184dp+1,   -0x1.2c2939cd6cbabp+0,   -0x1.fa734p-2, INEXACT)
T(RN,   -0x1.300856d76e0bbp+1,   -0x1.2c1ca70536ea8p+0,  -0x1.fd4e76p-2, INEXACT)
T(RN,   -0x1.2fde966592d6cp+1,   -0x1.2c101307f13f5p+0,   0x1.fd0b94p-2, INEXACT)
T(RN,   -0x1.2fb4dbaf863cbp+1,   -0x1.2c037dd59d286p+0,  -0x1.fb1d56p-2, INEXACT)
T(RN,   -0x1.2f8b26b47ea0bp+1,    -0x1.2bf6e76e3c1cp+0,   0x1.ff1112p-2, INEXACT)
T(RN,   -0x1.2f617773b2985p+1,   -0x1.2bea4fd1cfa3fp+0,  -0x1.f9e986p-2, INEXACT)
T(RN,   -0x1.2f37cdec58c16p+1,   -0x1.2bddb700594fcp+0,  -0x1.fc4c14p-2, INEXACT)
T(RN,   -0x1.2f0e2a1da7e23p+1,   -0x1.2bd11cf9dabf4p+0,  -0x1.f7255ap-2, INEXACT)
T(RN,   -0x1.2ee48c06d6d64p+1,   -0x1.2bc481be559c6p+0,  -0x1.ffad5cp-2, INEXACT)
T(RN,   -0x1.2ebaf3a71c94ap+1,   -0x1.2bb7e54dcb9d3p+0,  -0x1.ff7ad8p-2, INEXACT)
T(RN,   -0x1.2e9160fdb0343p+1,   -0x1.2bab47a83e853p+0,  -0x1.ffc4cep-2, INEXACT)
T(RN,   -0x1.2e67d409c8e49p+1,   -0x1.2b9ea8cdb0232p+0,   0x1.fd67cep-2, INEXACT)
T(RN,   -0x1.2e3e4cca9def5p+1,   -0x1.2b9208be2251ap+0,   0x1.fc3924p-2, INEXACT)
T(RN,   -0x1.2e14cb3f66bb6p+1,   -0x1.2b85677996f7ep+0,    0x1.fd2c3p-2, INEXACT)
T(RN,   -0x1.2deb4f675acb9p+1,   -0x1.2b78c50010098p+0,  -0x1.f8a31ep-2, INEXACT)
T(RN,   -0x1.2dc1d941b1c0cp+1,   -0x1.2b6c21518f86fp+0,   -0x1.fbaffp-2, INEXACT)
T(RN,   -0x1.2d9868cda34f6p+1,   -0x1.2b5f7c6e177a9p+0,   0x1.f84106p-2, INEXACT)
T(RN,   -0x1.2d6efe0a6754bp+1,   -0x1.2b52d655a9ff3p+0,    0x1.f7b09p-2, INEXACT)
T(RN,   -0x1.2d4598f735b55p+1,   -0x1.2b462f084935ap+0,  -0x1.fb7116p-2, INEXACT)
T(RN,   -0x1.2d1c3993468adp+1,   -0x1.2b398685f7529p+0,   0x1.f949d6p-2, INEXACT)
T(RN,   -0x1.2cf2dfddd1f26p+1,   -0x1.2b2cdcceb6902p+0,   -0x1.fc528p-2, INEXACT)
T(RN,   -0x1.2cc98bd610315p+1,   -0x1.2b2031e289382p+0,    0x1.fe5cap-2, INEXACT)
T(RN,   -0x1.2ca03d7b39a58p+1,   -0x1.2b1385c171a04p+0,   0x1.ff519ep-2, INEXACT)
T(RN,   -0x1.2c76f4cc86cfbp+1,   -0x1.2b06d86b722c9p+0,    0x1.fa2e3p-2, INEXACT)
T(RN,   -0x1.2c4db1c9303ebp+1,   -0x1.2afa29e08d497p+0,    0x1.f8b9bp-2, INEXACT)
T(RN,   -0x1.2c2474706e8dcp+1,   -0x1.2aed7a20c56b1p+0,  -0x1.f6c30ap-2, INEXACT)
T(RN,   -0x1.2bfb3cc17ac28p+1,   -0x1.2ae0c92c1d2a2p+0,  -0x1.f9c33cp-2, INEXACT)
T(RN,   -0x1.2bd20abb8d958p+1,   -0x1.2ad41702970bcp+0,  -0x1.fc9008p-2, INEXACT)
T(RN,   -0x1.2ba8de5de0134p+1,   -0x1.2ac763a435b2cp+0,   0x1.fc7e3ep-2, INEXACT)
T(RN,   -0x1.2b7fb7a7ab595p+1,   -0x1.2abaaf10fbcb6p+0,   0x1.fcbf4ep-2, INEXACT)
T(RN,     -0x1.2b56969828ap+1,    -0x1.2aadf948ec0ep+0,  -0x1.fbb3cap-2, INEXACT)
T(RN,   -0x1.2b2d7b2e9143dp+1,   -0x1.2aa1424c09421p+0,  -0x1.fb71bcp-2, INEXACT)
T(RN,   -0x1.2b04656a1eadfp+1,   -0x1.2a948a1a56371p+0,    0x1.f8422p-2, INEXACT)
T(RN,   -0x1.2adb554a0a68ap+1,   -0x1.2a87d0b3d5caep+0,   0x1.f60e34p-2, INEXACT)
T(RN,   -0x1.2ab24acd8e0e6p+1,   -0x1.2a7b16188ae44p+0,   0x1.f6e3aep-2, INEXACT)
T(RN,   -0x1.2a8945f3e38e9p+1,   -0x1.2a6e5a4878887p+0,  -0x1.fc3df8p-2, INEXACT)
T(RN,   -0x1.2a6046bc44982p+1,   -0x1.2a619d43a1ac8p+0,   0x1.fecc7cp-2, INEXACT)
T(RN,   -0x1.2a374d25eb289p+1,   -0x1.2a54df0a09626p+0,  -0x1.f6eaf4p-2, INEXACT)
T(RN,   -0x1.2a0e5930116b5p+1,   -0x1.2a481f9bb2cdfp+0,  -0x1.f9f306p-2, INEXACT)
T(RN,   -0x1.29e56ad9f1791p+1,   -0x1.2a3b5ef8a1118p+0,   0x1.fbeb8cp-2, INEXACT)
T(RN,   -0x1.29bc8222c59edp+1,   -0x1.2a2e9d20d763ep+0,   0x1.f5fd6ep-2, INEXACT)
T(RN,   -0x1.29939f09c849bp+1,   -0x1.2a21da145909dp+0,   0x1.f812d4p-2, INEXACT)
T(RN,   -0x1.296ac18e33f21p+1,   -0x1.2a1515d3294fdp+0,  -0x1.fe7436p-2, INEXACT)
T(RN,   -0x1.2941e9af4334cp+1,   -0x1.2a08505d4b91bp+0,  -0x1.f8bffcp-2, INEXACT)
T(RN,   -0x1.2919176c30c82p+1,   -0x1.29fb89b2c3378p+0,   0x1.fe4136p-2, INEXACT)
T(RN,   -0x1.28f04ac4377abp+1,   -0x1.29eec1d393b53p+0,  -0x1.fc96dep-2, INEXACT)
T(RN,   -0x1.28c783b69240cp+1,   -0x1.29e1f8bfc08e5p+0,  -0x1.ffb344p-2, INEXACT)
T(RN,   -0x1.289ec2427c19ep+1,   -0x1.29d52e774d4e6p+0,  -0x1.f955f2p-2, INEXACT)
T(RN,   -0x1.2876066730249p+1,   -0x1.29c862fa3d8eap+0,   0x1.f5fcb8p-2, INEXACT)
T(RN,   -0x1.284d5023e9b1ep+1,   -0x1.29bb964894fcap+0,  -0x1.fb3572p-2, INEXACT)
T(RN,   -0x1.28249f77e4055p+1,   -0x1.29aec86257457p+0,   0x1.ff52f2p-2, INEXACT)
T(RN,    -0x1.27fbf4625a9ap+1,   -0x1.29a1f947882c4p+0,   0x1.ff0064p-2, INEXACT)
T(RN,      -0x1.27d34ee289p+1,   -0x1.299528f82b7edp+0,   0x1.fb7458p-2, INEXACT)
T(RN,   -0x1.27aaaef7aad92p+1,   -0x1.298857744514cp+0,   0x1.f7ae8cp-2, INEXACT)
T(RN,   -0x1.278214a0fbfacp+1,   -0x1.297b84bbd8da4p+0,  -0x1.f842b4p-2, INEXACT)
T(RN,   -0x1.27597fddb837ep+1,   -0x1.296eb0ceeabedp+0,  -0x1.feae62p-2, INEXACT)
T(RN,   -0x1.2730f0ad1b882p+1,   -0x1.2961dbad7ec1ep+0,   0x1.fe4606p-2, INEXACT)
T(RN,   -0x1.2708670e6203bp+1,   -0x1.2955055798f19p+0,   0x1.ffcc2ap-2, INEXACT)
T(RN,   -0x1.26dfe300c7dfbp+1,   -0x1.29482dcd3d695p+0,  -0x1.feec64p-2, INEXACT)
T(RN,   -0x1.26b76483895fcp+1,   -0x1.293b550e704d5p+0,  -0x1.fe03e8p-2, INEXACT)
T(RN,    -0x1.268eeb95e2eep+1,   -0x1.292e7b1b35d26p+0,   0x1.f8007cp-2, INEXACT)
T(RN,   -0x1.26667837110b7p+1,   -0x1.29219ff392391p+0,  -0x1.f81374p-2, INEXACT)
T(RN,   -0x1.263e0a6650514p+1,   -0x1.2914c39789cd9p+0,   -0x1.fc687p-2, INEXACT)
T(RN,   -0x1.2615a222dd755p+1,   -0x1.2907e60720e9cp+0,  -0x1.f7dd2ep-2, INEXACT)
T(RN,    -0x1.25ed3f6bf54fp+1,   -0x1.28fb07425bf66p+0,   0x1.fbeeb4p-2, INEXACT)
T(RN,   -0x1.25c4e240d4c13p+1,   -0x1.28ee27493f646p+0,   0x1.fb7e5ep-2, INEXACT)
T(RN,   -0x1.259c8aa0b8d9cp+1,   -0x1.28e1461bcfb69p+0,   0x1.fa3b5ep-2, INEXACT)
T(RN,   -0x1.2574388adeb8dp+1,    -0x1.28d463ba117ap+0,   0x1.fc791ep-2, INEXACT)
T(RN,   -0x1.254bebfe8387fp+1,   -0x1.28c7802409432p+0,   0x1.f5d40ap-2, INEXACT)
T(RN,    -0x1.2523a4fae4d1p+1,   -0x1.28ba9b59bbc99p+0,   0x1.fe300ap-2, INEXACT)
T(RN,   -0x1.24fb637f3fd2dp+1,   -0x1.28adb55b2db16p+0,  -0x1.fd5e7ap-2, INEXACT)
T(RN,   -0x1.24d3278ad22fbp+1,   -0x1.28a0ce2863c2ap+0,   0x1.f6e496p-2, INEXACT)
T(RN,    -0x1.24aaf11cd98ap+1,   -0x1.2893e5c162ca3p+0,   0x1.fc7b22p-2, INEXACT)
T(RN,   -0x1.2482c03493a26p+1,   -0x1.2886fc262fa2ep+0,   -0x1.f7c7ap-2, INEXACT)
T(RN,   -0x1.245a94d13e55ep+1,   -0x1.287a1156cf34fp+0,  -0x1.fc2568p-2, INEXACT)
T(RN,   -0x1.24326ef217a33p+1,    -0x1.286d25534678p+0,   0x1.fe5152p-2, INEXACT)
T(RN,   -0x1.240a4e965d96cp+1,   -0x1.2860381b9a6cbp+0,   0x1.fb1ad4p-2, INEXACT)
T(RN,    -0x1.23e233bd4e5cp+1,   -0x1.285349afd021fp+0,  -0x1.ffb7eap-2, INEXACT)
T(RN,   -0x1.23ba1e662839dp+1,   -0x1.28465a0fecb3dp+0,   0x1.ff583ap-2, INEXACT)
T(RN,   -0x1.23920e9029921p+1,   -0x1.2839693bf54bfp+0,   0x1.fac966p-2, INEXACT)
T(RN,   -0x1.236a043a90e7cp+1,   -0x1.282c7733ef22ep+0,   0x1.f9596ap-2, INEXACT)
T(RN,   -0x1.2341ff649cc7cp+1,    -0x1.281f83f7df79p+0,  -0x1.fbb678p-2, INEXACT)
T(RN,    -0x1.231a000d8beap+1,   -0x1.28128f87cba0ep+0,   0x1.f8cd88p-2, INEXACT)
T(RN,   -0x1.22f206349d198p+1,   -0x1.280599e3b8f83p+0,  -0x1.fb5584p-2, INEXACT)
T(RN,    -0x1.22ca11d90f3bp+1,   -0x1.27f8a30bace91p+0,  -0x1.fe38cap-2, INEXACT)
T(RN,   -0x1.22a222fa21507p+1,   -0x1.27ebaaffacebdp+0,   0x1.fc9556p-2, INEXACT)
T(RN,   -0x1.227a399712744p+1,   -0x1.27deb1bfbe857p+0,  -0x1.fdd518p-2, INEXACT)
T(RN,   -0x1.225255af21e0dp+1,   -0x1.27d1b74be7497p+0,   0x1.fdfdd8p-2, INEXACT)
T(RN,   -0x1.222a77418ee2cp+1,   -0x1.27c4bba42cd64p+0,   0x1.f5faf4p-2, INEXACT)
T(RN,   -0x1.22029e4d98e53p+1,   -0x1.27b7bec894d8ap+0,  -0x1.f6ccbap-2, INEXACT)
T(RN,   -0x1.21dacad27f702p+1,   -0x1.27aac0b9250b2p+0,   0x1.fcec98p-2, INEXACT)
T(RN,   -0x1.21b2fccf82206p+1,   -0x1.279dc175e3342p+0,   -0x1.fb103p-2, INEXACT)
T(RN,   -0x1.218b3443e0b4bp+1,   -0x1.2790c0fed5293p+0,    0x1.fff63p-2, INEXACT)
T(RN,   -0x1.2163712edafc8p+1,   -0x1.2783bf5400ca6p+0,   0x1.ff8c44p-2, INEXACT)
T(RN,   -0x1.213bb38fb0e7cp+1,   -0x1.2776bc756c06cp+0,   0x1.f69376p-2, INEXACT)
T(RN,   -0x1.2113fb65a2836p+1,   -0x1.2769b8631cdb9p+0,   0x1.f9a7b6p-2, INEXACT)
T(RN,   -0x1.20ec48afefee3p+1,   -0x1.275cb31d19509p+0,   0x1.f94106p-2, INEXACT)
T(RN,   -0x1.20c49b6dd96e6p+1,   -0x1.274faca3677f1p+0,   0x1.fe6a74p-2, INEXACT)
T(RN,   -0x1.209cf39e9f517p+1,   -0x1.2742a4f60d877p+0,    0x1.f5de6p-2, INEXACT)
T(RN,   -0x1.2075514182142p+1,   -0x1.27359c15119e4p+0,   0x1.fc8b16p-2, INEXACT)
T(RN,   -0x1.204db455c2414p+1,   -0x1.272892007a016p+0,   0x1.fde8ccp-2, INEXACT)
T(RN,   -0x1.20261cdaa07b9p+1,   -0x1.271b86b84cfb4p+0,   0x1.f98018p-2, INEXACT)
T(RN,   -0x1.1ffe8acf5d87fp+1,   -0x1.270e7a3c90e65p+0,  -0x1.ffee2ap-2, INEXACT)
T(RN,   -0x1.1fd6fe333a43dp+1,   -0x1.27016c8d4c299p+0,   0x1.f878cep-2, INEXACT)
T(RN,   -0x1.1faf770577a13p+1,   -0x1.26f45daa8537ep+0,    0x1.f7657p-2, INEXACT)
T(RN,    -0x1.1f87f54556b4p+1,   -0x1.26e74d944293dp+0,    0x1.fb119p-2, INEXACT)
T(RN,    -0x1.1f6078f218acp+1,   -0x1.26da3c4a8acdfp+0,   0x1.f8a7e2p-2, INEXACT)
T(RN,   -0x1.1f39020afebdep+1,   -0x1.26cd29cd647d3p+0,    0x1.f814ep-2, INEXACT)
T(RN,   -0x1.1f11908f4a5aep+1,   -0x1.26c0161cd6515p+0,   0x1.f80414p-2, INEXACT)
T(RN,    -0x1.1eea247e3cf7p+1,   -0x1.26b30138e6ffcp+0,   0x1.f7c808p-2, INEXACT)
T(RN,     -0x1.1ec2bdd7182p+1,   -0x1.26a5eb219d4b4p+0,   0x1.f70c6ep-2, INEXACT)
T(RN,   -0x1.1e9b5c991d77ep+1,   -0x1.2698d3d700021p+0,    0x1.f6299p-2, INEXACT)
T(RN,   -0x1.1e7400c38ec77p+1,   -0x1.268bbb5916042p+0,   0x1.f65506p-2, INEXACT)
T(RN,   -0x1.1e4caa55addd6p+1,   -0x1.267ea1a7e6382p+0,   0x1.f629f6p-2, INEXACT)
T(RN,   -0x1.1e25594ebcf6bp+1,   -0x1.267186c377ae6p+0,   -0x1.f5fbap-2, INEXACT)
T(RN,   -0x1.1dfe0dadfe8a3p+1,   -0x1.26646aabd18f3p+0,  -0x1.f667e2p-2, INEXACT)
T(RN,   -0x1.1dd6c772b3fafp+1,   -0x1.26574d60faabep+0,  -0x1.f7d3b8p-2, INEXACT)
T(RN,   -0x1.1daf869c1fc48p+1,   -0x1.264a2ee2fa381p+0,  -0x1.f5e976p-2, INEXACT)
T(RN,   -0x1.1d884b2984608p+1,   -0x1.263d0f31d76bap+0,  -0x1.f95f68p-2, INEXACT)
T(RN,   -0x1.1d61151a2456cp+1,   -0x1.262fee4d99881p+0,  -0x1.fa416ap-2, INEXACT)
T(RN,   -0x1.1d39e46d423cbp+1,   -0x1.2622cc3647d85p+0,  -0x1.f8b958p-2, INEXACT)
T(RN,   -0x1.1d12b92220c8cp+1,   -0x1.2615a8ebe9b74p+0,  -0x1.f8fd5ap-2, INEXACT)
T(RN,   -0x1.1ceb933802b72p+1,   -0x1.2608846e86869p+0,  -0x1.fbe65ap-2, INEXACT)
T(RN,   -0x1.1cc472ae2b01fp+1,   -0x1.25fb5ebe25c1ap+0,   -0x1.fe046p-2, INEXACT)
T(RN,   -0x1.1c9d5783dc9bfp+1,   -0x1.25ee37dacee64p+0,  -0x1.f6b188p-2, INEXACT)
T(RN,    -0x1.1c7641b85aa4p+1,    -0x1.25e10fc48986p+0,  -0x1.f8611ep-2, INEXACT)
T(RN,   -0x1.1c4f314ae8496p+1,   -0x1.25d3e67b5d3cep+0,  -0x1.f7bb08p-2, INEXACT)
T(RN,   -0x1.1c28263ac8e42p+1,   -0x1.25c6bbff51b99p+0,  -0x1.f95b6ep-2, INEXACT)
T(RN,   -0x1.1c0120873fd44p+1,   -0x1.25b990506eb26p+0,  -0x1.fc15a6p-2, INEXACT)
T(RN,   -0x1.1bda202f909ecp+1,   -0x1.25ac636ebbef1p+0,  -0x1.fb9cf2p-2, INEXACT)
T(RN,   -0x1.1bb32532fed9fp+1,   -0x1.259f355a41423p+0,  -0x1.fcf01cp-2, INEXACT)
T(RN,   -0x1.1b8c2f90ce44bp+1,    -0x1.259206130691p+0,   -0x1.fd412p-2, INEXACT)
T(RN,   -0x1.1b653f4842a8ap+1,   -0x1.2584d59913c96p+0,   -0x1.fefe7p-2, INEXACT)
T(RN,   -0x1.1b3e54589ff0ap+1,   -0x1.2577a3ec70e97p+0,  -0x1.fc7634p-2, INEXACT)
T(RN,   -0x1.1b176ec12a20ap+1,   -0x1.256a710d25fcdp+0,  -0x1.fa1858p-2, INEXACT)
T(RN,   -0x1.1af08e8125533p+1,   -0x1.255d3cfb3b1bcp+0,   0x1.fe5c0ep-2, INEXACT)
T(RN,   -0x1.1ac9b397d5c13p+1,    -0x1.255007b6b86ep+0,   0x1.f9f694p-2, INEXACT)
T(RN,   -0x1.1aa2de047fbb2p+1,   -0x1.2542d13fa6283p+0,   0x1.f61234p-2, INEXACT)
T(RN,   -0x1.1a7c0dc667aa6p+1,   -0x1.253599960c8c9p+0,  -0x1.fb2026p-2, INEXACT)
T(RN,   -0x1.1a5542dcd213ep+1,   -0x1.252860b9f3eb9p+0,   0x1.f664d4p-2, INEXACT)
T(RN,   -0x1.1a2e7d4703944p+1,   -0x1.251b26ab64a32p+0,   0x1.f9b59ap-2, INEXACT)
T(RN,   -0x1.1a07bd0440e1fp+1,   -0x1.250deb6a671edp+0,   0x1.f767dcp-2, INEXACT)
T(RN,   -0x1.19e10213ced33p+1,   -0x1.2500aef703da3p+0,   0x1.f6762ep-2, INEXACT)
T(RN,   -0x1.19ba4c74f24f3p+1,   -0x1.24f37151435bcp+0,  -0x1.fbe7aep-2, INEXACT)
T(RN,   -0x1.19939c26f058ap+1,   -0x1.24e632792e384p+0,   0x1.fb4bfap-2, INEXACT)
T(RN,   -0x1.196cf1290e152p+1,   -0x1.24d8f26ecd15ep+0,   0x1.f8449ap-2, INEXACT)
T(RN,   -0x1.19464b7a90b66p+1,   -0x1.24cbb13228a3ep+0,  -0x1.fd479ep-2, INEXACT)
T(RN,   -0x1.191fab1abd8f1p+1,   -0x1.24be6ec349a1dp+0,  -0x1.fca432p-2, INEXACT)
T(RN,   -0x1.18f91008da087p+1,   -0x1.24b12b2238dc4p+0,    0x1.f6115p-2, INEXACT)
T(RN,   -0x1.18d27a442bb2dp+1,   -0x1.24a3e64eff328p+0,  -0x1.fd6c44p-2, INEXACT)
T(RN,   -0x1.18abe9cbf81d8p+1,   -0x1.2496a049a5884p+0,   0x1.fe3ffep-2, INEXACT)
T(RN,   -0x1.18855e9f8507bp+1,   -0x1.2489591234d74p+0,   0x1.f9d138p-2, INEXACT)
T(RN,   -0x1.185ed8be1849dp+1,   -0x1.247c10a8b626fp+0,  -0x1.f86becp-2, INEXACT)
T(RN,   -0x1.18385826f7c42p+1,   -0x1.246ec70d32867p+0,   0x1.fa064ap-2, INEXACT)
T(RN,   -0x1.1811dcd9697efp+1,   -0x1.24617c3fb3184p+0,   0x1.fe81fap-2, INEXACT)
T(RN,   -0x1.17eb66d4b39b2p+1,   -0x1.24543040410c6p+0,  -0x1.fbc144p-2, INEXACT)
T(RN,    -0x1.17c4f6181c2cp+1,   -0x1.2446e30ee5933p+0,  -0x1.f5d242p-2, INEXACT)
T(RN,   -0x1.179e8aa2e9e89p+1,   -0x1.243994abaa1b1p+0,   0x1.f5ff06p-2, INEXACT)
T(RN,   -0x1.1778247462d92p+1,   -0x1.242c451697db4p+0,   0x1.fc6b82p-2, INEXACT)
T(RN,   -0x1.1751c38bcda1dp+1,   -0x1.241ef44fb8461p+0,  -0x1.fcf68cp-2, INEXACT)
T(RN,   -0x1.172b67e870de1p+1,   -0x1.2411a25714cfep+0,   0x1.f69f4ap-2, INEXACT)
T(RN,   -0x1.17051189934bep+1,   -0x1.24044f2cb6fecp+0,  -0x1.fd2f18p-2, INEXACT)
T(RN,   -0x1.16dec06e7bb6bp+1,   -0x1.23f6fad0a8624p+0,  -0x1.fbd876p-2, INEXACT)
T(RN,   -0x1.16b874967108ap+1,   -0x1.23e9a542f29a1p+0,   0x1.ff896ep-2, INEXACT)
T(RN,   -0x1.16922e00ba4a1p+1,   -0x1.23dc4e839f55dp+0,   0x1.f96ebcp-2, INEXACT)
T(RN,   -0x1.166becac9e942p+1,   -0x1.23cef692b8502p+0,  -0x1.fa3076p-2, INEXACT)
T(RN,   -0x1.1645b099651bfp+1,   -0x1.23c19d7047528p+0,   0x1.fb2654p-2, INEXACT)
T(RN,   -0x1.161f79c655332p+1,   -0x1.23b4431c56361p+0,   0x1.f94b02p-2, INEXACT)
T(RN,   -0x1.15f94832b6476p+1,   -0x1.23a6e796eee2ep+0,  -0x1.fe610ap-2, INEXACT)
T(RN,   -0x1.15d31bddcfcc4p+1,   -0x1.23998ae01b484p+0,   -0x1.f6aebp-2, INEXACT)
T(RN,   -0x1.15acf4c6e9764p+1,   -0x1.238c2cf7e571cp+0,  -0x1.f70d5cp-2, INEXACT)
T(RN,   -0x1.1586d2ed4ae68p+1,   -0x1.237ecdde57696p+0,   0x1.fe3132p-2, INEXACT)
T(RN,   -0x1.1560b6503bf08p+1,   -0x1.23716d937b505p+0,   0x1.fdfd88p-2, INEXACT)
T(RN,   -0x1.153a9eef04822p+1,   -0x1.23640c175b563p+0,   0x1.f75c34p-2, INEXACT)
T(RN,   -0x1.15148cc8ec931p+1,   -0x1.2356a96a01b39p+0,  -0x1.f74a82p-2, INEXACT)
T(RN,   -0x1.14ee7fdd3c42dp+1,   -0x1.2349458b78b42p+0,   0x1.fdfee6p-2, INEXACT)
T(RN,   -0x1.14c8782b3bc49p+1,   -0x1.233be07bcab04p+0,   0x1.fc9f3ep-2, INEXACT)
T(RN,   -0x1.14a275b23366fp+1,   -0x1.232e7a3b020f2p+0,    0x1.f7602p-2, INEXACT)
T(RN,   -0x1.147c78716b8cep+1,   -0x1.232112c92944ap+0,  -0x1.fd27eap-2, INEXACT)
T(RN,   -0x1.145680682cb01p+1,   -0x1.2313aa264ad1ep+0,  -0x1.f72d7ap-2, INEXACT)
T(RN,   -0x1.14308d95bf792p+1,   -0x1.23064052714e3p+0,  -0x1.fcb828p-2, INEXACT)
T(RN,   -0x1.140a9ff96c8cap+1,   -0x1.22f8d54da754dp+0,   -0x1.ffc1bp-2, INEXACT)
T(RN,   -0x1.13e4b7927cb93p+1,   -0x1.22eb6917f7955p+0,  -0x1.fd87aep-2, INEXACT)
T(RN,   -0x1.13bed46038deep+1,   -0x1.22ddfbb16ccadp+0,   0x1.fc7f4ep-2, INEXACT)
T(RN,   -0x1.1398f661ea056p+1,   -0x1.22d08d1a11c43p+0,  -0x1.f85a12p-2, INEXACT)
T(RN,   -0x1.13731d96d935bp+1,   -0x1.22c31d51f155ep+0,  -0x1.ff02b6p-2, INEXACT)
T(RN,   -0x1.134d49fe4faa6p+1,   -0x1.22b5ac59166b9p+0,   0x1.fe7cd8p-2, INEXACT)
T(RN,   -0x1.13277b9796a51p+1,   -0x1.22a83a2f8bf92p+0,  -0x1.f94f22p-2, INEXACT)
T(RN,   -0x1.1301b261f7879p+1,   -0x1.229ac6d55d02fp+0,   0x1.f90724p-2, INEXACT)
T(RN,   -0x1.12dbee5cbbd21p+1,   -0x1.228d524a949e2p+0,   0x1.fd26e8p-2, INEXACT)
T(RN,   -0x1.12b62f872d11bp+1,   -0x1.227fdc8f3de9bp+0,   0x1.f9e2ecp-2, INEXACT)
T(RN,   -0x1.129075e094e8cp+1,   -0x1.227265a36411cp+0,   0x1.f670c8p-2, INEXACT)
T(RN,   -0x1.126ac1683d492p+1,   -0x1.2264ed8712646p+0,   0x1.f6c604p-2, INEXACT)
T(RN,    -0x1.1245121d6fddp+1,   -0x1.2257743a541bap+0,  -0x1.f93d3ap-2, INEXACT)
T(RN,   -0x1.121f67ff76bd8p+1,   -0x1.2249f9bd349e9p+0,  -0x1.fee4b8p-2, INEXACT)
T(RN,   -0x1.11f9c30d9be93p+1,   -0x1.223c7e0fbf507p+0,   0x1.ff65e4p-2, INEXACT)
T(RN,   -0x1.11d4234729922p+1,   -0x1.222f0131ffacbp+0,  -0x1.ff906ep-2, INEXACT)
T(RN,   -0x1.11ae88ab69fbfp+1,   -0x1.22218324013a3p+0,    0x1.fc9dfp-2, INEXACT)
T(RN,   -0x1.1188f339a77c8p+1,   -0x1.221403e5cf8c7p+0,  -0x1.fa8226p-2, INEXACT)
T(RN,   -0x1.116362f12c8f6p+1,   -0x1.2206837776499p+0,   0x1.fd9a26p-2, INEXACT)
T(RN,   -0x1.113dd7d143bf8p+1,   -0x1.21f901d901234p+0,   0x1.ff1d18p-2, INEXACT)
T(RN,   -0x1.111851d937b1cp+1,   -0x1.21eb7f0a7bd9ep+0,   0x1.f73756p-2, INEXACT)
T(RN,   -0x1.10f2d10853254p+1,    -0x1.21ddfb0bf23dp+0,  -0x1.f9e9b4p-2, INEXACT)
T(RN,   -0x1.10cd555de0f6fp+1,   -0x1.21d075dd702c5p+0,    0x1.f7f8ap-2, INEXACT)
T(RN,   -0x1.10a7ded92c146p+1,   -0x1.21c2ef7f01938p+0,   0x1.feae7ep-2, INEXACT)
T(RN,   -0x1.10826d797f87dp+1,    -0x1.21b567f0b26ep+0,   0x1.fd4f72p-2, INEXACT)
T(RN,    -0x1.105d013e2674p+1,   -0x1.21a7df328ec5ep+0,  -0x1.fccd6cp-2, INEXACT)
T(RN,   -0x1.10379a266c166p+1,   -0x1.219a5544a2b45p+0,  -0x1.fbaa7cp-2, INEXACT)
T(RN,   -0x1.101238319bc23p+1,   -0x1.218cca26fa604p+0,  -0x1.fd8bbap-2, INEXACT)
T(RN,   -0x1.0fecdb5f00e89p+1,    -0x1.217f3dd9a201p+0,   0x1.fd4018p-2, INEXACT)
T(RN,   -0x1.0fc783ade7063p+1,   -0x1.2171b05ca5d7fp+0,   0x1.faa47ap-2, INEXACT)
T(RN,   -0x1.0fa2311d99c4bp+1,   -0x1.216421b0123c4p+0,    0x1.f7f65p-2, INEXACT)
T(RN,   -0x1.0f7ce3ad64ae6p+1,   -0x1.215691d3f37f9p+0,  -0x1.f5dad4p-2, INEXACT)
T(RN,   -0x1.0f579b5c940b9p+1,   -0x1.214900c8563e2p+0,  -0x1.f6e4acp-2, INEXACT)
T(RN,   -0x1.0f32582a73546p+1,   -0x1.213b6e8d46ce6p+0,  -0x1.fbf3c8p-2, INEXACT)
T(RN,   -0x1.0f0d1a164eab7p+1,   -0x1.212ddb22d1ca6p+0,   0x1.ffffd6p-2, INEXACT)
T(RN,   -0x1.0ee7e11f722c5p+1,   -0x1.2120468903cfap+0,  -0x1.fd526cp-2, INEXACT)
T(RN,   -0x1.0ec2ad452a0c7p+1,   -0x1.2112b0bfe98a6p+0,   0x1.fa0cbcp-2, INEXACT)
T(RN,   -0x1.0e9d7e86c2944p+1,   -0x1.210519c78fb41p+0,  -0x1.faa04ap-2, INEXACT)
T(RN,   -0x1.0e7854e3882ebp+1,    -0x1.20f781a00318p+0,    0x1.f6622p-2, INEXACT)
T(RN,   -0x1.0e53305ac74fep+1,   -0x1.20e9e849508b1p+0,   0x1.fca96cp-2, INEXACT)
T(RN,   -0x1.0e2e10ebcc9aap+1,   -0x1.20dc4dc384f8cp+0,   0x1.f7a572p-2, INEXACT)
T(RN,   -0x1.0e08f695e4b46p+1,   -0x1.20ceb20ead537p+0,  -0x1.f850ccp-2, INEXACT)
T(RN,   -0x1.0de3e1585c661p+1,   -0x1.20c1152ad6a02p+0,  -0x1.f6b6fep-2, INEXACT)
T(RN,    -0x1.0dbed1328091p+1,   -0x1.20b377180df2cp+0,  -0x1.f76fdcp-2, INEXACT)
T(RN,   -0x1.0d99c6239e2a1p+1,   -0x1.20a5d7d6606c2p+0,   0x1.f684c4p-2, INEXACT)
T(RN,   -0x1.0d74c02b024a5p+1,   -0x1.20983765db406p+0,   0x1.f8374ap-2, INEXACT)
T(RN,   -0x1.0d4fbf47fa09cp+1,   -0x1.208a95c68ba8fp+0,  -0x1.f611e8p-2, INEXACT)
T(RN,   -0x1.0d2ac379d2cf3p+1,    -0x1.207cf2f87f02p+0,  -0x1.f975ecp-2, INEXACT)
T(RN,     -0x1.0d05ccbfd9dp+1,   -0x1.206f4efbc29b9p+0,  -0x1.fc9dd6p-2, INEXACT)
T(RN,   -0x1.0ce0db195c922p+1,   -0x1.2061a9d063e92p+0,   -0x1.f791ep-2, INEXACT)
T(RN,   -0x1.0cbbee85a89b8p+1,   -0x1.2054037670641p+0,  -0x1.f725bcp-2, INEXACT)
T(RN,   -0x1.0c9707040b8bap+1,    -0x1.20465bedf595p+0,   0x1.f76e8cp-2, INEXACT)
T(RN,   -0x1.0c722493d32ffp+1,   -0x1.2038b337011bbp+0,  -0x1.f8644ap-2, INEXACT)
T(RN,   -0x1.0c4d47344d4f9p+1,    -0x1.202b0951a09bp+0,   0x1.f7549cp-2, INEXACT)
T(RN,   -0x1.0c286ee4c7db7p+1,   -0x1.201d5e3de1cbap+0,   0x1.fb1c78p-2, INEXACT)
T(RN,   -0x1.0c039ba490dadp+1,   -0x1.200fb1fbd2744p+0,  -0x1.ff3bbep-2, INEXACT)
T(RN,   -0x1.0bdecd72f66dcp+1,   -0x1.2002048b806a8p+0,   0x1.fb9d32p-2, INEXACT)
T(RN,   -0x1.0bba044f46ca1p+1,   -0x1.1ff455ecf9927p+0,  -0x1.f776a2p-2, INEXACT)
T(RN,   -0x1.0b954038d03c7p+1,   -0x1.1fe6a6204bde1p+0,   0x1.ffe784p-2, INEXACT)
T(RN,    -0x1.0b70812ee135p+1,    -0x1.1fd8f5258553p+0,  -0x1.f96da4p-2, INEXACT)
T(RN,   -0x1.0b4bc730c828ep+1,   -0x1.1fcb42fcb3fe3p+0,   0x1.fa0c4ap-2, INEXACT)
T(RN,   -0x1.0b27123dd3b94p+1,   -0x1.1fbd8fa5e6036p+0,   0x1.f6a9d8p-2, INEXACT)
T(RN,   -0x1.0b02625552942p+1,   -0x1.1fafdb212990dp+0,   0x1.f64ec4p-2, INEXACT)
T(RN,   -0x1.0addb77693876p+1,   -0x1.1fa2256e8ce6bp+0,   0x1.fd41f4p-2, INEXACT)
T(RN,   -0x1.0ab911a0e5715p+1,   -0x1.1f946e8e1e516p+0,  -0x1.f982ecp-2, INEXACT)
T(RN,   -0x1.0a9470d397338p+1,   -0x1.1f86b67fec243p+0,   0x1.f61d2ep-2, INEXACT)
T(RN,   -0x1.0a6fd50df7e3dp+1,   -0x1.1f78fd4404cc7p+0,  -0x1.f5f9dap-2, INEXACT)
T(RN,   -0x1.0a4b3e4f572bdp+1,   -0x1.1f6b42da76f47p+0,   -0x1.f8225p-2, INEXACT)
T(RN,   -0x1.0a26ac9703a35p+1,   -0x1.1f5d874350e61p+0,  -0x1.f97c4cp-2, INEXACT)
T(RN,   -0x1.0a021fe44ce58p+1,   -0x1.1f4fca7ea1527p+0,  -0x1.fb15acp-2, INEXACT)
T(RN,   -0x1.09dd9836826e4p+1,    -0x1.1f420c8c76e5p+0,   -0x1.fdd58p-2, INEXACT)
T(RN,    -0x1.09b9158cf3bep+1,   -0x1.1f344d6ce050fp+0,  -0x1.f6c538p-2, INEXACT)
T(RN,   -0x1.099497e6f07fcp+1,   -0x1.1f268d1fec5f8p+0,   -0x1.fafcbp-2, INEXACT)
T(RN,   -0x1.09701f43c869dp+1,   -0x1.1f18cba5a9e44p+0,  -0x1.f761d2p-2, INEXACT)
T(RN,   -0x1.094baba2cb555p+1,   -0x1.1f0b08fe27c5ep+0,   0x1.f9aeb6p-2, INEXACT)
T(RN,   -0x1.09273d03492afp+1,   -0x1.1efd452974f74p+0,   -0x1.fbf2bp-2, INEXACT)
T(RN,   -0x1.0902d36491f71p+1,   -0x1.1eef8027a07e6p+0,   0x1.fc3bf8p-2, INEXACT)
T(RN,   -0x1.08de6ec5f5cdap+1,   -0x1.1ee1b9f8b96abp+0,  -0x1.f6af9ap-2, INEXACT)
T(RN,   -0x1.08ba0f26c4e7dp+1,   -0x1.1ed3f29ccedf5p+0,   0x1.f7deb2p-2, INEXACT)
T(RN,    -0x1.0895b4864f95p+1,   -0x1.1ec62a13f00e5p+0,   0x1.f8923cp-2, INEXACT)
T(RN,   -0x1.08715ee3e6379p+1,   -0x1.1eb8605e2c36dp+0,   0x1.fd35c6p-2, INEXACT)
T(RN,   -0x1.084d0e3ed94dcp+1,   -0x1.1eaa957b92a8cp+0,  -0x1.fc070ap-2, INEXACT)
T(RN,   -0x1.0828c296796bep+1,   -0x1.1e9cc96c32c26p+0,  -0x1.f800dap-2, INEXACT)
T(RN,   -0x1.08047bea173f9p+1,   -0x1.1e8efc301bf1dp+0,   0x1.f905e4p-2, INEXACT)
T(RN,   -0x1.07e03a3902e9bp+1,   -0x1.1e812dc75d75ep+0,   -0x1.f5dccp-2, INEXACT)
T(RN,   -0x1.07bbfd828f41bp+1,   -0x1.1e735e32079bcp+0,  -0x1.fc262ep-2, INEXACT)
T(RN,    -0x1.0797c5c60b41p+1,   -0x1.1e658d70293ddp+0,   0x1.f63e8cp-2, INEXACT)
T(RN,   -0x1.07739302c89c8p+1,   -0x1.1e57bb81d2474p+0,  -0x1.fd2f14p-2, INEXACT)
T(RN,   -0x1.074f6538187bap+1,   -0x1.1e49e86712732p+0,     0x1.f5edp-2, INEXACT)
T(RN,   -0x1.072b3c654c203p+1,   -0x1.1e3c141ff98d4p+0,  -0x1.f75de8p-2, INEXACT)
T(RN,   -0x1.07071889b4dd5p+1,   -0x1.1e2e3eac976ddp+0,  -0x1.f99f32p-2, INEXACT)
T(RN,   -0x1.06e2f9a4a41ddp+1,   -0x1.1e20680cfbfc7p+0,   0x1.f953a6p-2, INEXACT)
T(RN,   -0x1.06bedfb56b6cfp+1,   -0x1.1e12904137338p+0,   0x1.f61678p-2, INEXACT)
T(RN,   -0x1.069acabb5c64ep+1,   -0x1.1e04b74959192p+0,   0x1.fe0feap-2, INEXACT)
T(RN,   -0x1.0676bab5c8bdep+1,   -0x1.1df6dd2571c55p+0,  -0x1.fa5b94p-2, INEXACT)
T(RN,   -0x1.0652afa3fd6e8p+1,   -0x1.1de901d58f81bp+0,   0x1.f5c392p-2, INEXACT)
T(RN,   -0x1.062ea9855add8p+1,   -0x1.1ddb2559c8186p+0,   0x1.fecdc6p-2, INEXACT)
T(RN,   -0x1.060aa8592487ep+1,   -0x1.1dcd47b2263abp+0,    0x1.fec41p-2, INEXACT)
T(RN,   -0x1.05e6ac1eb1582p+1,   -0x1.1dbf68debc193p+0,  -0x1.fcc6c8p-2, INEXACT)
T(RN,   -0x1.05c2b4d5537d9p+1,   -0x1.1db188df9a18bp+0,  -0x1.fe0a12p-2, INEXACT)
T(RN,   -0x1.059ec27c5d39ap+1,   -0x1.1da3a7b4d0ab7p+0,  -0x1.f78ab6p-2, INEXACT)
T(RN,   -0x1.057ad51320f08p+1,   -0x1.1d95c55e70574p+0,   0x1.f9b75cp-2, INEXACT)
T(RN,   -0x1.0556ec98f10f6p+1,   -0x1.1d87e1dc89abfp+0,   -0x1.fad35p-2, INEXACT)
T(RN,   -0x1.0533090d20271p+1,   -0x1.1d79fd2f2d4cfp+0,   0x1.fdd3f2p-2, INEXACT)
T(RN,   -0x1.050f2a6f00d9ep+1,   -0x1.1d6c17566beb3p+0,    0x1.f7b87p-2, INEXACT)
T(RN,   -0x1.04eb50bde5e5cp+1,   -0x1.1d5e305256486p+0,   0x1.fde118p-2, INEXACT)
T(RN,   -0x1.04c77bf92221fp+1,   -0x1.1d504822fd367p+0,   -0x1.febbfp-2, INEXACT)
T(RN,   -0x1.04a3ac20086cap+1,   -0x1.1d425ec871901p+0,   0x1.f8e576p-2, INEXACT)
T(RN,   -0x1.047fe131ebe5ap+1,   -0x1.1d347442c4503p+0,  -0x1.fc75a6p-2, INEXACT)
T(RN,   -0x1.045c1b2e1f8ddp+1,   -0x1.1d268892066bap+0,  -0x1.fcfccep-2, INEXACT)
T(RN,   -0x1.04385a13f6a34p+1,   -0x1.1d189bb648f59p+0,  -0x1.fb71e2p-2, INEXACT)
T(RN,   -0x1.04149de2c46c4p+1,   -0x1.1d0aadaf9d0abp+0,  -0x1.f6e632p-2, INEXACT)
T(RN,   -0x1.03f0e699dc501p+1,   -0x1.1cfcbe7e13daep+0,  -0x1.f81ab8p-2, INEXACT)
T(RN,    -0x1.03cd343891cap+1,   -0x1.1ceece21bea43p+0,   -0x1.fc297p-2, INEXACT)
T(RN,   -0x1.03a986be3867dp+1,   -0x1.1ce0dc9aaeb23p+0,   0x1.f8fe2ep-2, INEXACT)
T(RN,   -0x1.0385de2a23992p+1,   -0x1.1cd2e9e8f54b4p+0,   -0x1.f5d1bp-2, INEXACT)
T(RN,   -0x1.03623a7ba7d02p+1,   -0x1.1cc4f60ca420fp+0,  -0x1.faf17cp-2, INEXACT)
T(RN,   -0x1.033e9bb2183e4p+1,   -0x1.1cb70105cc6dep+0,   0x1.f631ecp-2, INEXACT)
T(RN,   -0x1.031b01ccc9005p+1,   -0x1.1ca90ad47fcf5p+0,    0x1.ff9ffp-2, INEXACT)
T(RN,   -0x1.02f76ccb0e242p+1,   -0x1.1c9b1378cfe2ep+0,   0x1.fa824ep-2, INEXACT)
T(RN,   -0x1.02d3dcac3bd41p+1,   -0x1.1c8d1af2ce57ep+0,   0x1.fd681ap-2, INEXACT)
T(RN,   -0x1.02b0516fa637bp+1,    -0x1.1c7f21428ce3p+0,   -0x1.fbb6ap-2, INEXACT)
T(RN,   -0x1.028ccb14a1a86p+1,   -0x1.1c7126681d52cp+0,  -0x1.fd2eecp-2, INEXACT)
T(RN,   -0x1.0269499a82826p+1,   -0x1.1c632a63917d6p+0,  -0x1.f7294ap-2, INEXACT)
T(RN,   -0x1.0245cd009d574p+1,   -0x1.1c552d34fb548p+0,  -0x1.fab2fap-2, INEXACT)
T(RN,   -0x1.0222554646abbp+1,   -0x1.1c472edc6ccb1p+0,    0x1.f982bp-2, INEXACT)
T(RN,   -0x1.01fee26ad3325p+1,   -0x1.1c392f59f7eccp+0,   0x1.f6901cp-2, INEXACT)
T(RN,   -0x1.01db746d97aefp+1,   -0x1.1c2b2eadaed25p+0,   0x1.ff2416p-2, INEXACT)
T(RN,   -0x1.01b80b4de9008p+1,   -0x1.1c1d2cd7a3a5cp+0,   0x1.feb046p-2, INEXACT)
T(RN,   -0x1.0194a70b1c18dp+1,   -0x1.1c0f29d7e89f1p+0,  -0x1.facddap-2, INEXACT)
T(RN,   -0x1.017147a48606ap+1,    -0x1.1c0125ae9008p+0,  -0x1.f7cb94p-2, INEXACT)
T(RN,   -0x1.014ded197be58p+1,    -0x1.1bf3205bac36p+0,   0x1.fe19a6p-2, INEXACT)
T(RN,   -0x1.012a976952fa5p+1,   -0x1.1be519df4f958p+0,   0x1.f9aa6cp-2, INEXACT)
T(RN,   -0x1.0107469360906p+1,   -0x1.1bd712398c9bdp+0,   0x1.fdc68ep-2, INEXACT)
T(RN,   -0x1.00e3fa96fa0f5p+1,   -0x1.1bc9096a75d01p+0,   0x1.fcbddep-2, INEXACT)
T(RN,   -0x1.00c0b37374f92p+1,   -0x1.1bbaff721dca6p+0,   0x1.f8a94cp-2, INEXACT)
T(RN,   -0x1.009d712826e75p+1,   -0x1.1bacf4509732cp+0,   0x1.fa764cp-2, INEXACT)
T(RN,   -0x1.007a33b4658e7p+1,   -0x1.1b9ee805f4c28p+0,   0x1.f7906ep-2, INEXACT)
T(RN,   -0x1.0056fb1786a85p+1,   -0x1.1b90da92493b9p+0,   0x1.f6aea4p-2, INEXACT)
T(RN,   -0x1.0033c750e0214p+1,   -0x1.1b82cbf5a77a9p+0,   0x1.f72d4cp-2, INEXACT)
T(RN,   -0x1.0010985fc7c29p+1,   -0x1.1b74bc302254bp+0,   0x1.f5fb44p-2, INEXACT)
T(RN,   -0x1.ffdadc8727fd3p+0,   -0x1.1b66ab41cce95p+0,  -0x1.f5d5d4p-2, INEXACT)
T(RN,   -0x1.ff9491f735574p+0,   -0x1.1b58992aba1fdp+0,   -0x1.f67b1p-2, INEXACT)
T(RN,   -0x1.ff4e510e642b4p+0,   -0x1.1b4a85eafd155p+0,   0x1.fba04ap-2, INEXACT)
T(RN,   -0x1.ff0819cb61003p+0,   -0x1.1b3c7182a8ea5p+0,  -0x1.f66b0ep-2, INEXACT)
T(RN,   -0x1.fec1ec2cd8c65p+0,   -0x1.1b2e5bf1d0daap+0,  -0x1.f7d096p-2, INEXACT)
T(RN,   -0x1.fe7bc831788ebp+0,   -0x1.1b204538882f8p+0,  -0x1.f5c796p-2, INEXACT)
T(RN,   -0x1.fe35add7ed783p+0,   -0x1.1b122d56e23b8p+0,  -0x1.ff9836p-2, INEXACT)
T(RN,   -0x1.fdef9d1ee4e41p+0,   -0x1.1b04144cf2652p+0,  -0x1.f9e362p-2, INEXACT)
T(RN,    -0x1.fda996050c65p+0,   -0x1.1af5fa1acc237p+0,  -0x1.f88564p-2, INEXACT)
T(RN,   -0x1.fd63988911becp+0,    -0x1.1ae7dec082fep+0,  -0x1.fa1bf4p-2, INEXACT)
T(RN,   -0x1.fd1da4a9a2ce8p+0,   -0x1.1ad9c23e2a882p+0,  -0x1.f65316p-2, INEXACT)
T(RN,   -0x1.fcd7ba656dbdfp+0,   -0x1.1acba493d66b3p+0,  -0x1.fe7cdcp-2, INEXACT)
T(RN,   -0x1.fc91d9bb20c9ep+0,   -0x1.1abd85c19a5b1p+0,  -0x1.f74eecp-2, INEXACT)
T(RN,   -0x1.fc4c02a96a6e7p+0,   -0x1.1aaf65c78a1f1p+0,  -0x1.f84762p-2, INEXACT)
T(RN,   -0x1.fc06352ef94e4p+0,   -0x1.1aa144a5b98cfp+0,  -0x1.ffa082p-2, INEXACT)
T(RN,   -0x1.fbc0714a7c41dp+0,   -0x1.1a93225c3c8bfp+0,    0x1.fe1a3p-2, INEXACT)
T(RN,   -0x1.fb7ab6faa246cp+0,   -0x1.1a84feeb2711bp+0,   0x1.fba346p-2, INEXACT)
T(RN,   -0x1.fb35063e1a8a9p+0,    -0x1.1a76da528d24p+0,    0x1.feb0ep-2, INEXACT)
T(RN,   -0x1.faef5f139474bp+0,   -0x1.1a68b49282db3p+0,   0x1.fa2e1ap-2, INEXACT)
T(RN,   -0x1.faa9c179bf862p+0,   -0x1.1a5a8dab1c5b7p+0,   0x1.ff3f1ep-2, INEXACT)
T(RN,   -0x1.fa642d6f4b838p+0,   -0x1.1a4c659c6ddd6p+0,   0x1.f918fcp-2, INEXACT)
T(RN,   -0x1.fa1ea2f2e84f3p+0,   -0x1.1a3e3c668ba66p+0,   0x1.f9eaa8p-2, INEXACT)
T(RN,   -0x1.f9d9220346053p+0,   -0x1.1a3012098a0e4p+0,   0x1.fedaeap-2, INEXACT)
T(RN,   -0x1.f993aa9f14e5ep+0,   -0x1.1a21e6857d7afp+0,   0x1.f81edcp-2, INEXACT)
T(RN,   -0x1.f94e3cc505672p+0,   -0x1.1a13b9da7a641p+0,  -0x1.fab706p-2, INEXACT)
T(RN,   -0x1.f908d873c82e1p+0,   -0x1.1a058c0895517p+0,  -0x1.f89a6ep-2, INEXACT)
T(RN,   -0x1.f8c37daa0e023p+0,   -0x1.19f75d0fe2d8dp+0,  -0x1.f75df8p-2, INEXACT)
T(RN,   -0x1.f87e2c6687e88p+0,   -0x1.19e92cf077a32p+0,   0x1.fc1584p-2, INEXACT)
T(RN,   -0x1.f838e4a7e707fp+0,   -0x1.19dafbaa68674p+0,  -0x1.fdeb24p-2, INEXACT)
T(RN,    -0x1.f7f3a66cdcbbp+0,    -0x1.19ccc93dc9edp+0,  -0x1.f92d32p-2, INEXACT)
T(RN,   -0x1.f7ae71b41a8a8p+0,   -0x1.19be95aab10cbp+0,  -0x1.fcb2b6p-2, INEXACT)
T(RN,   -0x1.f769467c5228ap+0,   -0x1.19b060f132addp+0,  -0x1.fff6fcp-2, INEXACT)
T(RN,   -0x1.f72424c4357c2p+0,   -0x1.19a22b1163c96p+0,   0x1.fc3938p-2, INEXACT)
T(RN,   -0x1.f6df0c8a76968p+0,   -0x1.1993f40b59682p+0,   0x1.f6bb62p-2, INEXACT)
T(RN,   -0x1.f699fdcdc7b66p+0,   -0x1.1985bbdf28a2bp+0,   0x1.fb0838p-2, INEXACT)
T(RN,    -0x1.f654f88cdb45p+0,   -0x1.1977828ce6a16p+0,  -0x1.fc21f2p-2, INEXACT)
T(RN,   -0x1.f60ffcc663de6p+0,   -0x1.19694814a89d9p+0,   -0x1.fc8e3p-2, INEXACT)
T(RN,   -0x1.f5cb0a7914509p+0,   -0x1.195b0c7683e1ep+0,   0x1.fd91b8p-2, INEXACT)
T(RN,   -0x1.f58621a39f8a1p+0,   -0x1.194ccfb28dc6ap+0,   -0x1.f9568p-2, INEXACT)
T(RN,   -0x1.f5414244b8b41p+0,   -0x1.193e91c8dbb6ap+0,   0x1.f89cecp-2, INEXACT)
T(RN,   -0x1.f4fc6c5b131adp+0,   -0x1.193052b9832b4p+0,  -0x1.f9474ap-2, INEXACT)
T(RN,   -0x1.f4b79fe562456p+0,   -0x1.1922128499b07p+0,  -0x1.f8274cp-2, INEXACT)
T(RN,   -0x1.f472dce259dbap+0,   -0x1.1913d12a34dffp+0,   0x1.fd9304p-2, INEXACT)
T(RN,   -0x1.f42e2350adb63p+0,   -0x1.19058eaa6a649p+0,   0x1.fcf66ep-2, INEXACT)
T(RN,   -0x1.f3e9732f11e0cp+0,   -0x1.18f74b054ffa7p+0,  -0x1.fe08a6p-2, INEXACT)
T(RN,   -0x1.f3a4cc7c3a931p+0,   -0x1.18e9063afb6d8p+0,   0x1.fdb388p-2, INEXACT)
T(RN,   -0x1.f3602f36dc313p+0,   -0x1.18dac04b829a2p+0,   0x1.fb3aaep-2, INEXACT)
T(RN,   -0x1.f31b9b5dab452p+0,   -0x1.18cc7936fb6b3p+0,     0x1.f881p-2, INEXACT)
T(RN,   -0x1.f2d710ef5c916p+0,   -0x1.18be30fd7bde5p+0,  -0x1.fabb66p-2, INEXACT)
T(RN,   -0x1.f2928feaa503ap+0,   -0x1.18afe79f1a00dp+0,  -0x1.fb1edap-2, INEXACT)
T(RN,   -0x1.f24e184e39b12p+0,   -0x1.18a19d1bebef4p+0,    0x1.fff89p-2, INEXACT)
T(RN,   -0x1.f209aa18cfe4bp+0,   -0x1.1893517407d86p+0,   0x1.f5cc6ap-2, INEXACT)
T(RN,   -0x1.f1c545491d0d9p+0,   -0x1.188504a783f94p+0,   0x1.f604ccp-2, INEXACT)
T(RN,   -0x1.f180e9ddd6d6bp+0,   -0x1.1876b6b676a27p+0,  -0x1.faa918p-2, INEXACT)
T(RN,   -0x1.f13c97d5b3044p+0,   -0x1.186867a0f6308p+0,  -0x1.fb088ep-2, INEXACT)
T(RN,   -0x1.f0f84f2f679c9p+0,   -0x1.185a17671914fp+0,  -0x1.f832e2p-2, INEXACT)
T(RN,   -0x1.f0b40fe9aac0ep+0,   -0x1.184bc608f5cdcp+0,  -0x1.feb9a4p-2, INEXACT)
T(RN,   -0x1.f06fda0332cbcp+0,   -0x1.183d7386a2ebdp+0,   0x1.f7fe96p-2, INEXACT)
T(RN,   -0x1.f02bad7ab6426p+0,   -0x1.182f1fe037101p+0,    0x1.f76e6p-2, INEXACT)
T(RN,   -0x1.efe78a4eebd35p+0,   -0x1.1820cb15c8eaep+0,   0x1.f6151ap-2, INEXACT)
T(RN,   -0x1.efa3707e8a4ecp+0,   -0x1.181275276f3acp+0,  -0x1.f5ef6cp-2, INEXACT)
T(RN,    -0x1.ef5f600848f8p+0,   -0x1.18041e1540dd3p+0,  -0x1.f9362ap-2, INEXACT)
T(RN,   -0x1.ef1b58eadecf9p+0,   -0x1.17f5c5df54a8cp+0,  -0x1.f8ae74p-2, INEXACT)
T(RN,   -0x1.eed75b25034cdp+0,   -0x1.17e76c85c193ep+0,   0x1.fec916p-2, INEXACT)
T(RN,   -0x1.ee9366b56e024p+0,   -0x1.17d912089ea1ep+0,   0x1.ff5254p-2, INEXACT)
T(RN,   -0x1.ee4f7b9ad6b44p+0,   -0x1.17cab66802e77p+0,  -0x1.ffceb4p-2, INEXACT)
T(RN,   -0x1.ee0b99d3f54e1p+0,   -0x1.17bc59a405884p+0,   0x1.ffccb4p-2, INEXACT)
T(RN,   -0x1.edc7c15f81e55p+0,   -0x1.17adfbbcbdb85p+0,   0x1.fc3fecp-2, INEXACT)
T(RN,   -0x1.ed83f23c34cacp+0,   -0x1.179f9cb242beep+0,   0x1.f5d6cep-2, INEXACT)
T(RN,   -0x1.ed402c68c673cp+0,   -0x1.17913c84abf21p+0,  -0x1.f6d7c4p-2, INEXACT)
T(RN,   -0x1.ecfc6fe3ef754p+0,   -0x1.1782db3410b58p+0,  -0x1.fdba04p-2, INEXACT)
T(RN,   -0x1.ecb8bcac68ab3p+0,    -0x1.177478c08883p+0,   0x1.f8d2ecp-2, INEXACT)
T(RN,   -0x1.ec7512c0eb0b1p+0,    -0x1.1766152a2ae1p+0,  -0x1.fc8514p-2, INEXACT)
T(RN,   -0x1.ec3172202fba4p+0,   -0x1.1757b0710f66cp+0,  -0x1.f98736p-2, INEXACT)
T(RN,   -0x1.ebeddac8f013dp+0,   -0x1.17494a954dbe3p+0,  -0x1.fd8fbep-2, INEXACT)
T(RN,   -0x1.ebaa4cb9e59b8p+0,   -0x1.173ae396fda0dp+0,   0x1.fee5dap-2, INEXACT)
T(RN,   -0x1.eb66c7f1c9fa3p+0,   -0x1.172c7b7636d74p+0,   0x1.fd7ad8p-2, INEXACT)
T(RN,   -0x1.eb234c6f570dfp+0,   -0x1.171e1233113c6p+0,  -0x1.fba416p-2, INEXACT)
T(RN,   -0x1.eadfda3146d8fp+0,   -0x1.170fa7cda4b9ap+0,   0x1.f62a68p-2, INEXACT)
T(RN,    -0x1.ea9c7136539fp+0,   -0x1.17013c46094dep+0,   0x1.f7e2d2p-2, INEXACT)
T(RN,   -0x1.ea59117d37b33p+0,   -0x1.16f2cf9c57021p+0,   0x1.f6f9ecp-2, INEXACT)
T(RN,   -0x1.ea15bb04adbfap+0,   -0x1.16e461d0a5f8fp+0,  -0x1.f5cd28p-2, INEXACT)
T(RN,   -0x1.e9d26dcb705ebp+0,   -0x1.16d5f2e30e58cp+0,  -0x1.fa5232p-2, INEXACT)
T(RN,   -0x1.e98f29d03a81bp+0,   -0x1.16c782d3a861ap+0,  -0x1.f8cb6ep-2, INEXACT)
T(RN,   -0x1.e94bef11c7459p+0,   -0x1.16b911a28c641p+0,  -0x1.f8d1d4p-2, INEXACT)
T(RN,   -0x1.e908bd8ed1ec7p+0,   -0x1.16aa9f4fd2bfap+0,  -0x1.fb66a4p-2, INEXACT)
T(RN,   -0x1.e8c5954615db9p+0,   -0x1.169c2bdb93e28p+0,  -0x1.fb05b2p-2, INEXACT)
T(RN,   -0x1.e88276364eb0cp+0,   -0x1.168db745e84e1p+0,   0x1.f9e568p-2, INEXACT)
T(RN,   -0x1.e83f605e38338p+0,    -0x1.167f418ee894p+0,  -0x1.fdc966p-2, INEXACT)
T(RN,    -0x1.e7fc53bc8e5bp+0,   -0x1.1670cab6ad56fp+0,    0x1.f6a65p-2, INEXACT)
T(RN,   -0x1.e7b950500d452p+0,   -0x1.166252bd4f497p+0,  -0x1.fa2b7cp-2, INEXACT)
T(RN,   -0x1.e7765617713abp+0,    -0x1.1653d9a2e72ep+0,  -0x1.fe7384p-2, INEXACT)
T(RN,   -0x1.e733651176bb9p+0,   -0x1.16455f678dda6p+0,  -0x1.fc5428p-2, INEXACT)
T(RN,   -0x1.e6f07d3cda67cp+0,   -0x1.1636e40b5c324p+0,   0x1.ff84acp-2, INEXACT)
T(RN,   -0x1.e6ad9e9859147p+0,   -0x1.1628678e6b2c3p+0,  -0x1.fa8c6cp-2, INEXACT)
T(RN,   -0x1.e66ac922afbd3p+0,   -0x1.1619e9f0d3cdcp+0,   0x1.fa3be4p-2, INEXACT)
T(RN,   -0x1.e627fcda9b91cp+0,   -0x1.160b6b32af2f6p+0,   0x1.faa0c8p-2, INEXACT)
T(RN,   -0x1.e5e539bed9d6ep+0,   -0x1.15fceb541674fp+0,   0x1.f7d4a6p-2, INEXACT)
T(RN,    -0x1.e5a27fce2838p+0,   -0x1.15ee6a5522dfep+0,  -0x1.f645f8p-2, INEXACT)
T(RN,   -0x1.e55fcf07443b1p+0,   -0x1.15dfe835edb07p+0,   -0x1.f98a7p-2, INEXACT)
T(RN,   -0x1.e51d2768ebd65p+0,   -0x1.15d164f69046ap+0,  -0x1.fb5e48p-2, INEXACT)
T(RN,    -0x1.e4da88f1dd03p+0,   -0x1.15c2e097240a3p+0,  -0x1.fddaf8p-2, INEXACT)
T(RN,   -0x1.e497f3a0d5f9fp+0,   -0x1.15b45b17c277dp+0,   0x1.fde942p-2, INEXACT)
T(RN,   -0x1.e4556774951ccp+0,   -0x1.15a5d478851c7p+0,   0x1.f9dc1cp-2, INEXACT)
T(RN,   -0x1.e412e46bd8f6bp+0,   -0x1.15974cb985951p+0,   0x1.f78c48p-2, INEXACT)
T(RN,   -0x1.e3d06a8560437p+0,   -0x1.1588c3dadd909p+0,  -0x1.fe0f7cp-2, INEXACT)
T(RN,   -0x1.e38df9bfe9e63p+0,   -0x1.157a39dca6cd7p+0,   -0x1.f9d37p-2, INEXACT)
T(RN,   -0x1.e34b921a34efep+0,   -0x1.156baebefb1b9p+0,  -0x1.fcf862p-2, INEXACT)
T(RN,   -0x1.e3093393009d2p+0,   -0x1.155d2281f45b7p+0,   0x1.fff71cp-2, INEXACT)
T(RN,   -0x1.e2c6de290c563p+0,   -0x1.154e9525ac7e8p+0,   0x1.f68738p-2, INEXACT)
T(RN,   -0x1.e28491db17b2ep+0,   -0x1.154006aa3d87ap+0,    0x1.f5de5p-2, INEXACT)
T(RN,   -0x1.e2424ea7e2736p+0,   -0x1.1531770fc189ep+0,  -0x1.f8f8fcp-2, INEXACT)
T(RN,   -0x1.e200148e2c85ep+0,   -0x1.1522e65652a96p+0,   0x1.fa59cap-2, INEXACT)
T(RN,    -0x1.e1bde38cb602p+0,    -0x1.1514547e0b1bp+0,  -0x1.f886ecp-2, INEXACT)
T(RN,   -0x1.e17bbba23f2ddp+0,   -0x1.1505c18705249p+0,   0x1.fbc56cp-2, INEXACT)
T(RN,    -0x1.e1399ccd8877p+0,   -0x1.14f72d715b1c5p+0,  -0x1.fdf2b6p-2, INEXACT)
T(RN,   -0x1.e0f7870d527fdp+0,   -0x1.14e8983d276adp+0,   0x1.f92104p-2, INEXACT)
T(RN,   -0x1.e0b57a605e0d3p+0,    -0x1.14da01ea8488p+0,  -0x1.fee946p-2, INEXACT)
T(RN,   -0x1.e07376c56c17fp+0,    -0x1.14cb6a798cfep+0,   0x1.fb0fcap-2, INEXACT)
T(RN,   -0x1.e0317c3b3db4bp+0,   -0x1.14bcd1ea5b64cp+0,    0x1.fbe86p-2, INEXACT)
T(RN,   -0x1.dfef8ac0943e3p+0,   -0x1.14ae383d0a6abp+0,   0x1.f781ccp-2, INEXACT)
T(RN,    -0x1.dfada254312cp+0,   -0x1.149f9d71b4cbfp+0,   0x1.f8d046p-2, INEXACT)
T(RN,   -0x1.df6bc2f4d615ep+0,    -0x1.149101887553p+0,   0x1.f69336p-2, INEXACT)
T(RN,   -0x1.df29eca144d5dp+0,   -0x1.1482648166e06p+0,  -0x1.fd24d4p-2, INEXACT)
T(RN,   -0x1.dee81f583f02ep+0,   -0x1.1473c65ca44ccp+0,  -0x1.f5cc68p-2, INEXACT)
T(RN,   -0x1.dea65b1887ddap+0,   -0x1.1465271a48d6dp+0,  -0x1.f8ea22p-2, INEXACT)
T(RN,   -0x1.de649fe0e0a16p+0,   -0x1.145686ba6f517p+0,   0x1.f78fe2p-2, INEXACT)
T(RN,   -0x1.de22edb00c209p+0,   -0x1.1447e53d32f18p+0,   -0x1.f8c84p-2, INEXACT)
T(RN,   -0x1.dde14484cd1c3p+0,   -0x1.143942a2aeeefp+0,  -0x1.f630e2p-2, INEXACT)
T(RN,   -0x1.dd9fa45de656dp+0,   -0x1.142a9eeafe899p+0,  -0x1.fd7832p-2, INEXACT)
T(RN,   -0x1.dd5e0d3a1ad55p+0,   -0x1.141bfa163d173p+0,  -0x1.fead4cp-2, INEXACT)
T(RN,   -0x1.dd1c7f182dbf2p+0,   -0x1.140d542485fcap+0,  -0x1.f7bbd2p-2, INEXACT)
T(RN,   -0x1.dcdaf9f6e276dp+0,   -0x1.13fead15f4b32p+0,   0x1.fcdea4p-2, INEXACT)
T(RN,   -0x1.dc997dd4fc752p+0,   -0x1.13f004eaa4c07p+0,  -0x1.f8987ap-2, INEXACT)
T(RN,   -0x1.dc580ab13f70ep+0,   -0x1.13e15ba2b1bf1p+0,    0x1.fb806p-2, INEXACT)
T(RN,   -0x1.dc16a08a6f3e4p+0,   -0x1.13d2b13e3757ep+0,  -0x1.fbc80ap-2, INEXACT)
T(RN,   -0x1.dbd53f5f4fe67p+0,   -0x1.13c405bd51467p+0,   0x1.f9f10cp-2, INEXACT)
T(RN,   -0x1.db93e72ea59a8p+0,   -0x1.13b559201b571p+0,  -0x1.fd6e16p-2, INEXACT)
T(RN,   -0x1.db5297f734b4bp+0,   -0x1.13a6ab66b1663p+0,  -0x1.fcd4bep-2, INEXACT)
T(RN,   -0x1.db1151b7c1be4p+0,   -0x1.1397fc912f625p+0,   0x1.f904acp-2, INEXACT)
T(RN,   -0x1.dad0146f1165fp+0,   -0x1.13894c9fb149ep+0,  -0x1.fa5714p-2, INEXACT)
T(RN,   -0x1.da8ee01be893ap+0,   -0x1.137a9b92532f1p+0,   0x1.f6112ap-2, INEXACT)
T(RN,   -0x1.da4db4bd0c498p+0,   -0x1.136be9693131cp+0,   0x1.f8bd4ap-2, INEXACT)
T(RN,   -0x1.da0c925141aa2p+0,   -0x1.135d362467803p+0,   0x1.f64428p-2, INEXACT)
T(RN,   -0x1.d9cb78d74e52ap+0,   -0x1.134e81c4126bbp+0,    0x1.fc122p-2, INEXACT)
T(RN,     -0x1.d98a684df79p+0,   -0x1.133fcc484e3aep+0,  -0x1.feae3cp-2, INEXACT)
T(RN,   -0x1.d94960b4032ccp+0,   -0x1.133115b13757dp+0,    0x1.fcdd6p-2, INEXACT)
T(RN,   -0x1.d9086208370f6p+0,   -0x1.13225dfeea3abp+0,  -0x1.fda0a4p-2, INEXACT)
T(RN,   -0x1.d8c76c49593d2p+0,   -0x1.1313a53183699p+0,  -0x1.ff7d48p-2, INEXACT)
T(RN,   -0x1.d8867f762ff6fp+0,   -0x1.1304eb491f7f9p+0,   0x1.ffaf8cp-2, INEXACT)
T(RN,   -0x1.d8459b8d818fcp+0,   -0x1.12f63045db236p+0,    0x1.f9398p-2, INEXACT)
T(RN,   -0x1.d804c08e14a0dp+0,   -0x1.12e77427d312ep+0,  -0x1.f6102cp-2, INEXACT)
T(RN,   -0x1.d7c3ee76aff6dp+0,   -0x1.12d8b6ef241eep+0,  -0x1.f5fde8p-2, INEXACT)
T(RN,   -0x1.d78325461a5b3p+0,   -0x1.12c9f89beb1efp+0,   0x1.f7d97ep-2, INEXACT)
T(RN,   -0x1.d74264fb1ae04p+0,   -0x1.12bb392e4502cp+0,  -0x1.f945d8p-2, INEXACT)
T(RN,    -0x1.d701ad9478c2p+0,   -0x1.12ac78a64eca7p+0,   0x1.fcaa04p-2, INEXACT)
T(RN,   -0x1.d6c0ff10fb6b1p+0,   -0x1.129db70425889p+0,    0x1.fa672p-2, INEXACT)
T(RN,   -0x1.d680596f6a63ap+0,   -0x1.128ef447e65dap+0,  -0x1.ff3a84p-2, INEXACT)
T(RN,   -0x1.d63fbcae8d68bp+0,   -0x1.12803071ae7d7p+0,   -0x1.f6201p-2, INEXACT)
T(RN,   -0x1.d5ff28cd2c6aep+0,   -0x1.12716b819b2f2p+0,   0x1.fa71b2p-2, INEXACT)
T(RN,   -0x1.d5be9dca0f6dap+0,   -0x1.1262a577c9c5bp+0,  -0x1.fc7ed2p-2, INEXACT)
T(RN,   -0x1.d57e1ba3feb06p+0,   -0x1.1253de5457a8ep+0,  -0x1.fa48cep-2, INEXACT)
T(RN,   -0x1.d53da259c2982p+0,   -0x1.124516176250ap+0,   0x1.f61b04p-2, INEXACT)
T(RN,   -0x1.d4fd31ea23bb2p+0,   -0x1.12364cc10747bp+0,   0x1.fbefeap-2, INEXACT)
T(RN,   -0x1.d4bcca53eacedp+0,   -0x1.1227825164273p+0,   0x1.f7738ap-2, INEXACT)
T(RN,   -0x1.d47c6b95e0bc8p+0,   -0x1.1218b6c8969bap+0,   0x1.f6da54p-2, INEXACT)
T(RN,   -0x1.d43c15aece992p+0,   -0x1.1209ea26bc62fp+0,   0x1.faa784p-2, INEXACT)
T(RN,   -0x1.d3fbc89d7d953p+0,   -0x1.11fb1c6bf348dp+0,   0x1.f71ed8p-2, INEXACT)
T(RN,   -0x1.d3bb8460b71fcp+0,   -0x1.11ec4d98592ecp+0,   0x1.f705c8p-2, INEXACT)
T(RN,   -0x1.d37b48f744d3ep+0,   -0x1.11dd7dac0c07dp+0,   0x1.f669bep-2, INEXACT)
T(RN,    -0x1.d33b165ff04dp+0,   -0x1.11ceaca729ceap+0,  -0x1.f6d31ep-2, INEXACT)
T(RN,   -0x1.d2faec9983b21p+0,   -0x1.11bfda89d0a54p+0,   -0x1.f7864p-2, INEXACT)
T(RN,   -0x1.d2bacba2c8d6fp+0,   -0x1.11b107541ea22p+0,   0x1.f6a152p-2, INEXACT)
T(RN,   -0x1.d27ab37a8a036p+0,   -0x1.11a2330631fe1p+0,  -0x1.fc6602p-2, INEXACT)
T(RN,   -0x1.d23aa41f91a98p+0,   -0x1.11935da02902cp+0,  -0x1.f6f13cp-2, INEXACT)
T(RN,   -0x1.d1fa9d90aa54dp+0,   -0x1.1184872222076p+0,   0x1.fd33d6p-2, INEXACT)
T(RN,   -0x1.d1ba9fcc9ec23p+0,   -0x1.1175af8c3b763p+0,  -0x1.fd803cp-2, INEXACT)
T(RN,   -0x1.d17aaad239d5dp+0,   -0x1.1166d6de93c99p+0,   0x1.f8fdfep-2, INEXACT)
T(RN,   -0x1.d13abea046a16p+0,   -0x1.1157fd19498e6p+0,  -0x1.f69414p-2, INEXACT)
T(RN,   -0x1.d0fadb35905c7p+0,   -0x1.1149223c7b615p+0,   -0x1.fbdefp-2, INEXACT)
T(RN,   -0x1.d0bb0090e26f3p+0,    -0x1.113a464847f2p+0,   0x1.f68f98p-2, INEXACT)
T(RN,   -0x1.d07b2eb108698p+0,   -0x1.112b693cce00ep+0,   0x1.f8eabep-2, INEXACT)
T(RN,   -0x1.d03b6594ce048p+0,   -0x1.111c8b1a2c5f5p+0,  -0x1.f9690ep-2, INEXACT)
T(RN,   -0x1.cffba53aff123p+0,   -0x1.110dabe081ebdp+0,  -0x1.f6bd52p-2, INEXACT)
T(RN,   -0x1.cfbbeda267cfap+0,   -0x1.10fecb8feda58p+0,  -0x1.f7081ap-2, INEXACT)
T(RN,   -0x1.cf7c3ec9d44ccp+0,   -0x1.10efea288e886p+0,  -0x1.fe48a6p-2, INEXACT)
T(RN,   -0x1.cf3c98b010f6dp+0,   -0x1.10e107aa83adbp+0,  -0x1.f9a568p-2, INEXACT)
T(RN,   -0x1.cefcfb53ea596p+0,   -0x1.10d22415ec3d3p+0,   0x1.ffdeaap-2, INEXACT)
T(RN,   -0x1.cebd66b42d32ep+0,   -0x1.10c33f6ae7724p+0,   -0x1.fc8f3p-2, INEXACT)
T(RN,   -0x1.ce7ddacfa65efp+0,   -0x1.10b459a994963p+0,  -0x1.fe7a4ap-2, INEXACT)
T(RN,   -0x1.ce3e57a522e77p+0,   -0x1.10a572d21304dp+0,   0x1.f77afap-2, INEXACT)
T(RN,   -0x1.cdfedd33700bap+0,   -0x1.10968ae4822e1p+0,   0x1.fc0c72p-2, INEXACT)
T(RN,   -0x1.cdbf6b795b268p+0,   -0x1.1087a1e1018fcp+0,  -0x1.f71394p-2, INEXACT)
T(RN,   -0x1.cd800275b1bf9p+0,   -0x1.1078b7c7b0b98p+0,  -0x1.fde9bcp-2, INEXACT)
T(RN,   -0x1.cd40a22741893p+0,   -0x1.1069cc98af4cbp+0,  -0x1.f6a6e6p-2, INEXACT)
T(RN,   -0x1.cd014a8cd8699p+0,   -0x1.105ae0541cfe5p+0,  -0x1.f9aee2p-2, INEXACT)
T(RN,   -0x1.ccc1fba54468ep+0,   -0x1.104bf2fa1992ep+0,  -0x1.fc5772p-2, INEXACT)
T(RN,   -0x1.cc82b56f53af7p+0,   -0x1.103d048ac4ddfp+0,   -0x1.fa3cfp-2, INEXACT)
T(RN,   -0x1.cc4377e9d4a6cp+0,   -0x1.102e15063ec9fp+0,   -0x1.f6575p-2, INEXACT)
T(RN,   -0x1.cc04431395ca5p+0,    -0x1.101f246ca74dp+0,   0x1.ffefecp-2, INEXACT)
T(RN,   -0x1.cbc516eb65d0ap+0,   -0x1.101032be1e72ep+0,   0x1.f5df52p-2, INEXACT)
T(RN,   -0x1.cb85f370138fap+0,   -0x1.10013ffac4561p+0,   0x1.fe74eap-2, INEXACT)
T(RN,   -0x1.cb46d8a06e103p+0,   -0x1.0ff24c22b924cp+0,  -0x1.f7770ap-2, INEXACT)
T(RN,   -0x1.cb07c67b447bep+0,   -0x1.0fe357361d1c2p+0,   0x1.fd73b2p-2, INEXACT)
T(RN,   -0x1.cac8bcff662bbp+0,   -0x1.0fd46135108c8p+0,   0x1.f8b97ap-2, INEXACT)
T(RN,   -0x1.ca89bc2ba2a5ep+0,   -0x1.0fc56a1fb3d84p+0,  -0x1.fd631ep-2, INEXACT)
T(RN,    -0x1.ca4ac3fec991p+0,   -0x1.0fb671f62770dp+0,  -0x1.fe2fd8p-2, INEXACT)
T(RN,   -0x1.ca0bd477aab65p+0,   -0x1.0fa778b88bd78p+0,   0x1.f73856p-2, INEXACT)
T(RN,   -0x1.c9cced951639ap+0,   -0x1.0f987e6701aaep+0,  -0x1.f6b4c8p-2, INEXACT)
T(RN,   -0x1.c98e0f55dc25bp+0,   -0x1.0f898301a98aap+0,   0x1.fec746p-2, INEXACT)
T(RN,   -0x1.c94f39b8cccd2p+0,   -0x1.0f7a8688a42f9p+0,   -0x1.ffd04p-2, INEXACT)
T(RN,   -0x1.c9106cbcb8b87p+0,   -0x1.0f6b88fc12667p+0,  -0x1.fb4feap-2, INEXACT)
T(RN,   -0x1.c8d1a86070871p+0,   -0x1.0f5c8a5c15094p+0,  -0x1.fc0568p-2, INEXACT)
T(RN,   -0x1.c892eca2c5088p+0,   -0x1.0f4d8aa8cd04fp+0,  -0x1.f6307ep-2, INEXACT)
T(RN,   -0x1.c854398287385p+0,   -0x1.0f3e89e25b587p+0,   0x1.f651bcp-2, INEXACT)
T(RN,   -0x1.c8158efe88371p+0,   -0x1.0f2f8808e1134p+0,     0x1.fc88p-2, INEXACT)
T(RN,   -0x1.c7d6ed15994d6p+0,   -0x1.0f20851c7f55dp+0,   0x1.f86b38p-2, INEXACT)
T(RN,   -0x1.c79853c68bed8p+0,   -0x1.0f11811d57522p+0,   0x1.f6268ap-2, INEXACT)
T(RN,   -0x1.c759c31031e11p+0,   -0x1.0f027c0b8a56cp+0,  -0x1.f9b564p-2, INEXACT)
T(RN,   -0x1.c71b3af15cbd3p+0,    -0x1.0ef375e739adp+0,  -0x1.f6dbb4p-2, INEXACT)
T(RN,   -0x1.c6dcbb68de83bp+0,   -0x1.0ee46eb086bffp+0,   0x1.fc09a4p-2, INEXACT)
T(RN,   -0x1.c69e4475895a1p+0,   -0x1.0ed56667930afp+0,  -0x1.fcae16p-2, INEXACT)
T(RN,   -0x1.c65fd6162f7b3p+0,   -0x1.0ec65d0c8015ap+0,    0x1.f6435p-2, INEXACT)
T(RN,   -0x1.c6217049a35bfp+0,   -0x1.0eb7529f6f7d9p+0,   0x1.f811dcp-2, INEXACT)
T(RN,   -0x1.c5e3130eb797ap+0,   -0x1.0ea8472082f0ep+0,   0x1.f6ba32p-2, INEXACT)
T(RN,   -0x1.c5a4be643ee6fp+0,   -0x1.0e993a8fdc2c7p+0,  -0x1.ff9e62p-2, INEXACT)
T(RN,   -0x1.c56672490c3a9p+0,    -0x1.0e8a2ced9d02p+0,  -0x1.f7c456p-2, INEXACT)
T(RN,   -0x1.c5282ebbf2a6bp+0,   -0x1.0e7b1e39e753ap+0,  -0x1.fbef3cp-2, INEXACT)
T(RN,   -0x1.c4e9f3bbc56b4p+0,   -0x1.0e6c0e74dd157p+0,  -0x1.fed748p-2, INEXACT)
T(RN,   -0x1.c4abc14757ebap+0,   -0x1.0e5cfd9ea04bap+0,   0x1.fb68d6p-2, INEXACT)
T(RN,   -0x1.c46d975d7db72p+0,   -0x1.0e4debb7530cdp+0,  -0x1.f89456p-2, INEXACT)
T(RN,   -0x1.c42f75fd0a8d9p+0,   -0x1.0e3ed8bf17828p+0,   0x1.f6c772p-2, INEXACT)
T(RN,   -0x1.c3f15d24d24a2p+0,   -0x1.0e2fc4b60fe4dp+0,   0x1.f9fec8p-2, INEXACT)
T(RN,   -0x1.c3b34cd3a8ff6p+0,   -0x1.0e20af9c5e80bp+0,  -0x1.fdf084p-2, INEXACT)
T(RN,   -0x1.c375450862dbbp+0,   -0x1.0e11997225b14p+0,  -0x1.f5dedap-2, INEXACT)
T(RN,   -0x1.c33745c1d44aap+0,   -0x1.0e02823787e83p+0,   0x1.f94722p-2, INEXACT)
T(RN,   -0x1.c2f94efed1c21p+0,   -0x1.0df369eca7a16p+0,   0x1.fb82c6p-2, INEXACT)
T(RN,   -0x1.c2bb60be30029p+0,   -0x1.0de45091a7725p+0,   -0x1.f8207p-2, INEXACT)
T(RN,   -0x1.c27d7afec3dc1p+0,   -0x1.0dd53626a9fbap+0,   0x1.f999acp-2, INEXACT)
T(RN,   -0x1.c23f9dbf6255ap+0,   -0x1.0dc61aabd1f36p+0,   -0x1.fb431p-2, INEXACT)
T(RN,   -0x1.c201c8fee09a2p+0,   -0x1.0db6fe21421f7p+0,   0x1.fbc67ap-2, INEXACT)
T(RN,   -0x1.c1c3fcbc13fcep+0,   -0x1.0da7e0871d579p+0,   0x1.fd4518p-2, INEXACT)
T(RN,   -0x1.c18638f5d1fcap+0,   -0x1.0d98c1dd86858p+0,  -0x1.fcb63cp-2, INEXACT)
T(RN,   -0x1.c1487daaf0459p+0,   -0x1.0d89a224a0a58p+0,   0x1.fd9888p-2, INEXACT)
T(RN,   -0x1.c10acada449fbp+0,   -0x1.0d7a815c8ec29p+0,   0x1.fc6cf6p-2, INEXACT)
T(RN,   -0x1.c0cd2082a50a5p+0,   -0x1.0d6b5f8573fc9p+0,   0x1.fd7732p-2, INEXACT)
T(RN,   -0x1.c08f7ea2e7a41p+0,   -0x1.0d5c3c9f7382cp+0,   -0x1.f98e1p-2, INEXACT)
T(RN,   -0x1.c051e539e2b6dp+0,   -0x1.0d4d18aab0965p+0,   0x1.f60d78p-2, INEXACT)
T(RN,   -0x1.c01454466cb8bp+0,   -0x1.0d3df3a74e8b4p+0,   0x1.fb09ccp-2, INEXACT)
T(RN,   -0x1.bfd6cbc75c452p+0,   -0x1.0d2ecd9570c62p+0,  -0x1.fe5d84p-2, INEXACT)
T(RN,    -0x1.bf994bbb8826p+0,   -0x1.0d1fa6753abe5p+0,     0x1.fc5fp-2, INEXACT)
T(RN,   -0x1.bf5bd421c73fdp+0,   -0x1.0d107e46cff9cp+0,  -0x1.fd4184p-2, INEXACT)
T(RN,   -0x1.bf1e64f8f0afdp+0,   -0x1.0d01550a54137p+0,   0x1.f705a2p-2, INEXACT)
T(RN,   -0x1.bee0fe3fdbb73p+0,   -0x1.0cf22abfeab74p+0,   0x1.fb5ebap-2, INEXACT)
T(RN,   -0x1.bea39ff55fb98p+0,   -0x1.0ce2ff67b7a0ep+0,   0x1.f6429ep-2, INEXACT)
T(RN,   -0x1.be664a18544dap+0,   -0x1.0cd3d301dea05p+0,   0x1.fd6b82p-2, INEXACT)
T(RN,   -0x1.be28fca79126bp+0,   -0x1.0cc4a58e83942p+0,    0x1.fae45p-2, INEXACT)
T(RN,   -0x1.bdebb7a1ee2d9p+0,   -0x1.0cb5770dca6fcp+0,   0x1.f96f54p-2, INEXACT)
T(RN,   -0x1.bdae7b06436cep+0,   -0x1.0ca6477fd7369p+0,   0x1.fa0e44p-2, INEXACT)
T(RN,   -0x1.bd7146d36911cp+0,   -0x1.0c9716e4cdfc1p+0,   0x1.f8e682p-2, INEXACT)
T(RN,   -0x1.bd341b0837817p+0,   -0x1.0c87e53cd2e94p+0,   0x1.fa7048p-2, INEXACT)
T(RN,   -0x1.bcf6f7a3873cdp+0,   -0x1.0c78b2880a359p+0,   0x1.f9f1ecp-2, INEXACT)
T(RN,   -0x1.bcb9dca430e97p+0,   -0x1.0c697ec698292p+0,   0x1.f8cafcp-2, INEXACT)
T(RN,   -0x1.bc7cca090d682p+0,   -0x1.0c5a49f8a1226p+0,   0x1.f60346p-2, INEXACT)
T(RN,   -0x1.bc3fbfd0f5b88p+0,    -0x1.0c4b141e498fp+0,   0x1.f6362ap-2, INEXACT)
T(RN,   -0x1.bc02bdfac3149p+0,   -0x1.0c3bdd37b5f2ep+0,  -0x1.fb211ap-2, INEXACT)
T(RN,   -0x1.bbc5c4854e883p+0,   -0x1.0c2ca5450acdbp+0,   0x1.f5c95cp-2, INEXACT)
T(RN,   -0x1.bb88d36f71b75p+0,    -0x1.0c1d6c466ccdp+0,   0x1.f61128p-2, INEXACT)
T(RN,   -0x1.bb4beab8060f4p+0,   -0x1.0c0e323c00982p+0,   -0x1.f5d41p-2, INEXACT)
T(RN,   -0x1.bb0f0a5de65adp+0,   -0x1.0bfef725eb354p+0,  -0x1.f6d4c6p-2, INEXACT)
T(RN,   -0x1.bad2325feb4d1p+0,   -0x1.0befbb04512c5p+0,  -0x1.f6d2aep-2, INEXACT)
T(RN,   -0x1.ba9562bcef79cp+0,    -0x1.0be07dd75785p+0,  -0x1.f82736p-2, INEXACT)
T(RN,   -0x1.ba589b73cd1a9p+0,   -0x1.0bd13f9f23381p+0,  -0x1.f7f4bcp-2, INEXACT)
T(RN,   -0x1.ba1bdc835e9b4p+0,   -0x1.0bc2005bd9526p+0,  -0x1.f7a9c2p-2, INEXACT)
T(RN,   -0x1.b9df25ea7e8c2p+0,   -0x1.0bb2c00d9ef19p+0,  -0x1.f8e586p-2, INEXACT)
T(RN,   -0x1.b9a277a807a9cp+0,   -0x1.0ba37eb49945fp+0,  -0x1.fb7c1ep-2, INEXACT)
T(RN,   -0x1.b965d1bad4d63p+0,   -0x1.0b943c50ed90dp+0,   -0x1.f66f6p-2, INEXACT)
T(RN,   -0x1.b9293421c125ap+0,   -0x1.0b84f8e2c127bp+0,  -0x1.f99fecp-2, INEXACT)
T(RN,   -0x1.b8ec9edba7c88p+0,   -0x1.0b75b46a396ecp+0,  -0x1.fd3f6ap-2, INEXACT)
T(RN,   -0x1.b8b011e7641a2p+0,   -0x1.0b666ee77bdc9p+0,  -0x1.fdb196p-2, INEXACT)
T(RN,   -0x1.b8738d43d19c7p+0,    -0x1.0b57285aadf9p+0,  -0x1.fe743cp-2, INEXACT)
T(RN,   -0x1.b83710efcbfbbp+0,   -0x1.0b47e0c3f55e2p+0,   0x1.ff95f2p-2, INEXACT)
T(RN,   -0x1.b7fa9cea2f15dp+0,   -0x1.0b38982377ba6p+0,  -0x1.fe7978p-2, INEXACT)
T(RN,   -0x1.b7be3131d6db8p+0,   -0x1.0b294e795ac82p+0,  -0x1.ff8148p-2, INEXACT)
T(RN,   -0x1.b781cdc59f75cp+0,   -0x1.0b1a03c5c457dp+0,   -0x1.fce0bp-2, INEXACT)
T(RN,   -0x1.b74572a46535cp+0,   -0x1.0b0ab808da4b9p+0,   -0x1.fc063p-2, INEXACT)
T(RN,   -0x1.b7091fcd048efp+0,   -0x1.0afb6b42c295cp+0,  -0x1.fade46p-2, INEXACT)
T(RN,   -0x1.b6ccd53e5a1e6p+0,   -0x1.0aec1d73a33aep+0,  -0x1.f8c358p-2, INEXACT)
T(RN,   -0x1.b69092f742a49p+0,   -0x1.0adcce9ba24ffp+0,   0x1.fc0892p-2, INEXACT)
T(RN,   -0x1.b65458f69b13fp+0,   -0x1.0acd7ebae5fe6p+0,   0x1.fcafdep-2, INEXACT)
T(RN,   -0x1.b618273b407e6p+0,   -0x1.0abe2dd1947f1p+0,   -0x1.f7b92p-2, INEXACT)
T(RN,   -0x1.b5dbfdc41022bp+0,   -0x1.0aaedbdfd41dcp+0,  -0x1.f60e22p-2, INEXACT)
T(RN,   -0x1.b59fdc8fe7677p+0,   -0x1.0a9f88e5cb381p+0,  -0x1.ff73f4p-2, INEXACT)
T(RN,   -0x1.b563c39da3d68p+0,   -0x1.0a9034e3a03c1p+0,   0x1.fda19ep-2, INEXACT)
T(RN,   -0x1.b527b2ec2324ep+0,   -0x1.0a80dfd979aa9p+0,   0x1.ff3304p-2, INEXACT)
T(RN,   -0x1.b4ebaa7a4330fp+0,   -0x1.0a7189c77e165p+0,   0x1.fe0182p-2, INEXACT)
T(RN,   -0x1.b4afaa46e1fe8p+0,   -0x1.0a6232add4235p+0,  -0x1.f629c6p-2, INEXACT)
T(RN,   -0x1.b473b250ddb55p+0,   -0x1.0a52da8ca2862p+0,  -0x1.fae62ep-2, INEXACT)
T(RN,   -0x1.b437c29714b32p+0,   -0x1.0a4381641008dp+0,    0x1.fe2e6p-2, INEXACT)
T(RN,   -0x1.b3fbdb18656f5p+0,   -0x1.0a3427344383bp+0,    0x1.fb853p-2, INEXACT)
T(RN,   -0x1.b3bffbd3ae8a4p+0,   -0x1.0a24cbfd63e0fp+0,   0x1.fed4f8p-2, INEXACT)
T(RN,   -0x1.b38424c7ced0bp+0,   -0x1.0a156fbf981ddp+0,   -0x1.fa2b2p-2, INEXACT)
T(RN,   -0x1.b34855f3a537dp+0,   -0x1.0a06127b07495p+0,   -0x1.f7871p-2, INEXACT)
T(RN,   -0x1.b30c8f5610da1p+0,   -0x1.09f6b42fd883cp+0,  -0x1.ffbe5ap-2, INEXACT)
T(RN,   -0x1.b2d0d0edf0f8dp+0,   -0x1.09e754de32feep+0,   0x1.feb5cep-2, INEXACT)
T(RN,   -0x1.b2951aba24ff4p+0,   -0x1.09d7f4863dfefp+0,   0x1.f9bae8p-2, INEXACT)
T(RN,   -0x1.b2596cb98c7b9p+0,   -0x1.09c8932820d89p+0,   0x1.f8ede8p-2, INEXACT)
T(RN,   -0x1.b21dc6eb071e7p+0,   -0x1.09b930c402f0ep+0,   0x1.f70962p-2, INEXACT)
T(RN,   -0x1.b1e2294d74f05p+0,   -0x1.09a9cd5a0bcb4p+0,  -0x1.f8e39ep-2, INEXACT)
T(RN,   -0x1.b1a693dfb5cfcp+0,   -0x1.099a68ea62e79p+0,   0x1.f7924ap-2, INEXACT)
T(RN,   -0x1.b16b06a0a9f86p+0,   -0x1.098b03752fe5bp+0,  -0x1.fd7714p-2, INEXACT)
T(RN,   -0x1.b12f818f31c73p+0,   -0x1.097b9cfa9a753p+0,    0x1.f7f32p-2, INEXACT)
T(RN,   -0x1.b0f404aa2db17p+0,   -0x1.096c357aca53ep+0,   0x1.fafff8p-2, INEXACT)
T(RN,   -0x1.b0b88ff07d40cp+0,   -0x1.095cccf5e709cp+0,   0x1.f5c8ccp-2, INEXACT)
T(RN,   -0x1.b07d236104be9p+0,   -0x1.094d636c1961ap+0,   0x1.f97042p-2, INEXACT)
T(RN,   -0x1.b041befaa1983p+0,   -0x1.093df8dd8866ap+0,  -0x1.f7f9a8p-2, INEXACT)
T(RN,   -0x1.b00662bc361e6p+0,   -0x1.092e8d4a5c6fbp+0,  -0x1.fbcb3cp-2, INEXACT)
T(RN,   -0x1.afcb0ea4a38eap+0,   -0x1.091f20b2bd941p+0,   0x1.f67b8cp-2, INEXACT)
T(RN,   -0x1.af8fc2b2cb5bbp+0,   -0x1.090fb316d4009p+0,  -0x1.fcc132p-2, INEXACT)
T(RN,   -0x1.af547ee58f11ap+0,   -0x1.09004476c7efbp+0,   0x1.fb67f2p-2, INEXACT)
T(RN,   -0x1.af19433bd06edp+0,    -0x1.08f0d4d2c1b1p+0,   0x1.f8121ap-2, INEXACT)
T(RN,   -0x1.aede0fb4714c6p+0,   -0x1.08e1642ae9a26p+0,  -0x1.f629a8p-2, INEXACT)
T(RN,   -0x1.aea2e44e53cb7p+0,   -0x1.08d1f27f683bdp+0,   0x1.fdde1ap-2, INEXACT)
T(RN,   -0x1.ae67c1085a011p+0,   -0x1.08c27fd065fa2p+0,  -0x1.fb77b4p-2, INEXACT)
T(RN,   -0x1.ae2ca5e166517p+0,   -0x1.08b30c1e0b75dp+0,   0x1.fd2a08p-2, INEXACT)
T(RN,    -0x1.adf192d85b3ap+0,    -0x1.08a397688156p+0,  -0x1.f7c114p-2, INEXACT)
T(RN,   -0x1.adb687ec1b5e9p+0,   -0x1.089421aff052fp+0,  -0x1.f6fe76p-2, INEXACT)
T(RN,   -0x1.ad7b851b898bfp+0,   -0x1.0884aaf481376p+0,  -0x1.f88ec6p-2, INEXACT)
T(RN,   -0x1.ad408a6588b99p+0,   -0x1.087533365ce0ap+0,   0x1.fd279ap-2, INEXACT)
T(RN,    -0x1.ad0597c8fc04p+0,   -0x1.0865ba75ac3d8p+0,  -0x1.f8051ap-2, INEXACT)
T(RN,   -0x1.accaad44c6a73p+0,   -0x1.085640b2984c2p+0,   0x1.f7c7f6p-2, INEXACT)
T(RN,   -0x1.ac8fcad7cc118p+0,   -0x1.0846c5ed4a1fep+0,  -0x1.fb13f8p-2, INEXACT)
T(RN,   -0x1.ac54f080efd21p+0,   -0x1.08374a25eadbdp+0,  -0x1.fb201ep-2, INEXACT)
T(RN,   -0x1.ac1a1e3f159abp+0,   -0x1.0827cd5ca3b3ep+0,   -0x1.f647dp-2, INEXACT)
T(RN,   -0x1.abdf5411215c1p+0,    -0x1.08184f919df4p+0,  -0x1.fa2f1cp-2, INEXACT)
T(RN,   -0x1.aba491f5f70d8p+0,   -0x1.0808d0c502f16p+0,  -0x1.fa913cp-2, INEXACT)
T(RN,   -0x1.ab69d7ec7adc6p+0,   -0x1.07f950f6fc16ep+0,   0x1.fb0e0ep-2, INEXACT)
T(RN,   -0x1.ab2f25f391222p+0,   -0x1.07e9d027b2e2cp+0,  -0x1.fbf4bap-2, INEXACT)
T(RN,   -0x1.aaf47c0a1e53ep+0,   -0x1.07da4e5750e1ap+0,   0x1.fbc3a4p-2, INEXACT)
T(RN,   -0x1.aab9da2f07169p+0,   -0x1.07cacb85ffb4bp+0,   0x1.f87f3ep-2, INEXACT)
T(RN,   -0x1.aa7f4061302dep+0,   -0x1.07bb47b3e90c9p+0,  -0x1.f932f8p-2, INEXACT)
T(RN,    -0x1.aa44ae9f7e91p+0,   -0x1.07abc2e136aedp+0,   0x1.fe4318p-2, INEXACT)
T(RN,   -0x1.aa0a24e8d7547p+0,   -0x1.079c3d0e1270bp+0,  -0x1.fc1956p-2, INEXACT)
T(RN,   -0x1.a9cfa33c1fb4dp+0,   -0x1.078cb63aa6391p+0,   0x1.fa454ep-2, INEXACT)
T(RN,   -0x1.a99529983d11fp+0,   -0x1.077d2e671c001p+0,   0x1.fce58ep-2, INEXACT)
T(RN,   -0x1.a95ab7fc14f92p+0,   -0x1.076da5939dd12p+0,   0x1.fc41c6p-2, INEXACT)
T(RN,   -0x1.a9204e668d1edp+0,   -0x1.075e1bc055c9ap+0,   0x1.f785bcp-2, INEXACT)
T(RN,   -0x1.a8e5ecd68b578p+0,   -0x1.074e90ed6e16fp+0,   0x1.faf51cp-2, INEXACT)
T(RN,   -0x1.a8ab934af59e5p+0,   -0x1.073f051b10f83p+0,   0x1.f7c21cp-2, INEXACT)
T(RN,   -0x1.a87141c2b22ffp+0,   -0x1.072f784968c57p+0,   0x1.f8e7cap-2, INEXACT)
T(RN,   -0x1.a836f83ca73c1p+0,   -0x1.071fea789fdadp+0,  -0x1.f7fb6ap-2, INEXACT)
T(RN,   -0x1.a7fcb6b7bb432p+0,   -0x1.07105ba8e0b14p+0,  -0x1.f67912p-2, INEXACT)
T(RN,   -0x1.a7c27d32d4e15p+0,   -0x1.0700cbda55d0bp+0,    0x1.f6df3p-2, INEXACT)
T(RN,   -0x1.a7884bacdacf1p+0,   -0x1.06f13b0d29d04p+0,  -0x1.f71fb4p-2, INEXACT)
T(RN,   -0x1.a74e2224b3fa4p+0,   -0x1.06e1a941875c7p+0,   -0x1.f5cdep-2, INEXACT)
T(RN,   -0x1.a7140099476f1p+0,   -0x1.06d2167799319p+0,  -0x1.faeb7cp-2, INEXACT)
T(RN,   -0x1.a6d9e7097c624p+0,   -0x1.06c282af8a1e2p+0,   0x1.fc1cacp-2, INEXACT)
T(RN,   -0x1.a69fd5743a2bcp+0,   -0x1.06b2ede98501cp+0,  -0x1.f6cee6p-2, INEXACT)
T(RN,   -0x1.a665cbd86853bp+0,     -0x1.06a35825b4dp+0,   0x1.f84914p-2, INEXACT)
T(RN,   -0x1.a62bca34ee77ap+0,   -0x1.0693c164448a1p+0,   0x1.fb2ea8p-2, INEXACT)
T(RN,   -0x1.a5f1d088b4721p+0,   -0x1.068429a55f48cp+0,   -0x1.fc4b3p-2, INEXACT)
T(RN,   -0x1.a5b7ded2a2178p+0,   -0x1.067490e9302a9p+0,  -0x1.f6b472p-2, INEXACT)
T(RN,   -0x1.a57df5119fc8fp+0,   -0x1.0664f72fe27b7p+0,  -0x1.fb5e58p-2, INEXACT)
T(RN,   -0x1.a5441344958e8p+0,   -0x1.06555c79a176cp+0,  -0x1.f78ae6p-2, INEXACT)
T(RN,   -0x1.a50a396a6bdc8p+0,   -0x1.0645c0c6987c7p+0,  -0x1.fd76f8p-2, INEXACT)
T(RN,   -0x1.a4d067820b42ep+0,   -0x1.06362416f2fb5p+0,   -0x1.f7238p-2, INEXACT)
T(RN,   -0x1.a4969d8a5c78cp+0,   -0x1.0626866adc742p+0,   0x1.f87344p-2, INEXACT)
T(RN,   -0x1.a45cdb824858cp+0,   -0x1.0616e7c28078dp+0,   0x1.f808fcp-2, INEXACT)
T(RN,   -0x1.a4232168b7e2dp+0,   -0x1.0607481e0aacap+0,   0x1.fbcb32p-2, INEXACT)
T(RN,   -0x1.a3e96f3c9445ep+0,    -0x1.05f7a77da6c7p+0,   0x1.ff6da2p-2, INEXACT)
T(RN,   -0x1.a3afc4fcc6c85p+0,   -0x1.05e805e1808d2p+0,   0x1.f99ae2p-2, INEXACT)
T(RN,   -0x1.a37622a838dffp+0,   -0x1.05d86349c3d87p+0,   0x1.ff60f6p-2, INEXACT)
T(RN,   -0x1.a33c883dd42e4p+0,   -0x1.05c8bfb69c95ap+0,   0x1.fec1e6p-2, INEXACT)
T(RN,   -0x1.a302f5bc826efp+0,   -0x1.05b91b2836bfep+0,   0x1.f8dca2p-2, INEXACT)
T(RN,    -0x1.a2c96b232d85p+0,   -0x1.05a9759ebe647p+0,   0x1.fa1912p-2, INEXACT)
T(RN,   -0x1.a28fe870bf8a9p+0,   -0x1.0599cf1a5fa6fp+0,   0x1.f73792p-2, INEXACT)
T(RN,   -0x1.a2566da4229d3p+0,   -0x1.058a279b46b35p+0,    0x1.f7bd1p-2, INEXACT)
T(RN,   -0x1.a21cfabc41145p+0,   -0x1.057a7f219fccap+0,   0x1.f60fe6p-2, INEXACT)
T(RN,   -0x1.a1e38fb805c7fp+0,   -0x1.056ad5ad97606p+0,   0x1.fc4cf6p-2, INEXACT)
T(RN,   -0x1.a1aa2c965ae68p+0,   -0x1.055b2b3f59b54p+0,  -0x1.f87f36p-2, INEXACT)
T(RN,   -0x1.a170d1562b77bp+0,   -0x1.054b7fd713546p+0,  -0x1.f8bb26p-2, INEXACT)
T(RN,   -0x1.a1377df662606p+0,   -0x1.053bd374f0c4ep+0,   0x1.fde3cap-2, INEXACT)
T(RN,   -0x1.a0fe3275eab76p+0,   -0x1.052c26191ea31p+0,  -0x1.fec43ep-2, INEXACT)
T(RN,   -0x1.a0c4eed3afc2ap+0,   -0x1.051c77c3c99f1p+0,   0x1.fec678p-2, INEXACT)
T(RN,   -0x1.a08bb30e9ce0dp+0,   -0x1.050cc8751e77ap+0,  -0x1.f9ac96p-2, INEXACT)
T(RN,   -0x1.a0527f259d9e2p+0,   -0x1.04fd182d49feep+0,  -0x1.fe7944p-2, INEXACT)
T(RN,   -0x1.a01953179dacfp+0,   -0x1.04ed66ec7918fp+0,   0x1.f7cf56p-2, INEXACT)
T(RN,   -0x1.9fe02ee388e09p+0,   -0x1.04ddb4b2d8ba7p+0,   0x1.fe88aep-2, INEXACT)
T(RN,   -0x1.9fa712884b341p+0,   -0x1.04ce018095ea2p+0,  -0x1.f68f0ap-2, INEXACT)
T(RN,   -0x1.9f6dfe04d0cd3p+0,   -0x1.04be4d55ddc1bp+0,  -0x1.f77174p-2, INEXACT)
T(RN,    -0x1.9f34f15805f1p+0,   -0x1.04ae9832dd6aep+0,   0x1.f64a18p-2, INEXACT)
T(RN,   -0x1.9efbec80d70fbp+0,   -0x1.049ee217c222dp+0,  -0x1.f84fa2p-2, INEXACT)
T(RN,   -0x1.9ec2ef7e30bacp+0,   -0x1.048f2b04b936cp+0,  -0x1.f7eb22p-2, INEXACT)
T(RN,   -0x1.9e89fa4effa87p+0,   -0x1.047f72f9f005ap+0,   -0x1.fc23dp-2, INEXACT)
T(RN,   -0x1.9e510cf230c1cp+0,   -0x1.046fb9f79403ap+0,  -0x1.fdcf2ep-2, INEXACT)
T(RN,   -0x1.9e182766b1074p+0,   -0x1.045ffffdd2b2cp+0,   -0x1.fc7fap-2, INEXACT)
T(RN,   -0x1.9ddf49ab6d9dcp+0,   -0x1.0450450cd9a64p+0,   0x1.f69a44p-2, INEXACT)
T(RN,   -0x1.9da673bf53dc5p+0,   -0x1.04408924d686cp+0,   0x1.fc771ap-2, INEXACT)
T(RN,   -0x1.9d6da5a15134fp+0,   -0x1.0430cc45f70b7p+0,   0x1.fa558ap-2, INEXACT)
T(RN,   -0x1.9d34df5053451p+0,   -0x1.04210e7068feep+0,   0x1.fcccbap-2, INEXACT)
T(RN,   -0x1.9cfc20cb47d3fp+0,   -0x1.04114fa45a3e8p+0,   0x1.f75304p-2, INEXACT)
T(RN,   -0x1.9cc36a111cc6bp+0,   -0x1.04018fe1f8b76p+0,  -0x1.f811bep-2, INEXACT)
T(RN,    -0x1.9c8abb20c023p+0,   -0x1.03f1cf297266ap+0,   0x1.f73f6cp-2, INEXACT)
T(RN,   -0x1.9c5213f920204p+0,   -0x1.03e20d7af55eep+0,   -0x1.f8d94p-2, INEXACT)
T(RN,   -0x1.9c1974992b133p+0,   -0x1.03d24ad6afc1cp+0,  -0x1.fd4634p-2, INEXACT)
T(RN,   -0x1.9be0dcffcf84ep+0,   -0x1.03c2873ccfc6ep+0,   0x1.f6b904p-2, INEXACT)
T(RN,   -0x1.9ba84d2bfc0c1p+0,   -0x1.03b2c2ad83b12p+0,  -0x1.f8a112p-2, INEXACT)
T(RN,    -0x1.9b6fc51c9f76p+0,   -0x1.03a2fd28f9d96p+0,   0x1.fdebcep-2, INEXACT)
T(RN,   -0x1.9b3744d0a8b1dp+0,   -0x1.039336af60a9ap+0,   0x1.f791aap-2, INEXACT)
T(RN,   -0x1.9afecc4706d16p+0,   -0x1.03836f40e69c9p+0,   0x1.ff83c4p-2, INEXACT)
T(RN,   -0x1.9ac65b7ea90f9p+0,   -0x1.0373a6ddba3fap+0,   0x1.f68ceap-2, INEXACT)
T(RN,   -0x1.9a8df2767ecd2p+0,   -0x1.0363dd860a322p+0,  -0x1.fa9c3cp-2, INEXACT)
T(RN,   -0x1.9a55912d7782dp+0,   -0x1.0354133a05212p+0,  -0x1.f67ec4p-2, INEXACT)
T(RN,   -0x1.9a1d37a282f04p+0,   -0x1.034447f9d9d4fp+0,  -0x1.fb31ccp-2, INEXACT)
T(RN,   -0x1.99e4e5d490d53p+0,   -0x1.03347bc5b71d1p+0,   -0x1.f9eaap-2, INEXACT)
T(RN,   -0x1.99ac9bc29124dp+0,   -0x1.0324ae9dcbde9p+0,   0x1.fe523cp-2, INEXACT)
T(RN,   -0x1.9974596b74014p+0,   -0x1.0314e08247131p+0,    0x1.f8192p-2, INEXACT)
T(RN,   -0x1.993c1ece2996ap+0,   -0x1.0305117357be1p+0,  -0x1.f5d80ep-2, INEXACT)
T(RN,   -0x1.9903ebe9a26a3p+0,   -0x1.02f541712d033p+0,  -0x1.fba34cp-2, INEXACT)
T(RN,   -0x1.98cbc0bccef33p+0,   -0x1.02e5707bf6098p+0,   -0x1.f7b7ep-2, INEXACT)
T(RN,    -0x1.98939d469fd8p+0,   -0x1.02d59e93e20c6p+0,   0x1.faab6cp-2, INEXACT)
T(RN,   -0x1.985b818605f9ap+0,   -0x1.02c5cbb9205f2p+0,  -0x1.fcb3fcp-2, INEXACT)
T(RN,   -0x1.98236d79f24e6p+0,   -0x1.02b5f7ebe061dp+0,   0x1.f68912p-2, INEXACT)
T(RN,   -0x1.97eb612155f37p+0,   -0x1.02a6232c51871p+0,   0x1.fdb476p-2, INEXACT)
T(RN,   -0x1.97b35c7b222e6p+0,   -0x1.02964d7aa353ep+0,   -0x1.fc584p-2, INEXACT)
T(RN,   -0x1.977b5f864866fp+0,   -0x1.028676d7055dfp+0,  -0x1.fafb42p-2, INEXACT)
T(RN,   -0x1.97436a41ba2adp+0,   -0x1.02769f41a74cfp+0,   0x1.fbd86cp-2, INEXACT)
T(RN,   -0x1.970b7cac692e1p+0,   -0x1.0266c6bab8dacp+0,  -0x1.fb520ep-2, INEXACT)
T(RN,   -0x1.96d396c5474b5p+0,   -0x1.0256ed4269d2fp+0,  -0x1.fd1bc4p-2, INEXACT)
T(RN,   -0x1.969bb88b4682ep+0,   -0x1.024712d8ea131p+0,   0x1.fb28dep-2, INEXACT)
T(RN,   -0x1.9663e1fd58ecep+0,   -0x1.0237377e6986bp+0,   0x1.fe6a62p-2, INEXACT)
T(RN,   -0x1.962c131a70de7p+0,   -0x1.02275b331831bp+0,  -0x1.f835aap-2, INEXACT)
T(RN,   -0x1.95f44be180b6ap+0,   -0x1.02177df72621bp+0,    0x1.f949dp-2, INEXACT)
T(RN,   -0x1.95bc8c517b0f1p+0,   -0x1.02079fcac37c7p+0,   0x1.f98f28p-2, INEXACT)
T(RN,   -0x1.9584d46952a11p+0,   -0x1.01f7c0ae20779p+0,    0x1.f5f9ep-2, INEXACT)
T(RN,   -0x1.954d2427fa45ep+0,   -0x1.01e7e0a16d58fp+0,   0x1.f5fceap-2, INEXACT)
T(RN,   -0x1.95157b8c64f2cp+0,   -0x1.01d7ffa4da758p+0,   0x1.f6b9c2p-2, INEXACT)
T(RN,   -0x1.94ddda9585bd9p+0,   -0x1.01c81db898329p+0,   0x1.f64868p-2, INEXACT)
T(RN,   -0x1.94a641425046ep+0,   -0x1.01b83adcd7243p+0,  -0x1.f5d3dep-2, INEXACT)
T(RN,   -0x1.946eaf91b7c69p+0,   -0x1.01a85711c7c77p+0,   -0x1.fc841p-2, INEXACT)
T(RN,   -0x1.94372582afadfp+0,    -0x1.019872579ab1p+0,   -0x1.f99a5p-2, INEXACT)
T(RN,   -0x1.93ffa3142bd9dp+0,   -0x1.01888cae809b5p+0,   -0x1.f8e55p-2, INEXACT)
T(RN,   -0x1.93c8284520231p+0,   -0x1.0178a616aa46cp+0,  -0x1.fc710ap-2, INEXACT)
T(RN,   -0x1.9390b5148097ap+0,   -0x1.0168be904889fp+0,  -0x1.fffb86p-2, INEXACT)
T(RN,   -0x1.93594981414ddp+0,   -0x1.0158d61b8c44fp+0,  -0x1.fae912p-2, INEXACT)
T(RN,   -0x1.9321e58a56959p+0,   -0x1.0148ecb8a66f6p+0,   -0x1.f7055p-2, INEXACT)
T(RN,   -0x1.92ea892eb4ec3p+0,   -0x1.01390267c814fp+0,  -0x1.f788e8p-2, INEXACT)
T(RN,   -0x1.92b3346d50dd8p+0,   -0x1.01291729224c8p+0,  -0x1.fb806ep-2, INEXACT)
T(RN,   -0x1.927be7451f24ep+0,   -0x1.01192afce641ap+0,  -0x1.fa645ap-2, INEXACT)
T(RN,   -0x1.9244a1b514a3ep+0,   -0x1.01093de34531ep+0,  -0x1.fb75f4p-2, INEXACT)
T(RN,   -0x1.920d63bc265e9p+0,   -0x1.00f94fdc706bcp+0,  -0x1.f6fed6p-2, INEXACT)
T(RN,   -0x1.91d62d59497dep+0,   -0x1.00e960e8994f5p+0,   0x1.fbac8ep-2, INEXACT)
T(RN,   -0x1.919efe8b7350fp+0,   -0x1.00d97107f14eep+0,  -0x1.fa27ccp-2, INEXACT)
T(RN,   -0x1.9167d75199446p+0,   -0x1.00c9803aa9ebep+0,  -0x1.fe9594p-2, INEXACT)
T(RN,   -0x1.9130b7aab0f4fp+0,   -0x1.00b98e80f4bcdp+0,   0x1.f73c66p-2, INEXACT)
T(RN,    -0x1.90f99f95b019p+0,   -0x1.00a99bdb0366cp+0,  -0x1.f8f9cap-2, INEXACT)
T(RN,   -0x1.90c28f118c977p+0,   -0x1.0099a84907a35p+0,   0x1.f8d2e4p-2, INEXACT)
T(RN,   -0x1.908b861d3c69ep+0,   -0x1.0089b3cb3338fp+0,   0x1.f6f54cp-2, INEXACT)
T(RN,   -0x1.905484b7b5be5p+0,   -0x1.0079be61b803fp+0,   0x1.f70934p-2, INEXACT)
T(RN,   -0x1.901d8adfeeeadp+0,   -0x1.0069c80cc7f35p+0,  -0x1.f6b018p-2, INEXACT)
T(RN,   -0x1.8fe69894de57cp+0,   -0x1.0059d0cc95022p+0,  -0x1.f5ec44p-2, INEXACT)
T(RN,   -0x1.8fafadd57a9cbp+0,   -0x1.0049d8a151403p+0,   0x1.ffcaacp-2, INEXACT)
T(RN,   -0x1.8f78caa0ba756p+0,   -0x1.0039df8b2eceep+0,   0x1.fa3478p-2, INEXACT)
T(RN,   -0x1.8f41eef594be5p+0,   -0x1.0029e58a5fdfep+0,  -0x1.fb40d8p-2, INEXACT)
T(RN,   -0x1.8f0b1ad30071cp+0,   -0x1.0019ea9f16b44p+0,    0x1.f7a8ep-2, INEXACT)
T(RN,   -0x1.8ed44e37f4dd8p+0,   -0x1.0009eec985acbp+0,   0x1.f8ffb6p-2, INEXACT)
T(RN,   -0x1.8e9d892369278p+0,   -0x1.fff3e413be49ep-1,  -0x1.fdcd04p-2, INEXACT)
T(RN,   -0x1.8e66cb9454cabp+0,   -0x1.ffd3e8c0ab30bp-1,  -0x1.f86ff4p-2, INEXACT)
T(RN,   -0x1.8e301589af635p+0,    -0x1.ffb3eb9a3726p-1,  -0x1.ff60f4p-2, INEXACT)
T(RN,   -0x1.8df9670270a1dp+0,   -0x1.ff93eca0c75b6p-1,   0x1.fa305ap-2, INEXACT)
T(RN,   -0x1.8dc2bffd906b4p+0,   -0x1.ff73ebd4c12f1p-1,   0x1.f82ba6p-2, INEXACT)
T(RN,   -0x1.8d8c207a06a57p+0,   -0x1.ff53e9368a0d5p-1,  -0x1.f6519ep-2, INEXACT)
T(RN,   -0x1.8d558876cbbe4p+0,   -0x1.ff33e4c687bfbp-1,  -0x1.fc130ap-2, INEXACT)
T(RN,   -0x1.8d1ef7f2d7b9fp+0,   -0x1.ff13de851fdfbp-1,  -0x1.f8bb22p-2, INEXACT)
T(RN,     -0x1.8ce86eed232p+0,   -0x1.fef3d672b8616p-1,  -0x1.f7a596p-2, INEXACT)
T(RN,   -0x1.8cb1ed64a680dp+0,   -0x1.fed3cc8fb74bbp-1,  -0x1.fc4632p-2, INEXACT)
T(RN,   -0x1.8c7b73585a8c9p+0,   -0x1.feb3c0dc82c5ep-1,  -0x1.f9be4cp-2, INEXACT)
T(RN,   -0x1.8c4500c73837ep+0,   -0x1.fe93b359812d1p-1,   -0x1.fbad4p-2, INEXACT)
T(RN,   -0x1.8c0e95b03866cp+0,   -0x1.fe73a40718e23p-1,  -0x1.f9e95cp-2, INEXACT)
T(RN,   -0x1.8bd8321254485p+0,     -0x1.fe5392e5b08p-1,  -0x1.fec70ep-2, INEXACT)
T(RN,   -0x1.8ba1d5ec85235p+0,   -0x1.fe337ff5aebcbp-1,   0x1.f9bba8p-2, INEXACT)
T(RN,    -0x1.8b6b813dc45ep+0,   -0x1.fe136b377a6ecp-1,   0x1.f765f8p-2, INEXACT)
T(RN,   -0x1.8b3534050b90cp+0,   -0x1.fdf354ab7a97bp-1,   -0x1.f6cdfp-2, INEXACT)
T(RN,   -0x1.8afeee41546b1p+0,   -0x1.fdd33c5216541p-1,  -0x1.f96b22p-2, INEXACT)
T(RN,   -0x1.8ac8aff198c39p+0,   -0x1.fdb3222bb4e53p-1,   0x1.f95afap-2, INEXACT)
T(RN,   -0x1.8a927914d2994p+0,   -0x1.fd930638bdb1ep-1,   0x1.f6f7fap-2, INEXACT)
T(RN,   -0x1.8a5c49a9fc06fp+0,   -0x1.fd72e879983ecp-1,  -0x1.f747dcp-2, INEXACT)
T(RN,   -0x1.8a2621b00f53dp+0,    -0x1.fd52c8eeac38p-1,    0x1.fb61ep-2, INEXACT)
T(RN,   -0x1.89f0012606eabp+0,   -0x1.fd32a798616cdp-1,  -0x1.fa6ad4p-2, INEXACT)
T(RN,   -0x1.89b9e80add4efp+0,   -0x1.fd1284771fc7ep-1,   0x1.f861fap-2, INEXACT)
T(RN,   -0x1.8983d65d8d36ap+0,   -0x1.fcf25f8b4f5fdp-1,   0x1.fb2142p-2, INEXACT)
T(RN,   -0x1.894dcc1d11717p+0,   -0x1.fcd238d55867ap-1,   0x1.fa2a16p-2, INEXACT)
T(RN,    -0x1.8917c94864f9p+0,   -0x1.fcb21055a338bp-1,   0x1.fad1e8p-2, INEXACT)
T(RN,   -0x1.88e1cdde82e7fp+0,   -0x1.fc91e60c984d6p-1,    0x1.fce63p-2, INEXACT)
T(RN,   -0x1.88abd9de667b4p+0,   -0x1.fc71b9faa041fp-1,  -0x1.fa57f8p-2, INEXACT)
T(RN,   -0x1.8875ed470b15ep+0,   -0x1.fc518c2023d65p-1,    0x1.fa308p-2, INEXACT)
T(RN,   -0x1.884008176c44ep+0,   -0x1.fc315c7d8bf14p-1,   0x1.fc1d9ep-2, INEXACT)
T(RN,   -0x1.880a2a4e85a5bp+0,   -0x1.fc112b1341905p-1,   0x1.f95398p-2, INEXACT)
T(RN,   -0x1.87d453eb53132p+0,   -0x1.fbf0f7e1ade31p-1,   0x1.fb4d18p-2, INEXACT)
T(RN,   -0x1.879e84ecd07a1p+0,   -0x1.fbd0c2e93a312p-1,   0x1.fa8c0cp-2, INEXACT)
T(RN,    -0x1.8768bd51f9e3p+0,   -0x1.fbb08c2a4fdfep-1,   0x1.f9654ap-2, INEXACT)
T(RN,   -0x1.8732fd19cba97p+0,   -0x1.fb9053a55893bp-1,  -0x1.fe2fccp-2, INEXACT)
T(RN,   -0x1.86fd444341dddp+0,   -0x1.fb70195abdd0fp-1,  -0x1.f5c928p-2, INEXACT)
T(RN,   -0x1.86c792cd597a6p+0,   -0x1.fb4fdd4ae9b5ap-1,  -0x1.f71ac2p-2, INEXACT)
T(RN,   -0x1.8691e8b70ed69p+0,   -0x1.fb2f9f76460b3p-1,  -0x1.f5f0d4p-2, INEXACT)
T(RN,   -0x1.865c45ff5eb3ap+0,   -0x1.fb0f5fdd3ce7bp-1,   -0x1.fb51bp-2, INEXACT)
T(RN,   -0x1.8626aaa546134p+0,    -0x1.faef1e803895p-1,   0x1.f96606p-2, INEXACT)
T(RN,   -0x1.85f116a7c1f86p+0,   -0x1.facedb5fa36b1p-1,   0x1.fb4084p-2, INEXACT)
T(RN,   -0x1.85bb8a05cf984p+0,    -0x1.faae967be7edp-1,   0x1.ff2baep-2, INEXACT)
T(RN,   -0x1.858604be6c516p+0,   -0x1.fa8e4fd570c3fp-1,   0x1.f6ee6cp-2, INEXACT)
T(RN,   -0x1.855086d09591dp+0,   -0x1.fa6e076ca8af7p-1,   0x1.f97772p-2, INEXACT)
T(RN,   -0x1.851b103b48fc8p+0,   -0x1.fa4dbd41fa9c1p-1,  -0x1.f61cb2p-2, INEXACT)
T(RN,   -0x1.84e5a0fd8458cp+0,   -0x1.fa2d7155d1992p-1,   0x1.f7924ep-2, INEXACT)
T(RN,   -0x1.84b03916457e2p+0,   -0x1.fa0d23a898cd2p-1,   0x1.fe4066p-2, INEXACT)
T(RN,   -0x1.847ad8848a7c7p+0,   -0x1.f9ecd43abb8d6p-1,  -0x1.f6a912p-2, INEXACT)
T(RN,    -0x1.84457f475178p+0,   -0x1.f9cc830ca5487p-1,  -0x1.f69d1cp-2, INEXACT)
T(RN,   -0x1.84102d5d98c4bp+0,   -0x1.f9ac301ec196dp-1,  -0x1.ff143ep-2, INEXACT)
T(RN,   -0x1.83dae2c65ece5p+0,   -0x1.f98bdb717c2c5p-1,   0x1.f8e5fap-2, INEXACT)
T(RN,   -0x1.83a59f80a2344p+0,   -0x1.f96b850540e92p-1,   0x1.fb1dfap-2, INEXACT)
T(RN,   -0x1.8370638b61a4ep+0,   -0x1.f94b2cda7bc34p-1,   0x1.f6064ep-2, INEXACT)
T(RN,   -0x1.833b2ee59bff4p+0,   -0x1.f92ad2f198db4p-1,  -0x1.f9e8c6p-2, INEXACT)
T(RN,   -0x1.8306018e501ffp+0,   -0x1.f90a774b045cdp-1,  -0x1.f63222p-2, INEXACT)
T(RN,   -0x1.82d0db847d903p+0,   -0x1.f8ea19e72ae9cp-1,  -0x1.f8b39cp-2, INEXACT)
T(RN,   -0x1.829bbcc7232f5p+0,   -0x1.f8c9bac678c92p-1,   0x1.f65c7cp-2, INEXACT)
T(RN,   -0x1.8266a55540876p+0,    -0x1.f8a959e95ab7p-1,  -0x1.fd3b12p-2, INEXACT)
T(RN,   -0x1.8231952dd524bp+0,   -0x1.f888f7503d7d3p-1,   0x1.fa5c7ep-2, INEXACT)
T(RN,   -0x1.81fc8c4fe0ba6p+0,   -0x1.f86892fb8e0a7p-1,  -0x1.fbeb6cp-2, INEXACT)
T(RN,   -0x1.81c78aba63151p+0,   -0x1.f8482cebb9695p-1,   0x1.f86f06p-2, INEXACT)
T(RN,   -0x1.8192906c5c2c8p+0,   -0x1.f827c5212ccbep-1,   0x1.f8fe82p-2, INEXACT)
T(RN,   -0x1.815d9d64cc1acp+0,   -0x1.f8075b9c5585ap-1,   0x1.fdfaaep-2, INEXACT)
T(RN,   -0x1.8128b1a2b318fp+0,   -0x1.f7e6f05da109ep-1,  -0x1.fd9f3cp-2, INEXACT)
T(RN,   -0x1.80f3cd251186dp+0,   -0x1.f7c683657cf01p-1,  -0x1.ff5766p-2, INEXACT)
T(RN,   -0x1.80beefeae7ec6p+0,   -0x1.f7a614b456f52p-1,  -0x1.f5fdc2p-2, INEXACT)
T(RN,   -0x1.808a19f336e84p+0,   -0x1.f785a44a9cf06p-1,     0x1.f7a9p-2, INEXACT)
T(RN,   -0x1.80554b3cff455p+0,   -0x1.f7653228bce12p-1,  -0x1.fe2636p-2, INEXACT)
T(RN,   -0x1.802083c741eabp+0,   -0x1.f744be4f24e43p-1,     0x1.f60ep-2, INEXACT)
T(RN,   -0x1.7febc390fff12p+0,   -0x1.f72448be4341fp-1,  -0x1.f6b722p-2, INEXACT)
T(RN,   -0x1.7fb70a993a7edp+0,   -0x1.f703d17686572p-1,  -0x1.fe1192p-2, INEXACT)
T(RN,   -0x1.7f8258def2ee5p+0,   -0x1.f6e358785cad8p-1,  -0x1.f722acp-2, INEXACT)
T(RN,   -0x1.7f4dae612ab73p+0,   -0x1.f6c2ddc434ed1p-1,   0x1.fd0fccp-2, INEXACT)
T(RN,   -0x1.7f190b1ee371bp+0,   -0x1.f6a2615a7ddeap-1,    0x1.fd265p-2, INEXACT)
T(RN,   -0x1.7ee46f171ed86p+0,   -0x1.f681e33ba66c8p-1,  -0x1.f85034p-2, INEXACT)
T(RN,   -0x1.7eafda48ded41p+0,   -0x1.f66163681da9dp-1,   0x1.f902d8p-2, INEXACT)
T(RN,   -0x1.7e7b4cb3255b1p+0,   -0x1.f640e1e052bedp-1,   0x1.f7003cp-2, INEXACT)
T(RN,   -0x1.7e46c654f4a32p+0,   -0x1.f6205ea4b5073p-1,  -0x1.f8c322p-2, INEXACT)
T(RN,   -0x1.7e12472d4eeaep+0,   -0x1.f5ffd9b5b3f05p-1,   0x1.ff44d2p-2, INEXACT)
T(RN,   -0x1.7dddcf3b36a02p+0,   -0x1.f5df5313bf118p-1,   0x1.f741fep-2, INEXACT)
T(RN,   -0x1.7da95e7dae49ep+0,   -0x1.f5becabf461dcp-1,   0x1.f6dd8ep-2, INEXACT)
T(RN,   -0x1.7d74f4f3b8acbp+0,   -0x1.f59e40b8b8fabp-1,  -0x1.f71294p-2, INEXACT)
T(RN,   -0x1.7d40929c588afp+0,   -0x1.f57db5008798bp-1,  -0x1.fa8b0ap-2, INEXACT)
T(RN,   -0x1.7d0c377690df4p+0,   -0x1.f55d279722177p-1,   0x1.fd6584p-2, INEXACT)
T(RN,   -0x1.7cd7e38164c77p+0,   -0x1.f53c987cf8b8ep-1,   0x1.fc8f96p-2, INEXACT)
T(RN,   -0x1.7ca396bbd77ebp+0,   -0x1.f51c07b27bdd5p-1,  -0x1.f98b54p-2, INEXACT)
T(RN,    -0x1.7c6f5124ec62p+0,   -0x1.f4fb75381c062p-1,   0x1.f814bep-2, INEXACT)
T(RN,   -0x1.7c3b12bba6f0dp+0,   -0x1.f4dae10e49d6bp-1,   0x1.fb4cf2p-2, INEXACT)
T(RN,   -0x1.7c06db7f0adadp+0,   -0x1.f4ba4b35761c6p-1,   0x1.faa84cp-2, INEXACT)
T(RN,   -0x1.7bd2ab6e1bd4bp+0,   -0x1.f499b3ae11b3ep-1,   0x1.f68d12p-2, INEXACT)
T(RN,   -0x1.7b9e8287ddd3ap+0,   -0x1.f4791a788dae5p-1,  -0x1.f679fep-2, INEXACT)
T(RN,   -0x1.7b6a60cb54ec7p+0,   -0x1.f4587f955b3c8p-1,  -0x1.fa803ep-2, INEXACT)
T(RN,   -0x1.7b364637854adp+0,   -0x1.f437e304eba9cp-1,   0x1.fbb7f8p-2, INEXACT)
T(RN,   -0x1.7b0232cb73309p+0,   -0x1.f41744c7b05b7p-1,  -0x1.f910fcp-2, INEXACT)
T(RN,   -0x1.7ace2686231b4p+0,   -0x1.f3f6a4de1ae7fp-1,   0x1.fb7bf6p-2, INEXACT)
T(RN,   -0x1.7a9a216699a09p+0,   -0x1.f3d603489d013p-1,   0x1.fbba28p-2, INEXACT)
T(RN,   -0x1.7a66236bdb7b3p+0,   -0x1.f3b56007a87c1p-1,   0x1.f5ec54p-2, INEXACT)
T(RN,   -0x1.7a322c94ed85cp+0,   -0x1.f394bb1baf4d8p-1,   0x1.f80f28p-2, INEXACT)
T(RN,   -0x1.79fe3ce0d4c13p+0,   -0x1.f3741485238e7p-1,   0x1.f79f04p-2, INEXACT)
T(RN,   -0x1.79ca544e964a2p+0,   -0x1.f3536c4477752p-1,    0x1.fb7a3p-2, INEXACT)
T(RN,    -0x1.799672dd3767p+0,   -0x1.f332c25a1d5e1p-1,  -0x1.f99bb2p-2, INEXACT)
T(RN,   -0x1.7962988bbd7a1p+0,   -0x1.f31216c687c2ep-1,    0x1.fea2bp-2, INEXACT)
T(RN,   -0x1.792ec5592e0fbp+0,    -0x1.f2f1698a2944p-1,  -0x1.fc4edcp-2, INEXACT)
T(RN,   -0x1.78faf9448ec76p+0,   -0x1.f2d0baa574994p-1,   0x1.f7722ap-2, INEXACT)
T(RN,   -0x1.78c7344ce580cp+0,   -0x1.f2b00a18dcaf2p-1,   0x1.ffd75cp-2, INEXACT)
T(RN,    -0x1.78937671381ap+0,   -0x1.f28f57e4d47cdp-1,    -0x1.fffep-2, INEXACT)
T(RN,   -0x1.785fbfb08caadp+0,   -0x1.f26ea409cf296p-1,    0x1.fffa6p-2, INEXACT)
T(RN,   -0x1.782c1009e9681p+0,   -0x1.f24dee883ffa8p-1,  -0x1.fe1c26p-2, INEXACT)
T(RN,   -0x1.77f8677c54a52p+0,   -0x1.f22d37609a546p-1,   0x1.f9eca6p-2, INEXACT)
T(RN,   -0x1.77c4c606d4dc3p+0,   -0x1.f20c7e9351bffp-1,  -0x1.f68b4ap-2, INEXACT)
T(RN,   -0x1.77912ba870a4ep+0,   -0x1.f1ebc420d9e3fp-1,    0x1.fe35ap-2, INEXACT)
T(RN,   -0x1.775d98602ebf2p+0,   -0x1.f1cb0809a68cdp-1,  -0x1.fd124ep-2, INEXACT)
T(RN,   -0x1.772a0c2d16066p+0,   -0x1.f1aa4a4e2ba39p-1,   0x1.fe09fcp-2, INEXACT)
T(RN,   -0x1.76f6870e2d84ep+0,   -0x1.f1898aeedd3afp-1,   0x1.fa0da8p-2, INEXACT)
T(RN,   -0x1.76c309027c012p+0,   -0x1.f168c9ec2f45ep-1,   0x1.f60f82p-2, INEXACT)
T(RN,   -0x1.768f920909bb9p+0,   -0x1.f148074696b37p-1,   -0x1.f8797p-2, INEXACT)
T(RN,   -0x1.765c2220dd253p+0,   -0x1.f12742fe87572p-1,  -0x1.fd4d38p-2, INEXACT)
T(RN,   -0x1.7628b948fe1eap+0,   -0x1.f1067d1475fa1p-1,  -0x1.fdbacep-2, INEXACT)
T(RN,   -0x1.75f55780744ffp+0,   -0x1.f0e5b588d74cdp-1,  -0x1.fde9b8p-2, INEXACT)
T(RN,   -0x1.75c1fcc647846p+0,   -0x1.f0c4ec5c2021cp-1,   0x1.fd53eep-2, INEXACT)
T(RN,   -0x1.758ea9197fad2p+0,   -0x1.f0a4218ec56f2p-1,  -0x1.f95dcep-2, INEXACT)
T(RN,   -0x1.755b5c7924e18p+0,   -0x1.f08355213c4e8p-1,    0x1.f934dp-2, INEXACT)
T(RN,   -0x1.752816e43f3f5p+0,   -0x1.f0628713f9e97p-1,  -0x1.f5da2cp-2, INEXACT)
T(RN,   -0x1.74f4d859d750fp+0,   -0x1.f041b76773b9dp-1,   0x1.ff75cap-2, INEXACT)
T(RN,   -0x1.74c1a0d8f5619p+0,   -0x1.f020e61c1f1cdp-1,   0x1.fb02a8p-2, INEXACT)
T(RN,   -0x1.748e7060a2162p+0,   -0x1.f000133271b42p-1,    0x1.f5e3cp-2, INEXACT)
T(RN,   -0x1.745b46efe62b5p+0,   -0x1.efdf3eaae13c1p-1,  -0x1.fe17cep-2, INEXACT)
T(RN,   -0x1.74282485ca83dp+0,   -0x1.efbe6885e3946p-1,  -0x1.f87926p-2, INEXACT)
T(RN,   -0x1.73f5092157d7ap+0,   -0x1.ef9d90c3ee8ccp-1,  -0x1.f5c568p-2, INEXACT)
T(RN,   -0x1.73c1f4c1980f6p+0,   -0x1.ef7cb76578c3dp-1,  -0x1.f9638ep-2, INEXACT)
T(RN,   -0x1.738ee76593b7fp+0,   -0x1.ef5bdc6af803dp-1,  -0x1.fcf20ap-2, INEXACT)
T(RN,   -0x1.735be10c54662p+0,   -0x1.ef3affd4e2cbdp-1,  -0x1.f8ef74p-2, INEXACT)
T(RN,   -0x1.7328e1b4e3a86p+0,   -0x1.ef1a21a3afa1fp-1,  -0x1.f69beap-2, INEXACT)
T(RN,   -0x1.72f5e95e4b173p+0,   -0x1.eef941d7d51dep-1,   -0x1.f71acp-2, INEXACT)
T(RN,   -0x1.72c2f80794b54p+0,   -0x1.eed86071ca26ep-1,  -0x1.f69852p-2, INEXACT)
T(RN,   -0x1.72900dafca367p+0,   -0x1.eeb77d72057c5p-1,   0x1.f6ba86p-2, INEXACT)
T(RN,   -0x1.725d2a55f5bd8p+0,   -0x1.ee9698d8fe305p-1,   0x1.f88b36p-2, INEXACT)
T(RN,   -0x1.722a4df92126bp+0,   -0x1.ee75b2a72b324p-1,  -0x1.f5c7f8p-2, INEXACT)
T(RN,   -0x1.71f7789857cabp+0,   -0x1.ee54cadd04728p-1,  -0x1.fae788p-2, INEXACT)
T(RN,   -0x1.71c4aa32a310bp+0,   -0x1.ee33e17b00aaap-1,  -0x1.fef4fap-2, INEXACT)
T(RN,   -0x1.7191e2c70ded7p+0,   -0x1.ee12f68197a05p-1,  -0x1.f8e458p-2, INEXACT)
T(RN,   -0x1.715f2254a3158p+0,   -0x1.edf209f140fa9p-1,   0x1.f8bbe6p-2, INEXACT)
T(RN,   -0x1.712c68da6d5f5p+0,   -0x1.edd11bca74817p-1,  -0x1.ff4666p-2, INEXACT)
T(RN,   -0x1.70f9b65777d0cp+0,   -0x1.edb02c0daa264p-1,  -0x1.f6011ep-2, INEXACT)
T(RN,   -0x1.70c70acacd79dp+0,   -0x1.ed8f3abb59ebfp-1,  -0x1.f5dbf8p-2, INEXACT)
T(RN,   -0x1.7094663379a13p+0,   -0x1.ed6e47d3fc03ap-1,   0x1.fb6b42p-2, INEXACT)
T(RN,   -0x1.7061c89087a36p+0,   -0x1.ed4d535808b79p-1,   0x1.f72e42p-2, INEXACT)
T(RN,   -0x1.702f31e103012p+0,   -0x1.ed2c5d47f8742p-1,   0x1.fb002cp-2, INEXACT)
T(RN,   -0x1.6ffca223f764dp+0,   -0x1.ed0b65a443cb9p-1,    0x1.fa385p-2, INEXACT)
T(RN,   -0x1.6fca195870897p+0,   -0x1.ecea6c6d6365ap-1,   0x1.feae86p-2, INEXACT)
T(RN,   -0x1.6f97977d7a5c3p+0,   -0x1.ecc971a3d0157p-1,   0x1.f70784p-2, INEXACT)
T(RN,   -0x1.6f651c9220dfdp+0,   -0x1.eca8754802c6dp-1,    0x1.f7416p-2, INEXACT)
T(RN,   -0x1.6f32a895703dbp+0,   -0x1.ec87775a74897p-1,    -0x1.fc98p-2, INEXACT)
T(RN,   -0x1.6f003b8674c97p+0,   -0x1.ec6677db9e92fp-1,    0x1.f8177p-2, INEXACT)
T(RN,   -0x1.6ecdd5643ae7fp+0,   -0x1.ec4576cbfa2f2p-1,   0x1.f90c8cp-2, INEXACT)
T(RN,   -0x1.6e9b762dcf25bp+0,   -0x1.ec24742c00ce1p-1,   -0x1.fcef3p-2, INEXACT)
T(RN,    -0x1.6e691de23e33p+0,   -0x1.ec036ffc2c01ap-1,  -0x1.f8f9a4p-2, INEXACT)
T(RN,   -0x1.6e36cc8094e34p+0,   -0x1.ebe26a3cf57d5p-1,  -0x1.ffa9ecp-2, INEXACT)
T(RN,   -0x1.6e048207e0259p+0,   -0x1.ebc162eed7112p-1,   0x1.f8a69ep-2, INEXACT)
T(RN,   -0x1.6dd23e772d0b2p+0,   -0x1.eba05a124aae1p-1,  -0x1.fb651cp-2, INEXACT)
T(RN,   -0x1.6da001cd88cffp+0,   -0x1.eb7f4fa7ca6b4p-1,  -0x1.f739a2p-2, INEXACT)
T(RN,   -0x1.6d6dcc0a00c4ep+0,   -0x1.eb5e43afd0781p-1,   0x1.f8c41cp-2, INEXACT)
T(RN,   -0x1.6d3b9d2ba264dp+0,   -0x1.eb3d362ad729fp-1,   0x1.f85182p-2, INEXACT)
T(RN,   -0x1.6d0975317b457p+0,   -0x1.eb1c271958f21p-1,   0x1.fc2cdep-2, INEXACT)
T(RN,   -0x1.6cd7541a991eep+0,   -0x1.eafb167bd062bp-1,  -0x1.ff8f3cp-2, INEXACT)
T(RN,   -0x1.6ca539e609cd8p+0,   -0x1.eada0452b82ffp-1,   0x1.ff7fa4p-2, INEXACT)
T(RN,   -0x1.6c732692db50dp+0,   -0x1.eab8f09e8b2fcp-1,  -0x1.fd2a68p-2, INEXACT)
T(RN,   -0x1.6c411a201bc67p+0,   -0x1.ea97db5fc455bp-1,  -0x1.ff0158p-2, INEXACT)
T(RN,   -0x1.6c0f148cd965ap+0,   -0x1.ea76c496deb09p-1,    0x1.fe42bp-2, INEXACT)
T(RN,   -0x1.6bdd15d822994p+0,   -0x1.ea55ac44557b9p-1,   0x1.f9e0b2p-2, INEXACT)
T(RN,   -0x1.6bab1e0105dd7p+0,   -0x1.ea349268a4074p-1,  -0x1.ff45cep-2, INEXACT)
T(RN,   -0x1.6b792d0691d58p+0,    -0x1.ea13770445c8p-1,   0x1.fc567cp-2, INEXACT)
T(RN,   -0x1.6b4742e7d543cp+0,   -0x1.e9f25a17b6513p-1,  -0x1.f8cd1cp-2, INEXACT)
T(RN,    -0x1.6b155fa3df0dp+0,   -0x1.e9d13ba37156ap-1,  -0x1.fddc96p-2, INEXACT)
T(RN,   -0x1.6ae38339be30bp+0,   -0x1.e9b01ba7f2a7fp-1,   0x1.fb8dd4p-2, INEXACT)
T(RN,   -0x1.6ab1ada881dffp+0,   -0x1.e98efa25b63fdp-1,    0x1.f6d67p-2, INEXACT)
T(RN,   -0x1.6a7fdeef396f1p+0,   -0x1.e96dd71d383a1p-1,   0x1.f7e694p-2, INEXACT)
T(RN,   -0x1.6a4e170cf429cp+0,   -0x1.e94cb28ef4b6bp-1,   0x1.f67abap-2, INEXACT)
T(RN,   -0x1.6a1c5600c18e5p+0,   -0x1.e92b8c7b68013p-1,   0x1.f60528p-2, INEXACT)
T(RN,   -0x1.69ea9bc9b17bcp+0,   -0x1.e90a64e30eaf6p-1,  -0x1.f649c8p-2, INEXACT)
T(RN,   -0x1.69b8e866d3affp+0,   -0x1.e8e93bc6654aap-1,  -0x1.f6d598p-2, INEXACT)
T(RN,   -0x1.69873bd73813ep+0,    -0x1.e8c81125e883p-1,  -0x1.f831fap-2, INEXACT)
T(RN,   -0x1.69559619ee9b2p+0,   -0x1.e8a6e50215194p-1,  -0x1.f6de06p-2, INEXACT)
T(RN,   -0x1.6923f72e0791cp+0,   -0x1.e885b75b6812fp-1,  -0x1.f8f03ap-2, INEXACT)
T(RN,   -0x1.68f25f129332ap+0,   -0x1.e86488325e73dp-1,  -0x1.fcf9cap-2, INEXACT)
T(RN,   -0x1.68c0cdc6a1ffdp+0,   -0x1.e84357877578ep-1,  -0x1.fc4d56p-2, INEXACT)
T(RN,   -0x1.688f4349447f5p+0,   -0x1.e822255b2a6b5p-1,   0x1.ff35b6p-2, INEXACT)
T(RN,   -0x1.685dbf998b6e4p+0,   -0x1.e800f1adfac31p-1,  -0x1.ffccd8p-2, INEXACT)
T(RN,   -0x1.682c42b687985p+0,    -0x1.e7dfbc80640bp-1,  -0x1.fdc218p-2, INEXACT)
T(RN,   -0x1.67facc9f49f7fp+0,   -0x1.e7be85d2e3f71p-1,   0x1.fffa7cp-2, INEXACT)
T(RN,   -0x1.67c95d52e39cap+0,   -0x1.e79d4da5f852fp-1,   0x1.ff2c2ep-2, INEXACT)
T(RN,   -0x1.6797f4d065bfap+0,   -0x1.e77c13fa1f0fap-1,   0x1.f8c31cp-2, INEXACT)
T(RN,   -0x1.67669316e1b69p+0,   -0x1.e75ad8cfd63acp-1,  -0x1.fbce06p-2, INEXACT)
T(RN,   -0x1.6735382568f95p+0,   -0x1.e7399c279c022p-1,   0x1.ffdc64p-2, INEXACT)
T(RN,   -0x1.6703e3fb0d21cp+0,   -0x1.e7185e01eeb44p-1,  -0x1.f5f404p-2, INEXACT)
T(RN,   -0x1.66d29696dfe72p+0,   -0x1.e6f71e5f4cbc5p-1,  -0x1.f7727ep-2, INEXACT)
T(RN,   -0x1.66a14ff7f323fp+0,   -0x1.e6d5dd4034a6dp-1,   -0x1.ff817p-2, INEXACT)
T(RN,   -0x1.6670101d58cfcp+0,    -0x1.e6b49aa5251dp-1,   0x1.f5f16cp-2, INEXACT)
T(RN,    -0x1.663ed706230dp+0,   -0x1.e693568e9cee9p-1,  -0x1.fd45dap-2, INEXACT)
T(RN,   -0x1.660da4b164149p+0,   -0x1.e67210fd1b032p-1,   0x1.fdb0a4p-2, INEXACT)
T(RN,   -0x1.65dc791e2e3e8p+0,   -0x1.e650c9f11e611p-1,  -0x1.f6347ep-2, INEXACT)
T(RN,   -0x1.65ab544b9408dp+0,   -0x1.e62f816b26312p-1,  -0x1.f6e33ap-2, INEXACT)
T(RN,   -0x1.657a3638a8167p+0,   -0x1.e60e376bb1be7p-1,  -0x1.f9a002p-2, INEXACT)
T(RN,   -0x1.65491ee47d1f8p+0,   -0x1.e5ecebf3406b7p-1,   0x1.f62464p-2, INEXACT)
T(RN,    -0x1.65180e4e260dp+0,    -0x1.e5cb9f0251c5p-1,  -0x1.f9260ep-2, INEXACT)
T(RN,   -0x1.64e70474b5d5ap+0,   -0x1.e5aa50996569fp-1,  -0x1.f67658p-2, INEXACT)
T(RN,   -0x1.64b601573f9aap+0,   -0x1.e58900b8fb1f2p-1,   0x1.f97b5cp-2, INEXACT)
T(RN,   -0x1.648504f4d69b2p+0,   -0x1.e567af6192c6ep-1,  -0x1.fd4ca4p-2, INEXACT)
T(RN,   -0x1.64540f4c8e3c8p+0,   -0x1.e5465c93ac661p-1,  -0x1.ffe44ep-2, INEXACT)
T(RN,   -0x1.6423205d79ffcp+0,   -0x1.e525084fc81d7p-1,   0x1.feb08cp-2, INEXACT)
T(RN,   -0x1.63f23826ad691p+0,   -0x1.e503b2966618fp-1,  -0x1.f5dc0ap-2, INEXACT)
T(RN,    -0x1.63c156a73c8dp+0,   -0x1.e4e25b6806ef6p-1,  -0x1.f8db18p-2, INEXACT)
T(RN,   -0x1.63907bde3afc4p+0,   -0x1.e4c102c52ae6ap-1,   0x1.f9c882p-2, INEXACT)
T(RN,   -0x1.635fa7cabcdafp+0,    -0x1.e49fa8ae52b2p-1,    0x1.f7d42p-2, INEXACT)
T(RN,   -0x1.632eda6bd6452p+0,   -0x1.e47e4d23ff07ep-1,    0x1.fd921p-2, INEXACT)
T(RN,   -0x1.62fe13c09b6d2p+0,   -0x1.e45cf026b0b6ap-1,  -0x1.f64992p-2, INEXACT)
T(RN,   -0x1.62cd53c820ffbp+0,   -0x1.e43b91b6e8e8dp-1,   0x1.f74912p-2, INEXACT)
T(RN,   -0x1.629c9a817b336p+0,   -0x1.e41a31d528812p-1,    0x1.fc6f6p-2, INEXACT)
T(RN,   -0x1.626be7ebbeaaep+0,   -0x1.e3f8d081f0b49p-1,    0x1.f61c5p-2, INEXACT)
T(RN,   -0x1.623b3c060089dp+0,   -0x1.e3d76dbdc3194p-1,  -0x1.fb8504p-2, INEXACT)
T(RN,   -0x1.620a96cf5558ap+0,   -0x1.e3b6098920e34p-1,   -0x1.f9dbep-2, INEXACT)
T(RN,   -0x1.61d9f846d2328p+0,   -0x1.e394a3e48bb3ep-1,   0x1.f75274p-2, INEXACT)
T(RN,   -0x1.61a9606b8c50cp+0,   -0x1.e3733cd08549dp-1,  -0x1.f7f0bap-2, INEXACT)
T(RN,   -0x1.6178cf3c98ee5p+0,   -0x1.e351d44d8f6cfp-1,  -0x1.faeea8p-2, INEXACT)
T(RN,   -0x1.614844b90d726p+0,   -0x1.e3306a5c2c0c2p-1,   0x1.f99358p-2, INEXACT)
T(RN,   -0x1.6117c0dfff676p+0,    -0x1.e30efefcdd37p-1,   0x1.fdc3f8p-2, INEXACT)
T(RN,   -0x1.60e743b084715p+0,    -0x1.e2ed92302517p-1,   -0x1.ff512p-2, INEXACT)
T(RN,   -0x1.60b6cd29b2592p+0,   -0x1.e2cc23f685f72p-1,   0x1.f6bd94p-2, INEXACT)
T(RN,   -0x1.60865d4a9f053p+0,   -0x1.e2aab450823f5p-1,    0x1.f8548p-2, INEXACT)
T(RN,   -0x1.6055f412607f5p+0,    -0x1.e289433e9c78p-1,  -0x1.f9469ap-2, INEXACT)
T(RN,   -0x1.602591800cef4p+0,   -0x1.e267d0c157465p-1,   0x1.fa0582p-2, INEXACT)
T(RN,   -0x1.5ff53592ba93bp+0,   -0x1.e2465cd93567cp-1,   0x1.f9576ep-2, INEXACT)
T(RN,   -0x1.5fc4e0497fde3p+0,   -0x1.e224e786b9c4fp-1,  -0x1.f5f992p-2, INEXACT)
T(RN,   -0x1.5f9491a3736d6p+0,   -0x1.e20370ca676dbp-1,  -0x1.fd87e2p-2, INEXACT)
T(RN,   -0x1.5f64499fabc91p+0,   -0x1.e1e1f8a4c16a3p-1,   0x1.fcea98p-2, INEXACT)
T(RN,   -0x1.5f34083d3fbebp+0,    -0x1.e1c07f164afbp-1,   0x1.fbea18p-2, INEXACT)
T(RN,   -0x1.5f03cd7b463b8p+0,   -0x1.e19f041f877eap-1,  -0x1.f6633ep-2, INEXACT)
T(RN,   -0x1.5ed39958d645cp+0,   -0x1.e17d87c0fa6cbp-1,   0x1.fe7324p-2, INEXACT)
T(RN,   -0x1.5ea36bd507091p+0,   -0x1.e15c09fb275f1p-1,   0x1.f5e574p-2, INEXACT)
T(RN,   -0x1.5e7344eeefceap+0,   -0x1.e13a8ace920bdp-1,   0x1.fb32aap-2, INEXACT)
T(RN,   -0x1.5e4324a5a7f9dp+0,   -0x1.e1190a3bbe433p-1,  -0x1.fafbf2p-2, INEXACT)
T(RN,   -0x1.5e130af847172p+0,   -0x1.e0f788432ff9bp-1,  -0x1.f797e8p-2, INEXACT)
T(RN,   -0x1.5de2f7e5e4cc8p+0,   -0x1.e0d604e56b3d8p-1,  -0x1.f90bb4p-2, INEXACT)
T(RN,   -0x1.5db2eb6d98e3cp+0,   -0x1.e0b48022f43d7p-1,   0x1.f68528p-2, INEXACT)
T(RN,   -0x1.5d82e58e7b427p+0,   -0x1.e092f9fc4f439p-1,   0x1.ff6bb2p-2, INEXACT)
T(RN,   -0x1.5d52e647a3f1bp+0,   -0x1.e071727200ba4p-1,   0x1.ff1032p-2, INEXACT)
T(RN,   -0x1.5d22ed982b171p+0,   -0x1.e04fe9848d277p-1,   0x1.f7c234p-2, INEXACT)
T(RN,   -0x1.5cf2fb7f28ed3p+0,   -0x1.e02e5f3479276p-1,   0x1.f7b3d4p-2, INEXACT)
T(RN,   -0x1.5cc30ffbb60bcp+0,   -0x1.e00cd382499f1p-1,  -0x1.f7130ap-2, INEXACT)
T(RN,   -0x1.5c932b0cead37p+0,   -0x1.dfeb466e83546p-1,  -0x1.fd5402p-2, INEXACT)
T(RN,   -0x1.5c634cb1dfe6bp+0,   -0x1.dfc9b7f9ab42ep-1,   -0x1.ff2ebp-2, INEXACT)
T(RN,   -0x1.5c3374e9ae17bp+0,    -0x1.dfa82824468fp-1,  -0x1.ff4418p-2, INEXACT)
T(RN,   -0x1.5c03a3b36e4aap+0,   -0x1.df8696eeda714p-1,    -0x1.f6fap-2, INEXACT)
T(RN,   -0x1.5bd3d90e39862p+0,   -0x1.df650459ec41ap-1,   0x1.fb0f66p-2, INEXACT)
T(RN,   -0x1.5ba414f928efdp+0,   -0x1.df43706601757p-1,   0x1.fd3714p-2, INEXACT)
T(RN,    -0x1.5b745773555fp+0,    -0x1.df21db139f52p-1,   0x1.f5cb64p-2, INEXACT)
T(RN,   -0x1.5b44a07bd989bp+0,   -0x1.df0044634c74ep-1,  -0x1.f98c3ep-2, INEXACT)
T(RN,   -0x1.5b14f011cda1bp+0,   -0x1.dedeac558dbd6p-1,   -0x1.f685dp-2, INEXACT)
T(RN,   -0x1.5ae546344bbdbp+0,   -0x1.debd12eae9677p-1,  -0x1.fb914ap-2, INEXACT)
T(RN,   -0x1.5ab5a2e26da12p+0,   -0x1.de9b7823e57b9p-1,  -0x1.fc0436p-2, INEXACT)
T(RN,   -0x1.5a86061b4d281p+0,   -0x1.de79dc01081acp-1,  -0x1.f6a7fap-2, INEXACT)
T(RN,    -0x1.5a566fde046ap+0,   -0x1.de583e82d7971p-1,  -0x1.ff964ep-2, INEXACT)
T(RN,   -0x1.5a26e029ad7c9p+0,   -0x1.de369fa9da484p-1,   0x1.fc482ap-2, INEXACT)
T(RN,   -0x1.59f756fd62a23p+0,   -0x1.de14ff7696acfp-1,   0x1.fde468p-2, INEXACT)
T(RN,   -0x1.59c7d4583e3edp+0,   -0x1.ddf35de993625p-1,  -0x1.ff7344p-2, INEXACT)
T(RN,   -0x1.599858395ad35p+0,   -0x1.ddd1bb035720ep-1,  -0x1.fdb9f2p-2, INEXACT)
T(RN,   -0x1.5968e29fd3029p+0,   -0x1.ddb016c468c04p-1,   0x1.fccd78p-2, INEXACT)
T(RN,    -0x1.5939738ac18cp+0,   -0x1.dd8e712d4f335p-1,    0x1.fa96fp-2, INEXACT)
T(RN,   -0x1.590a0af9414fap+0,   -0x1.dd6cca3e918acp-1,  -0x1.f85516p-2, INEXACT)
T(RN,   -0x1.58daa8ea6d4e6p+0,   -0x1.dd4b21f8b6f55p-1,  -0x1.f7325ep-2, INEXACT)
T(RN,   -0x1.58ab4d5d60a8cp+0,   -0x1.dd29785c46bf2p-1,  -0x1.ff75a2p-2, INEXACT)
T(RN,   -0x1.587bf851369aap+0,   -0x1.dd07cd69c84e6p-1,   0x1.fcb728p-2, INEXACT)
T(RN,   -0x1.584ca9c50a817p+0,   -0x1.dce62121c3281p-1,  -0x1.faee4ep-2, INEXACT)
T(RN,   -0x1.581d61b7f7ddep+0,   -0x1.dcc47384bef08p-1,   0x1.fe6026p-2, INEXACT)
T(RN,   -0x1.57ee20291a45ep+0,   -0x1.dca2c49343623p-1,   0x1.fcc986p-2, INEXACT)
T(RN,   -0x1.57bee5178d7eep+0,   -0x1.dc81144dd85fdp-1,   0x1.f882c2p-2, INEXACT)
T(RN,   -0x1.578fb0826d526p+0,   -0x1.dc5f62b505d59p-1,   0x1.f6be0cp-2, INEXACT)
T(RN,   -0x1.57608268d5df1p+0,    -0x1.dc3dafc953f3p-1,  -0x1.f73a16p-2, INEXACT)
T(RN,   -0x1.57315ac9e31e3p+0,   -0x1.dc1bfb8b4ad34p-1,  -0x1.f7bcc4p-2, INEXACT)
T(RN,   -0x1.570239a4b15bbp+0,   -0x1.dbfa45fb72d32p-1,  -0x1.f978eep-2, INEXACT)
T(RN,   -0x1.56d31ef85ce13p+0,   -0x1.dbd88f1a54541p-1,   0x1.fe94bap-2, INEXACT)
T(RN,   -0x1.56a40ac4022f6p+0,   -0x1.dbb6d6e877e57p-1,   0x1.ff9d2ap-2, INEXACT)
T(RN,   -0x1.5674fd06bdd86p+0,   -0x1.db951d6666295p-1,  -0x1.fe7df6p-2, INEXACT)
T(RN,   -0x1.5645f5bfac9acp+0,   -0x1.db736294a7e7cp-1,  -0x1.f64076p-2, INEXACT)
T(RN,   -0x1.5616f4edeb377p+0,   -0x1.db51a673c5f0fp-1,  -0x1.f5decap-2, INEXACT)
T(RN,   -0x1.55e7fa9096cd5p+0,   -0x1.db2fe904495e9p-1,    0x1.ffb21p-2, INEXACT)
T(RN,   -0x1.55b906a6cc467p+0,   -0x1.db0e2a46bb2adp-1,  -0x1.fb77f8p-2, INEXACT)
T(RN,   -0x1.558a192fa8ebap+0,   -0x1.daec6a3ba499ap-1,   0x1.fa1d1cp-2, INEXACT)
T(RN,   -0x1.555b322a4a06fp+0,   -0x1.dacaa8e38ef66p-1,    0x1.ff186p-2, INEXACT)
T(RN,   -0x1.552c5195cd0c8p+0,   -0x1.daa8e63f03b08p-1,   0x1.fbf372p-2, INEXACT)
T(RN,   -0x1.54fd77714f8bfp+0,   -0x1.da87224e8c515p-1,   0x1.f71ca2p-2, INEXACT)
T(RN,   -0x1.54cea3bbef34cp+0,   -0x1.da655d12b27f2p-1,  -0x1.fe7b88p-2, INEXACT)
T(RN,   -0x1.549fd674c9d52p+0,   -0x1.da43968bfffc1p-1,   0x1.f6928ap-2, INEXACT)
T(RN,   -0x1.54710f9afd638p+0,   -0x1.da21cebafeadap-1,  -0x1.f94f16p-2, INEXACT)
T(RN,   -0x1.54424f2da7e06p+0,   -0x1.da0005a03885fp-1,   0x1.feeb6ap-2, INEXACT)
T(RN,   -0x1.5413952be77c3p+0,     -0x1.d9de3b3c37ap-1,   0x1.f6e506p-2, INEXACT)
T(RN,   -0x1.53e4e194da834p+0,   -0x1.d9bc6f8f86308p-1,   0x1.fb1346p-2, INEXACT)
T(RN,   -0x1.53b634679f60dp+0,   -0x1.d99aa29aae885p-1,   0x1.ffc858p-2, INEXACT)
T(RN,   -0x1.53878da354991p+0,   -0x1.d978d45e3b101p-1,   0x1.f8fbcap-2, INEXACT)
T(RN,   -0x1.5358ed4718d75p+0,   -0x1.d95704dab6526p-1,   0x1.ffd64ep-2, INEXACT)
T(RN,   -0x1.532a53520ae26p+0,   -0x1.d9353410aaf38p-1,   -0x1.fd25fp-2, INEXACT)
T(RN,   -0x1.52fbbfc3499a6p+0,   -0x1.d9136200a3af6p-1,   0x1.fa127cp-2, INEXACT)
T(RN,   -0x1.52cd3299f407fp+0,   -0x1.d8f18eab2b654p-1,   0x1.f8c8e8p-2, INEXACT)
T(RN,   -0x1.529eabd5294d1p+0,   -0x1.d8cfba10cd0c2p-1,   -0x1.f64dbp-2, INEXACT)
T(RN,   -0x1.52702b7408badp+0,   -0x1.d8ade43213c29p-1,  -0x1.fbedfap-2, INEXACT)
T(RN,   -0x1.5241b175b1a5ap+0,   -0x1.d88c0d0f8aaf3p-1,   -0x1.f8235p-2, INEXACT)
T(RN,   -0x1.52133dd943858p+0,   -0x1.d86a34a9bd17cp-1,   0x1.feb28cp-2, INEXACT)
T(RN,   -0x1.51e4d09dde04fp+0,   -0x1.d8485b01366c6p-1,  -0x1.f63f3cp-2, INEXACT)
T(RN,   -0x1.51b669c2a0dc8p+0,   -0x1.d8268016822c6p-1,  -0x1.fbfa68p-2, INEXACT)
T(RN,   -0x1.51880946abeaep+0,   -0x1.d804a3ea2bf85p-1,    0x1.fdbc7p-2, INEXACT)
T(RN,   -0x1.5159af291f27ap+0,   -0x1.d7e2c67cbf885p-1,   -0x1.f6f9fp-2, INEXACT)
T(RN,   -0x1.512b5b691ab48p+0,   -0x1.d7c0e7cec8b82p-1,  -0x1.fccf3ap-2, INEXACT)
T(RN,   -0x1.50fd0e05bec7cp+0,   -0x1.d79f07e0d377dp-1,   0x1.fb1198p-2, INEXACT)
T(RN,   -0x1.50cec6fe2bb24p+0,   -0x1.d77d26b36bd03p-1,  -0x1.fb38aap-2, INEXACT)
T(RN,   -0x1.50a0865181f38p+0,   -0x1.d75b44471df0dp-1,   0x1.fc7ecap-2, INEXACT)
T(RN,   -0x1.50724bfee16c9p+0,   -0x1.d739609c759a9p-1,  -0x1.f5cd22p-2, INEXACT)
T(RN,   -0x1.504418056cdd6p+0,   -0x1.d7177bb400adcp-1,  -0x1.ff50cep-2, INEXACT)
T(RN,   -0x1.5015ea64430acp+0,   -0x1.d6f5958e4a248p-1,   -0x1.fefdfp-2, INEXACT)
T(RN,   -0x1.4fe7c31a859adp+0,   -0x1.d6d3ae2bdf1a8p-1,  -0x1.fba51ap-2, INEXACT)
T(RN,   -0x1.4fb9a2275596ep+0,   -0x1.d6b1c58d4c3d5p-1,  -0x1.fb0b78p-2, INEXACT)
T(RN,   -0x1.4f8b8789d42f2p+0,   -0x1.d68fdbb31e5bep-1,  -0x1.f6b6e4p-2, INEXACT)
T(RN,    -0x1.4f5d734122afp+0,   -0x1.d66df09de25dep-1,   0x1.f6a728p-2, INEXACT)
T(RN,   -0x1.4f2f654c61deap+0,   -0x1.d64c044e24cf2p-1,   0x1.f5d268p-2, INEXACT)
T(RN,   -0x1.4f015daab53c1p+0,   -0x1.d62a16c4743f4p-1,   0x1.f8ef02p-2, INEXACT)
T(RN,   -0x1.4ed35c5b3c75dp+0,   -0x1.d60828015c73cp-1,   0x1.f8a23ep-2, INEXACT)
T(RN,   -0x1.4ea5615d19fdap+0,   -0x1.d5e638056b3ffp-1,  -0x1.ffe568p-2, INEXACT)
T(RN,   -0x1.4e776caf6fb98p+0,   -0x1.d5c446d12e148p-1,    0x1.fad06p-2, INEXACT)
T(RN,   -0x1.4e497e515fb1bp+0,   -0x1.d5a2546532806p-1,  -0x1.fe799cp-2, INEXACT)
T(RN,   -0x1.4e1b96420bfeap+0,   -0x1.d58060c206228p-1,  -0x1.fea418p-2, INEXACT)
T(RN,   -0x1.4dedb48096e74p+0,   -0x1.d55e6be836c0dp-1,   0x1.fd64b6p-2, INEXACT)
T(RN,   -0x1.4dbfd90c22caap+0,   -0x1.d53c75d85237bp-1,  -0x1.f625f8p-2, INEXACT)
T(RN,   -0x1.4d9203e3d229fp+0,   -0x1.d51a7e92e680cp-1,  -0x1.f9c1c2p-2, INEXACT)
T(RN,   -0x1.4d643506c79c1p+0,   -0x1.d4f8861881aa3p-1,   0x1.fbed9ap-2, INEXACT)
T(RN,   -0x1.4d366c7425d9cp+0,   -0x1.d4d68c69b1dfcp-1,  -0x1.fbd16ep-2, INEXACT)
T(RN,   -0x1.4d08aa2b0fc69p+0,   -0x1.d4b491870570dp-1,  -0x1.fd1852p-2, INEXACT)
T(RN,   -0x1.4cdaee2aa84fcp+0,   -0x1.d49295710ab86p-1,  -0x1.f8cca2p-2, INEXACT)
T(RN,   -0x1.4cad387212905p+0,   -0x1.d470982850378p-1,   -0x1.fa8c4p-2, INEXACT)
T(RN,   -0x1.4c7f890071b9dp+0,   -0x1.d44e99ad64841p-1,   0x1.f5f57ap-2, INEXACT)
T(RN,   -0x1.4c51dfd4e91ffp+0,   -0x1.d42c9a00d651ap-1,  -0x1.fb82c8p-2, INEXACT)
T(RN,   -0x1.4c243cee9c335p+0,   -0x1.d40a9923346cep-1,   0x1.f6839ep-2, INEXACT)
T(RN,   -0x1.4bf6a04cae825p+0,   -0x1.d3e897150dbd1p-1,   0x1.f8c63ep-2, INEXACT)
T(RN,   -0x1.4bc909ee43bc7p+0,   -0x1.d3c693d6f145dp-1,   0x1.faf81cp-2, INEXACT)
T(RN,   -0x1.4b9b79d27faa5p+0,   -0x1.d3a48f696e217p-1,    0x1.fc263p-2, INEXACT)
T(RN,   -0x1.4b6deff8863c2p+0,   -0x1.d38289cd138bap-1,   0x1.febf78p-2, INEXACT)
T(RN,   -0x1.4b406c5f7b721p+0,   -0x1.d360830270cfdp-1,   0x1.fb93f8p-2, INEXACT)
T(RN,   -0x1.4b12ef0683776p+0,   -0x1.d33e7b0a155d6p-1,   0x1.f715bep-2, INEXACT)
T(RN,   -0x1.4ae577ecc28b4p+0,   -0x1.d31c71e490b65p-1,   0x1.f70c34p-2, INEXACT)
T(RN,   -0x1.4ab807115d0f9p+0,   -0x1.d2fa6792727a4p-1,   0x1.f675b2p-2, INEXACT)
T(RN,   -0x1.4a8a9c7377785p+0,    -0x1.d2d85c144a5ap-1,   0x1.f5df66p-2, INEXACT)
T(RN,   -0x1.4a5d38123697cp+0,   -0x1.d2b64f6aa850bp-1,  -0x1.f5c372p-2, INEXACT)
T(RN,   -0x1.4a2fd9ecbf123p+0,   -0x1.d29441961c3a6p-1,  -0x1.f6c53ep-2, INEXACT)
T(RN,   -0x1.4a028202359d3p+0,   -0x1.d27232973603bp-1,  -0x1.f64182p-2, INEXACT)
T(RN,   -0x1.49d53051bf5f5p+0,   -0x1.d250226e85f18p-1,  -0x1.fc56bcp-2, INEXACT)
T(RN,   -0x1.49a7e4da8156ep+0,   -0x1.d22e111c9c2ddp-1,   0x1.f60222p-2, INEXACT)
T(RN,   -0x1.497a9f9ba0bccp+0,   -0x1.d20bfea209123p-1,   0x1.ff0feap-2, INEXACT)
T(RN,   -0x1.494d609442eccp+0,   -0x1.d1e9eaff5d15ap-1,   0x1.fcd2c2p-2, INEXACT)
T(RN,   -0x1.492027c38d579p+0,   -0x1.d1c7d63528c23p-1,   0x1.fd8ec6p-2, INEXACT)
T(RN,   -0x1.48f2f528a586ap+0,   -0x1.d1a5c043fcb7ep-1,  -0x1.fc18c2p-2, INEXACT)
T(RN,   -0x1.48c5c8c2b127fp+0,   -0x1.d183a92c69b54p-1,  -0x1.f8232ep-2, INEXACT)
T(RN,   -0x1.4898a290d60d8p+0,   -0x1.d16190ef00975p-1,    0x1.f830ap-2, INEXACT)
T(RN,   -0x1.486b82923a1b5p+0,   -0x1.d13f778c524bfp-1,   -0x1.f9cafp-2, INEXACT)
T(RN,   -0x1.483e68c6035b3p+0,   -0x1.d11d5d04efe03p-1,   0x1.fbe7c2p-2, INEXACT)
T(RN,   -0x1.4811552b57f01p+0,   -0x1.d0fb41596a77ap-1,  -0x1.fdbef4p-2, INEXACT)
T(RN,   -0x1.47e447c15e1c5p+0,   -0x1.d0d9248a53501p-1,   0x1.f96a1ep-2, INEXACT)
T(RN,   -0x1.47b740873c481p+0,   -0x1.d0b706983bc75p-1,   -0x1.f66afp-2, INEXACT)
T(RN,   -0x1.478a3f7c18eccp+0,   -0x1.d094e783b54abp-1,   0x1.fadb5ap-2, INEXACT)
T(RN,   -0x1.475d449f1aa46p+0,   -0x1.d072c74d51638p-1,  -0x1.fda442p-2, INEXACT)
T(RN,   -0x1.47304fef6834ap+0,   -0x1.d050a5f5a1be9p-1,  -0x1.fa7acep-2, INEXACT)
T(RN,   -0x1.4703616c286c8p+0,   -0x1.d02e837d3812cp-1,  -0x1.f685bap-2, INEXACT)
T(RN,   -0x1.46d6791482424p+0,   -0x1.d00c5fe4a6376p-1,  -0x1.fd79e8p-2, INEXACT)
T(RN,   -0x1.46a996e79ccffp+0,   -0x1.cfea3b2c7e21ap-1,   -0x1.f90e8p-2, INEXACT)
T(RN,   -0x1.467cbae49f43fp+0,   -0x1.cfc8155551d8bp-1,   0x1.fb6ec6p-2, INEXACT)
T(RN,   -0x1.464fe50ab0eddp+0,   -0x1.cfa5ee5fb37fcp-1,   0x1.fc36cep-2, INEXACT)
T(RN,   -0x1.46231558f93bep+0,   -0x1.cf83c64c3553dp-1,  -0x1.f5f544p-2, INEXACT)
T(RN,   -0x1.45f64bce9fb87p+0,   -0x1.cf619d1b69a98p-1,   0x1.fadba6p-2, INEXACT)
T(RN,   -0x1.45c9886acc0e2p+0,   -0x1.cf3f72cde2f0ep-1,   0x1.faa848p-2, INEXACT)
T(RN,   -0x1.459ccb2ca6024p+0,   -0x1.cf1d476433b08p-1,   0x1.fa8368p-2, INEXACT)
T(RN,   -0x1.45701413557d2p+0,   -0x1.cefb1adeee8c1p-1,   0x1.f83db2p-2, INEXACT)
T(RN,   -0x1.4543631e027bap+0,   -0x1.ced8ed3ea6395p-1,  -0x1.f9c5b2p-2, INEXACT)
T(RN,   -0x1.4516b84bd51e7p+0,   -0x1.ceb6be83ed8b7p-1,  -0x1.fdf23cp-2, INEXACT)
T(RN,   -0x1.44ea139bf5a4ap+0,   -0x1.ce948eaf576f4p-1,    -0x1.f721p-2, INEXACT)
T(RN,   -0x1.44bd750d8c692p+0,   -0x1.ce725dc176e8fp-1,   0x1.f82ce2p-2, INEXACT)
T(RN,    -0x1.4490dc9fc1e9p+0,   -0x1.ce502bbadf192p-1,   0x1.fcf778p-2, INEXACT)
T(RN,   -0x1.44644a51beb16p+0,   -0x1.ce2df89c232ebp-1,  -0x1.f5ffaep-2, INEXACT)
T(RN,   -0x1.4437be22ab77fp+0,   -0x1.ce0bc465d6797p-1,   0x1.fad15cp-2, INEXACT)
T(RN,   -0x1.440b3811b113ep+0,   -0x1.cde98f188c654p-1,    0x1.fa7bbp-2, INEXACT)
T(RN,   -0x1.43deb81df86aep+0,   -0x1.cdc758b4d86adp-1,   0x1.f665a2p-2, INEXACT)
T(RN,   -0x1.43b23e46aa975p+0,   -0x1.cda5213b4e2d5p-1,  -0x1.f6526ap-2, INEXACT)
T(RN,   -0x1.4385ca8af0ba3p+0,   -0x1.cd82e8ac8156bp-1,  -0x1.fbea1ap-2, INEXACT)
T(RN,   -0x1.43595ce9f418fp+0,   -0x1.cd60af0905aedp-1,   0x1.fd5468p-2, INEXACT)
T(RN,   -0x1.432cf562de1d2p+0,   -0x1.cd3e74516f1b5p-1,  -0x1.f9dc98p-2, INEXACT)
T(RN,   -0x1.430093f4d8474p+0,   -0x1.cd1c38865194cp-1,   0x1.f927dep-2, INEXACT)
T(RN,   -0x1.42d4389f0c386p+0,   -0x1.ccf9fba8412efp-1,  -0x1.f9eeaep-2, INEXACT)
T(RN,   -0x1.42a7e360a3a7ap+0,   -0x1.ccd7bdb7d20fdp-1,   0x1.f5d37cp-2, INEXACT)
T(RN,   -0x1.427b9438c879ep+0,   -0x1.ccb57eb59882bp-1,  -0x1.fb2bc6p-2, INEXACT)
T(RN,   -0x1.424f4b26a4a5bp+0,   -0x1.cc933ea228e1ap-1,  -0x1.f95722p-2, INEXACT)
T(RN,   -0x1.422308296234fp+0,   -0x1.cc70fd7e17974p-1,   0x1.f5c42ep-2, INEXACT)
T(RN,   -0x1.41f6cb402b6bfp+0,    -0x1.cc4ebb49f93dp-1,  -0x1.f62c1cp-2, INEXACT)
T(RN,   -0x1.41ca946a2a902p+0,   -0x1.cc2c7806626e3p-1,  -0x1.f67348p-2, INEXACT)
T(RN,    -0x1.419e63a68a0ep+0,   -0x1.cc0a33b3e7e5fp-1,  -0x1.fdc7d6p-2, INEXACT)
T(RN,   -0x1.417238f474777p+0,   -0x1.cbe7ee531e7d8p-1,   0x1.f8e148p-2, INEXACT)
T(RN,   -0x1.414614531470ep+0,    -0x1.cbc5a7e49b1ep-1,  -0x1.ff856ap-2, INEXACT)
T(RN,   -0x1.4119f5c194bd2p+0,   -0x1.cba36068f2c8ep-1,   0x1.fa91b2p-2, INEXACT)
T(RN,   -0x1.40eddd3f202dcp+0,   -0x1.cb8117e0ba8c9p-1,   0x1.f5c462p-2, INEXACT)
T(RN,   -0x1.40c1cacae1f87p+0,   -0x1.cb5ece4c87c64p-1,  -0x1.f8cae6p-2, INEXACT)
T(RN,   -0x1.4095be64051a1p+0,   -0x1.cb3c83acefa7ep-1,  -0x1.fe7df6p-2, INEXACT)
T(RN,   -0x1.4069b809b4c04p+0,   -0x1.cb1a3802878a6p-1,   0x1.ff8dc6p-2, INEXACT)
T(RN,   -0x1.403db7bb1c4f7p+0,   -0x1.caf7eb4de4f28p-1,  -0x1.f7782ap-2, INEXACT)
T(RN,   -0x1.4011bd77673cap+0,   -0x1.cad59d8f9d727p-1,  -0x1.fcbb0cp-2, INEXACT)
T(RN,   -0x1.3fe5c93dc116cp+0,   -0x1.cab34ec846b1bp-1,  -0x1.fba77cp-2, INEXACT)
T(RN,   -0x1.3fb9db0d5594dp+0,   -0x1.ca90fef87677bp-1,   0x1.f6311ap-2, INEXACT)
T(RN,   -0x1.3f8df2e5507d3p+0,   -0x1.ca6eae20c298dp-1,   0x1.ff3b6cp-2, INEXACT)
T(RN,   -0x1.3f6210c4ddb77p+0,   -0x1.ca4c5c41c103ep-1,   0x1.fc38cap-2, INEXACT)
T(RN,   -0x1.3f3634ab29511p+0,   -0x1.ca2a095c07c62p-1,  -0x1.fac812p-2, INEXACT)
T(RN,   -0x1.3f0a5e975f708p+0,   -0x1.ca07b5702d00bp-1,   0x1.fec612p-2, INEXACT)
T(RN,   -0x1.3ede8e88ac4d6p+0,   -0x1.c9e5607ec6e31p-1,   0x1.fdaa9ap-2, INEXACT)
T(RN,   -0x1.3eb2c47e3c4a5p+0,   -0x1.c9c30a886bbebp-1,   0x1.f86094p-2, INEXACT)
T(RN,   -0x1.3e8700773bde9p+0,   -0x1.c9a0b38db1f5bp-1,   0x1.f61804p-2, INEXACT)
T(RN,   -0x1.3e5b4272d7a37p+0,   -0x1.c97e5b8f30055p-1,   0x1.f792bap-2, INEXACT)
T(RN,   -0x1.3e2f8a703c51ep+0,   -0x1.c95c028d7c841p-1,   -0x1.f7a79p-2, INEXACT)
T(RN,   -0x1.3e03d86e96c46p+0,   -0x1.c939a8892e22fp-1,  -0x1.f8b558p-2, INEXACT)
T(RN,   -0x1.3dd82c6d13ddfp+0,    -0x1.c9174d82db9ap-1,   0x1.ff693cp-2, INEXACT)
T(RN,   -0x1.3dac866ae0a84p+0,   -0x1.c8f4f17b1bc01p-1,   0x1.f7e49ep-2, INEXACT)
T(RN,   -0x1.3d80e6672a53fp+0,   -0x1.c8d29472858a9p-1,   0x1.fabae4p-2, INEXACT)
T(RN,   -0x1.3d554c611e247p+0,   -0x1.c8b03669affdfp-1,   0x1.fe3896p-2, INEXACT)
T(RN,   -0x1.3d29b857e97edp+0,   -0x1.c88dd76132394p-1,  -0x1.fef8e8p-2, INEXACT)
T(RN,   -0x1.3cfe2a4ab9bbap+0,   -0x1.c86b7759a3518p-1,  -0x1.f5dd5ap-2, INEXACT)
T(RN,   -0x1.3cd2a238bce64p+0,    -0x1.c84916539ae9p-1,  -0x1.fee9bap-2, INEXACT)
T(RN,   -0x1.3ca72021204c9p+0,   -0x1.c826b44fb00c4p-1,    0x1.fa452p-2, INEXACT)
T(RN,   -0x1.3c7ba40311e78p+0,   -0x1.c804514e7a4efp-1,   -0x1.facf6p-2, INEXACT)
T(RN,   -0x1.3c502dddbfb09p+0,   -0x1.c7e1ed509144ap-1,   0x1.f8a344p-2, INEXACT)
T(RN,   -0x1.3c24bdb057ac6p+0,   -0x1.c7bf88568c89fp-1,  -0x1.f9881ep-2, INEXACT)
T(RN,   -0x1.3bf9537a08174p+0,   -0x1.c79d226103e6ep-1,  -0x1.f9e12ap-2, INEXACT)
T(RN,    -0x1.3bcdef39ff0bp+0,   -0x1.c77abb708f07fp-1,    0x1.f6121p-2, INEXACT)
T(RN,   -0x1.3ba290ef6b5fep+0,   -0x1.c7585385c6307p-1,   -0x1.fdc14p-2, INEXACT)
T(RN,   -0x1.3b7738997b2c5p+0,   -0x1.c735eaa141093p-1,  -0x1.f705eep-2, INEXACT)
T(RN,   -0x1.3b4be6375d36cp+0,   -0x1.c71380c397c66p-1,  -0x1.feb972p-2, INEXACT)
T(RN,   -0x1.3b2099c840385p+0,   -0x1.c6f115ed62911p-1,  -0x1.f92f92p-2, INEXACT)
T(RN,   -0x1.3af5534b530dbp+0,    -0x1.c6ceaa1f39aep-1,  -0x1.ff9168p-2, INEXACT)
T(RN,   -0x1.3aca12bfc4addp+0,   -0x1.c6ac3d59b5762p-1,   0x1.fc8894p-2, INEXACT)
T(RN,   -0x1.3a9ed824c429bp+0,   -0x1.c689cf9d6e56ap-1,   0x1.f9acfep-2, INEXACT)
T(RN,   -0x1.3a73a37980b34p+0,    -0x1.c66760eafcd6p-1,   0x1.fa7644p-2, INEXACT)
T(RN,   -0x1.3a4874bd29985p+0,   -0x1.c644f142f9905p-1,  -0x1.ff2f86p-2, INEXACT)
T(RN,   -0x1.3a1d4beeee3c3p+0,   -0x1.c62280a5fd31bp-1,   0x1.fba4d6p-2, INEXACT)
T(RN,   -0x1.39f2290dfe2ffp+0,   -0x1.c6000f14a08a4p-1,   0x1.fa25d8p-2, INEXACT)
T(RN,   -0x1.39c70c19890eap+0,    -0x1.c5dd9c8f7c71p-1,  -0x1.fb9a56p-2, INEXACT)
T(RN,   -0x1.399bf510be96dp+0,   -0x1.c5bb291729d82p-1,   0x1.fd0592p-2, INEXACT)
T(RN,   -0x1.3970e3f2cea5cp+0,   -0x1.c598b4ac41c9bp-1,   0x1.fea2e6p-2, INEXACT)
T(RN,   -0x1.3945d8bee9283p+0,   -0x1.c5763f4f5d5aep-1,  -0x1.f65b66p-2, INEXACT)
T(RN,   -0x1.391ad3743e4f3p+0,   -0x1.c553c90115d65p-1,   -0x1.fa4d6p-2, INEXACT)
T(RN,   -0x1.38efd411fe3e7p+0,   -0x1.c53151c2047afp-1,   -0x1.f7504p-2, INEXACT)
T(RN,   -0x1.38c4da97593cep+0,   -0x1.c50ed992c2a2ap-1,  -0x1.f77ea4p-2, INEXACT)
T(RN,   -0x1.3899e7037fb7cp+0,   -0x1.c4ec6073e9c4bp-1,  -0x1.facdb8p-2, INEXACT)
T(RN,   -0x1.386ef955a23aap+0,   -0x1.c4c9e666136f7p-1,  -0x1.fcf6fep-2, INEXACT)
T(RN,   -0x1.3844118cf1641p+0,   -0x1.c4a76b69d93f1p-1,  -0x1.fe5ae2p-2, INEXACT)
T(RN,   -0x1.38192fa89df92p+0,   -0x1.c484ef7fd4ed4p-1,  -0x1.fe4838p-2, INEXACT)
T(RN,   -0x1.37ee53a7d8d31p+0,   -0x1.c46272a8a0426p-1,   0x1.fa57bcp-2, INEXACT)
T(RN,   -0x1.37c37d89d2ea4p+0,   -0x1.c43ff4e4d51e8p-1,   0x1.f779a8p-2, INEXACT)
T(RN,   -0x1.3798ad4dbd5aep+0,   -0x1.c41d76350d7cdp-1,  -0x1.ff8088p-2, INEXACT)
T(RN,   -0x1.376de2f2c9503p+0,   -0x1.c3faf699e362dp-1,   0x1.fa8ef4p-2, INEXACT)
T(RN,   -0x1.37431e78281a2p+0,   -0x1.c3d87613f0f24p-1,    0x1.fdf9cp-2, INEXACT)
T(RN,   -0x1.37185fdd0b214p+0,   -0x1.c3b5f4a3d05ecp-1,   0x1.f7336ap-2, INEXACT)
T(RN,   -0x1.36eda720a3f04p+0,   -0x1.c393724a1bf5cp-1,    0x1.f680dp-2, INEXACT)
T(RN,   -0x1.36c2f44224262p+0,   -0x1.c370ef076e135p-1,   -0x1.f71f6p-2, INEXACT)
T(RN,   -0x1.36984740bd889p+0,   -0x1.c34e6adc6130ap-1,   0x1.fcefbep-2, INEXACT)
T(RN,   -0x1.366da01ba1ee8p+0,   -0x1.c32be5c98fd34p-1,   0x1.ff4576p-2, INEXACT)
T(RN,   -0x1.3642fed2034fap+0,   -0x1.c3095fcf94991p-1,  -0x1.fac816p-2, INEXACT)
T(RN,   -0x1.3618636313c5ep+0,   -0x1.c2e6d8ef0a397p-1,   0x1.fc1334p-2, INEXACT)
T(RN,   -0x1.35edcdce057dcp+0,   -0x1.c2c451288b792p-1,  -0x1.f9d442p-2, INEXACT)
T(RN,   -0x1.35c33e120ac8fp+0,   -0x1.c2a1c87cb3386p-1,   0x1.fa1936p-2, INEXACT)
T(RN,   -0x1.3598b42e56079p+0,   -0x1.c27f3eec1c616p-1,   0x1.f83958p-2, INEXACT)
T(RN,   -0x1.356e302219c13p+0,   -0x1.c25cb47761fbep-1,  -0x1.f72526p-2, INEXACT)
T(RN,   -0x1.3543b1ec88addp+0,   -0x1.c23a291f1f348p-1,   0x1.fa9b06p-2, INEXACT)
T(RN,   -0x1.3519398cd56e7p+0,   -0x1.c2179ce3ef234p-1,  -0x1.fa7664p-2, INEXACT)
T(RN,   -0x1.34eec70232e81p+0,   -0x1.c1f50fc66d149p-1,   -0x1.fb0ddp-2, INEXACT)
T(RN,   -0x1.34c45a4bd413cp+0,   -0x1.c1d281c73462fp-1,   0x1.feef68p-2, INEXACT)
T(RN,   -0x1.3499f368ebfcap+0,   -0x1.c1aff2e6e0754p-1,  -0x1.f6e1a2p-2, INEXACT)
T(RN,   -0x1.346f9258addb6p+0,   -0x1.c18d63260cd48p-1,   0x1.fd42e2p-2, INEXACT)
T(RN,   -0x1.3445371a4cf49p+0,   -0x1.c16ad28555113p-1,   0x1.fc0f8cp-2, INEXACT)
T(RN,   -0x1.341ae1acfcb1dp+0,   -0x1.c148410554d73p-1,  -0x1.f6b9b8p-2, INEXACT)
T(RN,   -0x1.33f0920ff0915p+0,   -0x1.c125aea6a7e04p-1,   0x1.fd15eap-2, INEXACT)
T(RN,   -0x1.33c648425c312p+0,   -0x1.c1031b69e9fdcp-1,   0x1.f89a22p-2, INEXACT)
T(RN,   -0x1.339c0443734e6p+0,   -0x1.c0e0874fb7177p-1,   -0x1.f626fp-2, INEXACT)
T(RN,   -0x1.3371c61269dc9p+0,   -0x1.c0bdf258ab3e9p-1,  -0x1.f7403ap-2, INEXACT)
T(RN,   -0x1.33478dae73a47p+0,   -0x1.c09b5c85625e9p-1,   0x1.fed5c8p-2, INEXACT)
T(RN,   -0x1.331d5b16c4c76p+0,   -0x1.c078c5d678a8ap-1,  -0x1.fc7d82p-2, INEXACT)
T(RN,   -0x1.32f32e4a916e4p+0,   -0x1.c0562e4c8a50bp-1,  -0x1.fa31c2p-2, INEXACT)
T(RN,    -0x1.32c907490de1p+0,   -0x1.c03395e833a14p-1,   0x1.f99822p-2, INEXACT)
T(RN,   -0x1.329ee6116e84bp+0,   -0x1.c010fcaa10f9cp-1,  -0x1.f8a60ap-2, INEXACT)
T(RN,   -0x1.3274caa2e7d3ap+0,   -0x1.bfee6292bec77p-1,   0x1.faad2cp-2, INEXACT)
T(RN,   -0x1.324ab4fcae722p+0,   -0x1.bfcbc7a2d9975p-1,   -0x1.fe12dp-2, INEXACT)
T(RN,   -0x1.3220a51df711fp+0,   -0x1.bfa92bdafdfdap-1,   0x1.ff6742p-2, INEXACT)
T(RN,   -0x1.31f69b05f669ap+0,   -0x1.bf868f3bc88fbp-1,   -0x1.f6882p-2, INEXACT)
T(RN,   -0x1.31cc96b3e1b78p+0,   -0x1.bf63f1c5d64ecp-1,   -0x1.f81acp-2, INEXACT)
T(RN,   -0x1.31a29826edbbap+0,   -0x1.bf415379c3d0dp-1,   0x1.fa5abap-2, INEXACT)
T(RN,   -0x1.31789f5e4fb48p+0,   -0x1.bf1eb4582e10ap-1,   0x1.f6069ap-2, INEXACT)
T(RN,   -0x1.314eac593cdfap+0,   -0x1.befc1461b2046p-1,   0x1.fe7a88p-2, INEXACT)
T(RN,   -0x1.3124bf16ea982p+0,   -0x1.bed97396ecb73p-1,  -0x1.f764b8p-2, INEXACT)
T(RN,   -0x1.30fad7968e7d8p+0,   -0x1.beb6d1f87b68cp-1,     0x1.fd54p-2, INEXACT)
T(RN,   -0x1.30d0f5d75df73p+0,   -0x1.be942f86fb272p-1,  -0x1.ff4eecp-2, INEXACT)
T(RN,   -0x1.30a719d88ec78p+0,   -0x1.be718c4309474p-1,  -0x1.f7d4dcp-2, INEXACT)
T(RN,   -0x1.307d439956bf3p+0,   -0x1.be4ee82d43267p-1,  -0x1.ffcd7ep-2, INEXACT)
T(RN,   -0x1.30537318ebc7fp+0,   -0x1.be2c43464632bp-1,  -0x1.ffc52cp-2, INEXACT)
T(RN,   -0x1.3029a85683e19p+0,   -0x1.be099d8eafe86p-1,  -0x1.f90282p-2, INEXACT)
T(RN,     -0x1.2fffe351553p+0,   -0x1.bde6f7071ddddp-1,  -0x1.f600eep-2, INEXACT)
T(RN,   -0x1.2fd6240895f1ap+0,   -0x1.bdc44fb02dbb3p-1,  -0x1.fb8d08p-2, INEXACT)
T(RN,   -0x1.2fac6a7b7c7a9p+0,   -0x1.bda1a78a7d369p-1,    0x1.f619ap-2, INEXACT)
T(RN,   -0x1.2f82b6a93f427p+0,   -0x1.bd7efe96aa1f8p-1,    0x1.fac9ep-2, INEXACT)
T(RN,   -0x1.2f59089114d2dp+0,   -0x1.bd5c54d552501p-1,   0x1.fd67f4p-2, INEXACT)
T(RN,   -0x1.2f2f603233e26p+0,   -0x1.bd39aa4713c3ap-1,   0x1.fa5c46p-2, INEXACT)
T(RN,   -0x1.2f05bd8bd32edp+0,   -0x1.bd16feec8c771p-1,   0x1.f720ccp-2, INEXACT)
T(RN,   -0x1.2edc209d297fap+0,   -0x1.bcf452c65a6b1p-1,  -0x1.f66b18p-2, INEXACT)
T(RN,   -0x1.2eb289656e218p+0,   -0x1.bcd1a5d51c0abp-1,  -0x1.f76a02p-2, INEXACT)
T(RN,   -0x1.2e88f7e3d7f0bp+0,    -0x1.bcaef8196f5fp-1,  -0x1.fadcb8p-2, INEXACT)
T(RN,   -0x1.2e5f6c179e2bep+0,   -0x1.bc8c4993f2be8p-1,  -0x1.fb12c2p-2, INEXACT)
T(RN,   -0x1.2e35e5fff8254p+0,   -0x1.bc699a45448b6p-1,  -0x1.f9c638p-2, INEXACT)
T(RN,   -0x1.2e0c659c1d4d9p+0,   -0x1.bc46ea2e033cbp-1,  -0x1.f8f042p-2, INEXACT)
T(RN,   -0x1.2de2eaeb4527bp+0,   -0x1.bc24394ecd53fp-1,  -0x1.fd1604p-2, INEXACT)
T(RN,   -0x1.2db975eca75c9p+0,   -0x1.bc0187a8416dap-1,   0x1.f865e4p-2, INEXACT)
T(RN,   -0x1.2d90069f7ba8ap+0,   -0x1.bbded53afe31fp-1,   0x1.f681b2p-2, INEXACT)
T(RN,   -0x1.2d669d02f9e5ep+0,   -0x1.bbbc2207a25ccp-1,   0x1.f82876p-2, INEXACT)
T(RN,   -0x1.2d3d39165a0ecp+0,   -0x1.bb996e0eccc04p-1,   0x1.f77f56p-2, INEXACT)
T(RN,   -0x1.2d13dad8d42f9p+0,   -0x1.bb76b9511c38bp-1,   -0x1.fc4cep-2, INEXACT)
T(RN,   -0x1.2cea8249a074fp+0,   -0x1.bb5403cf2fb82p-1,   0x1.f8be9cp-2, INEXACT)
T(RN,   -0x1.2cc12f67f7311p+0,   -0x1.bb314d89a64b8p-1,  -0x1.f65946p-2, INEXACT)
T(RN,   -0x1.2c97e23310bbep+0,    -0x1.bb0e96811effp-1,   -0x1.ff74dp-2, INEXACT)
T(RN,   -0x1.2c6e9aaa259c2p+0,   -0x1.baebdeb639012p-1,   0x1.f7cd8ep-2, INEXACT)
T(RN,   -0x1.2c4558cc6e697p+0,   -0x1.bac9262993898p-1,  -0x1.f65bb4p-2, INEXACT)
T(RN,   -0x1.2c1c1c9923d24p+0,   -0x1.baa66cdbcddd4p-1,  -0x1.f8121ep-2, INEXACT)
T(RN,   -0x1.2bf2e60f7ec0dp+0,   -0x1.ba83b2cd876ecp-1,  -0x1.f6dfbep-2, INEXACT)
T(RN,   -0x1.2bc9b52eb809bp+0,   -0x1.ba60f7ff5f98ap-1,  -0x1.f6ca94p-2, INEXACT)
T(RN,   -0x1.2ba089f608bccp+0,   -0x1.ba3e3c71f5e1fp-1,   0x1.fab704p-2, INEXACT)
T(RN,   -0x1.2b776464a9fb4p+0,   -0x1.ba1b8025e9db2p-1,  -0x1.ff8bcap-2, INEXACT)
T(RN,   -0x1.2b4e4479d5099p+0,   -0x1.b9f8c31bdb2c5p-1,  -0x1.fc1668p-2, INEXACT)
T(RN,   -0x1.2b252a34c33e7p+0,   -0x1.b9d605546987cp-1,  -0x1.fdd438p-2, INEXACT)
T(RN,   -0x1.2afc1594adfc8p+0,   -0x1.b9b346d034a3ep-1,   0x1.f751a8p-2, INEXACT)
T(RN,   -0x1.2ad30698cf02cp+0,   -0x1.b990878fdc7fcp-1,  -0x1.f785a4p-2, INEXACT)
T(RN,   -0x1.2aa9fd405fe0ep+0,   -0x1.b96dc79400ec3p-1,    0x1.ffbf5p-2, INEXACT)
T(RN,   -0x1.2a80f98a9a56dp+0,   -0x1.b94b06dd41dd7p-1,  -0x1.fc9b16p-2, INEXACT)
T(RN,   -0x1.2a57fb76b84e5p+0,   -0x1.b928456c3f64dp-1,  -0x1.f8a6a8p-2, INEXACT)
T(RN,   -0x1.2a2f0303f3c43p+0,    -0x1.b9058341999ep-1,   0x1.f82e6ap-2, INEXACT)
T(RN,   -0x1.2a06103186d1dp+0,    -0x1.b8e2c05df0b7p-1,    0x1.fe48ep-2, INEXACT)
T(RN,   -0x1.29dd22feabb04p+0,   -0x1.b8bffcc1e4f27p-1,   0x1.fe0d12p-2, INEXACT)
T(RN,   -0x1.29b43b6a9ca61p+0,   -0x1.b89d386e16986p-1,  -0x1.f7ee6ep-2, INEXACT)
T(RN,   -0x1.298b597494249p+0,   -0x1.b87a7363260ecp-1,    0x1.f636ep-2, INEXACT)
T(RN,   -0x1.29627d1bccaacp+0,   -0x1.b857ada1b3c15p-1,  -0x1.fc832ap-2, INEXACT)
T(RN,    -0x1.2939a65f80cfp+0,   -0x1.b834e72a6028ep-1,   0x1.f75452p-2, INEXACT)
T(RN,   -0x1.2910d53eeb77cp+0,   -0x1.b8121ffdcbfc9p-1,  -0x1.faaba2p-2, INEXACT)
T(RN,    -0x1.28e809b9474bp+0,   -0x1.b7ef581c97b5bp-1,   0x1.f8f442p-2, INEXACT)
T(RN,   -0x1.28bf43cdcf588p+0,   -0x1.b7cc8f876421ap-1,   0x1.f5f3d8p-2, INEXACT)
T(RN,   -0x1.2896837bbe9c5p+0,   -0x1.b7a9c63ed1f63p-1,   0x1.fc98dep-2, INEXACT)
T(RN,   -0x1.286dc8c25044fp+0,   -0x1.b786fc43820dbp-1,   0x1.f5fef6p-2, INEXACT)
T(RN,   -0x1.284513a0bf916p+0,   -0x1.b76431961549fp-1,  -0x1.fe0da2p-2, INEXACT)
T(RN,   -0x1.281c641647e65p+0,    -0x1.b74166372ca6p-1,   0x1.fef374p-2, INEXACT)
T(RN,   -0x1.27f3ba2224b3fp+0,   -0x1.b71e9a2769206p-1,   0x1.fcf25ep-2, INEXACT)
T(RN,   -0x1.27cb15c39194cp+0,   -0x1.b6fbcd676bd4bp-1,    0x1.f6fbdp-2, INEXACT)
T(RN,    -0x1.27a276f9ca24p+0,   -0x1.b6d8fff7d5d86p-1,   0x1.f61356p-2, INEXACT)
T(RN,   -0x1.2779ddc40a705p+0,   -0x1.b6b631d9489cep-1,  -0x1.f7c814p-2, INEXACT)
T(RN,   -0x1.27514a218e09fp+0,   -0x1.b693630c65202p-1,  -0x1.f9b278p-2, INEXACT)
T(RN,   -0x1.2728bc11911d2p+0,   -0x1.b6709391ccdeep-1,   0x1.f90514p-2, INEXACT)
T(RN,   -0x1.270033934fb09p+0,   -0x1.b64dc36a212ecp-1,  -0x1.f8a03cp-2, INEXACT)
T(RN,   -0x1.26d7b0a606082p+0,   -0x1.b62af29603925p-1,   0x1.fba8fcp-2, INEXACT)
T(RN,   -0x1.26af3348f06d4p+0,   -0x1.b6082116158a3p-1,  -0x1.fe9b02p-2, INEXACT)
T(RN,   -0x1.2686bb7b4b4cdp+0,   -0x1.b5e54eeaf8adcp-1,  -0x1.fc9a54p-2, INEXACT)
T(RN,   -0x1.265e493c53303p+0,   -0x1.b5c27c154ea5cp-1,    0x1.f9c38p-2, INEXACT)
T(RN,   -0x1.2635dc8b44b29p+0,    -0x1.b59fa895b923p-1,   0x1.fd851cp-2, INEXACT)
T(RN,    -0x1.260d75675c94p+0,   -0x1.b57cd46cd9ee8p-1,   -0x1.fb96bp-2, INEXACT)
T(RN,   -0x1.25e513cfd7a9dp+0,   -0x1.b559ff9b52dbep-1,   0x1.fdb1cap-2, INEXACT)
T(RN,   -0x1.25bcb7c3f2e6dp+0,    -0x1.b5372a21c5d1p-1,     0x1.f9eap-2, INEXACT)
T(RN,   -0x1.25946142eb4f2p+0,   -0x1.b5145400d4baep-1,  -0x1.f6ac2ap-2, INEXACT)
T(RN,   -0x1.256c104bfe1c2p+0,   -0x1.b4f17d3921acbp-1,  -0x1.fe69ccp-2, INEXACT)
T(RN,   -0x1.2543c4de6879fp+0,   -0x1.b4cea5cb4ea6ap-1,  -0x1.f6f918p-2, INEXACT)
T(RN,   -0x1.251b7ef967d56p+0,   -0x1.b4abcdb7fdd8ep-1,   0x1.fbf176p-2, INEXACT)
T(RN,   -0x1.24f33e9c399bfp+0,   -0x1.b488f4ffd16c9p-1,   0x1.f7ff3cp-2, INEXACT)
T(RN,   -0x1.24cb03c61b669p+0,   -0x1.b4661ba36ba85p-1,    0x1.f8d6ep-2, INEXACT)
T(RN,    -0x1.24a2ce764adcp+0,   -0x1.b44341a36ed6dp-1,   0x1.f9e656p-2, INEXACT)
T(RN,   -0x1.247a9eac05c2ap+0,   -0x1.b42067007d563p-1,  -0x1.f7d22cp-2, INEXACT)
T(RN,   -0x1.245274668a048p+0,   -0x1.b3fd8bbb399b4p-1,  -0x1.fd89b2p-2, INEXACT)
T(RN,   -0x1.242a4fa515967p+0,   -0x1.b3daafd4461c3p-1,  -0x1.fd657ep-2, INEXACT)
T(RN,   -0x1.24023066e6967p+0,   -0x1.b3b7d34c456aap-1,   0x1.fd8914p-2, INEXACT)
T(RN,   -0x1.23da16ab3b282p+0,   -0x1.b394f623da151p-1,  -0x1.f66824p-2, INEXACT)
T(RN,    -0x1.23b2027151b6p+0,   -0x1.b372185ba6deep-1,   0x1.fef676p-2, INEXACT)
T(RN,   -0x1.2389f3b868898p+0,   -0x1.b34f39f44e66dp-1,  -0x1.f816fep-2, INEXACT)
T(RN,   -0x1.2361ea7fbe2c1p+0,   -0x1.b32c5aee737a7p-1,  -0x1.fd219ep-2, INEXACT)
T(RN,   -0x1.2339e6c691408p+0,   -0x1.b3097b4ab8f52p-1,   0x1.f5d7d2p-2, INEXACT)
T(RN,   -0x1.2311e88c207a5p+0,   -0x1.b2e69b09c1b87p-1,  -0x1.f6e7dep-2, INEXACT)
T(RN,    -0x1.22e9efcfaaa9p+0,   -0x1.b2c3ba2c30b55p-1,   0x1.fbd3ccp-2, INEXACT)
T(RN,   -0x1.22c1fc906eb8ap+0,   -0x1.b2a0d8b2a8ed7p-1,  -0x1.fd5c46p-2, INEXACT)
T(RN,   -0x1.229a0ecdabaf2p+0,   -0x1.b27df69dcd6fep-1,   0x1.fdab78p-2, INEXACT)
T(RN,   -0x1.22722686a0ae6p+0,   -0x1.b25b13ee415bcp-1,   0x1.f67534p-2, INEXACT)
T(RN,   -0x1.224a43ba8d00ep+0,   -0x1.b23830a4a7eabp-1,  -0x1.ff3296p-2, INEXACT)
T(RN,    -0x1.22226668afe1p+0,   -0x1.b2154cc1a43f3p-1,  -0x1.f707ccp-2, INEXACT)
T(RN,   -0x1.21fa8e9048d17p+0,   -0x1.b1f26845d9b24p-1,  -0x1.fbfc16p-2, INEXACT)
T(RN,   -0x1.21d2bc309757fp+0,   -0x1.b1cf8331eb968p-1,  -0x1.f8b8e2p-2, INEXACT)
T(RN,   -0x1.21aaef48db17fp+0,   -0x1.b1ac9d867d4f8p-1,  -0x1.fc7d84p-2, INEXACT)
T(RN,   -0x1.218327d853d5dp+0,   -0x1.b189b74432549p-1,   -0x1.fba79p-2, INEXACT)
T(RN,   -0x1.215b65de4165cp+0,   -0x1.b166d06bae21bp-1,  -0x1.faa9b8p-2, INEXACT)
T(RN,   -0x1.2133a959e3bfcp+0,    -0x1.b143e8fd9449p-1,   0x1.fb5a58p-2, INEXACT)
T(RN,   -0x1.210bf24a7af41p+0,   -0x1.b12100fa8868dp-1,    0x1.fa59ap-2, INEXACT)
T(RN,   -0x1.20e440af47262p+0,   -0x1.b0fe18632e26cp-1,   0x1.f7d77cp-2, INEXACT)
T(RN,   -0x1.20bc948788a0ep+0,   -0x1.b0db2f382941ep-1,  -0x1.f7848ap-2, INEXACT)
T(RN,   -0x1.2094edd27fbf2p+0,   -0x1.b0b8457a1d7d9p-1,   -0x1.fb572p-2, INEXACT)
T(RN,    -0x1.206d4c8f6cf7p+0,   -0x1.b0955b29aeabep-1,  -0x1.fd7536p-2, INEXACT)
T(RN,   -0x1.2045b0bd90dabp+0,   -0x1.b072704780adep-1,   0x1.f73a24p-2, INEXACT)
T(RN,   -0x1.201e1a5c2c1b4p+0,   -0x1.b04f84d437766p-1,   0x1.f75b08p-2, INEXACT)
T(RN,   -0x1.1ff6896a7f7b9p+0,   -0x1.b02c98d076fe1p-1,   -0x1.f8fbdp-2, INEXACT)
T(RN,   -0x1.1fcefde7cbddbp+0,   -0x1.b009ac3ce34f3p-1,   0x1.febaeap-2, INEXACT)
T(RN,    -0x1.1fa777d35242p+0,   -0x1.afe6bf1a20855p-1,   0x1.ffff26p-2, INEXACT)
T(RN,   -0x1.1f7ff72c53b49p+0,   -0x1.afc3d168d2bc3p-1,    0x1.f94ffp-2, INEXACT)
T(RN,   -0x1.1f587bf211715p+0,     -0x1.afa0e3299e3p-1,   0x1.f795d4p-2, INEXACT)
T(RN,   -0x1.1f310623ccb6ep+0,   -0x1.af7df45d27155p-1,   0x1.f8efd8p-2, INEXACT)
T(RN,   -0x1.1f0995c0c6eecp+0,   -0x1.af5b050411bcap-1,   -0x1.ffc75p-2, INEXACT)
T(RN,   -0x1.1ee22ac8419b2p+0,    -0x1.af38151f0282p-1,   -0x1.f9b0dp-2, INEXACT)
T(RN,   -0x1.1ebac5397e529p+0,   -0x1.af1524ae9dc98p-1,    0x1.fbe9ap-2, INEXACT)
T(RN,   -0x1.1e936513bec47p+0,   -0x1.aef233b388032p-1,  -0x1.ffb08cp-2, INEXACT)
T(RN,    -0x1.1e6c0a5644b8p+0,   -0x1.aecf422e65a95p-1,   0x1.f642e6p-2, INEXACT)
T(RN,   -0x1.1e44b50052237p+0,   -0x1.aeac501fdb564p-1,   0x1.f72aa4p-2, INEXACT)
T(RN,   -0x1.1e1d651129036p+0,   -0x1.ae895d888d9f4p-1,   -0x1.f698fp-2, INEXACT)
T(RN,   -0x1.1df61a880b714p+0,   -0x1.ae666a692128ap-1,  -0x1.f78764p-2, INEXACT)
T(RN,   -0x1.1dced5643ba01p+0,   -0x1.ae4376c23aa31p-1,  -0x1.fd1cf8p-2, INEXACT)
T(RN,   -0x1.1da795a4fbe12p+0,   -0x1.ae2082947ecf9p-1,   -0x1.f663cp-2, INEXACT)
T(RN,   -0x1.1d805b498e9cep+0,    -0x1.adfd8de09279p-1,   0x1.f703cap-2, INEXACT)
T(RN,   -0x1.1d59265136553p+0,   -0x1.adda98a71a767p-1,   -0x1.fbbfap-2, INEXACT)
T(RN,   -0x1.1d31f6bb35ad3p+0,   -0x1.adb7a2e8bbb16p-1,    0x1.f8f12p-2, INEXACT)
T(RN,   -0x1.1d0acc86cf50fp+0,   -0x1.ad94aca61b10fp-1,  -0x1.f6a84ap-2, INEXACT)
T(RN,   -0x1.1ce3a7b3462abp+0,   -0x1.ad71b5dfdda86p-1,   0x1.fff19ep-2, INEXACT)
T(RN,   -0x1.1cbc883fdd0b6p+0,   -0x1.ad4ebe96a869dp-1,    0x1.fb026p-2, INEXACT)
T(RN,   -0x1.1c956e2bd6fd2p+0,   -0x1.ad2bc6cb206f3p-1,    0x1.f9043p-2, INEXACT)
T(RN,   -0x1.1c6e59767734bp+0,   -0x1.ad08ce7deaedap-1,  -0x1.ffa214p-2, INEXACT)
T(RN,   -0x1.1c474a1f00d46p+0,   -0x1.ace5d5afacfe6p-1,   0x1.fdd094p-2, INEXACT)
T(RN,   -0x1.1c204024b736ep+0,   -0x1.acc2dc610be25p-1,    0x1.fcc2fp-2, INEXACT)
T(RN,   -0x1.1bf93b86ddc98p+0,   -0x1.ac9fe292acdf9p-1,   -0x1.f7241p-2, INEXACT)
T(RN,   -0x1.1bd23c44b812ep+0,   -0x1.ac7ce84535477p-1,   0x1.ff0308p-2, INEXACT)
T(RN,   -0x1.1bab425d89b3ap+0,   -0x1.ac59ed794a77ap-1,  -0x1.ff0622p-2, INEXACT)
T(RN,   -0x1.1b844dd096691p+0,   -0x1.ac36f22f91dbbp-1,  -0x1.f90deap-2, INEXACT)
T(RN,   -0x1.1b5d5e9d22056p+0,   -0x1.ac13f668b0e6bp-1,  -0x1.ff4e9ap-2, INEXACT)
T(RN,   -0x1.1b3674c2707a3p+0,   -0x1.abf0fa254d1c4p-1,   0x1.f8ebc4p-2, INEXACT)
T(RN,   -0x1.1b0f903fc5ba5p+0,   -0x1.abcdfd660bf5ap-1,   0x1.f5ccdap-2, INEXACT)
T(RN,   -0x1.1ae8b114661bcp+0,   -0x1.abab002b93398p-1,  -0x1.f87946p-2, INEXACT)
T(RN,   -0x1.1ac1d73f95b0dp+0,   -0x1.ab8802768865dp-1,  -0x1.fb4a3cp-2, INEXACT)
T(RN,   -0x1.1a9b02c098d3cp+0,   -0x1.ab650447912dap-1,  -0x1.fea244p-2, INEXACT)
T(RN,   -0x1.1a743396b3fd8p+0,   -0x1.ab42059f5353bp-1,   0x1.f6ba42p-2, INEXACT)
T(RN,   -0x1.1a4d69c12baeep+0,   -0x1.ab1f067e74962p-1,   0x1.f69fa6p-2, INEXACT)
T(RN,   -0x1.1a26a53f44908p+0,   -0x1.aafc06e59acadp-1,   0x1.f83608p-2, INEXACT)
T(RN,   -0x1.19ffe610435a1p+0,   -0x1.aad906d56bc95p-1,  -0x1.ffc0a4p-2, INEXACT)
T(RN,   -0x1.19d92c336cebap+0,   -0x1.aab6064e8d815p-1,   0x1.fbdb34p-2, INEXACT)
T(RN,   -0x1.19b277a806263p+0,   -0x1.aa930551a5d79p-1,   0x1.f6bd46p-2, INEXACT)
T(RN,   -0x1.198bc86d54292p+0,   -0x1.aa7003df5adcdp-1,  -0x1.f935e8p-2, INEXACT)
T(RN,   -0x1.19651e829c069p+0,   -0x1.aa4d01f852896p-1,   0x1.f82714p-2, INEXACT)
T(RN,   -0x1.193e79e723045p+0,   -0x1.aa29ff9d32f86p-1,   0x1.fc1d7ap-2, INEXACT)
T(RN,    -0x1.1917da9a2e72p+0,   -0x1.aa06fccea2413p-1,   0x1.f95d1ep-2, INEXACT)
T(RN,   -0x1.18f1409b03c5bp+0,   -0x1.a9e3f98d4691bp-1,   -0x1.fa59bp-2, INEXACT)
T(RN,   -0x1.18caabe8e884cp+0,   -0x1.a9c0f5d9c618ep-1,   0x1.ff5b22p-2, INEXACT)
T(RN,   -0x1.18a41c8322598p+0,   -0x1.a99df1b4c71b1p-1,   0x1.f7e2cep-2, INEXACT)
T(RN,   -0x1.187d9268f6eebp+0,   -0x1.a97aed1eefd01p-1,   0x1.f6172ap-2, INEXACT)
T(RN,   -0x1.18570d99ac495p+0,   -0x1.a957e818e6b52p-1,  -0x1.f5ee1ep-2, INEXACT)
T(RN,   -0x1.18308e14882c8p+0,   -0x1.a934e2a351febp-1,  -0x1.f69f04p-2, INEXACT)
T(RN,    -0x1.180a13d8d0adp+0,   -0x1.a911dcbed81ebp-1,   0x1.fb039cp-2, INEXACT)
T(RN,   -0x1.17e39ee5cbf27p+0,   -0x1.a8eed66c1f8b8p-1,   0x1.f9e2a2p-2, INEXACT)
T(RN,   -0x1.17bd2f3ac03dbp+0,   -0x1.a8cbcfabcec56p-1,   0x1.f9106cp-2, INEXACT)
T(RN,   -0x1.1796c4d6f3ddap+0,   -0x1.a8a8c87e8c4c7p-1,  -0x1.ff3518p-2, INEXACT)
T(RN,   -0x1.17705fb9ad4c5p+0,   -0x1.a885c0e4febaep-1,   0x1.f8fa58p-2, INEXACT)
T(RN,   -0x1.1749ffe23300ep+0,   -0x1.a862b8dfcc9b8p-1,  -0x1.f5fa16p-2, INEXACT)
T(RN,   -0x1.1723a54fcbbafp+0,   -0x1.a83fb06f9cadbp-1,  -0x1.fe8e26p-2, INEXACT)
T(RN,   -0x1.16fd5001be1eep+0,   -0x1.a81ca795158aep-1,   0x1.f71e12p-2, INEXACT)
T(RN,   -0x1.16d6fff751097p+0,   -0x1.a7f99e50ddf2ep-1,  -0x1.fa8126p-2, INEXACT)
T(RN,   -0x1.16b0b52fcb6c1p+0,   -0x1.a7d694a39caabp-1,  -0x1.f79dccp-2, INEXACT)
T(RN,   -0x1.168a6faa74492p+0,   -0x1.a7b38a8df8799p-1,   0x1.faf7f6p-2, INEXACT)
T(RN,   -0x1.16642f6692cd4p+0,   -0x1.a790801098401p-1,   0x1.f887cep-2, INEXACT)
T(RN,   -0x1.163df4636e32cp+0,   -0x1.a76d752c22ddap-1,  -0x1.fa921cp-2, INEXACT)
T(RN,   -0x1.1617bea04dc17p+0,   -0x1.a74a69e13f305p-1,   -0x1.fb13cp-2, INEXACT)
T(RN,   -0x1.15f18e1c78fb5p+0,    -0x1.a7275e30943ep-1,   0x1.fb0e0ep-2, INEXACT)
T(RN,   -0x1.15cb62d737581p+0,   -0x1.a704521ac8f59p-1,  -0x1.ff15eap-2, INEXACT)
T(RN,    -0x1.15a53ccfd07ep+0,   -0x1.a6e145a084628p-1,  -0x1.fb8e02p-2, INEXACT)
T(RN,   -0x1.157f1c058c288p+0,    -0x1.a6be38c26d96p-1,    0x1.ff536p-2, INEXACT)
T(RN,   -0x1.15590077b228dp+0,   -0x1.a69b2b812ba7ap-1,  -0x1.f6bb88p-2, INEXACT)
T(RN,   -0x1.1532ea258a6c8p+0,   -0x1.a6781ddd65baap-1,  -0x1.ffb186p-2, INEXACT)
T(RN,   -0x1.150cd90e5cfb4p+0,   -0x1.a6550fd7c2fc8p-1,  -0x1.f5f90ap-2, INEXACT)
T(RN,    -0x1.14e6cd3171f8p+0,   -0x1.a6320170eaa5bp-1,  -0x1.f8920ap-2, INEXACT)
T(RN,   -0x1.14c0c68e11951p+0,   -0x1.a60ef2a983ee9p-1,    0x1.fca37p-2, INEXACT)
T(RN,   -0x1.149ac5238420fp+0,   -0x1.a5ebe382361b7p-1,   0x1.f91898p-2, INEXACT)
T(RN,   -0x1.1474c8f112091p+0,   -0x1.a5c8d3fba87ecp-1,  -0x1.f7721cp-2, INEXACT)
T(RN,   -0x1.144ed1f603eecp+0,   -0x1.a5a5c416828c6p-1,  -0x1.fb204ap-2, INEXACT)
T(RN,   -0x1.1428e031a242ap+0,    -0x1.a582b3d36b7dp-1,  -0x1.ff1528p-2, INEXACT)
T(RN,   -0x1.1402f3a335d23p+0,   -0x1.a55fa3330ad08p-1,   0x1.fcd66cp-2, INEXACT)
T(RN,   -0x1.13dd0c4a07686p+0,   -0x1.a53c923607f61p-1,    0x1.fbcdep-2, INEXACT)
T(RN,   -0x1.13b72a255ff47p+0,   -0x1.a51980dd0a6fbp-1,   0x1.f5eea4p-2, INEXACT)
T(RN,    -0x1.13914d348871p+0,   -0x1.a4f66f28b9bb6p-1,  -0x1.fa7372p-2, INEXACT)
T(RN,   -0x1.136b7576c9fbdp+0,   -0x1.a4d35d19bd68cp-1,  -0x1.f6929ap-2, INEXACT)
T(RN,   -0x1.1345a2eb6dc87p+0,   -0x1.a4b04ab0bd0d1p-1,  -0x1.fdd0b8p-2, INEXACT)
T(RN,   -0x1.131fd591bd259p+0,   -0x1.a48d37ee6047cp-1,   0x1.fa6a26p-2, INEXACT)
T(RN,   -0x1.12fa0d6901526p+0,   -0x1.a46a24d34e9b3p-1,  -0x1.f5fbd4p-2, INEXACT)
T(RN,   -0x1.12d44a7084502p+0,   -0x1.a4471160302eap-1,  -0x1.f75572p-2, INEXACT)
T(RN,   -0x1.12ae8ca78f2c4p+0,   -0x1.a423fd95ac381p-1,   0x1.fbe02ep-2, INEXACT)
T(RN,   -0x1.1288d40d6bcf3p+0,    -0x1.a400e9746aaap-1,  -0x1.fc7cfcp-2, INEXACT)
T(RN,   -0x1.126320a163ff5p+0,   -0x1.a3ddd4fd1347dp-1,  -0x1.fe5e88p-2, INEXACT)
T(RN,   -0x1.123d7262c199ep+0,   -0x1.a3bac0304ddb3p-1,  -0x1.fd15a4p-2, INEXACT)
T(RN,   -0x1.1217c950cea93p+0,   -0x1.a397ab0ec2486p-1,   0x1.f7ebf4p-2, INEXACT)
T(RN,   -0x1.11f2256ad5367p+0,   -0x1.a374959918638p-1,  -0x1.fbb0dep-2, INEXACT)
T(RN,   -0x1.11cc86b01f7d2p+0,   -0x1.a3517fcff81fcp-1,    0x1.febb1p-2, INEXACT)
T(RN,   -0x1.11a6ed1ff7a6bp+0,   -0x1.a32e69b409508p-1,   -0x1.f69c5p-2, INEXACT)
T(RN,   -0x1.118158b9a8525p+0,   -0x1.a30b5345f4271p-1,  -0x1.f655f4p-2, INEXACT)
T(RN,   -0x1.115bc97c7bbd7p+0,   -0x1.a2e83c86606a2p-1,   0x1.fa07b2p-2, INEXACT)
T(RN,   -0x1.11363f67bc947p+0,   -0x1.a2c52575f6387p-1,   0x1.fc77fep-2, INEXACT)
T(RN,   -0x1.1110ba7ab5777p+0,   -0x1.a2a20e155d958p-1,  -0x1.f6b766p-2, INEXACT)
T(RN,   -0x1.10eb3ab4b13c7p+0,   -0x1.a27ef6653ea75p-1,  -0x1.fd3c14p-2, INEXACT)
T(RN,   -0x1.10c5c014fab19p+0,   -0x1.a25bde66417cep-1,  -0x1.fb4bf6p-2, INEXACT)
T(RN,   -0x1.10a04a9adcd1bp+0,   -0x1.a238c6190e3f2p-1,  -0x1.f6f234p-2, INEXACT)
T(RN,   -0x1.107ada45a2a36p+0,    -0x1.a215ad7e4d12p-1,  -0x1.f61bfap-2, INEXACT)
T(RN,   -0x1.10556f1497661p+0,   -0x1.a1f29496a63ebp-1,   0x1.ffb5e6p-2, INEXACT)
T(RN,   -0x1.10300907064b3p+0,   -0x1.a1cf7b62c1f17p-1,  -0x1.fa66f2p-2, INEXACT)
T(RN,   -0x1.100aa81c3aa74p+0,   -0x1.a1ac61e34866dp-1,    0x1.fc9bep-2, INEXACT)
T(RN,   -0x1.0fe54c537ff58p+0,     -0x1.a1894818e1fp-1,   0x1.fc0a9ap-2, INEXACT)
T(RN,   -0x1.0fbff5ac21b97p+0,   -0x1.a1662e0436d57p-1,   0x1.fe4512p-2, INEXACT)
T(RN,    -0x1.0f9aa4256b9ep+0,   -0x1.a14313a5ef746p-1,   0x1.f820c4p-2, INEXACT)
T(RN,   -0x1.0f7557bea95efp+0,   -0x1.a11ff8feb4299p-1,  -0x1.f649c4p-2, INEXACT)
T(RN,   -0x1.0f50107726d5cp+0,   -0x1.a0fcde0f2d5d1p-1,   0x1.f6e668p-2, INEXACT)
T(RN,   -0x1.0f2ace4e2fe43p+0,   -0x1.a0d9c2d8036eap-1,  -0x1.fff30ap-2, INEXACT)
T(RN,   -0x1.0f059143109ecp+0,   -0x1.a0b6a759dedcdp-1,  -0x1.fe34c4p-2, INEXACT)
T(RN,   -0x1.0ee05955151b1p+0,   -0x1.a0938b956816dp-1,   0x1.fe13d8p-2, INEXACT)
T(RN,   -0x1.0ebb26838992dp+0,   -0x1.a0706f8b479d4p-1,   0x1.fa05cep-2, INEXACT)
T(RN,   -0x1.0e95f8cdba5b8p+0,   -0x1.a04d533c25fa2p-1,  -0x1.f68ae2p-2, INEXACT)
T(RN,   -0x1.0e70d032f3e6fp+0,   -0x1.a02a36a8abc13p-1,   0x1.f5ddeep-2, INEXACT)
T(RN,   -0x1.0e4bacb282a6bp+0,   -0x1.a00719d181757p-1,    0x1.f860cp-2, INEXACT)
T(RN,   -0x1.0e268e4bb33c2p+0,   -0x1.9fe3fcb74fb5ep-1,   0x1.fe593ep-2, INEXACT)
T(RN,   -0x1.0e0174fdd25d9p+0,   -0x1.9fc0df5abf247p-1,  -0x1.f9a5a2p-2, INEXACT)
T(RN,   -0x1.0ddc60c82cce1p+0,   -0x1.9f9dc1bc785ddp-1,   0x1.f68974p-2, INEXACT)
T(RN,   -0x1.0db751aa0f895p+0,   -0x1.9f7aa3dd2423ap-1,  -0x1.faddbap-2, INEXACT)
T(RN,   -0x1.0d9247a2c774ap+0,   -0x1.9f5785bd6b10bp-1,  -0x1.fe7056p-2, INEXACT)
T(RN,   -0x1.0d6d42b1a1b23p+0,   -0x1.9f34675df5e88p-1,  -0x1.fa74dcp-2, INEXACT)
T(RN,   -0x1.0d4842d5eb6bcp+0,   -0x1.9f1148bf6d645p-1,   0x1.f964fep-2, INEXACT)
T(RN,   -0x1.0d23480ef154ep+0,   -0x1.9eee29e279bbep-1,   0x1.f5d32ap-2, INEXACT)
T(RN,   -0x1.0cfe525c028f8p+0,   -0x1.9ecb0ac7c564ap-1,   -0x1.f73a3p-2, INEXACT)
T(RN,   -0x1.0cd961bc6ad42p+0,   -0x1.9ea7eb6ff784ap-1,  -0x1.ff8084p-2, INEXACT)
T(RN,   -0x1.0cb4762f78462p+0,   -0x1.9e84cbdbb97c8p-1,  -0x1.fc8934p-2, INEXACT)
T(RN,   -0x1.0c8f8fb4788ddp+0,   -0x1.9e61ac0bb4264p-1,   0x1.f716dap-2, INEXACT)
T(RN,   -0x1.0c6aae4ab9715p+0,   -0x1.9e3e8c009066dp-1,  -0x1.fb5932p-2, INEXACT)
T(RN,    -0x1.0c45d1f188c8p+0,   -0x1.9e1b6bbaf7216p-1,   0x1.fbb98ap-2, INEXACT)
T(RN,   -0x1.0c20faa834865p+0,   -0x1.9df84b3b91437p-1,     0x1.f67bp-2, INEXACT)
T(RN,   -0x1.0bfc286e0ab38p+0,   -0x1.9dd52a8307ba5p-1,   0x1.fb0facp-2, INEXACT)
T(RN,   -0x1.0bd75b42597a3p+0,   -0x1.9db2099203833p-1,   0x1.f79acap-2, INEXACT)
T(RN,   -0x1.0bb293246f117p+0,   -0x1.9d8ee8692d953p-1,  -0x1.f92404p-2, INEXACT)
T(RN,   -0x1.0b8dd01399cc1p+0,   -0x1.9d6bc7092eefap-1,   0x1.ff3194p-2, INEXACT)
T(RN,   -0x1.0b69120f281d4p+0,    -0x1.9d48a572b09fp-1,   0x1.f6ea6ap-2, INEXACT)
T(RN,   -0x1.0b44591668852p+0,   -0x1.9d2583a65ba9dp-1,  -0x1.f9ebf6p-2, INEXACT)
T(RN,   -0x1.0b1fa528a9a68p+0,   -0x1.9d0261a4d9255p-1,   0x1.fbd536p-2, INEXACT)
T(RN,   -0x1.0afaf6453a32cp+0,   -0x1.9cdf3f6ed222dp-1,  -0x1.f61142p-2, INEXACT)
T(RN,   -0x1.0ad64c6b68f8ep+0,   -0x1.9cbc1d04efbd2p-1,   0x1.fbdacap-2, INEXACT)
T(RN,   -0x1.0ab1a79a84dfcp+0,    -0x1.9c98fa67db14p-1,  -0x1.fd960ep-2, INEXACT)
T(RN,   -0x1.0a8d07d1dce84p+0,   -0x1.9c75d7983d4d2p-1,   0x1.f8befcp-2, INEXACT)
T(RN,   -0x1.0a686d10c0273p+0,   -0x1.9c52b496bf8f3p-1,   0x1.f8781ep-2, INEXACT)
T(RN,   -0x1.0a43d7567dcd7p+0,    -0x1.9c2f91640b09p-1,  -0x1.ff0632p-2, INEXACT)
T(RN,   -0x1.0a1f46a26523bp+0,   -0x1.9c0c6e00c8ed6p-1,   0x1.fd5142p-2, INEXACT)
T(RN,    -0x1.09fabaf3c589p+0,   -0x1.9be94a6da2725p-1,  -0x1.f6bba6p-2, INEXACT)
T(RN,   -0x1.09d63449ee783p+0,   -0x1.9bc626ab40d53p-1,   0x1.fc7feep-2, INEXACT)
T(RN,   -0x1.09b1b2a42f7e1p+0,   -0x1.9ba302ba4d525p-1,    -0x1.f86ep-2, INEXACT)
T(RN,   -0x1.098d3601d843ep+0,    -0x1.9b7fde9b712ep-1,   -0x1.fef7bp-2, INEXACT)
T(RN,    -0x1.0968be62388ep+0,   -0x1.9b5cba4f55b3ep-1,    0x1.fa695p-2, INEXACT)
T(RN,   -0x1.09444bc4a0305p+0,   -0x1.9b3995d6a42bap-1,  -0x1.fa2b14p-2, INEXACT)
T(RN,   -0x1.091fde285f28cp+0,    -0x1.9b16713205f2p-1,  -0x1.f78028p-2, INEXACT)
T(RN,   -0x1.08fb758cc573ap+0,   -0x1.9af34c62244f4p-1,  -0x1.feeb76p-2, INEXACT)
T(RN,   -0x1.08d711f123363p+0,   -0x1.9ad02767a89fcp-1,   0x1.fd62ecp-2, INEXACT)
T(RN,   -0x1.08b2b354c8adbp+0,    -0x1.9aad02433c44p-1,  -0x1.fd68c6p-2, INEXACT)
T(RN,   -0x1.088e59b7062a1p+0,   -0x1.9a89dcf5889adp-1,  -0x1.f9f3ccp-2, INEXACT)
T(RN,   -0x1.086a05172c159p+0,   -0x1.9a66b77f37094p-1,  -0x1.f5f092p-2, INEXACT)
T(RN,   -0x1.0845b5748af37p+0,   -0x1.9a4391e0f0f8fp-1,   0x1.fc1a04p-2, INEXACT)
T(RN,   -0x1.08216ace730e5p+0,   -0x1.9a206c1b5f894p-1,   0x1.f5e05ep-2, INEXACT)
T(RN,   -0x1.07fd252436069p+0,   -0x1.99fd462f2d10dp-1,   0x1.fb716ap-2, INEXACT)
T(RN,   -0x1.07d8e47523b8ep+0,   -0x1.99da201d021d2p-1,  -0x1.fabc9ep-2, INEXACT)
T(RN,   -0x1.07b4a8c08d546p+0,   -0x1.99b6f9e5886f9p-1,   0x1.fcaceap-2, INEXACT)
T(RN,   -0x1.07907205c3dddp+0,   -0x1.9993d389698d1p-1,    0x1.fcc58p-2, INEXACT)
T(RN,   -0x1.076c4044185c4p+0,   -0x1.9970ad094ee8cp-1,  -0x1.fb157ap-2, INEXACT)
T(RN,   -0x1.0748137adbff9p+0,   -0x1.994d8665e2094p-1,   0x1.f920eep-2, INEXACT)
T(RN,   -0x1.0723eba9600dep+0,   -0x1.992a5f9fcc774p-1,  -0x1.ff2096p-2, INEXACT)
T(RN,   -0x1.06ffc8cef5daep+0,   -0x1.990738b7b7b42p-1,  -0x1.f72132p-2, INEXACT)
T(RN,   -0x1.06dbaaeaeedecp+0,   -0x1.98e411ae4d50dp-1,   0x1.fc7cf4p-2, INEXACT)
T(RN,   -0x1.06b791fc9ca22p+0,   -0x1.98c0ea8436da3p-1,   0x1.fb7baap-2, INEXACT)
T(RN,   -0x1.06937e0350c56p+0,   -0x1.989dc33a1ddfep-1,  -0x1.fed5fcp-2, INEXACT)
T(RN,   -0x1.066f6efe5d0b2p+0,   -0x1.987a9bd0abfe6p-1,   0x1.fd161ap-2, INEXACT)
T(RN,   -0x1.064b64ed133d8p+0,   -0x1.985774488ac58p-1,   0x1.fb552cp-2, INEXACT)
T(RN,   -0x1.06275fcec54c8p+0,   -0x1.98344ca263d55p-1,   0x1.f71124p-2, INEXACT)
T(RN,   -0x1.06035fa2c5352p+0,   -0x1.981124dee0c63p-1,  -0x1.fc4cdap-2, INEXACT)
T(RN,   -0x1.05df64686516ep+0,   -0x1.97edfcfeab3d7p-1,  -0x1.f6fb7ap-2, INEXACT)
T(RN,   -0x1.05bb6e1ef721bp+0,   -0x1.97cad5026cdbfp-1,   0x1.fc891ep-2, INEXACT)
T(RN,   -0x1.05977cc5cda11p+0,    -0x1.97a7aceacf49p-1,  -0x1.f85604p-2, INEXACT)
T(RN,   -0x1.0573905c3af4ap+0,   -0x1.978484b87c2a8p-1,  -0x1.ffd616p-2, INEXACT)
T(RN,   -0x1.054fa8e19198fp+0,    -0x1.97615c6c1d2ep-1,   0x1.fe8eccp-2, INEXACT)
T(RN,   -0x1.052bc655241cap+0,    -0x1.973e34065bfep-1,   0x1.f7430cp-2, INEXACT)
T(RN,   -0x1.0507e8b6452cep+0,   -0x1.971b0b87e24ddp-1,   0x1.fa7768p-2, INEXACT)
T(RN,   -0x1.04e410044786bp+0,   -0x1.96f7e2f159cb6p-1,  -0x1.f84252p-2, INEXACT)
T(RN,   -0x1.04c03c3e7e041p+0,   -0x1.96d4ba436c2bcp-1,    0x1.f87f4p-2, INEXACT)
T(RN,   -0x1.049c6d643b961p+0,   -0x1.96b1917ec325ep-1,   0x1.fb5712p-2, INEXACT)
T(RN,   -0x1.0478a374d3499p+0,   -0x1.968e68a408769p-1,   0x1.ff26bcp-2, INEXACT)
T(RN,   -0x1.0454de6f98398p+0,   -0x1.966b3fb3e5d34p-1,   0x1.f63912p-2, INEXACT)
T(RN,   -0x1.04311e53dd9d5p+0,   -0x1.964816af04f81p-1,   0x1.f8899cp-2, INEXACT)
T(RN,   -0x1.040d6320f6cadp+0,   -0x1.9624ed960fa9bp-1,  -0x1.ffeba8p-2, INEXACT)
T(RN,   -0x1.03e9acd637238p+0,   -0x1.9601c469afa2ap-1,   0x1.fe5fb2p-2, INEXACT)
T(RN,   -0x1.03c5fb72f2287p+0,   -0x1.95de9b2a8ea75p-1,   0x1.fcf1cap-2, INEXACT)
T(RN,   -0x1.03a24ef67b73ep+0,   -0x1.95bb71d9567f4p-1,  -0x1.fbd606p-2, INEXACT)
T(RN,   -0x1.037ea76026b16p+0,   -0x1.95984876b0ed3p-1,   0x1.ff950ep-2, INEXACT)
T(RN,    -0x1.035b04af47a2p+0,   -0x1.95751f0347b3cp-1,   0x1.f5e7cap-2, INEXACT)
T(RN,   -0x1.033766e3322bfp+0,   -0x1.9551f57fc4a43p-1,   0x1.faa588p-2, INEXACT)
T(RN,   -0x1.0313cdfb3a44bp+0,   -0x1.952ecbecd1892p-1,   0x1.f957d4p-2, INEXACT)
T(RN,   -0x1.02f039f6b3f55p+0,   -0x1.950ba24b182aap-1,   0x1.f9c55cp-2, INEXACT)
T(RN,   -0x1.02ccaad4f3609p+0,   -0x1.94e8789b42543p-1,    0x1.f6ab2p-2, INEXACT)
T(RN,   -0x1.02a920954cc47p+0,   -0x1.94c54eddf9d64p-1,   0x1.fcd8dep-2, INEXACT)
T(RN,   -0x1.02859b37147ccp+0,   -0x1.94a22513e888bp-1,   0x1.fc971cp-2, INEXACT)
T(RN,    -0x1.02621ab99eebp+0,   -0x1.947efb3db832ep-1,    0x1.f649fp-2, INEXACT)
T(RN,   -0x1.023e9f1c40962p+0,   -0x1.945bd15c12ab1p-1,   0x1.f795c2p-2, INEXACT)
T(RN,   -0x1.021b285e4e19fp+0,   -0x1.9438a76fa1c5fp-1,    0x1.f8d39p-2, INEXACT)
T(RN,   -0x1.01f7b67f1c1f7p+0,   -0x1.94157d790f4efp-1,   0x1.f82336p-2, INEXACT)
T(RN,   -0x1.01d4497dff7dcp+0,   -0x1.93f253790528ep-1,   0x1.fc7628p-2, INEXACT)
T(RN,    -0x1.01b0e15a4d16p+0,   -0x1.93cf29702d2a1p-1,   0x1.fba604p-2, INEXACT)
T(RN,   -0x1.018d7e1359cf1p+0,    -0x1.93abff5f3118p-1,   0x1.f9ba76p-2, INEXACT)
T(RN,   -0x1.016a1fa87ad37p+0,   -0x1.9388d546bae4dp-1,   0x1.f6b0c6p-2, INEXACT)
T(RN,   -0x1.0146c619052dcp+0,   -0x1.9365ab27744c5p-1,   0x1.fad6bap-2, INEXACT)
T(RN,   -0x1.012371644e376p+0,   -0x1.934281020741fp-1,   0x1.f79bf4p-2, INEXACT)
T(RN,   -0x1.01002189ab30bp+0,   -0x1.931f56d71d898p-1,   0x1.f828c2p-2, INEXACT)
T(RN,   -0x1.00dcd68871a0fp+0,   -0x1.92fc2ca761169p-1,   0x1.f765cap-2, INEXACT)
T(RN,   -0x1.00b9905ff6ec7p+0,    -0x1.92d902737ba3p-1,    0x1.f6decp-2, INEXACT)
T(RN,   -0x1.00964f0f90d4dp+0,   -0x1.92b5d83c172ecp-1,   0x1.f78d72p-2, INEXACT)
T(RN,   -0x1.0073129694f1bp+0,   -0x1.9292ae01dd78ep-1,   0x1.f78b7ap-2, INEXACT)
T(RN,   -0x1.004fdaf4592a5p+0,   -0x1.926f83c57878ep-1,  -0x1.f7650cp-2, INEXACT)
T(RN,   -0x1.002ca828333e6p+0,   -0x1.924c598791e76p-1,   0x1.f62f76p-2, INEXACT)
T(RN,   -0x1.00097a3177a25p+0,   -0x1.92292f48d21aep-1,   0x1.f5d8dcp-2, INEXACT)
T(RN,   -0x1.ffcca21f02673p-1,   -0x1.92060509e7bb4p-1,   -0x1.f6263p-2, INEXACT)
T(RN,   -0x1.ff865983428f5p-1,   -0x1.91e2dacb77d14p-1,  -0x1.f664a6p-2, INEXACT)
T(RN,   -0x1.ff401a8e5fb7ep-1,   -0x1.91bfb08e2df64p-1,  -0x1.f72612p-2, INEXACT)
T(RN,   -0x1.fef9e53f061d7p-1,   -0x1.919c8652b3ccfp-1,  -0x1.f6c772p-2, INEXACT)
T(RN,   -0x1.feb3b993e2ef2p-1,   -0x1.91795c19b359fp-1,  -0x1.f61472p-2, INEXACT)
T(RN,   -0x1.fe6d978ba321ap-1,   -0x1.915631e3d66d1p-1,  -0x1.f7767cp-2, INEXACT)
T(RN,   -0x1.fe277f24f3ea8p-1,    -0x1.913307b1c6dfp-1,  -0x1.f6e05ap-2, INEXACT)
T(RN,    -0x1.fde1705e82bdp-1,   -0x1.910fdd842e8fbp-1,  -0x1.f7790ep-2, INEXACT)
T(RN,   -0x1.fd9b6b36fd2eap-1,   -0x1.90ecb35bb7587p-1,    0x1.f89c6p-2, INEXACT)
T(RN,   -0x1.fd556fad10fa6p-1,   -0x1.90c989390b0ddp-1,  -0x1.f606fep-2, INEXACT)
T(RN,   -0x1.fd0f7dbf6c1dbp-1,   -0x1.90a65f1cd38d8p-1,  -0x1.f87248p-2, INEXACT)
T(RN,   -0x1.fcc9956cbcc58p-1,   -0x1.90833507bab56p-1,  -0x1.f68d7cp-2, INEXACT)
T(RN,   -0x1.fc83b6b3b135ep-1,   -0x1.90600afa6a56ep-1,  -0x1.fb6afep-2, INEXACT)
T(RN,    -0x1.fc3de192f7f2p-1,   -0x1.903ce0f58c4b2p-1,  -0x1.fa9c12p-2, INEXACT)
T(RN,   -0x1.fbf816093faacp-1,   -0x1.9019b6f9ca6a2p-1,    -0x1.fd06p-2, INEXACT)
T(RN,   -0x1.fbb254153743ep-1,   -0x1.8ff68d07ce8d5p-1,  -0x1.fc9d88p-2, INEXACT)
T(RN,   -0x1.fb6c9bb58dc1ap-1,   -0x1.8fd3632042864p-1,  -0x1.fb8046p-2, INEXACT)
T(RN,   -0x1.fb26ece8f2574p-1,   -0x1.8fb03943d025ep-1,   -0x1.fcf1ap-2, INEXACT)
T(RN,    0x1.9000000000003p+6,    0x1.8f905eb2def22p+0,   0x1.bca026p-2, INEXACT)
T(RN,    0x1.8c5530efaa9aep+6,    0x1.8f8a4e7a8bac6p+0,   0x1.1e1a92p-2, INEXACT)
T(RN,    0x1.88b2fd470a713p+6,    0x1.8f842fe62b3dep+0,  -0x1.428eeap-6, INEXACT)
T(RN,    0x1.851950d2aebe5p+6,    0x1.8f7e02d3bf70fp+0,   0x1.062f46p-8, INEXACT)
T(RN,    0x1.8188178e903a3p+6,    0x1.8f77c720f9b14p+0,  -0x1.a6c042p-4, INEXACT)
T(RN,    0x1.7dff3da5a1d09p+6,    0x1.8f717cab3a4ebp+0,   0x1.37471cp-3, INEXACT)
T(RN,    0x1.7a7eaf7162621p+6,    0x1.8f6b234f8fbe3p+0,   0x1.697e46p-4, INEXACT)
T(RN,    0x1.770659796f835p+6,    0x1.8f64baeab5d92p+0,   0x1.59a08cp-6, INEXACT)
T(RN,    0x1.73962873193eep+6,    0x1.8f5e4359151acp+0,   0x1.8ed4cep-3, INEXACT)
T(RN,    0x1.702e0940f6d4ap+6,    0x1.8f57bc76c1dbep+0,   0x1.922158p-5, INEXACT)
T(RN,    0x1.6ccde8f27c754p+6,    0x1.8f51261f7b8cfp+0,   -0x1.843d7p-5, INEXACT)
T(RN,    0x1.6975b4c391f5ap+6,    0x1.8f4a802eabee1p+0,  -0x1.ce98dep-4, INEXACT)
T(RN,    0x1.66255a1c2a7c7p+6,    0x1.8f43ca7f66457p+0,  -0x1.e34554p-3, INEXACT)
T(RN,    0x1.62dcc68fdd216p+6,    0x1.8f3d04ec6693ep+0,   0x1.a42b98p-2, INEXACT)
T(RN,    0x1.5f9be7dd7e80ep+6,    0x1.8f362f5010c74p+0,  -0x1.505b1cp-3, INEXACT)
T(RN,    0x1.5c62abeebb3f9p+6,    0x1.8f2f49846febcp+0,   0x1.75c9dap-2, INEXACT)
T(RN,     0x1.593100d7b37cp+6,    0x1.8f285363355a4p+0,  -0x1.aed94ep-3, INEXACT)
T(RN,     0x1.5606d4d6972dp+6,    0x1.8f214cc5b7e5ep+0,  -0x1.0d1592p-2, INEXACT)
T(RN,    0x1.52e416534367ap+6,    0x1.8f1a3584f306cp+0,  -0x1.a6695ep-4, INEXACT)
T(RN,    0x1.4fc8b3dee090dp+6,    0x1.8f130d7986035p+0,  -0x1.ebab52p-2, INEXACT)
T(RN,    0x1.4cb49c338170fp+6,    0x1.8f0bd47bb317bp+0,  -0x1.f72934p-2, INEXACT)
T(RN,    0x1.49a7be33c32c4p+6,    0x1.8f048a635e9adp+0,  -0x1.52ce28p-2, INEXACT)
T(RN,    0x1.46a208ea6e1cdp+6,    0x1.8efd2f080e21dp+0,  -0x1.ba94c6p-2, INEXACT)
T(RN,    0x1.43a36b8a178c1p+6,    0x1.8ef5c240e7a17p+0,   0x1.dc2358p-3, INEXACT)
T(RN,    0x1.40abd56cc4479p+6,    0x1.8eee43e4b08d2p+0,   0x1.617d7ep-2, INEXACT)
T(RN,    0x1.3dbb36138c14cp+6,    0x1.8ee6b3c9ccf49p+0,    0x1.2f8d2p-2, INEXACT)
T(RN,    0x1.3ad17d263dfa4p+6,    0x1.8edf11c63e9ecp+0,  -0x1.e27f5ep-2, INEXACT)
T(RN,    0x1.37ee9a7305629p+6,    0x1.8ed75dafa4236p+0,  -0x1.ce860cp-2, INEXACT)
T(RN,    0x1.35127dee10132p+6,    0x1.8ecf975b3801bp+0,    0x1.6ee64p-2, INEXACT)
T(RN,    0x1.323d17b134f77p+6,    0x1.8ec7be9dcfb58p+0,   0x1.536bd4p-2, INEXACT)
T(RN,    0x1.2f6e57fb9bbbbp+6,    0x1.8ebfd34bdaca5p+0,    0x1.054b7p-2, INEXACT)
T(RN,    0x1.2ca62f31653a3p+6,    0x1.8eb7d53961ebep+0,  -0x1.18b016p-4, INEXACT)
T(RN,    0x1.29e48ddb54b33p+6,    0x1.8eafc43a05f4ep+0,   -0x1.003c5p-2, INEXACT)
T(RN,    0x1.272964a679d1ap+6,    0x1.8ea7a020fefb5p+0,  -0x1.eacceap-3, INEXACT)
T(RN,    0x1.2474a463db7a1p+6,    0x1.8e9f68c11b5acp+0,  -0x1.46914cp-2, INEXACT)
T(RN,    0x1.21c63e082360bp+6,    0x1.8e971decbebc7p+0,   0x1.7baf26p-2, INEXACT)
T(RN,    0x1.1f1e22ab4a665p+6,    0x1.8e8ebf75e11cep+0,  -0x1.0e9458p-2, INEXACT)
T(RN,    0x1.1c7c438845b84p+6,    0x1.8e864d2e0dcfdp+0,  -0x1.7ef312p-3, INEXACT)
T(RN,    0x1.19e091fcb4b54p+6,    0x1.8e7dc6e662812p+0,  -0x1.d1c1f8p-2, INEXACT)
T(RN,    0x1.174aff888f905p+6,    0x1.8e752c6f8e342p+0,  -0x1.884d2cp-2, INEXACT)
T(RN,    0x1.14bb7dcdd6b43p+6,    0x1.8e6c7d99d0402p+0,  -0x1.fa4d9ap-3, INEXACT)
T(RN,    0x1.1231fe9042e3bp+6,    0x1.8e63ba34f74afp+0,   0x1.96ee58p-3, INEXACT)
T(RN,    0x1.0fae73b4f6156p+6,    0x1.8e5ae2106040dp+0,  -0x1.71ab34p-2, INEXACT)
T(RN,    0x1.0d30cf422d082p+6,    0x1.8e51f4faf54a7p+0,   0x1.386c86p-5, INEXACT)
T(RN,    0x1.0ab9035ef1924p+6,    0x1.8e48f2c32cbfep+0,  -0x1.2d7da4p-5, INEXACT)
T(RN,    0x1.08470252cda41p+6,    0x1.8e3fdb370819dp+0,  -0x1.921a8ap-4, INEXACT)
T(RN,     0x1.05dabe857f01p+6,    0x1.8e36ae2412dffp+0,  -0x1.598fb6p-3, INEXACT)
T(RN,    0x1.03742a7eabaafp+6,    0x1.8e2d6b5761951p+0,  -0x1.43a102p-5, INEXACT)
T(RN,    0x1.011338e596ff7p+6,    0x1.8e24129d90a0bp+0,  -0x1.6b76aep-2, INEXACT)
T(RN,    0x1.fd6fb901af071p+5,    0x1.8e1aa3c2c3365p+0,   0x1.d0f692p-3, INEXACT)
T(RN,    0x1.f8c4106c1ac01p+5,    0x1.8e111e92a239dp+0,    0x1.de531p-3, INEXACT)
T(RN,    0x1.f4235e13330fdp+5,    0x1.8e0782d85b21ep+0,   0x1.d2f006p-2, INEXACT)
T(RN,    0x1.ef8d883cab161p+5,    0x1.8dfdd05e9ed76p+0,   0x1.1d56cap-2, INEXACT)
T(RN,    0x1.eb02756a9823cp+5,    0x1.8df406efa0929p+0,   0x1.76ff0ep-5, INEXACT)
T(RN,    0x1.e6820c5ae4026p+5,    0x1.8dea265514b57p+0,  -0x1.6f510ep-2, INEXACT)
T(RN,    0x1.e20c3406c0885p+5,    0x1.8de02e582fa3bp+0,  -0x1.94cdf4p-2, INEXACT)
T(RN,    0x1.dda0d3a21c747p+5,    0x1.8dd61ec1a497ep+0,   0x1.eada12p-2, INEXACT)
T(RN,    0x1.d93fd29b19951p+5,    0x1.8dcbf759a475ep+0,  -0x1.07f4d8p-2, INEXACT)
T(RN,    0x1.d4e91899842d8p+5,    0x1.8dc1b7e7dc9b5p+0,   0x1.7de27cp-8, INEXACT)
T(RN,    0x1.d09c8d7e4b9ecp+5,    0x1.8db7603375ac4p+0,  -0x1.afa8ccp-3, INEXACT)
T(RN,    0x1.cc5a1962fc4d8p+5,    0x1.8dacf003125e2p+0,  -0x1.a0a288p-2, INEXACT)
T(RN,    0x1.c821a4993ac2fp+5,    0x1.8da2671cce3f7p+0,  -0x1.c22e62p-2, INEXACT)
T(RN,    0x1.c3f317aa40037p+5,    0x1.8d97c5463c7cep+0,   0x1.9071d8p-2, INEXACT)
T(RN,    0x1.bfce5b56571ecp+5,    0x1.8d8d0a4466a37p+0,  -0x1.4d6ba6p-3, INEXACT)
T(RN,    0x1.bbb358945bedcp+5,    0x1.8d8235dbcb606p+0,  -0x1.d481e8p-2, INEXACT)
T(RN,    0x1.b7a1f8913b01fp+5,    0x1.8d7747d05d3dap+0,   0x1.efa712p-2, INEXACT)
T(RN,    0x1.b39a24af72c0ep+5,    0x1.8d6c3fe5815b8p+0,  -0x1.4faeeep-3, INEXACT)
T(RN,    0x1.af9bc68695a91p+5,    0x1.8d611dde0e284p+0,  -0x1.b5c0c4p-2, INEXACT)
T(RN,    0x1.aba6c7e2cdbf5p+5,    0x1.8d55e17c4a13dp+0,   -0x1.3bc35p-3, INEXACT)
T(RN,    0x1.a7bb12c4611f4p+5,    0x1.8d4a8a81ea412p+0,  -0x1.a714eap-5, INEXACT)
T(RN,    0x1.a3d8915f37acfp+5,    0x1.8d3f18b011349p+0,   0x1.c15a4ep-4, INEXACT)
T(RN,    0x1.9fff2e1a61e7bp+5,    0x1.8d338bc74d7f4p+0,   -0x1.0d195p-6, INEXACT)
T(RN,    0x1.9c2ed38fa0d77p+5,    0x1.8d27e38798679p+0,  -0x1.a74e38p-4, INEXACT)
T(RN,    0x1.98676c8aef14dp+5,    0x1.8d1c1fb0548e8p+0,  -0x1.1bb16ap-2, INEXACT)
T(RN,    0x1.94a8e40a0ae75p+5,    0x1.8d1040004c923p+0,   0x1.d32ab8p-4, INEXACT)
T(RN,    0x1.90f3253c017a2p+5,    0x1.8d044435b1ad2p+0,  -0x1.3929cep-3, INEXACT)
T(RN,    0x1.8d461b80bb219p+5,    0x1.8cf82c0e1a52dp+0,    0x1.44285p-2, INEXACT)
T(RN,    0x1.89a1b26888afap+5,    0x1.8cebf74680c8bp+0,   0x1.69e7eap-2, INEXACT)
T(RN,    0x1.8605d5b3b1d7fp+5,    0x1.8cdfa59b41bc9p+0,   0x1.3d4c18p-3, INEXACT)
T(RN,    0x1.82727152049c3p+5,    0x1.8cd336c81ad79p+0,  -0x1.a37bf6p-2, INEXACT)
T(RN,    0x1.7ee7716265c13p+5,    0x1.8cc6aa88294e2p+0,  -0x1.15e42ap-2, INEXACT)
T(RN,    0x1.7b64c232624adp+5,    0x1.8cba0095e86c9p+0,  -0x1.b766f6p-3, INEXACT)
T(RN,    0x1.77ea503dc1fa9p+5,    0x1.8cad38ab3020dp+0,   0x1.fd4a56p-3, INEXACT)
T(RN,    0x1.7478082e1ace3p+5,    0x1.8ca0528133809p+0,  -0x1.8fd32cp-2, INEXACT)
T(RN,    0x1.710dd6da657f5p+5,    0x1.8c934dd07f4ccp+0,   0x1.3268d4p-2, INEXACT)
T(RN,    0x1.6daba94692fd3p+5,    0x1.8c862a50f870ep+0,     0x1.dea4p-3, INEXACT)
T(RN,    0x1.6a516ca322e11p+5,      0x1.8c78e7b9da8p+0,  -0x1.37dd74p-2, INEXACT)
T(RN,    0x1.66ff0e4cbadb5p+5,    0x1.8c6b85c1b62dfp+0,  -0x1.ae49e4p-3, INEXACT)
T(RN,    0x1.63b47bcbbf14dp+5,    0x1.8c5e041e6fc51p+0,   0x1.8815c4p-2, INEXACT)
T(RN,    0x1.6071a2d3eb835p+5,    0x1.8c5062853d98ep+0,  -0x1.6000eep-2, INEXACT)
T(RN,    0x1.5d367143ee305p+5,    0x1.8c42a0aaa675ap+0,   0x1.7e96cep-3, INEXACT)
T(RN,    0x1.5a02d525026d1p+5,    0x1.8c34be42800b9p+0,  -0x1.1a38cep-2, INEXACT)
T(RN,    0x1.56d6bcaa8cf44p+5,    0x1.8c26baffed57fp+0,    0x1.47229p-2, INEXACT)
T(RN,    0x1.53b21631b8f4cp+5,    0x1.8c1896955d097p+0,  -0x1.71d4c2p-3, INEXACT)
T(RN,    0x1.5094d0411606cp+5,    0x1.8c0a50b487e24p+0,   0x1.213d54p-3, INEXACT)
T(RN,     0x1.4d7ed9883705p+5,    0x1.8bfbe90e6f15ap+0,  -0x1.7a386ap-3, INEXACT)
T(RN,    0x1.4a7020df51ca8p+5,    0x1.8bed5f535aa2cp+0,  -0x1.f97ec2p-2, INEXACT)
T(RN,    0x1.47689546dfd33p+5,    0x1.8bdeb332d7abap+0,  -0x1.626836p-2, INEXACT)
T(RN,    0x1.446825e73fbbap+5,    0x1.8bcfe45bb6c88p+0,   0x1.2da1f2p-3, INEXACT)
T(RN,    0x1.416ec210579dap+5,    0x1.8bc0f27c0a57cp+0,   0x1.b3a9c4p-2, INEXACT)
T(RN,    0x1.3e7c5939384adp+5,    0x1.8bb1dd4124ca4p+0,   0x1.a5a53ep-2, INEXACT)
T(RN,    0x1.3b90daffc15f3p+5,     0x1.8ba2a45796ecp+0,  -0x1.4f1ce8p-3, INEXACT)
T(RN,    0x1.38ac3728462b5p+5,    0x1.8b93476b2e294p+0,  -0x1.659deep-3, INEXACT)
T(RN,    0x1.35ce5d9d33762p+5,    0x1.8b83c626f2cfcp+0,   0x1.bf6ef2p-2, INEXACT)
T(RN,    0x1.32f73e6eb6109p+5,    0x1.8b742035264c6p+0,  -0x1.012e5ap-2, INEXACT)
T(RN,    0x1.3026c9d2623c3p+5,    0x1.8b64553f41658p+0,   -0x1.6da2fp-3, INEXACT)
T(RN,    0x1.2d5cf022dbe0bp+5,    0x1.8b5464edf270dp+0,  -0x1.83b3a8p-2, INEXACT)
T(RN,    0x1.2a99a1df7f915p+5,    0x1.8b444ee91b863p+0,   0x1.a17e0ep-3, INEXACT)
T(RN,    0x1.27dccfac0c5cbp+5,    0x1.8b3412d7d0ae2p+0,  -0x1.ca9704p-3, INEXACT)
T(RN,    0x1.25266a504e671p+5,    0x1.8b23b060560d2p+0,   0x1.48f874p-2, INEXACT)
T(RN,    0x1.227662b7ca4e5p+5,    0x1.8b1327281e0a6p+0,  -0x1.6196e2p-2, INEXACT)
T(RN,    0x1.1fcca9f169536p+5,    0x1.8b0276d3c773ap+0,   0x1.370ab8p-3, INEXACT)
T(RN,    0x1.1d29312f26481p+5,    0x1.8af19f071b9c2p+0,    0x1.c9dd8p-3, INEXACT)
T(RN,    0x1.1a8be9c5bb41bp+5,    0x1.8ae09f650c78ap+0,  -0x1.4901b4p-5, INEXACT)
T(RN,    0x1.17f4c52c500adp+5,     0x1.8acf778fb2b7p+0,  -0x1.ab1ad4p-3, INEXACT)
T(RN,    0x1.1563b4fc29556p+5,    0x1.8abe27284bd21p+0,   0x1.3628e4p-2, INEXACT)
T(RN,    0x1.12d8aaf058aacp+5,    0x1.8aacadcf38215p+0,  -0x1.00e8c8p-2, INEXACT)
T(RN,    0x1.105398e56d174p+5,    0x1.8a9b0b23f8e54p+0,  -0x1.a04c04p-4, INEXACT)
T(RN,    0x1.0dd470d9248f6p+5,    0x1.8a893ec52e4efp+0,  -0x1.f6d2b6p-2, INEXACT)
T(RN,    0x1.0b5b24ea1e0ecp+5,    0x1.8a77485095846p+0,   0x1.607cc8p-8, INEXACT)
T(RN,    0x1.08e7a7578c6d1p+5,    0x1.8a65276306a02p+0,  -0x1.fde73cp-2, INEXACT)
T(RN,    0x1.0679ea80e9e7ap+5,    0x1.8a52db9872adcp+0,   0x1.6fc772p-2, INEXACT)
T(RN,    0x1.0411e0e5ac5fbp+5,    0x1.8a40648be1a13p+0,  -0x1.26768cp-2, INEXACT)
T(RN,    0x1.01af7d24fa49dp+5,    0x1.8a2dc1d7704b5p+0,   0x1.636dfep-3, INEXACT)
T(RN,    0x1.fea563fac09a3p+4,    0x1.8a1af3144e492p+0,  -0x1.93fc82p-3, INEXACT)
T(RN,    0x1.f9f6e4990f22ap+4,      0x1.8a07f7dabbfp+0,   0x1.1378c4p-2, INEXACT)
T(RN,    0x1.f553621dd9755p+4,    0x1.89f4cfc20834fp+0,   0x1.38f42ep-2, INEXACT)
T(RN,    0x1.f0bac2bf2f1fbp+4,    0x1.89e17a608e906p+0,   0x1.fad186p-2, INEXACT)
T(RN,    0x1.ec2cecefa6942p+4,    0x1.89cdf74bb4dd6p+0,   0x1.38a466p-3, INEXACT)
T(RN,    0x1.e7a9c75dcf1cap+4,    0x1.89ba4617e9351p+0,  -0x1.89c394p-4, INEXACT)
T(RN,    0x1.e33138f3a418bp+4,    0x1.89a666589fc5ap+0,    0x1.70149p-2, INEXACT)
T(RN,    0x1.dec328d601853p+4,    0x1.899257a050a51p+0,  -0x1.6bd9fcp-2, INEXACT)
T(RN,    0x1.da5f7e6419ce8p+4,    0x1.897e198075a06p+0,    0x1.40aa7p-5, INEXACT)
T(RN,    0x1.d6062136ece3ep+4,    0x1.8969ab8988059p+0,  -0x1.a7d2d8p-2, INEXACT)
T(RN,    0x1.d1b6f920c08d2p+4,    0x1.89550d4afe6a7p+0,   -0x1.03d56p-2, INEXACT)
T(RN,    0x1.cd71ee2c99ffep+4,    0x1.89403e534a6e7p+0,   0x1.597562p-3, INEXACT)
T(RN,    0x1.c936e89db8aedp+4,    0x1.892b3e2fd6789p+0,  -0x1.ed353ep-2, INEXACT)
T(RN,    0x1.c505d0ef12524p+4,    0x1.89160c6d03715p+0,  -0x1.1c36a4p-3, INEXACT)
T(RN,    0x1.c0de8fd2d0259p+4,    0x1.8900a8962677bp+0,   0x1.c90234p-3, INEXACT)
T(RN,    0x1.bcc10e31cd59ap+4,    0x1.88eb12358692ap+0,   0x1.ff1f2cp-2, INEXACT)
T(RN,    0x1.b8ad352b16b4ep+4,    0x1.88d548d45a5ddp+0,   0x1.14c486p-2, INEXACT)
T(RN,    0x1.b4a2ee136b618p+4,    0x1.88bf4bfac5b26p+0,  -0x1.9a3806p-2, INEXACT)
T(RN,    0x1.b0a22274bee74p+4,    0x1.88a91b2fd74b5p+0,  -0x1.e955b4p-3, INEXACT)
T(RN,    0x1.acaabc0dbc4bep+4,    0x1.8892b5f986656p+0,   -0x1.1432dp-2, INEXACT)
T(RN,    0x1.a8bca4d14a57fp+4,    0x1.887c1bdcb05b2p+0,   0x1.7794d2p-2, INEXACT)
T(RN,    0x1.a4d7c6e611007p+4,    0x1.88654c5d163c4p+0,   0x1.b25f96p-3, INEXACT)
T(RN,    0x1.a0fc0ca5ffee1p+4,    0x1.884e46fd5a611p+0,   -0x1.f5b4dp-2, INEXACT)
T(RN,    0x1.9d29609dd621ap+4,    0x1.88370b3efdf97p+0,  -0x1.276086p-2, INEXACT)
T(RN,    0x1.995fad8caab47p+4,    0x1.881f98a25e975p+0,   -0x1.5853cp-4, INEXACT)
T(RN,    0x1.959ede6376afap+4,    0x1.8807eea6b3b55p+0,   0x1.af4108p-4, INEXACT)
T(RN,    0x1.91e6de449ff79p+4,    0x1.87f00cca0c38dp+0,   0x1.143856p-2, INEXACT)
T(RN,    0x1.8e379883854d3p+4,    0x1.87d7f2894befdp+0,  -0x1.679eaep-2, INEXACT)
T(RN,    0x1.8a90f8a40b5c8p+4,    0x1.87bf9f60290acp+0,   0x1.b9e50cp-2, INEXACT)
T(RN,    0x1.86f2ea5a2ad9dp+4,    0x1.87a712c929916p+0,   0x1.ddffe2p-3, INEXACT)
T(RN,    0x1.835d59897fabcp+4,    0x1.878e4c3da0d46p+0,  -0x1.293af4p-5, INEXACT)
T(RN,    0x1.7fd03244d91bdp+4,    0x1.87754b35acd9fp+0,   -0x1.f48bbp-2, INEXACT)
T(RN,     0x1.7c4b60cdcb0fp+4,    0x1.875c0f2833c69p+0,    0x1.b37afp-2, INEXACT)
T(RN,    0x1.78ced1944040ep+4,    0x1.8742978ae1411p+0,  -0x1.b48e5ap-3, INEXACT)
T(RN,    0x1.755a71360d82ap+4,    0x1.8728e3d223d37p+0,   0x1.267214p-2, INEXACT)
T(RN,    0x1.71ee2c7e85f74p+4,    0x1.870ef3712a464p+0,    0x1.2725fp-2, INEXACT)
T(RN,    0x1.6e89f066104cbp+4,    0x1.86f4c5d9e0f8dp+0,  -0x1.5744c2p-2, INEXACT)
T(RN,    0x1.6b2daa11bcf1bp+4,    0x1.86da5a7cef34fp+0,   0x1.688492p-4, INEXACT)
T(RN,    0x1.67d946d2dd41cp+4,    0x1.86bfb0c9b47e3p+0,   0x1.f9909ap-2, INEXACT)
T(RN,    0x1.648cb4269ba76p+4,    0x1.86a4c82e45dd8p+0,   0x1.d8b184p-3, INEXACT)
T(RN,    0x1.6147dfb594b3cp+4,    0x1.8689a0176b28ap+0,  -0x1.e1950ep-3, INEXACT)
T(RN,    0x1.5e0ab75371264p+4,    0x1.866e37f09c456p+0,    0x1.c4809p-3, INEXACT)
T(RN,    0x1.5ad528fe80e34p+4,    0x1.86528f23fe68ap+0,  -0x1.fbbc96p-2, INEXACT)
T(RN,    0x1.57a722df56d9ep+4,    0x1.8636a51a61521p+0,    -0x1.f01ep-2, INEXACT)
T(RN,    0x1.5480934865d28p+4,    0x1.861a793b3c831p+0,   0x1.69d018p-4, INEXACT)
T(RN,    0x1.516168b59e279p+4,    0x1.85fe0aecac722p+0,   0x1.f07958p-4, INEXACT)
T(RN,    0x1.4e4991cc0c63ep+4,    0x1.85e159936fba7p+0,  -0x1.b96734p-3, INEXACT)
T(RN,    0x1.4b38fd5978c6fp+4,    0x1.85c46492e4477p+0,  -0x1.28535ep-2, INEXACT)
T(RN,    0x1.482f9a5407aa7p+4,    0x1.85a72b4d047c8p+0,   0x1.b1030ep-5, INEXACT)
T(RN,    0x1.452d57d9dac84p+4,    0x1.8589ad226458ep+0,  -0x1.71a8f2p-5, INEXACT)
T(RN,    0x1.42322530b35fep+4,    0x1.856be9722e982p+0,   0x1.00cbdap-4, INEXACT)
T(RN,     0x1.3f3df1c59537p+4,    0x1.854ddf9a21ce8p+0,   -0x1.50dcep-2, INEXACT)
T(RN,    0x1.3c50ad2c6a742p+4,    0x1.852f8ef68d821p+0,   0x1.38267ep-3, INEXACT)
T(RN,    0x1.396a471fa852fp+4,    0x1.8510f6e24f3fcp+0,  -0x1.329f58p-2, INEXACT)
T(RN,    0x1.368aaf7ff4adep+4,    0x1.84f216b6cfadap+0,   0x1.a07052p-4, INEXACT)
T(RN,    0x1.33b1d653cc5b6p+4,    0x1.84d2edcbff98dp+0,   0x1.6512cap-2, INEXACT)
T(RN,    0x1.30dfabc72a5f6p+4,    0x1.84b37b785500cp+0,   0x1.8c7d4cp-2, INEXACT)
T(RN,    0x1.2e14202b2febbp+4,    0x1.8493bf10c81ecp+0,   0x1.e9228ap-3, INEXACT)
T(RN,     0x1.2b4f23f5cd2fp+4,    0x1.8473b7e8d06a6p+0,   0x1.4db368p-2, INEXACT)
T(RN,    0x1.2890a7c16af1ep+4,    0x1.84536552619a9p+0,  -0x1.c6e756p-4, INEXACT)
T(RN,    0x1.25d89c4c94fccp+4,    0x1.8432c69de8a3dp+0,   -0x1.eba68p-2, INEXACT)
T(RN,    0x1.2326f279a547cp+4,    0x1.8411db1a48b32p+0,   -0x1.66eb3p-2, INEXACT)
T(RN,    0x1.207b9b4e6ff1dp+4,    0x1.83f0a214d8261p+0,   0x1.7da2eep-4, INEXACT)
T(RN,    0x1.1dd687f3effc6p+4,    0x1.83cf1ad95d7ffp+0,   -0x1.3002cp-6, INEXACT)
T(RN,    0x1.1b37a9b5f4cafp+4,    0x1.83ad44b20c5c6p+0,  -0x1.bc3114p-3, INEXACT)
T(RN,    0x1.189ef202d063bp+4,    0x1.838b1ee7825efp+0,  -0x1.275c9ep-2, INEXACT)
T(RN,    0x1.160c526b06714p+4,    0x1.8368a8c0c4206p+0,   0x1.c9d8b8p-2, INEXACT)
T(RN,    0x1.137fbca0fc012p+4,    0x1.8345e1833a191p+0,  -0x1.30e47ep-2, INEXACT)
T(RN,    0x1.10f92278a7febp+4,    0x1.8322c872ad89cp+0,  -0x1.628c02p-2, INEXACT)
T(RN,    0x1.0e7875e7446a3p+4,    0x1.82ff5cd145614p+0,   0x1.9adb76p-2, INEXACT)
T(RN,    0x1.0bfda90300471p+4,    0x1.82db9ddf83205p+0,   0x1.2f601cp-3, INEXACT)
T(RN,    0x1.0988ae02b241cp+4,    0x1.82b78adc3fbbcp+0,  -0x1.88e89ap-2, INEXACT)
T(RN,    0x1.0719773d8c0c2p+4,    0x1.82932304a87c5p+0,  -0x1.9b09f8p-4, INEXACT)
T(RN,    0x1.04aff72ace6cfp+4,    0x1.826e65943bdccp+0,   0x1.b47d18p-2, INEXACT)
T(RN,    0x1.024c20617e00cp+4,    0x1.824951c4c6666p+0,  -0x1.6dc508p-3, INEXACT)
T(RN,    0x1.ffdbcb30315b1p+3,    0x1.8223e6ce5f8c7p+0,  -0x1.0fe48ap-2, INEXACT)
T(RN,    0x1.fb2a734897868p+3,    0x1.81fe23e766858p+0,   0x1.0f31c4p-3, INEXACT)
T(RN,    0x1.f6841ef555962p+3,     0x1.81d808447f24p+0,  -0x1.ad200ep-2, INEXACT)
T(RN,    0x1.f1e8b45cce028p+3,     0x1.81b193188eaep+0,   0x1.b7bc38p-3, INEXACT)
T(RN,    0x1.ed5819e20ef56p+3,    0x1.818ac394b8b36p+0,   0x1.98bf46p-2, INEXACT)
T(RN,    0x1.e8d2362443e3dp+3,     0x1.816398e85be4p+0,  -0x1.a012f8p-3, INEXACT)
T(RN,    0x1.e456effe28769p+3,    0x1.813c12410ee52p+0,  -0x1.396b6ap-6, INEXACT)
T(RN,    0x1.dfe62e857cbf4p+3,    0x1.81142eca9d262p+0,  -0x1.d90338p-3, INEXACT)
T(RN,    0x1.db7fd90a7ab47p+3,    0x1.80ebedaf03b5ap+0,   -0x1.6779ep-3, INEXACT)
T(RN,    0x1.d723d7174cf1ap+3,    0x1.80c34e166e163p+0,   0x1.d132eap-2, INEXACT)
T(RN,    0x1.d2d2106f86bccp+3,    0x1.809a4f2733136p+0,  -0x1.fefe4ep-3, INEXACT)
T(RN,    0x1.ce8a6d0f9d47ap+3,    0x1.8070f005d197ap+0,  -0x1.f730c8p-2, INEXACT)
T(RN,    0x1.ca4cd52c622e2p+3,    0x1.80472fd4ed822p+0,   0x1.94935cp-2, INEXACT)
T(RN,    0x1.c61931327f302p+3,    0x1.801d0db54c7ddp+0,  -0x1.c92b92p-2, INEXACT)
T(RN,    0x1.c1ef69c5f31f1p+3,    0x1.7ff288c5d2da2p+0,   0x1.274d96p-3, INEXACT)
T(RN,    0x1.bdcf67c18fffap+3,    0x1.7fc7a0238063dp+0,   0x1.f46bfep-6, INEXACT)
T(RN,    0x1.b9b914367a5e6p+3,    0x1.7f9c52e96d40ap+0,  -0x1.db9beep-2, INEXACT)
T(RN,    0x1.b5ac586ba9cfep+3,    0x1.7f70a030c6cc3p+0,   0x1.512e7ap-3, INEXACT)
T(RN,    0x1.b1a91ddd6a9c8p+3,    0x1.7f448710cc76dp+0,   0x1.f3c0e6p-3, INEXACT)
T(RN,    0x1.adaf4e3ce0968p+3,    0x1.7f18069ecca76p+0,   0x1.496ba6p-3, INEXACT)
T(RN,    0x1.a9bed36f8b13cp+3,    0x1.7eeb1dee219f5p+0,   0x1.41c132p-2, INEXACT)
T(RN,    0x1.a5d7978eca0bbp+3,    0x1.7ebdcc102e61bp+0,  -0x1.275d14p-6, INEXACT)
T(RN,    0x1.a1f984e76454dp+3,    0x1.7e9010145b9dbp+0,  -0x1.53f5ecp-2, INEXACT)
T(RN,    0x1.9e2485f90f016p+3,    0x1.7e61e908149c9p+0,   0x1.5aaf32p-2, INEXACT)
T(RN,    0x1.9a588575f5d63p+3,    0x1.7e3355f6c4334p+0,   0x1.8f99e4p-3, INEXACT)
T(RN,    0x1.96956e4244d93p+3,    0x1.7e0455e9d1b8bp+0,  -0x1.70d304p-2, INEXACT)
T(RN,    0x1.92db2b73b2f86p+3,    0x1.7dd4e7e89e006p+0,  -0x1.ef4d8ap-2, INEXACT)
T(RN,     0x1.8f29a8510dc2p+3,    0x1.7da50af88059cp+0,  -0x1.ebd644p-2, INEXACT)
T(RN,    0x1.8b80d051c62dfp+3,    0x1.7d74be1cc3951p+0,   0x1.5b7934p-3, INEXACT)
T(RN,    0x1.87e08f1d7e772p+3,    0x1.7d440056a30dbp+0,   0x1.9188fep-3, INEXACT)
T(RN,    0x1.8448d08b98ff2p+3,    0x1.7d12d0a547bacp+0,   0x1.06d0a6p-8, INEXACT)
T(RN,     0x1.80b980a2c83bp+3,    0x1.7ce12e05c545dp+0,  -0x1.71efa8p-2, INEXACT)
T(RN,    0x1.7d328b989fa9ap+3,    0x1.7caf17731728cp+0,   0x1.d616d2p-2, INEXACT)
T(RN,    0x1.79b3ddd125cbap+3,    0x1.7c7c8be61dd25p+0,   0x1.d2deecp-2, INEXACT)
T(RN,    0x1.763d63de671fep+3,    0x1.7c498a559bd32p+0,   -0x1.3cec5p-2, INEXACT)
T(RN,    0x1.72cf0a800a1dap+3,    0x1.7c1611b633125p+0,  -0x1.c316bep-3, INEXACT)
T(RN,    0x1.6f68bea2e42f1p+3,    0x1.7be220fa620abp+0,   0x1.8d853cp-2, INEXACT)
T(RN,    0x1.6c0a6d608fa46p+3,    0x1.7badb71281112p+0,   0x1.4e83e6p-2, INEXACT)
T(RN,    0x1.68b403ff02a0bp+3,    0x1.7b78d2ecbfa4ap+0,   0x1.15f032p-3, INEXACT)
T(RN,    0x1.65656ff026fe6p+3,    0x1.7b43737521c83p+0,   0x1.03a3fap-2, INEXACT)
T(RN,    0x1.621e9ed17326cp+3,    0x1.7b0d97957d674p+0,   0x1.e38b02p-3, INEXACT)
T(RN,    0x1.5edf7e6b83db8p+3,    0x1.7ad73e3577c55p+0,   0x1.0399b2p-5, INEXACT)
T(RN,    0x1.5ba7fcb1b6f1dp+3,    0x1.7aa0663a82f94p+0,   0x1.4d40c8p-2, INEXACT)
T(RN,    0x1.587807c1c6f99p+3,    0x1.7a690e87db749p+0,   0x1.fadd6ep-2, INEXACT)
T(RN,    0x1.554f8de367cfbp+3,    0x1.7a3135fe85979p+0,  -0x1.1a5256p-2, INEXACT)
T(RN,    0x1.522e7d87e41c1p+3,    0x1.79f8db7d4b533p+0,    0x1.38333p-5, INEXACT)
T(RN,    0x1.4f14c549bbb4ap+3,    0x1.79bffde0b9d81p+0,  -0x1.5d163ep-5, INEXACT)
T(RN,    0x1.4c0253ec42e5cp+3,    0x1.79869c031f54ep+0,  -0x1.d4ec9ap-2, INEXACT)
T(RN,     0x1.48f7185b429fp+3,    0x1.794cb4bc88c3cp+0,   0x1.218028p-5, INEXACT)
T(RN,    0x1.45f301aa997f5p+3,    0x1.791246e2bfc73p+0,  -0x1.87767ap-3, INEXACT)
T(RN,    0x1.42f5ff15ddc08p+3,    0x1.78d7514948983p+0,  -0x1.cb43f8p-2, INEXACT)
T(RN,    0x1.4000000000001p+3,    0x1.789bd2c160054p+0,   0x1.a33922p-2, INEXACT)
T(RN,    0x1.3d10f3f2eee23p+3,    0x1.785fca19f9833p+0,  -0x1.c52498p-5, INEXACT)
T(RN,    0x1.3a28ca9f3b8ddp+3,    0x1.7823361fbd517p+0,   0x1.1d479ap-4, INEXACT)
T(RN,    0x1.374773dbbefecp+3,    0x1.77e6159d06b0ep+0,    0x1.58034p-3, INEXACT)
T(RN,    0x1.346cdfa5402e5p+3,    0x1.77a86759e22fap+0,   -0x1.627f7p-3, INEXACT)
T(RN,    0x1.3198fe1e1b0d3p+3,    0x1.776a2a1c0c09bp+0,  -0x1.1ca206p-2, INEXACT)
T(RN,    0x1.2ecbbf8de84e6p+3,    0x1.772b5ca6ee9f5p+0,   0x1.85f526p-2, INEXACT)
T(RN,    0x1.2c0514612602ap+3,    0x1.76ebfdbba1023p+0,   0x1.b93624p-2, INEXACT)
T(RN,    0x1.2944ed28e0ff3p+3,    0x1.76ac0c18e59a6p+0,   0x1.bdd622p-4, INEXACT)
T(RN,    0x1.268b3a9a5f109p+3,    0x1.766b867b28e38p+0,   0x1.90e8c6p-2, INEXACT)
T(RN,    0x1.23d7ed8ec9f73p+3,    0x1.762a6b9c80434p+0,     0x1.a9bcp-2, INEXACT)
T(RN,    0x1.212af702db2adp+3,    0x1.75e8ba34a8fa7p+0,   0x1.883cc4p-2, INEXACT)
T(RN,    0x1.1e84481688637p+3,     0x1.75a670f90731p+0,  -0x1.f9d326p-3, INEXACT)
T(RN,    0x1.1be3d20cb0e77p+3,    0x1.75638e9ca51eap+0,    -0x1.7683p-3, INEXACT)
T(RN,    0x1.1949864acb9a4p+3,    0x1.752011d032501p+0,  -0x1.056f7ap-7, INEXACT)
T(RN,    0x1.16b5565895cc8p+3,    0x1.74dbf942030b3p+0,   0x1.3387dcp-2, INEXACT)
T(RN,    0x1.142733dfc2c9bp+3,     0x1.7497439e0fd2p+0,  -0x1.c4ccd8p-2, INEXACT)
T(RN,    0x1.119f10abac23dp+3,    0x1.7451ef8df5068p+0,  -0x1.ba72cap-2, INEXACT)
T(RN,    0x1.0f1cdea902b94p+3,    0x1.740bfbb8f2af6p+0,  -0x1.2a36f2p-3, INEXACT)
T(RN,    0x1.0ca08fe58073dp+3,    0x1.73c566c3ec5fcp+0,  -0x1.371ad2p-3, INEXACT)
T(RN,    0x1.0a2a168f9ac0bp+3,    0x1.737e2f516942cp+0,  -0x1.f4d078p-2, INEXACT)
T(RN,    0x1.07b964f635bd1p+3,    0x1.73365401944bep+0,  -0x1.a570e2p-3, INEXACT)
T(RN,    0x1.054e6d8858172p+3,    0x1.72edd3723c8d6p+0,   0x1.ed1bf8p-3, INEXACT)
T(RN,    0x1.02e922d4dfa31p+3,    0x1.72a4ac3ed5b67p+0,   0x1.829a44p-2, INEXACT)
T(RN,    0x1.0089778a369fap+3,    0x1.725add0078b9dp+0,  -0x1.2220bep-2, INEXACT)
T(RN,    0x1.fc5ebcec13544p+2,    0x1.7210644de49e9p+0,  -0x1.7617a8p-4, INEXACT)
T(RN,    0x1.f7b59509fcc37p+2,    0x1.71c540bb7f7bep+0,  -0x1.a63d78p-3, INEXACT)
T(RN,    0x1.f3175d84d56aap+2,    0x1.717970db57a1fp+0,  -0x1.e2dbe8p-2, INEXACT)
T(RN,    0x1.ee83fcb019b85p+2,    0x1.712cf33d24f0ap+0,   0x1.ccd722p-2, INEXACT)
T(RN,    0x1.e9fb591b87f1fp+2,    0x1.70dfc66e4a5d9p+0,  -0x1.0b9484p-3, INEXACT)
T(RN,    0x1.e57d599292c5cp+2,    0x1.7091e8f9d7abdp+0,   0x1.1a04e2p-5, INEXACT)
T(RN,    0x1.e109e51bd529dp+2,     0x1.704359688b55p+0,  -0x1.4c0888p-3, INEXACT)
T(RN,    0x1.dca0e2f88784fp+2,    0x1.6ff41640d4a75p+0,  -0x1.7bae0ap-5, INEXACT)
T(RN,    0x1.d8423aa3f61c4p+2,    0x1.6fa41e06d6187p+0,   0x1.ee005ap-5, INEXACT)
T(RN,    0x1.d3edd3d2f8c37p+2,    0x1.6f536f3c67cfdp+0,   -0x1.21d23p-2, INEXACT)
T(RN,     0x1.cfa396736bcep+2,    0x1.6f0208611a69cp+0,   0x1.f1eea4p-2, INEXACT)
T(RN,    0x1.cb636aabaa3d1p+2,    0x1.6eafe7f239f46p+0,  -0x1.ee343cp-2, INEXACT)
T(RN,    0x1.c72d38da0926ap+2,    0x1.6e5d0c6ad129ap+0,  -0x1.623958p-4, INEXACT)
T(RN,    0x1.c300e99454551p+2,    0x1.6e097443ace5dp+0,   0x1.20b3eep-2, INEXACT)
T(RN,    0x1.bede65a74c1a1p+2,    0x1.6db51df35fdeap+0,  -0x1.362cc2p-2, INEXACT)
T(RN,    0x1.bac5961624539p+2,    0x1.6d6007ee469b5p+0,  -0x1.28123ap-2, INEXACT)
T(RN,    0x1.b6b6641a049fap+2,    0x1.6d0a30a68bafbp+0,   0x1.aeccdep-2, INEXACT)
T(RN,    0x1.b2b0b92189bb8p+2,    0x1.6cb3968c2c3c5p+0,    0x1.78b56p-5, INEXACT)
T(RN,    0x1.aeb47ed0480cdp+2,    0x1.6c5c380cfcb61p+0,   0x1.93633ap-2, INEXACT)
T(RN,    0x1.aac19efe4f504p+2,    0x1.6c041394adf5bp+0,  -0x1.0f5c8cp-2, INEXACT)
T(RN,    0x1.a6d803b7af6cdp+2,    0x1.6bab278cd2933p+0,   0x1.34c45cp-3, INEXACT)
T(RN,    0x1.a2f7973bfe681p+2,    0x1.6b51725ce48d2p+0,   0x1.5dfd4cp-2, INEXACT)
T(RN,     0x1.9f2043fddf78p+2,    0x1.6af6f26a4b3f8p+0,   0x1.d4dc86p-3, INEXACT)
T(RN,     0x1.9b51f4a28b32p+2,    0x1.6a9ba61861ab6p+0,   0x1.e65b38p-6, INEXACT)
T(RN,    0x1.978c940158d24p+2,    0x1.6a3f8bc87d119p+0,  -0x1.627454p-2, INEXACT)
T(RN,    0x1.93d00d2348998p+2,    0x1.69e2a1d9f3e2bp+0,   0x1.9dfe7cp-2, INEXACT)
T(RN,    0x1.901c4b428f3fcp+2,    0x1.6984e6aa25066p+0,   0x1.23a04ep-5, INEXACT)
T(RN,    0x1.8c7139ca22781p+2,    0x1.692658947f7cep+0,   0x1.73b12ep-2, INEXACT)
T(RN,     0x1.88cec4554683p+2,    0x1.68c6f5f28a5bbp+0,   0x1.6b5d12p-3, INEXACT)
T(RN,    0x1.8534d6af1ccedp+2,    0x1.6866bd1bed295p+0,  -0x1.fabb7cp-5, INEXACT)
T(RN,    0x1.81a35cd233a01p+2,    0x1.6805ac6678991p+0,   0x1.902678p-2, INEXACT)
T(RN,    0x1.7e1a42e816c36p+2,    0x1.67a3c2262fa9fp+0,  -0x1.2f3462p-4, INEXACT)
T(RN,    0x1.7a997548e143fp+2,    0x1.6740fcad512b6p+0,   0x1.8465d8p-3, INEXACT)
T(RN,    0x1.7720e07ad0245p+2,    0x1.66dd5a4c61a91p+0,  -0x1.af7d8ep-4, INEXACT)
T(RN,    0x1.73b07131d618ap+2,    0x1.6678d95235c1ep+0,  -0x1.f5df8ep-2, INEXACT)
T(RN,    0x1.7048144f303e2p+2,    0x1.6613780bfceb4p+0,   0x1.69b372p-2, INEXACT)
T(RN,    0x1.6ce7b6e0fbceep+2,    0x1.65ad34c54ca3dp+0,   0x1.20326cp-2, INEXACT)
T(RN,    0x1.698f4621cccf6p+2,    0x1.65460dc82c18cp+0,   0x1.a19ccap-3, INEXACT)
T(RN,    0x1.663eaf7845b22p+2,     0x1.64de015d203fp+0,   -0x1.317c2p-2, INEXACT)
T(RN,    0x1.62f5e076aff15p+2,    0x1.64750dcb38645p+0,   -0x1.9f8d8p-2, INEXACT)
T(RN,    0x1.5fb4c6da959b2p+2,     0x1.640b31581b3ap+0,  -0x1.32900cp-2, INEXACT)
T(RN,    0x1.5c7b508c5bcd7p+2,    0x1.63a06a48145c8p+0,   0x1.a8c3dap-2, INEXACT)
T(RN,    0x1.59496b9ede20cp+2,    0x1.6334b6de225a4p+0,  -0x1.f879acp-5, INEXACT)
T(RN,    0x1.561f064f0aff7p+2,    0x1.62c8155c053d6p+0,   0x1.057d82p-4, INEXACT)
T(RN,    0x1.52fc0f0380e5ap+2,    0x1.625a84024d998p+0,  -0x1.1d1452p-3, INEXACT)
T(RN,    0x1.4fe0744c2c8a4p+2,    0x1.61ec01106c225p+0,   0x1.746dbap-3, INEXACT)
T(RN,    0x1.4ccc24e1e7ec9p+2,    0x1.617c8ac4c1cc3p+0,   -0x1.7864bp-3, INEXACT)
T(RN,    0x1.49bf0fa61a45fp+2,    0x1.610c1f5cb07b1p+0,  -0x1.142fdap-3, INEXACT)
T(RN,    0x1.46b923a258dd6p+2,    0x1.609abd14ac416p+0,   -0x1.0931ep-3, INEXACT)
T(RN,    0x1.43ba500808b8fp+2,    0x1.602862284d32ap+0,   -0x1.8173dp-3, INEXACT)
T(RN,    0x1.40c28430012e8p+2,    0x1.5fb50cd261cc8p+0,  -0x1.4a04cap-3, INEXACT)
T(RN,    0x1.3dd1af9a2f4dfp+2,    0x1.5f40bb4d01f92p+0,    0x1.256f9p-2, INEXACT)
T(RN,     0x1.3ae7c1ed3a26p+2,    0x1.5ecb6bd1a2adcp+0,  -0x1.c751e4p-2, INEXACT)
T(RN,    0x1.3804aaf627dffp+2,    0x1.5e551c992a293p+0,  -0x1.dc38cep-2, INEXACT)
T(RN,    0x1.35285aa803b02p+2,    0x1.5dddcbdc04d3ep+0,   0x1.8c1c22p-5, INEXACT)
T(RN,    0x1.3252c11b849a7p+2,    0x1.5d6577d23ac5dp+0,   0x1.268a3ap-2, INEXACT)
T(RN,    0x1.2f83ce8eb508bp+2,     0x1.5cec1eb385f5p+0,   0x1.637c5ep-4, INEXACT)
T(RN,    0x1.2cbb73649b2edp+2,    0x1.5c71beb7690efp+0,   0x1.35e7dap-5, INEXACT)
T(RN,    0x1.29f9a024e23e8p+2,    0x1.5bf656154700dp+0,   0x1.edf51ap-2, INEXACT)
T(RN,    0x1.273e457b8465dp+2,     0x1.5b79e3047b31p+0,  -0x1.437d36p-2, INEXACT)
T(RN,    0x1.2489543875973p+2,    0x1.5afc63bc726d8p+0,   0x1.90e586p-2, INEXACT)
T(RN,    0x1.21dabd4f4f1a6p+2,     0x1.5a7dd674c491p+0,   -0x1.be357p-2, INEXACT)
T(RN,    0x1.1f3271d6fbe2ap+2,    0x1.59fe39654ee3ap+0,  -0x1.e43828p-2, INEXACT)
T(RN,    0x1.1c90630965aa2p+2,    0x1.597d8ac64f382p+0,  -0x1.eda57ap-2, INEXACT)
T(RN,    0x1.19f4824322cf6p+2,    0x1.58fbc8d07fca3p+0,  -0x1.bbf1b4p-2, INEXACT)
T(RN,    0x1.175ec10324f36p+2,    0x1.5878f1bd33dfep+0,  -0x1.19c0a4p-2, INEXACT)
T(RN,    0x1.14cf10ea68574p+2,    0x1.57f503c675318p+0,  -0x1.461074p-2, INEXACT)
T(RN,    0x1.124563bba3f68p+2,    0x1.576ffd27221abp+0,  -0x1.63aad6p-4, INEXACT)
T(RN,    0x1.0fc1ab5afa5d6p+2,    0x1.56e9dc1b0c977p+0,  -0x1.272f5cp-3, INEXACT)
T(RN,    0x1.0d43d9cdab38ap+2,    0x1.56629edf1a104p+0,   0x1.a3f8eap-2, INEXACT)
T(RN,    0x1.0acbe139c59d9p+2,    0x1.55da43b163f79p+0,   0x1.e1b486p-2, INEXACT)
T(RN,    0x1.0859b3e5db085p+2,    0x1.5550c8d1593bfp+0,   0x1.f9f9aap-2, INEXACT)
T(RN,    0x1.05ed4438b30f6p+2,     0x1.54c62c7fe091p+0,  -0x1.d587cap-3, INEXACT)
T(RN,    0x1.038684b8ffc94p+2,    0x1.543a6cff7b923p+0,   0x1.9a578cp-2, INEXACT)
T(RN,    0x1.0125680d12e47p+2,    0x1.53ad88946ac12p+0,  -0x1.865da6p-2, INEXACT)
T(RN,    0x1.fd93c1f526de2p+1,    0x1.531f7d84d263bp+0,  -0x1.667f06p-5, INEXACT)
T(RN,     0x1.f8e7c4cc6898p+1,    0x1.52904a18e041bp+0,   0x1.a7695cp-3, INEXACT)
T(RN,    0x1.f446bea6d6ab9p+1,     0x1.51ffec9af247p+0,    0x1.98033p-2, INEXACT)
T(RN,    0x1.efb095c85256ap+1,    0x1.516e6357be0a8p+0,   0x1.faa4fep-2, INEXACT)
T(RN,    0x1.eb2530b1234dcp+1,    0x1.50dbac9e793cep+0,    0x1.a3e04p-2, INEXACT)
T(RN,    0x1.e6a4761d69f9cp+1,     0x1.5047c6c10301p+0,  -0x1.408eeep-6, INEXACT)
T(RN,     0x1.e22e4d049301p+1,    0x1.4fb2b0140e2fcp+0,   0x1.0ebf72p-5, INEXACT)
T(RN,    0x1.ddc29c98cc1bcp+1,     0x1.4f1c66ef4c89p+0,  -0x1.33e586p-2, INEXACT)
T(RN,    0x1.d9614c467a2ddp+1,    0x1.4e84e9ad9ad3cp+0,   0x1.15615ap-4, INEXACT)
T(RN,    0x1.d50a43b3b0a4cp+1,    0x1.4dec36ad2dee4p+0,  -0x1.12ac28p-2, INEXACT)
T(RN,    0x1.d0bd6abfaa16ep+1,    0x1.4d524c4fc0d08p+0,  -0x1.09a068p-3, INEXACT)
T(RN,    0x1.cc7aa982421eep+1,     0x1.4cb728fac381p+0,    0x1.6955dp-2, INEXACT)
T(RN,    0x1.c841e84b70733p+1,    0x1.4c1acb178afdep+0,  -0x1.5ef64ap-2, INEXACT)
T(RN,    0x1.c4130fa2c535ep+1,    0x1.4b7d3113821b5p+0,   0x1.58b15ap-3, INEXACT)
T(RN,    0x1.bfee0846e6779p+1,    0x1.4ade59605b567p+0,  -0x1.0e8692p-2, INEXACT)
T(RN,    0x1.bbd2bb2d0eeeep+1,    0x1.4a3e4274439fbp+0,   0x1.902136p-2, INEXACT)
T(RN,     0x1.b7c111808ddep+1,    0x1.499ceaca161a6p+0,   0x1.da41a2p-2, INEXACT)
T(RN,     0x1.b3b8f4a24825p+1,    0x1.48fa50e190d3ap+0,   0x1.8426eap-3, INEXACT)
T(RN,    0x1.afba4e283a7eep+1,    0x1.4856733f8a6f6p+0,  -0x1.ac8f68p-2, INEXACT)
T(RN,    0x1.abc507dcfce47p+1,    0x1.47b1506e28cb8p+0,   0x1.e71318p-2, INEXACT)
T(RN,    0x1.a7d90bbf4714cp+1,    0x1.470ae6fd18981p+0,  -0x1.c384f2p-3, INEXACT)
T(RN,    0x1.a3f64401763f4p+1,    0x1.46633581c5e55p+0,  -0x1.e66aecp-5, INEXACT)
T(RN,    0x1.a01c9b0913cc4p+1,    0x1.45ba3a9795a3fp+0,  -0x1.1e6a28p-2, INEXACT)
T(RN,    0x1.9c4bfb6e5d42ep+1,    0x1.450ff4e02018bp+0,   0x1.1e6f9ep-2, INEXACT)
T(RN,    0x1.98844ffbcd481p+1,    0x1.446463036c3fdp+0,   0x1.484978p-2, INEXACT)
T(RN,    0x1.94c583ada5b53p+1,    0x1.43b783b02c1fdp+0,  -0x1.36722ap-3, INEXACT)
T(RN,    0x1.910f81b17ac44p+1,    0x1.4309559bfa08ap+0,   0x1.b153e8p-2, INEXACT)
T(RN,    0x1.8d623565bf4c7p+1,    0x1.4259d78396bc2p+0,   0x1.045a2ap-6, INEXACT)
T(RN,      0x1.89bd8a59521p+1,    0x1.41a9082b287edp+0,   0x1.2e8de4p-3, INEXACT)
T(RN,    0x1.86216c4b0c16fp+1,    0x1.40f6e65e7b0b9p+0,   -0x1.0ae8fp-4, INEXACT)
T(RN,    0x1.828dc7295013ap+1,    0x1.404370f140684p+0,  -0x1.4192a8p-4, INEXACT)
T(RN,    0x1.7f0287119ad0ep+1,    0x1.3f8ea6bf5296cp+0,  -0x1.8ef98cp-4, INEXACT)
T(RN,    0x1.7b7f985014a53p+1,    0x1.3ed886acf61e5p+0,   0x1.4fd7b2p-2, INEXACT)
T(RN,    0x1.7804e75f23e95p+1,    0x1.3e210fa71d685p+0,  -0x1.c3507cp-4, INEXACT)
T(RN,    0x1.749260e70070dp+1,    0x1.3d6840a3acec4p+0,    0x1.57396p-4, INEXACT)
T(RN,    0x1.7127f1bd47fffp+1,    0x1.3cae18a1c0241p+0,    0x1.0feebp-3, INEXACT)
T(RN,    0x1.6dc586e493bf1p+1,    0x1.3bf296a9ef449p+0,    0x1.e9019p-4, INEXACT)
T(RN,    0x1.6a6b0d8c0ea82p+1,    0x1.3b35b9ce95b2cp+0,   0x1.7998aep-2, INEXACT)
T(RN,    0x1.6718730f0ceadp+1,    0x1.3a77812c192f4p+0,  -0x1.cfe002p-2, INEXACT)
T(RN,    0x1.63cda4f4a447bp+1,    0x1.39b7ebe931b1dp+0,   -0x1.98168p-5, INEXACT)
T(RN,    0x1.608a90ef455d7p+1,    0x1.38f6f93731eb8p+0,   0x1.00b0a8p-2, INEXACT)
T(RN,    0x1.5d4f24dc55e78p+1,    0x1.3834a85250696p+0,   0x1.13b23ep-2, INEXACT)
T(RN,    0x1.5a1b4ec3cbec3p+1,    0x1.3770f881f14e2p+0,  -0x1.a59b7cp-2, INEXACT)
T(RN,    0x1.56eefcd7c9d63p+1,    0x1.36abe918f099dp+0,   0x1.b96042p-3, INEXACT)
T(RN,    0x1.53ca1d743b797p+1,    0x1.35e57975ecf5fp+0,  -0x1.7d19f4p-6, INEXACT)
T(RN,    0x1.50ac9f1e74006p+1,    0x1.351da90392fd2p+0,   0x1.88651cp-2, INEXACT)
T(RN,    0x1.4d967084ccbe6p+1,    0x1.34547738e8f1ep+0,   0x1.14c008p-4, INEXACT)
T(RN,    0x1.4a87807e44e7ap+1,    0x1.3389e3999adbap+0,   0x1.76814cp-2, INEXACT)
T(RN,    0x1.477fbe0a2229fp+1,    0x1.32bdedb646fc9p+0,  -0x1.bf981ep-4, INEXACT)
T(RN,    0x1.447f184f9225fp+1,    0x1.31f0952cca95ep+0,  -0x1.18982ep-2, INEXACT)
T(RN,     0x1.41857e9d4cc6p+1,    0x1.3121d9a88eec8p+0,  -0x1.7594aap-2, INEXACT)
T(RN,    0x1.3e92e0693770fp+1,    0x1.3051bae2d6823p+0,   -0x1.517f9p-3, INEXACT)
T(RN,    0x1.3ba72d500916ap+1,    0x1.2f8038a30a74cp+0,   -0x1.395fbp-2, INEXACT)
T(RN,    0x1.38c25514ef149p+1,    0x1.2ead52bf07f5cp+0,   0x1.7ade9ep-3, INEXACT)
T(RN,    0x1.35e447a132efcp+1,    0x1.2dd9091b6dcb1p+0,  -0x1.99722ap-2, INEXACT)
T(RN,    0x1.330cf503e0e31p+1,    0x1.2d035babe9ca7p+0,   -0x1.a8485p-2, INEXACT)
T(RN,    0x1.303c4d716f3f2p+1,    0x1.2c2c4a73863eap+0,   0x1.8d028ap-3, INEXACT)
T(RN,    0x1.2d724143669a4p+1,    0x1.2b53d584f726ep+0,   0x1.8c514cp-2, INEXACT)
T(RN,    0x1.2aaec0f80acefp+1,    0x1.2a79fd02e73fdp+0,   0x1.6ab084p-3, INEXACT)
T(RN,    0x1.27f1bd3204c5bp+1,    0x1.299ec12044c39p+0,  -0x1.603516p-3, INEXACT)
T(RN,    0x1.253b26b80d0a1p+1,    0x1.28c222208dcffp+0,  -0x1.512c1ap-2, INEXACT)
T(RN,    0x1.228aee749727cp+1,    0x1.27e420581c5fcp+0,   0x1.5df142p-5, INEXACT)
T(RN,    0x1.1fe105757dce2p+1,    0x1.2704bc2c71c44p+0,  -0x1.9a1e6ap-4, INEXACT)
T(RN,     0x1.1d3d5cebafb9p+1,    0x1.2623f614818bbp+0,  -0x1.2d673cp-2, INEXACT)
T(RN,    0x1.1a9fe62add5cap+1,    0x1.2541ce98fbc07p+0,   0x1.915b5ep-2, INEXACT)
T(RN,    0x1.180892a92751bp+1,    0x1.245e4654966bdp+0,   0x1.db5d82p-2, INEXACT)
T(RN,    0x1.157753fecd829p+1,    0x1.23795df456492p+0,  -0x1.bdf28cp-3, INEXACT)
T(RN,    0x1.12ec1be5df14bp+1,    0x1.22931637d691dp+0,   0x1.79c70cp-2, INEXACT)
T(RN,    0x1.1066dc39eb0edp+1,    0x1.21ab6ff18fcd5p+0,   0x1.3debb6p-3, INEXACT)
T(RN,    0x1.0de786f7b1b93p+1,    0x1.20c26c071d8f3p+0,  -0x1.e51cbep-2, INEXACT)
T(RN,    0x1.0b6e0e3cd6b64p+1,    0x1.1fd80b71830b9p+0,    0x1.e6476p-4, INEXACT)
T(RN,    0x1.08fa644793d25p+1,    0x1.1eec4f3d6e6b1p+0,   -0x1.de4d6p-4, INEXACT)
T(RN,    0x1.068c7b766c885p+1,    0x1.1dff388b7ac7ap+0,  -0x1.262cc6p-7, INEXACT)
T(RN,    0x1.04244647e239cp+1,    0x1.1d10c89070b8cp+0,  -0x1.992598p-2, INEXACT)
T(RN,    0x1.01c1b75a29198p+1,    0x1.1c2100958558ep+0,  0x1.bab1aap-14, INEXACT)
T(RN,    0x1.fec982d5bb8b1p+0,    0x1.1b2fe1f897a96p+0,  -0x1.00e19cp-4, INEXACT)
T(RN,    0x1.fa1aaead77201p+0,    0x1.1a3d6e2c6c3e6p+0,  -0x1.c23b8ap-4, INEXACT)
T(RN,    0x1.f576d832a6eb2p+0,    0x1.1949a6b8e7183p+0,    0x1.45ba6p-2, INEXACT)
T(RN,    0x1.f0dde599877c7p+0,    0x1.18548d3b43916p+0,  -0x1.e5e8b6p-2, INEXACT)
T(RN,    0x1.ec4fbd52e0921p+0,     0x1.175e23664a49p+0,   0x1.68a86cp-3, INEXACT)
T(RN,     0x1.e7cc460b76ffp+0,    0x1.16666b0284eddp+0,  -0x1.b4d16ap-2, INEXACT)
T(RN,    0x1.e35366ab7fdf5p+0,    0x1.156d65ee6fd31p+0,   0x1.32f636p-3, INEXACT)
T(RN,    0x1.dee506561517fp+0,    0x1.1473161ea9333p+0,   0x1.96fe4ap-3, INEXACT)
T(RN,    0x1.da810c68ab1c8p+0,    0x1.13777d9e1e086p+0,   0x1.702bfep-4, INEXACT)
T(RN,    0x1.d627607a87faap+0,    0x1.127a9e8e34607p+0,  -0x1.cd5e28p-6, INEXACT)
T(RN,    0x1.d1d7ea5c3ba5fp+0,    0x1.117c7b26f312cp+0,  -0x1.a16ba8p-4, INEXACT)
T(RN,    0x1.cd9292171982dp+0,    0x1.107d15b726befp+0,   0x1.f3f0aep-2, INEXACT)
T(RN,    0x1.c9573fecb32d6p+0,    0x1.0f7c70a483fafp+0,   0x1.c897ecp-2, INEXACT)
T(RN,    0x1.c525dc565477cp+0,    0x1.0e7a8e6bc6978p+0,   0x1.db4416p-2, INEXACT)
T(RN,    0x1.c0fe5004809f8p+0,    0x1.0d7771a0cde23p+0,   0x1.fdcb62p-2, INEXACT)
T(RN,    0x1.bce083de70b54p+0,    0x1.0c731ceeb5cc8p+0,  -0x1.d880cep-5, INEXACT)
T(RN,    0x1.b8cc61019334dp+0,    0x1.0b6d9317ece04p+0,   0x1.d5e986p-4, INEXACT)
T(RN,    0x1.b4c1d0c10cca9p+0,    0x1.0a66d6f646e8dp+0,  -0x1.bb3112p-3, INEXACT)
T(RN,    0x1.b0c0bca53a438p+0,    0x1.095eeb7b0c3b2p+0,   0x1.bb8f7ap-2, INEXACT)
T(RN,    0x1.acc90e6b33a4bp+0,    0x1.0855d3af05844p+0,  -0x1.0fb45cp-2, INEXACT)
T(RN,    0x1.a8dab00450691p+0,    0x1.074b92b2840a8p+0,  -0x1.bc7e32p-5, INEXACT)
T(RN,    0x1.a4f58b95ace04p+0,     0x1.06402bbd6649p+0,   0x1.a9c9b8p-6, INEXACT)
T(RN,    0x1.a1198b77b0ae3p+0,    0x1.0533a21f18d35p+0,  -0x1.41ebd4p-3, INEXACT)
T(RN,    0x1.9d469a3596678p+0,    0x1.0425f93e936bbp+0,   0x1.aa223ap-5, INEXACT)
T(RN,    0x1.997ca28cf448dp+0,    0x1.0317349a52391p+0,   0x1.766522p-5, INEXACT)
T(RN,    0x1.95bb8f6d46054p+0,    0x1.020757c84b0a8p+0,   0x1.642ceap-3, INEXACT)
T(RN,    0x1.92034bf777ab3p+0,    0x1.00f66675de969p+0,   0x1.f31eeap-2, INEXACT)
T(RN,    0x1.8e53c37d719b9p+0,    0x1.ffc8c8cf8b4c2p-1,  -0x1.6bb396p-3, INEXACT)
T(RN,    0x1.8aace181a5911p+0,    0x1.fda2aaf3f435dp-1,  -0x1.d2d3c8p-2, INEXACT)
T(RN,    0x1.870e91b69cb62p+0,    0x1.fb7a7b3f3788bp-1,   0x1.cfe49cp-2, INEXACT)
T(RN,    0x1.8378bffe86c53p+0,    0x1.f95041c5a1e6dp-1,  -0x1.231a8ap-3, INEXACT)
T(RN,    0x1.7feb586aca32ap+0,    0x1.f72406c945882p-1,  -0x1.e3335ep-2, INEXACT)
T(RN,     0x1.7c66473b955dp+0,    0x1.f4f5d2b9aa1eap-1,  -0x1.b414e4p-3, INEXACT)
T(RN,    0x1.78e978df70c14p+0,    0x1.f2c5ae3373fa9p-1,  -0x1.58f57ap-2, INEXACT)
T(RN,    0x1.7574d9f2d230ap+0,    0x1.f093a200025e2p-1,   0x1.34935cp-3, INEXACT)
T(RN,    0x1.7208573fb105fp+0,    0x1.ee5fb71504f24p-1,   0x1.f2471ep-4, INEXACT)
T(RN,     0x1.6ea3ddbd1b58p+0,    0x1.ec29f6940852dp-1,  -0x1.265412p-4, INEXACT)
T(RN,    0x1.6b475a8ecc268p+0,    0x1.e9f269c9f9a93p-1,  -0x1.ecaaf8p-2, INEXACT)
T(RN,    0x1.67f2bb04c27f2p+0,    0x1.e7b91a2ea150fp-1,   0x1.a77402p-2, INEXACT)
T(RN,    0x1.64a5ec9ad9994p+0,    0x1.e57e116414848p-1,   0x1.1e1e1ep-2, INEXACT)
T(RN,    0x1.6160dcf861e51p+0,    0x1.e34159361e13ep-1,  -0x1.f49aa4p-5, INEXACT)
T(RN,    0x1.5e2379efbb0c9p+0,    0x1.e102fb999e28ep-1,    0x1.b123bp-6, INEXACT)
T(RN,    0x1.5aedb17deee38p+0,    0x1.dec302abe1211p-1,   0x1.47a02ep-2, INEXACT)
T(RN,    0x1.57bf71ca4d453p+0,    0x1.dc8178b1ed893p-1,   0x1.799536p-2, INEXACT)
T(RN,    0x1.5498a92608dcap+0,    0x1.da3e6817c9479p-1,   0x1.0c60acp-2, INEXACT)
T(RN,    0x1.5179460bd4d61p+0,    0x1.d7f9db6fb6081p-1,   0x1.e95f6cp-2, INEXACT)
T(RN,     0x1.4e61371f8377p+0,    0x1.d5b3dd7164fe6p-1,   0x1.056262p-4, INEXACT)
T(RN,    0x1.4b506b2da59abp+0,    0x1.d36c78f92217cp-1,  -0x1.a943ecp-4, INEXACT)
T(RN,    0x1.4846d12b2b11ap+0,    0x1.d123b906f6b83p-1,   0x1.69deaep-2, INEXACT)
T(RN,    0x1.4544583503e0ep+0,    0x1.ced9a8bdc4224p-1,  -0x1.f2a016p-3, INEXACT)
T(RN,    0x1.4248ef8fc2604p+0,    0x1.cc8e536255addp-1,   0x1.a09dd8p-2, INEXACT)
T(RN,    0x1.3f5486a73e34bp+0,    0x1.ca41c45a6af26p-1,   0x1.ad1484p-6, INEXACT)
T(RN,    0x1.3c670d0e3824bp+0,    0x1.c7f4072bba10bp-1,  -0x1.539e2ap-2, INEXACT)
T(RN,    0x1.3980727dfec5bp+0,    0x1.c5a5277aea47ep-1,  -0x1.71fc1ep-2, INEXACT)
T(RN,    0x1.36a0a6d613ff3p+0,    0x1.c355310a8706dp-1,   0x1.c4e09ap-2, INEXACT)
T(RN,    0x1.33c79a1bd3625p+0,    0x1.c1042fb9ebadap-1,    0x1.368d8p-3, INEXACT)
T(RN,    0x1.30f53c7a19547p+0,    0x1.beb22f842837bp-1,   0x1.078de6p-3, INEXACT)
T(RN,    0x1.2e297e40eb095p+0,    0x1.bc5f3c7edf05fp-1,   0x1.06823ep-3, INEXACT)
T(RN,    0x1.2b644fe51f4cap+0,    0x1.ba0b62d91c098p-1,   0x1.fc577ep-5, INEXACT)
T(RN,    0x1.28a5a2000817bp+0,    0x1.b7b6aeda258d6p-1,   -0x1.ee062p-7, INEXACT)
T(RN,    0x1.25ed654f1cf27p+0,    0x1.b5612ce046e39p-1,    0x1.c8675p-2, INEXACT)
T(RN,    0x1.233b8ab3a61d1p+0,    0x1.b30ae95f953afp-1,   0x1.527fb4p-2, INEXACT)
T(RN,    0x1.2090033268808p+0,    0x1.b0b3f0e0aee75p-1,  -0x1.4e34aap-3, INEXACT)
T(RN,    0x1.1deabff352651p+0,    0x1.ae5c4fff7567ap-1,   0x1.f39c28p-2, INEXACT)
T(RN,    0x1.1b4bb24128ebbp+0,    0x1.ac041369c276ap-1,  -0x1.2c7626p-6, INEXACT)
T(RN,    0x1.18b2cb8936492p+0,    0x1.a9ab47de18788p-1,   0x1.af7148p-2, INEXACT)
T(RN,    0x1.161ffd5af8c17p+0,    0x1.a751fa2a4e964p-1,  -0x1.9d711ep-3, INEXACT)
T(RN,    0x1.13933967d2612p+0,    0x1.a4f8372a38dcbp-1,   0x1.39089cp-2, INEXACT)
T(RN,    0x1.110c7182b972ep+0,    0x1.a29e0bc64cb43p-1,   0x1.b3ecc6p-2, INEXACT)
T(RN,    0x1.0e8b979fe9b01p+0,    0x1.a04384f2420b3p-1,   0x1.9b62b6p-4, INEXACT)
T(RN,     0x1.0c109dd4962ap+0,    0x1.9de8afabb18bep-1,  -0x1.510d3ap-6, INEXACT)
T(RN,    0x1.099b76569beafp+0,    0x1.9b8d98f8b0396p-1,  -0x1.ae8922p-4, INEXACT)
T(RN,    0x1.072c137c354bfp+0,    0x1.99324de668d02p-1,   0x1.fa5966p-6, INEXACT)
T(RN,    0x1.04c267bbadff6p+0,    0x1.96d6db87b3483p-1,   0x1.5c66dep-3, INEXACT)
T(RN,    0x1.025e65ab17cd2p+0,    0x1.947b4ef3aad71p-1,  -0x1.6957a6p-4, INEXACT)
T(RN,                  0x1p+0,    0x1.921fb54442d18p-1,  -0x1.1a6264p-2, INEXACT)
T(RN,    0x1.fb4e531e4b039p-1,    0x1.8fc41b94dacc1p-1,   0x1.e9ee34p-2, INEXACT)
T(RN,    0x1.f6a7aa985f492p-1,    0x1.8d688f00d25afp-1,   0x1.e4292ap-3, INEXACT)
T(RN,    0x1.f20bec92cb312p-1,    0x1.8b0d1ca21cd2fp-1,  -0x1.e16e9cp-3, INEXACT)
T(RN,    0x1.ed7aff6ecd16ep-1,    0x1.88b1d18fd569bp-1,  -0x1.1e4ab6p-3, INEXACT)
T(RN,    0x1.e8f4c9c9c4e1cp-1,    0x1.8656badcd4174p-1,    0x1.969bdp-2, INEXACT)
T(RN,    0x1.e479327ca6e3cp-1,    0x1.83fbe5964397fp-1,  -0x1.2b6bf6p-2, INEXACT)
T(RN,    0x1.e008209b70042p-1,    0x1.81a15ec238eefp-1,   0x1.f7e116p-3, INEXACT)
T(RN,    0x1.dba17b749b31cp-1,    0x1.7f47335e4cc67p-1,   0x1.0e37fcp-2, INEXACT)
T(RN,    0x1.d7452a90981a7p-1,    0x1.7ced705e370cdp-1,  -0x1.d2b968p-4, INEXACT)
T(RN,    0x1.d2f315b143252p-1,    0x1.7a9422aa6d2aap-1,    0x1.d1771p-5, INEXACT)
T(RN,    0x1.ceab24d15eaacp-1,    0x1.783b571ec32c7p-1,  -0x1.e372fcp-2, INEXACT)
T(RN,    0x1.ca6d40240d6bdp-1,    0x1.75e31a89103b7p-1,  -0x1.9abcc2p-2, INEXACT)
T(RN,    0x1.c63950144e3f1p-1,    0x1.738b79a7d6bbcp-1,  -0x1.5babe4p-2, INEXACT)
T(RN,    0x1.c20f3d4478f6dp-1,    0x1.71348128f0683p-1,  -0x1.381782p-3, INEXACT)
T(RN,    0x1.bdeef08dbc7a5p-1,    0x1.6ede3da83ebf9p-1,   0x1.a305d2p-2, INEXACT)
T(RN,    0x1.b9d852ff9e0f7p-1,    0x1.6c88bbae6015cp-1,   0x1.dd2424p-2, INEXACT)
T(RN,    0x1.b5cb4ddf79d2ep-1,    0x1.6a3407af6999ap-1,   0x1.7bf14ep-4, INEXACT)
T(RN,    0x1.b1c7caa8045b7p-1,    0x1.67e02e09a69d3p-1,   0x1.e2f7f4p-2, INEXACT)
T(RN,     0x1.adcdb308cd86p-1,    0x1.658d3b045d6b6p-1,  -0x1.97ca86p-4, INEXACT)
T(RN,    0x1.a9dcf0e5c4678p-1,    0x1.633b3ace99f57p-1,  -0x1.f093d8p-3, INEXACT)
T(RN,    0x1.a5f56e56bc619p-1,    0x1.60ea397dfe9c6p-1,   0x1.ea6f94p-2, INEXACT)
T(RN,    0x1.a21715a6f3582p-1,    0x1.5e9a430d9b5b3p-1,   0x1.a8650cp-5, INEXACT)
T(RN,    0x1.9e41d1549904ep-1,    0x1.5c4b635ccb926p-1,   0x1.c7883cp-5, INEXACT)
T(RN,    0x1.9a758c105765ap-1,    0x1.59fda62e1ab0cp-1,   0x1.001ccap-6, INEXACT)
T(RN,    0x1.96b230bcdc435p-1,    0x1.57b117262ff55p-1,   0x1.f900b8p-3, INEXACT)
T(RN,    0x1.92f7aa6e63cf9p-1,    0x1.5565c1cac180dp-1,  -0x1.2b95f8p-2, INEXACT)
T(RN,    0x1.8f45e46a44552p-1,    0x1.531bb1818eeafp-1,   0x1.2bf678p-2, INEXACT)
T(RN,    0x1.8b9cca267af9cp-1,    0x1.50d2f18f638b5p-1,    0x1.9dde4p-8, INEXACT)
T(RN,    0x1.87fc4749398e5p-1,    0x1.4e8b8d1720a4cp-1,   0x1.98fc8cp-3, INEXACT)
T(RN,    0x1.846447a8756aep-1,    0x1.4c458f18cf9b1p-1,  -0x1.e42668p-4, INEXACT)
T(RN,    0x1.80d4b74977549p-1,    0x1.4a010270bc5b9p-1,   -0x1.c30c2p-4, INEXACT)
T(RN,    0x1.7d4d82606c6a5p-1,    0x1.47bdf1d69819fp-1,   0x1.eeac54p-5, INEXACT)
T(RN,    0x1.79ce954ff8168p-1,    0x1.457c67dca4821p-1,   0x1.d992ccp-2, INEXACT)
T(RN,    0x1.7657dca8c702ap-1,    0x1.433c6eeee77a4p-1,   0x1.cdb32cp-2, INEXACT)
T(RN,    0x1.72e94529230b2p-1,    0x1.40fe1152678f3p-1,   -0x1.1671dp-2, INEXACT)
T(RN,    0x1.6f82bbbc8830cp-1,    0x1.3ec15924711eap-1,   0x1.68f242p-3, INEXACT)
T(RN,    0x1.6c242d7b3a854p-1,    0x1.3c865059e4523p-1,  -0x1.89dce2p-4, INEXACT)
T(RN,    0x1.68cd87a9dd10dp-1,    0x1.3a4d00be8bf9ep-1,  -0x1.2c6c62p-2, INEXACT)
T(RN,    0x1.657eb7b909ae6p-1,    0x1.381573f47d504p-1,  -0x1.bf550ap-3, INEXACT)
T(RN,    0x1.6237ab44e9dc6p-1,    0x1.35dfb37380b0dp-1,  -0x1.75acaep-2, INEXACT)
T(RN,    0x1.5ef85014d07fap-1,     0x1.33abc8888345p-1,   0x1.3af854p-2, INEXACT)
T(RN,     0x1.5bc0941ad496p-1,    0x1.3179bc5511a88p-1,   -0x1.71c0ep-2, INEXACT)
T(RN,     0x1.589065736cd7p-1,    0x1.2f4997cedb847p-1,  -0x1.a58606p-3, INEXACT)
T(RN,    0x1.5567b2650c402p-1,    0x1.2d1b63bf401afp-1,   0x1.52419cp-6, INEXACT)
T(RN,    0x1.5246695fbf8a3p-1,    0x1.2aef28c2e3bc4p-1,   -0x1.22537p-4, INEXACT)
T(RN,    0x1.4f2c78fccb866p-1,    0x1.28c4ef494e1a7p-1,   0x1.0a757ep-3, INEXACT)
T(RN,    0x1.4c19cffe4c5ffp-1,    0x1.269cbf94916d4p-1,   0x1.2d5aa8p-3, INEXACT)
T(RN,    0x1.490e5d4ed5c19p-1,    0x1.2476a1b8fa56fp-1,  -0x1.94a846p-2, INEXACT)
T(RN,    0x1.460a100113db5p-1,     0x1.22529d9cc876p-1,  -0x1.a3d42cp-4, INEXACT)
T(RN,    0x1.430cd74f6d478p-1,    0x1.2030baf7ef8e2p-1,   0x1.ed9746p-3, INEXACT)
T(RN,    0x1.4016a29ba5cc9p-1,     0x1.1e110153e131p-1,   0x1.47a78ap-3, INEXACT)
T(RN,    0x1.3d27616e81f99p-1,    0x1.1bf3780b5ecbbp-1,  -0x1.8beb9ep-2, INEXACT)
T(RN,    0x1.3a3f03776b9bfp-1,    0x1.19d8264a53fc7p-1,  -0x1.899a72p-6, INEXACT)
T(RN,    0x1.375d788c170bcp-1,    0x1.17bf130db9111p-1,  -0x1.832a5cp-2, INEXACT)
T(RN,    0x1.3482b0a8294ccp-1,    0x1.15a845237d8e1p-1,  -0x1.d62b5ap-3, INEXACT)
T(RN,    0x1.31ae9becdf02ap-1,    0x1.1393c32a7a9a8p-1,  -0x1.62e40ap-2, INEXACT)
T(RN,    0x1.2ee12aa0b4365p-1,    0x1.118193926d2cfp-1,   0x1.52de68p-2, INEXACT)
T(RN,    0x1.2c1a4d2f0ce9dp-1,    0x1.0f71bc9bf7d17p-1,   0x1.ecf2d4p-2, INEXACT)
T(RN,    0x1.2959f427de7a1p-1,    0x1.0d644458abe2ap-1,    0x1.0b64bp-2, INEXACT)
T(RN,    0x1.26a0103f59cb3p-1,    0x1.0b5930ab1a0a1p-1,  -0x1.4b869ap-3, INEXACT)
T(RN,    0x1.23ec924d963f1p-1,    0x1.09508746e9decp-1,  -0x1.d29e76p-2, INEXACT)
T(RN,    0x1.213f6b4e3d72ap-1,    0x1.074a4db0f8742p-1,  -0x1.ebd3dep-3, INEXACT)
T(RN,    0x1.1e988c6037c1ap-1,    0x1.0546893f7dad4p-1,  -0x1.da73d6p-2, INEXACT)
T(RN,    0x1.1bf7e6c5598ddp-1,    0x1.03453f1a38254p-1,   0x1.5c326ep-3, INEXACT)
T(RN,    0x1.195d6be21148ep-1,    0x1.0146743a9f7dap-1,   0x1.04e01cp-2, INEXACT)
T(RN,    0x1.16c90d3d163dep-1,    0x1.fe945ad839c47p-2,  -0x1.0340d6p-3, INEXACT)
T(RN,    0x1.143abc7f181a3p-1,    0x1.faa0de989324cp-2,   0x1.f12e7ep-2, INEXACT)
T(RN,    0x1.11b26b726f32bp-1,    0x1.f6b27c9666797p-2,  -0x1.ec0012p-2, INEXACT)
T(RN,    0x1.0f300c02cd848p-1,     0x1.f2c93d574bfap-2,   0x1.837d3ep-3, INEXACT)
T(RN,    0x1.0cb3903cf06e9p-1,    0x1.eee52906f78eep-2,  -0x1.df3fbep-5, INEXACT)
T(RN,    0x1.0a3cea4e53239p-1,    0x1.eb064777e2223p-2,   0x1.67bf16p-4, INEXACT)
T(RN,    0x1.07cc0c84e1d19p-1,    0x1.e72ca023fd009p-2,  -0x1.978c04p-3, INEXACT)
T(RN,    0x1.0560e94ead7dep-1,    0x1.e3583a2d6ee59p-2,   0x1.c740fep-2, INEXACT)
T(RN,     0x1.02fb7339a094p-1,    0x1.df891c5f5a4cbp-2,  -0x1.90b53cp-3, INEXACT)
T(RN,    0x1.009b9cf334253p-1,    0x1.dbbf4d2eaca0bp-2,  -0x1.2d68c8p-3, INEXACT)
T(RN,    0x1.fc82b2904bafdp-2,    0x1.d7fad2baf5e2ap-2,   0x1.3f4eb6p-7, INEXACT)
T(RN,    0x1.f7d936485d099p-2,     0x1.d43bb2cf4863p-2,  -0x1.b19754p-3, INEXACT)
T(RN,    0x1.f33aab2372ffdp-2,    0x1.d081f2e32027bp-2,   -0x1.de4e8p-2, INEXACT)
T(RN,    0x1.eea6f7733919ap-2,    0x1.cccd981b5199ep-2,   0x1.c043b8p-2, INEXACT)
T(RN,    0x1.ea1e01c5a0f71p-2,    0x1.c91ea74aff17ep-2,  -0x1.e0a15ep-2, INEXACT)
T(RN,    0x1.e59fb0e454da9p-2,    0x1.c57524f495095p-2,    0x1.f10d7p-3, INEXACT)
T(RN,    0x1.e12bebd42b7dfp-2,    0x1.c1d1154acc10fp-2,  -0x1.c0ea58p-2, INEXACT)
T(RN,    0x1.dcc299d49d30cp-2,    0x1.be327c31b0ff1p-2,   0x1.ce1d58p-2, INEXACT)
T(RN,    0x1.d863a25f3a3c7p-2,    0x1.ba995d3fb221ap-2,  -0x1.5ee516p-4, INEXACT)
T(RN,    0x1.d40eed27228b7p-2,     0x1.b705bbbeb197p-2,   -0x1.88e05p-4, INEXACT)
T(RN,    0x1.cfc462187e907p-2,    0x1.b3779aad1c448p-2,  -0x1.cf63d2p-2, INEXACT)
T(RN,    0x1.cb83e957f96a8p-2,    0x1.afeefcbf05175p-2,   0x1.79c4aap-2, INEXACT)
T(RN,    0x1.c74d6b423c435p-2,    0x1.ac6be45f44352p-2,  -0x1.a7f142p-2, INEXACT)
T(RN,    0x1.c320d06b6ae55p-2,    0x1.a8ee53b099c72p-2,  -0x1.d02864p-2, INEXACT)
T(RN,    0x1.befe019ea1856p-2,    0x1.a5764c8ed4064p-2,  -0x1.cf8e42p-2, INEXACT)
T(RN,    0x1.bae4e7dd73becp-2,    0x1.a203d08ff837ep-2,  -0x1.727f46p-5, INEXACT)
T(RN,    0x1.b6d56c5f6cbd9p-2,     0x1.9e96e1056e47p-2,  -0x1.139e9ep-4, INEXACT)
T(RN,    0x1.b2cf789190955p-2,    0x1.9b2f7efd2eaacp-2,   0x1.8fad7ap-5, INEXACT)
T(RN,    0x1.aed2f615dec0ep-2,    0x1.97cdab42f24bcp-2,   0x1.74fa2cp-2, INEXACT)
T(RN,    0x1.aadfcec2d5c8cp-2,    0x1.94716661641c5p-2,   0x1.7ec208p-2, INEXACT)
T(RN,    0x1.a6f5eca2f80d4p-2,    0x1.911ab0a35419cp-2,  -0x1.9bc89ap-2, INEXACT)
T(RN,    0x1.a31539f451b21p-2,    0x1.8dc98a14eb6f2p-2,  -0x1.ad4788p-2, INEXACT)
T(RN,    0x1.9f3da127ffa85p-2,    0x1.8a7df284e1731p-2,   -0x1.a3646p-2, INEXACT)
T(RN,    0x1.9b6f0ce1b7d3ep-2,    0x1.8737e985b13d6p-2,  -0x1.d55c8cp-2, INEXACT)
T(RN,    0x1.97a967f7524b3p-2,    0x1.83f76e6ecf941p-2,   0x1.8c32a2p-4, INEXACT)
T(RN,    0x1.93ec9d7053accp-2,    0x1.80bc805de0ee9p-2,   0x1.178ce8p-2, INEXACT)
T(RN,    0x1.9038988578892p-2,    0x1.7d871e37ef53dp-2,  -0x1.c53fbep-3, INEXACT)
T(RN,    0x1.8c8d44a041dedp-2,    0x1.7a5746aa9fd7dp-2,   0x1.fe6ba2p-2, INEXACT)
T(RN,    0x1.88ea8d5a82a49p-2,    0x1.772cf82d677ebp-2,  -0x1.caec34p-2, INEXACT)
T(RN,    0x1.85505e7dee615p-2,    0x1.74083102bf51cp-2,  -0x1.5a981cp-2, INEXACT)
T(RN,    0x1.81bea403a8cd9p-2,    0x1.70e8ef39576e6p-2,   0x1.6df84cp-2, INEXACT)
T(RN,    0x1.7e354a13d67c9p-2,     0x1.6dcf30ad48dfp-2,    0x1.6c2b4p-3, INEXACT)
T(RN,    0x1.7ab43d052e8afp-2,    0x1.6abaf309460d8p-2,  -0x1.6906dep-3, INEXACT)
T(RN,    0x1.773b695c8d50ap-2,    0x1.67ac33c7c9a0cp-2,   0x1.d949dcp-2, INEXACT)
T(RN,    0x1.73cabbcc88124p-2,    0x1.64a2f03443984p-2,   0x1.997894p-3, INEXACT)
T(RN,    0x1.7062213501b23p-2,    0x1.619f256c447eep-2,   0x1.e2a968p-3, INEXACT)
T(RN,    0x1.6d0186a2c05c1p-2,    0x1.5ea0d060a688fp-2,  -0x1.5e3b24p-2, INEXACT)
T(RN,     0x1.69a8d94f042bp-2,    0x1.5ba7edd6b47b4p-2,   -0x1.4c8e6p-4, INEXACT)
T(RN,     0x1.6658069f1ec6p-2,    0x1.58b47a694e33fp-2,  -0x1.c27304p-3, INEXACT)
T(RN,    0x1.630efc240bf23p-2,    0x1.55c6728a0ab5fp-2,   0x1.2017ccp-3, INEXACT)
T(RN,    0x1.5fcda79a0b17fp-2,    0x1.52ddd28257953p-2,   0x1.50ec78p-3, INEXACT)
T(RN,    0x1.5c93f6e839b74p-2,    0x1.4ffa967495a4ep-2,  -0x1.f23012p-7, INEXACT)
T(RN,    0x1.5961d8202ecbdp-2,    0x1.4d1cba5d32ccfp-2,  -0x1.d6ac46p-2, INEXACT)
T(RN,    0x1.5637397d971d1p-2,    0x1.4a443a13c0eb2p-2,  -0x1.283098p-3, INEXACT)
T(RN,     0x1.53140965d277p-2,    0x1.4771114c09a53p-2,   -0x1.1f90bp-2, INEXACT)
T(RN,    0x1.4ff8366791cc2p-2,    0x1.44a33b971f17ep-2,   -0x1.0992ap-3, INEXACT)
T(RN,     0x1.4ce3af3a763dp-2,    0x1.41dab464694afp-2,   0x1.301628p-2, INEXACT)
T(RN,    0x1.49d662beb1024p-2,    0x1.3f177702b055ap-2,  -0x1.478996p-2, INEXACT)
T(RN,    0x1.46d03ffca4399p-2,    0x1.3c597ea12323cp-2,   0x1.e2be54p-4, INEXACT)
T(RN,     0x1.43d136248491p-2,    0x1.39a0c6505ac6ep-2,   0x1.357722p-3, INEXACT)
T(RN,    0x1.40d9348dfbd02p-2,     0x1.36ed49035a47p-2,   0x1.8ad342p-2, INEXACT)
T(RN,    0x1.3de82ab7cc3d2p-2,    0x1.343f01908ae38p-2,   0x1.484df8p-2, INEXACT)
T(RN,    0x1.3afe084774d99p-2,    0x1.3195eab2b4b64p-2,   -0x1.9a2eep-2, INEXACT)
T(RN,    0x1.381abd08d678bp-2,    0x1.2ef1ff09f3b0ep-2,  -0x1.75cf8ep-3, INEXACT)
T(RN,    0x1.353e38edd9a94p-2,    0x1.2c53391ca8e5ep-2,   0x1.9b9d14p-3, INEXACT)
T(RN,    0x1.32686c0e1573dp-2,    0x1.29b9935868184p-2,  -0x1.6e0a46p-3, INEXACT)
T(RN,    0x1.2f9946a676ea8p-2,    0x1.27250812e1889p-2,   0x1.e154f6p-3, INEXACT)
T(RN,    0x1.2cd0b918e9878p-2,    0x1.2495918ac7f7bp-2,  -0x1.4a7fc6p-3, INEXACT)
T(RN,    0x1.2a0eb3ec005a3p-2,    0x1.220b29e8b2dccp-2,  -0x1.1e131ap-5, INEXACT)
T(RN,    0x1.275327ca9fffep-2,    0x1.1f85cb3ffcc78p-2,   0x1.748fb4p-8, INEXACT)
T(RN,    0x1.249e0583a965ap-2,    0x1.1d056f8f9dec6p-2,   0x1.524ef6p-2, INEXACT)
T(RN,    0x1.21ef3e09a5533p-2,    0x1.1a8a10c302d8fp-2,   0x1.ca9ec6p-2, INEXACT)
T(RN,    0x1.1f46c27270bbdp-2,    0x1.1813a8b2df4e8p-2,  -0x1.ea0b68p-3, INEXACT)
T(RN,    0x1.1ca483f6e9d2ep-2,    0x1.15a23125fd423p-2,  -0x1.8e189cp-2, INEXACT)
T(RN,    0x1.1a0873f29de44p-2,    0x1.1335a3d208041p-2,  -0x1.b2dff2p-7, INEXACT)
T(RN,    0x1.177283e377ec7p-2,    0x1.10cdfa5c538d1p-2,  -0x1.83dcdap-2, INEXACT)
T(RN,    0x1.14e2a5696ff02p-2,    0x1.0e6b2e5a9ff73p-2,    0x1.b7a83p-3, INEXACT)
T(RN,    0x1.1258ca463b11bp-2,    0x1.0c0d3953d9221p-2,    0x1.b6023p-3, INEXACT)
T(RN,    0x1.0fd4e45cfc612p-2,    0x1.09b414c0d2872p-2,   0x1.1252bcp-2, INEXACT)
T(RN,    0x1.0d56e5b1f666ap-2,    0x1.075fba0cff422p-2,  -0x1.1bcd82p-4, INEXACT)
T(RN,    0x1.0adec06a3d651p-2,    0x1.051022972652cp-2,  -0x1.3ad7bep-4, INEXACT)
T(RN,    0x1.086c66cb6a52dp-2,    0x1.02c547b2131c4p-2,  -0x1.290922p-5, INEXACT)
T(RN,    0x1.05ffcb3b4e87ep-2,    0x1.007f22a5422a3p-2,  -0x1.8ac638p-3, INEXACT)
T(RN,    0x1.0398e03fa81e5p-2,    0x1.fc7b595b147edp-3,   0x1.2f769ap-2, INEXACT)
T(RN,    0x1.0137987dd704cp-2,    0x1.f801bdfb836ecp-3,  -0x1.c1d27ep-3, INEXACT)
T(RN,    0x1.fdb7cd7525816p-3,     0x1.f391657ec083p-3,  -0x1.e07a22p-2, INEXACT)
T(RN,    0x1.f90b7bb341bddp-3,    0x1.ef2a422639fb1p-3,  -0x1.fe2f4ep-3, INEXACT)
T(RN,    0x1.f46a21bb1820dp-3,    0x1.eacc462312042p-3,  -0x1.26bc48p-2, INEXACT)
T(RN,     0x1.efd3a5ceb7e6p-3,     0x1.e67763974cadp-3,  -0x1.ad5436p-3, INEXACT)
T(RN,    0x1.eb47ee6c9b04dp-3,    0x1.e22b8c96f6d01p-3,   0x1.e07c02p-3, INEXACT)
T(RN,    0x1.e6c6e24f1864ep-3,    0x1.dde8b329460a8p-3,    0x1.c2503p-5, INEXACT)
T(RN,    0x1.e250686bd75d3p-3,    0x1.d9aec949b1d0cp-3,   0x1.adb38cp-5, INEXACT)
T(RN,    0x1.dde467f3447e2p-3,    0x1.d57dc0e905b6ap-3,   -0x1.ddec5p-3, INEXACT)
T(RN,    0x1.d982c85007a2ap-3,    0x1.d1558bee6d001p-3,   -0x1.2e6bfp-2, INEXACT)
T(RN,    0x1.d52b71267b434p-3,     0x1.cd361c38778dp-3,  -0x1.bdc4eap-2, INEXACT)
T(RN,    0x1.d0de4a54250c5p-3,    0x1.c91f639e183a8p-3,  -0x1.4464ccp-3, INEXACT)
T(RN,    0x1.cc9b3bef2fb02p-3,    0x1.c51153ef9ccb1p-3,    0x1.e20ddp-2, INEXACT)
T(RN,    0x1.c8622e45e5f4cp-3,     0x1.c10bdef79f6fp-3,   0x1.7cd546p-6, INEXACT)
T(RN,    0x1.c43309de2efa7p-3,    0x1.bd0ef67bf2041p-3,   0x1.61c56cp-2, INEXACT)
T(RN,    0x1.c00db7750bb5ep-3,    0x1.b91a8c3e83207p-3,  -0x1.fde9bap-4, INEXACT)
T(RN,    0x1.bbf21ffe159d9p-3,     0x1.b52e91fe3d04p-3,  -0x1.f8efe6p-2, INEXACT)
T(RN,    0x1.b7e02ca2fe877p-3,     0x1.b14af977de86p-3,   0x1.236fc6p-4, INEXACT)
T(RN,    0x1.b3d7c6c311b14p-3,    0x1.ad6fb466ce14ep-3,   0x1.84f12ep-3, INEXACT)
T(RN,     0x1.afd8d7f2b5f5p-3,    0x1.a99cb485e6e45p-3,   0x1.24421ap-3, INEXACT)
T(RN,    0x1.abe349faf1239p-3,    0x1.a5d1eb90405ddp-3,  -0x1.6728a8p-2, INEXACT)
T(RN,    0x1.a7f706d8ec83ap-3,    0x1.a20f4b41efed5p-3,   0x1.452ef8p-2, INEXACT)
T(RN,    0x1.a413f8bd7a739p-3,    0x1.9e54c558c5428p-3,    0x1.8b724p-4, INEXACT)
T(RN,    0x1.a03a0a0c9d293p-3,     0x1.9aa24b95011ep-3,   0x1.7b77cep-2, INEXACT)
T(RN,    0x1.9c69255d0e8f2p-3,    0x1.96f7cfba06c35p-3,  -0x1.314a7ep-2, INEXACT)
T(RN,     0x1.98a13577c93cp-3,    0x1.9355438f08283p-3,   0x1.63acdcp-2, INEXACT)
T(RN,    0x1.94e22557927ffp-3,     0x1.8fba98dfacf7p-3,  -0x1.415288p-3, INEXACT)
T(RN,    0x1.912be0288588dp-3,    0x1.8c27c17cb4812p-3,   -0x1.c6dc4p-2, INEXACT)
T(RN,    0x1.8d7e51479f96bp-3,    0x1.889caf3c92b3ap-3,   0x1.2dd3cap-2, INEXACT)
T(RN,    0x1.89d964424d419p-3,    0x1.851953fc082aap-3,   -0x1.892d9p-2, INEXACT)
T(RN,    0x1.863d04d5f8cbep-3,    0x1.819da19eb579dp-3,   0x1.93f2fap-5, INEXACT)
T(RN,    0x1.82a91eef997f6p-3,    0x1.7e298a0fa9c02p-3,   0x1.a99f9ap-3, INEXACT)
T(RN,    0x1.7f1d9eab44131p-3,    0x1.7abcff41eca14p-3,   -0x1.7b229p-4, INEXACT)
T(RN,    0x1.7b9a7053bc16cp-3,    0x1.7757f33103ba3p-3,   0x1.1a3b22p-5, INEXACT)
T(RN,    0x1.781f806206621p-3,    0x1.73fa57e173a88p-3,  -0x1.453c64p-2, INEXACT)
T(RN,    0x1.74acbb7cfc84ap-3,    0x1.70a41f613cbc1p-3,   0x1.1dd738p-2, INEXACT)
T(RN,    0x1.71420e78e1357p-3,    0x1.6d553bc853698p-3,  -0x1.35ca9ep-6, INEXACT)
T(RN,    0x1.6ddf6656f5bddp-3,    0x1.6a0d9f3914942p-3,   0x1.94d228p-2, INEXACT)
T(RN,    0x1.6a84b045105fcp-3,    0x1.66cd3be0b5c66p-3,    0x1.0b521p-2, INEXACT)
T(RN,    0x1.6731d99d33b2cp-3,    0x1.639403f7b16dep-3,   0x1.526c18p-3, INEXACT)
T(RN,    0x1.63e6cfe526f75p-3,    0x1.6061e9c22f327p-3,    0x1.56df6p-4, INEXACT)
T(RN,    0x1.60a380ce0f5d7p-3,     0x1.5d36df90687dp-3,  -0x1.07a944p-2, INEXACT)
T(RN,    0x1.5d67da340a3b9p-3,    0x1.5a12d7bf09439p-3,  -0x1.2890c8p-2, INEXACT)
T(RN,    0x1.5a33ca1dc835fp-3,    0x1.56f5c4b78d315p-3,  -0x1.2df66cp-2, INEXACT)
T(RN,    0x1.57073ebc29508p-3,    0x1.53df98f0993cbp-3,   0x1.7d0b4ap-2, INEXACT)
T(RN,    0x1.53e22669d9ed9p-3,    0x1.50d046ee51c3fp-3,   0x1.525504p-3, INEXACT)
T(RN,    0x1.50c46faaf0b35p-3,    0x1.4dc7c142ad41bp-3,  -0x1.3438acp-3, INEXACT)
T(RN,    0x1.4dae092c8d581p-3,    0x1.4ac5fa8dc3aecp-3,  -0x1.aaa234p-2, INEXACT)
T(RN,    0x1.4a9ee1c47852cp-3,    0x1.47cae57e1aa57p-3,   0x1.c1af38p-3, INEXACT)
T(RN,    0x1.4796e870c36d6p-3,    0x1.44d674d0ee594p-3,   0x1.ad024ap-2, INEXACT)
T(RN,    0x1.44960c576b376p-3,     0x1.41e89b527777p-3,   0x1.a0ddd2p-3, INEXACT)
T(RN,    0x1.419c3cc5f955bp-3,    0x1.3f014bde2dff9p-3,   0x1.a598d6p-2, INEXACT)
T(RN,    0x1.3ea9693127af9p-3,    0x1.3c20795f09313p-3,  -0x1.149a68p-7, INEXACT)
T(RN,     0x1.3bbd81348474p-3,    0x1.394616cfbc905p-3,  -0x1.789f24p-3, INEXACT)
T(RN,    0x1.38d8749216f81p-3,    0x1.3672173af2237p-3,   0x1.b207dcp-2, INEXACT)
T(RN,    0x1.35fa3332056a8p-3,    0x1.33a46dbb81f2cp-3,  -0x1.824abap-2, INEXACT)
T(RN,    0x1.3322ad223b5bap-3,    0x1.30dd0d7ca6de9p-3,  -0x1.ca2d8ap-4, INEXACT)
T(RN,    0x1.3051d29611173p-3,    0x1.2e1be9ba30dbfp-3,   0x1.db3726p-5, INEXACT)
T(RN,    0x1.2d8793e5f3cdbp-3,    0x1.2b60f5c0b4a9ap-3,  -0x1.df39cap-3, INEXACT)
T(RN,    0x1.2ac3e18f0e8d4p-3,    0x1.28ac24edb90efp-3, -0x1.e0152ap-10, INEXACT)
T(RN,    0x1.2806ac32f404cp-3,    0x1.25fd6aafe1b1ap-3,   0x1.26309ap-2, INEXACT)
T(RN,    0x1.254fe49749132p-3,     0x1.2354ba871797p-3,  -0x1.d2327ep-2, INEXACT)
T(RN,    0x1.229f7ba5701ecp-3,    0x1.20b20804af5dep-3,   0x1.9d58b2p-2, INEXACT)
T(RN,    0x1.1ff5626a35327p-3,    0x1.1e1546cb8d3f2p-3,  -0x1.e637aep-2, INEXACT)
T(RN,    0x1.1d518a157ae0fp-3,     0x1.1b7e6a9046e9p-3,   0x1.1623ecp-2, INEXACT)
T(RN,    0x1.1ab3e3f9e7ea7p-3,    0x1.18ed6719433e8p-3,   0x1.3ebab4p-2, INEXACT)
T(RN,    0x1.181c618c95a3ap-3,    0x1.1662303ed80dap-3,  -0x1.cec48ep-4, INEXACT)
T(RN,    0x1.158af464bf1c6p-3,    0x1.13dcb9eb65c8cp-3,  -0x1.894752p-3, INEXACT)
T(RN,    0x1.12ff8e3b71041p-3,    0x1.115cf81b7151ap-3,  -0x1.01a452p-7, INEXACT)
T(RN,    0x1.107a20eb3a4a1p-3,    0x1.0ee2deddbbe43p-3,    0x1.2de81p-2, INEXACT)
T(RN,     0x1.0dfa9e6fdd78p-3,    0x1.0c6e6253592dcp-3,  -0x1.de8862p-3, INEXACT)
T(RN,    0x1.0b80f8e602c58p-3,    0x1.09ff76afc39f9p-3,  -0x1.017974p-2, INEXACT)
T(RN,    0x1.090d228aeae23p-3,    0x1.07961038ef078p-3,  -0x1.a088a6p-6, INEXACT)
T(RN,    0x1.069f0dbc22748p-3,    0x1.05322347597c9p-3,  -0x1.49789ap-4, INEXACT)
T(RN,    0x1.0436acf7364d7p-3,     0x1.02d3a4461aadp-3,  -0x1.d5bb4ap-2, INEXACT)
T(RN,     0x1.01d3f2d9684dp-3,    0x1.007a87b2f197bp-3,  -0x1.445ab2p-3, INEXACT)
T(RN,    0x1.feeda43ec9eddp-4,    0x1.fc4d843ca17b5p-4,   0x1.e20c5cp-3, INEXACT)
T(RN,    0x1.fa3e7b49f36dcp-4,    0x1.f7b09056d1b1ap-4,  -0x1.b967fep-7, INEXACT)
T(RN,    0x1.f59a50c997a2cp-4,    0x1.f31e1d206442cp-4,    0x1.21aa7p-5, INEXACT)
T(RN,    0x1.f1010af01ffeap-4,    0x1.ee96142ae85a5p-4,  -0x1.deecfcp-2, INEXACT)
T(RN,     0x1.ec72902c856ap-4,    0x1.ea185f2d98ebcp-4,   -0x1.986dfp-5, INEXACT)
T(RN,    0x1.e7eec729c2209p-4,    0x1.e5a4e805671c2p-4,  -0x1.9d5d8ep-2, INEXACT)
T(RN,    0x1.e37596ce44dbbp-4,    0x1.e13b98b502226p-4,  -0x1.61ddbap-2, INEXACT)
T(RN,    0x1.df06e63b65474p-4,    0x1.dcdc5b64dcafep-4,   0x1.3f61cep-6, INEXACT)
T(RN,    0x1.daa29cccd9bf5p-4,    0x1.d8871a632ff7dp-4,  -0x1.20a94ep-2, INEXACT)
T(RN,    0x1.d648a2182e50bp-4,    0x1.d43bc023fc65cp-4,    0x1.beb63p-2, INEXACT)
T(RN,    0x1.d1f8ddec3cfb3p-4,    0x1.cffa374108175p-4,   0x1.94a934p-2, INEXACT)
T(RN,    0x1.cdb33850a733ep-4,    0x1.cbc26a79db2e2p-4,   0x1.710e7ep-3, INEXACT)
T(RN,    0x1.c977998550a1cp-4,    0x1.c79444b3ba083p-4,  -0x1.174c8cp-2, INEXACT)
T(RN,    0x1.c545ea01db12ap-4,    0x1.c36fb0f99d71dp-4,  -0x1.50fad8p-2, INEXACT)
T(RN,    0x1.c11e127523a81p-4,    0x1.bf549a7c28e4ap-4,  -0x1.98ab22p-3, INEXACT)
T(RN,    0x1.bcfffbc4c1359p-4,    0x1.bb42ec919ee0ep-4,   0x1.59ae68p-4, INEXACT)
T(RN,    0x1.b8eb8f0c83ce9p-4,    0x1.b73a92b5d3729p-4,  -0x1.0ac382p-2, INEXACT)
T(RN,    0x1.b4e0b59df5848p-4,    0x1.b33b788a1cf5cp-4,  -0x1.e0b2f4p-4, INEXACT)
T(RN,    0x1.b0df58ffdc4cbp-4,    0x1.af4589d54323bp-4,   0x1.9c7eb6p-2, INEXACT)
T(RN,      0x1.ace762edbd1p-4,    0x1.ab58b2836c7d4p-4,    0x1.65136p-3, INEXACT)
T(RN,    0x1.a8f8bd575fde3p-4,    0x1.a774dea60a1e1p-4,  -0x1.5e7748p-2, INEXACT)
T(RN,    0x1.a513526055463p-4,    0x1.a399fa73c20a7p-4,  -0x1.8a838ap-2, INEXACT)
T(RN,    0x1.a1370c5f7ccbcp-4,    0x1.9fc7f24858019p-4,   0x1.22d29ep-2, INEXACT)
T(RN,    0x1.9d63d5de8c7b5p-4,    0x1.9bfeb2a494e53p-4,  -0x1.afe1f4p-6, INEXACT)
T(RN,    0x1.9999999999998p-4,    0x1.983e282e2cc4bp-4,    0x1.6ab73p-2, INEXACT)
T(RN,    0x1.95d8427ea2694p-4,    0x1.94863fafa3951p-4,   0x1.e2c0bep-3, INEXACT)
T(RN,    0x1.921fbbad19074p-4,    0x1.90d6e61830a54p-4,  -0x1.02faa2p-6, INEXACT)
T(RN,    0x1.8e6ff0756f5a6p-4,    0x1.8d30087ba0dc6p-4,   0x1.fd1606p-2, INEXACT)
T(RN,    0x1.8ac8cc58a4125p-4,     0x1.8991941237cap-4,   0x1.7841bap-3, INEXACT)
T(RN,    0x1.872a3b07d0b48p-4,    0x1.85fb76388f976p-4,  -0x1.55aa92p-4, INEXACT)
T(RN,    0x1.83942863b8b61p-4,    0x1.826d9c6f77e55p-4,  -0x1.76cdb4p-6, INEXACT)
T(RN,    0x1.8006807c599cfp-4,    0x1.7ee7f45bd39f3p-4,  -0x1.b46918p-2, INEXACT)
T(RN,    0x1.7c812f907c27cp-4,      0x1.7b6a6bc675dp-4,   0x1.b2c072p-2, INEXACT)
T(RN,    0x1.7904220d467b7p-4,    0x1.77f4f09bfd849p-4,  -0x1.c93ad4p-3, INEXACT)
T(RN,    0x1.758f448dcf50fp-4,    0x1.748770ecb0c39p-4,   0x1.f776cap-2, INEXACT)
T(RN,    0x1.722283dab2223p-4,    0x1.7121daec56a4cp-4,    0x1.4a03fp-2, INEXACT)
T(RN,    0x1.6ebdcce9a4563p-4,    0x1.6dc41cf210959p-4,   0x1.f02712p-3, INEXACT)
T(RN,    0x1.6b610cdd0b658p-4,    0x1.6a6e257832ce7p-4,   0x1.cb9caap-2, INEXACT)
T(RN,    0x1.680c310393f8ap-4,    0x1.671fe31c1c06cp-4,   0x1.df88e8p-3, INEXACT)
T(RN,    0x1.64bf26d7c9fb6p-4,    0x1.63d9449e0c6dbp-4,   0x1.fdb67cp-2, INEXACT)
T(RN,    0x1.6179dbffb1a5dp-4,     0x1.609a38e0fbf3p-4,  -0x1.4ad0e8p-2, INEXACT)
T(RN,    0x1.5e3c3e4c61758p-4,    0x1.5d62aeea6fe63p-4,   0x1.784bccp-2, INEXACT)
T(RN,    0x1.5b063bb99d15ep-4,    0x1.5a3295e24ff3bp-4,  -0x1.c83844p-2, INEXACT)
T(RN,    0x1.57d7c26d7137fp-4,    0x1.5709dd12ba8ccp-4,   -0x1.cebb7p-2, INEXACT)
T(RN,    0x1.54b0c0b7d052dp-4,    0x1.53e873e7d8bb1p-4,  -0x1.837248p-4, INEXACT)
T(RN,     0x1.51912512304ep-4,    0x1.50ce49efb16c8p-4,   0x1.598b4ap-2, INEXACT)
T(RN,    0x1.4e78de1f29133p-4,    0x1.4dbb4ed9fc3d7p-4,   0x1.7635aap-6, INEXACT)
T(RN,    0x1.4b67daaa1403fp-4,    0x1.4aaf7277f3c7ap-4,   0x1.226572p-2, INEXACT)
T(RN,    0x1.485e09a6ac514p-4,     0x1.47aaa4bc277cp-4,    0x1.9120dp-2, INEXACT)
T(RN,    0x1.455b5a30b035cp-4,    0x1.44acd5ba4d11dp-4,   0x1.55bc68p-4, INEXACT)
T(RN,    0x1.425fbb8b830c5p-4,    0x1.41b5f5a7118cfp-4,   0x1.66359ep-4, INEXACT)
T(RN,    0x1.3f6b1d21d0441p-4,    0x1.3ec5f4d7e9e4ap-4,   0x1.a2c078p-4, INEXACT)
T(RN,    0x1.3c7d6e852f2e2p-4,    0x1.3bdcc3c2e34fap-4,   0x1.ebdfd8p-2, INEXACT)
T(RN,    0x1.39969f6dc7a4fp-4,     0x1.38fa52fe733dp-4,   0x1.cb2e2ep-2, INEXACT)
T(RN,    0x1.36b69fb9f788bp-4,    0x1.361e934146fd7p-4,   0x1.b759fep-2, INEXACT)
T(RN,    0x1.33dd5f6df9106p-4,    0x1.334975621323ap-4,   0x1.ff0f42p-2, INEXACT)
T(RN,    0x1.310aceb389ee9p-4,    0x1.307aea5762a27p-4,  -0x1.f9705ap-6, INEXACT)
T(RN,    0x1.2e3eddd993453p-4,    0x1.2db2e33765abap-4,  -0x1.4a4b48p-2, INEXACT)
T(RN,    0x1.2b797d53d2687p-4,    0x1.2af15137c0559p-4,  -0x1.bff242p-4, INEXACT)
T(RN,    0x1.28ba9dba826f3p-4,    0x1.283625ad590ddp-4,   0x1.70df7ep-2, INEXACT)
T(RN,    0x1.26022fca068d7p-4,    0x1.2581520c26db7p-4,  -0x1.67b7d2p-2, INEXACT)
T(RN,    0x1.2350246295376p-4,    0x1.22d2c7e6ff769p-4,  -0x1.26727cp-2, INEXACT)
T(RN,    0x1.20a46c87e40d6p-4,    0x1.202a78ef653aep-4,   0x1.df5676p-2, INEXACT)
T(RN,    0x1.1dfef960d48b8p-4,    0x1.1d8856f554f6dp-4,   0x1.31e8bcp-3, INEXACT)
T(RN,    0x1.1b5fbc37217d1p-4,    0x1.1aec53e7139dfp-4,   0x1.014b76p-2, INEXACT)
T(RN,    0x1.18c6a6770d32dp-4,     0x1.185661d0fbe2p-4,   0x1.d1ba6ep-4, INEXACT)
T(RN,     0x1.1633a9af1078p-4,    0x1.15c672dd4bb5ep-4,    0x1.96af7p-2, INEXACT)
T(RN,    0x1.13a6b78f8a459p-4,    0x1.133c7953f1be4p-4,   0x1.08edacp-2, INEXACT)
T(RN,    0x1.111fc1ea70334p-4,    0x1.10b8679a5ab61p-4,   0x1.4f99f2p-2, INEXACT)
T(RN,    0x1.0e9ebab2ffa1bp-4,    0x1.0e3a30333ec65p-4,   0x1.bfb018p-2, INEXACT)
T(RN,    0x1.0c2393fd6f9ebp-4,    0x1.0bc1c5be6ed83p-4,  -0x1.4043a6p-2, INEXACT)
T(RN,    0x1.09ae3ffea37fep-4,    0x1.094f1af8a1e2bp-4,   0x1.18321cp-3, INEXACT)
T(RN,    0x1.073eb10bde346p-4,    0x1.06e222bb42388p-4,  -0x1.93e088p-3, INEXACT)
T(RN,    0x1.04d4d99a76491p-4,     0x1.047acffc3ad8p-4,   0x1.24281ep-2, INEXACT)
T(RN,    0x1.0270ac3f8a9f9p-4,    0x1.021915cdc4c06p-4,  -0x1.88a852p-2, INEXACT)
T(RN,    0x1.00121bafb7d6cp-4,    0x1.ff79cebc68a21p-5,   0x1.d5a8aap-2, INEXACT)
T(RN,    0x1.fb72357d9cc28p-5,    0x1.facc6fef8d647p-5,   0x1.48eb9ap-2, INEXACT)
T(RN,    0x1.f6cb38bf12931p-5,    0x1.f629f600de99ap-5,   0x1.f4d55ap-3, INEXACT)
T(RN,    0x1.f22f27468b45ep-5,    0x1.f19247f34aa64p-5,  -0x1.79a29ep-2, INEXACT)
T(RN,    0x1.ed9de7737547ap-5,    0x1.ed054d0062b81p-5,  -0x1.9b11f6p-3, INEXACT)
T(RN,     0x1.e9175fe164d1p-5,    0x1.e882ec97f6272p-5,   -0x1.11871p-3, INEXACT)
T(RN,    0x1.e49b776786bd2p-5,    0x1.e40b0e5fae096p-5,   0x1.bbc038p-2, INEXACT)
T(RN,    0x1.e02a151814a92p-5,    0x1.df9d9a32a8f7ep-5,  -0x1.c5b896p-3, INEXACT)
T(RN,    0x1.dbc3203fca5cdp-5,    0x1.db3a7821170e3p-5,  -0x1.5e5ae4p-3, INEXACT)
T(RN,    0x1.d76680655c784p-5,    0x1.d6e1906fd6257p-5,  -0x1.f32868p-6, INEXACT)
T(RN,    0x1.d3141d48f064cp-5,    0x1.d292cb980e51fp-5,  -0x1.f3e93ap-4, INEXACT)
T(RN,    0x1.cecbdee395843p-5,    0x1.ce4e1246cea46p-5,   0x1.16d388p-2, INEXACT)
T(RN,    0x1.ca8dad66bf9c1p-5,    0x1.ca134d5caa329p-5,   0x1.b41c48p-2, INEXACT)
T(RN,    0x1.c659713bc27c6p-5,    0x1.c5e265ed556ecp-5,   0x1.78ee0cp-3, INEXACT)
T(RN,    0x1.c22f13034edafp-5,     0x1.c1bb453f43ccp-5,  -0x1.e8cabap-2, INEXACT)
T(RN,    0x1.be0e7b94f062ep-5,    0x1.bd9dd4cb45b5cp-5,  -0x1.4bcf9ap-2, INEXACT)
T(RN,    0x1.b9f793fe8cf68p-5,    0x1.b989fe3c26de6p-5,   0x1.48bf74p-2, INEXACT)
T(RN,    0x1.b5ea4583e51dfp-5,    0x1.b57fab6e4ce56p-5,  -0x1.8b2a1ep-2, INEXACT)
T(RN,    0x1.b1e6799e15a0cp-5,    0x1.b17ec66f56595p-5,   0x1.f6f4c4p-2, INEXACT)
T(RN,    0x1.adec19fb1a4a6p-5,    0x1.ad87397dba196p-5,   0x1.23e82cp-4, INEXACT)
T(RN,    0x1.a9fb107d51d28p-5,    0x1.a998ef0867177p-5, -0x1.3b3768p-10, INEXACT)
T(RN,    0x1.a613473b02e8dp-5,    0x1.a5b3d1ae647cfp-5,   0x1.a2c326p-4, INEXACT)
T(RN,    0x1.a234a87de262ep-5,    0x1.a1d7cc3e7237fp-5,  -0x1.b999e4p-4, INEXACT)
T(RN,    0x1.9e5f1ec29a866p-5,    0x1.9e04c9b6a9ef2p-5,   0x1.738798p-2, INEXACT)
T(RN,    0x1.9a9294b8536eap-5,    0x1.9a3ab54420601p-5,  -0x1.3f4212p-3, INEXACT)
T(RN,    0x1.96cef5403c8c9p-5,    0x1.96797a42872cap-5,  -0x1.43f3eap-2, INEXACT)
T(RN,    0x1.93142b6d173abp-5,    0x1.92c1043bcf147p-5,    0x1.1a866p-2, INEXACT)
T(RN,    0x1.8f622282c2664p-5,    0x1.8f113ee7caa0ep-5,    0x1.9f66cp-3, INEXACT)
T(RN,    0x1.8bb8c5f5c747ap-5,     0x1.8b6a162bd142p-5,  -0x1.621488p-3, INEXACT)
T(RN,    0x1.8818016ae72bfp-5,    0x1.87cb761a62e22p-5,  -0x1.695cd6p-3, INEXACT)
T(RN,    0x1.847fc0b6aa487p-5,    0x1.84354af2cbecfp-5,  -0x1.d16eb6p-2, INEXACT)
T(RN,    0x1.80efefdcef97ep-5,    0x1.80a78120c9cecp-5,   0x1.429f28p-3, INEXACT)
T(RN,    0x1.7d687b107dc07p-5,    0x1.7d22053c2fed9p-5,   0x1.54de8cp-4, INEXACT)
T(RN,    0x1.79e94eb294fd2p-5,    0x1.79a4c4088d1bbp-5,  -0x1.597b88p-3, INEXACT)
T(RN,    0x1.7672575282092p-5,    0x1.762faa74d1853p-5,    0x1.90b6bp-8, INEXACT)
T(RN,    0x1.730381ad320d1p-5,    0x1.72c2a59af51c1p-5,  -0x1.7c2186p-4, INEXACT)
T(RN,    0x1.6f9cbaacc7887p-5,    0x1.6f5da2bf9e814p-5,   0x1.d3542cp-2, INEXACT)
T(RN,    0x1.6c3def683035dp-5,    0x1.6c008f51ca6bbp-5,  -0x1.6980bep-3, INEXACT)
T(RN,    0x1.68e70d22bbea9p-5,    0x1.68ab58ea7392bp-5,  -0x1.79040ap-2, INEXACT)
T(RN,    0x1.6598014bb46a9p-5,    0x1.655ded4c3b15ep-5,  -0x1.ea4282p-3, INEXACT)
T(RN,    0x1.6250b97df6323p-5,    0x1.62183a6311696p-5,   0x1.d28e9ap-2, INEXACT)
T(RN,    0x1.5f11237f8a312p-5,    0x1.5eda2e43dfc31p-5,  -0x1.d4da16p-2, INEXACT)
T(RN,    0x1.5bd92d4140775p-5,    0x1.5ba3b72c320e2p-5,   0x1.78048ap-5, INEXACT)
T(RN,    0x1.58a8c4de4bcd8p-5,    0x1.5874c381e15f9p-5,  -0x1.c4accep-2, INEXACT)
T(RN,    0x1.557fd89bde3a2p-5,    0x1.554d41d2bef19p-5,   0x1.0c1d76p-3, INEXACT)
T(RN,    0x1.525e56e8c670ep-5,    0x1.522d20d43fa47p-5,  -0x1.83f2e8p-2, INEXACT)
T(RN,    0x1.4f442e5d0e281p-5,    0x1.4f144f6328053p-5,   0x1.e2ea74p-2, INEXACT)
T(RN,    0x1.4c314db999536p-5,    0x1.4c02bc8338d9ap-5,   0x1.9768ccp-3, INEXACT)
T(RN,     0x1.4925a3e7c643p-5,    0x1.48f8575edc35ep-5,  -0x1.062736p-4, INEXACT)
T(RN,    0x1.46211ff90ea29p-5,    0x1.45f50f46d3174p-5,   0x1.7921f6p-2, INEXACT)
T(RN,     0x1.4323b126a957p-5,    0x1.42f8d3b1e386fp-5,  -0x1.c606dap-2, INEXACT)
T(RN,    0x1.402d46d12d3a7p-5,    0x1.4003943c87466p-5,    0x1.42667p-3, INEXACT)
T(RN,    0x1.3d3dd08034b24p-5,    0x1.3d1540a89b023p-5,   0x1.e973fcp-2, INEXACT)
T(RN,    0x1.3a553de2021d3p-5,    0x1.3a2dc8dd0e0dbp-5,  -0x1.6cee12p-3, INEXACT)
T(RN,    0x1.37737ecb251a9p-5,    0x1.374d1ce592a8fp-5,  -0x1.9a75ccp-2, INEXACT)
T(RN,    0x1.3498833620a48p-5,    0x1.34732cf24ecd8p-5,   0x1.b8879ep-2, INEXACT)
T(RN,    0x1.31c43b4311fd3p-5,    0x1.319fe9578d842p-5,   -0x1.f359cp-2, INEXACT)
T(RN,    0x1.2ef69737586f1p-5,    0x1.2ed3428d70c61p-5,    0x1.8ffadp-2, INEXACT)
T(RN,    0x1.2c2f877d3dd9fp-5,    0x1.2c0d292fa3e3cp-5,  -0x1.9172a8p-7, INEXACT)
T(RN,    0x1.296efca3a00e9p-5,    0x1.294d8dfd0e773p-5,  -0x1.fde352p-3, INEXACT)
T(RN,    0x1.26b4e75d9af4ep-5,    0x1.269461d787dd9p-5,   0x1.d6757ap-2, INEXACT)
T(RN,    0x1.24013882337cdp-5,     0x1.23e195c38b3bp-5,   0x1.9cd456p-4, INEXACT)
T(RN,    0x1.2153e10c0355ap-5,    0x1.21351ae7ec067p-5,  -0x1.73ebd2p-4, INEXACT)
T(RN,    0x1.1eacd218e56b2p-5,    0x1.1e8ee28d8b1dap-5,   0x1.e468f8p-2, INEXACT)
T(RN,    0x1.1c0bfce9a3282p-5,    0x1.1beede1f0c62ep-5,  -0x1.d54cdep-2, INEXACT)
T(RN,    0x1.197152e1a2799p-5,    0x1.1954ff288ce23p-5,  -0x1.ac250cp-3, INEXACT)
T(RN,    0x1.16dcc58694928p-5,    0x1.16c13757597ddp-5,  -0x1.a45214p-2, INEXACT)
T(RN,    0x1.144e4680256fdp-5,    0x1.14337879a624bp-5,   0x1.c9b5bep-2, INEXACT)
T(RN,    0x1.11c5c797ac174p-5,     0x1.11abb47e458ep-5,   0x1.abad36p-2, INEXACT)
T(RN,    0x1.0f433ab7db925p-5,    0x1.0f29dd74617d7p-5,   0x1.d6f01ep-2, INEXACT)
T(RN,    0x1.0cc691ec74a34p-5,    0x1.0cade58b338e6p-5,   0x1.4c2c5ap-2, INEXACT)
T(RN,    0x1.0a4fbf61f830bp-5,    0x1.0a37bf11be84ep-5,   0x1.dac262p-4, INEXACT)
T(RN,    0x1.07deb5655a683p-5,    0x1.07c75c768825bp-5,   0x1.4dc80cp-2, INEXACT)
T(RN,    0x1.05736663b6946p-5,    0x1.055cb04753932p-5,  -0x1.72e5eap-2, INEXACT)
T(RN,    0x1.030dc4ea03a71p-5,    0x1.02f7ad30dc312p-5,   0x1.b36f92p-2, INEXACT)
T(RN,    0x1.00adc3a4c9735p-5,    0x1.009845fe910c5p-5,   0x1.52761ep-2, INEXACT)
T(RN,    0x1.fca6aabfad2e7p-6,    0x1.fc7cdb34a18ddp-6,  -0x1.a5acb6p-3, INEXACT)
T(RN,    0x1.f7fcda0bee28cp-6,    0x1.f7d42e184c13fp-6,   0x1.d32134p-2, INEXACT)
T(RN,    0x1.f35dfb4157278p-6,    0x1.f3366af408f2ep-6,   0x1.b3fef8p-3, INEXACT)
T(RN,    0x1.eec9f4afc2a84p-6,    0x1.eea3784f0c575p-6,   0x1.0fc468p-4, INEXACT)
T(RN,     0x1.ea40ace35586p-6,    0x1.ea1b3ceb53492p-6,   0x1.fe862cp-3, INEXACT)
T(RN,    0x1.e5c20aa3f1773p-6,    0x1.e59d9fc520a37p-6,   0x1.9f3edcp-2, INEXACT)
T(RN,    0x1.e14df4f4a8d8ap-6,    0x1.e12a88127b10ep-6,  -0x1.175f1ep-3, INEXACT)
T(RN,    0x1.dce4531333c36p-6,    0x1.dcc1dd42ac0c1p-6,  -0x1.dca4acp-2, INEXACT)
T(RN,    0x1.d8850c7766663p-6,    0x1.d86386fdbfde9p-6,  -0x1.0c0accp-2, INEXACT)
T(RN,    0x1.d43008d2a8a28p-6,    0x1.d40f6d2406a08p-6,   0x1.893a7ep-3, INEXACT)
T(RN,    0x1.cfe5300f6eeb7p-6,     0x1.cfc577cd9639p-6,   0x1.5d748cp-3, INEXACT)
T(RN,    0x1.cba46a50b45fcp-6,    0x1.cb858f49cd5a3p-6,  -0x1.c5e17ap-2, INEXACT)
T(RN,    0x1.c76d9ff1761e4p-6,     0x1.c74f9c1ed77ap-6,   0x1.65b122p-2, INEXACT)
T(RN,    0x1.c340b9842fd39p-6,    0x1.c323870931c7cp-6,  -0x1.37f488p-4, INEXACT)
T(RN,    0x1.bf1d9fd2597a1p-6,    0x1.bf0138fb311a7p-6,  -0x1.f9aa6cp-7, INEXACT)
T(RN,     0x1.bb043bdbe64dp-6,    0x1.bae89b1c88d87p-6,  -0x1.906232p-5, INEXACT)
T(RN,     0x1.b6f476d6c4e9p-6,    0x1.b6d996c9d2d5ep-6,   0x1.eaaa26p-4, INEXACT)
T(RN,    0x1.b2ee3a2e609b4p-6,    0x1.b2d41594182b9p-6,  -0x1.3f6584p-2, INEXACT)
T(RN,    0x1.aef16f8323d76p-6,    0x1.aed801405b00ap-6,   0x1.11de1cp-2, INEXACT)
T(RN,    0x1.aafe00a9fbd4cp-6,    0x1.aae543c721481p-6,   0x1.ed79fap-3, INEXACT)
T(RN,    0x1.a713d7abdd513p-6,    0x1.a6fbc7540072dp-6,  -0x1.9d5f9ap-4, INEXACT)
T(RN,    0x1.a332dec54a731p-6,    0x1.a31b76452a10ap-6,  -0x1.47804ep-3, INEXACT)
T(RN,    0x1.9f5b0065d9ca1p-6,    0x1.9f443b2af960bp-6,  -0x1.eda1bcp-3, INEXACT)
T(RN,    0x1.9b8c272fbe6dep-6,    0x1.9b7600c781d2cp-6,   0x1.3e4222p-2, INEXACT)
T(RN,    0x1.97c63df751345p-6,     0x1.97b0b20e1e73p-6,   0x1.c82f02p-3, INEXACT)
T(RN,    0x1.94092fc29afe3p-6,    0x1.93f43a230241fp-6,   0x1.b36644p-2, INEXACT)
T(RN,    0x1.9054e7c8e01a3p-6,    0x1.9040845ac977cp-6,   0x1.f4600cp-2, INEXACT)
T(RN,    0x1.8ca951722cb7dp-6,    0x1.8c957c3a0baf3p-6,   0x1.b8abb6p-4, INEXACT)
T(RN,    0x1.89065856e26a4p-6,    0x1.88f30d74eef89p-6,  -0x1.3bd102p-4, INEXACT)
T(RN,     0x1.856be83f46b7p-6,    0x1.855923eebbd1bp-6,   0x1.a7390cp-2, INEXACT)
T(RN,    0x1.81d9ed2312b0cp-6,    0x1.81c7abb972046p-6,   0x1.89ce42p-4, INEXACT)
T(RN,    0x1.7e50532903982p-6,    0x1.7e3e91155e669p-6,   -0x1.546b5p-2, INEXACT)
T(RN,     0x1.7acf06a66c82p-6,     0x1.7abdc070b17cp-6,   0x1.af0dccp-3, INEXACT)
T(RN,    0x1.7755f41ec9028p-6,    0x1.7745266716f9ep-6,   0x1.52d5f4p-6, INEXACT)
T(RN,    0x1.73e5084350d6ap-6,    0x1.73d4afc14e27ep-6,  -0x1.9faed8p-6, INEXACT)
T(RN,    0x1.707c2ff28c8cdp-6,    0x1.706c4974c31edp-6,  -0x1.659d88p-3, INEXACT)
T(RN,    0x1.6d1b5837eb2a2p-6,    0x1.6d0be0a328e45p-6,   0x1.7a4388p-3, INEXACT)
T(RN,    0x1.69c26e4b58c86p-6,    0x1.69b3629a14602p-6,   0x1.4b5ff2p-2, INEXACT)
T(RN,     0x1.66715f90d62bp-6,    0x1.6662bcd2982a4p-6,   0x1.3f2ab8p-2, INEXACT)
T(RN,    0x1.63281998114acp-6,    0x1.6319dcf0e1325p-6,   0x1.960f48p-2, INEXACT)
T(RN,    0x1.5fe68a1bfed2cp-6,    0x1.5fd8b0c3d43bbp-6,  -0x1.4e75bap-3, INEXACT)
T(RN,    0x1.5cac9f02748dcp-6,    0x1.5c9f2644ac2e4p-6,  -0x1.c1739ep-3, INEXACT)
T(RN,    0x1.597a465bc4c3fp-6,    0x1.596d2b96993c4p-6,   0x1.0a84eep-3, INEXACT)
T(RN,    0x1.564f6e625a82ep-6,    0x1.5642af0660d83p-6,  -0x1.94adf2p-2, INEXACT)
T(RN,    0x1.532c057a56cfbp-6,    0x1.531f9f09fe7b9p-6,  -0x1.a65d38p-2, INEXACT)
T(RN,    0x1.500ffa312ec2cp-6,    0x1.5003ea40453dbp-6,   -0x1.72b72p-2, INEXACT)
T(RN,    0x1.4cfb3b3d4a873p-6,    0x1.4cef7f7082368p-6,  -0x1.6a1a32p-3, INEXACT)
T(RN,    0x1.49edb77da53f5p-6,    0x1.49e24d8a1fae9p-6,   0x1.6eafb6p-2, INEXACT)
T(RN,    0x1.46e75df96dc98p-6,    0x1.46dc43a449188p-6,   0x1.2c7fdap-2, INEXACT)
T(RN,    0x1.43e81ddfa8664p-6,    0x1.43dd50fd8fd59p-6,   0x1.35803cp-2, INEXACT)
T(RN,    0x1.40efe686d13a4p-6,    0x1.40e564fb90c02p-6,  -0x1.3c336cp-3, INEXACT)
T(RN,    0x1.3dfea76c7fabbp-6,    0x1.3df46f2a9a7cbp-6,   0x1.2b5a08p-2, INEXACT)
T(RN,    0x1.3b1450350a9adp-6,    0x1.3b0a5f3d54911p-6,  -0x1.6784dep-3, INEXACT)
T(RN,    0x1.3830d0ab2d6ffp-6,    0x1.3827250c673dcp-6,   0x1.65791ep-3, INEXACT)
T(RN,    0x1.355418bfadff7p-6,     0x1.354ab0962419p-6,  -0x1.e91a1ap-2, INEXACT)
T(RN,    0x1.327e188903426p-6,    0x1.3274f1fe2f6c8p-6,   0x1.9b10d8p-4, INEXACT)
T(RN,     0x1.2faec042fcdfp-6,    0x1.2fa5d98d2a4f9p-6,   0x1.12883ep-2, INEXACT)
T(RN,    0x1.2ce6004e6b81ap-6,    0x1.2cdd57b05d80ap-6,   0x1.19c618p-4, INEXACT)
T(RN,    0x1.2a23c930ca03ap-6,    0x1.2a1b5cf964fb1p-6,   0x1.ed3c74p-2, INEXACT)
T(RN,    0x1.27680b93e75ddp-6,    0x1.275fda1ddc474p-6,  -0x1.a8da88p-3, INEXACT)
T(RN,    0x1.24b2b84591648p-6,    0x1.24aabff70b847p-6,  -0x1.228dc4p-2, INEXACT)
T(RN,    0x1.2203c037404cap-6,    0x1.21fbff81952afp-6,    0x1.c147ep-4, INEXACT)
T(RN,    0x1.1f5b147dc2f56p-6,    0x1.1f5389dd2483ap-6,    0x1.2708fp-2, INEXACT)
T(RN,    0x1.1cb8a650ebf91p-6,    0x1.1cb1504c1cd78p-6,   0x1.78a712p-3, INEXACT)
T(RN,    0x1.1a1c670b3f7dep-6,    0x1.1a15443349504p-6,   -0x1.1f55dp-2, INEXACT)
T(RN,    0x1.17864829a1c93p-6,    0x1.177f57198d8d2p-6,  -0x1.22c67ap-8, INEXACT)
T(RN,    0x1.14f63b4b06916p-6,    0x1.14ef7aa796e81p-6,    0x1.39367p-5, INEXACT)
T(RN,    0x1.126c3230210d5p-6,    0x1.1265a0a78e6b5p-6,   0x1.de321ep-6, INEXACT)
T(RN,    0x1.0fe81ebb14be2p-6,    0x1.0fe1bb04cb73dp-6,   0x1.a274fcp-4, INEXACT)
T(RN,    0x1.0d69f2ef26f5ep-6,    0x1.0d63bbcb8703bp-6,  -0x1.cd8f08p-6, INEXACT)
T(RN,    0x1.0af1a0f071133p-6,    0x1.0aeb95288fbd4p-6,   -0x1.d3e69p-3, INEXACT)
T(RN,    0x1.087f1b0393755p-6,    0x1.08793968fe8a3p-6,  -0x1.48338cp-2, INEXACT)
T(RN,    0x1.0612538d69243p-6,    0x1.060c9af9ebeafp-6,   0x1.99ac0cp-6, INEXACT)
T(RN,    0x1.03ab3d12bc2c2p-6,    0x1.03a5ac6825ee1p-6,   -0x1.1675ep-2, INEXACT)
T(RN,     0x1.0149ca37faabp-6,    0x1.0144605fe6ce4p-6,    0x1.d9e76p-5, INEXACT)
T(RN,    0x1.fddbdb81d918fp-7,    0x1.fdd153591867dp-7,  -0x1.5af3ccp-2, INEXACT)
T(RN,    0x1.f92f3520d3ecdp-7,    0x1.f924f6709e39ep-7,  -0x1.7cc3aap-2, INEXACT)
T(RN,      0x1.f48d875024cp-7,    0x1.f4839017f8c8ep-7,   0x1.aa01e6p-2, INEXACT)
T(RN,    0x1.eff6b85008aa3p-7,    0x1.efed069d5bd97p-7,   0x1.c8eb48p-2, INEXACT)
T(RN,    0x1.eb6aae9d2bc59p-7,    0x1.eb61408b08d1fp-7,  -0x1.d4abbap-3, INEXACT)
T(RN,    0x1.e6e950f01b586p-7,    0x1.e6e024a6c38afp-7,  -0x1.713cb2p-2, INEXACT)
T(RN,    0x1.e272863cb9494p-7,    0x1.e26999f14857cp-7,  -0x1.09a854p-2, INEXACT)
T(RN,    0x1.de0635b1b0e1fp-7,    0x1.ddfd87a5c34bcp-7,   0x1.c69afap-4, INEXACT)
T(RN,    0x1.d9a446b7ecd44p-7,    0x1.d99bd53948b03p-7,  -0x1.40f782p-3, INEXACT)
T(RN,    0x1.d54ca0f20e84fp-7,    0x1.d5446a5a4eaf3p-7,   0x1.825ea2p-7, INEXACT)
T(RN,    0x1.d0ff2c3be6976p-7,    0x1.d0f72ef0282eap-7,   0x1.9b08eep-2, INEXACT)
T(RN,    0x1.ccbbd0a9eeb6dp-7,    0x1.ccb40b1a80d8bp-7,  -0x1.524172p-3, INEXACT)
T(RN,    0x1.c8827688c49b3p-7,    0x1.c87ae730da509p-7,    0x1.7f24bp-4, INEXACT)
T(RN,    0x1.c453065ca643ep-7,    0x1.c44babc20a8d3p-7,  -0x1.9386a8p-2, INEXACT)
T(RN,    0x1.c02d68e0ef6c2p-7,    0x1.c0264193bb5fbp-7,   0x1.2a5e3ap-2, INEXACT)
T(RN,    0x1.bc118707982d4p-7,    0x1.bc0a91a1eb184p-7,   0x1.450c2ep-4, INEXACT)
T(RN,    0x1.b7ff49f8b4d33p-7,    0x1.b7f8851e6e504p-7,  -0x1.3267b6p-3, INEXACT)
T(RN,    0x1.b3f69b11f6dcap-7,    0x1.b3f0057072d1ap-7,  -0x1.479e2ap-2, INEXACT)
T(RN,    0x1.aff763e62f268p-7,    0x1.aff0fc34039cbp-7,   0x1.d0a2e8p-2, INEXACT)
T(RN,    0x1.ac018e3cd13c2p-7,    0x1.abfb53398e055p-7,   0x1.fa5bd8p-5, INEXACT)
T(RN,    0x1.a815041177d03p-7,    0x1.a80ef48567ed1p-7,  -0x1.b4def2p-2, INEXACT)
T(RN,    0x1.a431af936a53ep-7,    0x1.a42bca4f570eap-7,  -0x1.a58c06p-4, INEXACT)
T(RN,     0x1.a0577b2523afp-7,    0x1.a051bf02195e7p-7,  -0x1.807366p-2, INEXACT)
T(RN,    0x1.9c86515bda149p-7,    0x1.9c80bd3aee7cap-7,  -0x1.fe861ap-4, INEXACT)
T(RN,    0x1.98be1cff07f12p-7,    0x1.98b8afc92234fp-7,   0x1.be49b2p-4, INEXACT)
T(RN,    0x1.94fec907f5f18p-7,    0x1.94f981ad980c7p-7,   0x1.1604a6p-7, INEXACT)
T(RN,    0x1.914840a1461bbp-7,    0x1.91431e1a57d6bp-7,   -0x1.59231p-2, INEXACT)
T(RN,    0x1.8d9a6f267ffedp-7,    0x1.8d9570721b57ap-7,   0x1.b92034p-2, INEXACT)
T(RN,    0x1.89f540239dee5p-7,    0x1.89f06447dce64p-7,   -0x1.82467p-5, INEXACT)
T(RN,    0x1.86589f549b4d2p-7,    0x1.8653e55e67165p-7,  -0x1.b7ecbcp-5, INEXACT)
T(RN,    0x1.82c478a503e2bp-7,    0x1.82bfdfa7e5616p-7,  -0x1.fcd4e8p-2, INEXACT)
T(RN,    0x1.7f38b82f84392p-7,    0x1.7f343f4575d08p-7,  -0x1.03d514p-2, INEXACT)
T(RN,    0x1.7bb54a3d7aff9p-7,    0x1.7bb0f086bba08p-7,  -0x1.99e4b2p-3, INEXACT)
T(RN,    0x1.783a1b468b73bp-7,    0x1.7835dfe972e52p-7,   0x1.407734p-3, INEXACT)
T(RN,    0x1.74c717f030c8ep-7,    0x1.74c2fa190520ep-7,  -0x1.94f888p-2, INEXACT)
T(RN,    0x1.715c2d0d528fdp-7,    0x1.71582bee1ed58p-7,   0x1.379312p-7, INEXACT)
T(RN,    0x1.6df9479dda1acp-7,    0x1.6df5626e46086p-7,   0x1.51517ep-2, INEXACT)
T(RN,    0x1.6a9e54ce48dbdp-7,    0x1.6a9a8acb71b9bp-7,   0x1.61b3e8p-2, INEXACT)
T(RN,    0x1.674b41f74fb9cp-7,    0x1.67479263a24a2p-7,  -0x1.446be6p-2, INEXACT)
T(RN,    0x1.63fffc9d675dfp-7,    0x1.63fc66c07ad29p-7,  -0x1.8e96b2p-3, INEXACT)
T(RN,     0x1.60bc72706972p-7,    0x1.60b8f596db63cp-7,   -0x1.1c99ep-2, INEXACT)
T(RN,    0x1.5d80914b2ad05p-7,    0x1.5d7d2cc67c326p-7,   0x1.1e20d6p-2, INEXACT)
T(RN,    0x1.5a4c473316a3ap-7,    0x1.5a48fa5989aaep-7,  -0x1.5395bcp-5, INEXACT)
T(RN,    0x1.571f8257ca72fp-7,    0x1.571c4c84416b7p-7,   0x1.9d5346p-3, INEXACT)
T(RN,    0x1.53fa3112b3184p-7,    0x1.53f711a49021cp-7,   0x1.7896dcp-2, INEXACT)
T(RN,    0x1.50dc41e6aa9eap-7,    0x1.50d93841b04a4p-7,   0x1.f65e5ep-2, INEXACT)
T(RN,    0x1.4dc5a37f97095p-7,    0x1.4dc2af0bc9d21p-7,    0x1.b3e84p-4, INEXACT)
T(RN,    0x1.4ab644b209fc3p-7,    0x1.4ab364db92948p-7,   0x1.dd84aap-2, INEXACT)
