#	Copyright 2014 Nintendo.  All rights reserved.
# this file gets included into the top level nnmusl build folder
# the actual make files are generated by cmake

.PHONY:		build
.PHONY:		build-android-aarch64 build-android-aarch64-native
.PHONY:		build-horizon-aarch64
.PHONY:		build-horizon-armv7l
.PHONY:		build-linux-aarch64 build-linux-aarch64-native
.PHONY:		build-linux-armv7l build-linux-armv7l-native
.PHONY:		build-linux-x86_64 build-linux-x86_64-native

CMAKE_BUILD = SIGLO_TARGET=$(subst $(1),,$@) siglo cmake --build ./$(subst $(1),,$@) $(2) --target $(3)

build:	$(SIGLO_TARGETS:%=build-%)

build-android-aarch64:
	$(call CMAKE_BUILD,build-,,ntd_test_libc)

build-android-aarch64-native:
	$(call CMAKE_BUILD,build-,,ntd_test_libc)

build-horizon-aarch64:
    # disable for now, needs horizon libraries
	# $(call CMAKE_BUILD,build-,ntd_test_libc)

build-horizon-armv7l:
    # disable for now, needs horizon libraries
	# $(call CMAKE_BUILD,build-,ntd_test_libc)

build-linux-aarch64:
	$(call CMAKE_BUILD,build-,,ntd_test_libc)

build-linux-aarch64-native:
	$(call CMAKE_BUILD,build-,,ntd_test_libc)

build-linux-armv7l:
	$(call CMAKE_BUILD,build-,,ntd_test_libc)

build-linux-armv7l-native:
	$(call CMAKE_BUILD,build-,,ntd_test_libc)

build-linux-x86_64:
	$(call CMAKE_BUILD,build-,,ntd_test_libc)

build-linux-x86_64-native:
	$(call CMAKE_BUILD,build-,,ntd_test_libc)

.PHONY:		rebuild
.PHONY:		rebuild-android-aarch64 rebuild-android-aarch64-native
.PHONY:		rebuild-horizon-aarch64
.PHONY:		rebuild-horizon-armv7l
.PHONY:		rebuild-linux-aarch64 rebuild-linux-aarch64-native
.PHONY:		rebuild-linux-armv7l rebuild-linux-armv7l-native
.PHONY:		rebuild-linux-x86_64 rebuild-linux-x86_64-native

rebuild:	$(SIGLO_TARGETS:%=rebuild-%)

rebuild-android-aarch64:
	$(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-android-aarch64-native:
	$(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-horizon-aarch64:
    # disable for now, needs horizon libraries
	# $(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-horizon-armv7l:
    # disable for now, needs horizon libraries
	# $(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-linux-aarch64:
	$(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-linux-aarch64-native:
	$(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-linux-armv7l:
	$(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-linux-armv7l-native:
	$(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-linux-x86_64:
	$(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

rebuild-linux-x86_64-native:
	$(call CMAKE_BUILD,rebuild-,--clean-first,ntd_test_libc)

.PHONY:	clean
.PHONY:	clean-android-aarch64 clean-android-aarch64-native
.PHONY:	clean-horizon-aarch64
.PHONY:	clean-horizon-armv7l
.PHONY:	clean-linux-aarch64 clean-linux-aarch64-native
.PHONY:	clean-linux-armv7l clean-linux-armv7l-native
.PHONY:	clean-linux-x86_64 clean-linux-x86_64-native

clean:	$(SIGLO_TARGETS:%=clean-%)

clean-android-aarch64:
	-rm -r ./$(subst clean-,,$@)

clean-android-aarch64-native:
	-rm -r ./$(subst clean-,,$@)

clean-horizon-aarch64:
	-rm -r ./$(subst clean-,,$@)

clean-horizon-armv7l:
	-rm -r ./$(subst clean-,,$@)

clean-linux-aarch64:
	-rm -r ./$(subst clean-,,$@)

clean-linux-aarch64-native:
	-rm -r ./$(subst clean-,,$@)

clean-linux-armv7l:
	-rm -r ./$(subst clean-,,$@)

clean-linux-armv7l-native:
	-rm -r ./$(subst clean-,,$@)

clean-linux-x86_64:
	-rm -r ./$(subst clean-,,$@)

clean-linux-x86_64-native:
	-rm -r ./$(subst clean-,,$@)

