﻿/*---------------------------------------------------------------------------*
  Copyright (C) 2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

enum
{
    RYNDA_780_LC_ALL,
    RYNDA_780_LANG,
    RYNDA_780_LC_CTYPE,
    RYNDA_780_LC_NUMERIC,
    RYNDA_780_LC_TIME,
    RYNDA_780_LC_COLLATE,
    RYNDA_780_LC_MONETARY,
    RYNDA_780_LC_MESSAGES,
    RYNDA_780_TZ,
    RYNDA_780_DATEMSK,
    RYNDA_780_MSGVERB,
    RYNDA_780_END_OF_ORIG_ENV,
};

extern char **environ;

static char **rynda_780_orig_env[RYNDA_780_END_OF_ORIG_ENV+1];

void save_orig_env()
{
    if (getenv("LC_ALL") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_LC_ALL] = getenv("LC_ALL");
    }
    if (getenv("LANG") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_LANG] = getenv("LANG");
    }
    if (getenv("LC_CTYPE") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_LC_CTYPE] = getenv("LC_CTYPE");
    }
    if (getenv("LC_NUMERIC") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_LC_NUMERIC] = getenv("LC_NUMERIC");
    }
    if (getenv("LC_TIME") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_LC_TIME] = getenv("LC_TIME");
    }
    if (getenv("LC_TILC_COLLATE") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_LC_COLLATE] = getenv("LC_COLLATE");
    }
    if (getenv("LC_MONETARY") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_LC_MONETARY] = getenv("LC_MONETARY");
    }
    if (getenv("LC_MESSAGES") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_LC_MESSAGES] = getenv("LC_MESSAGES");
    }
    if (getenv("TZ") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_TZ] = getenv("TZ");
    }
    if (getenv("DATEMSK") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_DATEMSK] = getenv("DATEMSK");
    }
    if (getenv("MSGVERB") != NULL)
    {
        *rynda_780_orig_env[RYNDA_780_MSGVERB] = getenv("MSGVERB");
    }
}

void restore_orig_evn()
{
    if (rynda_780_orig_env[RYNDA_780_LC_ALL])
    {
        setenv("LC_ALL", *rynda_780_orig_env[RYNDA_780_LC_ALL], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_LANG])
    {
        setenv("LANG", *rynda_780_orig_env[RYNDA_780_LANG], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_LC_CTYPE])
    {
        setenv("LC_CTYPE", *rynda_780_orig_env[RYNDA_780_LC_CTYPE], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_LC_NUMERIC])
    {
        setenv("LC_NUMERIC", *rynda_780_orig_env[RYNDA_780_LC_NUMERIC], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_LC_TIME])
    {
        setenv("LC_TIME", *rynda_780_orig_env[RYNDA_780_LC_TIME], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_LC_COLLATE])
    {
        setenv("LC_TILC_COLLATE", *rynda_780_orig_env[RYNDA_780_LC_COLLATE], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_LC_MONETARY])
    {
        setenv("LC_MONETARY", *rynda_780_orig_env[RYNDA_780_LC_MONETARY], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_LC_MESSAGES])
    {
        setenv("LC_MESSAGES", *rynda_780_orig_env[RYNDA_780_LC_MESSAGES], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_TZ])
    {
        setenv("TZ", *rynda_780_orig_env[RYNDA_780_TZ], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_DATEMSK])
    {
        setenv("DATEMSK", *rynda_780_orig_env[RYNDA_780_DATEMSK], 1);
    }
    if (rynda_780_orig_env[RYNDA_780_MSGVERB])
    {
        setenv("MSGVERB", *rynda_780_orig_env[RYNDA_780_MSGVERB], 1);
    }
}

void rynda_780()
{
    NTD_TEST_GROUP_START("RYNDA-780", 1);

    char *s;
    int r;

    memset(rynda_780_orig_env, 0, (RYNDA_780_END_OF_ORIG_ENV+1)*sizeof(char **));
    save_orig_env();

    environ = NULL;

    TESTCASE_MESSAGE(environ == 0, "environ is not NULL\n");

    /* Test setenv */
    setenv("LC_ALL", "1", 1);
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"1") == 0), "LC_ALL should be \"1\", returned %s\n", s);
    }

    /* Test setenv with overwrite flag disabled */
    setenv("LC_ALL", "-2", 0);
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"1") == 0), "LC_ALL should be \"1\", returned %s\n", s);
    }

    /* Test setenv with overwrite flag enabled and a longer value */
    setenv("LC_ALL", "-2", 1);
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"-2") == 0), "LC_ALL should be \"-2\", returned %s\n", s);
    }

    /* Test putenv */
    putenv("LC_ALL=3");
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"3") == 0), "LC_ALL should be \"3\", returned %s\n", s);
    }

    /* Test putenv with a longer value */
    putenv("LC_ALL=abc");
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"abc") == 0), "LC_ALL should be \"abc\", returned %s\n", s);
    }

    /* Test setenv after putenv with overwrite flag disabled */
    setenv("LC_ALL", "def", 0);
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"abc") == 0), "LC_ALL should be \"abc\", returned %s\n", s);
    }

    /* Test putenv with a longer value */
    putenv("LC_ALL=13-4");
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"13-4") == 0), "LC_ALL should be \"13-4\", returned %s\n", s);
    }

    /* Test setenv after putenv with overwrite flag enabled */
    setenv("LC_ALL", "def", 1);
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"def") == 0), "LC_ALL should be \"def\", returned %s\n", s);
    }

    /* Test setenv with a shorter value */
    setenv("LC_ALL", "-1", 1);
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"-1") == 0), "LC_ALL should be \"-1\", returned %s\n", s);
    }

    /* Test putenv with a shorter value */
    putenv("LC_ALL=5");
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s != 0, "LC_ALL returned NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"5") == 0), "LC_ALL should be \"5\", returned %s\n", s);
    }

    /* Test LC_CTYPE */
    setenv("LC_CTYPE", "C", 1);
    s = getenv("LC_CTYPE");
    TESTCASE_MESSAGE(s != 0, "LC_CTYPE is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"C") == 0), "LC_CTYPE should be \"C\", returned %s\n", s);
    }

    /* Test LANG */
    putenv("LANG=C.UTF-8");
    s = getenv("LANG");
    TESTCASE_MESSAGE(s != 0, "LANG is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"C.UTF-8") == 0), "LANG should be \"C.UTF-8\", returned %s\n", s);
    }

    /* Test LC_NUMERIC */
    setenv("LC_NUMERIC", "COMMA_ON_3_ZEROES", 1);
    s = getenv("LC_NUMERIC");
    TESTCASE_MESSAGE(s != 0, "LC_NUMERIC is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"COMMA_ON_3_ZEROES") == 0), "LC_NUMERIC should be \"COMMA_ON_3_ZEROES\", returned %s\n", s);
    }

    /* Test LC_TIME */
    putenv("LC_TIME=10:08");
    s = getenv("LC_TIME");
    TESTCASE_MESSAGE(s != 0, "LC_TIME is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"10:08") == 0), "LC_TIME should be \"10:08\", returned %s\n", s);
    }

    /* Test LC_COLLATE */
    setenv("LC_COLLATE", "MULTIBYTE", 1);
    s = getenv("LC_COLLATE");
    TESTCASE_MESSAGE(s != 0, "LC_COLLATE is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"MULTIBYTE") == 0), "LC_COLLATE should be \"MULTIBYTE\", returned %s\n", s);
    }

    /* Test LC_MONETARY */
    putenv("LC_MONETARY=YEN");
    s = getenv("LC_MONETARY");
    TESTCASE_MESSAGE(s != 0, "LC_MONETARY is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"YEN") == 0), "LC_MONETARY should be \"YEN\", returned %s\n", s);
    }

    /* Test LC_MESSAGES */
    setenv("LC_MESSAGES", "JAPANESE", 1);
    s = getenv("LC_MESSAGES");
    TESTCASE_MESSAGE(s != 0, "LC_MESSAGES is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"JAPANESE") == 0), "LC_MESSAGES should be \"JAPANESE\", returned %s\n", s);
    }

    /* Test TZ */
    putenv("TZ=GREENWICH");
    s = getenv("TZ");
    TESTCASE_MESSAGE(s != 0, "TZ is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"GREENWICH") == 0), "TZ should be \"GREENWICH\", returned %s\n", s);
    }

    /* Test DATEMSK */
    setenv("DATEMSK", "MM/DD/YYYY", 1);
    s = getenv("DATEMSK");
    TESTCASE_MESSAGE(s != 0, "DATEMSK is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"MM/DD/YYYY") == 0), "DATEMSK should be \"MM/DD/YYYY\", returned %s\n", s);
    }

    /* Test MSGVERB */
    putenv("MSGVERB=OFF");
    s = getenv("MSGVERB");
    TESTCASE_MESSAGE(s != 0, "MSGVERB is NULL\n");
    if (s!=0)
    {
        TESTCASE_MESSAGE((strcmp(s,"OFF") == 0), "MSGVERB should be \"OFF\", returned %s\n", s);
    }

    /* Test unsetenv("LC_CTYPE"), previously set using setenv */
    unsetenv("LC_CTYPE");
    s = getenv("LC_CTYPE");
    TESTCASE_MESSAGE(s == 0, "unsetenv(\"LC_CTYPE\") is not NULL\n");

    /* Test unsetenv("LANG"), previously set using putenv */
    unsetenv("LANG");
    s = getenv("LANG");
    TESTCASE_MESSAGE(s == 0, "unsetenv(\"LANG\" is not NULL\n");

    /* Test putenv("MSGVERB") without assigned value, previously set using putenv with a value */
    putenv("MSGVERB");
    s = getenv("MSGVERB");
    TESTCASE_MESSAGE(s == 0, "putenv(\"MSGVERB\" is not NULL\n");

    clearenv();

    /* Test clearenv() */
    s = getenv("LC_ALL");
    TESTCASE_MESSAGE(s == 0, "clearenv() LC_ALL is not NULL\n");
    s = getenv("LC_NUMERIC");
    TESTCASE_MESSAGE(s == 0, "clearenv()LC_NUMERIC is not NULL\n");
    s = getenv("LC_TIME");
    TESTCASE_MESSAGE(s == 0, "clearenv()LC_TIME is not NULL\n");
    s = getenv("LC_COLLATE");
    TESTCASE_MESSAGE(s == 0, "clearenv()LC_COLLATE is not NULL\n");
    s = getenv("LC_MONETARY");
    TESTCASE_MESSAGE(s == 0, "clearenv()LC_MONETARY is not NULL\n");
    s = getenv("LC_MESSAGES");
    TESTCASE_MESSAGE(s == 0, "clearenv()LC_MESSAGES is not NULL\n");
    s = getenv("TZ");
    TESTCASE_MESSAGE(s == 0, "clearenv()TZ is not NULL\n");
    s = getenv("DATEMSK");
    TESTCASE_MESSAGE(s == 0, "clearenv()DATEMSK is not NULL\n");

    restore_orig_evn();
    NTD_TEST_GROUP_END("RYNDA-780", 1);
}
