﻿/*---------------------------------------------------------------------------*
  Copyright (C) 2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdarg.h>
#include <wchar.h>

float float2 = 1.2345;
float float3 = 0xc2f60000; /* -123.0 */
float float4 = 0x3cd1b717; /* 0.0256 */

static void *dummy_ptr = (void *) 0x12345678;

static void MyPrintf_rynda_492(int line, const wchar_t *expect, const wchar_t *fmt, ...)
{
    wchar_t *buffer = NULL;
    int ret_val = -1;
    wchar_t stack_buffer[512] = L"";
    size_t exp_len = wcslen(expect);

    buffer = stack_buffer;
    va_list ap;
    va_start(ap, fmt);
    ret_val = vswprintf(buffer, 511, fmt, ap); /* Original crash here */

    size_t len = wcslen(stack_buffer);
    if (!(ret_val == exp_len && len == exp_len && !wcscmp(expect, stack_buffer))) {
        printf("#define RESULT_STRING_%ls1 L\"%ls\"\n", fmt, stack_buffer);
        TESTCASE_WITH_LINE(line, false,
            "FAILED vswprintf(%ls) returned %d expected %d, got '%ls' expected '%ls' wcslen() = %d\n",
            fmt,
            ret_val, exp_len,
            stack_buffer, expect,
            len
            );
    } else {
        TESTCASE_SUCCESS();
    }

}

void rynda_492()
{
    NTD_TEST_GROUP_START("RYNDA-492", 1);
#define RESULT_STRING_1     L"                                                                                                Class,  Count,  NumKBytes,  MaxKBytes, ExclusiveResKBytes"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_1, L" %100ls, % 6ls, % 10ls, % 10ls, % 10ls",
        L"Class", L"Count", L"NumKBytes", L"MaxKBytes", L"ExclusiveResKBytes");
#define RESULT_STRING_2     L"0x12345678"
#define RESULT_STRING_3     L"  0x12345678"
#define RESULT_STRING_4     L"   0x12345678"
#define RESULT_STRING_5     L"          0x12345678"
#define RESULT_STRING_6     L"                         0x12345678"
    /* %p */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%hhp", dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%hp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%lp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%llp", dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%jp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%zp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%tp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%p",   dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"% 10lp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_3, L"% 12llp", dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_4, L"% 13jp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_5, L"% 20zp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_6, L"% 35tp",  dummy_ptr);

    /* %d */
#define RESULT_STRING_d1    L"15"
#define RESULT_STRING_d2    L"-246"
#define RESULT_STRING_d3    L"53478"
#define RESULT_STRING_d4    L"-6546793"
#define RESULT_STRING_d5    L"  " RESULT_STRING_d4
#define RESULT_STRING_d6    L"          " RESULT_STRING_d1
#define RESULT_STRING_d7    L"         " RESULT_STRING_d2
#define RESULT_STRING_d8    L"               " RESULT_STRING_d3
#define RESULT_STRING_d9    L"                           " RESULT_STRING_d4
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d1, L"%hhd",                   15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d2, L"%hd",                  -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d3, L"%ld",  (long)         53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d4, L"%lld", (long long) -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d1, L"%jd",  (intmax_t)        15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d2, L"%zd",  (size_t)        -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d3, L"%td",  (ptrdiff_t)    53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d1, L"%d",                     15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d5, L"% 10ld", (long)    -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d6, L"% 12lld",(long long)     15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d7, L"% 13jd", (intmax_t)    -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d8, L"% 20zd", (size_t)     53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d9, L"% 35td", (ptrdiff_t) -6546793);

    /* %i */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d1, L"%hhi",                   15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d2, L"%hi",                  -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d3, L"%li",  (long)         53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d4, L"%lli", (long long) -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d1, L"%ji",  (intmax_t)        15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d2, L"%zi",  (size_t)        -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d3, L"%ti",  (ptrdiff_t)    53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d1, L"%i",                     15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d5, L"% 10li", (long)    -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d6, L"% 12lli",(long long)     15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d7, L"% 13ji", (intmax_t)    -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d8, L"% 20zi", (size_t)     53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d9, L"% 35ti", (ptrdiff_t) -6546793);

    /* %u */
#define RESULT_STRING_u1 L"2"
#define RESULT_STRING_u2 L"12498"
#define RESULT_STRING_u3 L"533"
#define RESULT_STRING_u4 L"4294967295"
#define RESULT_STRING_u5 L"78034"
#define RESULT_STRING_u6 L"4294967295"
#define RESULT_STRING_u7 L"           2"
#define RESULT_STRING_u8 L"        78034"
#define RESULT_STRING_u9 L"                 533"
#define RESULT_STRING_u10 L"                         4294967295"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u1, L"%hhu", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u2, L"%hu", 78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u3, L"%lu", 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u4, L"%llu", (long long) 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u1, L"%ju", (intmax_t) 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u5, L"%zu", (size_t) 78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u3, L"%tu", (ptrdiff_t) 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u1, L"%u", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u6, L"% 10lu", 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u7, L"% 12llu", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u8, L"% 13ju", (uintmax_t)78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u9, L"% 20zu", (size_t) 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u10, L"% 35tu", (ptrdiff_t) 0xffffffff);

    /* %o */
#define RESULT_STRING_o1 L"2"
#define RESULT_STRING_o2 L"30322"
#define RESULT_STRING_o3 L"1025"
#define RESULT_STRING_o4 L"37777777777"
#define RESULT_STRING_o5 L"230322"
#define RESULT_STRING_o6 L"           2"
#define RESULT_STRING_o7 L"       230322"
#define RESULT_STRING_o8 L"                1025"
#define RESULT_STRING_o9 L"                        37777777777"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o1, L"%hho", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o2, L"%ho", 78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o3, L"%lo", (long) 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o4, L"%llo", (long long) 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o1, L"%jo", (intmax_t) 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o5, L"%zo", (size_t) 78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o3, L"%to", (ptrdiff_t) 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o1, L"%u", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o4, L"% 10lo", 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o6, L"% 12llo", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o7, L"% 13jo", (intmax_t)78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o8, L"% 20zo", 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o9, L"% 35to", 0xffffffff);

    /* %x */
#define RESULT_STRING_x1 L"2"
#define RESULT_STRING_x2 L"30d2"
#define RESULT_STRING_x3 L"215"
#define RESULT_STRING_x4 L"ffffffff"
#define RESULT_STRING_x5 L"130d2"
#define RESULT_STRING_x6 L"  ffffffff"
#define RESULT_STRING_x7 L"           2"
#define RESULT_STRING_x8 L"        130d2"
#define RESULT_STRING_x9 L"                 215"
#define RESULT_STRING_x10 L"                           ffffffff"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x1, L"%hhx", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x2, L"%hx", 78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x3, L"%lx", (long) 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x4, L"%llx", (long long) 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x1, L"%jx", (intmax_t) 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x5, L"%zx", (size_t) 78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x3, L"%tx", (ptrdiff_t) 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x1, L"%x", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x6, L"% 10lx", 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x7, L"% 12llx", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x8, L"% 13jx", (intmax_t) 78034);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x9, L"% 20zx", (size_t) 533);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x10, L"% 35tx", (ptrdiff_t) 0xffffffff);

    /* %X */
#define RESULT_STRING_X1 L"F"
#define RESULT_STRING_X2 L"FF0A"
#define RESULT_STRING_X3 L"D0E6"
#define RESULT_STRING_X4 L"FFFFFFFFFF9C1A97"
#define RESULT_STRING_X7 L"           F"
#define RESULT_STRING_X8 L"FFFFFFFFFFFFFF0A"
#define RESULT_STRING_X9 L"     FFFFFF0A"
#define RESULT_STRING_X10 L"                D0E6"

#ifdef __arm__
    #define RESULT_STRING_X5 L"FFFFFF0A"
    #define RESULT_STRING_X11 L"                           FF9C1A97"
    #define RESULT_STRING_X13 L"  FF9C1A97"
#else
    #define RESULT_STRING_X5 L"FFFFFFFFFFFFFF0A"
    #define RESULT_STRING_X11 L"                   FFFFFFFFFF9C1A97"
    #define RESULT_STRING_X13 L"FFFFFFFFFF9C1A97"
#endif

    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X1, L"%hhX", 15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X2, L"%hX", -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X3, L"%lX", (long) 53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X4, L"%llX", (long long) -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X1, L"%jX", (intmax_t) 15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X5, L"%zX", (size_t) -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X3, L"%tX", (ptrdiff_t) 53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X1, L"%X", 15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X13, L"% 10lX", (long) -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X7, L"% 12llX", 15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X8, L"% 13jX", (long long) -246);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X10, L"% 20zX", (size_t) 53478);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X11, L"% 35tX", (ptrdiff_t) -6546793);

    /* %f */
#define RESULT_STRING_f1 L"1.234500"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%f",   float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%hf",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%hhf", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%jf",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%lf",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%llf", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%tf",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%zf",  float2);
#if 0 /* Comment out tests with precision for now (RYNDA-635) */
#define RESULT_STRING_f1 L"1.234500"
#define RESULT_STRING_f2 L"-0.003000"
#define RESULT_STRING_f3 L"3270901760.000000"
#define RESULT_STRING_f4 L"1020376832.000000"
#define RESULT_STRING_f5 L" 1020376832.000000"
#define RESULT_STRING_f6 L"    1.234500"
#define RESULT_STRING_f7 L"    -0.003000"
#define RESULT_STRING_f8 L"   3270901760.000000"
#define RESULT_STRING_f9 L"                  1020376832.000000"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%hhf", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f2, L"%hf", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f3, L"%lf", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f4, L"%llf", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%jf", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f2, L"%zf", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f3, L"%tf", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f1, L"%f", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f5, L"% 10lf", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f6, L"% 12llf", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f7, L"% 13jf", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f8, L"% 20zf", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f9, L"% 35tf", float4);
#endif

    /* %F */
#define RESULT_STRING_F1 L"1.234500"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%F",   float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%hF",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%hhF", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%jF",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%lF",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%llF", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%tF",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%zF",  float2);
#if 0 /* Comment out tests with precision for now (RYNDA-635) */
#define RESULT_STRING_F1 L"1.2345"
#define RESULT_STRING_F2 L"-0.00300000"
#define RESULT_STRING_F3 L"3270901760.00"
#define RESULT_STRING_F4 L"1020376832.00000"
#define RESULT_STRING_F5 L"1.23"
#define RESULT_STRING_F6 L"-0.003"
#define RESULT_STRING_F7 L".73270901760.000000"
#define RESULT_STRING_F9 L"1.234"
#define RESULT_STRING_F10 L" 1020376832.000000"
#define RESULT_STRING_F11 L"    1.234500"
#define RESULT_STRING_F12 L"    -0.003000"
#define RESULT_STRING_F13 L"   3270901760.000000"
#define RESULT_STRING_F14 L"                  1020376832.000000"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F1, L"%.4hhF", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F2, L"%.8hF", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F3, L"%.2lF", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F4, L"%.5llF", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F5, L"%.2jF", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F6, L"%.3zF", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F7, L".7%tF", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F9, L"%.3F", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F10, L"% 10lF", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F11, L"% 12llF", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F12, L"% 13jF", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F13, L"% 20zF", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F14, L"% 35tF", float4);
#endif

    /* %e */
#define RESULT_STRING_e1 L"1.234500e+00"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%e",   float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%he",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%hhe", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%je",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%le",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%lle", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%te",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%ze",  float2);
#if 0 /* Comment out tests with precision for now (RYNDA-635) */
#define RESULT_STRING_e1 L"1.234500e+00"
#define RESULT_STRING_e2 L"-3.000000e-03"
#define RESULT_STRING_e3 L"3.270902e+09"
#define RESULT_STRING_e4 L"1.020377e+09"
#define RESULT_STRING_e5 L"1.234500e+00"
#define RESULT_STRING_e6 L"-3.000000e-03"
#define RESULT_STRING_e7 L"3.270902e+09"
#define RESULT_STRING_e9 L"1.234500e+00"
#define RESULT_STRING_e10 L" 1.020377e+09"
#define RESULT_STRING_e11 L" 1.234500e+00"
#define RESULT_STRING_e12 L"-3.000000e-03"
#define RESULT_STRING_e13 L"        3.270902e+09"
#define RESULT_STRING_e14 L"                       1.020377e+09"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e1, L"%hhe", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e2, L"%he", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e3, L"%le", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e4, L"%lle", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e5, L"%je", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e6, L"%ze", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e7, L"%te", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e9, L"%e", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e10, L"% 10le", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e11, L"% 12lle", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e12, L"% 13je", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e13, L"% 20ze", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e14, L"% 35te", float4);
#endif

    /* %E */
#define RESULT_STRING_E1 L"1.234500E+00"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%E",   float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%hE",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%hhE", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%jE",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%lE",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%llE", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%tE",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%zE",  float2);
#if 0 /* Comment out tests with precision for now (RYNDA-635) */
#define RESULT_STRING_E1 L"1.2345E+00"
#define RESULT_STRING_E2 L"-3.00000000E-03"
#define RESULT_STRING_E3 L"3.27E+09"
#define RESULT_STRING_E4 L"1.02038E+09"
#define RESULT_STRING_E5 L"1.23E+00"
#define RESULT_STRING_E6 L"-3.000E-03"
#define RESULT_STRING_E7 L".73.270902E+09"
#define RESULT_STRING_E9 L"1.234E+00"
#define RESULT_STRING_E10 L" 1.020377E+09"
#define RESULT_STRING_E11 L" 1.234500E+00"
#define RESULT_STRING_E12 L"-3.000000E-03"
#define RESULT_STRING_E13 L"        3.270902E+09"
#define RESULT_STRING_E14 L"                       1.020377E+09"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E1, L"%.4hhE", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E2, L"%.8hE", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E3, L"%.2lE", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E4, L"%.5llE", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E5, L"%.2jE", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E6, L"%.3zE", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E7, L".7%tE", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E9, L"%.3E", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E10, L"% 10lE", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E11, L"% 12llE", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E12, L"% 13jE", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E13, L"% 20zE", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E14, L"% 35tE", float4);
#endif

    /* %g */
#define RESULT_STRING_g1 L"1.2345"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%g",   float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%hg",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%hhg", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%jg",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%lg",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%llg", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%tg",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%zg",  float2);
#if 0 /* Comment out tests with precision for now (RYNDA-635) */
#define RESULT_STRING_g1 L"1.2345"
#define RESULT_STRING_g2 L"-0.003"
#define RESULT_STRING_g3 L"3.2709e+09"
#define RESULT_STRING_g4 L"1.02038e+09"
#define RESULT_STRING_g5 L" 1.02038e+09"
#define RESULT_STRING_g6 L"      1.2345"
#define RESULT_STRING_g7 L"       -0.003"
#define RESULT_STRING_g8 L"          3.2709e+09"
#define RESULT_STRING_g9 L"                        1.02038e+09"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%hhg", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g2, L"%hg", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g3, L"%lg", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g4, L"%llg", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%jg", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g2, L"%zg", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g3, L"%tg", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g1, L"%g", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g5, L"% 10lg", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g6, L"% 12llg", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g7, L"% 13jg", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g8, L"% 20zg", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g9, L"% 35tg", float4);
#endif

    /* %G */
#define RESULT_STRING_G1 L"1.2345"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%G",   float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%hG",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%hhG", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%jG",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%lG",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%llG", float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%tG",  float2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%zG",  float2);
#if 0 /* Comment out tests with precision for now (RYNDA-635) */
#define RESULT_STRING_G1 L"1.234"
#define RESULT_STRING_G2 L"-0.003"
#define RESULT_STRING_G3 L"3.3E+09"
#define RESULT_STRING_G4 L"1.0204E+09"
#define RESULT_STRING_G5 L"1.2"
#define RESULT_STRING_G6 L"-0.003"
#define RESULT_STRING_G7 L".73.2709E+09"
#define RESULT_STRING_G9 L"1.23"
#define RESULT_STRING_G10 L" 1.02038E+09"
#define RESULT_STRING_G11 L"      1.2345"
#define RESULT_STRING_G12 L"       -0.003"
#define RESULT_STRING_G13 L"          3.2709E+09"
#define RESULT_STRING_G14 L"                        1.02038E+09"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G1, L"%.4hhG", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G2, L"%.8hG", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G3, L"%.2lG", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G4, L"%.5llG", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G5, L"%.2jG", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G6, L"%.3zG", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G7,  L".7%tG", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G9, L"%.3G", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G10, L"% 10lG", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G11, L"% 12llG", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G12, L"% 13jG", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G13, L"% 20zG", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G14, L"% 35tG", float4);
#endif

    /* %a */
#if 0 /* Comment out %a until precision issues can be fixed (RYNDA-635) */
#define RESULT_STRING_a1 L"0x1.3c08p+0"
#define RESULT_STRING_a2 L"-0x1.89374bc7p-9"
#define RESULT_STRING_a3 L"0x1.86p+31"
#define RESULT_STRING_a4 L"0x1.e68dcp+29"
#define RESULT_STRING_a5 L"0x1.3cp+0"
#define RESULT_STRING_a6 L"-0x1.893p-9"
#define RESULT_STRING_a7 L"0x1.85ec000p+31"
#define RESULT_STRING_a9 L"0x1.3c083126e978dp+0"
#define RESULT_STRING_a10 L" 0x1.e68db8p+29"
#define RESULT_STRING_a11 L" 0x1.3c083126e978dp+0"
#define RESULT_STRING_a12 L"-0x1.89374bc6a7efap-9"
#define RESULT_STRING_a13 L"        0x1.85ecp+31"
#define RESULT_STRING_a14 L"                     0x1.e68db8p+29"

    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a1, L"%.4hha", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a2, L"%.8ha", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a3, L"%.2la", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a4, L"%.5lla", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a5, L"%.2ja", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a6, L"%.3za", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a7, L"%.7ta", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a9, L"%a", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a10, L"% 10la", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a11, L"% 12lla", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a12, L"% 13ja", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a13, L"% 20za", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a14, L"% 35ta", float4);
#endif

    /* %A */
#if 0 /* Comment out %a until precision issues can be fixed (RYNDA-635) */
#define RESULT_STRING_A1  L"0X1.3C08P+0"
#define RESULT_STRING_A2  L"-0X1.89374BC7P-9"
#define RESULT_STRING_A3  L"0X1.86P+31"
#define RESULT_STRING_A4  L"0X1.E68DCP+29"
#define RESULT_STRING_A5  L"0X1.3CP+0"
#define RESULT_STRING_A6  L"-0X1.893P-9"
#define RESULT_STRING_A7  L"0X1.85EC000P+31"
#define RESULT_STRING_A9  L"0X1.3C1P+0"
#define RESULT_STRING_A10 L" 0X1.E68DB8P+29"
#define RESULT_STRING_A11 L" 0X1.3C083126E978DP+0"
#define RESULT_STRING_A12 L"-0X1.89374BC6A7EFAP-9"
#define RESULT_STRING_A13 L"        0X1.85ECP+31"
#define RESULT_STRING_A14 L"                     0X1.E68DB8P+29"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A1, L"%.4hhA", 1.2345);   /* 0X1.3C08P+0 */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A2, L"%.8hA", -0.003);    /* -0X1.89374C00P-9 */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A3, L"%.2lA", float3);    /* 0X1.86P+31 */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A4, L"%.5llA", float4);  /* 0X1.E68DB8P+29 */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A5, L"%.2jA", 1.2345);    /* 0X1.3CP+0 */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A6, L"%.3zA", -0.003);    /* -0X1.8938P-9 */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A7, L"%.7tA", float3);   /* 0X1.85EC000P+31 */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A9, L"%.3A", 1.2345);     /* 0X1.3C08P+0 */
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A10, L"% 10lA", float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A11, L"% 12llA", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A12, L"% 13jA", -0.003);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A13, L"% 20zA", float3);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A14, L"% 35tA", float4);
#endif

    /* %c */
#define RESULT_STRING_c1 L"a"
#define RESULT_STRING_c2 L"         a"
#define RESULT_STRING_c3 L"           a"
#define RESULT_STRING_c4 L"            a"
#define RESULT_STRING_c5 L"                   a"
#define RESULT_STRING_c6 L"                                  a"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%hhc", 'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%hc", 'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%lc", L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%llc", (long long) L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%jc", (intmax_t) L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%zc", (size_t) L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%tc", (ptrdiff_t) L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%c", 'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c2, L"% 10lc", L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c3, L"% 12llc", (long long) L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c4, L"% 13jc", (intmax_t) L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c5, L"% 20zc", (size_t) L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c6, L"% 35tc", (ptrdiff_t) L'a');


// the "L" prefix is not valid for non-floating point types but we test it as if it was l:
#define RESULT_STRING_7     L"                              0x12345678"
#define RESULT_STRING_d10   L"                                      " RESULT_STRING_d1
#define RESULT_STRING_u11 L"                                       2"
#define RESULT_STRING_o10 L"                                       2"
#define RESULT_STRING_x11 L"                                       2"
#ifdef __arm__
    #define RESULT_STRING_X6 L"FF9C1A97"
#else
    #define RESULT_STRING_X6 L"FFFFFFFFFF9C1A97"
#endif
#define RESULT_STRING_X12 L"                                       F"
#define RESULT_STRING_f10 L"                       1020376832.000000"
#define RESULT_STRING_F8 L"1020376832.000000000"
#define RESULT_STRING_F15 L"                       1020376832.000000"
#define RESULT_STRING_e8 L"1.020377e+09"
#define RESULT_STRING_e15 L"                            1.234500e+00"
#define RESULT_STRING_E8 L"1.020376832E+09"
#define RESULT_STRING_E15 L"                            1.234500E+00"
#define RESULT_STRING_g10 L"                                  1.2345"
#define RESULT_STRING_G8 L"1.02037683E+09"
#define RESULT_STRING_G15 L"                                  1.2345"
#define RESULT_STRING_a8  L"0x1.e68db8p+29"
#define RESULT_STRING_a15 L"                    0x1.3c083126e978dp+0"
#define RESULT_STRING_A8  L"0X1.E68DB8000P+29"
#define RESULT_STRING_A15 L"                    0X1.3C083126E978DP+0"
#define RESULT_STRING_c7 L"                                       a"
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_2, L"%Lp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_7, L"% 40Lp",  dummy_ptr);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d4, L"%Ld",  (long)      -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d10,L"% 40Ld", 15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d4, L"%Li",  (long)      -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_d10,L"% 40Li", 15);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u4, L"%Lu", 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_u11,L"% 40Lu", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o4, L"%Lo", (long) 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_o10, L"% 40Lo", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x4, L"%Lx", 0xffffffff);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_x11, L"% 40Lx", 2);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X6, L"%LX", (long) -6546793);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_X12, L"% 40LX", 15);
#if 0
    // don't test long double as it may produce different results depending on the processor
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f4, L"%Lf", (long double) float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_f10, L"% 40Lf", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F8, L"%.9LF", (long double) float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_F15, L"% 40LF", 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e8, L"%Le", (long double) float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_e15, L"% 40Le", (long double) 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E8, L"%.9LE", (long double) float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_E15, L"% 40LE", (long double) 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g4, L"%Lg", (long double) float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_g10, L"% 40Lg", (long double) 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G8, L"%.9LG", (long double) float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_G15, L"% 40LG", (long double) 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a8, L"%La", (long double) float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_a15, L"% 40La", (long double) 1.2345);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A8, L"%.9LA", (long double) float4);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_A15, L"% 40LA", (long double) 1.2345);
#endif
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c1, L"%Lc", L'a');
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_c7, L"% 40Lc", (long) L'a');

    /* %n */
#define RESULT_STRING_n1 L"XYZ"
    unsigned char   nchars_char;
    unsigned short  nchars_short;
    int             nchars_int;
    intmax_t        nchars_intmax_t;
    size_t          nchars_size_t;
    ptrdiff_t       nchars_ptrdiff_t;
    long            nchars_long;
    long long       nchars_long_long;

    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%hhn",    &nchars_char);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%hn",     &nchars_short);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%ln",     &nchars_long);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%lln",    &nchars_long_long);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%jn",     &nchars_intmax_t);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%zn",     &nchars_size_t);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%tn",     &nchars_ptrdiff_t);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%Ln",     &nchars_long);
    MyPrintf_rynda_492(__LINE__, RESULT_STRING_n1, L"XYZ%n",      &nchars_int);
    TESTCASE_MESSAGE(nchars_char == 3
        && nchars_short == 3
        && nchars_long == 3
        && nchars_long_long == 3
        && nchars_intmax_t == 3
        && nchars_size_t == 3
        && nchars_ptrdiff_t == 3
        && nchars_long == 3
        && nchars_int == 3,
        "\ntesting %%n expect all values to == 3: %d, %d, %ld, %lld, %jd, %zd, %td, %ld, %d\n",
            nchars_char,
            nchars_short,
            nchars_long,
            nchars_long_long,
            nchars_intmax_t,
            nchars_size_t,
            nchars_ptrdiff_t,
            nchars_long,
            nchars_int
        );

    NTD_TEST_GROUP_END("RYNDA-492", 1);
}
