﻿/*---------------------------------------------------------------------------*
  Copyright (C) 2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stdio.h>
#include <wchar.h>

#define TEST_293_SWPRINTF(expect_count, expect, buf, ...) \
    do { \
    int count = swprintf(buf, sizeof(buf) / sizeof(wchar_t), __VA_ARGS__);    \
     TESTCASE_MESSAGE((count == (expect_count)) && wcscmp(buf, expect) == 0,    \
        "buf = '%s', wcslen(buf) = %d, count = %d", \
        buf, wcslen(buf), count);   \
    } while (0)

#define TEST_293_SNPRINTF(expect_count, expect, buf, ...) \
    do { \
    int count = snprintf(buf, sizeof(buf), __VA_ARGS__);    \
     TESTCASE_MESSAGE((count == (expect_count)) && strcmp(buf, expect) == 0,    \
        "buf = '%s', strlen(buf) = %d, count = %d", \
        buf, strlen(buf), count);   \
    } while (0)

void rynda_293()
{
    static char buf[256];
    static wchar_t wc_buf[256];
    int count;

    NTD_TEST_GROUP_START("RYNDA-293", 1);
    count = snprintf(buf, sizeof(buf), "%5.3ls", L"12345");
    TESTCASE_MESSAGE(strcmp(buf, "  123") == 0,
        "buf = '%s', strlen(buf) = %d, count = %d",
        buf,
        strlen(buf),
        count);

    count = swprintf(wc_buf, sizeof(wc_buf) / sizeof(wchar_t), L"%5.3ls", L"12345");
    TESTCASE_MESSAGE(wcscmp(wc_buf, L"  123") == 0,
        "wc_buf = '%ls', wcslen(wc_buf) = %d, count = %d",
        wc_buf,
        wcslen(wc_buf),
        count);

    count = snprintf(buf, sizeof(buf), "%#010o %#010o %#010o %#010o", 0, 0, 0xabcdef, 0xABCDEF);
    TESTCASE_MESSAGE(strcmp(buf, "0000000000 0000000000 0052746757 0052746757") == 0,
        "buf = '%s', strlen(buf) = %d, count = %d",
        buf,
        strlen(buf),
        count);
    NTD_TEST_GROUP_END("RYNDA-293", 1);


    TEST_293_SWPRINTF(5, L"  123", wc_buf, L"%5.3ls", L"12345");
    TEST_293_SWPRINTF(5, L"123  ", wc_buf, L"%-5.3ls", L"12345");
    TEST_293_SWPRINTF(5, L"  123", wc_buf, L"%*.*ls", 5, 3, L"12345");

    TEST_293_SWPRINTF(3, L"  A", wc_buf, L"%3lc", 0x41);
    TEST_293_SWPRINTF(3, L"A  ", wc_buf, L"%-3lc", 0x41);
    TEST_293_SWPRINTF(1, L"A",   wc_buf, L"%1.0lc", 0x41);
    TEST_293_SWPRINTF(1, L"あ",  wc_buf, L"%lc", L'あ');
    TEST_293_SWPRINTF(3, L"  あ", wc_buf, L"%3lc", L'あ');
    TEST_293_SWPRINTF(3, L"あ  ", wc_buf, L"%-3lc", L'あ');
    TEST_293_SWPRINTF(1, L"ァ", wc_buf, L"%lc", L'ァ');
    TEST_293_SWPRINTF(3, L"  ァ", wc_buf, L"%3lc", L'ァ');
    TEST_293_SWPRINTF(3, L"ァ  ", wc_buf, L"%-3lc", L'ァ');
    TEST_293_SWPRINTF(1, L"壽", wc_buf, L"%lc", L'壽');
    TEST_293_SWPRINTF(3, L"  壽", wc_buf, L"%3lc", L'壽');
    TEST_293_SWPRINTF(3, L"壽  ", wc_buf, L"%-3lc", L'壽');
    TEST_293_SWPRINTF(5, L"あいうえお", wc_buf, L"%ls", L"あいうえお");

    TEST_293_SWPRINTF(6, L"(null)", wc_buf, L"%ls", (wchar_t*)NULL);
    TEST_293_SWPRINTF(6, L"(null)", wc_buf, L"%s",  (char*)NULL);
    TEST_293_SWPRINTF(5, L"  123",  wc_buf, L"%5.3ls", L"12345");
    TEST_293_SWPRINTF(5, L"123  ",  wc_buf, L"%-5.3ls", L"12345");
    TEST_293_SWPRINTF(5, L"  123",  wc_buf, L"%*.*ls", 5, 3, L"12345");
    TEST_293_SWPRINTF(3, L"  A",    wc_buf, L"%3lc", 0x41);
    TEST_293_SWPRINTF(3, L"A  ",    wc_buf, L"%-3lc", 0x41);
    TEST_293_SWPRINTF(1, L"A",      wc_buf, L"%1.0lc", 0x41);
    TEST_293_SWPRINTF(1, L"あ",     wc_buf, L"あ");
    TEST_293_SWPRINTF(5, L"あいうえお", wc_buf, L"%ls", L"あいうえお");

    TEST_293_SWPRINTF(10, L"あいうえおァィゥェォ", wc_buf, L"%ls", L"あいうえおァィゥェォ");
    TEST_293_SWPRINTF(16, L"あいうえおァィゥェォ123abc", wc_buf, L"%ls", L"あいうえおァィゥェォ123abc");
    TEST_293_SWPRINTF(18, L"あいうえお ァィゥェォ 123abc", wc_buf, L"%ls", L"あいうえお ァィゥェォ 123abc");
    TEST_293_SWPRINTF(18, L"あ1いう3aえお ァィb2ゥェォ c", wc_buf, L"%ls", L"あ1いう3aえお ァィb2ゥェォ c");
    TEST_293_SWPRINTF(18, L" cあ1いう3aえお ァィb2ゥェォ", wc_buf, L"%ls", L" cあ1いう3aえお ァィb2ゥェォ");
    TEST_293_SWPRINTF(21, L"賀 壽あ1いう3aえお ァィb2ゥェォ c", wc_buf, L"%ls", L"賀 壽あ1いう3aえお ァィb2ゥェォ c");
    TEST_293_SWPRINTF(4, L"可喜可賀", wc_buf, L"%ls", L"可喜可賀");
    TEST_293_SWPRINTF(4, L"  可喜", wc_buf, L"%4.2ls", L"可喜可賀");

    TEST_293_SNPRINTF(6, "(null)", buf, "%ls", (wchar_t*)NULL);
    TEST_293_SNPRINTF(6, "(null)", buf, "%s",  (char*)NULL);
}
