﻿/*---------------------------------------------------------------------------*
  Copyright (C) 2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stdio.h>
#include <stdarg.h>

static wchar_t nsbg_3671_expect_str[] = L"test string has 36 wide characters.\n";
void nsbg_3671_PrintWide(const wchar_t * format, ...)
{
    wchar_t buffer[256];
    va_list args;
    va_start(args, format);
    int len = vswprintf(buffer, 256, format, args);
    TESTCASE(len == 36); // "%d" => "36" so result should be 36
    TESTCASE(wcscmp(buffer, nsbg_3671_expect_str) == 0);
    va_end(args);
}

void nsbg_3671()
{
    wchar_t str[] = L"test string has %d wide characters.\n";
    NTD_TEST_GROUP_START("NSBG-3671", 1);
    nsbg_3671_PrintWide(str, wcslen(str));
    NTD_TEST_GROUP_END("NSBG-3671", 1);
}
