﻿/*---------------------------------------------------------------------------*
  Copyright (C) 2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stdio.h>
#include <stdarg.h>

static int test_vprintf(const char *fmt,...)
{
    int ret;
    va_list ap;
    va_start(ap, fmt);
    ret = vprintf(fmt, ap);
    va_end(ap);
    return ret;
}

void nsbg_2665()
{
    const int expected_result = 20;
    int result = -1;
    NTD_TEST_GROUP_START("NSBG-2665", 1);
    result = test_vprintf("CHECKING vprintf %d\n", 42);
    TESTCASE_MESSAGE(result == expected_result,
        "vprintf() failed. Expected %d, got %d\n", expected_result, result);
    NTD_TEST_GROUP_END("NSBG-2665", 1);
}
