#!/bin/bash

#-------------------------------------------------------------------------------
#  This script generates a "!.nact" file that can be used to build the LibcTest
#  sources from the SDK/Samples directory even though those LibcTest sources
#  exist in another folder.
#
#  This script assumes it is being run from the "LibcTest" sources directory.
#-------------------------------------------------------------------------------

input_file="!.nact"
output_file="!.nact--external"
RYNDA_SDK_LIBC_TEST_PATH="/src/lib/nnmusl/test/LibcTest/"

if [ -e ${output_file} ]; then
    rm ${output_file}
fi
touch ${output_file}

prev_line=""
changing_source_files=0
changing_include_dirs=0

ORIG_IFS=${IFS}
IFS=''
while read line
do
    if [[ ${prev_line} =~ "ProgramName =" ]]
    then
        echo "    filesBase = MakeFilePath(\""`pwd -W`"\", \"RootRelative\");" \
          >> ${output_file}
    fi

    print_line=${line}

    # Changing source file lines to use "filesBase.Combine("
    if [[ ${prev_line} =~ "SourceFiles" ]]; then
      changing_source_files=1
    fi
    if [ ${changing_source_files} -eq 1 ]
    then
      if [[ ${line} =~ ");" ]];
      then
        changing_source_files=0
      else
        # Don't manipulate an empty line or one that has only whitespace
        if ! [[ -z "${line// }" ]]
        then
          print_line=${print_line/f\"/filesBase.Combine(\"}
          print_line=${print_line%,*}"),"
        fi
      fi
    fi

    # Changing include path lines to use "MakeFilePath(filesBase.Combine("
    if [[ ${prev_line} =~ "AdditionalIncludeSearchPath" ]]; then
      changing_include_dirs=1
    fi
    if [ ${changing_include_dirs} -eq 1 ]
    then
      if [[ ${line} =~ ");" ]];
      then
        changing_include_dirs=0
      else
        # If-check to skip comments
        if ! [[ ${line} =~ "#" ]] && ! [[ ${line} =~ "//" ]]
        then
          print_line=${print_line/MakeFilePath(/MakeFilePath(filesBase.Combine(}
          print_line=${print_line%)*}")),"
        fi
      fi
    fi

    echo ${print_line} >> ${output_file}

    prev_line=${line}

done < ${input_file}
IFS=${ORIG_IFS}
