#!/bin/bash
source ${SIGLO_BASE}/scripts/env_siglo.sh

TEST_BUILD_DIR=${SIGLO_BUILD}/test/LibcTest
TEST_SRC_DIR=${SIGLO_SRC}/lib/nnmusl/test/LibcTest

# setup for building nnmusl

mkdir -p ${TEST_BUILD_DIR}

echo "# this file is generated" > ${TEST_BUILD_DIR}/Makefile
echo >> ${TEST_BUILD_DIR}/Makefile
echo "include \$(SIGLO_SRC)/lib/nnmusl/test/LibcTest/makealltargets.mk" >> ${TEST_BUILD_DIR}/Makefile
echo >> ${TEST_BUILD_DIR}/Makefile

for target in ${SIGLO_TARGETS}
do
    echo
    echo "configure ntd-test-libc for $target in build directory ${TEST_BUILD_DIR}/${target}"
    mkdir -p ${TEST_BUILD_DIR}/${target}
    cd ${TEST_BUILD_DIR}/${target}
    cmake -G "${NNMUSL_CMAKE_GENERATOR}"                           \
            -DCMAKE_TOOLCHAIN_FILE=${SIGLO_TOOLS}/Toolchain-siglo-${target}.cmake   \
            -DCMAKE_INSTALL_PREFIX=${SIGLO_SDK}/${target}		\
            -DCMAKE_BUILD_TYPE=RelWithDebInfo               	\
            ${TEST_SRC_DIR}
done
