﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nnt/gtest/detail/gtest-heap.h>

namespace nnt { namespace testing { namespace detail {

template<class T1, class T2>
struct Pair final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    typedef T1 first_type;
    typedef T2 second_type;

public:
    T1 first;
    T2 second;

    Pair() NN_NOEXCEPT
        : first()
        , second()
    {
    }

    Pair(const Pair& other) NN_NOEXCEPT
        : first(other.first)
        , second(other.second)
    {
    }

    Pair(Pair&& other) NN_NOEXCEPT
        : first(other.first)
        , second(other.second)
    {
    }

    Pair(const T1& lhs, const T2& rhs) NN_NOEXCEPT
        : first(lhs)
        , second(rhs)
    {
    }

    template<typename U1, typename U2>
    Pair(const Pair<U1, U2>& other) NN_NOEXCEPT
        : first(other.first)
        , second(other.second)
    {
    }

    Pair& operator=(const Pair& other) NN_NOEXCEPT
    {
        this->first = other.first;
        this->second = other.second;
        return *this;
    }

    Pair& operator=(Pair&& other) NN_NOEXCEPT
    {
        this->first = other.first;
        this->second = other.second;
        return *this;
    }

    bool operator==(const Pair& other) const NN_NOEXCEPT
    {
        return (this->first == other.first) && (this->second == other.second);
    }

    bool operator!=(const Pair& other) const NN_NOEXCEPT
    {
        return !(*this == other);
    }

    bool operator<(const Pair& other) const NN_NOEXCEPT
    {
        if (this->first < other.first)
        {
            return true;
        }

        if (other.first < this->first)
        {
            return false;
        }

        if (this->second < other.second)
        {
            return true;
        }

        return false;
    }
};

class Utility final
{
public:
    template<class T1, class T2>
    static inline Pair<T1, T2> Make_pair(T1 lhs, T2 rhs) NN_NOEXCEPT
    {
        return Pair<T1, T2>(lhs, rhs);
    }

    template<class T>
    static inline void Swap(T& a, T& b) NN_NOEXCEPT
    {
        T c = a;
        a = b;
        b = c;
    }

private:
    Utility();

    NN_DISALLOW_COPY(Utility);
    NN_DISALLOW_MOVE(Utility);
};

}}} // namespace nnt::testing::detail
