﻿//==============================================================================
//  Copyright (C) Deja Tools, LLC.  All rights reserved.
//==============================================================================

#pragma once

#ifdef NN_NINTENDO_SDK
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/htcs/htcs_Socket.h>
#include <nn/os/os_ThreadApi.h>
//#define REPORT( ... ) nn::tma::log::Log( __VA_ARGS__ )
#ifdef _WIN32
#define REPORT( ... ) printf( __VA_ARGS__ )
#else
#define REPORT( ... ) NN_LOG( __VA_ARGS__ )
#define SLEEP( X ) nn::os::SleepThread( nn::TimeSpan::FromSeconds( (X) ))
#endif
#ifdef _WIN32
#include <Windows.h>
#endif
#else
#include <stdint.h>
#include <tchar.h>
#include <WinSock2.h>
#include <ws2tcpip.h>
#include <Windows.h>
#define REPORT(s, ... ) printf(s, __VA_ARGS__ )
#endif

#if __NX__
#define STRCAT( Dest, Source ) strcat( Dest, Source )
#define STRCPY( Dest, Source ) strcpy( Dest, Source )
#define STRNCMP( Comp1, Comp2, Length ) strncmp( Comp1, Comp2, Length)
#else
#define STRCAT( Dest, Source ) strcat( Dest, Source )
#define STRCPY( Dest, Source ) strcpy_s( Dest, 256, Source )
#define STRNCMP( Comp1, Comp2, Length ) strncmp( Comp1, Comp2, Length)
#endif


//============================================================================================
// System prep and close.
void InitSystem( void );
void CloseSystem( void );

//============================================================================================
// Socket utilities.

//===============================================================================================
//  Creates a listening socket for our server.  Returns the socket or < 0 if there was an error.
#ifdef NN_NINTENDO_SDK
int CreateListeningSocket( const char* pServerName, const char* pPortName );
#else
int CreateListeningSocket( int PortNumber );
#endif

//============================================================================================
//  Creates a connecting socket to the passed server.  Returns < 0 if there's an error.
#ifdef NN_NINTENDO_SDK
int CreateConnectSocket( const char* pHTCSServerName, const char* pHTCSServerPortName );
#else
int CreateConnectSocket( char* pIPAddress, int Port );
#endif

//========================================================================================
// Platform-specific flags to use for the Recv and Send calls.
#ifdef NN_NINTENDO_SDK
#define HTCS_MSG_PEEK       nn::htcs::HTCS_MSG_PEEK
#define HTCS_MSG_WAITALL    nn::htcs::HTCS_MSG_WAITALL
#else
#define HTCS_MSG_PEEK       MSG_PEEK
#define HTCS_MSG_WAITALL    MSG_WAITALL
#endif

//========================================================================================
// Thin platform-agnostic layer to the Recv call.  Returns the value that recv returns.
int Recv( int Socket, char* pDataBuffer, size_t ReadAmount, int Flags );

//========================================================================================
// Thin platform-agnostic layer to the Send call.  Returns the value that send returns.
int Send( int Socket, const char* pData, size_t SizeOfData, int Flags );

//========================================================================================
// Thin platform-agnostic layer to the close call.  Returns the value that close returns.
int CloseSocket( int Socket );

//============================================================================================
// Returns a random number in the given range, inclusive (ie., could be == Min or == Max ).
int GetRandom( int Min, int Max );

//============================================================================================
// Given the passed command-line arguments, finds one with the given tag and puts it's value
// into the passed pArgValue buffer.
// Returns TRUE if found, FALSE if not.
bool GetArg( int NumArgs, char** pArgs, const char* pFindArg, char* pArgValue );

//============================================================================================
// Thread functionality.

typedef void* THREAD_FUNCTION ( void* pArgs );

#ifdef __NX__
typedef nn::os::ThreadType ThreadId;
#else
typedef unsigned int ThreadId;
#endif

//==============================================================================
// API
bool StartThread( THREAD_FUNCTION* pfnThread, const char* pThreadName, void* pStack, size_t StackSize, void* pArg, ThreadId* pThread );
void JoinThread( ThreadId* pThread );

