﻿/*----------------------------------------------------------------------*
  Project: ND Float Double Test
 *----------------------------------------------------------------------*/

// Intended to help test [OASIS-67], [OASIS-68]
// https://panicbutton.atlassian.net/browse/OASIS-189

#include "../print.h"

#ifndef __NX__
#include <stdint.h>
#include <memory.h>
#endif

#ifndef __NX__
int main( int argc, char** argv )
#else
extern "C" void nnMain( void )
#endif

{
    int int1 = 0;
    int int2 = 1;
    long long longlong2 = 1;
    float float0 = 1.0f;                                                                  // 1.00000000
    float float1 = 0;                                                                     // 0.00000000
    float float2 = -1.0f;                                                                 // -1.00000000
    float float3 = 1234567890123456789.0f;                                                // 1.23456794e+018
    float float4 = 0.000000000001234567890123456789f;                                     // 1.23456789e-012
    float float5 = 0.00000000000000000000000000000000000000000001234567890123456789f;     // 1.261e-044#DEN
    float float6 = 2.0f / int1;                                                           // 1.#INF
    float float7 = -2.0f / int1;                                                          // -1.#INF
    float float8 = *(float*)&int2;                                                        // -1.#QNAN

    double double0 = 1.0;                                                                 // 1.0000000000000000
    double double1 = 0;                                                                   // 0.0000000000000000
    double double2 = -1.0;                                                                // -1.0000000000000000
    double double3 = 1234567890123456789.0;                                               // 1.2345678901234568e+018
    double double4 = 0.000000000001234567890123456789;                                    // 1.2345678901234569e-012
#ifdef __NX__
    double double5 = 0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001234567890123456789
        / 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.0
        / 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.0
        / 1000000000000000000000000000000000000.0;                                        // 1.234566295172e-318#DEN
    double double6 = 2.0 / int1;                                                          // 1.#INF
    double double7 = -2.0 / int1;                                                         // -1.#INF
    double double8 = *(double*)&longlong2;                                                // -1.#QNAN - However, Windows displays this as: 4.940656458412e-324#DEN
#else
    // This block deals with RefTarget having major problems with division.
    // Raw memory is used to initialize values to their "end result equivalent
    // to the NX" board.
    // RefTarget also has problems casting, so memcpy's are used.
    double double5 = -1.0;
    double double6 = 1.0;
    double double7 = -1.0;
    double double8 = 0.0;
    {
        const int64_t RAMEquivalentForDouble5 = 0x0000000000000000619c;                   // represents  1.234566295172e-318#DEN in "raw memory"
        const int64_t RAMEquivalentForDouble6 = 0x7ff0000000000000;                       // represents  1.#INF000000000000 in "raw memory"
        const int64_t RAMEquivalentForDouble7 = 0xfff0000000000000;                       // represents -1.#INF000000000000 in "raw memory"
        memcpy( &double5, &RAMEquivalentForDouble5, sizeof(double5) );
        memcpy( &double6, &RAMEquivalentForDouble6, sizeof(double6) );
        memcpy( &double7, &RAMEquivalentForDouble7, sizeof(double7) );
        memcpy( &double8, &longlong2, sizeof(double8) );                                  // represents -1.#QNAN - However, Windows displays this as: 4.940656458412e-324#DEN
    }
#endif

    long double longdouble0 = 1.0l;                                                       // 1.0000000000000000
    long double longdouble1 = 0.0l;                                                       // 0.0000000000000000
    long double longdouble2 = -1.0l;                                                      // -1.0000000000000000
    long double longdouble3 = 1234567890123456789.0l;                                     // 1.2345678901234568e+018
    long double longdouble4 = 0.000000000001234567890123456789l;                          // 1.2345678901234569e-012
#ifdef __NX__
    long double longdouble5 = 0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001234567890123456789l
        / 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.0l
        / 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.0l
        / 1000000000000000000000000000000000000.0l;                                       // 1.234566295172e-318#DEN
    long double longdouble6 = 2.0l / int1;                                                // 1.#INF
    long double longdouble7 = -2.0l / int1;                                               // -1.#INF
    long double longdouble8 = *(long double*)&longlong2;                                  // -1.#QNAN
#else
    long double longdouble5 = 0.0;
    long double longdouble6 = 0.0;
    long double longdouble7 = 0.0;
    long double longdouble8 = 0.0;
    {
        const int64_t RAMEquivalentForLongDouble5 = 0x0000000000000000619c;               // represents  1.234566295172e-318#DEN in "raw memory"
        const int64_t RAMEquivalentForLongDouble6 = 0x7ff0000000000000;                   // represents  1.#INF000000000000 in "raw memory"
        const int64_t RAMEquivalentForLongDouble7 = 0xfff0000000000000;                   // represents -1.#INF000000000000 in "raw memory"
        memcpy( &longdouble5, &RAMEquivalentForLongDouble5, sizeof(longdouble5) );
        memcpy( &longdouble6, &RAMEquivalentForLongDouble6, sizeof(longdouble6) );
        memcpy( &longdouble7, &RAMEquivalentForLongDouble7, sizeof(longdouble7) );
        memcpy( &longdouble8, &longlong2, sizeof(longdouble8) );                          // represents -1.#QNAN - However, Windows displays this as: 4.940656458412e-324#DEN
    }
#endif

    int SetBreakpointHere = 0; //Set breakpoint here!

    PRINT( "Running program from " __FILE__ "\n" );

#ifndef __NX__
    return 0;
#endif
}

