﻿// Creating a complex class hierarchy, filled with statics. The objective of the
// test is to determine if those statics can be viewed in the watch window. To
// test, set a breakpoint in main, then verify all statics can be viewed in the
// watch window. Also test additional expressions that access parent statics
// from the context of child classes, "TheChild::BaseInt" for example.
class TheBase {
public:
    static int BaseInt;
    static int BaseConflictInt;
    static int Int;
           int UnusedInt;

    class TheNestedBase {
public:
        static int NestedBaseInt;
        static int Int;
    };
};
class TheOtherBase {
public:
    static int OtherBaseInt;
    static int BaseConflictInt;
    static int Int;

    class TheOtherNestedBase {
public:
        static int OtherNestedBaseInt;
        static int Int;
    };
};
class TheMiddle : public TheBase, public TheOtherBase {
public:
    static int MiddleInt;
    static int Int;
    static TheBase BaseClass;
    static TheOtherBase OtherBaseClass;

    class TheNestedMiddle {
public:
        static int NestedMiddleInt;
        static int Int;
        static TheBase BaseClass;
    };
};
class TheChild : public TheMiddle {
public:
    static int ChildInt;
    static int Int;
    static TheMiddle MiddleClass;

    class TheNestedChild {
public:
        static int NestedChildInt;
        static int Int;
        static TheMiddle MiddleClass;
    };
};
int TheBase::Int;
int TheBase::TheNestedBase::Int;
int TheOtherBase::Int;
int TheOtherBase::TheOtherNestedBase::Int;
int TheMiddle::Int;
int TheMiddle::TheNestedMiddle::Int;
int TheChild::Int;
int TheChild::TheNestedChild::Int;
int TheBase::BaseInt;
int TheBase::BaseConflictInt;
int TheBase::TheNestedBase::NestedBaseInt;
int TheOtherBase::OtherBaseInt;
int TheOtherBase::BaseConflictInt;
int TheOtherBase::TheOtherNestedBase::OtherNestedBaseInt;
int TheMiddle::MiddleInt;
int TheMiddle::TheNestedMiddle::NestedMiddleInt;
int TheChild::ChildInt;
int TheChild::TheNestedChild::NestedChildInt;
// Static class objects that link to base classes.
TheBase         TheMiddle::TheNestedMiddle::BaseClass;
TheMiddle       TheChild::TheNestedChild::MiddleClass;
TheBase         TheMiddle::BaseClass;
TheOtherBase    TheMiddle::OtherBaseClass;
TheMiddle       TheChild::MiddleClass;

// Multiple namespaces with identical class and var names. Static variables
// scattered throughout. To test, set breakpoints within the NS2 namespace,
// then verify all statics defined. Note the placement of the breakpoints
// will change the context of some static var expressions, "Z::Int" is a
// static var expression that depends on the context of being within the
// "Y" class scope or the "X" class scope.
namespace NS1
{
    class X
    {
    public:
        class Y
        {
        public:
            static int Int;
        };
    public:
        static void Increment()
        {
            ++Y::Int;
        }
    };

    void Increment()
    {
        ++X::Y::Int;
    }
}
int NS1::X::Y::Int = 1;

namespace NS2
{
    class X
    {
    public:
        class Y
        {
    public:
            static int Int;
        public:
            class Z
            {
            public:
                static int Int;
            };
        public:
            static void Increment()
            {
                ++Y::Int;
                ++Y::Z::Int;
                ++X::Z::Int;
                ++X::Int; // Set breakpoint here.
            }
        };
    public:

        static void Increment()
        {
            ++Y::Int;
            ++Y::Z::Int;
            ++Z::Int;
            ++Int; // Set breakpoint here.
        }
    public:
        class Z
        {
        public:
            static int Int;
        };
        static int Int;
    };

    void Increment()
    {
        ++X::Y::Int;
        ++X::Y::Z::Int;
        ++X::Z::Int;
        ++X::Int;
    }
}
int NS2::X::Y::Int    = 10;
int NS2::X::Y::Z::Int = 100;
int NS2::X::Z::Int    = 1000;
int NS2::X::Int       = 10000;

namespace NS3
{
    class X
    {
    public:
        class Y
        {
    public:
            static int Int;
        };
    public:
        static void Increment()
        {
            ++Y::Int;
        }
    };

    void Increment()
    {
        ++X::Y::Int;
    }
}
int NS3::X::Y::Int = 100000;


extern "C" void nnMain()
{
    TheBase::Int = 1;
    TheBase::TheNestedBase::Int = 2;
    TheOtherBase::Int = 3;
    TheOtherBase::TheOtherNestedBase::Int = 4;
    TheMiddle::Int = 5;
    TheMiddle::TheNestedMiddle::Int = 6;
    TheChild::Int = 7;
    TheChild::TheNestedChild::Int = 8;
    TheBase::BaseInt = 9;
    TheBase::BaseConflictInt = 10;
    TheBase::TheNestedBase::NestedBaseInt = 11;
    TheOtherBase::OtherBaseInt = 12;
    TheOtherBase::BaseConflictInt = 13;
    TheOtherBase::TheOtherNestedBase::OtherNestedBaseInt = 14;
    TheMiddle::MiddleInt = 15;
    TheMiddle::TheNestedMiddle::NestedMiddleInt = 16;
    TheChild::ChildInt = 17;
    TheChild::TheNestedChild::NestedChildInt = 18;
    //TheChild::TheNestedBase::Int = 123; this is legal in C++, but not in the Win32 or Oasis expression parser.

    NS1::Increment();
    NS1::X::Increment();
    NS2::Increment();
    NS2::X::Increment();
    NS2::X::Y::Increment();
    NS3::Increment();
    NS3::X::Increment();

    return; // Set breakpoint here.
}
