﻿#include <cstdio>
#include <stdio.h>
#include <cstdarg>
#include <iostream>

//==============================================================================
// Inheritance hierarchy (non-virtual inheritance)
//              ClassA  ClassB  ClassC  ClassD
//                 \      /        \      /
//                  ClassE          ClassF
//                        \       /
//                         ClassG
//==============================================================================


class ClassA
{
public:
    ClassA() : CAInt(1) {};
    virtual ~ClassA(){};
    int CAInt;
};

class ClassB
{
public:
    ClassB() : CBInt(2){};
    virtual ~ClassB(){};
    int CBInt;
};

class ClassC
{
public:
    ClassC() : CCInt(3){};
    virtual ~ClassC(){};
    int CCInt;
};

class ClassD
{
public:
    ClassD() : CDInt(4){};
    virtual ~ClassD(){};
    int CDInt;
};

class ClassE : public ClassA, public ClassB
{
public:
    ClassE() : CEInt(5){};
    virtual ~ClassE(){};
    int CEInt;
};

class ClassF : public ClassC, public ClassD
{
public:
    ClassF() : CFInt(6){};
    virtual ~ClassF(){};
    int CFInt;
};

class ClassG : public ClassE, public ClassF
{
public:
    ClassG() : CGInt(7){};
    virtual ~ClassG(){};
    int CGInt;
};

// Adding additional child for testing pointers to derived types.

class ClassH : public ClassG
{
public:
    ClassH() : CHInt(8){};
    virtual ~ClassH(){};
    int CHInt;
};

// Adding additional namespaced and templated child for testing pointers to derived types.

namespace Namespace1234
{
    struct NamespacedStruct
    {
        int StructInt;
    };

    namespace
    {
        namespace Namespace5678
        {
            template <class A, class B>
            class ClassH : public ClassG
            {
            public:
                ClassH() : CHInt(12345678){};
                int CHInt;
            };
        }
    }
}


//==============================================================================
// Inheritance hierarchy (virtual inheritance)
//                  vA      vB      vD
//                    \    /  \    /
//                      vD      vE
//                        \    /
//                          vF
//==============================================================================

class vA
{
public:
    vA() : vAInt(1) {};
    virtual ~vA(){};
    int vAInt;
};

class vB
{
public:
    vB() : vBInt(2){};
    virtual ~vB(){};
    int vBInt;
};

class vC
{
public:
    vC() : vCInt(3){};
    virtual ~vC(){};
    int vCInt;
};

class vD : public virtual vA, public virtual vB
{
public:
    vD() : vDInt(4){};
    virtual ~vD(){};
    int vDInt;
};

class vE : public virtual vB, public virtual vC
{
public:
    vE() : vEInt(5){};
    virtual ~vE(){};
    int vEInt;
};

class vF : public virtual vD, public virtual vE
{
public:
    vF() : vFInt(6){};
    virtual ~vF(){};
    int vFInt;
};

//==============================================================================
// Inheritance hierarchy (non-virtual inheritance)
//              ClassMA     ClassMB     ClassMC
//                 \      /        \      /
//                  ClassMD         ClassME
//                        \       /
//                         ClassMF
//==============================================================================

class ClassMA
{
public:
    ClassMA() : MAInt(1) {};
    virtual ~ClassMA(){};
    int MAInt;
};

class ClassMB
{
public:
    ClassMB() : MBInt(2){};
    virtual ~ClassMB(){};
    int MBInt;
};

class ClassMC
{
public:
    ClassMC() : MCInt(3){};
    virtual ~ClassMC(){};
    int MCInt;
};

class ClassMD : public ClassMA, public ClassMB
{
public:
    ClassMD() : MDInt(4){};
    virtual ~ClassMD(){};
    int MDInt;
};

class ClassME : public ClassMB, public ClassMC
{
public:
    ClassME() : MEInt(5){};
    virtual ~ClassME(){};
    int MEInt;
};

class ClassMF : public ClassMD, public ClassME
{
public:
    ClassMF() : MFInt(6){};
    virtual ~ClassMF(){};
    int MFInt;
};

//==============================================================================

extern "C" void nnMain ( void )
{
    ClassG* CG = new ClassG();
    ClassH  CH;
    Namespace1234::Namespace5678::ClassH<Namespace1234::NamespacedStruct, ClassG> NCH;
    ClassG  ACG[2] = { *CG, *CG };
    ClassH* ACH[2] = { &CH, &CH };

    // Pointers to derived types.
    ClassA*  pCG  = CG;
    ClassA*  pCH  = &CH;
    ClassA*  pNCH = &NCH;
    ClassA*  pACG[2] = { CG, CG };
    ClassA*  pACH[2] = { &CH, &CH };
    ClassA** ppCG = &pCG;

    ClassE CE;
    ClassB* pCE = &CE;

    ClassMF MF;

    vF LocalvF; // Support not added - SigloNTD-8595.

    LocalvF.vAInt = 1;
}
