﻿//==============================================================================
//
//==============================================================================

#pragma once

#include <nn/nn_Common.h>
#include <nn/ro.h>

//==============================================================================

namespace nn { namespace mem {
class StandardAllocator;
}} // namespace nn::mem

class dll_code
{
public:

    //================================================================================
    // System init and clean.
static  void                    Init        ( nn::mem::StandardAllocator* pAllocator,
                                              const char*                 pMountName );
static  void                    Close       ();

public:
                                dll_code    ( const char*   pSource );
virtual                         ~dll_code   ();

        bool                    Load        ( );
        bool                    Unload      ( );

        bool                    FindSymbol  ( uintptr_t*    pAddress,
                                              const char*   pSymbolName);

protected:
    char                        m_Source[4096];
    void*                       m_pNro;
    char*                       m_pBss;
    void*                       m_pNrr;
    size_t                      m_NroSize;
    size_t                      m_BufferSize;
    size_t                      m_NrrSize;
    nn::ro::Module              m_Module;
    nn::ro::RegistrationInfo    m_Info;

    bool                        LoadSources ();

protected:

    //================================================================================
    // Loading functionality
static  bool                    LoadFile    ( const char*   pPath,
                                              void**        pLoadedFile,
                                              uint64_t*     pLoadedFileSize );

static  bool                    UnloadFile  ( void*         pLoadedFile );

};

//==============================================================================

