﻿//==============================================================================
// Test01:   Basic debugging over DLL load and unload
//    Uses DLLs named OMEGA and GAMMA.
//    Sequence of DLL usage:
//    Load OMEGA.
//    Unload OMEGA.
//    Load GAMMA.
//    Load OMEGA (again).
//    Unload GAMMA.
//    Unload OMEGA.
// Objectives:
//    Verify basic debugger functionality within a DLL.
//    Verify debugger handles DLL relocation.
// Tests for a DLL which is not yet loaded:
//    Breakpoints set into the DLL source will not bind.
//    Global variables in the DLL are not available.
// Tests for a DLL after it loads:
//    Breakpoints previously set in DLL source automatically bind.
//    Newly set breakpoints in DLL source will bind.
//    Global variables in the DLL are available.
// Tests for a DLL after it unloads:
//    Breakpoints previously set in DLL source automatically unbind.
//    Newly set breakpoints in DLL source will not bind.
//    Global variables in the DLL are not available.
// Perform all tests described above for both OMEGA and GAMMA before and after each sequence point described above.
//    Check to see if OMEGA uses a different base address the second time it loads.
//==============================================================================

#include "stdafx.h"
#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/mem/mem_StandardAllocator.h>
#include "..\DLLCode\DLLCode.h"
#include "..\Common\Common.h"

//==============================================================================
// Forward declarations.
bool Test();

//==============================================================================

extern "C" void nnMain()
{
    //===========================================
    // Init system.
    Common_Init();

    Test();

    Common_Close();
}

//==============================================================================
//    Load OMEGA.
//    Unload OMEGA.
//    Load GAMMA.
//    Load OMEGA (again).
//    Unload GAMMA.
//    Unload OMEGA.
//==============================================================================
bool Test()
{
    {
        //==============================================================================
        // Load OMEGA.
        // Unload OMEGA.
        //==============================================================================
        dll_code* pOmegaDLLCode = new dll_code( "Omega" ); //DLLBreakpointKey01
        if( pOmegaDLLCode->Load() == true )
        {
            int Zero = Common_TestDLLReturnIntCall( pOmegaDLLCode, "Omega_TestFunction" );
            REPORT("Omega_TestFunction returned %d\n", Zero );
        }
        pOmegaDLLCode->Unload();
        delete pOmegaDLLCode;
    }

    {
        //==============================================================================
        //    Load GAMMA.
        //    Load OMEGA (again).
        //==============================================================================
        dll_code* pGammaDLLCode = new dll_code( "Gamma" );  //DLLBreakpointKey02
        if( pGammaDLLCode->Load() == true )
        {
            dll_code* pOmegaDLLCode = new dll_code( "Omega" );
            if( pOmegaDLLCode->Load() == true )
            {
                int Zero = Common_TestDLLReturnIntCall( pOmegaDLLCode, "Omega_TestFunction" );
                REPORT("Omega_TestFunction returned %d\n", Zero );
                Zero = Common_TestDLLReturnIntCall( pGammaDLLCode, "Gamma_TestFunction" );
                REPORT("Gamma_TestFunction returned %d\n", Zero );
                //    Unload GAMMA.
                //    Unload OMEGA.
                pGammaDLLCode->Unload();
                delete pGammaDLLCode;

                pOmegaDLLCode->Unload();
                delete pOmegaDLLCode;
            }
        }
    }
    return true;  //DLLBreakpointKey03
}

//==============================================================================
