﻿//==============================================================================
// Gamma source
//==============================================================================

#include "stdafx.h"

//==============================================================================

extern "C" int Gamma_ReturnZero()
{
    return 0;
}

//==============================================================================

extern "C" int Gamma_ReturnOne()
{
    return 1;
}

//==============================================================================

static int64_t factorial( int N )
{
    int64_t ans = 1;
    int i;
    for(i=1; i <= N; i++)
    {
        ans *= i;
    }
    return ans;
}

//==============================================================================

extern "C" float Gamma_Work( int StartingNumber )
{
    float Ret = 0.0;
    for(int Index = 1; Index < 9; Index  += 1 )
    {
        int64_t Temp = factorial( Index );  //DLLBreakpointKey06
        Ret = (float)Temp;
        Ret = Ret * (1/Ret);
        Temp = factorial( Index + 1);
        Ret = StartingNumber * (1/(float)Temp);
    }
    return Ret;
}

//==============================================================================

extern "C" void Gamma_Sleep( int Seconds )
{
    SLEEP( Seconds );
}

//==============================================================================

extern "C" void Gamma_ChangeString( char* pString, int32_t Length )
{
    memset( pString, 0, Length );
    char ChangeTo[17] = {'C', 'h', 'a', 'n', 'g', 'e', 'd', ' ', 't', 'o', ' ', 'G', 'a', 'm', 'm', 'a', 0 };
    int32_t CopyLength = Length > sizeof(ChangeTo) ? sizeof(ChangeTo) : Length - 1;
    for( int32_t Index = 0; Index < CopyLength; Index += 1 )
    {
        pString[Index] = ChangeTo[Index];
    }
}

//==============================================================================

extern "C" int Gamma_TestFunction()
{
    // Function to do some tests with.
    int Result = 0;
    float Alpha = 0.0;
    float Bravo = 0.0;
    float Charlie = 0.0;

    Alpha = Gamma_Work(124); //DLLBreakpointKey04
    Bravo = Gamma_Work(512);
    Charlie = Gamma_Work(4096);

    return (int)(Alpha + Bravo + Charlie);
}

//==============================================================================
