﻿//==============================================================================
//
//  Main entry for Data Breakpoint Test
//
//==============================================================================

#ifndef __NX__
#else
#include <stdio.h>
#include <string.h>
#include <nn/tma/tma.h>
#include <nn/os.h>
#include <sys/mman.h>
#include "../../DeterministicRandom.h"
#endif

const char* simpleReadLiteral1 = "I am a string literal";
const char* simpleReadLiteral2 = "";
const char* simpleReadLiteral3 = "x";

char simpleReadGlobal1[] = "I am a global string";
char simpleReadGlobal2[] = "";
char simpleReadGlobal3[] = "l";

void SimpleReadTest()
{
    char simpleReadStack1[] = "I am a stack string";
    char simpleReadStack2[] = "";
    char simpleReadStack3[] = "a";
    char simpleReadStack4[] = "1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 "
        "1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 ";

    const char* msg1 = "I am a heap string";
    char* simpleReadHeap1 = new char[strlen( msg1 ) + 1];
    strcpy( simpleReadHeap1, msg1 );

    const char* msg2 = "";
    char* simpleReadHeap2 = new char[strlen( msg2 ) + 1];
    strcpy( simpleReadHeap2, msg2 );

    const char* msg3 = "w";
    char* simpleReadHeap3 = new char[strlen( msg3 ) + 1];
    strcpy( simpleReadHeap3, msg3 );

    int hold = 0;                                                         //MemKey00

    delete[] simpleReadHeap1;
    delete[] simpleReadHeap2;
    delete[] simpleReadHeap3;
}

char simpleWriteGlobal1[300];

void SimpleWriteTest()
{
    char simpleWriteStack1[300];
    char* simpleWriteHeap1 = new char[300];

    int hold = 0;                                                       //MemKey01

    delete[] simpleWriteHeap1;
}

// Test reads of relatively small pieces of memory.
const static int randomSmallReadNumLoops = 200;
const static int randomSmallReadMaxLength = 500;
const static int randomSmallReadSeed = 544;
char randomSmallReadGlobal1[randomSmallReadMaxLength + 1];

// Test going from readable to unreadable memory, and back again.
void ThreadFunction( void* data )
{}

// Creating a new thread remaps memory, so it can be used to test for unreadable bytes
// with reliable sizes.
nn::os::ThreadType thread1;
nn::os::ThreadType thread2;

void MemoryBoundaryTest()
{
    // Nintendo threads need these values to be aligned on 4096 byte boundaries.
    const size_t threadStackSize = 4096;
    const size_t alignment = 4096;

    // Allocate a chunk of contiguous memory. This chunk will be split up into four pieces:
    // an unreadable chunk, readable chunk, unreadable chunk, readable chunk, respectively.
    char* memStart = (char*)aligned_alloc( alignment, alignment * 4 );

    char* unreadable1 = memStart;
    char* readable1 = unreadable1 + alignment;
    char* unreadable2 = readable1 + alignment;
    char* readable2 = unreadable2 + alignment;

    // Make the first and third chunks unreadable by passing them to a thread.
    nn::os::CreateThread( &thread1, ThreadFunction, NULL, unreadable1, threadStackSize, nn::os::DefaultThreadPriority );
    nn::os::CreateThread( &thread2, ThreadFunction, NULL, unreadable2, threadStackSize, nn::os::DefaultThreadPriority );

    int hold = 0;                                                        //MemKey08
}

void RandomSmallReadTest()
{
    char randomSmallReadStack1[randomSmallReadMaxLength + 1];

    int hold = 0;                                                        //MemKey02

    deterministic_random random( randomSmallReadSeed );

    for( int i = 0; i < randomSmallReadNumLoops; ++i )
    {
        char* randomSmallReadHeap1 = random.RandomString( 0, randomSmallReadMaxLength );

        strcpy( randomSmallReadGlobal1, random.RandomString( 0, randomSmallReadMaxLength ) );
        strcpy( randomSmallReadStack1, random.RandomString( 0, randomSmallReadMaxLength ) );

        int hold = 0;                                                   //MemKey03

        delete[] randomSmallReadHeap1;
    }
}

// Test large reads, which will definitely encompass multiple memory pages.
const static int randomLargeReadNumLoops = 100;
const static int randomLargeReadMinLength = 10000;
const static int randomLargeReadMaxLength = 100000;
const static int randomLargeReadSeed = 7777;
char randomLargeReadGlobal1[randomLargeReadMaxLength + 1];

void RandomLargeReadTest()
{
    char randomLargeReadStack1[randomLargeReadMaxLength + 1];

    int hold = 0;                                                        //MemKey04

    deterministic_random random( randomLargeReadSeed );

    for( int i = 0; i < randomLargeReadNumLoops; ++i )
    {
        char* randomLargeReadHeap1 = random.RandomString( randomLargeReadMinLength, randomLargeReadMaxLength );

        strcpy( randomLargeReadGlobal1, random.RandomString( randomLargeReadMinLength, randomLargeReadMaxLength ) );
        strcpy( randomLargeReadStack1, random.RandomString( randomLargeReadMinLength, randomLargeReadMaxLength ) );

        int hold = 0;                                                   //MemKey05

        delete[] randomLargeReadHeap1;
    }
}

// Test writes of relatively small pieces of memory.
const static int randomSmallWriteMaxLength = 500;
char randomSmallWriteGlobal1[randomSmallWriteMaxLength + 1];

void RandomSmallWriteTest()
{
    char randomSmallWriteStack1[randomSmallWriteMaxLength + 1];
    char* randomSmallWriteHeap1 = new char[randomSmallWriteMaxLength + 1];

    int hold = 0;                                                       //MemKey06

    delete[] randomSmallWriteHeap1;
}

// Test large writes, which will definitely encompass multiple memory pages.
const static int randomLargeWriteMaxLength = 100000;
char randomLargeWriteGlobal1[randomLargeWriteMaxLength + 1];

void RandomLargeWriteTest()
{
    char randomLargeWriteStack1[randomLargeWriteMaxLength + 1];
    char* randomLargeWriteHeap1 = new char[randomLargeWriteMaxLength + 1];

    int hold = 0;                                                       //MemKey07

    delete[] randomLargeWriteHeap1;
}

// Tests a single, 'massive' read from memory, roughly 5mb.
const static int randomMassiveReadLength = 5000000;
const static int randomMassiveReadSeed = 5875;

void RandomMassiveReadTest()
{
    deterministic_random random( randomMassiveReadSeed );

    char* randomMassiveReadHeap1 = random.RandomString( randomMassiveReadLength, randomMassiveReadLength );

    int hold = 0;                                                                   //MemKey09

    delete[] randomMassiveReadHeap1;
}

// Tests a single 'massive' write to memory, roughly 5mb.
const static int randomMassiveWriteLength = 5000000;

void RandomMassiveWriteTest()
{
    char* randomMassiveWriteHeap1 = new char[randomMassiveWriteLength];

    int hold = 0;                                                                 //MemKey10

    delete[] randomMassiveWriteHeap1;
}

#ifndef __NX__
int main( int argc, char** argv )
#else
extern "C" void nnMain()
#endif
{
    SimpleReadTest();
    SimpleWriteTest();
    MemoryBoundaryTest();

    RandomSmallReadTest();
    RandomLargeReadTest();
    RandomSmallWriteTest();
    RandomLargeWriteTest();
    RandomMassiveReadTest();
    RandomMassiveWriteTest();

#ifndef __NX__
    return 0;
#else
    return;
#endif
}
