﻿#include <nn/os.h>
#include <nn/fs.h>
#include <nn/nn_Assert.h>

extern "C" void nnMain()
{
    const uint32_t FILE_SIZE = 0x1FFFFFFF;

    char Buffer[1024];
    memset( Buffer, '\0', 1024 );
    strcat( Buffer, "C:\\Users\\" );
    strcat( Buffer, USER_NAME );

    nn::Result result;
    result = nn::fs::MountHost( "host", Buffer );

    result = nn::fs::CreateDirectory( "host:/FsSmplDir" );
    NN_ASSERT( result.IsSuccess() );

    result = nn::fs::CreateFile( "host:/FsSmplDir/file1", 0 );
    NN_ASSERT( result.IsSuccess() );

    nn::fs::FileHandle fileHandle;
    result = nn::fs::OpenFile( &fileHandle, "host:/FsSmplDir/file1", nn::fs::OpenMode_Read | nn::fs::OpenMode_Write | nn::fs::OpenMode_AllowAppend );
    NN_ASSERT( result.IsSuccess() );

    static char writeBuffer[FILE_SIZE];
    for( int i = 0; i < FILE_SIZE; i++ )
    {
        writeBuffer[i] = static_cast<char>( i );
    }

    result = nn::fs::WriteFile( fileHandle, 0, writeBuffer, FILE_SIZE, nn::fs::WriteOption() );
    NN_ASSERT( result.IsSuccess() );

    result = nn::fs::FlushFile( fileHandle );
    NN_ASSERT( result.IsSuccess() );

    int64_t fileSize = 0;
    result = nn::fs::GetFileSize( &fileSize, fileHandle );
    NN_ASSERT( result.IsSuccess() );
    NN_ASSERT_EQUAL( fileSize, FILE_SIZE );

    nn::fs::CloseFile( fileHandle );

    nn::fs::Unmount( "host" );

    return;
}
