﻿//==============================================================================
//  Copyright (C) DejaTools, LLC.  All rights reserved.
//==============================================================================

#include <stdlib.h>
#include "pxmalloc.h"

//==============================================================================

MemMutex::MemMutex() : LockedCount(0)
{
}

MemMutex::~MemMutex()
{
}

void MemMutex::Lock()
{
    LockedCount++;
}

void MemMutex::Unlock()
{
    LockedCount--;
}

bool MemMutex::Locked()
{
    return LockedCount > 0;
}

extern void* tiny_memmgr_reserve( size_t Size );

void* SystemVirtualReserve(size_t Size)
{
    void* pResult = tiny_memmgr_reserve( Size );
    return pResult;
}

void SystemVirtualFree(void* pAddress, size_t Size)
{
}

void* SystemVirtualCommit(void* pAddress, size_t Size)
{
    return pAddress;
}

void SystemVirtualDecommit(void* pAddress, size_t Size)
{
}

//==============================================================================
