﻿//==============================================================================
//
//  Main entry for ComplexStackTest
//
//==============================================================================

#include <nn/os.h>

static int PlusX( int Base, int Factor, int Iterator )
{
    int Ret;
    Ret = Base + ( Factor * Iterator );
    return Ret;
}

static int ExpAdd( int Base, int Factor )
{
    int Result;

    Result = Base;
    Factor = PlusX( Factor, 3, 2 );

    for( int Count = 0; Count < Factor; Count++ )
    {
        Result *= Base;
    }

    return Result;
}

static int FactorX( int Source, int Factor )
{
    int Result = 0;

    Source = ExpAdd( Source, Factor );

    while( Source > Factor )
    {
        Result++;
        Source -= Factor;
    }

    return Result;
}

void Func()
{
    int j = 5;
    j++;
}

void RecursionDepthFunction( int Depth )
{
    int CurrentDepth = Depth-1;

    if( Depth > 0 )
        RecursionDepthFunction( CurrentDepth );
}

struct Vertex3
{
    float LocX;
    float LocY;
    float LocZ;

    void Initialize( float tX, float tY, float tZ )
    {
        LocX = tX;
        LocY = tY;
        LocZ = tZ;
    }
};

struct Triangle
{
    Vertex3 Vert1;
    Vertex3 Vert2;
    Vertex3 Vert3;

    void Initialize( float OriginX,  float OriginY,  float OriginZ,
                     float OffsetX1, float OffsetY1, float OffsetZ1,
                     float OffsetX2, float OffsetY2, float OffsetZ2 )
    {
        Vert1.Initialize( OriginX, OriginY, OriginZ );
        Vert2.Initialize( OriginX + OffsetX1, OriginY + OffsetY1, OriginZ + OffsetZ1);
        Vert3.Initialize( OriginX + OffsetX2, OriginY + OffsetY2, OriginZ + OffsetZ2);
    }
};

struct Polygon
{
    Triangle*   m_pTriangles;
    int         m_TAngleCount;

    void Initialize( )
    {
        // Create the triangle array.
        m_TAngleCount = 1;
        m_pTriangles = new Triangle[m_TAngleCount];

        m_pTriangles[0].Initialize( 0.0f,0.0f,0.0f,
                                    1.0f,1.0f,1.0f,
                                    1.0f,0.0f,1.0f );
    }
};

class Object
{
public:
    Object(){};
    ~Object(){};
    virtual void Initialize();

    void SetPosition( float tX, float tY, float tZ );
private:
    Vertex3 m_Position;
    Vertex3 m_Direction;
    Vertex3 m_Velocity;
};

void Object::Initialize()
{
    m_Position.Initialize( 0.0f, 0.0f, 0.0f );
    m_Direction.Initialize( 0.0f, 1.0f, 0.0f );
    m_Velocity.Initialize( 0.0f, 0.0f, 0.0f );
}

void Object::SetPosition( float tX, float tY, float tZ )
{
    m_Position.Initialize( tX, tY, tZ );
}

class Character : public Object
{
public:
    Character(){};
    ~Character(){};
    virtual void Initialize( Vertex3 tPos, char* tID );
protected:

private:
    char* ID;
};

void Character::Initialize( Vertex3 tPos, char* tID )
{
    SetPosition( tPos.LocX, tPos.LocY, tPos.LocZ );
    ID = tID;
}

class Player
{
public:
    Player(){};
    ~Player(){};
    void Create( char* Name );
protected:

private:
    Character* m_pCharacter;
    char*      m_pName;
};

void Player::Create( char* Name )
{
    Vertex3 newPos;
    m_pCharacter = new Character();
    m_pName = Name;

    newPos.Initialize( 15.0f, 3.4f, -2.13f );

    m_pCharacter->Initialize( newPos, m_pName );
}

inline int DoAdd( int A, int B )
{
    int Res = 0;

    Res = A + B;

    return Res;
}

inline int DoMulti( int A, int B )
{
    int Res = 0;

    for( int I = 0; I < B; I++ )
    {
        Res = DoAdd( A, A );
    }

    return Res;
}

inline int DoExponent( int A, int B )
{
    int Res = 0;

    for( int I = 0; I < B; I++ )
    {
        Res = DoMulti( A, A );
    }

    return Res;
}

class RefCount
{
private:
    int Count;

public:
    void AddRef()
    {
        Count++;
    }

    int CheckCount()
    {
        return Count;
    }

    int Release()
    {
        return Count--;
    }
};

template <typename T> class PsuedoPtr
{
private:
    T* pData;
    RefCount* count = 0;
public:
    PsuedoPtr() : pData(0)
    {
        count = new RefCount();
        count->AddRef();
    }

    PsuedoPtr( T* pValue ) : pData(pValue)
    {
        count = new RefCount();
        count->AddRef();
    }
    ~PsuedoPtr()
    {
        if( count->Release() <=0 )
        {
            delete pData;
            delete count;
        }
    }

    T& operator* ()
    {
        return *pData;
    }

    T* operator-> ()
    {
        return pData;
    }

    PsuedoPtr<T>& operator = (const PsuedoPtr<T>& psuedoptr)
    {
        if( this != &psuedoptr)
        {
            if( count->Release() == 0 )
            {
                // No one else is refrencing this pointer, so delete.
                delete pData;
                delete count;
            }

            // Copy data and refrence value;
            pData = psuedoptr.pData;
            count = psuedoptr.count;
            count->AddRef();
        }
        return *this;
    }

    bool IsNull()
    {
        return (pData==0)?true:false;
    }
};

template <typename T> class DynamicNode
{
public:
    PsuedoPtr<T> Obj;
    PsuedoPtr<T> First;
    PsuedoPtr<T> Previous;
    PsuedoPtr<T> Next;
    DynamicNode()
    { };
};

template <typename T> class DynamicArray
{
private:
    int m_ArrayCount;
    DynamicNode<T> First;
    DynamicNode<T> Last;
public:
    void Append( T* newElement )
    {
        if( First.Obj.IsNull() )
        {
            First.Obj = newElement;
            First.First = First.Obj;
            First.Next = 0;
            First.Previous = 0;
        }
    }
};

#ifndef __NX__
int main(int argc, char** argv)
#else
extern "C" void nnMain( void )
#endif
{
    int a = 1;
    int b = 2;
    int c = 3;
    int j = 4;
    int MaxRecursionDepth = 10;
    Polygon tPoly;
    Player* pPlayer;
    char* PlayerName;
    DynamicArray<Polygon> PolyList;

    Func();

    RecursionDepthFunction( MaxRecursionDepth );

    FactorX( j, c );

    tPoly.Initialize();

    pPlayer = new Player();
    PlayerName = new char[32];
    PlayerName[0] = 'P';
    PlayerName[1] = '1';
    pPlayer->Create( PlayerName );

    int Alpha = DoExponent( 3, 4 );

    PolyList.Append( &tPoly );
#ifndef __NX__
    return 0;
#endif
}
