﻿//==============================================================================
//  Main entry for BreakSvc
//==============================================================================

#include "nn\nn_TimeSpan.h"
#include "nn\os\os_Thread.h"

const unsigned int LENGTH_OF_SLEEP          = 10;
const unsigned int RECURSION_DEPTH          = 3;

void RecursiveSleep( nn::TimeSpan ts, int Recursion )
{                                                                                                       //LineTableTest01
    if( Recursion )                                                                                     //LineTableTest02
    {
        RecursiveSleep( ts, Recursion - 1 );                                                            //LineTableTest03
    }
    else
    {
        nn::os::SleepThread( ts );                                                                      //LineTableTest04
    }
}

#ifdef NN_NINTENDO_SDK
extern "C" void nnMain()
#else
int main( int argc, char **argv )
#endif
{
    for( long i = 1; i != 0; i++ )                                                                      //LineTableTest05
    {
        RecursiveSleep( nn::TimeSpan::FromSeconds( LENGTH_OF_SLEEP ), RECURSION_DEPTH );                //LineTableTest06
    }
}
