﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Set environment variables for tests

    .DESCRIPTION
        Set environment variables for tests.
#>

param
(
    [string]
    $AddressPattern = $env:TARGET_ADDRESS_PATTERN
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\..\..\..\..\Integrate\Scripts\Modules\HostBridge"

$TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
Write-Host ("##teamcity[setParameter name='env.INSPECTOR_MAGIC_TARGET_IP_ADDRESS' value='{0}']" -f $TargetAddress)
