﻿/*---------------------------------------------------------------------------*
  Copyright (C)2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

/*!
    @file
    @brief アプリケーションが動作するプラットフォームの情報を示すマクロの定義
*/

/*!
    @brief    汎用 API セットを使用している場合に定義されます。
*/
#define NN_BUILD_APISET_GENERIC 1

/*!
    @privatedocbegin{platform_NX}
    @brief    NX API セットを使用している場合に定義されます。
    @privatedocend
*/
#define NN_BUILD_APISET_NX  1


/*!
    @brief    アプリケーションが動作するプラットフォームが Windows の場合に定義されます。
*/
#define NN_BUILD_TARGET_PLATFORM_WIN 1

/*!
    @privatedocbegin{platform_NX}
    @brief    アプリケーションが動作するプラットフォームが NX 実機環境の場合に定義されます。
    @privatedocend
*/
#define NN_BUILD_TARGET_PLATFORM_NX 1


/*!
    @brief    アプリケーションが動作するプラットフォームにおいて OS が Windows である場合に定義されます。
*/
#define NN_BUILD_TARGET_PLATFORM_OS_WIN 1

/*!
    @privatedocbegin{platform_NX}
    @brief    アプリケーションが動作するプラットフォームにおいて OS が NX 実機環境で使用されている OS である場合に定義されます。
    @privatedocend
*/
#define NN_BUILD_TARGET_PLATFORM_OS_NN 1


/*!
    @brief    アプリケーションが動作するプラットフォームにおいてエンディアンがビッグエンディアンの場合に定義されます。
*/
#define NN_BUILD_TARGET_PLATFORM_ENDIAN_BIG 1

/*!
    @brief    アプリケーションが動作するプラットフォームにおいてエンディアンがリトルエンディアンの場合に定義されます。
*/
#define NN_BUILD_TARGET_PLATFORM_ENDIAN_LITTLE 1


/*!
    @brief    アプリケーションが動作するプラットフォームにおいてアドレスが 32 ビット幅の場合に定義されます。
*/
#define NN_BUILD_TARGET_PLATFORM_ADDRESS_32 1

/*!
    @brief    アプリケーションが動作するプラットフォームにおいてアドレスが 64 ビット幅の場合に定義されます。
*/
#define NN_BUILD_TARGET_PLATFORM_ADDRESS_64 1

