/*--------------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo. All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

function OnFinish(selProj, selObj)
{
	try
	{
		var strProjectPath = wizard.FindSymbol('PROJECT_PATH');
		var strProjectName = wizard.FindSymbol('PROJECT_NAME');

		selProj = CreateCustomProject(strProjectName, strProjectPath);
		AddConfig(selProj, strProjectName);
		AddFilters(selProj);

        var setting = wizard.FindSymbol('Setting');
        if(!setting)
        {
            return;
        }
		PrepareForPchSetting();
		var InfFile = CreateCustomInfFile();
		AddFilesToCustomProj(selProj, strProjectName, strProjectPath, InfFile);
		SetStdafxFileIfPchEnablePaltform(selProj, GetEnvironmentValue(setting.sdkRootPath));
		PchSettings(selProj);
		InfFile.Delete();

		selProj.Object.Save();
	}
	catch(e)
	{
		if (e.description.length != 0)
		{
			SetErrorInfo(e);
		}
		return e.number
	}
}

function CreateCustomProject(strProjectName, strProjectPath)
{
	try
	{
        var constSetting = wizard.FindSymbol('ConstructSetting');
        if(!constSetting)
        {
            return;
        }
        var setting = wizard.FindSymbol('Setting');
        if(!setting)
        {
            return;
        }
	    var sdkPathString = GetEnvironmentValue(setting.sdkRootPath);
	    var strWizardFileName = constSetting.wizardName;
	    var strTemplatePath = GetEnvironmentValue("%TMP%") + "\\default.vcxproj";
	    //var strTemplatePath = "D:\\tmp\\default.vcxproj";
	    CreateProjectTemplate(strWizardFileName, sdkPathString, strTemplatePath);

		var strProjTemplatePath = wizard.FindSymbol('START_PATH');
		var strProjTemplate = '';
		//strProjTemplate = strProjTemplatePath + '\\default.vcxproj';
		strProjTemplate = strTemplatePath;

		var Solution = dte.Solution;
		var strSolutionName = "";
		if (wizard.FindSymbol("CLOSE_SOLUTION"))
		{
			Solution.Close();
			strSolutionName = wizard.FindSymbol("VS_SOLUTION_NAME");
			if (strSolutionName.length)
			{
				var strSolutionPath = strProjectPath.substr(0, strProjectPath.length - strProjectName.length);
				Solution.Create(strSolutionPath, strSolutionName);
			}
		}

		var platformName = [];
		var addPropFiles = [];
		var addMetaFiles = [];
		GetPlatformNamesFromHtml(platformName);
		for(var i=0; i<platformName.length; i++)
		{
			var configs = [];
			GetPlatformConfig(sdkPathString, platformName[i], configs);

			ParseAddPropertySheetNameFromConfigLines(addPropFiles, configs);
			ParseMetaFileNameFromConfigLines(addMetaFiles, configs);
		}

		AddSpecifiedPropertyFiles(strProjectPath, sdkPathString, addPropFiles);
		AddOptionalPropertyFile();

		var strProjectNameWithExt = '';
		strProjectNameWithExt = strProjectName + '.vcxproj';

		var oTarget = wizard.FindSymbol("TARGET");
		var prj;
		if (wizard.FindSymbol("WIZARD_TYPE") == vsWizardAddSubProject)  // vsWizardAddSubProject
		{
			var prjItem = oTarget.AddFromTemplate(strProjTemplate, strProjectNameWithExt);
			prj = prjItem.SubProject;
		}
		else
		{
			prj = oTarget.AddFromTemplate(strProjTemplate, strProjectPath, strProjectNameWithExt);
		}
		//var fxtarget = wizard.FindSymbol("TARGET_FRAMEWORK_VERSION");
		//if (fxtarget != null && fxtarget != "")
		//{
		//    fxtarget = fxtarget.split('.', 2);
		//    if (fxtarget.length == 2)
		//	prj.Object.TargetFrameworkVersion = parseInt(fxtarget[0]) * 0x10000 + parseInt(fxtarget[1])
		//}

		AddSpecifiedMetaFiles(prj, strProjectPath, sdkPathString, addMetaFiles);

		var fso = new ActiveXObject('Scripting.FileSystemObject');
		DelFile(fso, strTemplatePath);

		return prj;
	}
	catch(e)
	{
		throw e;
	}
}

function GetEnvironmentValue(strWithEnvValue)
{
    wsh = new ActiveXObject("WScript.Shell");
    return wsh.ExpandEnvironmentStrings(strWithEnvValue);
}

function CreateProjectTemplate(strWizardName, strSdkRootDir, strTemplateFile)
{
    // t@Cɑ݂Ȃ΍폜
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if (fso.FileExists(strTemplateFile)) {
        DelFile(fso, strTemplateFile);
    }

    // o^vbgtH[mF
    var platformName = [];
    var inFileName;

    //if (GetPlatformNames(strSdkRootDir, platformName, strWizardName) <= 0) {
	//    return;
	//}

	GetPlatformNamesFromHtml(platformName);

    var VsVersion = dte.Version;
    var VsVersionString;
    if (VsVersion == "11.0")
    {
        VsVersionString = "VS2012";
    }
    else if (VsVersion == "12.0")
    {
        VsVersionString = "VS2013";
    }
    else if (VsVersion == "14.0")
    {
        VsVersionString = "VS2015";
    }
    else if (VsVersion == "15.0")
    {
        VsVersionString = "VS2017";
    }
    else
    {
        VsVersionString = "VS2012";
    }

    // t@CAĕۑ
    inFileName = GetProjectBaseFilePath(strSdkRootDir, "Base", strWizardName, "Base_1", VsVersionString);
    CoupleFile(strTemplateFile, inFileName);
    for (var i = 0; i < platformName.length; i++) {
        inFileName = GetProjectBaseFilePath(strSdkRootDir, platformName[i], strWizardName, "_1_1", VsVersionString);
        CoupleFile(strTemplateFile, inFileName);
    }
    inFileName = GetProjectBaseFilePath(strSdkRootDir, "Base", strWizardName, "Base_2", VsVersionString);
    CoupleFile(strTemplateFile, inFileName);
    for (var i = 0; i < platformName.length; i++) {
        inFileName = GetProjectBaseFilePath(strSdkRootDir, platformName[i], strWizardName, "_2_1", VsVersionString);
        CoupleFile(strTemplateFile, inFileName);
    }
    inFileName = GetProjectBaseFilePath(strSdkRootDir, "Base", strWizardName, "Base_3", VsVersionString);
    CoupleFile(strTemplateFile, inFileName);
    for (var i = 0; i < platformName.length; i++) {
        inFileName = GetProjectBaseFilePath(strSdkRootDir, platformName[i], strWizardName, "_3_1", VsVersionString);
        CoupleFile(strTemplateFile, inFileName);
    }
    inFileName = GetProjectBaseFilePath(strSdkRootDir, "Base", strWizardName, "Base_4", VsVersionString);
    CoupleFile(strTemplateFile, inFileName);
    for (var i = 0; i < platformName.length; i++) {
        inFileName = GetProjectBaseFilePath(strSdkRootDir, platformName[i], strWizardName, "_4_1", VsVersionString);
        CoupleFile(strTemplateFile, inFileName);
        inFileName = GetProjectBaseFilePath(strSdkRootDir, platformName[i], strWizardName, "_4_2", VsVersionString);
        CoupleFile(strTemplateFile, inFileName);
        inFileName = GetProjectBaseFilePath(strSdkRootDir, platformName[i], strWizardName, "_4_3", VsVersionString);
        CoupleFile(strTemplateFile, inFileName);
    }
    inFileName = GetProjectBaseFilePath(strSdkRootDir, "Base", strWizardName, "Base_5", VsVersionString);
    CoupleFile(strTemplateFile, inFileName);
    for (var i = 0; i < platformName.length; i++) {
        inFileName = GetProjectBaseFilePath(strSdkRootDir, platformName[i], strWizardName, "_5_1", VsVersionString);
        CoupleFile(strTemplateFile, inFileName);
    }
    inFileName = GetProjectBaseFilePath(strSdkRootDir, "Base", strWizardName, "Base_6", VsVersionString);
    CoupleFile(strTemplateFile, inFileName);

    //w蕶ϊ
    ConvertStringInFile(strTemplateFile, /CONVSTR_SDKROOT/g, GetSdkRootPathStringForPropertySheet());
    SetProjectOptionalProperty(strTemplateFile);

}

function GetProjectBaseFilePath(strSdkRootDir, strPlatformName, strWizardName, strVersionName, strVsVersion)
{
    var strDirectoryPath = strSdkRootDir + "\\Build\\Vc\\CustomWizard\\Platform\\" + strPlatformName + "\\" + strVsVersion;
    var strFilePath = strDirectoryPath + "\\" + strWizardName + strVersionName;
    var fso = new ActiveXObject('Scripting.FileSystemObject');

    if(fso.FolderExists(strDirectoryPath) && fso.FileExists(strFilePath))
    {
        return strFilePath;
    }
    else
    {
        return GetProjectBaseFilePath_simple(strSdkRootDir, strPlatformName, strWizardName) + strVersionName;
    }
}

function GetProjectBaseFilePath_simple(strSdkRootDir, strPlatformName, strWizardName)
{
    return strSdkRootDir + "\\Build\\Vc\\CustomWizard\\Platform\\" + strPlatformName + "\\" + strWizardName;
}

function GetBuildCommonDirectoryPath(strSdkRootDir)
{
    return strSdkRootDir + "\\Build\\Vc";
}

function GetPlatformNames(strSdkRootDir, strPlatformNames, strWizardName) {
    var strPlatformDirectory = strSdkRootDir + "\\Build\\Vc\\CustomWizard\\Platform\\";
    // PlatformfBNgȂꍇ-1Ԃ
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if (!fso.FolderExists(strPlatformDirectory)) {
        fso = null;
        return -1;
    }

    // Platform fBNgȉ̃fBNgT
    var size = 0;
    var folder = fso.GetFolder(strPlatformDirectory);
    var em = new Enumerator(folder.SubFolders);
    for (em.moveFirst() ; !em.atEnd() ; em.moveNext()) {
        // TfBNĝ "Base" ȊÔ̂zɊi[
        if (em.item().Name == "Base") {
            continue;
        }
        var strCheckFileName = strPlatformDirectory + em.item().Name + "\\" + strWizardName + "_1_1";
        if (!fso.FileExists(strCheckFileName)) {
            continue;
        }
        size = strPlatformNames.push(em.item().Name);
    }

    fso = null;

    return size;
}

function GetPlatformNamesFromHtml(platformNames)
{
    var setting = wizard.FindSymbol('Setting');
    if(!setting)
    {
        return;
    }
    for(var i=0; i<setting.platformNum ; i++)
    {
        if(setting.selectPlatforms[i] == true)
        {
            platformNames.push(setting.platformNames[i]);
        }
    }
}

function GetPlatformConfig(strSdkRootDir, strPlatformName, strPlatformConfigs)
{
    var strPlatformConfigFile = strSdkRootDir + "\\Build\\Vc\\CustomWizard\\Platform\\" + strPlatformName + "\\Config.txt";

    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if (!fso.FileExists(strPlatformConfigFile)) {
        fso = null;
        return;
    }
    var objFile = fso.OpenTextFile(strPlatformConfigFile);
    while(objFile.AtEndOfStream == false)
    {
        var strTest = objFile.ReadLine();
        strTest = strTest.replace(/(^\s+)|(\s+$)/g, "");
        if(strTest.length > 0)
        {
        	strPlatformConfigs.push(strTest);
        }
    }
    fso = null;
}

// Config.txt  PCH ܂܂邩`FbN
// ȂgpĂȂ (Config.txtɊ֌WȂ@\͓삷)
function CheckPch(proj, strPlatformConfig)
{
    for(var i=0; i<strPlatformConfig.length; i++)
    {
    	var strConfg = strPlatformConfig[i];
    	if(strConfg == "PCH")
    	{
    		return true;
    	}
    }
    return false;
}

function PrepareForPchSetting()
{
    var bPCH = wizard.FindSymbol("ID_BUILD_OPTION_PCH");
    if (bPCH == true)
    {
        // set include directive
        wizard.AddSymbol("STDAFX_INCLUDE_DIRECTIVE", "#include \"stdafx.h\"\r\n");
    }
}

function SetStdafxFileIfPchEnablePaltform(proj, strSdkRootDir)
{
    var bPCH = wizard.FindSymbol("ID_BUILD_OPTION_PCH");
    if (bPCH == true)
    {
        // add stdafx.h and stdafx.cpp to project
        var strProjectPath = wizard.FindSymbol('PROJECT_PATH');
        var strTemplatePath = wizard.FindSymbol('TEMPLATES_PATH');

        var strTarget = "stdafx.h";
        var strTemplate = strTemplatePath + '\\' + strTarget;
        var strFile = strProjectPath + '\\' + strTarget;
        var bCopyOnly = true;
        wizard.RenderTemplate(strTemplate, strFile, bCopyOnly);
        proj.Object.AddFile(strFile);

        strTarget = "stdafx.cpp";
        strTemplate = strTemplatePath + '\\' + strTarget;
        strFile = strProjectPath + '\\' + strTarget;
        wizard.RenderTemplate(strTemplate, strFile, bCopyOnly);
        proj.Object.AddFile(strFile);
    }
}

function CoupleFile(strOutFileName, strInFileName)
{
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if(!fso.FileExists(strInFileName))
    {
        return;
    }
    var objOutputFile;
    if (fso.FileExists(strOutFileName)) {
        objOutputFile = fso.OpenTextFile(strOutFileName, 8);
    }
    else {
        objOutputFile = fso.CreateTextFile(strOutFileName);
    }

    var objInputFile = fso.OpenTextFile(strInFileName);
    var strText = objInputFile.ReadAll();
    objInputFile.Close();

    objOutputFile.Write(strText);
    objOutputFile.Close();
}

function ConvertStringInFile(strFilePath, convertPattern, convertedString)
{
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if (!fso.FileExists(strFilePath)) {
        fso = null;
        return;
    }
    var objFile = fso.OpenTextFile(strFilePath);
    var convertedLines = [];
    while(objFile.AtEndOfStream == false)
    {
        var line = objFile.ReadLine();
        var converted = line.replace(convertPattern, convertedString);
        convertedLines.push(converted);
    }
    objFile.Close();

    var backupFilePath = strFilePath + ".bak";
    fso.MoveFile(strFilePath, backupFilePath);

    objFile = fso.CreateTextFile(strFilePath);
    for(var i=0; i<convertedLines.length;i++)
    {
        objFile.WriteLine(convertedLines[i]);
    }
    objFile.Close();

    fso.DeleteFile(backupFilePath);

    fso = null;
}

function AddFilters(proj)
{
	try
	{
	    // ftHg̃tB^[o^
	    SetupFilters(proj);

		// tB^[ǉ
	    var L_strBuild_Text = GetLocaleFilterName();
	    group = proj.Object.AddFilter(L_strBuild_Text);
	    group.Filter = "props";
	    group.UniqueIdentifier = "{F1DF9757-14C3-43FA-8525-6665FEDE7BA5}";
	}
	catch(e)
	{
		throw e;
	}
}

function GetLocaleFilterName()
{
    // MEMO: P[ǉꍇ͂̊֐C
    var localeName = wizard.FindSymbol('LCID');
    var returnName = "";

    switch (localeName) {
        case "1041":
            returnName = "rh";
            break;
        case "1033":
        default:
            returnName = "for Build";
            break;
    }
    return returnName;
}

function AddConfig(proj, strProjectName)
{
	try
	{
        // R\[Avp̃RpCEJݒs܂
		//var config = proj.Object.Configurations('Debug');

		//var CLTool = config.Tools('VCCLCompilerTool');
		//var strDefines = "WIN32;_DEBUG;_CONSOLE";
		//CLTool.PreprocessorDefinitions = strDefines;

		//var LinkTool = config.Tools('VCLinkerTool');
		//LinkTool.SubSystem = subSystemConsole;


		//config = proj.Object.Configurations('Release');

		//var CLTool = config.Tools('VCCLCompilerTool');
		//strDefines = "WIN32;NDEBUG;_CONSOLE";
		//CLTool.PreprocessorDefinitions = strDefines;

		//var LinkTool = config.Tools('VCLinkerTool');
		//LinkTool.SubSystem = subSystemConsole;
	}
	catch(e)
	{
		throw e;
	}
}

function PchSettings(proj)
{
    try
    {
        var bPCH = wizard.FindSymbol("ID_BUILD_OPTION_PCH");
        if (bPCH == true) {
            var configs = proj.Object.Configurations;

            var files = proj.Object.Files;
            var strFile = wizard.FindSymbol("PCH_FILE");
            if (null != strFile)
                file = files(strFile);
            else
                file = files("StdAfx.cpp");
            if (!file)
                return;

            for (var i = 1; i <= configs.Count; i++) {
                // setup /Yu (using precompiled headers)
                config = configs.Item(i);
                var CLTool = config.Tools("VCCLCompilerTool");
                CLTool.UsePrecompiledHeader = pchUseUsingSpecific;
                // setup /Yc (create precompiled header)
                fileConfig = file.FileConfigurations(config.Name);
                fileConfig.Tool.UsePrecompiledHeader = pchCreateUsingSpecific;
            }
        }
    }
    catch (e)
    {
        throw e;
    }
}

function GetSdkRootPathStringForPropertySheet()
{
    var setting = wizard.FindSymbol('Setting');
    if(!setting)
    {
        return "";
    }

    var sdkPathString = setting.sdkRootPath;
    if (sdkPathString.substr(0, 1) == '%' && sdkPathString.charAt(sdkPathString.length - 1) == '%') {
        // SDKpX %XXX% łꍇ
        return "$(" + sdkPathString.substr(1, sdkPathString.length - 2) + ")";
    }
    else
    {
        return sdkPathString;
    }
}

function AddSdkRootPathConfig()
{
    var setting = wizard.FindSymbol('Setting');
    if(!setting)
    {
        return;
    }
    var sdkPathString = setting.sdkRootPath;
    var strProjectPath = wizard.FindSymbol('PROJECT_PATH');

    if (sdkPathString.substr(0, 1) == '%' && sdkPathString.charAt(sdkPathString.length - 1) == '%') {
        // SDKpX %XXX% łꍇ
        var rootEnvName = sdkPathString.substr(1, sdkPathString.length - 2);
        var strCreateFile;
        var objFileSys = new ActiveXObject("Scripting.FileSystemObject");
        strCreateFile = objFileSys.BuildPath(strProjectPath, "NintendoSdkRootDefinition.props");
        var objWriteStream = objFileSys.CreateTextFile(strCreateFile);
        objWriteStream.WriteLine("<?xml version=\"1.0\" encoding=\"sjis\"?>");
        objWriteStream.WriteLine("");
        objWriteStream.WriteLine("");
        objWriteStream.WriteLine("<!-- ̃t@C̃t@CύXȂł -->");
        objWriteStream.WriteLine("");
        objWriteStream.WriteLine("<Project ToolsVersion=\"4.0\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">");
        objWriteStream.WriteLine("  <PropertyGroup Condition=\"'$(" + rootEnvName + ")' != ''\">");
        objWriteStream.WriteLine("    <NINTENDO_SDK_ROOT>$(" + rootEnvName + ")\</NINTENDO_SDK_ROOT>");
        objWriteStream.WriteLine("  </PropertyGroup>");
        objWriteStream.WriteLine("</Project>");
        objWriteStream.Close();
        objWriteStream = null;
        objFileSys = null;
    }
    else {
        // SDKpXϐ`ł͂Ȃꍇ
        var rootEnvName = sdkPathString.substr(1, sdkPathString.length - 2);
        var strCreateFile;
        var objFileSys = new ActiveXObject("Scripting.FileSystemObject");
        strCreateFile = objFileSys.BuildPath(strProjectPath, "NintendoSdkRootDefinition.props");
        var objWriteStream = objFileSys.CreateTextFile(strCreateFile);
        objWriteStream.WriteLine("<?xml version=\"1.0\" encoding=\"sjis\"?>");
        objWriteStream.WriteLine("");
        objWriteStream.WriteLine("");
        objWriteStream.WriteLine("<!-- ̃t@C̃t@CύXȂł -->");
        objWriteStream.WriteLine("");
        objWriteStream.WriteLine("<Project ToolsVersion=\"4.0\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">");
        objWriteStream.WriteLine("  <PropertyGroup>");
        objWriteStream.WriteLine("    <NINTENDO_SDK_ROOT>" + sdkPathString + "</NINTENDO_SDK_ROOT>");
        objWriteStream.WriteLine("  </PropertyGroup>");
        objWriteStream.WriteLine("</Project>");
        objWriteStream.Close();
        objWriteStream = null;
        objFileSys = null;
    }
}

function SetProjectOptionalProperty(strTemplateFilePath)
{
    var setting = wizard.FindSymbol('Setting');
    if(!setting)
    {
        return;
    }

    var addPropertyString = "";

    for(var i=0; i<setting.executeConfigs.length; i++)
    {
        if(setting.executeConfigs[i]["copyAndAddPropertyToProject"] != undefined)
        {
            var propPath = setting.executeConfigs[i]["copyAndAddPropertyToProject"];
            var propFileName = propPath.substr(propPath.lastIndexOf('\\')+1);

            var propertyString = "    <ImportGroup Label=\"PropertySheets\">\n" +
                                 "      <Import Project=\"" + propFileName + "\" Condition=\"exists('" + propFileName + "')\" />\n" +
                                 "    </ImportGroup>\n";
            addPropertyString = addPropertyString + propertyString;
        }
    }

    ConvertStringInFile(strTemplateFilePath, /CONVSTR_ADD_PROP/g, addPropertyString);
}

function ParseAddPropertySheetNameFromConfigLines(addPropFiles, configLines)
{
	var chkHeader = "PRJCOPY__";

	for(var i=0; i<configLines.length; i++)
	{
		if(configLines[i].indexOf(chkHeader) == 0)
		{
			addPropFiles.push(configLines[i].substring(chkHeader.length));
		}
	}
}

function ParseMetaFileNameFromConfigLines(addMetaFiles, configLines)
{
	var chkHeader = "PRJMETACOPY__";

	for(var i=0; i<configLines.length; i++)
	{
		if(configLines[i].indexOf(chkHeader) == 0)
		{
			addMetaFiles.push(configLines[i].substring(chkHeader.length));
		}
	}
}

function AddSpecifiedPropertyFiles(strProjectPath, strSdkRootDir, addPropFiles)
{
	var oldPropFiles = ["NintendoSdkBuildType_Debug.props", "NintendoSdkBuildType_Develop.props", "NintendoSdkBuildType_Release.props", "NintendoSdkVcProjectSettings.props"];
	var propFiles = [];
	var strBuildCommonPath = strSdkRootDir + "\\Build\\VcProjectUtility";
	var bCopyOnly = false;
	var isOldCompatible = false;

	// compatible check
	for(var i=0; i<addPropFiles.length; i++)
	{
		var fName = addPropFiles[i];
		if(fName == "NintendoSdkSpec_NX.props" || fName == "NintendoSdkSpec_Generic.props")
		{
			isOldCompatible = true;
		}
	}

	// add property sheet
	for(var i=0; i<addPropFiles.length; i++)
	{
		propFiles.push(addPropFiles[i]);
	}
	if(isOldCompatible == true)
	{
		// add old propety sheets for compatible
		for(var i=0; i<oldPropFiles.length; i++)
		{
			propFiles.push(oldPropFiles[i]);
		}
	}
	for(var i=0; i<propFiles.length; i++)
	{
		var strLocalTemplate = strBuildCommonPath + "\\" + propFiles[i];
		var strFile = strProjectPath + "\\" + propFiles[i];
		wizard.RenderTemplate(strLocalTemplate, strFile, bCopyOnly);
	}

	if(isOldCompatible == true)
	{
		// create old root path definition property sheet for compatible
		AddSdkRootPathConfig();
	}
}

function AddSpecifiedMetaFiles(proj, strProjectPath, strSdkRootDir, addMetaFiles)
{
	if(addMetaFiles.length <= 0)
	{
		return;
	}

        var metaDirectories = ["Resources\\SpecFiles", "Programs\\Iris\\Resources\\SpecFiles"];
	var fso = new ActiveXObject('Scripting.FileSystemObject');

	var strDirPath = strSdkRootDir + '\\' + metaDirectories[0];
	var strFilePath = strDirPath + '\\' + addMetaFiles[0];
	if(!fso.FileExists(strFilePath))
	{
		strDirPath = strSdkRootDir + '\\' + metaDirectories[1];
		strFilePath = strDirPath + '\\' + addMetaFiles[0];
		if(!fso.FileExists(strFilePath))
		{
			return;
		}
	}
        var strFile = fso.GetFile(strFilePath);
        var strDestPath = strProjectPath + '\\' + strFile.Name;
	wizard.RenderTemplate(strFilePath, strDestPath, true);
	var addFileObj = proj.Object.AddFile(strDestPath);
	addFileObj.ItemType = "CustomBuild";	// MEMO: for enabling build by modify

	for(var i=1; i<addMetaFiles.length; i++)
	{
		strFilePath = strDirPath + '\\' + addMetaFiles[i];
        	strFile = fso.GetFile(strFilePath);
	        strDestPath = strProjectPath + '\\' + strFile.Name;
		wizard.RenderTemplate(strFilePath, strDestPath, true);
		addFileObj = proj.Object.AddFile(strDestPath);
		addFileObj.ItemType = "CustomBuild";	// MEMO: for enabling build by modify
	}
}

function AddOptionalPropertyFile()
{
    var setting = wizard.FindSymbol('Setting');
    if(!setting)
    {
        return;
    }

    var fso = new ActiveXObject('Scripting.FileSystemObject');

    for(var i=0; i<setting.executeConfigs.length; i++)
    {
        if(setting.executeConfigs[i]["copyAndAddPropertyToProject"] != undefined)
        {
            var propPath = setting.executeConfigs[i]["copyAndAddPropertyToProject"];
            var strProjectPath = wizard.FindSymbol('PROJECT_PATH');
            var copyFilePath = setting.sdkRootPath + '\\' + propPath;
            var copyFileName = copyFilePath.substr(copyFilePath.lastIndexOf('\\')+1);
            var bCopyOnly = false;
            var strFile = strProjectPath + "\\" + copyFileName;

            fso.CopyFile(copyFilePath, strFile);
        }
    }
    fso = null;
}

function DelFile(fso, strWizTempFile)
{
	try
	{
		if (fso.FileExists(strWizTempFile))
		{
			var tmpFile = fso.GetFile(strWizTempFile);
			tmpFile.Delete();
		}
	}
	catch(e)
	{
		throw e;
	}
}

function CreateCustomInfFile()
{
	var fso, TemplatesFolder, TemplateFiles, strTemplate;
	fso = new ActiveXObject('Scripting.FileSystemObject');

	var TemporaryFolder = 2;
	var tfolder = fso.GetSpecialFolder(TemporaryFolder);
	var strTempFolder = tfolder.Drive + '\\' + tfolder.Name;

	var strWizTempFile = strTempFolder + "\\" + fso.GetTempName();

	var strTemplatePath = wizard.FindSymbol('TEMPLATES_PATH');
	var strInfFile = strTemplatePath + '\\Templates.inf';
	wizard.RenderTemplate(strInfFile, strWizTempFile);

	var WizTempFile = fso.GetFile(strWizTempFile);
	return WizTempFile;
}

function GetTargetName(strName, strProjectName)
{
	try
	{
		// TODO: ev[g t@Cɒoꂽt@C̖Oݒ肷
		var strTarget = strName;

		if (strName == 'readme.txt')
			strTarget = 'ReadMe.txt';

		if (strName == 'sample.txt')
			strTarget = 'Sample.txt';

		if (strName == 'Main.cpp')
		    strTarget = strProjectName + '.cpp';

		return strTarget;
	}
	catch(e)
	{
		throw e;
	}
}

function AddFilesToCustomProj(proj, strProjectName, strProjectPath, InfFile)
{
	var projItems = proj.ProjectItems

	var strTemplatePath = wizard.FindSymbol('TEMPLATES_PATH');

	var strTpl = '';
	var strName = '';

	var strTextStream = InfFile.OpenAsTextStream(1, -2);
	while (!strTextStream.AtEndOfStream)
	{
		strTpl = strTextStream.ReadLine();
		if (strTpl != '')
		{
			strName = strTpl;
			var strTarget = GetTargetName(strName, strProjectName);
			var strTemplate = strTemplatePath + '\\' + strTpl;
			var strFile = strProjectPath + '\\' + strTarget;

			var bCopyOnly = false;  //"true" ́At@CvWFNgɒo/ǉ邱ƂȂɁAaddingstrTemplate  strTarget Ƀt@CRs[܂B
			var strExt = strName.substr(strName.lastIndexOf("."));
			if(strExt==".bmp" || strExt==".ico" || strExt==".gif" || strExt==".rtf" || strExt==".css")
				bCopyOnly = true;
			wizard.RenderTemplate(strTemplate, strFile, bCopyOnly);
			proj.Object.AddFile(strFile);
		}
	}
	strTextStream.Close();
}

function DebugWriteLine(strLine)
{
    var debugFilePath = "D:\\home\\siglo\\wizardLog.txt";
    var fso = new ActiveXObject("Scripting.FileSystemObject");
    var objWriteStream = fso.OpenTextFile(debugFilePath, 8, true);
    objWriteStream.WriteLine(strLine);
    objWriteStream.Close();
    objWriteStream = null;
    fso = null;
}

