:: Copyright (C)2013 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.

@echo off

:: ---------------------------------------------------------------------------
::
:: Perform the necessary processing just after the clone of the repository.
::
:: You should execute this script only once.
::
:: ---------------------------------------------------------------------------

set REPOSITORY_ROOT=%~dp0
set DOT_GIT_DIRECTORY=%REPOSITORY_ROOT%.git\

:: ---------------------------------------------------------------------------
::  Move to the repository root.
:: ---------------------------------------------------------------------------
cd %REPOSITORY_ROOT%

:: ----------------------------------------------------------------------------
::  Setup git environments.
:: ----------------------------------------------------------------------------
call "%REPOSITORY_ROOT%setupGit.cmd"

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to setup git settings. 1>&2
    goto error
)

:: ---------------------------------------------------------------------------
:: Setup external repositories.
:: ---------------------------------------------------------------------------
echo Setup external repositories.

git exrepo-m init

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to execute 'git exrepo-m init'. 1>&2
    goto error
)

:: ---------------------------------------------------------------------------
:: Checkout external repositories.
:: ---------------------------------------------------------------------------
echo Checkout external repositories.

git exrepo update

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to execute 'git exrepo update'. 1>&2
    goto error
)

:: ---------------------------------------------------------------------------
:: Expand exstorage files.
:: ---------------------------------------------------------------------------
echo Expand exstorage files.

git exstorage expand

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to execute 'git exstorage expand'. 1>&2
    goto error
)

:: ---------------------------------------------------------------------------
:: Genarate GlobalAssemblyCache for PowerShell
:: ---------------------------------------------------------------------------
echo Genarate GlobalAssemblyCache for PowerShell
powershell -Version 2.0 -ExecutionPolicy RemoteSigned Integrate\Scripts\Invoke-NGenAll.ps1

:success
exit /B 0

:error
pause
exit /B 1
