﻿/// <header>
///   <version>0.0.0</version>
/// </header>

/// <tag name="Output">
///   <func id="Output"/>
/// </tag>
/// <func id="Output" name="Output">
///   <in name="color" type="vec4"/>
///   <description>出力</description>
/// </func>
/// <block guid="{00000000-0000-0000-0000-000000000000}" displayname="Output">
///   <func id="Output"/>
///   <in displayname="Albedo" type="vec4" target="color"/>
/// </block>
/// <code funcid="Output">
void Output( vec4 albedo )
{
    vec4 nw_out_albedo = albedo;
    nwOutputAlbedoColor = nw_out_albedo;

    // alpha processing
    nwOutputAlbedoColor.a = CalcAlphaProcess( nwOutputAlbedoColor.a );

    // custom shader
    FinalAdjustmentFragmentColor();

}
/// </code>

/// <tag name="Texture">
///   <func id="TextureCoord0"/>
/// </tag>
/// <func id="TextureCoord0" name="TextureCoord0">
///   <return type="vec2"/>
///   <description>テクスチャ座標 0</description>
/// </func>
/// <block guid="{00000000-0000-0002-0000-000000000000}" displayname="TextureCrd0">
///   <func id="TextureCoord0"/>
///   <out displayname="uv" type="vec2" target="return" semantic="TextureCoord0"/>
/// </block>
/// <code funcid="TextureCoord0">
vec2 TextureCoord0(  )
{
    return nwTextureCoord0;
}
/// </code>

/// <tag name="Texture">
///   <func id="TextureCoord1"/>
/// </tag>
/// <func id="TextureCoord1" name="TextureCoord1">
///   <return type="vec2"/>
///   <description>テクスチャ座標 1</description>
/// </func>
/// <block guid="{00000000-0000-0002-0000-000000000001}" displayname="TextureCrd1">
///   <func id="TextureCoord1"/>
///   <out displayname="uv" type="vec2" target="return" semantic="TextureCoord1"/>
/// </block>
/// <code funcid="TextureCoord1">
vec2 TextureCoord1(  )
{
    return nwTextureCoord1;
}
/// </code>

/// <tag name="Texture">
///   <func id="TextureCoord2"/>
/// </tag>
/// <func id="TextureCoord2" name="TextureCoord2">
///   <return type="vec2"/>
///   <description>テクスチャ座標 2</description>
/// </func>
/// <block guid="{00000000-0000-0002-0000-000000000002}" displayname="TextureCrd2">
///   <func id="TextureCoord2"/>
///   <out displayname="uv" type="vec2" target="return" semantic="TextureCoord2"/>
/// </block>
/// <code funcid="TextureCoord2">
vec2 TextureCoord2(  )
{
    return nwTextureCoord2;
}
/// </code>

/// <tag name="Texture">
///   <func id="AlbedoTexture0"/>
/// </tag>
/// <func id="AlbedoTexture0" name="AlbedoTexture0">
///   <in name="uv" type="vec2"/>
///   <return type="vec4"/>
///   <description>アルベド 0</description>
/// </func>
/// <block guid="{00000000-0000-0001-0001-000000000000}" displayname="AlbedoTexture0">
///   <func id="AlbedoTexture0"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <in displayname="uv" type="vec2" target="uv" semantic="TextureCoord0"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="_a0" displayname="" type="file" extension=".tga"/>
/// </block>
/// <code funcid="AlbedoTexture0">
vec4 AlbedoTexture0( vec2 uv )
{

    vec4 color = texture2D( nwAlbedoTexture0, uv );
    return color;
}
/// </code>

/// <tag name="Texture">
///   <func id="AlbedoTextureSampler0"/>
/// </tag>
/// <func id="AlbedoTextureSampler0" name="AlbedoTextureSampler0">
///   <return type="sampler2D"/>
///   <description>アルベド サンプラー 0</description>
/// </func>
/// <block guid="{00000000-0000-1001-0001-000000000000}" displayname="AlbedoTextureSampler0">
///   <func id="AlbedoTextureSampler0"/>
///   <out displayname="sampler2D" type="sampler2D" target="return"/>
///   <uniform name="_a0" displayname="" type="file" extension=".tga"/>
/// </block>
/// <code funcid="AlbedoTextureSampler0">
sampler2D AlbedoTextureSampler0(  )
{
    return nwAlbedoTexture0;
}
/// </code>

/// <tag name="Texture">
///   <func id="AlbedoTexture1"/>
/// </tag>
/// <func id="AlbedoTexture1" name="AlbedoTexture1">
///   <in name="uv" type="vec2"/>
///   <return type="vec4"/>
///   <description>アルベド 1</description>
/// </func>
/// <block guid="{00000000-0000-0001-0001-000000000001}" displayname="AlbedoTexture1">
///   <func id="AlbedoTexture1"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <in displayname="uv" type="vec2" target="uv" semantic="TextureCoord1"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="_a1" displayname="" type="file" extension=".tga"/>
/// </block>
/// <code funcid="AlbedoTexture1">
vec4 AlbedoTexture1( vec2 uv )
{

    vec4 color = texture2D( nwAlbedoTexture1, uv );
    return color;
}
/// </code>

/// <tag name="Texture">
///   <func id="AlbedoTexture2"/>
/// </tag>
/// <func id="AlbedoTexture2" name="AlbedoTexture2">
///   <in name="uv" type="vec2"/>
///   <return type="vec4"/>
///   <description>アルベド 2</description>
/// </func>
/// <block guid="{00000000-0000-0001-0001-000000000002}" displayname="AlbedoTexture2">
///   <func id="AlbedoTexture2"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <in displayname="uv" type="vec2" target="uv" semantic="TextureCoord2"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="_a2" displayname="" type="file" extension=".tga"/>
/// </block>
/// <code funcid="AlbedoTexture2">
vec4 AlbedoTexture2( vec2 uv )
{

    vec4 color = texture2D( nwAlbedoTexture2, uv );
    return color;
}
/// </code>

/// <tag name="Input">
///   <func id="GetConstantColorBlack"/>
/// </tag>
/// <func id="GetConstantColorBlack" name="GetConstantColorBlack">
///   <return type="vec4"/>
///   <description>ui2d 用コンスタントカラー 黒</description>
/// </func>
/// <block guid="{00000000-0000-0010-0000-000000000000}" displayname="ConstantColorBlack">
///   <func id="GetConstantColorBlack"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="m_VectorParameter6" displayname="ConstantColorBlack" type="vec4" />
/// </block>
/// <code funcid="GetConstantColorBlack">
vec4 GetConstantColorBlack()
{
    return nwConstantColor0;
}
/// </code>

/// <tag name="Input">
///   <func id="GetConstantColorWhite"/>
/// </tag>
/// <func id="GetConstantColorWhite" name="GetConstantColorWhite">
///   <return type="vec4"/>
///   <description>ui2d 用コンスタントカラー 白</description>
/// </func>
/// <block guid="{00000000-0000-0010-0000-000000000001}" displayname="ConstantColorWhite">
///   <func id="GetConstantColorWhite"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="m_VectorParameter0" displayname="ConstantColorWhite" type="vec4" />
/// </block>
/// <code funcid="GetConstantColorWhite">
vec4 GetConstantColorWhite()
{
    return nwConstantColor1;
}
/// </code>

/// <tag name="Input">
///   <func id="GetConstantColor0"/>
/// </tag>
/// <func id="GetConstantColor0" name="GetConstantColor0">
///   <return type="vec4"/>
///   <description>ui2d 用コンスタントカラー 0</description>
/// </func>
/// <block guid="{00000000-0000-0010-0000-000000000002}" displayname="ConstantColor0">
///   <func id="GetConstantColor0"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="m_VectorParameter1" displayname="ConstantColor0" type="vec4" />
/// </block>
/// <code funcid="GetConstantColor0">
vec4 GetConstantColor0()
{
    return nwConstantColor2;
}
/// </code>

/// <tag name="Input">
///   <func id="GetConstantColor1"/>
/// </tag>
/// <func id="GetConstantColor1" name="GetConstantColor1">
///   <return type="vec4"/>
///   <description>ui2d 用コンスタントカラー 1</description>
/// </func>
/// <block guid="{00000000-0000-0010-0000-000000000003}" displayname="ConstantColor1">
///   <func id="GetConstantColor1"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="m_VectorParameter2" displayname="ConstantColor1" type="vec4" />
/// </block>
/// <code funcid="GetConstantColor1">
vec4 GetConstantColor1()
{
    return nwConstantColor3;
}
/// </code>

/// <tag name="Input">
///   <func id="GetConstantColor2"/>
/// </tag>
/// <func id="GetConstantColor2" name="GetConstantColor2">
///   <return type="vec4"/>
///   <description>ui2d 用コンスタントカラー 2</description>
/// </func>
/// <block guid="{00000000-0000-0010-0000-000000000004}" displayname="ConstantColor2">
///   <func id="GetConstantColor2"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="m_VectorParameter3" displayname="ConstantColor2" type="vec4" />
/// </block>
/// <code funcid="GetConstantColor2">
vec4 GetConstantColor2()
{
    return nwConstantColor4;
}
/// </code>

/// <tag name="Input">
///   <func id="GetConstantColor3"/>
/// </tag>
/// <func id="GetConstantColor3" name="GetConstantColor3">
///   <return type="vec4"/>
///   <description>ui2d 用コンスタントカラー 3</description>
/// </func>
/// <block guid="{00000000-0000-0010-0000-000000000005}" displayname="ConstantColor3">
///   <func id="GetConstantColor3"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="m_VectorParameter4" displayname="ConstantColor3" type="vec4" />
/// </block>
/// <code funcid="GetConstantColor3">
vec4 GetConstantColor3()
{
    return nwConstantColor5;
}
/// </code>

/// <tag name="Input">
///   <func id="GetConstantColor4"/>
/// </tag>
/// <func id="GetConstantColor4" name="GetConstantColor4">
///   <return type="vec4"/>
///   <description>ui2d 用コンスタントカラー 4</description>
/// </func>
/// <block guid="{00000000-0000-0010-0000-000000000006}" displayname="ConstantColor4">
///   <func id="GetConstantColor4"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="m_VectorParameter5" displayname="ConstantColor4" type="vec4" />
/// </block>
/// <code funcid="GetConstantColor4">
vec4 GetConstantColor4()
{
    return nwConstantColor6;
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataVec3_0"/>
/// </tag>
/// <func id="GetExUserDataVec3_0" name="GetExUserDataVec3_0">
///   <return type="vec3"/>
///   <description>ui2d 拡張ユーザーデータ Vec3 0</description>
/// </func>
/// <block guid="{00000000-0000-0011-0000-000000000000}" displayname="ExUserDataVec3_0">
///   <func id="GetExUserDataVec3_0"/>
///   <out displayname="vec3" type="vec3" target="return.xyz"/>
///   <preview enabled="true" width="64" height="64"/>
/// </block>
/// <code funcid="GetExUserDataVec3_0">
vec3 GetExUserDataVec3_0(  )
{
    return userData_vec3[0];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataVec3_1"/>
/// </tag>
/// <func id="GetExUserDataVec3_1" name="GetExUserDataVec3_1">
///   <return type="vec3"/>
///   <description>ui2d 拡張ユーザーデータ Vec3 1</description>
/// </func>
/// <block guid="{95CA063E-D20A-421B-956D-68133A10E774}" displayname="ExUserDataVec3_1">
///   <func id="GetExUserDataVec3_1"/>
///   <out displayname="vec3" type="vec3" target="return.xyz"/>
/// </block>
/// <code funcid="GetExUserDataVec3_1">
vec3 GetExUserDataVec3_1(  )
{
    return userData_vec3[1];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataVec3_2"/>
/// </tag>
/// <func id="GetExUserDataVec3_2" name="GetExUserDataVec3_2">
///   <return type="vec3"/>
///   <description>ui2d 拡張ユーザーデータ Vec3 2</description>
/// </func>
/// <block guid="{A7127E9E-14C7-4D30-9DCC-93F50CF837C3}" displayname="ExUserDataVec3_2">
///   <func id="GetExUserDataVec3_2"/>
///   <out displayname="vec3" type="vec3" target="return.xyz"/>
/// </block>
/// <code funcid="GetExUserDataVec3_2">
vec3 GetExUserDataVec3_2(  )
{
    return userData_vec3[2];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataVec3_3"/>
/// </tag>
/// <func id="GetExUserDataVec3_3" name="GetExUserDataVec3_3">
///   <return type="vec3"/>
///   <description>ui2d 拡張ユーザーデータ Vec3 3</description>
/// </func>
/// <block guid="{17C12F67-085D-47AE-893A-65126BD42A66}" displayname="ExUserDataVec3_3">
///   <func id="GetExUserDataVec3_3"/>
///   <out displayname="vec3" type="vec3" target="return.xyz"/>
/// </block>
/// <code funcid="GetExUserDataVec3_3">
vec3 GetExUserDataVec3_3(  )
{
    return userData_vec3[3];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataVec2_0"/>
/// </tag>
/// <func id="GetExUserDataVec2_0" name="GetExUserDataVec2_0">
///   <return type="vec2"/>
///   <description>ui2d 拡張ユーザーデータ Vec2 0</description>
/// </func>
/// <block guid="{109BCDB6-45A7-4952-9970-9CAD870F3018}" displayname="ExUserDataVec2_0">
///   <func id="GetExUserDataVec2_0"/>
///   <out displayname="Vec2" type="vec2" target="return"/>
/// </block>
/// <code funcid="GetExUserDataVec2_0">
vec2 GetExUserDataVec2_0(  )
{
    return userData_vec2[0];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataVec2_1"/>
/// </tag>
/// <func id="GetExUserDataVec2_1" name="GetExUserDataVec2_1">
///   <return type="vec2"/>
///   <description>ui2d 拡張ユーザーデータ Vec2 1</description>
/// </func>
/// <block guid="{A539E373-21A2-4550-83CC-AE2A8E4B0AEA}" displayname="ExUserDataVec2_1">
///   <func id="GetExUserDataVec2_1"/>
///   <out displayname="Vec2" type="vec2" target="return"/>
/// </block>
/// <code funcid="GetExUserDataVec2_1">
vec2 GetExUserDataVec2_1(  )
{
    return userData_vec2[1];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataVec2_2"/>
/// </tag>
/// <func id="GetExUserDataVec2_2" name="GetExUserDataVec2_2">
///   <return type="vec2"/>
///   <description>ui2d 拡張ユーザーデータ Vec2 2</description>
/// </func>
/// <block guid="{A73EA51D-CE6E-4DF1-9FF2-AFD3363BA1D1}" displayname="ExUserDataVec2_2">
///   <func id="GetExUserDataVec2_2"/>
///   <out displayname="Vec2" type="vec2" target="return"/>
/// </block>
/// <code funcid="GetExUserDataVec2_2">
vec2 GetExUserDataVec2_2(  )
{
    return userData_vec2[2];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataVec2_3"/>
/// </tag>
/// <func id="GetExUserDataVec2_3" name="GetExUserDataVec2_3">
///   <return type="vec2"/>
///   <description>ui2d 拡張ユーザーデータ Vec2 3</description>
/// </func>
/// <block guid="{934FBDB6-4136-44F5-85A3-3B1DD5B57AA3}" displayname="ExUserDataVec2_3">
///   <func id="GetExUserDataVec2_3"/>
///   <out displayname="vec2" type="vec2" target="return"/>
/// </block>
/// <code funcid="GetExUserDataVec2_3">
vec2 GetExUserDataVec2_3(  )
{
    return userData_vec2[3];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataRgba_0"/>
/// </tag>
/// <func id="GetExUserDataRgba_0" name="GetExUserDataRgba_0">
///   <return type="ivec4"/>
///   <description>ui2d 拡張ユーザーデータ Rgba 0 を整数 0～255 で出力</description>
/// </func>
/// <block guid="{936BF66C-BED2-4AE7-982D-63C524745A30}" displayname="ExUserDataRgba_0">
///   <func id="GetExUserDataRgba_0"/>
///   <out displayname="Rgba" type="ivec4" target="return"/>
/// </block>
/// <code funcid="GetExUserDataRgba_0">
ivec4 GetExUserDataRgba_0(  )
{
    return userData_rgba[0];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataRgba_1"/>
/// </tag>
/// <func id="GetExUserDataRgba_1" name="GetExUserDataRgba_1">
///   <return type="ivec4"/>
///   <description>ui2d 拡張ユーザーデータ Rgba 1 を整数 0～255 で出力</description>
/// </func>
/// <block guid="{4990DBCF-4207-40F3-B1A0-16A63F555B6F}" displayname="ExUserDataRgba_1">
///   <func id="GetExUserDataRgba_1"/>
///   <out displayname="Rgba" type="ivec4" target="return"/>
/// </block>
/// <code funcid="GetExUserDataRgba_1">
ivec4 GetExUserDataRgba_1(  )
{
    return userData_rgba[1];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataRgba_2"/>
/// </tag>
/// <func id="GetExUserDataRgba_2" name="GetExUserDataRgba_2">
///   <return type="ivec4"/>
///   <description>ui2d 拡張ユーザーデータ Rgba 2 を整数 0～255 で出力</description>
/// </func>
/// <block guid="{99E6CE5D-F13C-49FA-8005-A2A758AE9714}" displayname="ExUserDataRgba_2">
///   <func id="GetExUserDataRgba_2"/>
///   <out displayname="Rgba" type="ivec4" target="return"/>
/// </block>
/// <code funcid="GetExUserDataRgba_2">
ivec4 GetExUserDataRgba_2(  )
{
    return userData_rgba[2];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataRgba_3"/>
/// </tag>
/// <func id="GetExUserDataRgba_3" name="GetExUserDataRgba_3">
///   <return type="ivec4"/>
///   <description>ui2d 拡張ユーザーデータ Rgba 3 を整数 0～255 で出力</description>
/// </func>
/// <block guid="{A966368C-9488-4E86-B85B-479F2100585B}" displayname="ExUserDataRgba_3">
///   <func id="GetExUserDataRgba_3"/>
///   <out displayname="Rgba" type="ivec4" target="return"/>
/// </block>
/// <code funcid="GetExUserDataRgba_3">
ivec4 GetExUserDataRgba_3(  )
{
    return userData_rgba[3];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataFloatRgba_0"/>
/// </tag>
/// <func id="GetExUserDataFloatRgba_0" name="GetExUserDataFloatRgba_0">
///   <return type="vec4"/>
///   <description>ui2d 拡張ユーザーデータ Rgba 0 を 0.0～1.0 に変換して出力</description>
/// </func>
/// <block guid="{D3355CC9-4C57-4C52-970F-DC3AF89D56A8}" displayname="ExUserDataFloatRgba_0">
///   <func id="GetExUserDataFloatRgba_0"/>
///   <out displayname="Rgba" type="vec4" target="return"/>
/// </block>
/// <code funcid="GetExUserDataFloatRgba_0">
vec4 GetExUserDataFloatRgba_0(  )
{
    return vec4(vec4(userData_rgba[0]) / 255.0);
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataFloatRgba_1"/>
/// </tag>
/// <func id="GetExUserDataFloatRgba_1" name="GetExUserDataFloatRgba_1">
///   <return type="vec4"/>
///   <description>ui2d 拡張ユーザーデータ Rgba 1 を 0.0～1.0 に変換して出力</description>
/// </func>
/// <block guid="{8967D37E-F49D-4489-87D1-A946AE5B38FE}" displayname="ExUserDataFloatRgba_1">
///   <func id="GetExUserDataFloatRgba_1"/>
///   <out displayname="Rgba" type="vec4" target="return"/>
/// </block>
/// <code funcid="GetExUserDataFloatRgba_1">
vec4 GetExUserDataFloatRgba_1(  )
{
    return vec4(vec4(userData_rgba[1]) / 255.0);
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataFloatRgba_2"/>
/// </tag>
/// <func id="GetExUserDataFloatRgba_2" name="GetExUserDataFloatRgba_2">
///   <return type="vec4"/>
///   <description>ui2d 拡張ユーザーデータ Rgba 2 を 0.0～1.0 に変換して出力</description>
/// </func>
/// <block guid="{33FA2742-3749-4D84-B895-861871AC2F63}" displayname="ExUserDataFloatRgba_2">
///   <func id="GetExUserDataFloatRgba_2"/>
///   <out displayname="Rgba" type="vec4" target="return"/>
/// </block>
/// <code funcid="GetExUserDataFloatRgba_2">
vec4 GetExUserDataFloatRgba_2(  )
{
    return vec4(vec4(userData_rgba[2]) / 255.0);
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataFloatRgba_3"/>
/// </tag>
/// <func id="GetExUserDataFloatRgba_3" name="GetExUserDataFloatRgba_3">
///   <return type="vec4"/>
///   <description>ui2d 拡張ユーザーデータ Rgba 3 を 0.0～1.0 に変換して出力</description>
/// </func>
/// <block guid="{B7A3D344-0F7D-4E1E-8100-E220D2DC06D7}" displayname="ExUserDataFloatRgba_3">
///   <func id="GetExUserDataFloatRgba_3"/>
///   <out displayname="Rgba" type="vec4" target="return"/>
/// </block>
/// <code funcid="GetExUserDataFloatRgba_3">
vec4 GetExUserDataFloatRgba_3(  )
{
    return vec4(vec4(userData_rgba[3]) / 255.0);
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataIvec2_0"/>
/// </tag>
/// <func id="GetExUserDataIvec2_0" name="GetExUserDataIvec2_0">
///   <return type="ivec2"/>
///   <description>ui2d 拡張ユーザーデータ Ivec2 0</description>
/// </func>
/// <block guid="{DDD91255-0E94-4A10-A7EA-01C501E445D6}" displayname="ExUserDataIvec2_0">
///   <func id="GetExUserDataIvec2_0"/>
///   <out displayname="Ivec2" type="ivec2" target="return"/>
/// </block>
/// <code funcid="GetExUserDataIvec2_0">
ivec2 GetExUserDataIvec2_0(  )
{
    return userData_ivec2[0];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataIvec2_1"/>
/// </tag>
/// <func id="GetExUserDataIvec2_1" name="GetExUserDataIvec2_1">
///   <return type="ivec2"/>
///   <description>ui2d 拡張ユーザーデータ Ivec2 1</description>
/// </func>
/// <block guid="{98F5D377-2608-4053-84E4-3C538A1D1C12}" displayname="ExUserDataIvec2_1">
///   <func id="GetExUserDataIvec2_1"/>
///   <out displayname="Ivec2" type="ivec2" target="return"/>
/// </block>
/// <code funcid="GetExUserDataIvec2_1">
ivec2 GetExUserDataIvec2_1(  )
{
    return userData_ivec2[0];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataIvec2_2"/>
/// </tag>
/// <func id="GetExUserDataIvec2_2" name="GetExUserDataIvec2_2">
///   <return type="ivec2"/>
///   <description>ui2d 拡張ユーザーデータ Ivec2 2</description>
/// </func>
/// <block guid="{9CBE3A7A-CDA6-4C41-91F1-DFD8C5BC1C51}" displayname="ExUserDataIvec2_2">
///   <func id="GetExUserDataIvec2_2"/>
///   <out displayname="Ivec2" type="ivec2" target="return"/>
/// </block>
/// <code funcid="GetExUserDataIvec2_2">
ivec2 GetExUserDataIvec2_2(  )
{
    return userData_ivec2[0];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataIvec2_3"/>
/// </tag>
/// <func id="GetExUserDataIvec2_3" name="GetExUserDataIvec2_3">
///   <return type="ivec2"/>
///   <description>ui2d 拡張ユーザーデータ Ivec2 3</description>
/// </func>
/// <block guid="{F728D879-A47D-4138-BE55-955DA18F24E0}" displayname="ExUserDataIvec2_3">
///   <func id="GetExUserDataIvec2_3"/>
///   <out displayname="Ivec2" type="ivec2" target="return"/>
/// </block>
/// <code funcid="GetExUserDataIvec2_3">
ivec2 GetExUserDataIvec2_3(  )
{
    return userData_ivec2[0];
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataInt_0"/>
/// </tag>
/// <func id="GetExUserDataInt_0" name="GetExUserDataInt_0">
///   <return type="int"/>
///   <description>ui2d 拡張ユーザーデータ Int 0</description>
/// </func>
/// <block guid="{5F7CF481-C347-4B00-9A0B-52DF7270BF0F}" displayname="ExUserDataInt_0">
///   <func id="GetExUserDataInt_0"/>
///   <out displayname="Int" type="int" target="return"/>
/// </block>
/// <code funcid="GetExUserDataInt_0">
int GetExUserDataInt_0(  )
{
    return userData_i0;
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataInt_1"/>
/// </tag>
/// <func id="GetExUserDataInt_1" name="GetExUserDataInt_1">
///   <return type="int"/>
///   <description>ui2d 拡張ユーザーデータ Int 1</description>
/// </func>
/// <block guid="{C34A3815-F2A5-466B-BE9C-FA16086670A0}" displayname="ExUserDataInt_1">
///   <func id="GetExUserDataInt_1"/>
///   <out displayname="Int" type="int" target="return"/>
/// </block>
/// <code funcid="GetExUserDataInt_1">
int GetExUserDataInt_1(  )
{
    return userData_i1;
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataInt_2"/>
/// </tag>
/// <func id="GetExUserDataInt_2" name="GetExUserDataInt_2">
///   <return type="int"/>
///   <description>ui2d 拡張ユーザーデータ Int 2</description>
/// </func>
/// <block guid="{ADB08165-0AA5-465C-A309-47F25088FEDD}" displayname="ExUserDataInt_2">
///   <func id="GetExUserDataInt_2"/>
///   <out displayname="Int" type="int" target="return"/>
/// </block>
/// <code funcid="GetExUserDataInt_2">
int GetExUserDataInt_2(  )
{
    return userData_i2;
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataInt_3"/>
/// </tag>
/// <func id="GetExUserDataInt_3" name="GetExUserDataInt_3">
///   <return type="int"/>
///   <description>ui2d 拡張ユーザーデータ Int 3</description>
/// </func>
/// <block guid="{97CA0FD4-4EB7-4484-AACB-FF895AD10F11}" displayname="ExUserDataInt_3">
///   <func id="GetExUserDataInt_3"/>
///   <out displayname="Int" type="int" target="return"/>
/// </block>
/// <code funcid="GetExUserDataInt_3">
int GetExUserDataInt_3(  )
{
    return userData_i3;
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataFloat_0"/>
/// </tag>
/// <func id="GetExUserDataFloat_0" name="GetExUserDataFloat_0">
///   <return type="float"/>
///   <description>ui2d 拡張ユーザーデータ Float 0</description>
/// </func>
/// <block guid="{56BE95AC-78A8-4494-AA61-6B6EBC1BB855}" displayname="ExUserDataFloat_0">
///   <func id="GetExUserDataFloat_0"/>
///   <out displayname="Float" type="float" target="return"/>
/// </block>
/// <code funcid="GetExUserDataFloat_0">
float GetExUserDataFloat_0(  )
{
    return userData_f0;
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataFloat_1"/>
/// </tag>
/// <func id="GetExUserDataFloat_1" name="GetExUserDataFloat_1">
///   <return type="float"/>
///   <description>ui2d 拡張ユーザーデータ Float 1</description>
/// </func>
/// <block guid="{15A66E43-B0C1-4F27-97E1-9A7059DFAEB7}" displayname="ExUserDataFloat_1">
///   <func id="GetExUserDataFloat_1"/>
///   <out displayname="Float" type="float" target="return"/>
/// </block>
/// <code funcid="GetExUserDataFloat_1">
float GetExUserDataFloat_1(  )
{
    return userData_f1;
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataFloat_2"/>
/// </tag>
/// <func id="GetExUserDataFloat_2" name="GetExUserDataFloat_2">
///   <return type="float"/>
///   <description>ui2d 拡張ユーザーデータ Float 2</description>
/// </func>
/// <block guid="{79B0F5CC-67B8-4DED-8333-920861F6EDD4}" displayname="ExUserDataFloat_2">
///   <func id="GetExUserDataFloat_2"/>
///   <out displayname="Float" type="float" target="return"/>
/// </block>
/// <code funcid="GetExUserDataFloat_2">
float GetExUserDataFloat_2(  )
{
    return userData_f2;
}
/// </code>

/// <tag name="Input">
///   <func id="GetExUserDataFloat_3"/>
/// </tag>
/// <func id="GetExUserDataFloat_3" name="GetExUserDataFloat_3">
///   <return type="float"/>
///   <description>ui2d 拡張ユーザーデータ Float 3</description>
/// </func>
/// <block guid="{15251DFC-2135-460C-80BA-4F73923B2366}" displayname="ExUserDataFloat_3">
///   <func id="GetExUserDataFloat_3"/>
///   <out displayname="Float" type="float" target="return"/>
/// </block>
/// <code funcid="GetExUserDataFloat_3">
float GetExUserDataFloat_3(  )
{
    return userData_f3;
}
/// </code>

/// <tag name="Input">
///   <func id="ToFloat"/>
/// </tag>
/// <func id="ToFloat" name="ToFloat">
///   <in name="v" type="int"/>
///   <return type="float"/>
///   <description>型変換 Int → Float</description>
/// </func>
/// <block guid="{6092D513-4BCB-47CB-8DEC-2D2ADA280068}" displayname="ToFloat">
///   <func id="ToFloat"/>
///   <out displayname="Float" type="float" target="return"/>
///   <in displayname="Int" type="int" target="v"/>
/// </block>
/// <code funcid="ToFloat">
float ToFloat( int v )
{
    return float(v);
}
/// </code>

/// <tag name="Input">
///   <func id="ToInt"/>
/// </tag>
/// <func id="ToInt" name="ToInt">
///   <in name="v" type="float"/>
///   <return type="int"/>
///   <description>型変換 Float → Int</description>
/// </func>
/// <block guid="{C713F987-C96C-46F2-8D49-6A523C6EDFFE}" displayname="ToInt">
///   <func id="ToInt"/>
///   <out displayname="Int" type="int" target="return"/>
///   <in displayname="Float" type="float" target="v"/>
/// </block>
/// <code funcid="ToInt">
int ToInt( float v )
{
    return int(v);
}
/// </code>

/// <tag name="Input">
///   <func id="ToVec4"/>
/// </tag>
/// <func id="ToVec4" name="ToVec4">
///   <in name="v" type="ivec4"/>
///   <return type="vec4"/>
///   <description>型変換 Ivec4 → Vec4</description>
/// </func>
/// <block guid="{DBC09ADE-85EE-46FA-8914-CB5B5C2F42FC}" displayname="ToVec4">
///   <func id="ToVec4"/>
///   <out displayname="Vec4" type="vec4" target="return"/>
///   <in displayname="Ivec4" type="ivec4" target="v"/>
/// </block>
/// <code funcid="ToVec4">
vec4 ToVec4( ivec4 v )
{
    return vec4(v);
}
/// </code>

/// <tag name="Input">
///   <func id="GetCameraPosition"/>
/// </tag>
/// <func id="GetCameraPosition" name="GetCameraPosition">
///   <return type="vec3"/>
///   <description></description>
/// </func>
/// <block guid="{9B41A596-58AA-4EF6-B9DC-1E7FBFE8FD86}" displayname="GetCameraPosition">
///   <func id="GetCameraPosition"/>
///   <out displayname="position" type="vec3" target="return"/>
/// </block>
/// <code funcid="GetCameraPosition">
vec3 GetCameraPosition(  )
{
    return cameraPosition;
}
/// </code>

/// <tag name="Input">
///   <func id="GetVertexColor"/>
/// </tag>
/// <func id="GetVertexColor" name="VertexColor">
///   <return type="vec4"/>
///   <description></description>
/// </func>
/// <block guid="{8114AE8B-8B29-43B0-BB9F-9688185BCC6D}" displayname="VertexColor">
///   <func id="GetVertexColor"/>
///   <out displayname="Color" type="vec4" target="return"/>
///   <out displayname="RGB" type="vec3" target="return.xyz"/>
///   <out displayname="A" type="float" target="return.w"/>
///   <preview enabled="true" width="64" height="64"/>
///   <uniform name="m_VectorParameter7" displayname="vColor" type="vec4" />
/// </block>
/// <code funcid="GetVertexColor">
vec4 VertexColor(  )
{
    return vColor;
}
/// </code>

