﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):
	# fsd 以外の <nw4f_3dif> version を 2.1.0 に変更します。
	if not doc.SelectSingleNode("/nw4f_3dif/shader_definition"):
		version = doc.SelectSingleNode("/nw4f_3dif/@version")
		version.Value = "2.1.0"

	# モデルの更新
	model = doc.SelectSingleNode("/nw4f_3dif/model")
	if model:
		UpdateModel(doc, model)

#==========================================================
# モデルの更新
def UpdateModel(doc, model):
	# <material> material_index を index に変更します。
	RenameAttribute(model, "material_array/material/@material_index", "index")

	# <env_ref_array> を <render_info_array> に変更します。
	RenameElement(doc, "//env_ref_array", "render_info_array")

	# <env_ref> を <render_info> に変更します。
	RenameElement(doc, "//env_ref", "render_info")

	# <bone> bone_index を index に変更します。
	RenameAttribute(model, "skeleton/bone_array/bone/@bone_index", "index")

	# <shape> shape_index を index に変更します。
	RenameAttribute(model, "shape_array/shape/@shape_index", "index")

	# シェイプ情報の更新
	shape_index = 0
	for shape_info in model.SelectNodes("shape_array/shape/shape_info"):
		UpdateShapeInfo(doc, shape_info, shape_index)
		shape_index += 1

	# <renderset_array> を削除します。
	renderset_array = model.SelectSingleNode("renderset_array")
	model.RemoveChild(renderset_array)

#----------------------------------------------------------
# シェイプ情報の更新
def UpdateShapeInfo(doc, shape_info, shape_index):
	renderset = doc.SelectSingleNode(
		"/nw4f_3dif/model/renderset_array/renderset[@shape_index = %d]" % (shape_index))

	# <renderset> から <shape_info> に mat_name を追加します。
	material_index = int(renderset.GetAttribute("material_index")) + 1
	material = doc.SelectSingleNode(
		"/nw4f_3dif/model/material_array/material[%d]" % (material_index))
	shape_info.SetAttribute("mat_name", material.GetAttribute("name"))

	# <shape_info> の bone_index を bone_name に変更し、インデックスを名前に変換します。
	bone_index = int(shape_info.GetAttribute("bone_index")) + 1
	bone = doc.SelectSingleNode(
		"/nw4f_3dif/model/skeleton/bone_array/bone[%d]" % (bone_index))
	shape_info.SetAttribute("bone_name", bone.GetAttribute("name"))
	shape_info.RemoveAttribute("bone_index")

	# <renderset> から <shape_info> に render_priority を追加します。
	shape_info.SetAttribute("render_priority", renderset.GetAttribute("priority"))

#==========================================================
# 要素のリネーム
def RenameElement(doc, xPath, newName):
	for oldElement in doc.SelectNodes(xPath):
		newElement = doc.CreateElement(newName)

		# 属性の移植
		for attribute in oldElement.Attributes:
			newElement.SetAttribute(attribute.Name, attribute.Value)

		# 子要素の移植
		while oldElement.HasChildNodes:
			newElement.AppendChild(oldElement.FirstChild)

		# 要素の差し替え
		oldElement.ParentNode.ReplaceChild(newElement, oldElement)

#----------------------------------------------------------
# 属性のリネーム
def RenameAttribute(target, xPath, newName):
	for oldAttribute in target.SelectNodes(xPath):
		ownerElement = oldAttribute.OwnerElement
		ownerElement.RemoveAttributeNode(oldAttribute)
		ownerElement.SetAttribute(newName, oldAttribute.Value)

#==========================================================
