﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_ServiceTypes.h>

namespace nnt{ namespace vi{

    static const int IndirectLayerSlotCount = 8;

    struct IndirectLayerSlot
    {
        nn::vi::IndirectLayerHandleType hLayer;
        nn::vi::IndirectProducerHandleType hProducerEndPoint;
        nn::vi::IndirectConsumerHandleType hConsumerEndPoint;
    };

    class IndirectLayerSlotList
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        IndirectLayerSlot& operator[](int index) NN_NOEXCEPT;

    private:
        IndirectLayerSlot m_List[IndirectLayerSlotCount];
    };

    extern IndirectLayerSlotList g_IndirectLayerSlotList;

}}
