﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include "settings/visrv_PhysicalDisplay.h"
#include "SettingsFixture.h"
#include "SettingsStub.h"

typedef SettingsFixture PhysicalDisplay;

TEST_F(PhysicalDisplay, Ctor)
{
    nn::visrv::settings::PhysicalDisplay display;

    for( int i = 0; i < sizeof(display.name); ++i )
    {
        EXPECT_EQ(0, display.name[i]);
    }

    for( int i = 0; i < sizeof(display.edidDisplayName); ++i )
    {
        EXPECT_EQ(0, display.edidDisplayName[i]);
    }

    EXPECT_LT(display.dc, 0);
}

TEST_F(PhysicalDisplay, Read)
{
    nnt::settings::WriteBuffer("External", "physical_display_0_name");
    nnt::settings::WriteBuffer("Edid", "physical_display_0_edid_display_name");
    nnt::settings::WriteValue(1, "physical_display_0_dc");

    nn::visrv::settings::PhysicalDisplay display;
    display.Read(0);

    EXPECT_STREQ("External", display.name);
    EXPECT_STREQ("Edid", display.edidDisplayName);
    EXPECT_EQ(1, display.dc);
}

TEST_F(PhysicalDisplay, Read_DefaultName)
{
    nnt::settings::WriteBuffer("", "physical_display_0_edid_display_name");
    nnt::settings::WriteValue(1, "physical_display_0_dc");

    nn::visrv::settings::PhysicalDisplay display;
    display.Read(0);

    for( int i = 0; i < sizeof(display.name); ++i )
    {
        EXPECT_EQ(0, display.name[i]);
    }

    for( int i = 0; i < sizeof(display.edidDisplayName); ++i )
    {
        EXPECT_EQ(0, display.edidDisplayName[i]);
    }

    EXPECT_LT(display.dc, 0);
}

TEST_F(PhysicalDisplay, Read_DefaultEdidName)
{
    nnt::settings::WriteBuffer("Internal", "physical_display_0_name");
    nnt::settings::WriteValue(1, "physical_display_0_dc");

    nn::visrv::settings::PhysicalDisplay display;
    display.Read(0);

    EXPECT_STREQ("Internal", display.name);

    for( int i = 0; i < sizeof(display.edidDisplayName); ++i )
    {
        EXPECT_EQ(0, display.edidDisplayName[i]);
    }
}

TEST_F(PhysicalDisplay, Read_DefaultDc)
{
    nnt::settings::WriteBuffer("External", "physical_display_0_name");
    nnt::settings::WriteBuffer("Edid", "physical_display_0_edid_display_name");

    nn::visrv::settings::PhysicalDisplay display;
    display.Read(0);

    for( int i = 0; i < sizeof(display.name); ++i )
    {
        EXPECT_EQ(0, display.name[i]);
    }

    for( int i = 0; i < sizeof(display.edidDisplayName); ++i )
    {
        EXPECT_EQ(0, display.edidDisplayName[i]);
    }

    EXPECT_LT(display.dc, 0);
}

TEST_F(PhysicalDisplay, Read_InvalidDc)
{
    nnt::settings::WriteBuffer("External", "physical_display_0_name");
    nnt::settings::WriteBuffer("Edid", "physical_display_0_edid_display_name");
    nnt::settings::WriteValue(std::numeric_limits<decltype(nn::visrv::settings::PhysicalDisplay::dc)>::min(), "physical_display_0_dc");

    nn::visrv::settings::PhysicalDisplay display;
    display.Read(0);

    for( int i = 0; i < sizeof(display.name); ++i )
    {
        EXPECT_EQ(0, display.name[i]);
    }

    for( int i = 0; i < sizeof(display.edidDisplayName); ++i )
    {
        EXPECT_EQ(0, display.edidDisplayName[i]);
    }

    EXPECT_LT(display.dc, 0);
}
