﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture SetLayerSettingsDefaults;

TEST_F(SetLayerSettingsDefaults, Success_Any)
{
    nn::vi::Initialize();

    nn::vi::LayerSettings settings;
    nn::vi::SetLayerSettingsDefaults(&settings);

    EXPECT_TRUE(settings.Test<nn::vi::LayerFlags::Fullscreen>());
    // TODO: add opaque check
    // need to move to VI process
}

TEST(SetLayerSettingsDefaultsPreconditions, ViNotInitialized_Any)
{
    nn::vi::LayerSettings settings;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::SetLayerSettingsDefaults(&settings), "");
}

TEST(SetLayerSettingsDefaultsPreconditions, pOutSettingsNull_Any)
{
    nn::vi::Initialize();
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetLayerSettingsDefaults(nullptr), "");
    nn::vi::Finalize();
}
