﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture ListDisplayRgbRanges;

// TODO: Either allow nullptr or update documentation to include precondition
TEST_F(ListDisplayRgbRanges, DISABLED_pOutModesNull_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDefaultDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDefaultDisplay));

    nn::vi::Display* pExternalDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pExternalDisplay, "External"));

    nn::vi::Display* pEdidDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pEdidDisplay, "Edid"));

    EXPECT_EQ(0, nn::vi::ListDisplayRgbRanges(nullptr, 1, pDefaultDisplay));
    EXPECT_EQ(0, nn::vi::ListDisplayRgbRanges(nullptr, 1, pExternalDisplay));
    EXPECT_EQ(0, nn::vi::ListDisplayRgbRanges(nullptr, 1, pEdidDisplay));

    nn::vi::CloseDisplay(pEdidDisplay);
    nn::vi::CloseDisplay(pExternalDisplay);
    nn::vi::CloseDisplay(pDefaultDisplay);
}

TEST_F(ListDisplayRgbRanges, ZeroCount_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDefaultDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDefaultDisplay));

    nn::vi::Display* pExternalDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pExternalDisplay, "External"));

    nn::vi::Display* pEdidDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pEdidDisplay, "Edid"));

    nn::vi::RgbRange range = nn::vi::RgbRange_Max;

    EXPECT_EQ(0, nn::vi::ListDisplayRgbRanges(&range, 0, pDefaultDisplay));
    EXPECT_EQ(nn::vi::RgbRange_Max, range);

    EXPECT_EQ(0, nn::vi::ListDisplayRgbRanges(&range, 0, pExternalDisplay));
    EXPECT_EQ(nn::vi::RgbRange_Max, range);

    EXPECT_EQ(0, nn::vi::ListDisplayRgbRanges(&range, 0, pEdidDisplay));
    EXPECT_EQ(nn::vi::RgbRange_Max, range);

    nn::vi::CloseDisplay(pEdidDisplay);
    nn::vi::CloseDisplay(pExternalDisplay);
    nn::vi::CloseDisplay(pDefaultDisplay);
}

TEST_F(ListDisplayRgbRanges, Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
    int modeCount = nn::vi::ListDisplayRgbRanges(ranges, sizeof(ranges) / sizeof(ranges[0]), pDisplay);
    EXPECT_NE(0, modeCount);

    for( int i = 0; i < modeCount; ++i )
    {
        switch( ranges[i] )
        {
        case nn::vi::RgbRange_Limited:
            break;
        case nn::vi::RgbRange_Full:
            break;
        default:
            FAIL();
        }
    }

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(ListDisplayRgbRanges, External_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
    int modeCount = nn::vi::ListDisplayRgbRanges(ranges, sizeof(ranges) / sizeof(ranges[0]), pDisplay);
    EXPECT_NE(0, modeCount);

    for( int i = 0; i < modeCount; ++i )
    {
        switch( ranges[i] )
        {
        case nn::vi::RgbRange_Limited:
            break;
        case nn::vi::RgbRange_Full:
            break;
        default:
            FAIL();
        }
    }

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(ListDisplayRgbRanges, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
    int modeCount = nn::vi::ListDisplayRgbRanges(ranges, sizeof(ranges) / sizeof(ranges[0]), pDisplay);
    EXPECT_NE(0, modeCount);

    for( int i = 0; i < modeCount; ++i )
    {
        switch( ranges[i] )
        {
        case nn::vi::RgbRange_Limited:
            break;
        case nn::vi::RgbRange_Full:
            break;
        default:
            FAIL();
        }
    }

    nn::vi::CloseDisplay(pDisplay);
}

TEST(ListDisplayRgbRangesPreconditions, ViNotInitialized_Any)
{
    nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::ListDisplayRgbRanges(ranges, sizeof(ranges) / sizeof(ranges[0]), pDisplay), "");
}

TEST(ListDisplayRgbRangesPreconditions, NegativeCount_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::ListDisplayRgbRanges(ranges, -1, pDisplay), "");

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}

TEST(ListDisplayRgbRangesPreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::ListDisplayRgbRanges(ranges, sizeof(ranges) / sizeof(ranges[0]), nullptr), "");

    nn::vi::Finalize();
}

TEST(ListDisplayRgbRangesPreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);

        nn::vi::RgbRange ranges[nn::vi::RgbRange_Max];
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::ListDisplayRgbRanges(ranges, sizeof(ranges) / sizeof(ranges[0]), pDisplay), "");
    }

    nn::vi::Finalize();
}
