﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture GetDisplayCmuMode;

TEST_F(GetDisplayCmuMode, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    nn::vi::CmuMode mode;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::GetDisplayCmuMode(&mode, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST(GetDisplayCmuModePreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);
    nn::vi::CmuMode mode;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayCmuMode(&mode, pDisplay), "");
}

TEST(GetDisplayCmuModePreconditions, pOutModeNull_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayCmuMode(nullptr, pDisplay), "");

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}

TEST(GetDisplayCmuModePreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    nn::vi::CmuMode mode;
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayCmuMode(&mode, nullptr), "");

    nn::vi::Finalize();
}

TEST(GetDisplayCmuModePreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);

        nn::vi::CmuMode mode;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayCmuMode(&mode, pDisplay), "");
    }

    nn::vi::Finalize();
}
