﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.h>

typedef nnt::vi::util::Fixture GetNativeWindow;

TEST_F(GetNativeWindow, Success_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

    nn::vi::NativeWindowHandle window = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::GetNativeWindow(&window, pLayer));
    EXPECT_NE(nullptr, window);

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}

TEST(GetNativeWindowPreconditions, ViNotInitialized_Any)
{
    // need some non-null value to not trip other preconditions
    nn::vi::Layer* pLayer = reinterpret_cast<nn::vi::Layer*>(0x1234);

    nn::vi::NativeWindowHandle window;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetNativeWindow(&window, pLayer), "");
}

TEST(GetNativeWindowPreconditions, pLayerNull_Any)
{
    nn::vi::Initialize();

    nn::vi::NativeWindowHandle window;
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetNativeWindow(&window, nullptr), "");

    nn::vi::Finalize();
}

TEST(GetNativeWindowPreconditions, pLayerInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::Layer* pLayer = nullptr;
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

        if( pLayer != nullptr )
        {
            nn::vi::DestroyLayer(pLayer);

            nn::vi::NativeWindowHandle window;
            EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetNativeWindow(&window, pLayer), "");
        }

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}

TEST(GetNativeWindowPreconditions, pOutWindowNull_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::Layer* pLayer = nullptr;
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

        if( pLayer != nullptr )
        {
            EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetNativeWindow(nullptr, pLayer), "");

            nn::vi::DestroyLayer(pLayer);
        }

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}
