﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "PanelTextPreparationTask.h"

#include <nn/gfx/util/gfx_ObjectHolder.h>
#include "../framework/Framework.h"
#include "../framework/TextWriterPool.h"
#include "../framework/TexturePool.h"

#include <nvn/nvn_FuncPtrInline.h>

namespace panel{

    PanelTextPreparationTask::PanelTextPreparationTask(
        const std::shared_ptr<PanelText>& pPanel,
        float positionX,
        float positionY,
        float viewportWidth,
        float viewportHeight,
        float fontSize,
        const nn::util::Color4f& fontColor,
        const std::string& text
    ) NN_NOEXCEPT
        : m_pPanel(pPanel)
        , m_PositionX(positionX)
        , m_PositionY(positionY)
        , m_ViewportWidth(viewportWidth)
        , m_ViewportHeight(viewportHeight)
        , m_FontSize(fontSize)
        , m_FontColor(fontColor)
        , m_Text(text)
    {
    }

    PanelPreparationResult PanelTextPreparationTask::Prepare(nn::gfx::CommandBuffer* pCommandBuffer, int resourceLockIndex) NN_NOEXCEPT
    {
        NN_UNUSED(pCommandBuffer);
        auto p = m_pPanel.lock();
        if(!p)
        {
            return PanelPreparationResult_Canceled;
        }

        // TextWriter を取得
        auto pTextWriterHolder = Framework::AcquirePoolTextWriter();
        if(!pTextWriterHolder)
        {
            return PanelPreparationResult_NeedRetry;
        }

        auto pWriter = pTextWriterHolder->Get();
        pWriter->SetViewportSize(m_ViewportWidth, m_ViewportHeight);
        pWriter->SetPosition(m_PositionX, m_PositionY);
        pWriter->SetColor(m_FontColor);
        pWriter->SetFontSize(m_FontSize);
        pWriter->Print(m_Text.c_str());

        p->SetTextWriter(pTextWriterHolder);

        return PanelPreparationResult_Success;
    }

}
