﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi.h>
#include <nn/vi/detail/vi_SystemServiceProxy.private.h>

namespace framework{ namespace detail{

    class DisplayModule
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::vi::Layer* GetLayer() NN_NOEXCEPT;

    private:
        nn::vi::Display* m_pDisplay;
        nn::vi::Layer* m_pLayer;
    };

    extern DisplayModule g_DisplayModule;

#ifdef NNT_VI_FW_DISPLAY_SYSTEM_RAW
    extern nn::vi::detail::SystemServiceProxy g_DisplayProxy;
#endif

}}
