﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>

namespace framework{

    struct FrameTime
    {
        nn::os::Tick beginWindowAcquireTexture;
        nn::os::Tick endWindowAcquireTexture;

        nn::os::Tick beginFrameCommand;
        nn::os::Tick endFrameCommand;

        nn::os::Tick beginWaitWindowFence;
        nn::os::Tick endWaitWindowFence;

        nn::os::Tick beginWaitCommandFence;
        nn::os::Tick endWaitCommandFence;

        nn::os::Tick beginQueuePresentTexture;
        nn::os::Tick endQueuePresentTexture;

        nn::os::Tick beginWaitPresentFence;
        nn::os::Tick endWaitPresentFence;
    };

    void PrintFrameTime(const FrameTime& time) NN_NOEXCEPT
    {
        nn::os::Tick baseTick = time.endWaitWindowFence;
        float tickPerFrame = static_cast<float>(nn::os::GetSystemTickFrequency() / 60);

        {
            // ACQuire texture
            auto begFramePercent = static_cast<int>(static_cast<float>((time.beginWindowAcquireTexture - baseTick).GetInt64Value()) / tickPerFrame * 100);
            auto endFramePercent = static_cast<int>(static_cast<float>((time.endWindowAcquireTexture - baseTick).GetInt64Value()) / tickPerFrame * 100);
            NN_SDK_LOG("acq(%d-%d%%) ", begFramePercent, endFramePercent);
            NN_UNUSED(begFramePercent);
            NN_UNUSED(endFramePercent);
        }
        {
            // COMmand
            auto begFramePercent = static_cast<int>(static_cast<float>((time.beginFrameCommand - baseTick).GetInt64Value()) / tickPerFrame * 100);
            auto endFramePercent = static_cast<int>(static_cast<float>((time.endFrameCommand - baseTick).GetInt64Value()) / tickPerFrame * 100);
            NN_SDK_LOG("cmd(%d-%d%%) ", begFramePercent, endFramePercent);
            NN_UNUSED(begFramePercent);
            NN_UNUSED(endFramePercent);
        }
        {
            // Wait Window Fence
            auto begFramePercent = static_cast<int>(static_cast<float>((time.beginWaitWindowFence - baseTick).GetInt64Value()) / tickPerFrame * 100);
            auto endFramePercent = static_cast<int>(static_cast<float>((time.endWaitWindowFence - baseTick).GetInt64Value()) / tickPerFrame * 100);
            NN_SDK_LOG("wwf(%d-%d%%) ", begFramePercent, endFramePercent);
            NN_UNUSED(begFramePercent);
            NN_UNUSED(endFramePercent);
        }
        {
            // Wait Command Fence
            auto begFramePercent = static_cast<int>(static_cast<float>((time.beginWaitCommandFence - baseTick).GetInt64Value()) / tickPerFrame * 100);
            auto endFramePercent = static_cast<int>(static_cast<float>((time.endWaitCommandFence - baseTick).GetInt64Value()) / tickPerFrame * 100);
            NN_SDK_LOG("wcf(%d-%d%%) ", begFramePercent, endFramePercent);
            NN_UNUSED(begFramePercent);
            NN_UNUSED(endFramePercent);
        }
        {
            // Present texture
            auto begFramePercent = static_cast<int>(static_cast<float>((time.beginQueuePresentTexture - baseTick).GetInt64Value()) / tickPerFrame * 100);
            auto endFramePercent = static_cast<int>(static_cast<float>((time.endQueuePresentTexture - baseTick).GetInt64Value()) / tickPerFrame * 100);
            NN_SDK_LOG("pre(%d-%d%%) ", begFramePercent, endFramePercent);
            NN_UNUSED(begFramePercent);
            NN_UNUSED(endFramePercent);
        }
        {
            // Wait present fence
            auto begFramePercent = static_cast<int>(static_cast<float>((time.beginWaitPresentFence - baseTick).GetInt64Value()) / tickPerFrame * 100);
            auto endFramePercent = static_cast<int>(static_cast<float>((time.endWaitPresentFence - baseTick).GetInt64Value()) / tickPerFrame * 100);
            NN_SDK_LOG("wpf(%d-%d%%) ", begFramePercent, endFramePercent);
            NN_UNUSED(begFramePercent);
            NN_UNUSED(endFramePercent);
        }
        NN_SDK_LOG("\n");
    }

}
