﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testFixtures.h"

TEST_F(CurlTest, DISABLED_TftpOptionClaimTest)
{
    CURLcode result;

    result = curl_easy_setopt(cHandle, CURLOPT_TFTP_BLKSIZE, 512L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    // CURLOPT_TFTP_NO_OPTIONS is not available in this version (added in 7.48.0).
}

TEST_F(CurlTest, DISABLED_SmtpOptionClaimTest)
{
    CURLcode result;

    result = curl_easy_setopt(cHandle, CURLOPT_MAIL_FROM, "<admin@example.com>");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    curl_slist *recipients = nullptr;
    recipients = curl_slist_append(recipients, "<admin@example.com>");
    result = curl_easy_setopt(cHandle, CURLOPT_MAIL_RCPT, recipients);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
    curl_slist_free_all(recipients);

    result = curl_easy_setopt(cHandle, CURLOPT_MAIL_AUTH, "admin@example.com");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
}

TEST_F(CurlTest, DISABLED_RtspOptionClaimTest)
{
    CURLcode result;

    result = curl_easy_setopt(cHandle, CURLOPT_RTSP_REQUEST, CURL_RTSPREQ_OPTIONS);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_RTSP_SESSION_ID, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_RTSP_STREAM_URI, "*");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_RTSP_TRANSPORT, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_RTSP_CLIENT_CSEQ, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_RTSP_SERVER_CSEQ, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
}

int knownHostCallback(CURL *handle, const curl_khkey *knownkey, const curl_khkey *foundkey, curl_khmatch matchstatus, void *clientp)
{
    return CURLKHSTAT_FINE;
}

TEST_F(CurlTest, DISABLED_SshOptionClaimTest)
{
    CURLcode result;

    result = curl_easy_setopt(cHandle, CURLOPT_SSH_AUTH_TYPES, CURLSSH_AUTH_ANY);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSH_HOST_PUBLIC_KEY_MD5, "01234567890123456789012345678901");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSH_PUBLIC_KEYFILE, "public.key");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSH_PRIVATE_KEYFILE, "private.key");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSH_KNOWNHOSTS, "known.hosts");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSH_KEYFUNCTION, knownHostCallback);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSH_KEYDATA, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
}

TEST_F(CurlTest, DISABLED_FtpOptionClaimTest)
{
    CURLcode result;

    result = curl_easy_setopt(cHandle, CURLOPT_FTPPORT, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_QUOTE, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_POSTQUOTE, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_PREQUOTE, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_APPEND, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_USE_EPRT, 1L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_USE_EPSV, 1L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_USE_PRET, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_CREATE_MISSING_DIRS, CURLFTP_CREATE_DIR_NONE);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_RESPONSE_TIMEOUT, 30L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_ALTERNATIVE_TO_USER, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_SKIP_PASV_IP, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTPSSLAUTH, CURLFTPAUTH_DEFAULT);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_SSL_CCC, CURLFTPSSL_CCC_NONE);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_ACCOUNT, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FTP_FILEMETHOD, CURLFTPMETHOD_MULTICWD);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
}

TEST_F(CurlTest, DISABLED_TelnetOptionClaimTest)
{
    CURLcode result;

    result = curl_easy_setopt(cHandle, CURLOPT_TELNETOPTIONS, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
}

TEST_F(CurlTest, DISABLED_MiscUnsupportedOptionClaimTest)
{
    CURLcode result;

    // These options used for FTP
    result = curl_easy_setopt(cHandle, CURLOPT_WILDCARDMATCH, 1L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_CHUNK_BGN_FUNCTION, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_CHUNK_END_FUNCTION, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_CHUNK_DATA, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_ACCEPTTIMEOUT_MS, 60000L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_TRANSFERTEXT, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_PROXY_TRANSFER_MODE, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_DIRLISTONLY, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_KRBLEVEL, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FNMATCH_FUNCTION, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_FNMATCH_DATA, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    // These options used for RTSP
    result = curl_easy_setopt(cHandle, CURLOPT_INTERLEAVEFUNCTION, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_INTERLEAVEDATA, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    // These options used for mail protocols
    result = curl_easy_setopt(cHandle, CURLOPT_SASL_IR, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_XOAUTH2_BEARER, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_CONV_TO_NETWORK_FUNCTION, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_CONV_FROM_NETWORK_FUNCTION, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_LOGIN_OPTIONS, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_USE_SSL, CURLUSESSL_NONE);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    // These options used for file transfer protocols
    result = curl_easy_setopt(cHandle, CURLOPT_NEW_FILE_PERMS, 0644L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_NEW_DIRECTORY_PERMS, 0755L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    // These options used for IPv6
    result = curl_easy_setopt(cHandle, CURLOPT_ADDRESS_SCOPE, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_DNS_LOCAL_IP6, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    // These options used for HTTP/2 (Added in curl 7.46.0)
//  result = curl_easy_setopt(cHandle, CURLOPT_STREAM_DEPENDS, nullptr);
//  EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

//  result = curl_easy_setopt(cHandle, CURLOPT_STREAM_DEPENDS_E, nullptr);
//  EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

//  result = curl_easy_setopt(cHandle, CURLOPT_STREAM_WEIGHT, nullptr);
//  EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
}

TEST_F(CurlTest, DISABLED_FileAccessOptionClaimTest)
{
    // File access from libcurl is not supported on NX
    CURLcode result;

    result = curl_easy_setopt(cHandle, CURLOPT_STDERR, stderr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_NETRC, CURL_NETRC_IGNORED);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_NETRC_FILE, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_COOKIEFILE, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_COOKIEJAR, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSLCERT, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSLCERTTYPE, "PEM");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSLKEY, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSLKEYTYPE, "PEM");
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_KEYPASSWD, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_CAINFO, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_ISSUERCERT, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_CAPATH, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_RANDOM_FILE, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_CRLFILE, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
}

TEST_F(CurlTest, DISABLED_SslBackendOptionClaimTest)
{
    // These options are only supported with specific SSL backends
    CURLcode result;

    result = curl_easy_setopt(cHandle, CURLOPT_SSLENGINE, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSLENGINE_DEFAULT, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSL_FALSESTART, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_SSL_VERIFYSTATUS, 0L);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);

    result = curl_easy_setopt(cHandle, CURLOPT_PINNEDPUBLICKEY, nullptr);
    EXPECT_EQ(CURLE_NOT_BUILT_IN, result);
}
