<?php
	// Information about the file the agent wants to send us
	$requestSize = $_SERVER['CONTENT_LENGTH'];
	$requestFileType = $_SERVER['CONTENT_TYPE'];

	// Where does the user agent want us to put the data?
	$requestUrl = $_SERVER['REQUEST_URI']; // Where should it appear on the site?
	$requestFile = $_SERVER['PATH_TRANSLATED']; // Where should it live in the filesystem?
	$requestExtension = pathinfo($requestUrl, PATHINFO_EXTENSION);
	
	// Reject files that are too big
	if ($requestSize > 50 * 1024 * 1024)
	{
		http_response_code(417);
		return;
	}
	
	// Blacklist certain file types
	$blacklist = array("php");
	if (in_array(strtolower($requestExtension), $blacklist))
	{
		http_response_code(417);
		return;
	}
	
	// All checks passed, open the local file for writing
	$localCopy = fopen($requestFile, "wb");
	if (!$localCopy)
	{
		http_response_code(500);
		return;
	}
	
	// PUT entity data appears at stdin
	$putEntity = fopen("php://input", "rb");
	
	while ($data = fread($putEntity, 1024))
	{
		fwrite($localCopy, $data);
	}
	
	fclose($putEntity);
	fclose($localCopy);
	
	// Assemble metadata to return to user agent
	$metadata = array(
		"size" => $requestSize,
		"md5sum" => md5_file($requestFile)
	);
	
	header("Content-Type: application/json");
	print(json_encode($metadata, JSON_PRETTY_PRINT | JSON_FORCE_OBJECT | JSON_NUMERIC_CHECK) . "\n");
?>
