﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_ConsoleFrameworkOpenCv.h"
#include "test_TaskBase.h"
#include "test_Time.h"
#pragma warning(push)
#pragma warning(disable: 4668)
#include <opencv2/opencv.hpp>
#pragma warning(pop)

namespace test {

//============================================================
void ConsoleFrameworkOpenCv::DoInitialize()
{
    TEST_ASSERT(!m_IsInitialized);

    m_IsInitialized = true;
} //ConsoleFrameworkOpenCv::DoInitialize()

//============================================================
void ConsoleFrameworkOpenCv::DoFinalize()
{
    if (m_IsInitialized)
    {
        m_IsInitialized = false;
    }
} //ConsoleFrameworkOpenCv::DoFinalize()

//============================================================
void ConsoleFrameworkOpenCv::DoMainLoop()
{
    m_FrameCount  = 0;

    // 最初のフレームの Calc を実行しておき、
    // ループの中では、フレーム N の Draw、フレーム N+1 の Calc という順番で実行する。
    FrameworkBase::GetTask()->Calc();

    m_Keycode = 0;
    while (m_Keycode != 27)  // until Esc key is pushed
    {
        test::TickTime begTick;
        begTick.SetCurrentCpuTime();

        GetTask()->Draw();

        GetTask()->Calc();

        test::TickTime endTick;
        endTick.SetCurrentCpuTime();

        // cvShowImage は cvWaitKey などのイベントが入らないと表示されないので適当な時間待つ必要がある
        s32 elapsedMsec = static_cast<s32>((endTick - begTick).ToTimeSpan().GetMilliSeconds());
        s32 waitMsec = 8 - elapsedMsec;
        if (waitMsec < 2)  // cvWaitKey に 1 を指定しても表示されない
        {
            waitMsec = 8;
        }
        m_Keycode = cvWaitKey(waitMsec);
        m_FrameCount++;
    } //while
} //ConsoleFrameworkOpenCv::DoMainLoop()

//============================================================

} //namespace test
